from chardet.enums import CharacterCategory, SequenceLikelihood
from chardet.sbcharsetprober import SingleByteCharSetModel

FRENCH_LANG_MODEL = {
    29: {  # 'A'
        29: SequenceLikelihood.LIKELY,  # 'A'
        40: SequenceLikelihood.LIKELY,  # 'B'
        25: SequenceLikelihood.LIKELY,  # 'C'
        35: SequenceLikelihood.LIKELY,  # 'D'
        31: SequenceLikelihood.UNLIKELY,  # 'E'
        42: SequenceLikelihood.LIKELY,  # 'F'
        47: SequenceLikelihood.LIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.LIKELY,  # 'I'
        48: SequenceLikelihood.UNLIKELY,  # 'J'
        56: SequenceLikelihood.UNLIKELY,  # 'K'
        24: SequenceLikelihood.LIKELY,  # 'L'
        33: SequenceLikelihood.LIKELY,  # 'M'
        39: SequenceLikelihood.POSITIVE,  # 'N'
        43: SequenceLikelihood.UNLIKELY,  # 'O'
        32: SequenceLikelihood.LIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        38: SequenceLikelihood.POSITIVE,  # 'R'
        30: SequenceLikelihood.LIKELY,  # 'S'
        37: SequenceLikelihood.POSITIVE,  # 'T'
        46: SequenceLikelihood.LIKELY,  # 'U'
        45: SequenceLikelihood.LIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        61: SequenceLikelihood.UNLIKELY,  # 'X'
        60: SequenceLikelihood.UNLIKELY,  # 'Y'
        63: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.UNLIKELY,  # 'a'
        19: SequenceLikelihood.LIKELY,  # 'b'
        12: SequenceLikelihood.POSITIVE,  # 'c'
        11: SequenceLikelihood.LIKELY,  # 'd'
        1: SequenceLikelihood.UNLIKELY,  # 'e'
        17: SequenceLikelihood.LIKELY,  # 'f'
        18: SequenceLikelihood.LIKELY,  # 'g'
        20: SequenceLikelihood.LIKELY,  # 'h'
        5: SequenceLikelihood.POSITIVE,  # 'i'
        26: SequenceLikelihood.LIKELY,  # 'j'
        44: SequenceLikelihood.UNLIKELY,  # 'k'
        10: SequenceLikelihood.POSITIVE,  # 'l'
        14: SequenceLikelihood.POSITIVE,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        8: SequenceLikelihood.LIKELY,  # 'o'
        13: SequenceLikelihood.POSITIVE,  # 'p'
        21: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        2: SequenceLikelihood.POSITIVE,  # 's'
        6: SequenceLikelihood.LIKELY,  # 't'
        9: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.POSITIVE,  # 'v'
        49: SequenceLikelihood.UNLIKELY,  # 'w'
        23: SequenceLikelihood.UNLIKELY,  # 'x'
        27: SequenceLikelihood.UNLIKELY,  # 'y'
        34: SequenceLikelihood.LIKELY,  # 'z'
        66: SequenceLikelihood.NEGATIVE,  # 'À'
        73: SequenceLikelihood.UNLIKELY,  # 'Â'
        83: SequenceLikelihood.NEGATIVE,  # 'Æ'
        69: SequenceLikelihood.UNLIKELY,  # 'Ç'
        70: SequenceLikelihood.NEGATIVE,  # 'È'
        58: SequenceLikelihood.UNLIKELY,  # 'É'
        72: SequenceLikelihood.NEGATIVE,  # 'Ê'
        80: SequenceLikelihood.UNLIKELY,  # 'Ë'
        71: SequenceLikelihood.UNLIKELY,  # 'Î'
        77: SequenceLikelihood.UNLIKELY,  # 'Ï'
        74: SequenceLikelihood.UNLIKELY,  # 'Ô'
        82: SequenceLikelihood.NEGATIVE,  # 'Ù'
        79: SequenceLikelihood.NEGATIVE,  # 'Û'
        78: SequenceLikelihood.UNLIKELY,  # 'Ü'
        22: SequenceLikelihood.UNLIKELY,  # 'à'
        53: SequenceLikelihood.UNLIKELY,  # 'â'
        76: SequenceLikelihood.NEGATIVE,  # 'æ'
        51: SequenceLikelihood.UNLIKELY,  # 'ç'
        28: SequenceLikelihood.UNLIKELY,  # 'è'
        15: SequenceLikelihood.UNLIKELY,  # 'é'
        41: SequenceLikelihood.NEGATIVE,  # 'ê'
        67: SequenceLikelihood.UNLIKELY,  # 'ë'
        57: SequenceLikelihood.UNLIKELY,  # 'î'
        65: SequenceLikelihood.UNLIKELY,  # 'ï'
        52: SequenceLikelihood.UNLIKELY,  # 'ô'
        62: SequenceLikelihood.NEGATIVE,  # 'ù'
        59: SequenceLikelihood.UNLIKELY,  # 'û'
        68: SequenceLikelihood.NEGATIVE,  # 'ü'
        81: SequenceLikelihood.UNLIKELY,  # 'ÿ'
        75: SequenceLikelihood.NEGATIVE,  # 'Œ'
        64: SequenceLikelihood.NEGATIVE,  # 'œ'
        84: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
    },
    40: {  # 'B'
        29: SequenceLikelihood.LIKELY,  # 'A'
        40: SequenceLikelihood.UNLIKELY,  # 'B'
        25: SequenceLikelihood.LIKELY,  # 'C'
        35: SequenceLikelihood.LIKELY,  # 'D'
        31: SequenceLikelihood.LIKELY,  # 'E'
        42: SequenceLikelihood.UNLIKELY,  # 'F'
        47: SequenceLikelihood.UNLIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.LIKELY,  # 'I'
        48: SequenceLikelihood.UNLIKELY,  # 'J'
        56: SequenceLikelihood.UNLIKELY,  # 'K'
        24: SequenceLikelihood.LIKELY,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        43: SequenceLikelihood.LIKELY,  # 'O'
        32: SequenceLikelihood.UNLIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        38: SequenceLikelihood.LIKELY,  # 'R'
        30: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.LIKELY,  # 'T'
        46: SequenceLikelihood.UNLIKELY,  # 'U'
        45: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        61: SequenceLikelihood.UNLIKELY,  # 'X'
        60: SequenceLikelihood.UNLIKELY,  # 'Y'
        63: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        12: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        17: SequenceLikelihood.UNLIKELY,  # 'f'
        18: SequenceLikelihood.UNLIKELY,  # 'g'
        20: SequenceLikelihood.UNLIKELY,  # 'h'
        5: SequenceLikelihood.POSITIVE,  # 'i'
        26: SequenceLikelihood.UNLIKELY,  # 'j'
        44: SequenceLikelihood.UNLIKELY,  # 'k'
        10: SequenceLikelihood.POSITIVE,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        8: SequenceLikelihood.POSITIVE,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        21: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        2: SequenceLikelihood.UNLIKELY,  # 's'
        6: SequenceLikelihood.UNLIKELY,  # 't'
        9: SequenceLikelihood.LIKELY,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        49: SequenceLikelihood.UNLIKELY,  # 'w'
        23: SequenceLikelihood.UNLIKELY,  # 'x'
        27: SequenceLikelihood.UNLIKELY,  # 'y'
        34: SequenceLikelihood.UNLIKELY,  # 'z'
        66: SequenceLikelihood.NEGATIVE,  # 'À'
        73: SequenceLikelihood.UNLIKELY,  # 'Â'
        83: SequenceLikelihood.NEGATIVE,  # 'Æ'
        69: SequenceLikelihood.NEGATIVE,  # 'Ç'
        70: SequenceLikelihood.UNLIKELY,  # 'È'
        58: SequenceLikelihood.UNLIKELY,  # 'É'
        72: SequenceLikelihood.UNLIKELY,  # 'Ê'
        80: SequenceLikelihood.NEGATIVE,  # 'Ë'
        71: SequenceLikelihood.UNLIKELY,  # 'Î'
        77: SequenceLikelihood.NEGATIVE,  # 'Ï'
        74: SequenceLikelihood.UNLIKELY,  # 'Ô'
        82: SequenceLikelihood.NEGATIVE,  # 'Ù'
        79: SequenceLikelihood.NEGATIVE,  # 'Û'
        78: SequenceLikelihood.UNLIKELY,  # 'Ü'
        22: SequenceLikelihood.UNLIKELY,  # 'à'
        53: SequenceLikelihood.UNLIKELY,  # 'â'
        76: SequenceLikelihood.UNLIKELY,  # 'æ'
        51: SequenceLikelihood.NEGATIVE,  # 'ç'
        28: SequenceLikelihood.UNLIKELY,  # 'è'
        15: SequenceLikelihood.LIKELY,  # 'é'
        41: SequenceLikelihood.UNLIKELY,  # 'ê'
        67: SequenceLikelihood.UNLIKELY,  # 'ë'
        57: SequenceLikelihood.UNLIKELY,  # 'î'
        65: SequenceLikelihood.UNLIKELY,  # 'ï'
        52: SequenceLikelihood.UNLIKELY,  # 'ô'
        62: SequenceLikelihood.UNLIKELY,  # 'ù'
        59: SequenceLikelihood.UNLIKELY,  # 'û'
        68: SequenceLikelihood.UNLIKELY,  # 'ü'
        81: SequenceLikelihood.NEGATIVE,  # 'ÿ'
        75: SequenceLikelihood.UNLIKELY,  # 'Œ'
        64: SequenceLikelihood.UNLIKELY,  # 'œ'
        84: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
    },
    25: {  # 'C'
        29: SequenceLikelihood.LIKELY,  # 'A'
        40: SequenceLikelihood.UNLIKELY,  # 'B'
        25: SequenceLikelihood.LIKELY,  # 'C'
        35: SequenceLikelihood.LIKELY,  # 'D'
        31: SequenceLikelihood.LIKELY,  # 'E'
        42: SequenceLikelihood.LIKELY,  # 'F'
        47: SequenceLikelihood.LIKELY,  # 'G'
        50: SequenceLikelihood.LIKELY,  # 'H'
        36: SequenceLikelihood.LIKELY,  # 'I'
        48: SequenceLikelihood.UNLIKELY,  # 'J'
        56: SequenceLikelihood.UNLIKELY,  # 'K'
        24: SequenceLikelihood.LIKELY,  # 'L'
        33: SequenceLikelihood.LIKELY,  # 'M'
        39: SequenceLikelihood.LIKELY,  # 'N'
        43: SequenceLikelihood.POSITIVE,  # 'O'
        32: SequenceLikelihood.LIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        38: SequenceLikelihood.LIKELY,  # 'R'
        30: SequenceLikelihood.LIKELY,  # 'S'
        37: SequenceLikelihood.LIKELY,  # 'T'
        46: SequenceLikelihood.LIKELY,  # 'U'
        45: SequenceLikelihood.LIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        61: SequenceLikelihood.UNLIKELY,  # 'X'
        60: SequenceLikelihood.UNLIKELY,  # 'Y'
        63: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        12: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        17: SequenceLikelihood.UNLIKELY,  # 'f'
        18: SequenceLikelihood.UNLIKELY,  # 'g'
        20: SequenceLikelihood.POSITIVE,  # 'h'
        5: SequenceLikelihood.LIKELY,  # 'i'
        26: SequenceLikelihood.UNLIKELY,  # 'j'
        44: SequenceLikelihood.UNLIKELY,  # 'k'
        10: SequenceLikelihood.POSITIVE,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        8: SequenceLikelihood.POSITIVE,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        21: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        2: SequenceLikelihood.UNLIKELY,  # 's'
        6: SequenceLikelihood.UNLIKELY,  # 't'
        9: SequenceLikelihood.LIKELY,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        49: SequenceLikelihood.UNLIKELY,  # 'w'
        23: SequenceLikelihood.UNLIKELY,  # 'x'
        27: SequenceLikelihood.LIKELY,  # 'y'
        34: SequenceLikelihood.UNLIKELY,  # 'z'
        66: SequenceLikelihood.NEGATIVE,  # 'À'
        73: SequenceLikelihood.UNLIKELY,  # 'Â'
        83: SequenceLikelihood.NEGATIVE,  # 'Æ'
        69: SequenceLikelihood.NEGATIVE,  # 'Ç'
        70: SequenceLikelihood.UNLIKELY,  # 'È'
        58: SequenceLikelihood.UNLIKELY,  # 'É'
        72: SequenceLikelihood.UNLIKELY,  # 'Ê'
        80: SequenceLikelihood.NEGATIVE,  # 'Ë'
        71: SequenceLikelihood.UNLIKELY,  # 'Î'
        77: SequenceLikelihood.UNLIKELY,  # 'Ï'
        74: SequenceLikelihood.UNLIKELY,  # 'Ô'
        82: SequenceLikelihood.NEGATIVE,  # 'Ù'
        79: SequenceLikelihood.NEGATIVE,  # 'Û'
        78: SequenceLikelihood.NEGATIVE,  # 'Ü'
        22: SequenceLikelihood.UNLIKELY,  # 'à'
        53: SequenceLikelihood.UNLIKELY,  # 'â'
        76: SequenceLikelihood.UNLIKELY,  # 'æ'
        51: SequenceLikelihood.NEGATIVE,  # 'ç'
        28: SequenceLikelihood.UNLIKELY,  # 'è'
        15: SequenceLikelihood.LIKELY,  # 'é'
        41: SequenceLikelihood.NEGATIVE,  # 'ê'
        67: SequenceLikelihood.NEGATIVE,  # 'ë'
        57: SequenceLikelihood.UNLIKELY,  # 'î'
        65: SequenceLikelihood.NEGATIVE,  # 'ï'
        52: SequenceLikelihood.LIKELY,  # 'ô'
        62: SequenceLikelihood.NEGATIVE,  # 'ù'
        59: SequenceLikelihood.NEGATIVE,  # 'û'
        68: SequenceLikelihood.NEGATIVE,  # 'ü'
        81: SequenceLikelihood.NEGATIVE,  # 'ÿ'
        75: SequenceLikelihood.UNLIKELY,  # 'Œ'
        64: SequenceLikelihood.UNLIKELY,  # 'œ'
        84: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
    },
    35: {  # 'D'
        29: SequenceLikelihood.LIKELY,  # 'A'
        40: SequenceLikelihood.UNLIKELY,  # 'B'
        25: SequenceLikelihood.LIKELY,  # 'C'
        35: SequenceLikelihood.LIKELY,  # 'D'
        31: SequenceLikelihood.POSITIVE,  # 'E'
        42: SequenceLikelihood.LIKELY,  # 'F'
        47: SequenceLikelihood.UNLIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.LIKELY,  # 'I'
        48: SequenceLikelihood.UNLIKELY,  # 'J'
        56: SequenceLikelihood.UNLIKELY,  # 'K'
        24: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        43: SequenceLikelihood.LIKELY,  # 'O'
        32: SequenceLikelihood.UNLIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        38: SequenceLikelihood.LIKELY,  # 'R'
        30: SequenceLikelihood.LIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        46: SequenceLikelihood.LIKELY,  # 'U'
        45: SequenceLikelihood.LIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        61: SequenceLikelihood.UNLIKELY,  # 'X'
        60: SequenceLikelihood.UNLIKELY,  # 'Y'
        63: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        12: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        17: SequenceLikelihood.UNLIKELY,  # 'f'
        18: SequenceLikelihood.UNLIKELY,  # 'g'
        20: SequenceLikelihood.UNLIKELY,  # 'h'
        5: SequenceLikelihood.POSITIVE,  # 'i'
        26: SequenceLikelihood.UNLIKELY,  # 'j'
        44: SequenceLikelihood.UNLIKELY,  # 'k'
        10: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        8: SequenceLikelihood.POSITIVE,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        21: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.LIKELY,  # 'r'
        2: SequenceLikelihood.UNLIKELY,  # 's'
        6: SequenceLikelihood.UNLIKELY,  # 't'
        9: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        49: SequenceLikelihood.UNLIKELY,  # 'w'
        23: SequenceLikelihood.UNLIKELY,  # 'x'
        27: SequenceLikelihood.UNLIKELY,  # 'y'
        34: SequenceLikelihood.UNLIKELY,  # 'z'
        66: SequenceLikelihood.UNLIKELY,  # 'À'
        73: SequenceLikelihood.NEGATIVE,  # 'Â'
        83: SequenceLikelihood.NEGATIVE,  # 'Æ'
        69: SequenceLikelihood.NEGATIVE,  # 'Ç'
        70: SequenceLikelihood.UNLIKELY,  # 'È'
        58: SequenceLikelihood.UNLIKELY,  # 'É'
        72: SequenceLikelihood.NEGATIVE,  # 'Ê'
        80: SequenceLikelihood.NEGATIVE,  # 'Ë'
        71: SequenceLikelihood.UNLIKELY,  # 'Î'
        77: SequenceLikelihood.NEGATIVE,  # 'Ï'
        74: SequenceLikelihood.UNLIKELY,  # 'Ô'
        82: SequenceLikelihood.NEGATIVE,  # 'Ù'
        79: SequenceLikelihood.UNLIKELY,  # 'Û'
        78: SequenceLikelihood.UNLIKELY,  # 'Ü'
        22: SequenceLikelihood.UNLIKELY,  # 'à'
        53: SequenceLikelihood.UNLIKELY,  # 'â'
        76: SequenceLikelihood.NEGATIVE,  # 'æ'
        51: SequenceLikelihood.NEGATIVE,  # 'ç'
        28: SequenceLikelihood.LIKELY,  # 'è'
        15: SequenceLikelihood.POSITIVE,  # 'é'
        41: SequenceLikelihood.UNLIKELY,  # 'ê'
        67: SequenceLikelihood.NEGATIVE,  # 'ë'
        57: SequenceLikelihood.UNLIKELY,  # 'î'
        65: SequenceLikelihood.NEGATIVE,  # 'ï'
        52: SequenceLikelihood.UNLIKELY,  # 'ô'
        62: SequenceLikelihood.UNLIKELY,  # 'ù'
        59: SequenceLikelihood.UNLIKELY,  # 'û'
        68: SequenceLikelihood.UNLIKELY,  # 'ü'
        81: SequenceLikelihood.NEGATIVE,  # 'ÿ'
        75: SequenceLikelihood.NEGATIVE,  # 'Œ'
        64: SequenceLikelihood.UNLIKELY,  # 'œ'
        84: SequenceLikelihood.UNLIKELY,  # 'Ÿ'
    },
    31: {  # 'E'
        29: SequenceLikelihood.LIKELY,  # 'A'
        40: SequenceLikelihood.UNLIKELY,  # 'B'
        25: SequenceLikelihood.LIKELY,  # 'C'
        35: SequenceLikelihood.LIKELY,  # 'D'
        31: SequenceLikelihood.LIKELY,  # 'E'
        42: SequenceLikelihood.LIKELY,  # 'F'
        47: SequenceLikelihood.LIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.LIKELY,  # 'I'
        48: SequenceLikelihood.UNLIKELY,  # 'J'
        56: SequenceLikelihood.UNLIKELY,  # 'K'
        24: SequenceLikelihood.LIKELY,  # 'L'
        33: SequenceLikelihood.LIKELY,  # 'M'
        39: SequenceLikelihood.POSITIVE,  # 'N'
        43: SequenceLikelihood.LIKELY,  # 'O'
        32: SequenceLikelihood.LIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        38: SequenceLikelihood.POSITIVE,  # 'R'
        30: SequenceLikelihood.POSITIVE,  # 'S'
        37: SequenceLikelihood.LIKELY,  # 'T'
        46: SequenceLikelihood.LIKELY,  # 'U'
        45: SequenceLikelihood.LIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        61: SequenceLikelihood.LIKELY,  # 'X'
        60: SequenceLikelihood.UNLIKELY,  # 'Y'
        63: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.LIKELY,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        12: SequenceLikelihood.LIKELY,  # 'c'
        11: SequenceLikelihood.LIKELY,  # 'd'
        1: SequenceLikelihood.UNLIKELY,  # 'e'
        17: SequenceLikelihood.LIKELY,  # 'f'
        18: SequenceLikelihood.LIKELY,  # 'g'
        20: SequenceLikelihood.UNLIKELY,  # 'h'
        5: SequenceLikelihood.UNLIKELY,  # 'i'
        26: SequenceLikelihood.UNLIKELY,  # 'j'
        44: SequenceLikelihood.UNLIKELY,  # 'k'
        10: SequenceLikelihood.POSITIVE,  # 'l'
        14: SequenceLikelihood.LIKELY,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        8: SequenceLikelihood.UNLIKELY,  # 'o'
        13: SequenceLikelihood.LIKELY,  # 'p'
        21: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.LIKELY,  # 'r'
        2: SequenceLikelihood.POSITIVE,  # 's'
        6: SequenceLikelihood.POSITIVE,  # 't'
        9: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.LIKELY,  # 'v'
        49: SequenceLikelihood.UNLIKELY,  # 'w'
        23: SequenceLikelihood.POSITIVE,  # 'x'
        27: SequenceLikelihood.UNLIKELY,  # 'y'
        34: SequenceLikelihood.UNLIKELY,  # 'z'
        66: SequenceLikelihood.UNLIKELY,  # 'À'
        73: SequenceLikelihood.UNLIKELY,  # 'Â'
        83: SequenceLikelihood.NEGATIVE,  # 'Æ'
        69: SequenceLikelihood.UNLIKELY,  # 'Ç'
        70: SequenceLikelihood.NEGATIVE,  # 'È'
        58: SequenceLikelihood.UNLIKELY,  # 'É'
        72: SequenceLikelihood.NEGATIVE,  # 'Ê'
        80: SequenceLikelihood.NEGATIVE,  # 'Ë'
        71: SequenceLikelihood.NEGATIVE,  # 'Î'
        77: SequenceLikelihood.UNLIKELY,  # 'Ï'
        74: SequenceLikelihood.UNLIKELY,  # 'Ô'
        82: SequenceLikelihood.NEGATIVE,  # 'Ù'
        79: SequenceLikelihood.UNLIKELY,  # 'Û'
        78: SequenceLikelihood.NEGATIVE,  # 'Ü'
        22: SequenceLikelihood.UNLIKELY,  # 'à'
        53: SequenceLikelihood.NEGATIVE,  # 'â'
        76: SequenceLikelihood.NEGATIVE,  # 'æ'
        51: SequenceLikelihood.UNLIKELY,  # 'ç'
        28: SequenceLikelihood.NEGATIVE,  # 'è'
        15: SequenceLikelihood.UNLIKELY,  # 'é'
        41: SequenceLikelihood.UNLIKELY,  # 'ê'
        67: SequenceLikelihood.NEGATIVE,  # 'ë'
        57: SequenceLikelihood.NEGATIVE,  # 'î'
        65: SequenceLikelihood.NEGATIVE,  # 'ï'
        52: SequenceLikelihood.NEGATIVE,  # 'ô'
        62: SequenceLikelihood.NEGATIVE,  # 'ù'
        59: SequenceLikelihood.NEGATIVE,  # 'û'
        68: SequenceLikelihood.NEGATIVE,  # 'ü'
        81: SequenceLikelihood.NEGATIVE,  # 'ÿ'
        75: SequenceLikelihood.NEGATIVE,  # 'Œ'
        64: SequenceLikelihood.NEGATIVE,  # 'œ'
        84: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
    },
    42: {  # 'F'
        29: SequenceLikelihood.LIKELY,  # 'A'
        40: SequenceLikelihood.UNLIKELY,  # 'B'
        25: SequenceLikelihood.LIKELY,  # 'C'
        35: SequenceLikelihood.UNLIKELY,  # 'D'
        31: SequenceLikelihood.LIKELY,  # 'E'
        42: SequenceLikelihood.LIKELY,  # 'F'
        47: SequenceLikelihood.UNLIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.LIKELY,  # 'I'
        48: SequenceLikelihood.UNLIKELY,  # 'J'
        56: SequenceLikelihood.UNLIKELY,  # 'K'
        24: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        43: SequenceLikelihood.LIKELY,  # 'O'
        32: SequenceLikelihood.LIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        38: SequenceLikelihood.LIKELY,  # 'R'
        30: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        46: SequenceLikelihood.UNLIKELY,  # 'U'
        45: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        61: SequenceLikelihood.UNLIKELY,  # 'X'
        60: SequenceLikelihood.UNLIKELY,  # 'Y'
        63: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        12: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        17: SequenceLikelihood.UNLIKELY,  # 'f'
        18: SequenceLikelihood.UNLIKELY,  # 'g'
        20: SequenceLikelihood.UNLIKELY,  # 'h'
        5: SequenceLikelihood.POSITIVE,  # 'i'
        26: SequenceLikelihood.UNLIKELY,  # 'j'
        44: SequenceLikelihood.UNLIKELY,  # 'k'
        10: SequenceLikelihood.LIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        8: SequenceLikelihood.POSITIVE,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        21: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        2: SequenceLikelihood.UNLIKELY,  # 's'
        6: SequenceLikelihood.UNLIKELY,  # 't'
        9: SequenceLikelihood.LIKELY,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        49: SequenceLikelihood.UNLIKELY,  # 'w'
        23: SequenceLikelihood.UNLIKELY,  # 'x'
        27: SequenceLikelihood.UNLIKELY,  # 'y'
        34: SequenceLikelihood.UNLIKELY,  # 'z'
        66: SequenceLikelihood.NEGATIVE,  # 'À'
        73: SequenceLikelihood.NEGATIVE,  # 'Â'
        83: SequenceLikelihood.NEGATIVE,  # 'Æ'
        69: SequenceLikelihood.NEGATIVE,  # 'Ç'
        70: SequenceLikelihood.UNLIKELY,  # 'È'
        58: SequenceLikelihood.UNLIKELY,  # 'É'
        72: SequenceLikelihood.UNLIKELY,  # 'Ê'
        80: SequenceLikelihood.NEGATIVE,  # 'Ë'
        71: SequenceLikelihood.NEGATIVE,  # 'Î'
        77: SequenceLikelihood.NEGATIVE,  # 'Ï'
        74: SequenceLikelihood.UNLIKELY,  # 'Ô'
        82: SequenceLikelihood.NEGATIVE,  # 'Ù'
        79: SequenceLikelihood.UNLIKELY,  # 'Û'
        78: SequenceLikelihood.UNLIKELY,  # 'Ü'
        22: SequenceLikelihood.UNLIKELY,  # 'à'
        53: SequenceLikelihood.UNLIKELY,  # 'â'
        76: SequenceLikelihood.UNLIKELY,  # 'æ'
        51: SequenceLikelihood.NEGATIVE,  # 'ç'
        28: SequenceLikelihood.UNLIKELY,  # 'è'
        15: SequenceLikelihood.LIKELY,  # 'é'
        41: SequenceLikelihood.UNLIKELY,  # 'ê'
        67: SequenceLikelihood.UNLIKELY,  # 'ë'
        57: SequenceLikelihood.NEGATIVE,  # 'î'
        65: SequenceLikelihood.UNLIKELY,  # 'ï'
        52: SequenceLikelihood.UNLIKELY,  # 'ô'
        62: SequenceLikelihood.NEGATIVE,  # 'ù'
        59: SequenceLikelihood.UNLIKELY,  # 'û'
        68: SequenceLikelihood.UNLIKELY,  # 'ü'
        81: SequenceLikelihood.NEGATIVE,  # 'ÿ'
        75: SequenceLikelihood.NEGATIVE,  # 'Œ'
        64: SequenceLikelihood.UNLIKELY,  # 'œ'
        84: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
    },
    47: {  # 'G'
        29: SequenceLikelihood.LIKELY,  # 'A'
        40: SequenceLikelihood.UNLIKELY,  # 'B'
        25: SequenceLikelihood.UNLIKELY,  # 'C'
        35: SequenceLikelihood.UNLIKELY,  # 'D'
        31: SequenceLikelihood.LIKELY,  # 'E'
        42: SequenceLikelihood.UNLIKELY,  # 'F'
        47: SequenceLikelihood.UNLIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.LIKELY,  # 'I'
        48: SequenceLikelihood.UNLIKELY,  # 'J'
        56: SequenceLikelihood.UNLIKELY,  # 'K'
        24: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.LIKELY,  # 'N'
        43: SequenceLikelihood.LIKELY,  # 'O'
        32: SequenceLikelihood.LIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        38: SequenceLikelihood.LIKELY,  # 'R'
        30: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.LIKELY,  # 'T'
        46: SequenceLikelihood.LIKELY,  # 'U'
        45: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        61: SequenceLikelihood.UNLIKELY,  # 'X'
        60: SequenceLikelihood.UNLIKELY,  # 'Y'
        63: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        12: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        17: SequenceLikelihood.UNLIKELY,  # 'f'
        18: SequenceLikelihood.UNLIKELY,  # 'g'
        20: SequenceLikelihood.UNLIKELY,  # 'h'
        5: SequenceLikelihood.LIKELY,  # 'i'
        26: SequenceLikelihood.UNLIKELY,  # 'j'
        44: SequenceLikelihood.UNLIKELY,  # 'k'
        10: SequenceLikelihood.LIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        8: SequenceLikelihood.POSITIVE,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        21: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        2: SequenceLikelihood.UNLIKELY,  # 's'
        6: SequenceLikelihood.UNLIKELY,  # 't'
        9: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        49: SequenceLikelihood.UNLIKELY,  # 'w'
        23: SequenceLikelihood.UNLIKELY,  # 'x'
        27: SequenceLikelihood.UNLIKELY,  # 'y'
        34: SequenceLikelihood.UNLIKELY,  # 'z'
        66: SequenceLikelihood.UNLIKELY,  # 'À'
        73: SequenceLikelihood.UNLIKELY,  # 'Â'
        83: SequenceLikelihood.NEGATIVE,  # 'Æ'
        69: SequenceLikelihood.NEGATIVE,  # 'Ç'
        70: SequenceLikelihood.UNLIKELY,  # 'È'
        58: SequenceLikelihood.UNLIKELY,  # 'É'
        72: SequenceLikelihood.UNLIKELY,  # 'Ê'
        80: SequenceLikelihood.UNLIKELY,  # 'Ë'
        71: SequenceLikelihood.UNLIKELY,  # 'Î'
        77: SequenceLikelihood.NEGATIVE,  # 'Ï'
        74: SequenceLikelihood.NEGATIVE,  # 'Ô'
        82: SequenceLikelihood.NEGATIVE,  # 'Ù'
        79: SequenceLikelihood.NEGATIVE,  # 'Û'
        78: SequenceLikelihood.UNLIKELY,  # 'Ü'
        22: SequenceLikelihood.UNLIKELY,  # 'à'
        53: SequenceLikelihood.UNLIKELY,  # 'â'
        76: SequenceLikelihood.UNLIKELY,  # 'æ'
        51: SequenceLikelihood.NEGATIVE,  # 'ç'
        28: SequenceLikelihood.UNLIKELY,  # 'è'
        15: SequenceLikelihood.LIKELY,  # 'é'
        41: SequenceLikelihood.UNLIKELY,  # 'ê'
        67: SequenceLikelihood.UNLIKELY,  # 'ë'
        57: SequenceLikelihood.UNLIKELY,  # 'î'
        65: SequenceLikelihood.UNLIKELY,  # 'ï'
        52: SequenceLikelihood.UNLIKELY,  # 'ô'
        62: SequenceLikelihood.NEGATIVE,  # 'ù'
        59: SequenceLikelihood.NEGATIVE,  # 'û'
        68: SequenceLikelihood.UNLIKELY,  # 'ü'
        81: SequenceLikelihood.NEGATIVE,  # 'ÿ'
        75: SequenceLikelihood.NEGATIVE,  # 'Œ'
        64: SequenceLikelihood.UNLIKELY,  # 'œ'
        84: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
    },
    50: {  # 'H'
        29: SequenceLikelihood.LIKELY,  # 'A'
        40: SequenceLikelihood.UNLIKELY,  # 'B'
        25: SequenceLikelihood.UNLIKELY,  # 'C'
        35: SequenceLikelihood.LIKELY,  # 'D'
        31: SequenceLikelihood.LIKELY,  # 'E'
        42: SequenceLikelihood.UNLIKELY,  # 'F'
        47: SequenceLikelihood.UNLIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.LIKELY,  # 'I'
        48: SequenceLikelihood.UNLIKELY,  # 'J'
        56: SequenceLikelihood.UNLIKELY,  # 'K'
        24: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        43: SequenceLikelihood.LIKELY,  # 'O'
        32: SequenceLikelihood.UNLIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        38: SequenceLikelihood.UNLIKELY,  # 'R'
        30: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.LIKELY,  # 'T'
        46: SequenceLikelihood.UNLIKELY,  # 'U'
        45: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        61: SequenceLikelihood.UNLIKELY,  # 'X'
        60: SequenceLikelihood.UNLIKELY,  # 'Y'
        63: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        12: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        17: SequenceLikelihood.UNLIKELY,  # 'f'
        18: SequenceLikelihood.UNLIKELY,  # 'g'
        20: SequenceLikelihood.UNLIKELY,  # 'h'
        5: SequenceLikelihood.LIKELY,  # 'i'
        26: SequenceLikelihood.UNLIKELY,  # 'j'
        44: SequenceLikelihood.UNLIKELY,  # 'k'
        10: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        8: SequenceLikelihood.POSITIVE,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        21: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        2: SequenceLikelihood.UNLIKELY,  # 's'
        6: SequenceLikelihood.UNLIKELY,  # 't'
        9: SequenceLikelihood.LIKELY,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        49: SequenceLikelihood.UNLIKELY,  # 'w'
        23: SequenceLikelihood.UNLIKELY,  # 'x'
        27: SequenceLikelihood.LIKELY,  # 'y'
        34: SequenceLikelihood.UNLIKELY,  # 'z'
        66: SequenceLikelihood.NEGATIVE,  # 'À'
        73: SequenceLikelihood.UNLIKELY,  # 'Â'
        83: SequenceLikelihood.NEGATIVE,  # 'Æ'
        69: SequenceLikelihood.NEGATIVE,  # 'Ç'
        70: SequenceLikelihood.UNLIKELY,  # 'È'
        58: SequenceLikelihood.UNLIKELY,  # 'É'
        72: SequenceLikelihood.UNLIKELY,  # 'Ê'
        80: SequenceLikelihood.NEGATIVE,  # 'Ë'
        71: SequenceLikelihood.NEGATIVE,  # 'Î'
        77: SequenceLikelihood.NEGATIVE,  # 'Ï'
        74: SequenceLikelihood.UNLIKELY,  # 'Ô'
        82: SequenceLikelihood.NEGATIVE,  # 'Ù'
        79: SequenceLikelihood.NEGATIVE,  # 'Û'
        78: SequenceLikelihood.UNLIKELY,  # 'Ü'
        22: SequenceLikelihood.UNLIKELY,  # 'à'
        53: SequenceLikelihood.UNLIKELY,  # 'â'
        76: SequenceLikelihood.NEGATIVE,  # 'æ'
        51: SequenceLikelihood.NEGATIVE,  # 'ç'
        28: SequenceLikelihood.UNLIKELY,  # 'è'
        15: SequenceLikelihood.LIKELY,  # 'é'
        41: SequenceLikelihood.UNLIKELY,  # 'ê'
        67: SequenceLikelihood.UNLIKELY,  # 'ë'
        57: SequenceLikelihood.NEGATIVE,  # 'î'
        65: SequenceLikelihood.NEGATIVE,  # 'ï'
        52: SequenceLikelihood.LIKELY,  # 'ô'
        62: SequenceLikelihood.UNLIKELY,  # 'ù'
        59: SequenceLikelihood.UNLIKELY,  # 'û'
        68: SequenceLikelihood.UNLIKELY,  # 'ü'
        81: SequenceLikelihood.NEGATIVE,  # 'ÿ'
        75: SequenceLikelihood.NEGATIVE,  # 'Œ'
        64: SequenceLikelihood.UNLIKELY,  # 'œ'
        84: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
    },
    36: {  # 'I'
        29: SequenceLikelihood.LIKELY,  # 'A'
        40: SequenceLikelihood.LIKELY,  # 'B'
        25: SequenceLikelihood.LIKELY,  # 'C'
        35: SequenceLikelihood.LIKELY,  # 'D'
        31: SequenceLikelihood.LIKELY,  # 'E'
        42: SequenceLikelihood.LIKELY,  # 'F'
        47: SequenceLikelihood.LIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.LIKELY,  # 'I'
        48: SequenceLikelihood.UNLIKELY,  # 'J'
        56: SequenceLikelihood.UNLIKELY,  # 'K'
        24: SequenceLikelihood.LIKELY,  # 'L'
        33: SequenceLikelihood.LIKELY,  # 'M'
        39: SequenceLikelihood.POSITIVE,  # 'N'
        43: SequenceLikelihood.LIKELY,  # 'O'
        32: SequenceLikelihood.LIKELY,  # 'P'
        55: SequenceLikelihood.LIKELY,  # 'Q'
        38: SequenceLikelihood.LIKELY,  # 'R'
        30: SequenceLikelihood.POSITIVE,  # 'S'
        37: SequenceLikelihood.LIKELY,  # 'T'
        46: SequenceLikelihood.UNLIKELY,  # 'U'
        45: SequenceLikelihood.LIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        61: SequenceLikelihood.LIKELY,  # 'X'
        60: SequenceLikelihood.UNLIKELY,  # 'Y'
        63: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.UNLIKELY,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        12: SequenceLikelihood.LIKELY,  # 'c'
        11: SequenceLikelihood.LIKELY,  # 'd'
        1: SequenceLikelihood.LIKELY,  # 'e'
        17: SequenceLikelihood.UNLIKELY,  # 'f'
        18: SequenceLikelihood.UNLIKELY,  # 'g'
        20: SequenceLikelihood.UNLIKELY,  # 'h'
        5: SequenceLikelihood.UNLIKELY,  # 'i'
        26: SequenceLikelihood.UNLIKELY,  # 'j'
        44: SequenceLikelihood.UNLIKELY,  # 'k'
        10: SequenceLikelihood.POSITIVE,  # 'l'
        14: SequenceLikelihood.LIKELY,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        8: SequenceLikelihood.UNLIKELY,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        21: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.LIKELY,  # 'r'
        2: SequenceLikelihood.LIKELY,  # 's'
        6: SequenceLikelihood.LIKELY,  # 't'
        9: SequenceLikelihood.UNLIKELY,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        49: SequenceLikelihood.UNLIKELY,  # 'w'
        23: SequenceLikelihood.UNLIKELY,  # 'x'
        27: SequenceLikelihood.UNLIKELY,  # 'y'
        34: SequenceLikelihood.UNLIKELY,  # 'z'
        66: SequenceLikelihood.NEGATIVE,  # 'À'
        73: SequenceLikelihood.NEGATIVE,  # 'Â'
        83: SequenceLikelihood.NEGATIVE,  # 'Æ'
        69: SequenceLikelihood.UNLIKELY,  # 'Ç'
        70: SequenceLikelihood.UNLIKELY,  # 'È'
        58: SequenceLikelihood.UNLIKELY,  # 'É'
        72: SequenceLikelihood.NEGATIVE,  # 'Ê'
        80: SequenceLikelihood.NEGATIVE,  # 'Ë'
        71: SequenceLikelihood.NEGATIVE,  # 'Î'
        77: SequenceLikelihood.NEGATIVE,  # 'Ï'
        74: SequenceLikelihood.NEGATIVE,  # 'Ô'
        82: SequenceLikelihood.UNLIKELY,  # 'Ù'
        79: SequenceLikelihood.NEGATIVE,  # 'Û'
        78: SequenceLikelihood.NEGATIVE,  # 'Ü'
        22: SequenceLikelihood.NEGATIVE,  # 'à'
        53: SequenceLikelihood.NEGATIVE,  # 'â'
        76: SequenceLikelihood.NEGATIVE,  # 'æ'
        51: SequenceLikelihood.UNLIKELY,  # 'ç'
        28: SequenceLikelihood.UNLIKELY,  # 'è'
        15: SequenceLikelihood.UNLIKELY,  # 'é'
        41: SequenceLikelihood.NEGATIVE,  # 'ê'
        67: SequenceLikelihood.NEGATIVE,  # 'ë'
        57: SequenceLikelihood.NEGATIVE,  # 'î'
        65: SequenceLikelihood.NEGATIVE,  # 'ï'
        52: SequenceLikelihood.NEGATIVE,  # 'ô'
        62: SequenceLikelihood.NEGATIVE,  # 'ù'
        59: SequenceLikelihood.NEGATIVE,  # 'û'
        68: SequenceLikelihood.NEGATIVE,  # 'ü'
        81: SequenceLikelihood.NEGATIVE,  # 'ÿ'
        75: SequenceLikelihood.UNLIKELY,  # 'Œ'
        64: SequenceLikelihood.NEGATIVE,  # 'œ'
        84: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
    },
    48: {  # 'J'
        29: SequenceLikelihood.UNLIKELY,  # 'A'
        40: SequenceLikelihood.UNLIKELY,  # 'B'
        25: SequenceLikelihood.UNLIKELY,  # 'C'
        35: SequenceLikelihood.UNLIKELY,  # 'D'
        31: SequenceLikelihood.LIKELY,  # 'E'
        42: SequenceLikelihood.UNLIKELY,  # 'F'
        47: SequenceLikelihood.UNLIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        48: SequenceLikelihood.UNLIKELY,  # 'J'
        56: SequenceLikelihood.UNLIKELY,  # 'K'
        24: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        43: SequenceLikelihood.LIKELY,  # 'O'
        32: SequenceLikelihood.UNLIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        38: SequenceLikelihood.UNLIKELY,  # 'R'
        30: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        46: SequenceLikelihood.UNLIKELY,  # 'U'
        45: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        61: SequenceLikelihood.UNLIKELY,  # 'X'
        60: SequenceLikelihood.UNLIKELY,  # 'Y'
        63: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        12: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        17: SequenceLikelihood.UNLIKELY,  # 'f'
        18: SequenceLikelihood.UNLIKELY,  # 'g'
        20: SequenceLikelihood.UNLIKELY,  # 'h'
        5: SequenceLikelihood.UNLIKELY,  # 'i'
        26: SequenceLikelihood.UNLIKELY,  # 'j'
        44: SequenceLikelihood.UNLIKELY,  # 'k'
        10: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        8: SequenceLikelihood.POSITIVE,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        21: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        2: SequenceLikelihood.UNLIKELY,  # 's'
        6: SequenceLikelihood.UNLIKELY,  # 't'
        9: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        49: SequenceLikelihood.UNLIKELY,  # 'w'
        23: SequenceLikelihood.UNLIKELY,  # 'x'
        27: SequenceLikelihood.UNLIKELY,  # 'y'
        34: SequenceLikelihood.UNLIKELY,  # 'z'
        66: SequenceLikelihood.UNLIKELY,  # 'À'
        73: SequenceLikelihood.NEGATIVE,  # 'Â'
        83: SequenceLikelihood.NEGATIVE,  # 'Æ'
        69: SequenceLikelihood.NEGATIVE,  # 'Ç'
        70: SequenceLikelihood.NEGATIVE,  # 'È'
        58: SequenceLikelihood.UNLIKELY,  # 'É'
        72: SequenceLikelihood.NEGATIVE,  # 'Ê'
        80: SequenceLikelihood.NEGATIVE,  # 'Ë'
        71: SequenceLikelihood.UNLIKELY,  # 'Î'
        77: SequenceLikelihood.NEGATIVE,  # 'Ï'
        74: SequenceLikelihood.UNLIKELY,  # 'Ô'
        82: SequenceLikelihood.NEGATIVE,  # 'Ù'
        79: SequenceLikelihood.NEGATIVE,  # 'Û'
        78: SequenceLikelihood.UNLIKELY,  # 'Ü'
        22: SequenceLikelihood.UNLIKELY,  # 'à'
        53: SequenceLikelihood.UNLIKELY,  # 'â'
        76: SequenceLikelihood.UNLIKELY,  # 'æ'
        51: SequenceLikelihood.NEGATIVE,  # 'ç'
        28: SequenceLikelihood.UNLIKELY,  # 'è'
        15: SequenceLikelihood.LIKELY,  # 'é'
        41: SequenceLikelihood.NEGATIVE,  # 'ê'
        67: SequenceLikelihood.UNLIKELY,  # 'ë'
        57: SequenceLikelihood.NEGATIVE,  # 'î'
        65: SequenceLikelihood.NEGATIVE,  # 'ï'
        52: SequenceLikelihood.UNLIKELY,  # 'ô'
        62: SequenceLikelihood.NEGATIVE,  # 'ù'
        59: SequenceLikelihood.UNLIKELY,  # 'û'
        68: SequenceLikelihood.UNLIKELY,  # 'ü'
        81: SequenceLikelihood.NEGATIVE,  # 'ÿ'
        75: SequenceLikelihood.NEGATIVE,  # 'Œ'
        64: SequenceLikelihood.UNLIKELY,  # 'œ'
        84: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
    },
    56: {  # 'K'
        29: SequenceLikelihood.UNLIKELY,  # 'A'
        40: SequenceLikelihood.UNLIKELY,  # 'B'
        25: SequenceLikelihood.UNLIKELY,  # 'C'
        35: SequenceLikelihood.UNLIKELY,  # 'D'
        31: SequenceLikelihood.UNLIKELY,  # 'E'
        42: SequenceLikelihood.UNLIKELY,  # 'F'
        47: SequenceLikelihood.UNLIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        48: SequenceLikelihood.UNLIKELY,  # 'J'
        56: SequenceLikelihood.UNLIKELY,  # 'K'
        24: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        43: SequenceLikelihood.UNLIKELY,  # 'O'
        32: SequenceLikelihood.UNLIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        38: SequenceLikelihood.UNLIKELY,  # 'R'
        30: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        46: SequenceLikelihood.UNLIKELY,  # 'U'
        45: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        61: SequenceLikelihood.UNLIKELY,  # 'X'
        60: SequenceLikelihood.UNLIKELY,  # 'Y'
        63: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.LIKELY,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        12: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.LIKELY,  # 'e'
        17: SequenceLikelihood.UNLIKELY,  # 'f'
        18: SequenceLikelihood.UNLIKELY,  # 'g'
        20: SequenceLikelihood.LIKELY,  # 'h'
        5: SequenceLikelihood.LIKELY,  # 'i'
        26: SequenceLikelihood.UNLIKELY,  # 'j'
        44: SequenceLikelihood.UNLIKELY,  # 'k'
        10: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        8: SequenceLikelihood.LIKELY,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        21: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.LIKELY,  # 'r'
        2: SequenceLikelihood.UNLIKELY,  # 's'
        6: SequenceLikelihood.UNLIKELY,  # 't'
        9: SequenceLikelihood.LIKELY,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        49: SequenceLikelihood.UNLIKELY,  # 'w'
        23: SequenceLikelihood.UNLIKELY,  # 'x'
        27: SequenceLikelihood.UNLIKELY,  # 'y'
        34: SequenceLikelihood.UNLIKELY,  # 'z'
        66: SequenceLikelihood.UNLIKELY,  # 'À'
        73: SequenceLikelihood.NEGATIVE,  # 'Â'
        83: SequenceLikelihood.NEGATIVE,  # 'Æ'
        69: SequenceLikelihood.NEGATIVE,  # 'Ç'
        70: SequenceLikelihood.NEGATIVE,  # 'È'
        58: SequenceLikelihood.UNLIKELY,  # 'É'
        72: SequenceLikelihood.NEGATIVE,  # 'Ê'
        80: SequenceLikelihood.NEGATIVE,  # 'Ë'
        71: SequenceLikelihood.UNLIKELY,  # 'Î'
        77: SequenceLikelihood.NEGATIVE,  # 'Ï'
        74: SequenceLikelihood.UNLIKELY,  # 'Ô'
        82: SequenceLikelihood.NEGATIVE,  # 'Ù'
        79: SequenceLikelihood.NEGATIVE,  # 'Û'
        78: SequenceLikelihood.UNLIKELY,  # 'Ü'
        22: SequenceLikelihood.UNLIKELY,  # 'à'
        53: SequenceLikelihood.UNLIKELY,  # 'â'
        76: SequenceLikelihood.NEGATIVE,  # 'æ'
        51: SequenceLikelihood.NEGATIVE,  # 'ç'
        28: SequenceLikelihood.UNLIKELY,  # 'è'
        15: SequenceLikelihood.UNLIKELY,  # 'é'
        41: SequenceLikelihood.UNLIKELY,  # 'ê'
        67: SequenceLikelihood.NEGATIVE,  # 'ë'
        57: SequenceLikelihood.NEGATIVE,  # 'î'
        65: SequenceLikelihood.UNLIKELY,  # 'ï'
        52: SequenceLikelihood.UNLIKELY,  # 'ô'
        62: SequenceLikelihood.NEGATIVE,  # 'ù'
        59: SequenceLikelihood.UNLIKELY,  # 'û'
        68: SequenceLikelihood.UNLIKELY,  # 'ü'
        81: SequenceLikelihood.NEGATIVE,  # 'ÿ'
        75: SequenceLikelihood.NEGATIVE,  # 'Œ'
        64: SequenceLikelihood.UNLIKELY,  # 'œ'
        84: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
    },
    24: {  # 'L'
        29: SequenceLikelihood.POSITIVE,  # 'A'
        40: SequenceLikelihood.UNLIKELY,  # 'B'
        25: SequenceLikelihood.LIKELY,  # 'C'
        35: SequenceLikelihood.UNLIKELY,  # 'D'
        31: SequenceLikelihood.POSITIVE,  # 'E'
        42: SequenceLikelihood.UNLIKELY,  # 'F'
        47: SequenceLikelihood.UNLIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.LIKELY,  # 'I'
        48: SequenceLikelihood.UNLIKELY,  # 'J'
        56: SequenceLikelihood.UNLIKELY,  # 'K'
        24: SequenceLikelihood.LIKELY,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        43: SequenceLikelihood.LIKELY,  # 'O'
        32: SequenceLikelihood.UNLIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        38: SequenceLikelihood.UNLIKELY,  # 'R'
        30: SequenceLikelihood.LIKELY,  # 'S'
        37: SequenceLikelihood.LIKELY,  # 'T'
        46: SequenceLikelihood.LIKELY,  # 'U'
        45: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        61: SequenceLikelihood.UNLIKELY,  # 'X'
        60: SequenceLikelihood.UNLIKELY,  # 'Y'
        63: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        12: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        17: SequenceLikelihood.UNLIKELY,  # 'f'
        18: SequenceLikelihood.UNLIKELY,  # 'g'
        20: SequenceLikelihood.UNLIKELY,  # 'h'
        5: SequenceLikelihood.POSITIVE,  # 'i'
        26: SequenceLikelihood.UNLIKELY,  # 'j'
        44: SequenceLikelihood.UNLIKELY,  # 'k'
        10: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        8: SequenceLikelihood.POSITIVE,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        21: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        2: SequenceLikelihood.UNLIKELY,  # 's'
        6: SequenceLikelihood.UNLIKELY,  # 't'
        9: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        49: SequenceLikelihood.UNLIKELY,  # 'w'
        23: SequenceLikelihood.UNLIKELY,  # 'x'
        27: SequenceLikelihood.LIKELY,  # 'y'
        34: SequenceLikelihood.UNLIKELY,  # 'z'
        66: SequenceLikelihood.UNLIKELY,  # 'À'
        73: SequenceLikelihood.UNLIKELY,  # 'Â'
        83: SequenceLikelihood.UNLIKELY,  # 'Æ'
        69: SequenceLikelihood.NEGATIVE,  # 'Ç'
        70: SequenceLikelihood.UNLIKELY,  # 'È'
        58: SequenceLikelihood.UNLIKELY,  # 'É'
        72: SequenceLikelihood.UNLIKELY,  # 'Ê'
        80: SequenceLikelihood.UNLIKELY,  # 'Ë'
        71: SequenceLikelihood.UNLIKELY,  # 'Î'
        77: SequenceLikelihood.NEGATIVE,  # 'Ï'
        74: SequenceLikelihood.UNLIKELY,  # 'Ô'
        82: SequenceLikelihood.NEGATIVE,  # 'Ù'
        79: SequenceLikelihood.NEGATIVE,  # 'Û'
        78: SequenceLikelihood.UNLIKELY,  # 'Ü'
        22: SequenceLikelihood.UNLIKELY,  # 'à'
        53: SequenceLikelihood.UNLIKELY,  # 'â'
        76: SequenceLikelihood.UNLIKELY,  # 'æ'
        51: SequenceLikelihood.NEGATIVE,  # 'ç'
        28: SequenceLikelihood.UNLIKELY,  # 'è'
        15: SequenceLikelihood.LIKELY,  # 'é'
        41: SequenceLikelihood.UNLIKELY,  # 'ê'
        67: SequenceLikelihood.UNLIKELY,  # 'ë'
        57: SequenceLikelihood.NEGATIVE,  # 'î'
        65: SequenceLikelihood.UNLIKELY,  # 'ï'
        52: SequenceLikelihood.UNLIKELY,  # 'ô'
        62: SequenceLikelihood.NEGATIVE,  # 'ù'
        59: SequenceLikelihood.NEGATIVE,  # 'û'
        68: SequenceLikelihood.UNLIKELY,  # 'ü'
        81: SequenceLikelihood.NEGATIVE,  # 'ÿ'
        75: SequenceLikelihood.UNLIKELY,  # 'Œ'
        64: SequenceLikelihood.UNLIKELY,  # 'œ'
        84: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
    },
    33: {  # 'M'
        29: SequenceLikelihood.POSITIVE,  # 'A'
        40: SequenceLikelihood.LIKELY,  # 'B'
        25: SequenceLikelihood.LIKELY,  # 'C'
        35: SequenceLikelihood.UNLIKELY,  # 'D'
        31: SequenceLikelihood.POSITIVE,  # 'E'
        42: SequenceLikelihood.UNLIKELY,  # 'F'
        47: SequenceLikelihood.UNLIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.LIKELY,  # 'I'
        48: SequenceLikelihood.UNLIKELY,  # 'J'
        56: SequenceLikelihood.UNLIKELY,  # 'K'
        24: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.LIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        43: SequenceLikelihood.LIKELY,  # 'O'
        32: SequenceLikelihood.LIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        38: SequenceLikelihood.UNLIKELY,  # 'R'
        30: SequenceLikelihood.LIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        46: SequenceLikelihood.UNLIKELY,  # 'U'
        45: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        61: SequenceLikelihood.UNLIKELY,  # 'X'
        60: SequenceLikelihood.UNLIKELY,  # 'Y'
        63: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        12: SequenceLikelihood.LIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        17: SequenceLikelihood.UNLIKELY,  # 'f'
        18: SequenceLikelihood.UNLIKELY,  # 'g'
        20: SequenceLikelihood.UNLIKELY,  # 'h'
        5: SequenceLikelihood.POSITIVE,  # 'i'
        26: SequenceLikelihood.UNLIKELY,  # 'j'
        44: SequenceLikelihood.UNLIKELY,  # 'k'
        10: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.LIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        8: SequenceLikelihood.POSITIVE,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        21: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        2: SequenceLikelihood.UNLIKELY,  # 's'
        6: SequenceLikelihood.UNLIKELY,  # 't'
        9: SequenceLikelihood.LIKELY,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        49: SequenceLikelihood.UNLIKELY,  # 'w'
        23: SequenceLikelihood.UNLIKELY,  # 'x'
        27: SequenceLikelihood.LIKELY,  # 'y'
        34: SequenceLikelihood.UNLIKELY,  # 'z'
        66: SequenceLikelihood.UNLIKELY,  # 'À'
        73: SequenceLikelihood.UNLIKELY,  # 'Â'
        83: SequenceLikelihood.NEGATIVE,  # 'Æ'
        69: SequenceLikelihood.UNLIKELY,  # 'Ç'
        70: SequenceLikelihood.UNLIKELY,  # 'È'
        58: SequenceLikelihood.UNLIKELY,  # 'É'
        72: SequenceLikelihood.UNLIKELY,  # 'Ê'
        80: SequenceLikelihood.UNLIKELY,  # 'Ë'
        71: SequenceLikelihood.NEGATIVE,  # 'Î'
        77: SequenceLikelihood.NEGATIVE,  # 'Ï'
        74: SequenceLikelihood.UNLIKELY,  # 'Ô'
        82: SequenceLikelihood.NEGATIVE,  # 'Ù'
        79: SequenceLikelihood.NEGATIVE,  # 'Û'
        78: SequenceLikelihood.UNLIKELY,  # 'Ü'
        22: SequenceLikelihood.UNLIKELY,  # 'à'
        53: SequenceLikelihood.UNLIKELY,  # 'â'
        76: SequenceLikelihood.UNLIKELY,  # 'æ'
        51: SequenceLikelihood.NEGATIVE,  # 'ç'
        28: SequenceLikelihood.UNLIKELY,  # 'è'
        15: SequenceLikelihood.LIKELY,  # 'é'
        41: SequenceLikelihood.LIKELY,  # 'ê'
        67: SequenceLikelihood.UNLIKELY,  # 'ë'
        57: SequenceLikelihood.UNLIKELY,  # 'î'
        65: SequenceLikelihood.UNLIKELY,  # 'ï'
        52: SequenceLikelihood.UNLIKELY,  # 'ô'
        62: SequenceLikelihood.NEGATIVE,  # 'ù'
        59: SequenceLikelihood.UNLIKELY,  # 'û'
        68: SequenceLikelihood.UNLIKELY,  # 'ü'
        81: SequenceLikelihood.UNLIKELY,  # 'ÿ'
        75: SequenceLikelihood.UNLIKELY,  # 'Œ'
        64: SequenceLikelihood.UNLIKELY,  # 'œ'
        84: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
    },
    39: {  # 'N'
        29: SequenceLikelihood.LIKELY,  # 'A'
        40: SequenceLikelihood.UNLIKELY,  # 'B'
        25: SequenceLikelihood.LIKELY,  # 'C'
        35: SequenceLikelihood.LIKELY,  # 'D'
        31: SequenceLikelihood.POSITIVE,  # 'E'
        42: SequenceLikelihood.LIKELY,  # 'F'
        47: SequenceLikelihood.LIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.LIKELY,  # 'I'
        48: SequenceLikelihood.UNLIKELY,  # 'J'
        56: SequenceLikelihood.UNLIKELY,  # 'K'
        24: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.LIKELY,  # 'N'
        43: SequenceLikelihood.LIKELY,  # 'O'
        32: SequenceLikelihood.UNLIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        38: SequenceLikelihood.UNLIKELY,  # 'R'
        30: SequenceLikelihood.LIKELY,  # 'S'
        37: SequenceLikelihood.POSITIVE,  # 'T'
        46: SequenceLikelihood.LIKELY,  # 'U'
        45: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        61: SequenceLikelihood.UNLIKELY,  # 'X'
        60: SequenceLikelihood.UNLIKELY,  # 'Y'
        63: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        12: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        17: SequenceLikelihood.UNLIKELY,  # 'f'
        18: SequenceLikelihood.UNLIKELY,  # 'g'
        20: SequenceLikelihood.UNLIKELY,  # 'h'
        5: SequenceLikelihood.POSITIVE,  # 'i'
        26: SequenceLikelihood.UNLIKELY,  # 'j'
        44: SequenceLikelihood.UNLIKELY,  # 'k'
        10: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        8: SequenceLikelihood.POSITIVE,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        21: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        2: SequenceLikelihood.UNLIKELY,  # 's'
        6: SequenceLikelihood.UNLIKELY,  # 't'
        9: SequenceLikelihood.LIKELY,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        49: SequenceLikelihood.UNLIKELY,  # 'w'
        23: SequenceLikelihood.UNLIKELY,  # 'x'
        27: SequenceLikelihood.UNLIKELY,  # 'y'
        34: SequenceLikelihood.UNLIKELY,  # 'z'
        66: SequenceLikelihood.NEGATIVE,  # 'À'
        73: SequenceLikelihood.UNLIKELY,  # 'Â'
        83: SequenceLikelihood.NEGATIVE,  # 'Æ'
        69: SequenceLikelihood.UNLIKELY,  # 'Ç'
        70: SequenceLikelihood.UNLIKELY,  # 'È'
        58: SequenceLikelihood.UNLIKELY,  # 'É'
        72: SequenceLikelihood.UNLIKELY,  # 'Ê'
        80: SequenceLikelihood.NEGATIVE,  # 'Ë'
        71: SequenceLikelihood.UNLIKELY,  # 'Î'
        77: SequenceLikelihood.NEGATIVE,  # 'Ï'
        74: SequenceLikelihood.UNLIKELY,  # 'Ô'
        82: SequenceLikelihood.NEGATIVE,  # 'Ù'
        79: SequenceLikelihood.NEGATIVE,  # 'Û'
        78: SequenceLikelihood.UNLIKELY,  # 'Ü'
        22: SequenceLikelihood.UNLIKELY,  # 'à'
        53: SequenceLikelihood.UNLIKELY,  # 'â'
        76: SequenceLikelihood.UNLIKELY,  # 'æ'
        51: SequenceLikelihood.UNLIKELY,  # 'ç'
        28: SequenceLikelihood.UNLIKELY,  # 'è'
        15: SequenceLikelihood.LIKELY,  # 'é'
        41: SequenceLikelihood.UNLIKELY,  # 'ê'
        67: SequenceLikelihood.UNLIKELY,  # 'ë'
        57: SequenceLikelihood.UNLIKELY,  # 'î'
        65: SequenceLikelihood.NEGATIVE,  # 'ï'
        52: SequenceLikelihood.UNLIKELY,  # 'ô'
        62: SequenceLikelihood.UNLIKELY,  # 'ù'
        59: SequenceLikelihood.UNLIKELY,  # 'û'
        68: SequenceLikelihood.UNLIKELY,  # 'ü'
        81: SequenceLikelihood.NEGATIVE,  # 'ÿ'
        75: SequenceLikelihood.UNLIKELY,  # 'Œ'
        64: SequenceLikelihood.UNLIKELY,  # 'œ'
        84: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
    },
    43: {  # 'O'
        29: SequenceLikelihood.UNLIKELY,  # 'A'
        40: SequenceLikelihood.LIKELY,  # 'B'
        25: SequenceLikelihood.LIKELY,  # 'C'
        35: SequenceLikelihood.LIKELY,  # 'D'
        31: SequenceLikelihood.UNLIKELY,  # 'E'
        42: SequenceLikelihood.UNLIKELY,  # 'F'
        47: SequenceLikelihood.LIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.LIKELY,  # 'I'
        48: SequenceLikelihood.UNLIKELY,  # 'J'
        56: SequenceLikelihood.UNLIKELY,  # 'K'
        24: SequenceLikelihood.LIKELY,  # 'L'
        33: SequenceLikelihood.LIKELY,  # 'M'
        39: SequenceLikelihood.POSITIVE,  # 'N'
        43: SequenceLikelihood.LIKELY,  # 'O'
        32: SequenceLikelihood.LIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        38: SequenceLikelihood.LIKELY,  # 'R'
        30: SequenceLikelihood.LIKELY,  # 'S'
        37: SequenceLikelihood.LIKELY,  # 'T'
        46: SequenceLikelihood.POSITIVE,  # 'U'
        45: SequenceLikelihood.LIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        61: SequenceLikelihood.UNLIKELY,  # 'X'
        60: SequenceLikelihood.UNLIKELY,  # 'Y'
        63: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.UNLIKELY,  # 'a'
        19: SequenceLikelihood.LIKELY,  # 'b'
        12: SequenceLikelihood.LIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.UNLIKELY,  # 'e'
        17: SequenceLikelihood.LIKELY,  # 'f'
        18: SequenceLikelihood.UNLIKELY,  # 'g'
        20: SequenceLikelihood.UNLIKELY,  # 'h'
        5: SequenceLikelihood.UNLIKELY,  # 'i'
        26: SequenceLikelihood.UNLIKELY,  # 'j'
        44: SequenceLikelihood.UNLIKELY,  # 'k'
        10: SequenceLikelihood.LIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        8: SequenceLikelihood.UNLIKELY,  # 'o'
        13: SequenceLikelihood.LIKELY,  # 'p'
        21: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        2: SequenceLikelihood.LIKELY,  # 's'
        6: SequenceLikelihood.UNLIKELY,  # 't'
        9: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        49: SequenceLikelihood.UNLIKELY,  # 'w'
        23: SequenceLikelihood.UNLIKELY,  # 'x'
        27: SequenceLikelihood.UNLIKELY,  # 'y'
        34: SequenceLikelihood.UNLIKELY,  # 'z'
        66: SequenceLikelihood.NEGATIVE,  # 'À'
        73: SequenceLikelihood.NEGATIVE,  # 'Â'
        83: SequenceLikelihood.NEGATIVE,  # 'Æ'
        69: SequenceLikelihood.NEGATIVE,  # 'Ç'
        70: SequenceLikelihood.UNLIKELY,  # 'È'
        58: SequenceLikelihood.UNLIKELY,  # 'É'
        72: SequenceLikelihood.UNLIKELY,  # 'Ê'
        80: SequenceLikelihood.UNLIKELY,  # 'Ë'
        71: SequenceLikelihood.UNLIKELY,  # 'Î'
        77: SequenceLikelihood.UNLIKELY,  # 'Ï'
        74: SequenceLikelihood.NEGATIVE,  # 'Ô'
        82: SequenceLikelihood.UNLIKELY,  # 'Ù'
        79: SequenceLikelihood.UNLIKELY,  # 'Û'
        78: SequenceLikelihood.UNLIKELY,  # 'Ü'
        22: SequenceLikelihood.NEGATIVE,  # 'à'
        53: SequenceLikelihood.NEGATIVE,  # 'â'
        76: SequenceLikelihood.NEGATIVE,  # 'æ'
        51: SequenceLikelihood.UNLIKELY,  # 'ç'
        28: SequenceLikelihood.NEGATIVE,  # 'è'
        15: SequenceLikelihood.UNLIKELY,  # 'é'
        41: SequenceLikelihood.UNLIKELY,  # 'ê'
        67: SequenceLikelihood.NEGATIVE,  # 'ë'
        57: SequenceLikelihood.UNLIKELY,  # 'î'
        65: SequenceLikelihood.UNLIKELY,  # 'ï'
        52: SequenceLikelihood.NEGATIVE,  # 'ô'
        62: SequenceLikelihood.UNLIKELY,  # 'ù'
        59: SequenceLikelihood.UNLIKELY,  # 'û'
        68: SequenceLikelihood.UNLIKELY,  # 'ü'
        81: SequenceLikelihood.NEGATIVE,  # 'ÿ'
        75: SequenceLikelihood.NEGATIVE,  # 'Œ'
        64: SequenceLikelihood.NEGATIVE,  # 'œ'
        84: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
    },
    32: {  # 'P'
        29: SequenceLikelihood.LIKELY,  # 'A'
        40: SequenceLikelihood.UNLIKELY,  # 'B'
        25: SequenceLikelihood.LIKELY,  # 'C'
        35: SequenceLikelihood.LIKELY,  # 'D'
        31: SequenceLikelihood.LIKELY,  # 'E'
        42: SequenceLikelihood.UNLIKELY,  # 'F'
        47: SequenceLikelihood.UNLIKELY,  # 'G'
        50: SequenceLikelihood.LIKELY,  # 'H'
        36: SequenceLikelihood.LIKELY,  # 'I'
        48: SequenceLikelihood.UNLIKELY,  # 'J'
        56: SequenceLikelihood.UNLIKELY,  # 'K'
        24: SequenceLikelihood.LIKELY,  # 'L'
        33: SequenceLikelihood.LIKELY,  # 'M'
        39: SequenceLikelihood.LIKELY,  # 'N'
        43: SequenceLikelihood.LIKELY,  # 'O'
        32: SequenceLikelihood.LIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        38: SequenceLikelihood.LIKELY,  # 'R'
        30: SequenceLikelihood.LIKELY,  # 'S'
        37: SequenceLikelihood.LIKELY,  # 'T'
        46: SequenceLikelihood.LIKELY,  # 'U'
        45: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        61: SequenceLikelihood.UNLIKELY,  # 'X'
        60: SequenceLikelihood.UNLIKELY,  # 'Y'
        63: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        12: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        17: SequenceLikelihood.UNLIKELY,  # 'f'
        18: SequenceLikelihood.UNLIKELY,  # 'g'
        20: SequenceLikelihood.POSITIVE,  # 'h'
        5: SequenceLikelihood.POSITIVE,  # 'i'
        26: SequenceLikelihood.UNLIKELY,  # 'j'
        44: SequenceLikelihood.UNLIKELY,  # 'k'
        10: SequenceLikelihood.POSITIVE,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        8: SequenceLikelihood.POSITIVE,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        21: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        2: SequenceLikelihood.UNLIKELY,  # 's'
        6: SequenceLikelihood.UNLIKELY,  # 't'
        9: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        49: SequenceLikelihood.UNLIKELY,  # 'w'
        23: SequenceLikelihood.UNLIKELY,  # 'x'
        27: SequenceLikelihood.LIKELY,  # 'y'
        34: SequenceLikelihood.UNLIKELY,  # 'z'
        66: SequenceLikelihood.NEGATIVE,  # 'À'
        73: SequenceLikelihood.UNLIKELY,  # 'Â'
        83: SequenceLikelihood.NEGATIVE,  # 'Æ'
        69: SequenceLikelihood.UNLIKELY,  # 'Ç'
        70: SequenceLikelihood.UNLIKELY,  # 'È'
        58: SequenceLikelihood.UNLIKELY,  # 'É'
        72: SequenceLikelihood.UNLIKELY,  # 'Ê'
        80: SequenceLikelihood.UNLIKELY,  # 'Ë'
        71: SequenceLikelihood.UNLIKELY,  # 'Î'
        77: SequenceLikelihood.NEGATIVE,  # 'Ï'
        74: SequenceLikelihood.UNLIKELY,  # 'Ô'
        82: SequenceLikelihood.NEGATIVE,  # 'Ù'
        79: SequenceLikelihood.UNLIKELY,  # 'Û'
        78: SequenceLikelihood.UNLIKELY,  # 'Ü'
        22: SequenceLikelihood.UNLIKELY,  # 'à'
        53: SequenceLikelihood.UNLIKELY,  # 'â'
        76: SequenceLikelihood.NEGATIVE,  # 'æ'
        51: SequenceLikelihood.NEGATIVE,  # 'ç'
        28: SequenceLikelihood.UNLIKELY,  # 'è'
        15: SequenceLikelihood.LIKELY,  # 'é'
        41: SequenceLikelihood.UNLIKELY,  # 'ê'
        67: SequenceLikelihood.UNLIKELY,  # 'ë'
        57: SequenceLikelihood.UNLIKELY,  # 'î'
        65: SequenceLikelihood.UNLIKELY,  # 'ï'
        52: SequenceLikelihood.UNLIKELY,  # 'ô'
        62: SequenceLikelihood.NEGATIVE,  # 'ù'
        59: SequenceLikelihood.NEGATIVE,  # 'û'
        68: SequenceLikelihood.UNLIKELY,  # 'ü'
        81: SequenceLikelihood.NEGATIVE,  # 'ÿ'
        75: SequenceLikelihood.NEGATIVE,  # 'Œ'
        64: SequenceLikelihood.UNLIKELY,  # 'œ'
        84: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
    },
    55: {  # 'Q'
        29: SequenceLikelihood.UNLIKELY,  # 'A'
        40: SequenceLikelihood.UNLIKELY,  # 'B'
        25: SequenceLikelihood.UNLIKELY,  # 'C'
        35: SequenceLikelihood.UNLIKELY,  # 'D'
        31: SequenceLikelihood.UNLIKELY,  # 'E'
        42: SequenceLikelihood.UNLIKELY,  # 'F'
        47: SequenceLikelihood.UNLIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        48: SequenceLikelihood.UNLIKELY,  # 'J'
        56: SequenceLikelihood.UNLIKELY,  # 'K'
        24: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        43: SequenceLikelihood.UNLIKELY,  # 'O'
        32: SequenceLikelihood.UNLIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        38: SequenceLikelihood.UNLIKELY,  # 'R'
        30: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        46: SequenceLikelihood.LIKELY,  # 'U'
        45: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        61: SequenceLikelihood.UNLIKELY,  # 'X'
        60: SequenceLikelihood.UNLIKELY,  # 'Y'
        63: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.UNLIKELY,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        12: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.UNLIKELY,  # 'e'
        17: SequenceLikelihood.UNLIKELY,  # 'f'
        18: SequenceLikelihood.UNLIKELY,  # 'g'
        20: SequenceLikelihood.UNLIKELY,  # 'h'
        5: SequenceLikelihood.UNLIKELY,  # 'i'
        26: SequenceLikelihood.UNLIKELY,  # 'j'
        44: SequenceLikelihood.UNLIKELY,  # 'k'
        10: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        8: SequenceLikelihood.UNLIKELY,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        21: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        2: SequenceLikelihood.UNLIKELY,  # 's'
        6: SequenceLikelihood.UNLIKELY,  # 't'
        9: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        49: SequenceLikelihood.UNLIKELY,  # 'w'
        23: SequenceLikelihood.UNLIKELY,  # 'x'
        27: SequenceLikelihood.UNLIKELY,  # 'y'
        34: SequenceLikelihood.UNLIKELY,  # 'z'
        66: SequenceLikelihood.UNLIKELY,  # 'À'
        73: SequenceLikelihood.NEGATIVE,  # 'Â'
        83: SequenceLikelihood.NEGATIVE,  # 'Æ'
        69: SequenceLikelihood.NEGATIVE,  # 'Ç'
        70: SequenceLikelihood.NEGATIVE,  # 'È'
        58: SequenceLikelihood.UNLIKELY,  # 'É'
        72: SequenceLikelihood.NEGATIVE,  # 'Ê'
        80: SequenceLikelihood.NEGATIVE,  # 'Ë'
        71: SequenceLikelihood.NEGATIVE,  # 'Î'
        77: SequenceLikelihood.NEGATIVE,  # 'Ï'
        74: SequenceLikelihood.NEGATIVE,  # 'Ô'
        82: SequenceLikelihood.NEGATIVE,  # 'Ù'
        79: SequenceLikelihood.UNLIKELY,  # 'Û'
        78: SequenceLikelihood.NEGATIVE,  # 'Ü'
        22: SequenceLikelihood.UNLIKELY,  # 'à'
        53: SequenceLikelihood.UNLIKELY,  # 'â'
        76: SequenceLikelihood.NEGATIVE,  # 'æ'
        51: SequenceLikelihood.NEGATIVE,  # 'ç'
        28: SequenceLikelihood.NEGATIVE,  # 'è'
        15: SequenceLikelihood.NEGATIVE,  # 'é'
        41: SequenceLikelihood.NEGATIVE,  # 'ê'
        67: SequenceLikelihood.NEGATIVE,  # 'ë'
        57: SequenceLikelihood.NEGATIVE,  # 'î'
        65: SequenceLikelihood.NEGATIVE,  # 'ï'
        52: SequenceLikelihood.NEGATIVE,  # 'ô'
        62: SequenceLikelihood.NEGATIVE,  # 'ù'
        59: SequenceLikelihood.NEGATIVE,  # 'û'
        68: SequenceLikelihood.NEGATIVE,  # 'ü'
        81: SequenceLikelihood.NEGATIVE,  # 'ÿ'
        75: SequenceLikelihood.NEGATIVE,  # 'Œ'
        64: SequenceLikelihood.NEGATIVE,  # 'œ'
        84: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
    },
    38: {  # 'R'
        29: SequenceLikelihood.POSITIVE,  # 'A'
        40: SequenceLikelihood.UNLIKELY,  # 'B'
        25: SequenceLikelihood.LIKELY,  # 'C'
        35: SequenceLikelihood.LIKELY,  # 'D'
        31: SequenceLikelihood.POSITIVE,  # 'E'
        42: SequenceLikelihood.UNLIKELY,  # 'F'
        47: SequenceLikelihood.LIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.LIKELY,  # 'I'
        48: SequenceLikelihood.UNLIKELY,  # 'J'
        56: SequenceLikelihood.UNLIKELY,  # 'K'
        24: SequenceLikelihood.LIKELY,  # 'L'
        33: SequenceLikelihood.LIKELY,  # 'M'
        39: SequenceLikelihood.LIKELY,  # 'N'
        43: SequenceLikelihood.LIKELY,  # 'O'
        32: SequenceLikelihood.LIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        38: SequenceLikelihood.LIKELY,  # 'R'
        30: SequenceLikelihood.LIKELY,  # 'S'
        37: SequenceLikelihood.LIKELY,  # 'T'
        46: SequenceLikelihood.LIKELY,  # 'U'
        45: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        61: SequenceLikelihood.UNLIKELY,  # 'X'
        60: SequenceLikelihood.UNLIKELY,  # 'Y'
        63: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        12: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        17: SequenceLikelihood.UNLIKELY,  # 'f'
        18: SequenceLikelihood.UNLIKELY,  # 'g'
        20: SequenceLikelihood.LIKELY,  # 'h'
        5: SequenceLikelihood.LIKELY,  # 'i'
        26: SequenceLikelihood.UNLIKELY,  # 'j'
        44: SequenceLikelihood.UNLIKELY,  # 'k'
        10: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        8: SequenceLikelihood.POSITIVE,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        21: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        2: SequenceLikelihood.UNLIKELY,  # 's'
        6: SequenceLikelihood.UNLIKELY,  # 't'
        9: SequenceLikelihood.LIKELY,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        49: SequenceLikelihood.UNLIKELY,  # 'w'
        23: SequenceLikelihood.UNLIKELY,  # 'x'
        27: SequenceLikelihood.UNLIKELY,  # 'y'
        34: SequenceLikelihood.UNLIKELY,  # 'z'
        66: SequenceLikelihood.UNLIKELY,  # 'À'
        73: SequenceLikelihood.UNLIKELY,  # 'Â'
        83: SequenceLikelihood.NEGATIVE,  # 'Æ'
        69: SequenceLikelihood.UNLIKELY,  # 'Ç'
        70: SequenceLikelihood.UNLIKELY,  # 'È'
        58: SequenceLikelihood.UNLIKELY,  # 'É'
        72: SequenceLikelihood.UNLIKELY,  # 'Ê'
        80: SequenceLikelihood.NEGATIVE,  # 'Ë'
        71: SequenceLikelihood.UNLIKELY,  # 'Î'
        77: SequenceLikelihood.UNLIKELY,  # 'Ï'
        74: SequenceLikelihood.UNLIKELY,  # 'Ô'
        82: SequenceLikelihood.NEGATIVE,  # 'Ù'
        79: SequenceLikelihood.UNLIKELY,  # 'Û'
        78: SequenceLikelihood.UNLIKELY,  # 'Ü'
        22: SequenceLikelihood.UNLIKELY,  # 'à'
        53: SequenceLikelihood.UNLIKELY,  # 'â'
        76: SequenceLikelihood.NEGATIVE,  # 'æ'
        51: SequenceLikelihood.NEGATIVE,  # 'ç'
        28: SequenceLikelihood.UNLIKELY,  # 'è'
        15: SequenceLikelihood.POSITIVE,  # 'é'
        41: SequenceLikelihood.UNLIKELY,  # 'ê'
        67: SequenceLikelihood.UNLIKELY,  # 'ë'
        57: SequenceLikelihood.UNLIKELY,  # 'î'
        65: SequenceLikelihood.UNLIKELY,  # 'ï'
        52: SequenceLikelihood.UNLIKELY,  # 'ô'
        62: SequenceLikelihood.NEGATIVE,  # 'ù'
        59: SequenceLikelihood.UNLIKELY,  # 'û'
        68: SequenceLikelihood.UNLIKELY,  # 'ü'
        81: SequenceLikelihood.NEGATIVE,  # 'ÿ'
        75: SequenceLikelihood.NEGATIVE,  # 'Œ'
        64: SequenceLikelihood.NEGATIVE,  # 'œ'
        84: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
    },
    30: {  # 'S'
        29: SequenceLikelihood.LIKELY,  # 'A'
        40: SequenceLikelihood.LIKELY,  # 'B'
        25: SequenceLikelihood.LIKELY,  # 'C'
        35: SequenceLikelihood.LIKELY,  # 'D'
        31: SequenceLikelihood.POSITIVE,  # 'E'
        42: SequenceLikelihood.LIKELY,  # 'F'
        47: SequenceLikelihood.UNLIKELY,  # 'G'
        50: SequenceLikelihood.LIKELY,  # 'H'
        36: SequenceLikelihood.LIKELY,  # 'I'
        48: SequenceLikelihood.UNLIKELY,  # 'J'
        56: SequenceLikelihood.UNLIKELY,  # 'K'
        24: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.LIKELY,  # 'M'
        39: SequenceLikelihood.LIKELY,  # 'N'
        43: SequenceLikelihood.LIKELY,  # 'O'
        32: SequenceLikelihood.LIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        38: SequenceLikelihood.UNLIKELY,  # 'R'
        30: SequenceLikelihood.LIKELY,  # 'S'
        37: SequenceLikelihood.LIKELY,  # 'T'
        46: SequenceLikelihood.LIKELY,  # 'U'
        45: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        61: SequenceLikelihood.UNLIKELY,  # 'X'
        60: SequenceLikelihood.UNLIKELY,  # 'Y'
        63: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        12: SequenceLikelihood.LIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        17: SequenceLikelihood.UNLIKELY,  # 'f'
        18: SequenceLikelihood.UNLIKELY,  # 'g'
        20: SequenceLikelihood.LIKELY,  # 'h'
        5: SequenceLikelihood.POSITIVE,  # 'i'
        26: SequenceLikelihood.UNLIKELY,  # 'j'
        44: SequenceLikelihood.LIKELY,  # 'k'
        10: SequenceLikelihood.LIKELY,  # 'l'
        14: SequenceLikelihood.LIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        8: SequenceLikelihood.POSITIVE,  # 'o'
        13: SequenceLikelihood.POSITIVE,  # 'p'
        21: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        2: SequenceLikelihood.UNLIKELY,  # 's'
        6: SequenceLikelihood.POSITIVE,  # 't'
        9: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        49: SequenceLikelihood.LIKELY,  # 'w'
        23: SequenceLikelihood.UNLIKELY,  # 'x'
        27: SequenceLikelihood.LIKELY,  # 'y'
        34: SequenceLikelihood.UNLIKELY,  # 'z'
        66: SequenceLikelihood.UNLIKELY,  # 'À'
        73: SequenceLikelihood.NEGATIVE,  # 'Â'
        83: SequenceLikelihood.NEGATIVE,  # 'Æ'
        69: SequenceLikelihood.UNLIKELY,  # 'Ç'
        70: SequenceLikelihood.UNLIKELY,  # 'È'
        58: SequenceLikelihood.UNLIKELY,  # 'É'
        72: SequenceLikelihood.NEGATIVE,  # 'Ê'
        80: SequenceLikelihood.NEGATIVE,  # 'Ë'
        71: SequenceLikelihood.UNLIKELY,  # 'Î'
        77: SequenceLikelihood.NEGATIVE,  # 'Ï'
        74: SequenceLikelihood.NEGATIVE,  # 'Ô'
        82: SequenceLikelihood.UNLIKELY,  # 'Ù'
        79: SequenceLikelihood.UNLIKELY,  # 'Û'
        78: SequenceLikelihood.UNLIKELY,  # 'Ü'
        22: SequenceLikelihood.UNLIKELY,  # 'à'
        53: SequenceLikelihood.UNLIKELY,  # 'â'
        76: SequenceLikelihood.UNLIKELY,  # 'æ'
        51: SequenceLikelihood.NEGATIVE,  # 'ç'
        28: SequenceLikelihood.UNLIKELY,  # 'è'
        15: SequenceLikelihood.LIKELY,  # 'é'
        41: SequenceLikelihood.UNLIKELY,  # 'ê'
        67: SequenceLikelihood.NEGATIVE,  # 'ë'
        57: SequenceLikelihood.UNLIKELY,  # 'î'
        65: SequenceLikelihood.NEGATIVE,  # 'ï'
        52: SequenceLikelihood.UNLIKELY,  # 'ô'
        62: SequenceLikelihood.UNLIKELY,  # 'ù'
        59: SequenceLikelihood.UNLIKELY,  # 'û'
        68: SequenceLikelihood.UNLIKELY,  # 'ü'
        81: SequenceLikelihood.NEGATIVE,  # 'ÿ'
        75: SequenceLikelihood.UNLIKELY,  # 'Œ'
        64: SequenceLikelihood.UNLIKELY,  # 'œ'
        84: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
    },
    37: {  # 'T'
        29: SequenceLikelihood.LIKELY,  # 'A'
        40: SequenceLikelihood.UNLIKELY,  # 'B'
        25: SequenceLikelihood.LIKELY,  # 'C'
        35: SequenceLikelihood.UNLIKELY,  # 'D'
        31: SequenceLikelihood.POSITIVE,  # 'E'
        42: SequenceLikelihood.UNLIKELY,  # 'F'
        47: SequenceLikelihood.UNLIKELY,  # 'G'
        50: SequenceLikelihood.LIKELY,  # 'H'
        36: SequenceLikelihood.POSITIVE,  # 'I'
        48: SequenceLikelihood.UNLIKELY,  # 'J'
        56: SequenceLikelihood.UNLIKELY,  # 'K'
        24: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        43: SequenceLikelihood.LIKELY,  # 'O'
        32: SequenceLikelihood.LIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        38: SequenceLikelihood.LIKELY,  # 'R'
        30: SequenceLikelihood.LIKELY,  # 'S'
        37: SequenceLikelihood.LIKELY,  # 'T'
        46: SequenceLikelihood.LIKELY,  # 'U'
        45: SequenceLikelihood.LIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        61: SequenceLikelihood.UNLIKELY,  # 'X'
        60: SequenceLikelihood.UNLIKELY,  # 'Y'
        63: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        12: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        17: SequenceLikelihood.UNLIKELY,  # 'f'
        18: SequenceLikelihood.UNLIKELY,  # 'g'
        20: SequenceLikelihood.POSITIVE,  # 'h'
        5: SequenceLikelihood.LIKELY,  # 'i'
        26: SequenceLikelihood.UNLIKELY,  # 'j'
        44: SequenceLikelihood.UNLIKELY,  # 'k'
        10: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        8: SequenceLikelihood.POSITIVE,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        21: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        2: SequenceLikelihood.UNLIKELY,  # 's'
        6: SequenceLikelihood.UNLIKELY,  # 't'
        9: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        49: SequenceLikelihood.LIKELY,  # 'w'
        23: SequenceLikelihood.UNLIKELY,  # 'x'
        27: SequenceLikelihood.LIKELY,  # 'y'
        34: SequenceLikelihood.UNLIKELY,  # 'z'
        66: SequenceLikelihood.UNLIKELY,  # 'À'
        73: SequenceLikelihood.UNLIKELY,  # 'Â'
        83: SequenceLikelihood.UNLIKELY,  # 'Æ'
        69: SequenceLikelihood.NEGATIVE,  # 'Ç'
        70: SequenceLikelihood.UNLIKELY,  # 'È'
        58: SequenceLikelihood.LIKELY,  # 'É'
        72: SequenceLikelihood.UNLIKELY,  # 'Ê'
        80: SequenceLikelihood.UNLIKELY,  # 'Ë'
        71: SequenceLikelihood.UNLIKELY,  # 'Î'
        77: SequenceLikelihood.NEGATIVE,  # 'Ï'
        74: SequenceLikelihood.UNLIKELY,  # 'Ô'
        82: SequenceLikelihood.NEGATIVE,  # 'Ù'
        79: SequenceLikelihood.NEGATIVE,  # 'Û'
        78: SequenceLikelihood.UNLIKELY,  # 'Ü'
        22: SequenceLikelihood.UNLIKELY,  # 'à'
        53: SequenceLikelihood.UNLIKELY,  # 'â'
        76: SequenceLikelihood.UNLIKELY,  # 'æ'
        51: SequenceLikelihood.NEGATIVE,  # 'ç'
        28: SequenceLikelihood.UNLIKELY,  # 'è'
        15: SequenceLikelihood.LIKELY,  # 'é'
        41: SequenceLikelihood.UNLIKELY,  # 'ê'
        67: SequenceLikelihood.UNLIKELY,  # 'ë'
        57: SequenceLikelihood.NEGATIVE,  # 'î'
        65: SequenceLikelihood.UNLIKELY,  # 'ï'
        52: SequenceLikelihood.UNLIKELY,  # 'ô'
        62: SequenceLikelihood.UNLIKELY,  # 'ù'
        59: SequenceLikelihood.UNLIKELY,  # 'û'
        68: SequenceLikelihood.UNLIKELY,  # 'ü'
        81: SequenceLikelihood.NEGATIVE,  # 'ÿ'
        75: SequenceLikelihood.NEGATIVE,  # 'Œ'
        64: SequenceLikelihood.NEGATIVE,  # 'œ'
        84: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
    },
    46: {  # 'U'
        29: SequenceLikelihood.LIKELY,  # 'A'
        40: SequenceLikelihood.LIKELY,  # 'B'
        25: SequenceLikelihood.LIKELY,  # 'C'
        35: SequenceLikelihood.LIKELY,  # 'D'
        31: SequenceLikelihood.LIKELY,  # 'E'
        42: SequenceLikelihood.UNLIKELY,  # 'F'
        47: SequenceLikelihood.UNLIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.LIKELY,  # 'I'
        48: SequenceLikelihood.UNLIKELY,  # 'J'
        56: SequenceLikelihood.UNLIKELY,  # 'K'
        24: SequenceLikelihood.LIKELY,  # 'L'
        33: SequenceLikelihood.LIKELY,  # 'M'
        39: SequenceLikelihood.LIKELY,  # 'N'
        43: SequenceLikelihood.UNLIKELY,  # 'O'
        32: SequenceLikelihood.LIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        38: SequenceLikelihood.POSITIVE,  # 'R'
        30: SequenceLikelihood.LIKELY,  # 'S'
        37: SequenceLikelihood.LIKELY,  # 'T'
        46: SequenceLikelihood.UNLIKELY,  # 'U'
        45: SequenceLikelihood.LIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        61: SequenceLikelihood.LIKELY,  # 'X'
        60: SequenceLikelihood.UNLIKELY,  # 'Y'
        63: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.UNLIKELY,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        12: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.UNLIKELY,  # 'e'
        17: SequenceLikelihood.UNLIKELY,  # 'f'
        18: SequenceLikelihood.UNLIKELY,  # 'g'
        20: SequenceLikelihood.UNLIKELY,  # 'h'
        5: SequenceLikelihood.UNLIKELY,  # 'i'
        26: SequenceLikelihood.UNLIKELY,  # 'j'
        44: SequenceLikelihood.UNLIKELY,  # 'k'
        10: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        8: SequenceLikelihood.UNLIKELY,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        21: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.LIKELY,  # 'r'
        2: SequenceLikelihood.LIKELY,  # 's'
        6: SequenceLikelihood.LIKELY,  # 't'
        9: SequenceLikelihood.UNLIKELY,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        49: SequenceLikelihood.UNLIKELY,  # 'w'
        23: SequenceLikelihood.UNLIKELY,  # 'x'
        27: SequenceLikelihood.UNLIKELY,  # 'y'
        34: SequenceLikelihood.UNLIKELY,  # 'z'
        66: SequenceLikelihood.NEGATIVE,  # 'À'
        73: SequenceLikelihood.NEGATIVE,  # 'Â'
        83: SequenceLikelihood.UNLIKELY,  # 'Æ'
        69: SequenceLikelihood.UNLIKELY,  # 'Ç'
        70: SequenceLikelihood.UNLIKELY,  # 'È'
        58: SequenceLikelihood.UNLIKELY,  # 'É'
        72: SequenceLikelihood.UNLIKELY,  # 'Ê'
        80: SequenceLikelihood.UNLIKELY,  # 'Ë'
        71: SequenceLikelihood.UNLIKELY,  # 'Î'
        77: SequenceLikelihood.UNLIKELY,  # 'Ï'
        74: SequenceLikelihood.NEGATIVE,  # 'Ô'
        82: SequenceLikelihood.NEGATIVE,  # 'Ù'
        79: SequenceLikelihood.NEGATIVE,  # 'Û'
        78: SequenceLikelihood.NEGATIVE,  # 'Ü'
        22: SequenceLikelihood.NEGATIVE,  # 'à'
        53: SequenceLikelihood.NEGATIVE,  # 'â'
        76: SequenceLikelihood.NEGATIVE,  # 'æ'
        51: SequenceLikelihood.NEGATIVE,  # 'ç'
        28: SequenceLikelihood.UNLIKELY,  # 'è'
        15: SequenceLikelihood.UNLIKELY,  # 'é'
        41: SequenceLikelihood.NEGATIVE,  # 'ê'
        67: SequenceLikelihood.NEGATIVE,  # 'ë'
        57: SequenceLikelihood.NEGATIVE,  # 'î'
        65: SequenceLikelihood.NEGATIVE,  # 'ï'
        52: SequenceLikelihood.NEGATIVE,  # 'ô'
        62: SequenceLikelihood.NEGATIVE,  # 'ù'
        59: SequenceLikelihood.NEGATIVE,  # 'û'
        68: SequenceLikelihood.NEGATIVE,  # 'ü'
        81: SequenceLikelihood.NEGATIVE,  # 'ÿ'
        75: SequenceLikelihood.NEGATIVE,  # 'Œ'
        64: SequenceLikelihood.NEGATIVE,  # 'œ'
        84: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
    },
    45: {  # 'V'
        29: SequenceLikelihood.LIKELY,  # 'A'
        40: SequenceLikelihood.UNLIKELY,  # 'B'
        25: SequenceLikelihood.UNLIKELY,  # 'C'
        35: SequenceLikelihood.LIKELY,  # 'D'
        31: SequenceLikelihood.LIKELY,  # 'E'
        42: SequenceLikelihood.UNLIKELY,  # 'F'
        47: SequenceLikelihood.UNLIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.LIKELY,  # 'I'
        48: SequenceLikelihood.UNLIKELY,  # 'J'
        56: SequenceLikelihood.UNLIKELY,  # 'K'
        24: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        43: SequenceLikelihood.LIKELY,  # 'O'
        32: SequenceLikelihood.UNLIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        38: SequenceLikelihood.UNLIKELY,  # 'R'
        30: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        46: SequenceLikelihood.UNLIKELY,  # 'U'
        45: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        61: SequenceLikelihood.UNLIKELY,  # 'X'
        60: SequenceLikelihood.UNLIKELY,  # 'Y'
        63: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        12: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        17: SequenceLikelihood.UNLIKELY,  # 'f'
        18: SequenceLikelihood.UNLIKELY,  # 'g'
        20: SequenceLikelihood.UNLIKELY,  # 'h'
        5: SequenceLikelihood.POSITIVE,  # 'i'
        26: SequenceLikelihood.UNLIKELY,  # 'j'
        44: SequenceLikelihood.UNLIKELY,  # 'k'
        10: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        8: SequenceLikelihood.POSITIVE,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        21: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        2: SequenceLikelihood.UNLIKELY,  # 's'
        6: SequenceLikelihood.UNLIKELY,  # 't'
        9: SequenceLikelihood.LIKELY,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        49: SequenceLikelihood.UNLIKELY,  # 'w'
        23: SequenceLikelihood.UNLIKELY,  # 'x'
        27: SequenceLikelihood.UNLIKELY,  # 'y'
        34: SequenceLikelihood.UNLIKELY,  # 'z'
        66: SequenceLikelihood.NEGATIVE,  # 'À'
        73: SequenceLikelihood.NEGATIVE,  # 'Â'
        83: SequenceLikelihood.NEGATIVE,  # 'Æ'
        69: SequenceLikelihood.NEGATIVE,  # 'Ç'
        70: SequenceLikelihood.UNLIKELY,  # 'È'
        58: SequenceLikelihood.UNLIKELY,  # 'É'
        72: SequenceLikelihood.UNLIKELY,  # 'Ê'
        80: SequenceLikelihood.NEGATIVE,  # 'Ë'
        71: SequenceLikelihood.NEGATIVE,  # 'Î'
        77: SequenceLikelihood.NEGATIVE,  # 'Ï'
        74: SequenceLikelihood.UNLIKELY,  # 'Ô'
        82: SequenceLikelihood.NEGATIVE,  # 'Ù'
        79: SequenceLikelihood.NEGATIVE,  # 'Û'
        78: SequenceLikelihood.NEGATIVE,  # 'Ü'
        22: SequenceLikelihood.UNLIKELY,  # 'à'
        53: SequenceLikelihood.UNLIKELY,  # 'â'
        76: SequenceLikelihood.UNLIKELY,  # 'æ'
        51: SequenceLikelihood.NEGATIVE,  # 'ç'
        28: SequenceLikelihood.UNLIKELY,  # 'è'
        15: SequenceLikelihood.LIKELY,  # 'é'
        41: SequenceLikelihood.UNLIKELY,  # 'ê'
        67: SequenceLikelihood.NEGATIVE,  # 'ë'
        57: SequenceLikelihood.NEGATIVE,  # 'î'
        65: SequenceLikelihood.NEGATIVE,  # 'ï'
        52: SequenceLikelihood.UNLIKELY,  # 'ô'
        62: SequenceLikelihood.NEGATIVE,  # 'ù'
        59: SequenceLikelihood.NEGATIVE,  # 'û'
        68: SequenceLikelihood.NEGATIVE,  # 'ü'
        81: SequenceLikelihood.NEGATIVE,  # 'ÿ'
        75: SequenceLikelihood.UNLIKELY,  # 'Œ'
        64: SequenceLikelihood.UNLIKELY,  # 'œ'
        84: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
    },
    54: {  # 'W'
        29: SequenceLikelihood.UNLIKELY,  # 'A'
        40: SequenceLikelihood.UNLIKELY,  # 'B'
        25: SequenceLikelihood.UNLIKELY,  # 'C'
        35: SequenceLikelihood.UNLIKELY,  # 'D'
        31: SequenceLikelihood.UNLIKELY,  # 'E'
        42: SequenceLikelihood.UNLIKELY,  # 'F'
        47: SequenceLikelihood.UNLIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        48: SequenceLikelihood.UNLIKELY,  # 'J'
        56: SequenceLikelihood.UNLIKELY,  # 'K'
        24: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        43: SequenceLikelihood.UNLIKELY,  # 'O'
        32: SequenceLikelihood.UNLIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        38: SequenceLikelihood.UNLIKELY,  # 'R'
        30: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        46: SequenceLikelihood.UNLIKELY,  # 'U'
        45: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        61: SequenceLikelihood.UNLIKELY,  # 'X'
        60: SequenceLikelihood.UNLIKELY,  # 'Y'
        63: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.LIKELY,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        12: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.LIKELY,  # 'e'
        17: SequenceLikelihood.UNLIKELY,  # 'f'
        18: SequenceLikelihood.UNLIKELY,  # 'g'
        20: SequenceLikelihood.LIKELY,  # 'h'
        5: SequenceLikelihood.POSITIVE,  # 'i'
        26: SequenceLikelihood.UNLIKELY,  # 'j'
        44: SequenceLikelihood.UNLIKELY,  # 'k'
        10: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        8: SequenceLikelihood.LIKELY,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        21: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        2: SequenceLikelihood.UNLIKELY,  # 's'
        6: SequenceLikelihood.UNLIKELY,  # 't'
        9: SequenceLikelihood.UNLIKELY,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        49: SequenceLikelihood.UNLIKELY,  # 'w'
        23: SequenceLikelihood.UNLIKELY,  # 'x'
        27: SequenceLikelihood.UNLIKELY,  # 'y'
        34: SequenceLikelihood.UNLIKELY,  # 'z'
        66: SequenceLikelihood.NEGATIVE,  # 'À'
        73: SequenceLikelihood.NEGATIVE,  # 'Â'
        83: SequenceLikelihood.NEGATIVE,  # 'Æ'
        69: SequenceLikelihood.NEGATIVE,  # 'Ç'
        70: SequenceLikelihood.NEGATIVE,  # 'È'
        58: SequenceLikelihood.UNLIKELY,  # 'É'
        72: SequenceLikelihood.NEGATIVE,  # 'Ê'
        80: SequenceLikelihood.NEGATIVE,  # 'Ë'
        71: SequenceLikelihood.NEGATIVE,  # 'Î'
        77: SequenceLikelihood.NEGATIVE,  # 'Ï'
        74: SequenceLikelihood.NEGATIVE,  # 'Ô'
        82: SequenceLikelihood.NEGATIVE,  # 'Ù'
        79: SequenceLikelihood.NEGATIVE,  # 'Û'
        78: SequenceLikelihood.UNLIKELY,  # 'Ü'
        22: SequenceLikelihood.NEGATIVE,  # 'à'
        53: SequenceLikelihood.UNLIKELY,  # 'â'
        76: SequenceLikelihood.NEGATIVE,  # 'æ'
        51: SequenceLikelihood.NEGATIVE,  # 'ç'
        28: SequenceLikelihood.UNLIKELY,  # 'è'
        15: SequenceLikelihood.UNLIKELY,  # 'é'
        41: SequenceLikelihood.UNLIKELY,  # 'ê'
        67: SequenceLikelihood.UNLIKELY,  # 'ë'
        57: SequenceLikelihood.NEGATIVE,  # 'î'
        65: SequenceLikelihood.NEGATIVE,  # 'ï'
        52: SequenceLikelihood.UNLIKELY,  # 'ô'
        62: SequenceLikelihood.NEGATIVE,  # 'ù'
        59: SequenceLikelihood.NEGATIVE,  # 'û'
        68: SequenceLikelihood.UNLIKELY,  # 'ü'
        81: SequenceLikelihood.NEGATIVE,  # 'ÿ'
        75: SequenceLikelihood.NEGATIVE,  # 'Œ'
        64: SequenceLikelihood.UNLIKELY,  # 'œ'
        84: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
    },
    61: {  # 'X'
        29: SequenceLikelihood.UNLIKELY,  # 'A'
        40: SequenceLikelihood.UNLIKELY,  # 'B'
        25: SequenceLikelihood.UNLIKELY,  # 'C'
        35: SequenceLikelihood.UNLIKELY,  # 'D'
        31: SequenceLikelihood.UNLIKELY,  # 'E'
        42: SequenceLikelihood.UNLIKELY,  # 'F'
        47: SequenceLikelihood.UNLIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.LIKELY,  # 'I'
        48: SequenceLikelihood.UNLIKELY,  # 'J'
        56: SequenceLikelihood.UNLIKELY,  # 'K'
        24: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        43: SequenceLikelihood.UNLIKELY,  # 'O'
        32: SequenceLikelihood.UNLIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        38: SequenceLikelihood.UNLIKELY,  # 'R'
        30: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        46: SequenceLikelihood.UNLIKELY,  # 'U'
        45: SequenceLikelihood.LIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        61: SequenceLikelihood.LIKELY,  # 'X'
        60: SequenceLikelihood.UNLIKELY,  # 'Y'
        63: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.UNLIKELY,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        12: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.UNLIKELY,  # 'e'
        17: SequenceLikelihood.UNLIKELY,  # 'f'
        18: SequenceLikelihood.UNLIKELY,  # 'g'
        20: SequenceLikelihood.UNLIKELY,  # 'h'
        5: SequenceLikelihood.UNLIKELY,  # 'i'
        26: SequenceLikelihood.UNLIKELY,  # 'j'
        44: SequenceLikelihood.UNLIKELY,  # 'k'
        10: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        8: SequenceLikelihood.UNLIKELY,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        21: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        2: SequenceLikelihood.UNLIKELY,  # 's'
        6: SequenceLikelihood.UNLIKELY,  # 't'
        9: SequenceLikelihood.UNLIKELY,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        49: SequenceLikelihood.UNLIKELY,  # 'w'
        23: SequenceLikelihood.UNLIKELY,  # 'x'
        27: SequenceLikelihood.UNLIKELY,  # 'y'
        34: SequenceLikelihood.UNLIKELY,  # 'z'
        66: SequenceLikelihood.UNLIKELY,  # 'À'
        73: SequenceLikelihood.NEGATIVE,  # 'Â'
        83: SequenceLikelihood.NEGATIVE,  # 'Æ'
        69: SequenceLikelihood.NEGATIVE,  # 'Ç'
        70: SequenceLikelihood.NEGATIVE,  # 'È'
        58: SequenceLikelihood.UNLIKELY,  # 'É'
        72: SequenceLikelihood.NEGATIVE,  # 'Ê'
        80: SequenceLikelihood.NEGATIVE,  # 'Ë'
        71: SequenceLikelihood.NEGATIVE,  # 'Î'
        77: SequenceLikelihood.NEGATIVE,  # 'Ï'
        74: SequenceLikelihood.NEGATIVE,  # 'Ô'
        82: SequenceLikelihood.NEGATIVE,  # 'Ù'
        79: SequenceLikelihood.NEGATIVE,  # 'Û'
        78: SequenceLikelihood.NEGATIVE,  # 'Ü'
        22: SequenceLikelihood.UNLIKELY,  # 'à'
        53: SequenceLikelihood.NEGATIVE,  # 'â'
        76: SequenceLikelihood.NEGATIVE,  # 'æ'
        51: SequenceLikelihood.NEGATIVE,  # 'ç'
        28: SequenceLikelihood.UNLIKELY,  # 'è'
        15: SequenceLikelihood.UNLIKELY,  # 'é'
        41: SequenceLikelihood.NEGATIVE,  # 'ê'
        67: SequenceLikelihood.NEGATIVE,  # 'ë'
        57: SequenceLikelihood.NEGATIVE,  # 'î'
        65: SequenceLikelihood.NEGATIVE,  # 'ï'
        52: SequenceLikelihood.NEGATIVE,  # 'ô'
        62: SequenceLikelihood.NEGATIVE,  # 'ù'
        59: SequenceLikelihood.NEGATIVE,  # 'û'
        68: SequenceLikelihood.NEGATIVE,  # 'ü'
        81: SequenceLikelihood.NEGATIVE,  # 'ÿ'
        75: SequenceLikelihood.NEGATIVE,  # 'Œ'
        64: SequenceLikelihood.NEGATIVE,  # 'œ'
        84: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
    },
    60: {  # 'Y'
        29: SequenceLikelihood.UNLIKELY,  # 'A'
        40: SequenceLikelihood.UNLIKELY,  # 'B'
        25: SequenceLikelihood.UNLIKELY,  # 'C'
        35: SequenceLikelihood.UNLIKELY,  # 'D'
        31: SequenceLikelihood.UNLIKELY,  # 'E'
        42: SequenceLikelihood.UNLIKELY,  # 'F'
        47: SequenceLikelihood.UNLIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        48: SequenceLikelihood.UNLIKELY,  # 'J'
        56: SequenceLikelihood.UNLIKELY,  # 'K'
        24: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        43: SequenceLikelihood.UNLIKELY,  # 'O'
        32: SequenceLikelihood.UNLIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        38: SequenceLikelihood.UNLIKELY,  # 'R'
        30: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        46: SequenceLikelihood.UNLIKELY,  # 'U'
        45: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        61: SequenceLikelihood.UNLIKELY,  # 'X'
        60: SequenceLikelihood.UNLIKELY,  # 'Y'
        63: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.LIKELY,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        12: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.UNLIKELY,  # 'e'
        17: SequenceLikelihood.UNLIKELY,  # 'f'
        18: SequenceLikelihood.UNLIKELY,  # 'g'
        20: SequenceLikelihood.UNLIKELY,  # 'h'
        5: SequenceLikelihood.UNLIKELY,  # 'i'
        26: SequenceLikelihood.UNLIKELY,  # 'j'
        44: SequenceLikelihood.UNLIKELY,  # 'k'
        10: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        8: SequenceLikelihood.LIKELY,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        21: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        2: SequenceLikelihood.UNLIKELY,  # 's'
        6: SequenceLikelihood.UNLIKELY,  # 't'
        9: SequenceLikelihood.UNLIKELY,  # 'u'
        16: SequenceLikelihood.LIKELY,  # 'v'
        49: SequenceLikelihood.UNLIKELY,  # 'w'
        23: SequenceLikelihood.UNLIKELY,  # 'x'
        27: SequenceLikelihood.UNLIKELY,  # 'y'
        34: SequenceLikelihood.UNLIKELY,  # 'z'
        66: SequenceLikelihood.NEGATIVE,  # 'À'
        73: SequenceLikelihood.NEGATIVE,  # 'Â'
        83: SequenceLikelihood.NEGATIVE,  # 'Æ'
        69: SequenceLikelihood.NEGATIVE,  # 'Ç'
        70: SequenceLikelihood.UNLIKELY,  # 'È'
        58: SequenceLikelihood.UNLIKELY,  # 'É'
        72: SequenceLikelihood.NEGATIVE,  # 'Ê'
        80: SequenceLikelihood.NEGATIVE,  # 'Ë'
        71: SequenceLikelihood.NEGATIVE,  # 'Î'
        77: SequenceLikelihood.NEGATIVE,  # 'Ï'
        74: SequenceLikelihood.UNLIKELY,  # 'Ô'
        82: SequenceLikelihood.NEGATIVE,  # 'Ù'
        79: SequenceLikelihood.UNLIKELY,  # 'Û'
        78: SequenceLikelihood.NEGATIVE,  # 'Ü'
        22: SequenceLikelihood.UNLIKELY,  # 'à'
        53: SequenceLikelihood.UNLIKELY,  # 'â'
        76: SequenceLikelihood.NEGATIVE,  # 'æ'
        51: SequenceLikelihood.NEGATIVE,  # 'ç'
        28: SequenceLikelihood.UNLIKELY,  # 'è'
        15: SequenceLikelihood.UNLIKELY,  # 'é'
        41: SequenceLikelihood.UNLIKELY,  # 'ê'
        67: SequenceLikelihood.NEGATIVE,  # 'ë'
        57: SequenceLikelihood.NEGATIVE,  # 'î'
        65: SequenceLikelihood.UNLIKELY,  # 'ï'
        52: SequenceLikelihood.UNLIKELY,  # 'ô'
        62: SequenceLikelihood.NEGATIVE,  # 'ù'
        59: SequenceLikelihood.UNLIKELY,  # 'û'
        68: SequenceLikelihood.UNLIKELY,  # 'ü'
        81: SequenceLikelihood.NEGATIVE,  # 'ÿ'
        75: SequenceLikelihood.NEGATIVE,  # 'Œ'
        64: SequenceLikelihood.NEGATIVE,  # 'œ'
        84: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
    },
    63: {  # 'Z'
        29: SequenceLikelihood.UNLIKELY,  # 'A'
        40: SequenceLikelihood.UNLIKELY,  # 'B'
        25: SequenceLikelihood.UNLIKELY,  # 'C'
        35: SequenceLikelihood.UNLIKELY,  # 'D'
        31: SequenceLikelihood.UNLIKELY,  # 'E'
        42: SequenceLikelihood.UNLIKELY,  # 'F'
        47: SequenceLikelihood.UNLIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        48: SequenceLikelihood.UNLIKELY,  # 'J'
        56: SequenceLikelihood.UNLIKELY,  # 'K'
        24: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        43: SequenceLikelihood.UNLIKELY,  # 'O'
        32: SequenceLikelihood.UNLIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        38: SequenceLikelihood.UNLIKELY,  # 'R'
        30: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        46: SequenceLikelihood.UNLIKELY,  # 'U'
        45: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        61: SequenceLikelihood.UNLIKELY,  # 'X'
        60: SequenceLikelihood.UNLIKELY,  # 'Y'
        63: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.LIKELY,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        12: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.LIKELY,  # 'e'
        17: SequenceLikelihood.UNLIKELY,  # 'f'
        18: SequenceLikelihood.UNLIKELY,  # 'g'
        20: SequenceLikelihood.UNLIKELY,  # 'h'
        5: SequenceLikelihood.LIKELY,  # 'i'
        26: SequenceLikelihood.UNLIKELY,  # 'j'
        44: SequenceLikelihood.UNLIKELY,  # 'k'
        10: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        8: SequenceLikelihood.LIKELY,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        21: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        2: SequenceLikelihood.UNLIKELY,  # 's'
        6: SequenceLikelihood.UNLIKELY,  # 't'
        9: SequenceLikelihood.UNLIKELY,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        49: SequenceLikelihood.UNLIKELY,  # 'w'
        23: SequenceLikelihood.UNLIKELY,  # 'x'
        27: SequenceLikelihood.UNLIKELY,  # 'y'
        34: SequenceLikelihood.UNLIKELY,  # 'z'
        66: SequenceLikelihood.NEGATIVE,  # 'À'
        73: SequenceLikelihood.NEGATIVE,  # 'Â'
        83: SequenceLikelihood.UNLIKELY,  # 'Æ'
        69: SequenceLikelihood.NEGATIVE,  # 'Ç'
        70: SequenceLikelihood.UNLIKELY,  # 'È'
        58: SequenceLikelihood.UNLIKELY,  # 'É'
        72: SequenceLikelihood.NEGATIVE,  # 'Ê'
        80: SequenceLikelihood.NEGATIVE,  # 'Ë'
        71: SequenceLikelihood.NEGATIVE,  # 'Î'
        77: SequenceLikelihood.NEGATIVE,  # 'Ï'
        74: SequenceLikelihood.NEGATIVE,  # 'Ô'
        82: SequenceLikelihood.NEGATIVE,  # 'Ù'
        79: SequenceLikelihood.NEGATIVE,  # 'Û'
        78: SequenceLikelihood.UNLIKELY,  # 'Ü'
        22: SequenceLikelihood.UNLIKELY,  # 'à'
        53: SequenceLikelihood.UNLIKELY,  # 'â'
        76: SequenceLikelihood.NEGATIVE,  # 'æ'
        51: SequenceLikelihood.NEGATIVE,  # 'ç'
        28: SequenceLikelihood.UNLIKELY,  # 'è'
        15: SequenceLikelihood.UNLIKELY,  # 'é'
        41: SequenceLikelihood.UNLIKELY,  # 'ê'
        67: SequenceLikelihood.NEGATIVE,  # 'ë'
        57: SequenceLikelihood.UNLIKELY,  # 'î'
        65: SequenceLikelihood.UNLIKELY,  # 'ï'
        52: SequenceLikelihood.UNLIKELY,  # 'ô'
        62: SequenceLikelihood.NEGATIVE,  # 'ù'
        59: SequenceLikelihood.NEGATIVE,  # 'û'
        68: SequenceLikelihood.UNLIKELY,  # 'ü'
        81: SequenceLikelihood.NEGATIVE,  # 'ÿ'
        75: SequenceLikelihood.NEGATIVE,  # 'Œ'
        64: SequenceLikelihood.NEGATIVE,  # 'œ'
        84: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
    },
    3: {  # 'a'
        29: SequenceLikelihood.UNLIKELY,  # 'A'
        40: SequenceLikelihood.UNLIKELY,  # 'B'
        25: SequenceLikelihood.UNLIKELY,  # 'C'
        35: SequenceLikelihood.UNLIKELY,  # 'D'
        31: SequenceLikelihood.UNLIKELY,  # 'E'
        42: SequenceLikelihood.UNLIKELY,  # 'F'
        47: SequenceLikelihood.UNLIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        48: SequenceLikelihood.UNLIKELY,  # 'J'
        56: SequenceLikelihood.UNLIKELY,  # 'K'
        24: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        43: SequenceLikelihood.UNLIKELY,  # 'O'
        32: SequenceLikelihood.UNLIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        38: SequenceLikelihood.UNLIKELY,  # 'R'
        30: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        46: SequenceLikelihood.UNLIKELY,  # 'U'
        45: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        61: SequenceLikelihood.UNLIKELY,  # 'X'
        60: SequenceLikelihood.UNLIKELY,  # 'Y'
        63: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.LIKELY,  # 'a'
        19: SequenceLikelihood.POSITIVE,  # 'b'
        12: SequenceLikelihood.POSITIVE,  # 'c'
        11: SequenceLikelihood.POSITIVE,  # 'd'
        1: SequenceLikelihood.LIKELY,  # 'e'
        17: SequenceLikelihood.POSITIVE,  # 'f'
        18: SequenceLikelihood.POSITIVE,  # 'g'
        20: SequenceLikelihood.POSITIVE,  # 'h'
        5: SequenceLikelihood.POSITIVE,  # 'i'
        26: SequenceLikelihood.POSITIVE,  # 'j'
        44: SequenceLikelihood.POSITIVE,  # 'k'
        10: SequenceLikelihood.POSITIVE,  # 'l'
        14: SequenceLikelihood.POSITIVE,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        8: SequenceLikelihood.POSITIVE,  # 'o'
        13: SequenceLikelihood.POSITIVE,  # 'p'
        21: SequenceLikelihood.POSITIVE,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        2: SequenceLikelihood.POSITIVE,  # 's'
        6: SequenceLikelihood.POSITIVE,  # 't'
        9: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.POSITIVE,  # 'v'
        49: SequenceLikelihood.LIKELY,  # 'w'
        23: SequenceLikelihood.POSITIVE,  # 'x'
        27: SequenceLikelihood.POSITIVE,  # 'y'
        34: SequenceLikelihood.POSITIVE,  # 'z'
        66: SequenceLikelihood.UNLIKELY,  # 'À'
        73: SequenceLikelihood.UNLIKELY,  # 'Â'
        83: SequenceLikelihood.NEGATIVE,  # 'Æ'
        69: SequenceLikelihood.UNLIKELY,  # 'Ç'
        70: SequenceLikelihood.NEGATIVE,  # 'È'
        58: SequenceLikelihood.UNLIKELY,  # 'É'
        72: SequenceLikelihood.NEGATIVE,  # 'Ê'
        80: SequenceLikelihood.UNLIKELY,  # 'Ë'
        71: SequenceLikelihood.UNLIKELY,  # 'Î'
        77: SequenceLikelihood.UNLIKELY,  # 'Ï'
        74: SequenceLikelihood.NEGATIVE,  # 'Ô'
        82: SequenceLikelihood.UNLIKELY,  # 'Ù'
        79: SequenceLikelihood.NEGATIVE,  # 'Û'
        78: SequenceLikelihood.NEGATIVE,  # 'Ü'
        22: SequenceLikelihood.UNLIKELY,  # 'à'
        53: SequenceLikelihood.UNLIKELY,  # 'â'
        76: SequenceLikelihood.NEGATIVE,  # 'æ'
        51: SequenceLikelihood.POSITIVE,  # 'ç'
        28: SequenceLikelihood.UNLIKELY,  # 'è'
        15: SequenceLikelihood.LIKELY,  # 'é'
        41: SequenceLikelihood.UNLIKELY,  # 'ê'
        67: SequenceLikelihood.LIKELY,  # 'ë'
        57: SequenceLikelihood.POSITIVE,  # 'î'
        65: SequenceLikelihood.LIKELY,  # 'ï'
        52: SequenceLikelihood.UNLIKELY,  # 'ô'
        62: SequenceLikelihood.UNLIKELY,  # 'ù'
        59: SequenceLikelihood.UNLIKELY,  # 'û'
        68: SequenceLikelihood.UNLIKELY,  # 'ü'
        81: SequenceLikelihood.UNLIKELY,  # 'ÿ'
        75: SequenceLikelihood.UNLIKELY,  # 'Œ'
        64: SequenceLikelihood.UNLIKELY,  # 'œ'
        84: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
    },
    19: {  # 'b'
        29: SequenceLikelihood.UNLIKELY,  # 'A'
        40: SequenceLikelihood.UNLIKELY,  # 'B'
        25: SequenceLikelihood.UNLIKELY,  # 'C'
        35: SequenceLikelihood.UNLIKELY,  # 'D'
        31: SequenceLikelihood.UNLIKELY,  # 'E'
        42: SequenceLikelihood.UNLIKELY,  # 'F'
        47: SequenceLikelihood.UNLIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        48: SequenceLikelihood.UNLIKELY,  # 'J'
        56: SequenceLikelihood.UNLIKELY,  # 'K'
        24: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        43: SequenceLikelihood.UNLIKELY,  # 'O'
        32: SequenceLikelihood.UNLIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        38: SequenceLikelihood.UNLIKELY,  # 'R'
        30: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        46: SequenceLikelihood.UNLIKELY,  # 'U'
        45: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        61: SequenceLikelihood.UNLIKELY,  # 'X'
        60: SequenceLikelihood.UNLIKELY,  # 'Y'
        63: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.LIKELY,  # 'b'
        12: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.LIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        17: SequenceLikelihood.UNLIKELY,  # 'f'
        18: SequenceLikelihood.UNLIKELY,  # 'g'
        20: SequenceLikelihood.UNLIKELY,  # 'h'
        5: SequenceLikelihood.POSITIVE,  # 'i'
        26: SequenceLikelihood.POSITIVE,  # 'j'
        44: SequenceLikelihood.UNLIKELY,  # 'k'
        10: SequenceLikelihood.POSITIVE,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        8: SequenceLikelihood.POSITIVE,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        21: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        2: SequenceLikelihood.POSITIVE,  # 's'
        6: SequenceLikelihood.POSITIVE,  # 't'
        9: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        49: SequenceLikelihood.UNLIKELY,  # 'w'
        23: SequenceLikelihood.UNLIKELY,  # 'x'
        27: SequenceLikelihood.LIKELY,  # 'y'
        34: SequenceLikelihood.UNLIKELY,  # 'z'
        66: SequenceLikelihood.UNLIKELY,  # 'À'
        73: SequenceLikelihood.UNLIKELY,  # 'Â'
        83: SequenceLikelihood.NEGATIVE,  # 'Æ'
        69: SequenceLikelihood.NEGATIVE,  # 'Ç'
        70: SequenceLikelihood.NEGATIVE,  # 'È'
        58: SequenceLikelihood.UNLIKELY,  # 'É'
        72: SequenceLikelihood.NEGATIVE,  # 'Ê'
        80: SequenceLikelihood.NEGATIVE,  # 'Ë'
        71: SequenceLikelihood.NEGATIVE,  # 'Î'
        77: SequenceLikelihood.NEGATIVE,  # 'Ï'
        74: SequenceLikelihood.NEGATIVE,  # 'Ô'
        82: SequenceLikelihood.NEGATIVE,  # 'Ù'
        79: SequenceLikelihood.NEGATIVE,  # 'Û'
        78: SequenceLikelihood.NEGATIVE,  # 'Ü'
        22: SequenceLikelihood.UNLIKELY,  # 'à'
        53: SequenceLikelihood.LIKELY,  # 'â'
        76: SequenceLikelihood.UNLIKELY,  # 'æ'
        51: SequenceLikelihood.NEGATIVE,  # 'ç'
        28: SequenceLikelihood.LIKELY,  # 'è'
        15: SequenceLikelihood.POSITIVE,  # 'é'
        41: SequenceLikelihood.LIKELY,  # 'ê'
        67: SequenceLikelihood.UNLIKELY,  # 'ë'
        57: SequenceLikelihood.UNLIKELY,  # 'î'
        65: SequenceLikelihood.UNLIKELY,  # 'ï'
        52: SequenceLikelihood.UNLIKELY,  # 'ô'
        62: SequenceLikelihood.UNLIKELY,  # 'ù'
        59: SequenceLikelihood.UNLIKELY,  # 'û'
        68: SequenceLikelihood.UNLIKELY,  # 'ü'
        81: SequenceLikelihood.NEGATIVE,  # 'ÿ'
        75: SequenceLikelihood.NEGATIVE,  # 'Œ'
        64: SequenceLikelihood.UNLIKELY,  # 'œ'
        84: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
    },
    12: {  # 'c'
        29: SequenceLikelihood.UNLIKELY,  # 'A'
        40: SequenceLikelihood.UNLIKELY,  # 'B'
        25: SequenceLikelihood.UNLIKELY,  # 'C'
        35: SequenceLikelihood.UNLIKELY,  # 'D'
        31: SequenceLikelihood.UNLIKELY,  # 'E'
        42: SequenceLikelihood.UNLIKELY,  # 'F'
        47: SequenceLikelihood.UNLIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        48: SequenceLikelihood.UNLIKELY,  # 'J'
        56: SequenceLikelihood.UNLIKELY,  # 'K'
        24: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        43: SequenceLikelihood.UNLIKELY,  # 'O'
        32: SequenceLikelihood.UNLIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        38: SequenceLikelihood.UNLIKELY,  # 'R'
        30: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        46: SequenceLikelihood.UNLIKELY,  # 'U'
        45: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        61: SequenceLikelihood.UNLIKELY,  # 'X'
        60: SequenceLikelihood.UNLIKELY,  # 'Y'
        63: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        12: SequenceLikelihood.POSITIVE,  # 'c'
        11: SequenceLikelihood.LIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        17: SequenceLikelihood.UNLIKELY,  # 'f'
        18: SequenceLikelihood.UNLIKELY,  # 'g'
        20: SequenceLikelihood.POSITIVE,  # 'h'
        5: SequenceLikelihood.POSITIVE,  # 'i'
        26: SequenceLikelihood.UNLIKELY,  # 'j'
        44: SequenceLikelihood.POSITIVE,  # 'k'
        10: SequenceLikelihood.POSITIVE,  # 'l'
        14: SequenceLikelihood.LIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        8: SequenceLikelihood.POSITIVE,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        21: SequenceLikelihood.LIKELY,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        2: SequenceLikelihood.POSITIVE,  # 's'
        6: SequenceLikelihood.POSITIVE,  # 't'
        9: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.POSITIVE,  # 'v'
        49: SequenceLikelihood.UNLIKELY,  # 'w'
        23: SequenceLikelihood.UNLIKELY,  # 'x'
        27: SequenceLikelihood.POSITIVE,  # 'y'
        34: SequenceLikelihood.UNLIKELY,  # 'z'
        66: SequenceLikelihood.UNLIKELY,  # 'À'
        73: SequenceLikelihood.NEGATIVE,  # 'Â'
        83: SequenceLikelihood.NEGATIVE,  # 'Æ'
        69: SequenceLikelihood.NEGATIVE,  # 'Ç'
        70: SequenceLikelihood.UNLIKELY,  # 'È'
        58: SequenceLikelihood.UNLIKELY,  # 'É'
        72: SequenceLikelihood.NEGATIVE,  # 'Ê'
        80: SequenceLikelihood.NEGATIVE,  # 'Ë'
        71: SequenceLikelihood.NEGATIVE,  # 'Î'
        77: SequenceLikelihood.NEGATIVE,  # 'Ï'
        74: SequenceLikelihood.NEGATIVE,  # 'Ô'
        82: SequenceLikelihood.NEGATIVE,  # 'Ù'
        79: SequenceLikelihood.NEGATIVE,  # 'Û'
        78: SequenceLikelihood.NEGATIVE,  # 'Ü'
        22: SequenceLikelihood.UNLIKELY,  # 'à'
        53: SequenceLikelihood.LIKELY,  # 'â'
        76: SequenceLikelihood.UNLIKELY,  # 'æ'
        51: SequenceLikelihood.UNLIKELY,  # 'ç'
        28: SequenceLikelihood.POSITIVE,  # 'è'
        15: SequenceLikelihood.POSITIVE,  # 'é'
        41: SequenceLikelihood.UNLIKELY,  # 'ê'
        67: SequenceLikelihood.UNLIKELY,  # 'ë'
        57: SequenceLikelihood.UNLIKELY,  # 'î'
        65: SequenceLikelihood.NEGATIVE,  # 'ï'
        52: SequenceLikelihood.POSITIVE,  # 'ô'
        62: SequenceLikelihood.UNLIKELY,  # 'ù'
        59: SequenceLikelihood.UNLIKELY,  # 'û'
        68: SequenceLikelihood.UNLIKELY,  # 'ü'
        81: SequenceLikelihood.NEGATIVE,  # 'ÿ'
        75: SequenceLikelihood.NEGATIVE,  # 'Œ'
        64: SequenceLikelihood.LIKELY,  # 'œ'
        84: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
    },
    11: {  # 'd'
        29: SequenceLikelihood.UNLIKELY,  # 'A'
        40: SequenceLikelihood.UNLIKELY,  # 'B'
        25: SequenceLikelihood.UNLIKELY,  # 'C'
        35: SequenceLikelihood.UNLIKELY,  # 'D'
        31: SequenceLikelihood.UNLIKELY,  # 'E'
        42: SequenceLikelihood.UNLIKELY,  # 'F'
        47: SequenceLikelihood.UNLIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        48: SequenceLikelihood.UNLIKELY,  # 'J'
        56: SequenceLikelihood.UNLIKELY,  # 'K'
        24: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        43: SequenceLikelihood.UNLIKELY,  # 'O'
        32: SequenceLikelihood.UNLIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        38: SequenceLikelihood.UNLIKELY,  # 'R'
        30: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        46: SequenceLikelihood.UNLIKELY,  # 'U'
        45: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        61: SequenceLikelihood.UNLIKELY,  # 'X'
        60: SequenceLikelihood.UNLIKELY,  # 'Y'
        63: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.LIKELY,  # 'b'
        12: SequenceLikelihood.LIKELY,  # 'c'
        11: SequenceLikelihood.LIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        17: SequenceLikelihood.LIKELY,  # 'f'
        18: SequenceLikelihood.LIKELY,  # 'g'
        20: SequenceLikelihood.LIKELY,  # 'h'
        5: SequenceLikelihood.POSITIVE,  # 'i'
        26: SequenceLikelihood.LIKELY,  # 'j'
        44: SequenceLikelihood.UNLIKELY,  # 'k'
        10: SequenceLikelihood.LIKELY,  # 'l'
        14: SequenceLikelihood.POSITIVE,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        8: SequenceLikelihood.POSITIVE,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        21: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        2: SequenceLikelihood.POSITIVE,  # 's'
        6: SequenceLikelihood.LIKELY,  # 't'
        9: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.LIKELY,  # 'v'
        49: SequenceLikelihood.LIKELY,  # 'w'
        23: SequenceLikelihood.UNLIKELY,  # 'x'
        27: SequenceLikelihood.LIKELY,  # 'y'
        34: SequenceLikelihood.UNLIKELY,  # 'z'
        66: SequenceLikelihood.UNLIKELY,  # 'À'
        73: SequenceLikelihood.UNLIKELY,  # 'Â'
        83: SequenceLikelihood.NEGATIVE,  # 'Æ'
        69: SequenceLikelihood.NEGATIVE,  # 'Ç'
        70: SequenceLikelihood.UNLIKELY,  # 'È'
        58: SequenceLikelihood.UNLIKELY,  # 'É'
        72: SequenceLikelihood.UNLIKELY,  # 'Ê'
        80: SequenceLikelihood.NEGATIVE,  # 'Ë'
        71: SequenceLikelihood.UNLIKELY,  # 'Î'
        77: SequenceLikelihood.NEGATIVE,  # 'Ï'
        74: SequenceLikelihood.NEGATIVE,  # 'Ô'
        82: SequenceLikelihood.NEGATIVE,  # 'Ù'
        79: SequenceLikelihood.NEGATIVE,  # 'Û'
        78: SequenceLikelihood.NEGATIVE,  # 'Ü'
        22: SequenceLikelihood.UNLIKELY,  # 'à'
        53: SequenceLikelihood.UNLIKELY,  # 'â'
        76: SequenceLikelihood.NEGATIVE,  # 'æ'
        51: SequenceLikelihood.NEGATIVE,  # 'ç'
        28: SequenceLikelihood.POSITIVE,  # 'è'
        15: SequenceLikelihood.POSITIVE,  # 'é'
        41: SequenceLikelihood.UNLIKELY,  # 'ê'
        67: SequenceLikelihood.UNLIKELY,  # 'ë'
        57: SequenceLikelihood.UNLIKELY,  # 'î'
        65: SequenceLikelihood.UNLIKELY,  # 'ï'
        52: SequenceLikelihood.UNLIKELY,  # 'ô'
        62: SequenceLikelihood.UNLIKELY,  # 'ù'
        59: SequenceLikelihood.LIKELY,  # 'û'
        68: SequenceLikelihood.UNLIKELY,  # 'ü'
        81: SequenceLikelihood.UNLIKELY,  # 'ÿ'
        75: SequenceLikelihood.UNLIKELY,  # 'Œ'
        64: SequenceLikelihood.UNLIKELY,  # 'œ'
        84: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
    },
    1: {  # 'e'
        29: SequenceLikelihood.UNLIKELY,  # 'A'
        40: SequenceLikelihood.UNLIKELY,  # 'B'
        25: SequenceLikelihood.UNLIKELY,  # 'C'
        35: SequenceLikelihood.UNLIKELY,  # 'D'
        31: SequenceLikelihood.UNLIKELY,  # 'E'
        42: SequenceLikelihood.UNLIKELY,  # 'F'
        47: SequenceLikelihood.UNLIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        48: SequenceLikelihood.UNLIKELY,  # 'J'
        56: SequenceLikelihood.UNLIKELY,  # 'K'
        24: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        43: SequenceLikelihood.UNLIKELY,  # 'O'
        32: SequenceLikelihood.UNLIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        38: SequenceLikelihood.UNLIKELY,  # 'R'
        30: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        46: SequenceLikelihood.UNLIKELY,  # 'U'
        45: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        61: SequenceLikelihood.UNLIKELY,  # 'X'
        60: SequenceLikelihood.UNLIKELY,  # 'Y'
        63: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.POSITIVE,  # 'b'
        12: SequenceLikelihood.POSITIVE,  # 'c'
        11: SequenceLikelihood.POSITIVE,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        17: SequenceLikelihood.POSITIVE,  # 'f'
        18: SequenceLikelihood.POSITIVE,  # 'g'
        20: SequenceLikelihood.LIKELY,  # 'h'
        5: SequenceLikelihood.POSITIVE,  # 'i'
        26: SequenceLikelihood.LIKELY,  # 'j'
        44: SequenceLikelihood.LIKELY,  # 'k'
        10: SequenceLikelihood.POSITIVE,  # 'l'
        14: SequenceLikelihood.POSITIVE,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        8: SequenceLikelihood.POSITIVE,  # 'o'
        13: SequenceLikelihood.POSITIVE,  # 'p'
        21: SequenceLikelihood.LIKELY,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        2: SequenceLikelihood.POSITIVE,  # 's'
        6: SequenceLikelihood.POSITIVE,  # 't'
        9: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.POSITIVE,  # 'v'
        49: SequenceLikelihood.POSITIVE,  # 'w'
        23: SequenceLikelihood.POSITIVE,  # 'x'
        27: SequenceLikelihood.POSITIVE,  # 'y'
        34: SequenceLikelihood.POSITIVE,  # 'z'
        66: SequenceLikelihood.UNLIKELY,  # 'À'
        73: SequenceLikelihood.UNLIKELY,  # 'Â'
        83: SequenceLikelihood.UNLIKELY,  # 'Æ'
        69: SequenceLikelihood.UNLIKELY,  # 'Ç'
        70: SequenceLikelihood.UNLIKELY,  # 'È'
        58: SequenceLikelihood.UNLIKELY,  # 'É'
        72: SequenceLikelihood.NEGATIVE,  # 'Ê'
        80: SequenceLikelihood.UNLIKELY,  # 'Ë'
        71: SequenceLikelihood.UNLIKELY,  # 'Î'
        77: SequenceLikelihood.NEGATIVE,  # 'Ï'
        74: SequenceLikelihood.NEGATIVE,  # 'Ô'
        82: SequenceLikelihood.NEGATIVE,  # 'Ù'
        79: SequenceLikelihood.NEGATIVE,  # 'Û'
        78: SequenceLikelihood.UNLIKELY,  # 'Ü'
        22: SequenceLikelihood.UNLIKELY,  # 'à'
        53: SequenceLikelihood.UNLIKELY,  # 'â'
        76: SequenceLikelihood.UNLIKELY,  # 'æ'
        51: SequenceLikelihood.LIKELY,  # 'ç'
        28: SequenceLikelihood.UNLIKELY,  # 'è'
        15: SequenceLikelihood.UNLIKELY,  # 'é'
        41: SequenceLikelihood.UNLIKELY,  # 'ê'
        67: SequenceLikelihood.UNLIKELY,  # 'ë'
        57: SequenceLikelihood.UNLIKELY,  # 'î'
        65: SequenceLikelihood.UNLIKELY,  # 'ï'
        52: SequenceLikelihood.UNLIKELY,  # 'ô'
        62: SequenceLikelihood.UNLIKELY,  # 'ù'
        59: SequenceLikelihood.UNLIKELY,  # 'û'
        68: SequenceLikelihood.UNLIKELY,  # 'ü'
        81: SequenceLikelihood.UNLIKELY,  # 'ÿ'
        75: SequenceLikelihood.UNLIKELY,  # 'Œ'
        64: SequenceLikelihood.UNLIKELY,  # 'œ'
        84: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
    },
    17: {  # 'f'
        29: SequenceLikelihood.UNLIKELY,  # 'A'
        40: SequenceLikelihood.UNLIKELY,  # 'B'
        25: SequenceLikelihood.UNLIKELY,  # 'C'
        35: SequenceLikelihood.UNLIKELY,  # 'D'
        31: SequenceLikelihood.UNLIKELY,  # 'E'
        42: SequenceLikelihood.UNLIKELY,  # 'F'
        47: SequenceLikelihood.UNLIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        48: SequenceLikelihood.UNLIKELY,  # 'J'
        56: SequenceLikelihood.UNLIKELY,  # 'K'
        24: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        43: SequenceLikelihood.UNLIKELY,  # 'O'
        32: SequenceLikelihood.UNLIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        38: SequenceLikelihood.UNLIKELY,  # 'R'
        30: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        46: SequenceLikelihood.UNLIKELY,  # 'U'
        45: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        61: SequenceLikelihood.UNLIKELY,  # 'X'
        60: SequenceLikelihood.UNLIKELY,  # 'Y'
        63: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        12: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        17: SequenceLikelihood.POSITIVE,  # 'f'
        18: SequenceLikelihood.UNLIKELY,  # 'g'
        20: SequenceLikelihood.UNLIKELY,  # 'h'
        5: SequenceLikelihood.POSITIVE,  # 'i'
        26: SequenceLikelihood.UNLIKELY,  # 'j'
        44: SequenceLikelihood.UNLIKELY,  # 'k'
        10: SequenceLikelihood.POSITIVE,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        8: SequenceLikelihood.POSITIVE,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        21: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        2: SequenceLikelihood.POSITIVE,  # 's'
        6: SequenceLikelihood.LIKELY,  # 't'
        9: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        49: SequenceLikelihood.UNLIKELY,  # 'w'
        23: SequenceLikelihood.UNLIKELY,  # 'x'
        27: SequenceLikelihood.UNLIKELY,  # 'y'
        34: SequenceLikelihood.UNLIKELY,  # 'z'
        66: SequenceLikelihood.NEGATIVE,  # 'À'
        73: SequenceLikelihood.NEGATIVE,  # 'Â'
        83: SequenceLikelihood.NEGATIVE,  # 'Æ'
        69: SequenceLikelihood.NEGATIVE,  # 'Ç'
        70: SequenceLikelihood.NEGATIVE,  # 'È'
        58: SequenceLikelihood.UNLIKELY,  # 'É'
        72: SequenceLikelihood.UNLIKELY,  # 'Ê'
        80: SequenceLikelihood.NEGATIVE,  # 'Ë'
        71: SequenceLikelihood.NEGATIVE,  # 'Î'
        77: SequenceLikelihood.NEGATIVE,  # 'Ï'
        74: SequenceLikelihood.NEGATIVE,  # 'Ô'
        82: SequenceLikelihood.NEGATIVE,  # 'Ù'
        79: SequenceLikelihood.NEGATIVE,  # 'Û'
        78: SequenceLikelihood.NEGATIVE,  # 'Ü'
        22: SequenceLikelihood.UNLIKELY,  # 'à'
        53: SequenceLikelihood.UNLIKELY,  # 'â'
        76: SequenceLikelihood.UNLIKELY,  # 'æ'
        51: SequenceLikelihood.NEGATIVE,  # 'ç'
        28: SequenceLikelihood.LIKELY,  # 'è'
        15: SequenceLikelihood.POSITIVE,  # 'é'
        41: SequenceLikelihood.LIKELY,  # 'ê'
        67: SequenceLikelihood.UNLIKELY,  # 'ë'
        57: SequenceLikelihood.UNLIKELY,  # 'î'
        65: SequenceLikelihood.UNLIKELY,  # 'ï'
        52: SequenceLikelihood.UNLIKELY,  # 'ô'
        62: SequenceLikelihood.UNLIKELY,  # 'ù'
        59: SequenceLikelihood.UNLIKELY,  # 'û'
        68: SequenceLikelihood.UNLIKELY,  # 'ü'
        81: SequenceLikelihood.NEGATIVE,  # 'ÿ'
        75: SequenceLikelihood.NEGATIVE,  # 'Œ'
        64: SequenceLikelihood.UNLIKELY,  # 'œ'
        84: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
    },
    18: {  # 'g'
        29: SequenceLikelihood.UNLIKELY,  # 'A'
        40: SequenceLikelihood.UNLIKELY,  # 'B'
        25: SequenceLikelihood.UNLIKELY,  # 'C'
        35: SequenceLikelihood.UNLIKELY,  # 'D'
        31: SequenceLikelihood.UNLIKELY,  # 'E'
        42: SequenceLikelihood.UNLIKELY,  # 'F'
        47: SequenceLikelihood.UNLIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        48: SequenceLikelihood.UNLIKELY,  # 'J'
        56: SequenceLikelihood.UNLIKELY,  # 'K'
        24: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        43: SequenceLikelihood.UNLIKELY,  # 'O'
        32: SequenceLikelihood.UNLIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        38: SequenceLikelihood.UNLIKELY,  # 'R'
        30: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        46: SequenceLikelihood.UNLIKELY,  # 'U'
        45: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        61: SequenceLikelihood.UNLIKELY,  # 'X'
        60: SequenceLikelihood.UNLIKELY,  # 'Y'
        63: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.LIKELY,  # 'b'
        12: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        17: SequenceLikelihood.UNLIKELY,  # 'f'
        18: SequenceLikelihood.LIKELY,  # 'g'
        20: SequenceLikelihood.POSITIVE,  # 'h'
        5: SequenceLikelihood.POSITIVE,  # 'i'
        26: SequenceLikelihood.UNLIKELY,  # 'j'
        44: SequenceLikelihood.UNLIKELY,  # 'k'
        10: SequenceLikelihood.POSITIVE,  # 'l'
        14: SequenceLikelihood.POSITIVE,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        8: SequenceLikelihood.POSITIVE,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        21: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        2: SequenceLikelihood.LIKELY,  # 's'
        6: SequenceLikelihood.LIKELY,  # 't'
        9: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        49: SequenceLikelihood.UNLIKELY,  # 'w'
        23: SequenceLikelihood.UNLIKELY,  # 'x'
        27: SequenceLikelihood.LIKELY,  # 'y'
        34: SequenceLikelihood.UNLIKELY,  # 'z'
        66: SequenceLikelihood.UNLIKELY,  # 'À'
        73: SequenceLikelihood.UNLIKELY,  # 'Â'
        83: SequenceLikelihood.NEGATIVE,  # 'Æ'
        69: SequenceLikelihood.NEGATIVE,  # 'Ç'
        70: SequenceLikelihood.NEGATIVE,  # 'È'
        58: SequenceLikelihood.UNLIKELY,  # 'É'
        72: SequenceLikelihood.NEGATIVE,  # 'Ê'
        80: SequenceLikelihood.NEGATIVE,  # 'Ë'
        71: SequenceLikelihood.NEGATIVE,  # 'Î'
        77: SequenceLikelihood.NEGATIVE,  # 'Ï'
        74: SequenceLikelihood.UNLIKELY,  # 'Ô'
        82: SequenceLikelihood.NEGATIVE,  # 'Ù'
        79: SequenceLikelihood.NEGATIVE,  # 'Û'
        78: SequenceLikelihood.NEGATIVE,  # 'Ü'
        22: SequenceLikelihood.UNLIKELY,  # 'à'
        53: SequenceLikelihood.LIKELY,  # 'â'
        76: SequenceLikelihood.UNLIKELY,  # 'æ'
        51: SequenceLikelihood.UNLIKELY,  # 'ç'
        28: SequenceLikelihood.POSITIVE,  # 'è'
        15: SequenceLikelihood.POSITIVE,  # 'é'
        41: SequenceLikelihood.UNLIKELY,  # 'ê'
        67: SequenceLikelihood.UNLIKELY,  # 'ë'
        57: SequenceLikelihood.UNLIKELY,  # 'î'
        65: SequenceLikelihood.UNLIKELY,  # 'ï'
        52: SequenceLikelihood.UNLIKELY,  # 'ô'
        62: SequenceLikelihood.UNLIKELY,  # 'ù'
        59: SequenceLikelihood.UNLIKELY,  # 'û'
        68: SequenceLikelihood.UNLIKELY,  # 'ü'
        81: SequenceLikelihood.NEGATIVE,  # 'ÿ'
        75: SequenceLikelihood.NEGATIVE,  # 'Œ'
        64: SequenceLikelihood.UNLIKELY,  # 'œ'
        84: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
    },
    20: {  # 'h'
        29: SequenceLikelihood.UNLIKELY,  # 'A'
        40: SequenceLikelihood.UNLIKELY,  # 'B'
        25: SequenceLikelihood.UNLIKELY,  # 'C'
        35: SequenceLikelihood.UNLIKELY,  # 'D'
        31: SequenceLikelihood.UNLIKELY,  # 'E'
        42: SequenceLikelihood.UNLIKELY,  # 'F'
        47: SequenceLikelihood.UNLIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        48: SequenceLikelihood.UNLIKELY,  # 'J'
        56: SequenceLikelihood.UNLIKELY,  # 'K'
        24: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        43: SequenceLikelihood.UNLIKELY,  # 'O'
        32: SequenceLikelihood.UNLIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        38: SequenceLikelihood.UNLIKELY,  # 'R'
        30: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        46: SequenceLikelihood.UNLIKELY,  # 'U'
        45: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        61: SequenceLikelihood.UNLIKELY,  # 'X'
        60: SequenceLikelihood.UNLIKELY,  # 'Y'
        63: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        12: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        17: SequenceLikelihood.UNLIKELY,  # 'f'
        18: SequenceLikelihood.UNLIKELY,  # 'g'
        20: SequenceLikelihood.UNLIKELY,  # 'h'
        5: SequenceLikelihood.POSITIVE,  # 'i'
        26: SequenceLikelihood.UNLIKELY,  # 'j'
        44: SequenceLikelihood.UNLIKELY,  # 'k'
        10: SequenceLikelihood.LIKELY,  # 'l'
        14: SequenceLikelihood.LIKELY,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        8: SequenceLikelihood.POSITIVE,  # 'o'
        13: SequenceLikelihood.LIKELY,  # 'p'
        21: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        2: SequenceLikelihood.LIKELY,  # 's'
        6: SequenceLikelihood.POSITIVE,  # 't'
        9: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        49: SequenceLikelihood.UNLIKELY,  # 'w'
        23: SequenceLikelihood.UNLIKELY,  # 'x'
        27: SequenceLikelihood.POSITIVE,  # 'y'
        34: SequenceLikelihood.UNLIKELY,  # 'z'
        66: SequenceLikelihood.NEGATIVE,  # 'À'
        73: SequenceLikelihood.UNLIKELY,  # 'Â'
        83: SequenceLikelihood.NEGATIVE,  # 'Æ'
        69: SequenceLikelihood.NEGATIVE,  # 'Ç'
        70: SequenceLikelihood.UNLIKELY,  # 'È'
        58: SequenceLikelihood.UNLIKELY,  # 'É'
        72: SequenceLikelihood.UNLIKELY,  # 'Ê'
        80: SequenceLikelihood.NEGATIVE,  # 'Ë'
        71: SequenceLikelihood.NEGATIVE,  # 'Î'
        77: SequenceLikelihood.NEGATIVE,  # 'Ï'
        74: SequenceLikelihood.NEGATIVE,  # 'Ô'
        82: SequenceLikelihood.UNLIKELY,  # 'Ù'
        79: SequenceLikelihood.NEGATIVE,  # 'Û'
        78: SequenceLikelihood.UNLIKELY,  # 'Ü'
        22: SequenceLikelihood.UNLIKELY,  # 'à'
        53: SequenceLikelihood.LIKELY,  # 'â'
        76: SequenceLikelihood.UNLIKELY,  # 'æ'
        51: SequenceLikelihood.UNLIKELY,  # 'ç'
        28: SequenceLikelihood.POSITIVE,  # 'è'
        15: SequenceLikelihood.POSITIVE,  # 'é'
        41: SequenceLikelihood.UNLIKELY,  # 'ê'
        67: SequenceLikelihood.UNLIKELY,  # 'ë'
        57: SequenceLikelihood.UNLIKELY,  # 'î'
        65: SequenceLikelihood.UNLIKELY,  # 'ï'
        52: SequenceLikelihood.POSITIVE,  # 'ô'
        62: SequenceLikelihood.UNLIKELY,  # 'ù'
        59: SequenceLikelihood.UNLIKELY,  # 'û'
        68: SequenceLikelihood.UNLIKELY,  # 'ü'
        81: SequenceLikelihood.NEGATIVE,  # 'ÿ'
        75: SequenceLikelihood.NEGATIVE,  # 'Œ'
        64: SequenceLikelihood.UNLIKELY,  # 'œ'
        84: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
    },
    5: {  # 'i'
        29: SequenceLikelihood.UNLIKELY,  # 'A'
        40: SequenceLikelihood.UNLIKELY,  # 'B'
        25: SequenceLikelihood.UNLIKELY,  # 'C'
        35: SequenceLikelihood.UNLIKELY,  # 'D'
        31: SequenceLikelihood.UNLIKELY,  # 'E'
        42: SequenceLikelihood.UNLIKELY,  # 'F'
        47: SequenceLikelihood.UNLIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        48: SequenceLikelihood.UNLIKELY,  # 'J'
        56: SequenceLikelihood.UNLIKELY,  # 'K'
        24: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        43: SequenceLikelihood.UNLIKELY,  # 'O'
        32: SequenceLikelihood.LIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        38: SequenceLikelihood.UNLIKELY,  # 'R'
        30: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        46: SequenceLikelihood.UNLIKELY,  # 'U'
        45: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        61: SequenceLikelihood.UNLIKELY,  # 'X'
        60: SequenceLikelihood.UNLIKELY,  # 'Y'
        63: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.POSITIVE,  # 'b'
        12: SequenceLikelihood.POSITIVE,  # 'c'
        11: SequenceLikelihood.POSITIVE,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        17: SequenceLikelihood.POSITIVE,  # 'f'
        18: SequenceLikelihood.POSITIVE,  # 'g'
        20: SequenceLikelihood.LIKELY,  # 'h'
        5: SequenceLikelihood.LIKELY,  # 'i'
        26: SequenceLikelihood.LIKELY,  # 'j'
        44: SequenceLikelihood.POSITIVE,  # 'k'
        10: SequenceLikelihood.POSITIVE,  # 'l'
        14: SequenceLikelihood.POSITIVE,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        8: SequenceLikelihood.POSITIVE,  # 'o'
        13: SequenceLikelihood.POSITIVE,  # 'p'
        21: SequenceLikelihood.POSITIVE,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        2: SequenceLikelihood.POSITIVE,  # 's'
        6: SequenceLikelihood.POSITIVE,  # 't'
        9: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.POSITIVE,  # 'v'
        49: SequenceLikelihood.UNLIKELY,  # 'w'
        23: SequenceLikelihood.POSITIVE,  # 'x'
        27: SequenceLikelihood.LIKELY,  # 'y'
        34: SequenceLikelihood.POSITIVE,  # 'z'
        66: SequenceLikelihood.UNLIKELY,  # 'À'
        73: SequenceLikelihood.NEGATIVE,  # 'Â'
        83: SequenceLikelihood.NEGATIVE,  # 'Æ'
        69: SequenceLikelihood.UNLIKELY,  # 'Ç'
        70: SequenceLikelihood.UNLIKELY,  # 'È'
        58: SequenceLikelihood.UNLIKELY,  # 'É'
        72: SequenceLikelihood.NEGATIVE,  # 'Ê'
        80: SequenceLikelihood.UNLIKELY,  # 'Ë'
        71: SequenceLikelihood.UNLIKELY,  # 'Î'
        77: SequenceLikelihood.NEGATIVE,  # 'Ï'
        74: SequenceLikelihood.NEGATIVE,  # 'Ô'
        82: SequenceLikelihood.NEGATIVE,  # 'Ù'
        79: SequenceLikelihood.NEGATIVE,  # 'Û'
        78: SequenceLikelihood.NEGATIVE,  # 'Ü'
        22: SequenceLikelihood.UNLIKELY,  # 'à'
        53: SequenceLikelihood.UNLIKELY,  # 'â'
        76: SequenceLikelihood.UNLIKELY,  # 'æ'
        51: SequenceLikelihood.UNLIKELY,  # 'ç'
        28: SequenceLikelihood.POSITIVE,  # 'è'
        15: SequenceLikelihood.POSITIVE,  # 'é'
        41: SequenceLikelihood.UNLIKELY,  # 'ê'
        67: SequenceLikelihood.UNLIKELY,  # 'ë'
        57: SequenceLikelihood.UNLIKELY,  # 'î'
        65: SequenceLikelihood.UNLIKELY,  # 'ï'
        52: SequenceLikelihood.UNLIKELY,  # 'ô'
        62: SequenceLikelihood.UNLIKELY,  # 'ù'
        59: SequenceLikelihood.UNLIKELY,  # 'û'
        68: SequenceLikelihood.NEGATIVE,  # 'ü'
        81: SequenceLikelihood.UNLIKELY,  # 'ÿ'
        75: SequenceLikelihood.NEGATIVE,  # 'Œ'
        64: SequenceLikelihood.UNLIKELY,  # 'œ'
        84: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
    },
    26: {  # 'j'
        29: SequenceLikelihood.UNLIKELY,  # 'A'
        40: SequenceLikelihood.UNLIKELY,  # 'B'
        25: SequenceLikelihood.UNLIKELY,  # 'C'
        35: SequenceLikelihood.UNLIKELY,  # 'D'
        31: SequenceLikelihood.UNLIKELY,  # 'E'
        42: SequenceLikelihood.UNLIKELY,  # 'F'
        47: SequenceLikelihood.UNLIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        48: SequenceLikelihood.UNLIKELY,  # 'J'
        56: SequenceLikelihood.UNLIKELY,  # 'K'
        24: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        43: SequenceLikelihood.UNLIKELY,  # 'O'
        32: SequenceLikelihood.UNLIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        38: SequenceLikelihood.UNLIKELY,  # 'R'
        30: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        46: SequenceLikelihood.UNLIKELY,  # 'U'
        45: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        61: SequenceLikelihood.UNLIKELY,  # 'X'
        60: SequenceLikelihood.UNLIKELY,  # 'Y'
        63: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        12: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        17: SequenceLikelihood.UNLIKELY,  # 'f'
        18: SequenceLikelihood.UNLIKELY,  # 'g'
        20: SequenceLikelihood.UNLIKELY,  # 'h'
        5: SequenceLikelihood.LIKELY,  # 'i'
        26: SequenceLikelihood.UNLIKELY,  # 'j'
        44: SequenceLikelihood.UNLIKELY,  # 'k'
        10: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        8: SequenceLikelihood.POSITIVE,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        21: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        2: SequenceLikelihood.UNLIKELY,  # 's'
        6: SequenceLikelihood.UNLIKELY,  # 't'
        9: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        49: SequenceLikelihood.UNLIKELY,  # 'w'
        23: SequenceLikelihood.UNLIKELY,  # 'x'
        27: SequenceLikelihood.UNLIKELY,  # 'y'
        34: SequenceLikelihood.UNLIKELY,  # 'z'
        66: SequenceLikelihood.NEGATIVE,  # 'À'
        73: SequenceLikelihood.NEGATIVE,  # 'Â'
        83: SequenceLikelihood.NEGATIVE,  # 'Æ'
        69: SequenceLikelihood.NEGATIVE,  # 'Ç'
        70: SequenceLikelihood.NEGATIVE,  # 'È'
        58: SequenceLikelihood.NEGATIVE,  # 'É'
        72: SequenceLikelihood.NEGATIVE,  # 'Ê'
        80: SequenceLikelihood.NEGATIVE,  # 'Ë'
        71: SequenceLikelihood.NEGATIVE,  # 'Î'
        77: SequenceLikelihood.NEGATIVE,  # 'Ï'
        74: SequenceLikelihood.NEGATIVE,  # 'Ô'
        82: SequenceLikelihood.NEGATIVE,  # 'Ù'
        79: SequenceLikelihood.NEGATIVE,  # 'Û'
        78: SequenceLikelihood.NEGATIVE,  # 'Ü'
        22: SequenceLikelihood.POSITIVE,  # 'à'
        53: SequenceLikelihood.UNLIKELY,  # 'â'
        76: SequenceLikelihood.UNLIKELY,  # 'æ'
        51: SequenceLikelihood.NEGATIVE,  # 'ç'
        28: SequenceLikelihood.UNLIKELY,  # 'è'
        15: SequenceLikelihood.UNLIKELY,  # 'é'
        41: SequenceLikelihood.NEGATIVE,  # 'ê'
        67: SequenceLikelihood.UNLIKELY,  # 'ë'
        57: SequenceLikelihood.UNLIKELY,  # 'î'
        65: SequenceLikelihood.UNLIKELY,  # 'ï'
        52: SequenceLikelihood.UNLIKELY,  # 'ô'
        62: SequenceLikelihood.NEGATIVE,  # 'ù'
        59: SequenceLikelihood.UNLIKELY,  # 'û'
        68: SequenceLikelihood.UNLIKELY,  # 'ü'
        81: SequenceLikelihood.NEGATIVE,  # 'ÿ'
        75: SequenceLikelihood.NEGATIVE,  # 'Œ'
        64: SequenceLikelihood.NEGATIVE,  # 'œ'
        84: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
    },
    44: {  # 'k'
        29: SequenceLikelihood.UNLIKELY,  # 'A'
        40: SequenceLikelihood.UNLIKELY,  # 'B'
        25: SequenceLikelihood.UNLIKELY,  # 'C'
        35: SequenceLikelihood.UNLIKELY,  # 'D'
        31: SequenceLikelihood.UNLIKELY,  # 'E'
        42: SequenceLikelihood.UNLIKELY,  # 'F'
        47: SequenceLikelihood.UNLIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        48: SequenceLikelihood.UNLIKELY,  # 'J'
        56: SequenceLikelihood.UNLIKELY,  # 'K'
        24: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        43: SequenceLikelihood.UNLIKELY,  # 'O'
        32: SequenceLikelihood.UNLIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        38: SequenceLikelihood.UNLIKELY,  # 'R'
        30: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        46: SequenceLikelihood.UNLIKELY,  # 'U'
        45: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        61: SequenceLikelihood.UNLIKELY,  # 'X'
        60: SequenceLikelihood.UNLIKELY,  # 'Y'
        63: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        12: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        17: SequenceLikelihood.UNLIKELY,  # 'f'
        18: SequenceLikelihood.LIKELY,  # 'g'
        20: SequenceLikelihood.LIKELY,  # 'h'
        5: SequenceLikelihood.POSITIVE,  # 'i'
        26: SequenceLikelihood.UNLIKELY,  # 'j'
        44: SequenceLikelihood.UNLIKELY,  # 'k'
        10: SequenceLikelihood.LIKELY,  # 'l'
        14: SequenceLikelihood.LIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        8: SequenceLikelihood.LIKELY,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        21: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.LIKELY,  # 'r'
        2: SequenceLikelihood.LIKELY,  # 's'
        6: SequenceLikelihood.LIKELY,  # 't'
        9: SequenceLikelihood.LIKELY,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        49: SequenceLikelihood.UNLIKELY,  # 'w'
        23: SequenceLikelihood.UNLIKELY,  # 'x'
        27: SequenceLikelihood.LIKELY,  # 'y'
        34: SequenceLikelihood.UNLIKELY,  # 'z'
        66: SequenceLikelihood.UNLIKELY,  # 'À'
        73: SequenceLikelihood.NEGATIVE,  # 'Â'
        83: SequenceLikelihood.NEGATIVE,  # 'Æ'
        69: SequenceLikelihood.NEGATIVE,  # 'Ç'
        70: SequenceLikelihood.NEGATIVE,  # 'È'
        58: SequenceLikelihood.UNLIKELY,  # 'É'
        72: SequenceLikelihood.NEGATIVE,  # 'Ê'
        80: SequenceLikelihood.NEGATIVE,  # 'Ë'
        71: SequenceLikelihood.UNLIKELY,  # 'Î'
        77: SequenceLikelihood.NEGATIVE,  # 'Ï'
        74: SequenceLikelihood.NEGATIVE,  # 'Ô'
        82: SequenceLikelihood.NEGATIVE,  # 'Ù'
        79: SequenceLikelihood.NEGATIVE,  # 'Û'
        78: SequenceLikelihood.NEGATIVE,  # 'Ü'
        22: SequenceLikelihood.UNLIKELY,  # 'à'
        53: SequenceLikelihood.UNLIKELY,  # 'â'
        76: SequenceLikelihood.UNLIKELY,  # 'æ'
        51: SequenceLikelihood.UNLIKELY,  # 'ç'
        28: SequenceLikelihood.UNLIKELY,  # 'è'
        15: SequenceLikelihood.LIKELY,  # 'é'
        41: SequenceLikelihood.UNLIKELY,  # 'ê'
        67: SequenceLikelihood.UNLIKELY,  # 'ë'
        57: SequenceLikelihood.UNLIKELY,  # 'î'
        65: SequenceLikelihood.NEGATIVE,  # 'ï'
        52: SequenceLikelihood.UNLIKELY,  # 'ô'
        62: SequenceLikelihood.NEGATIVE,  # 'ù'
        59: SequenceLikelihood.UNLIKELY,  # 'û'
        68: SequenceLikelihood.UNLIKELY,  # 'ü'
        81: SequenceLikelihood.NEGATIVE,  # 'ÿ'
        75: SequenceLikelihood.NEGATIVE,  # 'Œ'
        64: SequenceLikelihood.UNLIKELY,  # 'œ'
        84: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
    },
    10: {  # 'l'
        29: SequenceLikelihood.UNLIKELY,  # 'A'
        40: SequenceLikelihood.UNLIKELY,  # 'B'
        25: SequenceLikelihood.UNLIKELY,  # 'C'
        35: SequenceLikelihood.UNLIKELY,  # 'D'
        31: SequenceLikelihood.UNLIKELY,  # 'E'
        42: SequenceLikelihood.UNLIKELY,  # 'F'
        47: SequenceLikelihood.UNLIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        48: SequenceLikelihood.UNLIKELY,  # 'J'
        56: SequenceLikelihood.UNLIKELY,  # 'K'
        24: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        43: SequenceLikelihood.UNLIKELY,  # 'O'
        32: SequenceLikelihood.UNLIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        38: SequenceLikelihood.UNLIKELY,  # 'R'
        30: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        46: SequenceLikelihood.UNLIKELY,  # 'U'
        45: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        61: SequenceLikelihood.UNLIKELY,  # 'X'
        60: SequenceLikelihood.UNLIKELY,  # 'Y'
        63: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.LIKELY,  # 'b'
        12: SequenceLikelihood.POSITIVE,  # 'c'
        11: SequenceLikelihood.POSITIVE,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        17: SequenceLikelihood.LIKELY,  # 'f'
        18: SequenceLikelihood.POSITIVE,  # 'g'
        20: SequenceLikelihood.LIKELY,  # 'h'
        5: SequenceLikelihood.POSITIVE,  # 'i'
        26: SequenceLikelihood.UNLIKELY,  # 'j'
        44: SequenceLikelihood.LIKELY,  # 'k'
        10: SequenceLikelihood.POSITIVE,  # 'l'
        14: SequenceLikelihood.POSITIVE,  # 'm'
        4: SequenceLikelihood.LIKELY,  # 'n'
        8: SequenceLikelihood.POSITIVE,  # 'o'
        13: SequenceLikelihood.LIKELY,  # 'p'
        21: SequenceLikelihood.POSITIVE,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        2: SequenceLikelihood.POSITIVE,  # 's'
        6: SequenceLikelihood.POSITIVE,  # 't'
        9: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.LIKELY,  # 'v'
        49: SequenceLikelihood.UNLIKELY,  # 'w'
        23: SequenceLikelihood.UNLIKELY,  # 'x'
        27: SequenceLikelihood.POSITIVE,  # 'y'
        34: SequenceLikelihood.UNLIKELY,  # 'z'
        66: SequenceLikelihood.UNLIKELY,  # 'À'
        73: SequenceLikelihood.UNLIKELY,  # 'Â'
        83: SequenceLikelihood.NEGATIVE,  # 'Æ'
        69: SequenceLikelihood.NEGATIVE,  # 'Ç'
        70: SequenceLikelihood.UNLIKELY,  # 'È'
        58: SequenceLikelihood.UNLIKELY,  # 'É'
        72: SequenceLikelihood.NEGATIVE,  # 'Ê'
        80: SequenceLikelihood.NEGATIVE,  # 'Ë'
        71: SequenceLikelihood.UNLIKELY,  # 'Î'
        77: SequenceLikelihood.NEGATIVE,  # 'Ï'
        74: SequenceLikelihood.NEGATIVE,  # 'Ô'
        82: SequenceLikelihood.UNLIKELY,  # 'Ù'
        79: SequenceLikelihood.NEGATIVE,  # 'Û'
        78: SequenceLikelihood.UNLIKELY,  # 'Ü'
        22: SequenceLikelihood.POSITIVE,  # 'à'
        53: SequenceLikelihood.LIKELY,  # 'â'
        76: SequenceLikelihood.UNLIKELY,  # 'æ'
        51: SequenceLikelihood.UNLIKELY,  # 'ç'
        28: SequenceLikelihood.POSITIVE,  # 'è'
        15: SequenceLikelihood.POSITIVE,  # 'é'
        41: SequenceLikelihood.UNLIKELY,  # 'ê'
        67: SequenceLikelihood.UNLIKELY,  # 'ë'
        57: SequenceLikelihood.UNLIKELY,  # 'î'
        65: SequenceLikelihood.UNLIKELY,  # 'ï'
        52: SequenceLikelihood.LIKELY,  # 'ô'
        62: SequenceLikelihood.UNLIKELY,  # 'ù'
        59: SequenceLikelihood.UNLIKELY,  # 'û'
        68: SequenceLikelihood.UNLIKELY,  # 'ü'
        81: SequenceLikelihood.UNLIKELY,  # 'ÿ'
        75: SequenceLikelihood.NEGATIVE,  # 'Œ'
        64: SequenceLikelihood.UNLIKELY,  # 'œ'
        84: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
    },
    14: {  # 'm'
        29: SequenceLikelihood.UNLIKELY,  # 'A'
        40: SequenceLikelihood.UNLIKELY,  # 'B'
        25: SequenceLikelihood.UNLIKELY,  # 'C'
        35: SequenceLikelihood.UNLIKELY,  # 'D'
        31: SequenceLikelihood.UNLIKELY,  # 'E'
        42: SequenceLikelihood.UNLIKELY,  # 'F'
        47: SequenceLikelihood.UNLIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        48: SequenceLikelihood.UNLIKELY,  # 'J'
        56: SequenceLikelihood.UNLIKELY,  # 'K'
        24: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        43: SequenceLikelihood.UNLIKELY,  # 'O'
        32: SequenceLikelihood.UNLIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        38: SequenceLikelihood.UNLIKELY,  # 'R'
        30: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        46: SequenceLikelihood.UNLIKELY,  # 'U'
        45: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        61: SequenceLikelihood.UNLIKELY,  # 'X'
        60: SequenceLikelihood.UNLIKELY,  # 'Y'
        63: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.POSITIVE,  # 'b'
        12: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        17: SequenceLikelihood.UNLIKELY,  # 'f'
        18: SequenceLikelihood.LIKELY,  # 'g'
        20: SequenceLikelihood.UNLIKELY,  # 'h'
        5: SequenceLikelihood.POSITIVE,  # 'i'
        26: SequenceLikelihood.UNLIKELY,  # 'j'
        44: SequenceLikelihood.UNLIKELY,  # 'k'
        10: SequenceLikelihood.LIKELY,  # 'l'
        14: SequenceLikelihood.POSITIVE,  # 'm'
        4: SequenceLikelihood.LIKELY,  # 'n'
        8: SequenceLikelihood.POSITIVE,  # 'o'
        13: SequenceLikelihood.POSITIVE,  # 'p'
        21: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        2: SequenceLikelihood.POSITIVE,  # 's'
        6: SequenceLikelihood.LIKELY,  # 't'
        9: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        49: SequenceLikelihood.UNLIKELY,  # 'w'
        23: SequenceLikelihood.UNLIKELY,  # 'x'
        27: SequenceLikelihood.LIKELY,  # 'y'
        34: SequenceLikelihood.UNLIKELY,  # 'z'
        66: SequenceLikelihood.UNLIKELY,  # 'À'
        73: SequenceLikelihood.UNLIKELY,  # 'Â'
        83: SequenceLikelihood.NEGATIVE,  # 'Æ'
        69: SequenceLikelihood.NEGATIVE,  # 'Ç'
        70: SequenceLikelihood.UNLIKELY,  # 'È'
        58: SequenceLikelihood.UNLIKELY,  # 'É'
        72: SequenceLikelihood.UNLIKELY,  # 'Ê'
        80: SequenceLikelihood.NEGATIVE,  # 'Ë'
        71: SequenceLikelihood.NEGATIVE,  # 'Î'
        77: SequenceLikelihood.NEGATIVE,  # 'Ï'
        74: SequenceLikelihood.UNLIKELY,  # 'Ô'
        82: SequenceLikelihood.NEGATIVE,  # 'Ù'
        79: SequenceLikelihood.NEGATIVE,  # 'Û'
        78: SequenceLikelihood.NEGATIVE,  # 'Ü'
        22: SequenceLikelihood.UNLIKELY,  # 'à'
        53: SequenceLikelihood.LIKELY,  # 'â'
        76: SequenceLikelihood.UNLIKELY,  # 'æ'
        51: SequenceLikelihood.UNLIKELY,  # 'ç'
        28: SequenceLikelihood.POSITIVE,  # 'è'
        15: SequenceLikelihood.POSITIVE,  # 'é'
        41: SequenceLikelihood.POSITIVE,  # 'ê'
        67: SequenceLikelihood.UNLIKELY,  # 'ë'
        57: SequenceLikelihood.UNLIKELY,  # 'î'
        65: SequenceLikelihood.UNLIKELY,  # 'ï'
        52: SequenceLikelihood.UNLIKELY,  # 'ô'
        62: SequenceLikelihood.UNLIKELY,  # 'ù'
        59: SequenceLikelihood.UNLIKELY,  # 'û'
        68: SequenceLikelihood.UNLIKELY,  # 'ü'
        81: SequenceLikelihood.UNLIKELY,  # 'ÿ'
        75: SequenceLikelihood.UNLIKELY,  # 'Œ'
        64: SequenceLikelihood.UNLIKELY,  # 'œ'
        84: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
    },
    4: {  # 'n'
        29: SequenceLikelihood.UNLIKELY,  # 'A'
        40: SequenceLikelihood.UNLIKELY,  # 'B'
        25: SequenceLikelihood.UNLIKELY,  # 'C'
        35: SequenceLikelihood.UNLIKELY,  # 'D'
        31: SequenceLikelihood.UNLIKELY,  # 'E'
        42: SequenceLikelihood.UNLIKELY,  # 'F'
        47: SequenceLikelihood.UNLIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        48: SequenceLikelihood.UNLIKELY,  # 'J'
        56: SequenceLikelihood.UNLIKELY,  # 'K'
        24: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        43: SequenceLikelihood.UNLIKELY,  # 'O'
        32: SequenceLikelihood.UNLIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        38: SequenceLikelihood.UNLIKELY,  # 'R'
        30: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        46: SequenceLikelihood.UNLIKELY,  # 'U'
        45: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        61: SequenceLikelihood.UNLIKELY,  # 'X'
        60: SequenceLikelihood.UNLIKELY,  # 'Y'
        63: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.LIKELY,  # 'b'
        12: SequenceLikelihood.POSITIVE,  # 'c'
        11: SequenceLikelihood.POSITIVE,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        17: SequenceLikelihood.POSITIVE,  # 'f'
        18: SequenceLikelihood.POSITIVE,  # 'g'
        20: SequenceLikelihood.LIKELY,  # 'h'
        5: SequenceLikelihood.POSITIVE,  # 'i'
        26: SequenceLikelihood.POSITIVE,  # 'j'
        44: SequenceLikelihood.LIKELY,  # 'k'
        10: SequenceLikelihood.LIKELY,  # 'l'
        14: SequenceLikelihood.LIKELY,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        8: SequenceLikelihood.POSITIVE,  # 'o'
        13: SequenceLikelihood.LIKELY,  # 'p'
        21: SequenceLikelihood.POSITIVE,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        2: SequenceLikelihood.POSITIVE,  # 's'
        6: SequenceLikelihood.POSITIVE,  # 't'
        9: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.POSITIVE,  # 'v'
        49: SequenceLikelihood.UNLIKELY,  # 'w'
        23: SequenceLikelihood.UNLIKELY,  # 'x'
        27: SequenceLikelihood.POSITIVE,  # 'y'
        34: SequenceLikelihood.LIKELY,  # 'z'
        66: SequenceLikelihood.UNLIKELY,  # 'À'
        73: SequenceLikelihood.NEGATIVE,  # 'Â'
        83: SequenceLikelihood.NEGATIVE,  # 'Æ'
        69: SequenceLikelihood.UNLIKELY,  # 'Ç'
        70: SequenceLikelihood.UNLIKELY,  # 'È'
        58: SequenceLikelihood.UNLIKELY,  # 'É'
        72: SequenceLikelihood.UNLIKELY,  # 'Ê'
        80: SequenceLikelihood.NEGATIVE,  # 'Ë'
        71: SequenceLikelihood.UNLIKELY,  # 'Î'
        77: SequenceLikelihood.NEGATIVE,  # 'Ï'
        74: SequenceLikelihood.NEGATIVE,  # 'Ô'
        82: SequenceLikelihood.NEGATIVE,  # 'Ù'
        79: SequenceLikelihood.NEGATIVE,  # 'Û'
        78: SequenceLikelihood.NEGATIVE,  # 'Ü'
        22: SequenceLikelihood.UNLIKELY,  # 'à'
        53: SequenceLikelihood.UNLIKELY,  # 'â'
        76: SequenceLikelihood.UNLIKELY,  # 'æ'
        51: SequenceLikelihood.POSITIVE,  # 'ç'
        28: SequenceLikelihood.LIKELY,  # 'è'
        15: SequenceLikelihood.POSITIVE,  # 'é'
        41: SequenceLikelihood.LIKELY,  # 'ê'
        67: SequenceLikelihood.UNLIKELY,  # 'ë'
        57: SequenceLikelihood.UNLIKELY,  # 'î'
        65: SequenceLikelihood.UNLIKELY,  # 'ï'
        52: SequenceLikelihood.UNLIKELY,  # 'ô'
        62: SequenceLikelihood.UNLIKELY,  # 'ù'
        59: SequenceLikelihood.UNLIKELY,  # 'û'
        68: SequenceLikelihood.UNLIKELY,  # 'ü'
        81: SequenceLikelihood.NEGATIVE,  # 'ÿ'
        75: SequenceLikelihood.NEGATIVE,  # 'Œ'
        64: SequenceLikelihood.UNLIKELY,  # 'œ'
        84: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
    },
    8: {  # 'o'
        29: SequenceLikelihood.UNLIKELY,  # 'A'
        40: SequenceLikelihood.UNLIKELY,  # 'B'
        25: SequenceLikelihood.UNLIKELY,  # 'C'
        35: SequenceLikelihood.UNLIKELY,  # 'D'
        31: SequenceLikelihood.UNLIKELY,  # 'E'
        42: SequenceLikelihood.UNLIKELY,  # 'F'
        47: SequenceLikelihood.UNLIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        48: SequenceLikelihood.UNLIKELY,  # 'J'
        56: SequenceLikelihood.UNLIKELY,  # 'K'
        24: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        43: SequenceLikelihood.UNLIKELY,  # 'O'
        32: SequenceLikelihood.UNLIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        38: SequenceLikelihood.UNLIKELY,  # 'R'
        30: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        46: SequenceLikelihood.UNLIKELY,  # 'U'
        45: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        61: SequenceLikelihood.UNLIKELY,  # 'X'
        60: SequenceLikelihood.UNLIKELY,  # 'Y'
        63: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.POSITIVE,  # 'b'
        12: SequenceLikelihood.POSITIVE,  # 'c'
        11: SequenceLikelihood.POSITIVE,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        17: SequenceLikelihood.POSITIVE,  # 'f'
        18: SequenceLikelihood.POSITIVE,  # 'g'
        20: SequenceLikelihood.LIKELY,  # 'h'
        5: SequenceLikelihood.POSITIVE,  # 'i'
        26: SequenceLikelihood.POSITIVE,  # 'j'
        44: SequenceLikelihood.POSITIVE,  # 'k'
        10: SequenceLikelihood.POSITIVE,  # 'l'
        14: SequenceLikelihood.POSITIVE,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        8: SequenceLikelihood.POSITIVE,  # 'o'
        13: SequenceLikelihood.POSITIVE,  # 'p'
        21: SequenceLikelihood.POSITIVE,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        2: SequenceLikelihood.POSITIVE,  # 's'
        6: SequenceLikelihood.POSITIVE,  # 't'
        9: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.POSITIVE,  # 'v'
        49: SequenceLikelihood.POSITIVE,  # 'w'
        23: SequenceLikelihood.POSITIVE,  # 'x'
        27: SequenceLikelihood.POSITIVE,  # 'y'
        34: SequenceLikelihood.LIKELY,  # 'z'
        66: SequenceLikelihood.UNLIKELY,  # 'À'
        73: SequenceLikelihood.UNLIKELY,  # 'Â'
        83: SequenceLikelihood.NEGATIVE,  # 'Æ'
        69: SequenceLikelihood.NEGATIVE,  # 'Ç'
        70: SequenceLikelihood.UNLIKELY,  # 'È'
        58: SequenceLikelihood.UNLIKELY,  # 'É'
        72: SequenceLikelihood.NEGATIVE,  # 'Ê'
        80: SequenceLikelihood.UNLIKELY,  # 'Ë'
        71: SequenceLikelihood.UNLIKELY,  # 'Î'
        77: SequenceLikelihood.UNLIKELY,  # 'Ï'
        74: SequenceLikelihood.NEGATIVE,  # 'Ô'
        82: SequenceLikelihood.NEGATIVE,  # 'Ù'
        79: SequenceLikelihood.UNLIKELY,  # 'Û'
        78: SequenceLikelihood.NEGATIVE,  # 'Ü'
        22: SequenceLikelihood.UNLIKELY,  # 'à'
        53: SequenceLikelihood.UNLIKELY,  # 'â'
        76: SequenceLikelihood.NEGATIVE,  # 'æ'
        51: SequenceLikelihood.UNLIKELY,  # 'ç'
        28: SequenceLikelihood.LIKELY,  # 'è'
        15: SequenceLikelihood.LIKELY,  # 'é'
        41: SequenceLikelihood.UNLIKELY,  # 'ê'
        67: SequenceLikelihood.LIKELY,  # 'ë'
        57: SequenceLikelihood.LIKELY,  # 'î'
        65: SequenceLikelihood.LIKELY,  # 'ï'
        52: SequenceLikelihood.UNLIKELY,  # 'ô'
        62: SequenceLikelihood.POSITIVE,  # 'ù'
        59: SequenceLikelihood.POSITIVE,  # 'û'
        68: SequenceLikelihood.UNLIKELY,  # 'ü'
        81: SequenceLikelihood.UNLIKELY,  # 'ÿ'
        75: SequenceLikelihood.NEGATIVE,  # 'Œ'
        64: SequenceLikelihood.UNLIKELY,  # 'œ'
        84: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
    },
    13: {  # 'p'
        29: SequenceLikelihood.UNLIKELY,  # 'A'
        40: SequenceLikelihood.UNLIKELY,  # 'B'
        25: SequenceLikelihood.UNLIKELY,  # 'C'
        35: SequenceLikelihood.UNLIKELY,  # 'D'
        31: SequenceLikelihood.UNLIKELY,  # 'E'
        42: SequenceLikelihood.UNLIKELY,  # 'F'
        47: SequenceLikelihood.UNLIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        48: SequenceLikelihood.UNLIKELY,  # 'J'
        56: SequenceLikelihood.UNLIKELY,  # 'K'
        24: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        43: SequenceLikelihood.UNLIKELY,  # 'O'
        32: SequenceLikelihood.UNLIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        38: SequenceLikelihood.UNLIKELY,  # 'R'
        30: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        46: SequenceLikelihood.UNLIKELY,  # 'U'
        45: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        61: SequenceLikelihood.UNLIKELY,  # 'X'
        60: SequenceLikelihood.UNLIKELY,  # 'Y'
        63: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        12: SequenceLikelihood.LIKELY,  # 'c'
        11: SequenceLikelihood.LIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        17: SequenceLikelihood.UNLIKELY,  # 'f'
        18: SequenceLikelihood.UNLIKELY,  # 'g'
        20: SequenceLikelihood.POSITIVE,  # 'h'
        5: SequenceLikelihood.POSITIVE,  # 'i'
        26: SequenceLikelihood.UNLIKELY,  # 'j'
        44: SequenceLikelihood.UNLIKELY,  # 'k'
        10: SequenceLikelihood.POSITIVE,  # 'l'
        14: SequenceLikelihood.LIKELY,  # 'm'
        4: SequenceLikelihood.LIKELY,  # 'n'
        8: SequenceLikelihood.POSITIVE,  # 'o'
        13: SequenceLikelihood.POSITIVE,  # 'p'
        21: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        2: SequenceLikelihood.POSITIVE,  # 's'
        6: SequenceLikelihood.POSITIVE,  # 't'
        9: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        49: SequenceLikelihood.UNLIKELY,  # 'w'
        23: SequenceLikelihood.UNLIKELY,  # 'x'
        27: SequenceLikelihood.LIKELY,  # 'y'
        34: SequenceLikelihood.UNLIKELY,  # 'z'
        66: SequenceLikelihood.UNLIKELY,  # 'À'
        73: SequenceLikelihood.NEGATIVE,  # 'Â'
        83: SequenceLikelihood.NEGATIVE,  # 'Æ'
        69: SequenceLikelihood.NEGATIVE,  # 'Ç'
        70: SequenceLikelihood.UNLIKELY,  # 'È'
        58: SequenceLikelihood.UNLIKELY,  # 'É'
        72: SequenceLikelihood.NEGATIVE,  # 'Ê'
        80: SequenceLikelihood.NEGATIVE,  # 'Ë'
        71: SequenceLikelihood.NEGATIVE,  # 'Î'
        77: SequenceLikelihood.NEGATIVE,  # 'Ï'
        74: SequenceLikelihood.NEGATIVE,  # 'Ô'
        82: SequenceLikelihood.NEGATIVE,  # 'Ù'
        79: SequenceLikelihood.NEGATIVE,  # 'Û'
        78: SequenceLikelihood.NEGATIVE,  # 'Ü'
        22: SequenceLikelihood.UNLIKELY,  # 'à'
        53: SequenceLikelihood.LIKELY,  # 'â'
        76: SequenceLikelihood.UNLIKELY,  # 'æ'
        51: SequenceLikelihood.UNLIKELY,  # 'ç'
        28: SequenceLikelihood.POSITIVE,  # 'è'
        15: SequenceLikelihood.POSITIVE,  # 'é'
        41: SequenceLikelihood.LIKELY,  # 'ê'
        67: SequenceLikelihood.UNLIKELY,  # 'ë'
        57: SequenceLikelihood.UNLIKELY,  # 'î'
        65: SequenceLikelihood.UNLIKELY,  # 'ï'
        52: SequenceLikelihood.LIKELY,  # 'ô'
        62: SequenceLikelihood.NEGATIVE,  # 'ù'
        59: SequenceLikelihood.UNLIKELY,  # 'û'
        68: SequenceLikelihood.UNLIKELY,  # 'ü'
        81: SequenceLikelihood.NEGATIVE,  # 'ÿ'
        75: SequenceLikelihood.NEGATIVE,  # 'Œ'
        64: SequenceLikelihood.UNLIKELY,  # 'œ'
        84: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
    },
    21: {  # 'q'
        29: SequenceLikelihood.UNLIKELY,  # 'A'
        40: SequenceLikelihood.UNLIKELY,  # 'B'
        25: SequenceLikelihood.UNLIKELY,  # 'C'
        35: SequenceLikelihood.UNLIKELY,  # 'D'
        31: SequenceLikelihood.UNLIKELY,  # 'E'
        42: SequenceLikelihood.UNLIKELY,  # 'F'
        47: SequenceLikelihood.UNLIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        48: SequenceLikelihood.UNLIKELY,  # 'J'
        56: SequenceLikelihood.UNLIKELY,  # 'K'
        24: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        43: SequenceLikelihood.UNLIKELY,  # 'O'
        32: SequenceLikelihood.UNLIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        38: SequenceLikelihood.UNLIKELY,  # 'R'
        30: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        46: SequenceLikelihood.UNLIKELY,  # 'U'
        45: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        61: SequenceLikelihood.UNLIKELY,  # 'X'
        60: SequenceLikelihood.UNLIKELY,  # 'Y'
        63: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.UNLIKELY,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        12: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.UNLIKELY,  # 'e'
        17: SequenceLikelihood.UNLIKELY,  # 'f'
        18: SequenceLikelihood.UNLIKELY,  # 'g'
        20: SequenceLikelihood.UNLIKELY,  # 'h'
        5: SequenceLikelihood.UNLIKELY,  # 'i'
        26: SequenceLikelihood.UNLIKELY,  # 'j'
        44: SequenceLikelihood.UNLIKELY,  # 'k'
        10: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        8: SequenceLikelihood.UNLIKELY,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        21: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        2: SequenceLikelihood.UNLIKELY,  # 's'
        6: SequenceLikelihood.UNLIKELY,  # 't'
        9: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        49: SequenceLikelihood.UNLIKELY,  # 'w'
        23: SequenceLikelihood.UNLIKELY,  # 'x'
        27: SequenceLikelihood.UNLIKELY,  # 'y'
        34: SequenceLikelihood.UNLIKELY,  # 'z'
        66: SequenceLikelihood.NEGATIVE,  # 'À'
        73: SequenceLikelihood.NEGATIVE,  # 'Â'
        83: SequenceLikelihood.NEGATIVE,  # 'Æ'
        69: SequenceLikelihood.NEGATIVE,  # 'Ç'
        70: SequenceLikelihood.NEGATIVE,  # 'È'
        58: SequenceLikelihood.NEGATIVE,  # 'É'
        72: SequenceLikelihood.NEGATIVE,  # 'Ê'
        80: SequenceLikelihood.NEGATIVE,  # 'Ë'
        71: SequenceLikelihood.NEGATIVE,  # 'Î'
        77: SequenceLikelihood.NEGATIVE,  # 'Ï'
        74: SequenceLikelihood.NEGATIVE,  # 'Ô'
        82: SequenceLikelihood.NEGATIVE,  # 'Ù'
        79: SequenceLikelihood.NEGATIVE,  # 'Û'
        78: SequenceLikelihood.NEGATIVE,  # 'Ü'
        22: SequenceLikelihood.NEGATIVE,  # 'à'
        53: SequenceLikelihood.UNLIKELY,  # 'â'
        76: SequenceLikelihood.NEGATIVE,  # 'æ'
        51: SequenceLikelihood.NEGATIVE,  # 'ç'
        28: SequenceLikelihood.NEGATIVE,  # 'è'
        15: SequenceLikelihood.UNLIKELY,  # 'é'
        41: SequenceLikelihood.UNLIKELY,  # 'ê'
        67: SequenceLikelihood.UNLIKELY,  # 'ë'
        57: SequenceLikelihood.UNLIKELY,  # 'î'
        65: SequenceLikelihood.NEGATIVE,  # 'ï'
        52: SequenceLikelihood.NEGATIVE,  # 'ô'
        62: SequenceLikelihood.UNLIKELY,  # 'ù'
        59: SequenceLikelihood.UNLIKELY,  # 'û'
        68: SequenceLikelihood.NEGATIVE,  # 'ü'
        81: SequenceLikelihood.NEGATIVE,  # 'ÿ'
        75: SequenceLikelihood.NEGATIVE,  # 'Œ'
        64: SequenceLikelihood.NEGATIVE,  # 'œ'
        84: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
    },
    7: {  # 'r'
        29: SequenceLikelihood.UNLIKELY,  # 'A'
        40: SequenceLikelihood.UNLIKELY,  # 'B'
        25: SequenceLikelihood.UNLIKELY,  # 'C'
        35: SequenceLikelihood.UNLIKELY,  # 'D'
        31: SequenceLikelihood.UNLIKELY,  # 'E'
        42: SequenceLikelihood.UNLIKELY,  # 'F'
        47: SequenceLikelihood.UNLIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        48: SequenceLikelihood.UNLIKELY,  # 'J'
        56: SequenceLikelihood.UNLIKELY,  # 'K'
        24: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        43: SequenceLikelihood.UNLIKELY,  # 'O'
        32: SequenceLikelihood.UNLIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        38: SequenceLikelihood.UNLIKELY,  # 'R'
        30: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        46: SequenceLikelihood.UNLIKELY,  # 'U'
        45: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        61: SequenceLikelihood.UNLIKELY,  # 'X'
        60: SequenceLikelihood.UNLIKELY,  # 'Y'
        63: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.POSITIVE,  # 'b'
        12: SequenceLikelihood.POSITIVE,  # 'c'
        11: SequenceLikelihood.POSITIVE,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        17: SequenceLikelihood.POSITIVE,  # 'f'
        18: SequenceLikelihood.POSITIVE,  # 'g'
        20: SequenceLikelihood.LIKELY,  # 'h'
        5: SequenceLikelihood.POSITIVE,  # 'i'
        26: SequenceLikelihood.UNLIKELY,  # 'j'
        44: SequenceLikelihood.POSITIVE,  # 'k'
        10: SequenceLikelihood.POSITIVE,  # 'l'
        14: SequenceLikelihood.POSITIVE,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        8: SequenceLikelihood.POSITIVE,  # 'o'
        13: SequenceLikelihood.POSITIVE,  # 'p'
        21: SequenceLikelihood.POSITIVE,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        2: SequenceLikelihood.POSITIVE,  # 's'
        6: SequenceLikelihood.POSITIVE,  # 't'
        9: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.POSITIVE,  # 'v'
        49: SequenceLikelihood.LIKELY,  # 'w'
        23: SequenceLikelihood.UNLIKELY,  # 'x'
        27: SequenceLikelihood.POSITIVE,  # 'y'
        34: SequenceLikelihood.LIKELY,  # 'z'
        66: SequenceLikelihood.UNLIKELY,  # 'À'
        73: SequenceLikelihood.UNLIKELY,  # 'Â'
        83: SequenceLikelihood.NEGATIVE,  # 'Æ'
        69: SequenceLikelihood.UNLIKELY,  # 'Ç'
        70: SequenceLikelihood.UNLIKELY,  # 'È'
        58: SequenceLikelihood.UNLIKELY,  # 'É'
        72: SequenceLikelihood.UNLIKELY,  # 'Ê'
        80: SequenceLikelihood.NEGATIVE,  # 'Ë'
        71: SequenceLikelihood.UNLIKELY,  # 'Î'
        77: SequenceLikelihood.NEGATIVE,  # 'Ï'
        74: SequenceLikelihood.UNLIKELY,  # 'Ô'
        82: SequenceLikelihood.UNLIKELY,  # 'Ù'
        79: SequenceLikelihood.NEGATIVE,  # 'Û'
        78: SequenceLikelihood.NEGATIVE,  # 'Ü'
        22: SequenceLikelihood.UNLIKELY,  # 'à'
        53: SequenceLikelihood.POSITIVE,  # 'â'
        76: SequenceLikelihood.UNLIKELY,  # 'æ'
        51: SequenceLikelihood.LIKELY,  # 'ç'
        28: SequenceLikelihood.POSITIVE,  # 'è'
        15: SequenceLikelihood.POSITIVE,  # 'é'
        41: SequenceLikelihood.POSITIVE,  # 'ê'
        67: SequenceLikelihood.UNLIKELY,  # 'ë'
        57: SequenceLikelihood.UNLIKELY,  # 'î'
        65: SequenceLikelihood.UNLIKELY,  # 'ï'
        52: SequenceLikelihood.POSITIVE,  # 'ô'
        62: SequenceLikelihood.UNLIKELY,  # 'ù'
        59: SequenceLikelihood.LIKELY,  # 'û'
        68: SequenceLikelihood.UNLIKELY,  # 'ü'
        81: SequenceLikelihood.UNLIKELY,  # 'ÿ'
        75: SequenceLikelihood.NEGATIVE,  # 'Œ'
        64: SequenceLikelihood.UNLIKELY,  # 'œ'
        84: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
    },
    2: {  # 's'
        29: SequenceLikelihood.UNLIKELY,  # 'A'
        40: SequenceLikelihood.UNLIKELY,  # 'B'
        25: SequenceLikelihood.UNLIKELY,  # 'C'
        35: SequenceLikelihood.UNLIKELY,  # 'D'
        31: SequenceLikelihood.UNLIKELY,  # 'E'
        42: SequenceLikelihood.UNLIKELY,  # 'F'
        47: SequenceLikelihood.UNLIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        48: SequenceLikelihood.UNLIKELY,  # 'J'
        56: SequenceLikelihood.UNLIKELY,  # 'K'
        24: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        43: SequenceLikelihood.UNLIKELY,  # 'O'
        32: SequenceLikelihood.UNLIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        38: SequenceLikelihood.UNLIKELY,  # 'R'
        30: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        46: SequenceLikelihood.UNLIKELY,  # 'U'
        45: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        61: SequenceLikelihood.UNLIKELY,  # 'X'
        60: SequenceLikelihood.UNLIKELY,  # 'Y'
        63: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.LIKELY,  # 'b'
        12: SequenceLikelihood.POSITIVE,  # 'c'
        11: SequenceLikelihood.LIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        17: SequenceLikelihood.POSITIVE,  # 'f'
        18: SequenceLikelihood.LIKELY,  # 'g'
        20: SequenceLikelihood.POSITIVE,  # 'h'
        5: SequenceLikelihood.POSITIVE,  # 'i'
        26: SequenceLikelihood.UNLIKELY,  # 'j'
        44: SequenceLikelihood.LIKELY,  # 'k'
        10: SequenceLikelihood.POSITIVE,  # 'l'
        14: SequenceLikelihood.POSITIVE,  # 'm'
        4: SequenceLikelihood.LIKELY,  # 'n'
        8: SequenceLikelihood.POSITIVE,  # 'o'
        13: SequenceLikelihood.POSITIVE,  # 'p'
        21: SequenceLikelihood.POSITIVE,  # 'q'
        7: SequenceLikelihood.LIKELY,  # 'r'
        2: SequenceLikelihood.POSITIVE,  # 's'
        6: SequenceLikelihood.POSITIVE,  # 't'
        9: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        49: SequenceLikelihood.LIKELY,  # 'w'
        23: SequenceLikelihood.UNLIKELY,  # 'x'
        27: SequenceLikelihood.POSITIVE,  # 'y'
        34: SequenceLikelihood.UNLIKELY,  # 'z'
        66: SequenceLikelihood.UNLIKELY,  # 'À'
        73: SequenceLikelihood.UNLIKELY,  # 'Â'
        83: SequenceLikelihood.NEGATIVE,  # 'Æ'
        69: SequenceLikelihood.NEGATIVE,  # 'Ç'
        70: SequenceLikelihood.NEGATIVE,  # 'È'
        58: SequenceLikelihood.UNLIKELY,  # 'É'
        72: SequenceLikelihood.NEGATIVE,  # 'Ê'
        80: SequenceLikelihood.NEGATIVE,  # 'Ë'
        71: SequenceLikelihood.UNLIKELY,  # 'Î'
        77: SequenceLikelihood.NEGATIVE,  # 'Ï'
        74: SequenceLikelihood.NEGATIVE,  # 'Ô'
        82: SequenceLikelihood.NEGATIVE,  # 'Ù'
        79: SequenceLikelihood.UNLIKELY,  # 'Û'
        78: SequenceLikelihood.NEGATIVE,  # 'Ü'
        22: SequenceLikelihood.UNLIKELY,  # 'à'
        53: SequenceLikelihood.UNLIKELY,  # 'â'
        76: SequenceLikelihood.UNLIKELY,  # 'æ'
        51: SequenceLikelihood.UNLIKELY,  # 'ç'
        28: SequenceLikelihood.LIKELY,  # 'è'
        15: SequenceLikelihood.POSITIVE,  # 'é'
        41: SequenceLikelihood.UNLIKELY,  # 'ê'
        67: SequenceLikelihood.UNLIKELY,  # 'ë'
        57: SequenceLikelihood.UNLIKELY,  # 'î'
        65: SequenceLikelihood.UNLIKELY,  # 'ï'
        52: SequenceLikelihood.UNLIKELY,  # 'ô'
        62: SequenceLikelihood.UNLIKELY,  # 'ù'
        59: SequenceLikelihood.LIKELY,  # 'û'
        68: SequenceLikelihood.UNLIKELY,  # 'ü'
        81: SequenceLikelihood.NEGATIVE,  # 'ÿ'
        75: SequenceLikelihood.NEGATIVE,  # 'Œ'
        64: SequenceLikelihood.UNLIKELY,  # 'œ'
        84: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
    },
    6: {  # 't'
        29: SequenceLikelihood.UNLIKELY,  # 'A'
        40: SequenceLikelihood.UNLIKELY,  # 'B'
        25: SequenceLikelihood.UNLIKELY,  # 'C'
        35: SequenceLikelihood.UNLIKELY,  # 'D'
        31: SequenceLikelihood.UNLIKELY,  # 'E'
        42: SequenceLikelihood.UNLIKELY,  # 'F'
        47: SequenceLikelihood.UNLIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        48: SequenceLikelihood.UNLIKELY,  # 'J'
        56: SequenceLikelihood.UNLIKELY,  # 'K'
        24: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        43: SequenceLikelihood.UNLIKELY,  # 'O'
        32: SequenceLikelihood.UNLIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        38: SequenceLikelihood.UNLIKELY,  # 'R'
        30: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        46: SequenceLikelihood.UNLIKELY,  # 'U'
        45: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        61: SequenceLikelihood.UNLIKELY,  # 'X'
        60: SequenceLikelihood.UNLIKELY,  # 'Y'
        63: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.LIKELY,  # 'b'
        12: SequenceLikelihood.POSITIVE,  # 'c'
        11: SequenceLikelihood.LIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        17: SequenceLikelihood.LIKELY,  # 'f'
        18: SequenceLikelihood.UNLIKELY,  # 'g'
        20: SequenceLikelihood.POSITIVE,  # 'h'
        5: SequenceLikelihood.POSITIVE,  # 'i'
        26: SequenceLikelihood.UNLIKELY,  # 'j'
        44: SequenceLikelihood.UNLIKELY,  # 'k'
        10: SequenceLikelihood.LIKELY,  # 'l'
        14: SequenceLikelihood.LIKELY,  # 'm'
        4: SequenceLikelihood.LIKELY,  # 'n'
        8: SequenceLikelihood.POSITIVE,  # 'o'
        13: SequenceLikelihood.POSITIVE,  # 'p'
        21: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        2: SequenceLikelihood.POSITIVE,  # 's'
        6: SequenceLikelihood.POSITIVE,  # 't'
        9: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.LIKELY,  # 'v'
        49: SequenceLikelihood.LIKELY,  # 'w'
        23: SequenceLikelihood.UNLIKELY,  # 'x'
        27: SequenceLikelihood.POSITIVE,  # 'y'
        34: SequenceLikelihood.LIKELY,  # 'z'
        66: SequenceLikelihood.UNLIKELY,  # 'À'
        73: SequenceLikelihood.UNLIKELY,  # 'Â'
        83: SequenceLikelihood.NEGATIVE,  # 'Æ'
        69: SequenceLikelihood.UNLIKELY,  # 'Ç'
        70: SequenceLikelihood.UNLIKELY,  # 'È'
        58: SequenceLikelihood.UNLIKELY,  # 'É'
        72: SequenceLikelihood.UNLIKELY,  # 'Ê'
        80: SequenceLikelihood.NEGATIVE,  # 'Ë'
        71: SequenceLikelihood.UNLIKELY,  # 'Î'
        77: SequenceLikelihood.NEGATIVE,  # 'Ï'
        74: SequenceLikelihood.NEGATIVE,  # 'Ô'
        82: SequenceLikelihood.UNLIKELY,  # 'Ù'
        79: SequenceLikelihood.NEGATIVE,  # 'Û'
        78: SequenceLikelihood.NEGATIVE,  # 'Ü'
        22: SequenceLikelihood.UNLIKELY,  # 'à'
        53: SequenceLikelihood.LIKELY,  # 'â'
        76: SequenceLikelihood.UNLIKELY,  # 'æ'
        51: SequenceLikelihood.UNLIKELY,  # 'ç'
        28: SequenceLikelihood.POSITIVE,  # 'è'
        15: SequenceLikelihood.POSITIVE,  # 'é'
        41: SequenceLikelihood.LIKELY,  # 'ê'
        67: SequenceLikelihood.UNLIKELY,  # 'ë'
        57: SequenceLikelihood.UNLIKELY,  # 'î'
        65: SequenceLikelihood.UNLIKELY,  # 'ï'
        52: SequenceLikelihood.POSITIVE,  # 'ô'
        62: SequenceLikelihood.UNLIKELY,  # 'ù'
        59: SequenceLikelihood.UNLIKELY,  # 'û'
        68: SequenceLikelihood.UNLIKELY,  # 'ü'
        81: SequenceLikelihood.UNLIKELY,  # 'ÿ'
        75: SequenceLikelihood.UNLIKELY,  # 'Œ'
        64: SequenceLikelihood.UNLIKELY,  # 'œ'
        84: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
    },
    9: {  # 'u'
        29: SequenceLikelihood.UNLIKELY,  # 'A'
        40: SequenceLikelihood.UNLIKELY,  # 'B'
        25: SequenceLikelihood.UNLIKELY,  # 'C'
        35: SequenceLikelihood.UNLIKELY,  # 'D'
        31: SequenceLikelihood.UNLIKELY,  # 'E'
        42: SequenceLikelihood.UNLIKELY,  # 'F'
        47: SequenceLikelihood.UNLIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        48: SequenceLikelihood.UNLIKELY,  # 'J'
        56: SequenceLikelihood.UNLIKELY,  # 'K'
        24: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        43: SequenceLikelihood.UNLIKELY,  # 'O'
        32: SequenceLikelihood.UNLIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        38: SequenceLikelihood.UNLIKELY,  # 'R'
        30: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        46: SequenceLikelihood.UNLIKELY,  # 'U'
        45: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        61: SequenceLikelihood.UNLIKELY,  # 'X'
        60: SequenceLikelihood.UNLIKELY,  # 'Y'
        63: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.POSITIVE,  # 'b'
        12: SequenceLikelihood.POSITIVE,  # 'c'
        11: SequenceLikelihood.POSITIVE,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        17: SequenceLikelihood.POSITIVE,  # 'f'
        18: SequenceLikelihood.POSITIVE,  # 'g'
        20: SequenceLikelihood.POSITIVE,  # 'h'
        5: SequenceLikelihood.POSITIVE,  # 'i'
        26: SequenceLikelihood.POSITIVE,  # 'j'
        44: SequenceLikelihood.LIKELY,  # 'k'
        10: SequenceLikelihood.POSITIVE,  # 'l'
        14: SequenceLikelihood.POSITIVE,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        8: SequenceLikelihood.POSITIVE,  # 'o'
        13: SequenceLikelihood.POSITIVE,  # 'p'
        21: SequenceLikelihood.LIKELY,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        2: SequenceLikelihood.POSITIVE,  # 's'
        6: SequenceLikelihood.POSITIVE,  # 't'
        9: SequenceLikelihood.UNLIKELY,  # 'u'
        16: SequenceLikelihood.POSITIVE,  # 'v'
        49: SequenceLikelihood.UNLIKELY,  # 'w'
        23: SequenceLikelihood.POSITIVE,  # 'x'
        27: SequenceLikelihood.LIKELY,  # 'y'
        34: SequenceLikelihood.LIKELY,  # 'z'
        66: SequenceLikelihood.UNLIKELY,  # 'À'
        73: SequenceLikelihood.NEGATIVE,  # 'Â'
        83: SequenceLikelihood.NEGATIVE,  # 'Æ'
        69: SequenceLikelihood.UNLIKELY,  # 'Ç'
        70: SequenceLikelihood.UNLIKELY,  # 'È'
        58: SequenceLikelihood.UNLIKELY,  # 'É'
        72: SequenceLikelihood.NEGATIVE,  # 'Ê'
        80: SequenceLikelihood.NEGATIVE,  # 'Ë'
        71: SequenceLikelihood.UNLIKELY,  # 'Î'
        77: SequenceLikelihood.NEGATIVE,  # 'Ï'
        74: SequenceLikelihood.NEGATIVE,  # 'Ô'
        82: SequenceLikelihood.NEGATIVE,  # 'Ù'
        79: SequenceLikelihood.NEGATIVE,  # 'Û'
        78: SequenceLikelihood.NEGATIVE,  # 'Ü'
        22: SequenceLikelihood.UNLIKELY,  # 'à'
        53: SequenceLikelihood.UNLIKELY,  # 'â'
        76: SequenceLikelihood.UNLIKELY,  # 'æ'
        51: SequenceLikelihood.UNLIKELY,  # 'ç'
        28: SequenceLikelihood.LIKELY,  # 'è'
        15: SequenceLikelihood.POSITIVE,  # 'é'
        41: SequenceLikelihood.LIKELY,  # 'ê'
        67: SequenceLikelihood.UNLIKELY,  # 'ë'
        57: SequenceLikelihood.UNLIKELY,  # 'î'
        65: SequenceLikelihood.UNLIKELY,  # 'ï'
        52: SequenceLikelihood.UNLIKELY,  # 'ô'
        62: SequenceLikelihood.UNLIKELY,  # 'ù'
        59: SequenceLikelihood.NEGATIVE,  # 'û'
        68: SequenceLikelihood.NEGATIVE,  # 'ü'
        81: SequenceLikelihood.UNLIKELY,  # 'ÿ'
        75: SequenceLikelihood.UNLIKELY,  # 'Œ'
        64: SequenceLikelihood.NEGATIVE,  # 'œ'
        84: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
    },
    16: {  # 'v'
        29: SequenceLikelihood.UNLIKELY,  # 'A'
        40: SequenceLikelihood.UNLIKELY,  # 'B'
        25: SequenceLikelihood.UNLIKELY,  # 'C'
        35: SequenceLikelihood.UNLIKELY,  # 'D'
        31: SequenceLikelihood.UNLIKELY,  # 'E'
        42: SequenceLikelihood.UNLIKELY,  # 'F'
        47: SequenceLikelihood.UNLIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        48: SequenceLikelihood.UNLIKELY,  # 'J'
        56: SequenceLikelihood.UNLIKELY,  # 'K'
        24: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        43: SequenceLikelihood.UNLIKELY,  # 'O'
        32: SequenceLikelihood.UNLIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        38: SequenceLikelihood.UNLIKELY,  # 'R'
        30: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        46: SequenceLikelihood.UNLIKELY,  # 'U'
        45: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        61: SequenceLikelihood.UNLIKELY,  # 'X'
        60: SequenceLikelihood.UNLIKELY,  # 'Y'
        63: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        12: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        17: SequenceLikelihood.UNLIKELY,  # 'f'
        18: SequenceLikelihood.UNLIKELY,  # 'g'
        20: SequenceLikelihood.UNLIKELY,  # 'h'
        5: SequenceLikelihood.POSITIVE,  # 'i'
        26: SequenceLikelihood.UNLIKELY,  # 'j'
        44: SequenceLikelihood.UNLIKELY,  # 'k'
        10: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        8: SequenceLikelihood.POSITIVE,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        21: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        2: SequenceLikelihood.UNLIKELY,  # 's'
        6: SequenceLikelihood.UNLIKELY,  # 't'
        9: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        49: SequenceLikelihood.UNLIKELY,  # 'w'
        23: SequenceLikelihood.UNLIKELY,  # 'x'
        27: SequenceLikelihood.UNLIKELY,  # 'y'
        34: SequenceLikelihood.UNLIKELY,  # 'z'
        66: SequenceLikelihood.NEGATIVE,  # 'À'
        73: SequenceLikelihood.NEGATIVE,  # 'Â'
        83: SequenceLikelihood.NEGATIVE,  # 'Æ'
        69: SequenceLikelihood.NEGATIVE,  # 'Ç'
        70: SequenceLikelihood.UNLIKELY,  # 'È'
        58: SequenceLikelihood.UNLIKELY,  # 'É'
        72: SequenceLikelihood.UNLIKELY,  # 'Ê'
        80: SequenceLikelihood.NEGATIVE,  # 'Ë'
        71: SequenceLikelihood.NEGATIVE,  # 'Î'
        77: SequenceLikelihood.NEGATIVE,  # 'Ï'
        74: SequenceLikelihood.NEGATIVE,  # 'Ô'
        82: SequenceLikelihood.NEGATIVE,  # 'Ù'
        79: SequenceLikelihood.NEGATIVE,  # 'Û'
        78: SequenceLikelihood.NEGATIVE,  # 'Ü'
        22: SequenceLikelihood.UNLIKELY,  # 'à'
        53: SequenceLikelihood.UNLIKELY,  # 'â'
        76: SequenceLikelihood.UNLIKELY,  # 'æ'
        51: SequenceLikelihood.NEGATIVE,  # 'ç'
        28: SequenceLikelihood.LIKELY,  # 'è'
        15: SequenceLikelihood.POSITIVE,  # 'é'
        41: SequenceLikelihood.LIKELY,  # 'ê'
        67: SequenceLikelihood.UNLIKELY,  # 'ë'
        57: SequenceLikelihood.UNLIKELY,  # 'î'
        65: SequenceLikelihood.UNLIKELY,  # 'ï'
        52: SequenceLikelihood.UNLIKELY,  # 'ô'
        62: SequenceLikelihood.UNLIKELY,  # 'ù'
        59: SequenceLikelihood.UNLIKELY,  # 'û'
        68: SequenceLikelihood.NEGATIVE,  # 'ü'
        81: SequenceLikelihood.NEGATIVE,  # 'ÿ'
        75: SequenceLikelihood.NEGATIVE,  # 'Œ'
        64: SequenceLikelihood.UNLIKELY,  # 'œ'
        84: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
    },
    49: {  # 'w'
        29: SequenceLikelihood.UNLIKELY,  # 'A'
        40: SequenceLikelihood.UNLIKELY,  # 'B'
        25: SequenceLikelihood.UNLIKELY,  # 'C'
        35: SequenceLikelihood.UNLIKELY,  # 'D'
        31: SequenceLikelihood.UNLIKELY,  # 'E'
        42: SequenceLikelihood.UNLIKELY,  # 'F'
        47: SequenceLikelihood.UNLIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        48: SequenceLikelihood.UNLIKELY,  # 'J'
        56: SequenceLikelihood.UNLIKELY,  # 'K'
        24: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        43: SequenceLikelihood.UNLIKELY,  # 'O'
        32: SequenceLikelihood.UNLIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        38: SequenceLikelihood.UNLIKELY,  # 'R'
        30: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        46: SequenceLikelihood.UNLIKELY,  # 'U'
        45: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        61: SequenceLikelihood.UNLIKELY,  # 'X'
        60: SequenceLikelihood.UNLIKELY,  # 'Y'
        63: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        12: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        17: SequenceLikelihood.UNLIKELY,  # 'f'
        18: SequenceLikelihood.UNLIKELY,  # 'g'
        20: SequenceLikelihood.LIKELY,  # 'h'
        5: SequenceLikelihood.POSITIVE,  # 'i'
        26: SequenceLikelihood.UNLIKELY,  # 'j'
        44: SequenceLikelihood.UNLIKELY,  # 'k'
        10: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.LIKELY,  # 'n'
        8: SequenceLikelihood.LIKELY,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        21: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        2: SequenceLikelihood.LIKELY,  # 's'
        6: SequenceLikelihood.UNLIKELY,  # 't'
        9: SequenceLikelihood.UNLIKELY,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        49: SequenceLikelihood.POSITIVE,  # 'w'
        23: SequenceLikelihood.UNLIKELY,  # 'x'
        27: SequenceLikelihood.UNLIKELY,  # 'y'
        34: SequenceLikelihood.UNLIKELY,  # 'z'
        66: SequenceLikelihood.NEGATIVE,  # 'À'
        73: SequenceLikelihood.NEGATIVE,  # 'Â'
        83: SequenceLikelihood.NEGATIVE,  # 'Æ'
        69: SequenceLikelihood.NEGATIVE,  # 'Ç'
        70: SequenceLikelihood.NEGATIVE,  # 'È'
        58: SequenceLikelihood.NEGATIVE,  # 'É'
        72: SequenceLikelihood.NEGATIVE,  # 'Ê'
        80: SequenceLikelihood.NEGATIVE,  # 'Ë'
        71: SequenceLikelihood.NEGATIVE,  # 'Î'
        77: SequenceLikelihood.NEGATIVE,  # 'Ï'
        74: SequenceLikelihood.NEGATIVE,  # 'Ô'
        82: SequenceLikelihood.NEGATIVE,  # 'Ù'
        79: SequenceLikelihood.NEGATIVE,  # 'Û'
        78: SequenceLikelihood.NEGATIVE,  # 'Ü'
        22: SequenceLikelihood.UNLIKELY,  # 'à'
        53: SequenceLikelihood.UNLIKELY,  # 'â'
        76: SequenceLikelihood.NEGATIVE,  # 'æ'
        51: SequenceLikelihood.NEGATIVE,  # 'ç'
        28: SequenceLikelihood.UNLIKELY,  # 'è'
        15: SequenceLikelihood.UNLIKELY,  # 'é'
        41: SequenceLikelihood.UNLIKELY,  # 'ê'
        67: SequenceLikelihood.UNLIKELY,  # 'ë'
        57: SequenceLikelihood.UNLIKELY,  # 'î'
        65: SequenceLikelihood.NEGATIVE,  # 'ï'
        52: SequenceLikelihood.UNLIKELY,  # 'ô'
        62: SequenceLikelihood.UNLIKELY,  # 'ù'
        59: SequenceLikelihood.UNLIKELY,  # 'û'
        68: SequenceLikelihood.UNLIKELY,  # 'ü'
        81: SequenceLikelihood.NEGATIVE,  # 'ÿ'
        75: SequenceLikelihood.NEGATIVE,  # 'Œ'
        64: SequenceLikelihood.NEGATIVE,  # 'œ'
        84: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
    },
    23: {  # 'x'
        29: SequenceLikelihood.UNLIKELY,  # 'A'
        40: SequenceLikelihood.UNLIKELY,  # 'B'
        25: SequenceLikelihood.UNLIKELY,  # 'C'
        35: SequenceLikelihood.UNLIKELY,  # 'D'
        31: SequenceLikelihood.UNLIKELY,  # 'E'
        42: SequenceLikelihood.UNLIKELY,  # 'F'
        47: SequenceLikelihood.UNLIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        48: SequenceLikelihood.UNLIKELY,  # 'J'
        56: SequenceLikelihood.UNLIKELY,  # 'K'
        24: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        43: SequenceLikelihood.UNLIKELY,  # 'O'
        32: SequenceLikelihood.UNLIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        38: SequenceLikelihood.UNLIKELY,  # 'R'
        30: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        46: SequenceLikelihood.UNLIKELY,  # 'U'
        45: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        61: SequenceLikelihood.UNLIKELY,  # 'X'
        60: SequenceLikelihood.UNLIKELY,  # 'Y'
        63: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        12: SequenceLikelihood.POSITIVE,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        17: SequenceLikelihood.UNLIKELY,  # 'f'
        18: SequenceLikelihood.UNLIKELY,  # 'g'
        20: SequenceLikelihood.UNLIKELY,  # 'h'
        5: SequenceLikelihood.POSITIVE,  # 'i'
        26: SequenceLikelihood.UNLIKELY,  # 'j'
        44: SequenceLikelihood.UNLIKELY,  # 'k'
        10: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        8: SequenceLikelihood.LIKELY,  # 'o'
        13: SequenceLikelihood.POSITIVE,  # 'p'
        21: SequenceLikelihood.LIKELY,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        2: SequenceLikelihood.UNLIKELY,  # 's'
        6: SequenceLikelihood.POSITIVE,  # 't'
        9: SequenceLikelihood.LIKELY,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        49: SequenceLikelihood.UNLIKELY,  # 'w'
        23: SequenceLikelihood.UNLIKELY,  # 'x'
        27: SequenceLikelihood.LIKELY,  # 'y'
        34: SequenceLikelihood.UNLIKELY,  # 'z'
        66: SequenceLikelihood.UNLIKELY,  # 'À'
        73: SequenceLikelihood.NEGATIVE,  # 'Â'
        83: SequenceLikelihood.NEGATIVE,  # 'Æ'
        69: SequenceLikelihood.NEGATIVE,  # 'Ç'
        70: SequenceLikelihood.NEGATIVE,  # 'È'
        58: SequenceLikelihood.UNLIKELY,  # 'É'
        72: SequenceLikelihood.NEGATIVE,  # 'Ê'
        80: SequenceLikelihood.NEGATIVE,  # 'Ë'
        71: SequenceLikelihood.UNLIKELY,  # 'Î'
        77: SequenceLikelihood.NEGATIVE,  # 'Ï'
        74: SequenceLikelihood.NEGATIVE,  # 'Ô'
        82: SequenceLikelihood.NEGATIVE,  # 'Ù'
        79: SequenceLikelihood.NEGATIVE,  # 'Û'
        78: SequenceLikelihood.NEGATIVE,  # 'Ü'
        22: SequenceLikelihood.UNLIKELY,  # 'à'
        53: SequenceLikelihood.NEGATIVE,  # 'â'
        76: SequenceLikelihood.UNLIKELY,  # 'æ'
        51: SequenceLikelihood.UNLIKELY,  # 'ç'
        28: SequenceLikelihood.UNLIKELY,  # 'è'
        15: SequenceLikelihood.LIKELY,  # 'é'
        41: SequenceLikelihood.NEGATIVE,  # 'ê'
        67: SequenceLikelihood.UNLIKELY,  # 'ë'
        57: SequenceLikelihood.NEGATIVE,  # 'î'
        65: SequenceLikelihood.UNLIKELY,  # 'ï'
        52: SequenceLikelihood.NEGATIVE,  # 'ô'
        62: SequenceLikelihood.NEGATIVE,  # 'ù'
        59: SequenceLikelihood.NEGATIVE,  # 'û'
        68: SequenceLikelihood.UNLIKELY,  # 'ü'
        81: SequenceLikelihood.NEGATIVE,  # 'ÿ'
        75: SequenceLikelihood.NEGATIVE,  # 'Œ'
        64: SequenceLikelihood.NEGATIVE,  # 'œ'
        84: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
    },
    27: {  # 'y'
        29: SequenceLikelihood.UNLIKELY,  # 'A'
        40: SequenceLikelihood.UNLIKELY,  # 'B'
        25: SequenceLikelihood.UNLIKELY,  # 'C'
        35: SequenceLikelihood.UNLIKELY,  # 'D'
        31: SequenceLikelihood.UNLIKELY,  # 'E'
        42: SequenceLikelihood.UNLIKELY,  # 'F'
        47: SequenceLikelihood.UNLIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        48: SequenceLikelihood.UNLIKELY,  # 'J'
        56: SequenceLikelihood.UNLIKELY,  # 'K'
        24: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        43: SequenceLikelihood.UNLIKELY,  # 'O'
        32: SequenceLikelihood.UNLIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        38: SequenceLikelihood.UNLIKELY,  # 'R'
        30: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        46: SequenceLikelihood.UNLIKELY,  # 'U'
        45: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        61: SequenceLikelihood.UNLIKELY,  # 'X'
        60: SequenceLikelihood.UNLIKELY,  # 'Y'
        63: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.LIKELY,  # 'b'
        12: SequenceLikelihood.POSITIVE,  # 'c'
        11: SequenceLikelihood.LIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        17: SequenceLikelihood.UNLIKELY,  # 'f'
        18: SequenceLikelihood.LIKELY,  # 'g'
        20: SequenceLikelihood.UNLIKELY,  # 'h'
        5: SequenceLikelihood.UNLIKELY,  # 'i'
        26: SequenceLikelihood.UNLIKELY,  # 'j'
        44: SequenceLikelihood.UNLIKELY,  # 'k'
        10: SequenceLikelihood.POSITIVE,  # 'l'
        14: SequenceLikelihood.POSITIVE,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        8: SequenceLikelihood.POSITIVE,  # 'o'
        13: SequenceLikelihood.POSITIVE,  # 'p'
        21: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.LIKELY,  # 'r'
        2: SequenceLikelihood.POSITIVE,  # 's'
        6: SequenceLikelihood.LIKELY,  # 't'
        9: SequenceLikelihood.LIKELY,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        49: SequenceLikelihood.UNLIKELY,  # 'w'
        23: SequenceLikelihood.UNLIKELY,  # 'x'
        27: SequenceLikelihood.UNLIKELY,  # 'y'
        34: SequenceLikelihood.UNLIKELY,  # 'z'
        66: SequenceLikelihood.NEGATIVE,  # 'À'
        73: SequenceLikelihood.NEGATIVE,  # 'Â'
        83: SequenceLikelihood.NEGATIVE,  # 'Æ'
        69: SequenceLikelihood.NEGATIVE,  # 'Ç'
        70: SequenceLikelihood.NEGATIVE,  # 'È'
        58: SequenceLikelihood.UNLIKELY,  # 'É'
        72: SequenceLikelihood.NEGATIVE,  # 'Ê'
        80: SequenceLikelihood.NEGATIVE,  # 'Ë'
        71: SequenceLikelihood.NEGATIVE,  # 'Î'
        77: SequenceLikelihood.NEGATIVE,  # 'Ï'
        74: SequenceLikelihood.NEGATIVE,  # 'Ô'
        82: SequenceLikelihood.NEGATIVE,  # 'Ù'
        79: SequenceLikelihood.NEGATIVE,  # 'Û'
        78: SequenceLikelihood.NEGATIVE,  # 'Ü'
        22: SequenceLikelihood.UNLIKELY,  # 'à'
        53: SequenceLikelihood.UNLIKELY,  # 'â'
        76: SequenceLikelihood.NEGATIVE,  # 'æ'
        51: SequenceLikelihood.UNLIKELY,  # 'ç'
        28: SequenceLikelihood.UNLIKELY,  # 'è'
        15: SequenceLikelihood.POSITIVE,  # 'é'
        41: SequenceLikelihood.UNLIKELY,  # 'ê'
        67: SequenceLikelihood.UNLIKELY,  # 'ë'
        57: SequenceLikelihood.NEGATIVE,  # 'î'
        65: SequenceLikelihood.UNLIKELY,  # 'ï'
        52: SequenceLikelihood.UNLIKELY,  # 'ô'
        62: SequenceLikelihood.NEGATIVE,  # 'ù'
        59: SequenceLikelihood.UNLIKELY,  # 'û'
        68: SequenceLikelihood.UNLIKELY,  # 'ü'
        81: SequenceLikelihood.NEGATIVE,  # 'ÿ'
        75: SequenceLikelihood.NEGATIVE,  # 'Œ'
        64: SequenceLikelihood.NEGATIVE,  # 'œ'
        84: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
    },
    34: {  # 'z'
        29: SequenceLikelihood.UNLIKELY,  # 'A'
        40: SequenceLikelihood.UNLIKELY,  # 'B'
        25: SequenceLikelihood.UNLIKELY,  # 'C'
        35: SequenceLikelihood.UNLIKELY,  # 'D'
        31: SequenceLikelihood.UNLIKELY,  # 'E'
        42: SequenceLikelihood.UNLIKELY,  # 'F'
        47: SequenceLikelihood.UNLIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        48: SequenceLikelihood.UNLIKELY,  # 'J'
        56: SequenceLikelihood.UNLIKELY,  # 'K'
        24: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        43: SequenceLikelihood.UNLIKELY,  # 'O'
        32: SequenceLikelihood.UNLIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        38: SequenceLikelihood.UNLIKELY,  # 'R'
        30: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        46: SequenceLikelihood.UNLIKELY,  # 'U'
        45: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        61: SequenceLikelihood.UNLIKELY,  # 'X'
        60: SequenceLikelihood.UNLIKELY,  # 'Y'
        63: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        12: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        17: SequenceLikelihood.UNLIKELY,  # 'f'
        18: SequenceLikelihood.UNLIKELY,  # 'g'
        20: SequenceLikelihood.UNLIKELY,  # 'h'
        5: SequenceLikelihood.LIKELY,  # 'i'
        26: SequenceLikelihood.UNLIKELY,  # 'j'
        44: SequenceLikelihood.UNLIKELY,  # 'k'
        10: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        8: SequenceLikelihood.POSITIVE,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        21: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        2: SequenceLikelihood.UNLIKELY,  # 's'
        6: SequenceLikelihood.UNLIKELY,  # 't'
        9: SequenceLikelihood.LIKELY,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        49: SequenceLikelihood.UNLIKELY,  # 'w'
        23: SequenceLikelihood.UNLIKELY,  # 'x'
        27: SequenceLikelihood.LIKELY,  # 'y'
        34: SequenceLikelihood.LIKELY,  # 'z'
        66: SequenceLikelihood.UNLIKELY,  # 'À'
        73: SequenceLikelihood.UNLIKELY,  # 'Â'
        83: SequenceLikelihood.NEGATIVE,  # 'Æ'
        69: SequenceLikelihood.NEGATIVE,  # 'Ç'
        70: SequenceLikelihood.NEGATIVE,  # 'È'
        58: SequenceLikelihood.UNLIKELY,  # 'É'
        72: SequenceLikelihood.NEGATIVE,  # 'Ê'
        80: SequenceLikelihood.NEGATIVE,  # 'Ë'
        71: SequenceLikelihood.NEGATIVE,  # 'Î'
        77: SequenceLikelihood.NEGATIVE,  # 'Ï'
        74: SequenceLikelihood.NEGATIVE,  # 'Ô'
        82: SequenceLikelihood.NEGATIVE,  # 'Ù'
        79: SequenceLikelihood.NEGATIVE,  # 'Û'
        78: SequenceLikelihood.NEGATIVE,  # 'Ü'
        22: SequenceLikelihood.UNLIKELY,  # 'à'
        53: SequenceLikelihood.UNLIKELY,  # 'â'
        76: SequenceLikelihood.UNLIKELY,  # 'æ'
        51: SequenceLikelihood.NEGATIVE,  # 'ç'
        28: SequenceLikelihood.UNLIKELY,  # 'è'
        15: SequenceLikelihood.LIKELY,  # 'é'
        41: SequenceLikelihood.UNLIKELY,  # 'ê'
        67: SequenceLikelihood.UNLIKELY,  # 'ë'
        57: SequenceLikelihood.UNLIKELY,  # 'î'
        65: SequenceLikelihood.UNLIKELY,  # 'ï'
        52: SequenceLikelihood.UNLIKELY,  # 'ô'
        62: SequenceLikelihood.UNLIKELY,  # 'ù'
        59: SequenceLikelihood.NEGATIVE,  # 'û'
        68: SequenceLikelihood.UNLIKELY,  # 'ü'
        81: SequenceLikelihood.NEGATIVE,  # 'ÿ'
        75: SequenceLikelihood.NEGATIVE,  # 'Œ'
        64: SequenceLikelihood.NEGATIVE,  # 'œ'
        84: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
    },
    66: {  # 'À'
        29: SequenceLikelihood.NEGATIVE,  # 'A'
        40: SequenceLikelihood.UNLIKELY,  # 'B'
        25: SequenceLikelihood.UNLIKELY,  # 'C'
        35: SequenceLikelihood.UNLIKELY,  # 'D'
        31: SequenceLikelihood.NEGATIVE,  # 'E'
        42: SequenceLikelihood.NEGATIVE,  # 'F'
        47: SequenceLikelihood.NEGATIVE,  # 'G'
        50: SequenceLikelihood.NEGATIVE,  # 'H'
        36: SequenceLikelihood.NEGATIVE,  # 'I'
        48: SequenceLikelihood.UNLIKELY,  # 'J'
        56: SequenceLikelihood.NEGATIVE,  # 'K'
        24: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        43: SequenceLikelihood.NEGATIVE,  # 'O'
        32: SequenceLikelihood.NEGATIVE,  # 'P'
        55: SequenceLikelihood.NEGATIVE,  # 'Q'
        38: SequenceLikelihood.NEGATIVE,  # 'R'
        30: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.NEGATIVE,  # 'T'
        46: SequenceLikelihood.UNLIKELY,  # 'U'
        45: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.NEGATIVE,  # 'W'
        61: SequenceLikelihood.NEGATIVE,  # 'X'
        60: SequenceLikelihood.NEGATIVE,  # 'Y'
        63: SequenceLikelihood.NEGATIVE,  # 'Z'
        3: SequenceLikelihood.NEGATIVE,  # 'a'
        19: SequenceLikelihood.NEGATIVE,  # 'b'
        12: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.NEGATIVE,  # 'e'
        17: SequenceLikelihood.NEGATIVE,  # 'f'
        18: SequenceLikelihood.NEGATIVE,  # 'g'
        20: SequenceLikelihood.NEGATIVE,  # 'h'
        5: SequenceLikelihood.NEGATIVE,  # 'i'
        26: SequenceLikelihood.NEGATIVE,  # 'j'
        44: SequenceLikelihood.NEGATIVE,  # 'k'
        10: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.NEGATIVE,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        8: SequenceLikelihood.NEGATIVE,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        21: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.NEGATIVE,  # 'r'
        2: SequenceLikelihood.NEGATIVE,  # 's'
        6: SequenceLikelihood.NEGATIVE,  # 't'
        9: SequenceLikelihood.UNLIKELY,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        49: SequenceLikelihood.NEGATIVE,  # 'w'
        23: SequenceLikelihood.NEGATIVE,  # 'x'
        27: SequenceLikelihood.NEGATIVE,  # 'y'
        34: SequenceLikelihood.NEGATIVE,  # 'z'
        66: SequenceLikelihood.NEGATIVE,  # 'À'
        73: SequenceLikelihood.NEGATIVE,  # 'Â'
        83: SequenceLikelihood.NEGATIVE,  # 'Æ'
        69: SequenceLikelihood.NEGATIVE,  # 'Ç'
        70: SequenceLikelihood.NEGATIVE,  # 'È'
        58: SequenceLikelihood.NEGATIVE,  # 'É'
        72: SequenceLikelihood.NEGATIVE,  # 'Ê'
        80: SequenceLikelihood.NEGATIVE,  # 'Ë'
        71: SequenceLikelihood.NEGATIVE,  # 'Î'
        77: SequenceLikelihood.NEGATIVE,  # 'Ï'
        74: SequenceLikelihood.NEGATIVE,  # 'Ô'
        82: SequenceLikelihood.NEGATIVE,  # 'Ù'
        79: SequenceLikelihood.NEGATIVE,  # 'Û'
        78: SequenceLikelihood.NEGATIVE,  # 'Ü'
        22: SequenceLikelihood.NEGATIVE,  # 'à'
        53: SequenceLikelihood.NEGATIVE,  # 'â'
        76: SequenceLikelihood.NEGATIVE,  # 'æ'
        51: SequenceLikelihood.NEGATIVE,  # 'ç'
        28: SequenceLikelihood.NEGATIVE,  # 'è'
        15: SequenceLikelihood.NEGATIVE,  # 'é'
        41: SequenceLikelihood.NEGATIVE,  # 'ê'
        67: SequenceLikelihood.NEGATIVE,  # 'ë'
        57: SequenceLikelihood.NEGATIVE,  # 'î'
        65: SequenceLikelihood.NEGATIVE,  # 'ï'
        52: SequenceLikelihood.NEGATIVE,  # 'ô'
        62: SequenceLikelihood.NEGATIVE,  # 'ù'
        59: SequenceLikelihood.NEGATIVE,  # 'û'
        68: SequenceLikelihood.NEGATIVE,  # 'ü'
        81: SequenceLikelihood.NEGATIVE,  # 'ÿ'
        75: SequenceLikelihood.NEGATIVE,  # 'Œ'
        64: SequenceLikelihood.NEGATIVE,  # 'œ'
        84: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
    },
    73: {  # 'Â'
        29: SequenceLikelihood.NEGATIVE,  # 'A'
        40: SequenceLikelihood.UNLIKELY,  # 'B'
        25: SequenceLikelihood.UNLIKELY,  # 'C'
        35: SequenceLikelihood.NEGATIVE,  # 'D'
        31: SequenceLikelihood.NEGATIVE,  # 'E'
        42: SequenceLikelihood.NEGATIVE,  # 'F'
        47: SequenceLikelihood.UNLIKELY,  # 'G'
        50: SequenceLikelihood.NEGATIVE,  # 'H'
        36: SequenceLikelihood.NEGATIVE,  # 'I'
        48: SequenceLikelihood.UNLIKELY,  # 'J'
        56: SequenceLikelihood.NEGATIVE,  # 'K'
        24: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        43: SequenceLikelihood.NEGATIVE,  # 'O'
        32: SequenceLikelihood.UNLIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        38: SequenceLikelihood.UNLIKELY,  # 'R'
        30: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        46: SequenceLikelihood.NEGATIVE,  # 'U'
        45: SequenceLikelihood.NEGATIVE,  # 'V'
        54: SequenceLikelihood.NEGATIVE,  # 'W'
        61: SequenceLikelihood.NEGATIVE,  # 'X'
        60: SequenceLikelihood.NEGATIVE,  # 'Y'
        63: SequenceLikelihood.NEGATIVE,  # 'Z'
        3: SequenceLikelihood.UNLIKELY,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        12: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.UNLIKELY,  # 'e'
        17: SequenceLikelihood.NEGATIVE,  # 'f'
        18: SequenceLikelihood.UNLIKELY,  # 'g'
        20: SequenceLikelihood.NEGATIVE,  # 'h'
        5: SequenceLikelihood.NEGATIVE,  # 'i'
        26: SequenceLikelihood.NEGATIVE,  # 'j'
        44: SequenceLikelihood.NEGATIVE,  # 'k'
        10: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        8: SequenceLikelihood.NEGATIVE,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        21: SequenceLikelihood.NEGATIVE,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        2: SequenceLikelihood.UNLIKELY,  # 's'
        6: SequenceLikelihood.UNLIKELY,  # 't'
        9: SequenceLikelihood.NEGATIVE,  # 'u'
        16: SequenceLikelihood.NEGATIVE,  # 'v'
        49: SequenceLikelihood.NEGATIVE,  # 'w'
        23: SequenceLikelihood.NEGATIVE,  # 'x'
        27: SequenceLikelihood.UNLIKELY,  # 'y'
        34: SequenceLikelihood.NEGATIVE,  # 'z'
        66: SequenceLikelihood.NEGATIVE,  # 'À'
        73: SequenceLikelihood.UNLIKELY,  # 'Â'
        83: SequenceLikelihood.NEGATIVE,  # 'Æ'
        69: SequenceLikelihood.NEGATIVE,  # 'Ç'
        70: SequenceLikelihood.NEGATIVE,  # 'È'
        58: SequenceLikelihood.NEGATIVE,  # 'É'
        72: SequenceLikelihood.NEGATIVE,  # 'Ê'
        80: SequenceLikelihood.NEGATIVE,  # 'Ë'
        71: SequenceLikelihood.NEGATIVE,  # 'Î'
        77: SequenceLikelihood.NEGATIVE,  # 'Ï'
        74: SequenceLikelihood.NEGATIVE,  # 'Ô'
        82: SequenceLikelihood.NEGATIVE,  # 'Ù'
        79: SequenceLikelihood.NEGATIVE,  # 'Û'
        78: SequenceLikelihood.NEGATIVE,  # 'Ü'
        22: SequenceLikelihood.NEGATIVE,  # 'à'
        53: SequenceLikelihood.NEGATIVE,  # 'â'
        76: SequenceLikelihood.NEGATIVE,  # 'æ'
        51: SequenceLikelihood.NEGATIVE,  # 'ç'
        28: SequenceLikelihood.NEGATIVE,  # 'è'
        15: SequenceLikelihood.NEGATIVE,  # 'é'
        41: SequenceLikelihood.NEGATIVE,  # 'ê'
        67: SequenceLikelihood.NEGATIVE,  # 'ë'
        57: SequenceLikelihood.NEGATIVE,  # 'î'
        65: SequenceLikelihood.NEGATIVE,  # 'ï'
        52: SequenceLikelihood.NEGATIVE,  # 'ô'
        62: SequenceLikelihood.NEGATIVE,  # 'ù'
        59: SequenceLikelihood.NEGATIVE,  # 'û'
        68: SequenceLikelihood.NEGATIVE,  # 'ü'
        81: SequenceLikelihood.NEGATIVE,  # 'ÿ'
        75: SequenceLikelihood.NEGATIVE,  # 'Œ'
        64: SequenceLikelihood.UNLIKELY,  # 'œ'
        84: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
    },
    83: {  # 'Æ'
        29: SequenceLikelihood.NEGATIVE,  # 'A'
        40: SequenceLikelihood.NEGATIVE,  # 'B'
        25: SequenceLikelihood.NEGATIVE,  # 'C'
        35: SequenceLikelihood.NEGATIVE,  # 'D'
        31: SequenceLikelihood.NEGATIVE,  # 'E'
        42: SequenceLikelihood.NEGATIVE,  # 'F'
        47: SequenceLikelihood.UNLIKELY,  # 'G'
        50: SequenceLikelihood.NEGATIVE,  # 'H'
        36: SequenceLikelihood.NEGATIVE,  # 'I'
        48: SequenceLikelihood.NEGATIVE,  # 'J'
        56: SequenceLikelihood.NEGATIVE,  # 'K'
        24: SequenceLikelihood.NEGATIVE,  # 'L'
        33: SequenceLikelihood.NEGATIVE,  # 'M'
        39: SequenceLikelihood.NEGATIVE,  # 'N'
        43: SequenceLikelihood.NEGATIVE,  # 'O'
        32: SequenceLikelihood.NEGATIVE,  # 'P'
        55: SequenceLikelihood.NEGATIVE,  # 'Q'
        38: SequenceLikelihood.UNLIKELY,  # 'R'
        30: SequenceLikelihood.NEGATIVE,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        46: SequenceLikelihood.NEGATIVE,  # 'U'
        45: SequenceLikelihood.NEGATIVE,  # 'V'
        54: SequenceLikelihood.NEGATIVE,  # 'W'
        61: SequenceLikelihood.NEGATIVE,  # 'X'
        60: SequenceLikelihood.NEGATIVE,  # 'Y'
        63: SequenceLikelihood.NEGATIVE,  # 'Z'
        3: SequenceLikelihood.NEGATIVE,  # 'a'
        19: SequenceLikelihood.NEGATIVE,  # 'b'
        12: SequenceLikelihood.NEGATIVE,  # 'c'
        11: SequenceLikelihood.NEGATIVE,  # 'd'
        1: SequenceLikelihood.UNLIKELY,  # 'e'
        17: SequenceLikelihood.NEGATIVE,  # 'f'
        18: SequenceLikelihood.UNLIKELY,  # 'g'
        20: SequenceLikelihood.NEGATIVE,  # 'h'
        5: SequenceLikelihood.NEGATIVE,  # 'i'
        26: SequenceLikelihood.NEGATIVE,  # 'j'
        44: SequenceLikelihood.NEGATIVE,  # 'k'
        10: SequenceLikelihood.NEGATIVE,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        8: SequenceLikelihood.UNLIKELY,  # 'o'
        13: SequenceLikelihood.NEGATIVE,  # 'p'
        21: SequenceLikelihood.NEGATIVE,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        2: SequenceLikelihood.UNLIKELY,  # 's'
        6: SequenceLikelihood.UNLIKELY,  # 't'
        9: SequenceLikelihood.NEGATIVE,  # 'u'
        16: SequenceLikelihood.NEGATIVE,  # 'v'
        49: SequenceLikelihood.NEGATIVE,  # 'w'
        23: SequenceLikelihood.NEGATIVE,  # 'x'
        27: SequenceLikelihood.NEGATIVE,  # 'y'
        34: SequenceLikelihood.NEGATIVE,  # 'z'
        66: SequenceLikelihood.NEGATIVE,  # 'À'
        73: SequenceLikelihood.NEGATIVE,  # 'Â'
        83: SequenceLikelihood.NEGATIVE,  # 'Æ'
        69: SequenceLikelihood.NEGATIVE,  # 'Ç'
        70: SequenceLikelihood.NEGATIVE,  # 'È'
        58: SequenceLikelihood.NEGATIVE,  # 'É'
        72: SequenceLikelihood.NEGATIVE,  # 'Ê'
        80: SequenceLikelihood.NEGATIVE,  # 'Ë'
        71: SequenceLikelihood.NEGATIVE,  # 'Î'
        77: SequenceLikelihood.NEGATIVE,  # 'Ï'
        74: SequenceLikelihood.NEGATIVE,  # 'Ô'
        82: SequenceLikelihood.NEGATIVE,  # 'Ù'
        79: SequenceLikelihood.NEGATIVE,  # 'Û'
        78: SequenceLikelihood.NEGATIVE,  # 'Ü'
        22: SequenceLikelihood.NEGATIVE,  # 'à'
        53: SequenceLikelihood.NEGATIVE,  # 'â'
        76: SequenceLikelihood.NEGATIVE,  # 'æ'
        51: SequenceLikelihood.NEGATIVE,  # 'ç'
        28: SequenceLikelihood.NEGATIVE,  # 'è'
        15: SequenceLikelihood.NEGATIVE,  # 'é'
        41: SequenceLikelihood.NEGATIVE,  # 'ê'
        67: SequenceLikelihood.NEGATIVE,  # 'ë'
        57: SequenceLikelihood.NEGATIVE,  # 'î'
        65: SequenceLikelihood.NEGATIVE,  # 'ï'
        52: SequenceLikelihood.NEGATIVE,  # 'ô'
        62: SequenceLikelihood.NEGATIVE,  # 'ù'
        59: SequenceLikelihood.NEGATIVE,  # 'û'
        68: SequenceLikelihood.NEGATIVE,  # 'ü'
        81: SequenceLikelihood.NEGATIVE,  # 'ÿ'
        75: SequenceLikelihood.NEGATIVE,  # 'Œ'
        64: SequenceLikelihood.NEGATIVE,  # 'œ'
        84: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
    },
    69: {  # 'Ç'
        29: SequenceLikelihood.UNLIKELY,  # 'A'
        40: SequenceLikelihood.NEGATIVE,  # 'B'
        25: SequenceLikelihood.NEGATIVE,  # 'C'
        35: SequenceLikelihood.NEGATIVE,  # 'D'
        31: SequenceLikelihood.NEGATIVE,  # 'E'
        42: SequenceLikelihood.UNLIKELY,  # 'F'
        47: SequenceLikelihood.NEGATIVE,  # 'G'
        50: SequenceLikelihood.NEGATIVE,  # 'H'
        36: SequenceLikelihood.NEGATIVE,  # 'I'
        48: SequenceLikelihood.NEGATIVE,  # 'J'
        56: SequenceLikelihood.UNLIKELY,  # 'K'
        24: SequenceLikelihood.NEGATIVE,  # 'L'
        33: SequenceLikelihood.NEGATIVE,  # 'M'
        39: SequenceLikelihood.NEGATIVE,  # 'N'
        43: SequenceLikelihood.UNLIKELY,  # 'O'
        32: SequenceLikelihood.NEGATIVE,  # 'P'
        55: SequenceLikelihood.NEGATIVE,  # 'Q'
        38: SequenceLikelihood.NEGATIVE,  # 'R'
        30: SequenceLikelihood.NEGATIVE,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        46: SequenceLikelihood.UNLIKELY,  # 'U'
        45: SequenceLikelihood.NEGATIVE,  # 'V'
        54: SequenceLikelihood.NEGATIVE,  # 'W'
        61: SequenceLikelihood.NEGATIVE,  # 'X'
        60: SequenceLikelihood.NEGATIVE,  # 'Y'
        63: SequenceLikelihood.NEGATIVE,  # 'Z'
        3: SequenceLikelihood.LIKELY,  # 'a'
        19: SequenceLikelihood.NEGATIVE,  # 'b'
        12: SequenceLikelihood.NEGATIVE,  # 'c'
        11: SequenceLikelihood.NEGATIVE,  # 'd'
        1: SequenceLikelihood.UNLIKELY,  # 'e'
        17: SequenceLikelihood.NEGATIVE,  # 'f'
        18: SequenceLikelihood.NEGATIVE,  # 'g'
        20: SequenceLikelihood.NEGATIVE,  # 'h'
        5: SequenceLikelihood.UNLIKELY,  # 'i'
        26: SequenceLikelihood.NEGATIVE,  # 'j'
        44: SequenceLikelihood.NEGATIVE,  # 'k'
        10: SequenceLikelihood.NEGATIVE,  # 'l'
        14: SequenceLikelihood.NEGATIVE,  # 'm'
        4: SequenceLikelihood.NEGATIVE,  # 'n'
        8: SequenceLikelihood.UNLIKELY,  # 'o'
        13: SequenceLikelihood.NEGATIVE,  # 'p'
        21: SequenceLikelihood.NEGATIVE,  # 'q'
        7: SequenceLikelihood.NEGATIVE,  # 'r'
        2: SequenceLikelihood.NEGATIVE,  # 's'
        6: SequenceLikelihood.NEGATIVE,  # 't'
        9: SequenceLikelihood.UNLIKELY,  # 'u'
        16: SequenceLikelihood.NEGATIVE,  # 'v'
        49: SequenceLikelihood.NEGATIVE,  # 'w'
        23: SequenceLikelihood.NEGATIVE,  # 'x'
        27: SequenceLikelihood.NEGATIVE,  # 'y'
        34: SequenceLikelihood.NEGATIVE,  # 'z'
        66: SequenceLikelihood.NEGATIVE,  # 'À'
        73: SequenceLikelihood.NEGATIVE,  # 'Â'
        83: SequenceLikelihood.NEGATIVE,  # 'Æ'
        69: SequenceLikelihood.NEGATIVE,  # 'Ç'
        70: SequenceLikelihood.NEGATIVE,  # 'È'
        58: SequenceLikelihood.UNLIKELY,  # 'É'
        72: SequenceLikelihood.UNLIKELY,  # 'Ê'
        80: SequenceLikelihood.NEGATIVE,  # 'Ë'
        71: SequenceLikelihood.NEGATIVE,  # 'Î'
        77: SequenceLikelihood.NEGATIVE,  # 'Ï'
        74: SequenceLikelihood.NEGATIVE,  # 'Ô'
        82: SequenceLikelihood.NEGATIVE,  # 'Ù'
        79: SequenceLikelihood.NEGATIVE,  # 'Û'
        78: SequenceLikelihood.NEGATIVE,  # 'Ü'
        22: SequenceLikelihood.UNLIKELY,  # 'à'
        53: SequenceLikelihood.UNLIKELY,  # 'â'
        76: SequenceLikelihood.NEGATIVE,  # 'æ'
        51: SequenceLikelihood.NEGATIVE,  # 'ç'
        28: SequenceLikelihood.NEGATIVE,  # 'è'
        15: SequenceLikelihood.NEGATIVE,  # 'é'
        41: SequenceLikelihood.NEGATIVE,  # 'ê'
        67: SequenceLikelihood.NEGATIVE,  # 'ë'
        57: SequenceLikelihood.NEGATIVE,  # 'î'
        65: SequenceLikelihood.NEGATIVE,  # 'ï'
        52: SequenceLikelihood.NEGATIVE,  # 'ô'
        62: SequenceLikelihood.NEGATIVE,  # 'ù'
        59: SequenceLikelihood.NEGATIVE,  # 'û'
        68: SequenceLikelihood.NEGATIVE,  # 'ü'
        81: SequenceLikelihood.NEGATIVE,  # 'ÿ'
        75: SequenceLikelihood.NEGATIVE,  # 'Œ'
        64: SequenceLikelihood.NEGATIVE,  # 'œ'
        84: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
    },
    70: {  # 'È'
        29: SequenceLikelihood.NEGATIVE,  # 'A'
        40: SequenceLikelihood.UNLIKELY,  # 'B'
        25: SequenceLikelihood.UNLIKELY,  # 'C'
        35: SequenceLikelihood.UNLIKELY,  # 'D'
        31: SequenceLikelihood.UNLIKELY,  # 'E'
        42: SequenceLikelihood.UNLIKELY,  # 'F'
        47: SequenceLikelihood.UNLIKELY,  # 'G'
        50: SequenceLikelihood.NEGATIVE,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        48: SequenceLikelihood.NEGATIVE,  # 'J'
        56: SequenceLikelihood.NEGATIVE,  # 'K'
        24: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        43: SequenceLikelihood.NEGATIVE,  # 'O'
        32: SequenceLikelihood.UNLIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        38: SequenceLikelihood.UNLIKELY,  # 'R'
        30: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        46: SequenceLikelihood.NEGATIVE,  # 'U'
        45: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.NEGATIVE,  # 'W'
        61: SequenceLikelihood.NEGATIVE,  # 'X'
        60: SequenceLikelihood.NEGATIVE,  # 'Y'
        63: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.NEGATIVE,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        12: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.NEGATIVE,  # 'd'
        1: SequenceLikelihood.UNLIKELY,  # 'e'
        17: SequenceLikelihood.UNLIKELY,  # 'f'
        18: SequenceLikelihood.NEGATIVE,  # 'g'
        20: SequenceLikelihood.NEGATIVE,  # 'h'
        5: SequenceLikelihood.NEGATIVE,  # 'i'
        26: SequenceLikelihood.NEGATIVE,  # 'j'
        44: SequenceLikelihood.NEGATIVE,  # 'k'
        10: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        8: SequenceLikelihood.NEGATIVE,  # 'o'
        13: SequenceLikelihood.NEGATIVE,  # 'p'
        21: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        2: SequenceLikelihood.UNLIKELY,  # 's'
        6: SequenceLikelihood.UNLIKELY,  # 't'
        9: SequenceLikelihood.NEGATIVE,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        49: SequenceLikelihood.NEGATIVE,  # 'w'
        23: SequenceLikelihood.NEGATIVE,  # 'x'
        27: SequenceLikelihood.NEGATIVE,  # 'y'
        34: SequenceLikelihood.UNLIKELY,  # 'z'
        66: SequenceLikelihood.NEGATIVE,  # 'À'
        73: SequenceLikelihood.NEGATIVE,  # 'Â'
        83: SequenceLikelihood.NEGATIVE,  # 'Æ'
        69: SequenceLikelihood.UNLIKELY,  # 'Ç'
        70: SequenceLikelihood.NEGATIVE,  # 'È'
        58: SequenceLikelihood.NEGATIVE,  # 'É'
        72: SequenceLikelihood.NEGATIVE,  # 'Ê'
        80: SequenceLikelihood.NEGATIVE,  # 'Ë'
        71: SequenceLikelihood.NEGATIVE,  # 'Î'
        77: SequenceLikelihood.NEGATIVE,  # 'Ï'
        74: SequenceLikelihood.NEGATIVE,  # 'Ô'
        82: SequenceLikelihood.NEGATIVE,  # 'Ù'
        79: SequenceLikelihood.NEGATIVE,  # 'Û'
        78: SequenceLikelihood.NEGATIVE,  # 'Ü'
        22: SequenceLikelihood.NEGATIVE,  # 'à'
        53: SequenceLikelihood.NEGATIVE,  # 'â'
        76: SequenceLikelihood.NEGATIVE,  # 'æ'
        51: SequenceLikelihood.NEGATIVE,  # 'ç'
        28: SequenceLikelihood.NEGATIVE,  # 'è'
        15: SequenceLikelihood.NEGATIVE,  # 'é'
        41: SequenceLikelihood.NEGATIVE,  # 'ê'
        67: SequenceLikelihood.NEGATIVE,  # 'ë'
        57: SequenceLikelihood.NEGATIVE,  # 'î'
        65: SequenceLikelihood.NEGATIVE,  # 'ï'
        52: SequenceLikelihood.NEGATIVE,  # 'ô'
        62: SequenceLikelihood.NEGATIVE,  # 'ù'
        59: SequenceLikelihood.NEGATIVE,  # 'û'
        68: SequenceLikelihood.NEGATIVE,  # 'ü'
        81: SequenceLikelihood.NEGATIVE,  # 'ÿ'
        75: SequenceLikelihood.NEGATIVE,  # 'Œ'
        64: SequenceLikelihood.NEGATIVE,  # 'œ'
        84: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
    },
    58: {  # 'É'
        29: SequenceLikelihood.UNLIKELY,  # 'A'
        40: SequenceLikelihood.UNLIKELY,  # 'B'
        25: SequenceLikelihood.UNLIKELY,  # 'C'
        35: SequenceLikelihood.UNLIKELY,  # 'D'
        31: SequenceLikelihood.UNLIKELY,  # 'E'
        42: SequenceLikelihood.UNLIKELY,  # 'F'
        47: SequenceLikelihood.UNLIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        48: SequenceLikelihood.UNLIKELY,  # 'J'
        56: SequenceLikelihood.UNLIKELY,  # 'K'
        24: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        43: SequenceLikelihood.UNLIKELY,  # 'O'
        32: SequenceLikelihood.UNLIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        38: SequenceLikelihood.UNLIKELY,  # 'R'
        30: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        46: SequenceLikelihood.UNLIKELY,  # 'U'
        45: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.NEGATIVE,  # 'W'
        61: SequenceLikelihood.UNLIKELY,  # 'X'
        60: SequenceLikelihood.UNLIKELY,  # 'Y'
        63: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.UNLIKELY,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        12: SequenceLikelihood.LIKELY,  # 'c'
        11: SequenceLikelihood.LIKELY,  # 'd'
        1: SequenceLikelihood.UNLIKELY,  # 'e'
        17: SequenceLikelihood.UNLIKELY,  # 'f'
        18: SequenceLikelihood.LIKELY,  # 'g'
        20: SequenceLikelihood.UNLIKELY,  # 'h'
        5: SequenceLikelihood.UNLIKELY,  # 'i'
        26: SequenceLikelihood.UNLIKELY,  # 'j'
        44: SequenceLikelihood.NEGATIVE,  # 'k'
        10: SequenceLikelihood.LIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        8: SequenceLikelihood.UNLIKELY,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        21: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        2: SequenceLikelihood.UNLIKELY,  # 's'
        6: SequenceLikelihood.POSITIVE,  # 't'
        9: SequenceLikelihood.NEGATIVE,  # 'u'
        16: SequenceLikelihood.LIKELY,  # 'v'
        49: SequenceLikelihood.UNLIKELY,  # 'w'
        23: SequenceLikelihood.UNLIKELY,  # 'x'
        27: SequenceLikelihood.NEGATIVE,  # 'y'
        34: SequenceLikelihood.UNLIKELY,  # 'z'
        66: SequenceLikelihood.NEGATIVE,  # 'À'
        73: SequenceLikelihood.UNLIKELY,  # 'Â'
        83: SequenceLikelihood.NEGATIVE,  # 'Æ'
        69: SequenceLikelihood.UNLIKELY,  # 'Ç'
        70: SequenceLikelihood.UNLIKELY,  # 'È'
        58: SequenceLikelihood.UNLIKELY,  # 'É'
        72: SequenceLikelihood.NEGATIVE,  # 'Ê'
        80: SequenceLikelihood.NEGATIVE,  # 'Ë'
        71: SequenceLikelihood.NEGATIVE,  # 'Î'
        77: SequenceLikelihood.NEGATIVE,  # 'Ï'
        74: SequenceLikelihood.NEGATIVE,  # 'Ô'
        82: SequenceLikelihood.NEGATIVE,  # 'Ù'
        79: SequenceLikelihood.NEGATIVE,  # 'Û'
        78: SequenceLikelihood.NEGATIVE,  # 'Ü'
        22: SequenceLikelihood.NEGATIVE,  # 'à'
        53: SequenceLikelihood.NEGATIVE,  # 'â'
        76: SequenceLikelihood.NEGATIVE,  # 'æ'
        51: SequenceLikelihood.NEGATIVE,  # 'ç'
        28: SequenceLikelihood.NEGATIVE,  # 'è'
        15: SequenceLikelihood.NEGATIVE,  # 'é'
        41: SequenceLikelihood.NEGATIVE,  # 'ê'
        67: SequenceLikelihood.NEGATIVE,  # 'ë'
        57: SequenceLikelihood.NEGATIVE,  # 'î'
        65: SequenceLikelihood.UNLIKELY,  # 'ï'
        52: SequenceLikelihood.UNLIKELY,  # 'ô'
        62: SequenceLikelihood.NEGATIVE,  # 'ù'
        59: SequenceLikelihood.NEGATIVE,  # 'û'
        68: SequenceLikelihood.NEGATIVE,  # 'ü'
        81: SequenceLikelihood.NEGATIVE,  # 'ÿ'
        75: SequenceLikelihood.NEGATIVE,  # 'Œ'
        64: SequenceLikelihood.NEGATIVE,  # 'œ'
        84: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
    },
    72: {  # 'Ê'
        29: SequenceLikelihood.NEGATIVE,  # 'A'
        40: SequenceLikelihood.NEGATIVE,  # 'B'
        25: SequenceLikelihood.UNLIKELY,  # 'C'
        35: SequenceLikelihood.NEGATIVE,  # 'D'
        31: SequenceLikelihood.NEGATIVE,  # 'E'
        42: SequenceLikelihood.NEGATIVE,  # 'F'
        47: SequenceLikelihood.NEGATIVE,  # 'G'
        50: SequenceLikelihood.NEGATIVE,  # 'H'
        36: SequenceLikelihood.NEGATIVE,  # 'I'
        48: SequenceLikelihood.NEGATIVE,  # 'J'
        56: SequenceLikelihood.NEGATIVE,  # 'K'
        24: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        43: SequenceLikelihood.NEGATIVE,  # 'O'
        32: SequenceLikelihood.UNLIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        38: SequenceLikelihood.NEGATIVE,  # 'R'
        30: SequenceLikelihood.NEGATIVE,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        46: SequenceLikelihood.NEGATIVE,  # 'U'
        45: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.NEGATIVE,  # 'W'
        61: SequenceLikelihood.NEGATIVE,  # 'X'
        60: SequenceLikelihood.NEGATIVE,  # 'Y'
        63: SequenceLikelihood.NEGATIVE,  # 'Z'
        3: SequenceLikelihood.NEGATIVE,  # 'a'
        19: SequenceLikelihood.NEGATIVE,  # 'b'
        12: SequenceLikelihood.NEGATIVE,  # 'c'
        11: SequenceLikelihood.NEGATIVE,  # 'd'
        1: SequenceLikelihood.NEGATIVE,  # 'e'
        17: SequenceLikelihood.NEGATIVE,  # 'f'
        18: SequenceLikelihood.NEGATIVE,  # 'g'
        20: SequenceLikelihood.NEGATIVE,  # 'h'
        5: SequenceLikelihood.NEGATIVE,  # 'i'
        26: SequenceLikelihood.NEGATIVE,  # 'j'
        44: SequenceLikelihood.UNLIKELY,  # 'k'
        10: SequenceLikelihood.NEGATIVE,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        8: SequenceLikelihood.NEGATIVE,  # 'o'
        13: SequenceLikelihood.NEGATIVE,  # 'p'
        21: SequenceLikelihood.NEGATIVE,  # 'q'
        7: SequenceLikelihood.NEGATIVE,  # 'r'
        2: SequenceLikelihood.NEGATIVE,  # 's'
        6: SequenceLikelihood.UNLIKELY,  # 't'
        9: SequenceLikelihood.NEGATIVE,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        49: SequenceLikelihood.UNLIKELY,  # 'w'
        23: SequenceLikelihood.NEGATIVE,  # 'x'
        27: SequenceLikelihood.NEGATIVE,  # 'y'
        34: SequenceLikelihood.NEGATIVE,  # 'z'
        66: SequenceLikelihood.NEGATIVE,  # 'À'
        73: SequenceLikelihood.NEGATIVE,  # 'Â'
        83: SequenceLikelihood.NEGATIVE,  # 'Æ'
        69: SequenceLikelihood.NEGATIVE,  # 'Ç'
        70: SequenceLikelihood.NEGATIVE,  # 'È'
        58: SequenceLikelihood.NEGATIVE,  # 'É'
        72: SequenceLikelihood.NEGATIVE,  # 'Ê'
        80: SequenceLikelihood.NEGATIVE,  # 'Ë'
        71: SequenceLikelihood.NEGATIVE,  # 'Î'
        77: SequenceLikelihood.NEGATIVE,  # 'Ï'
        74: SequenceLikelihood.NEGATIVE,  # 'Ô'
        82: SequenceLikelihood.UNLIKELY,  # 'Ù'
        79: SequenceLikelihood.NEGATIVE,  # 'Û'
        78: SequenceLikelihood.NEGATIVE,  # 'Ü'
        22: SequenceLikelihood.NEGATIVE,  # 'à'
        53: SequenceLikelihood.NEGATIVE,  # 'â'
        76: SequenceLikelihood.NEGATIVE,  # 'æ'
        51: SequenceLikelihood.NEGATIVE,  # 'ç'
        28: SequenceLikelihood.NEGATIVE,  # 'è'
        15: SequenceLikelihood.UNLIKELY,  # 'é'
        41: SequenceLikelihood.NEGATIVE,  # 'ê'
        67: SequenceLikelihood.NEGATIVE,  # 'ë'
        57: SequenceLikelihood.NEGATIVE,  # 'î'
        65: SequenceLikelihood.NEGATIVE,  # 'ï'
        52: SequenceLikelihood.NEGATIVE,  # 'ô'
        62: SequenceLikelihood.NEGATIVE,  # 'ù'
        59: SequenceLikelihood.NEGATIVE,  # 'û'
        68: SequenceLikelihood.NEGATIVE,  # 'ü'
        81: SequenceLikelihood.NEGATIVE,  # 'ÿ'
        75: SequenceLikelihood.NEGATIVE,  # 'Œ'
        64: SequenceLikelihood.NEGATIVE,  # 'œ'
        84: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
    },
    80: {  # 'Ë'
        29: SequenceLikelihood.NEGATIVE,  # 'A'
        40: SequenceLikelihood.NEGATIVE,  # 'B'
        25: SequenceLikelihood.UNLIKELY,  # 'C'
        35: SequenceLikelihood.NEGATIVE,  # 'D'
        31: SequenceLikelihood.NEGATIVE,  # 'E'
        42: SequenceLikelihood.NEGATIVE,  # 'F'
        47: SequenceLikelihood.NEGATIVE,  # 'G'
        50: SequenceLikelihood.NEGATIVE,  # 'H'
        36: SequenceLikelihood.NEGATIVE,  # 'I'
        48: SequenceLikelihood.NEGATIVE,  # 'J'
        56: SequenceLikelihood.NEGATIVE,  # 'K'
        24: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        43: SequenceLikelihood.NEGATIVE,  # 'O'
        32: SequenceLikelihood.NEGATIVE,  # 'P'
        55: SequenceLikelihood.NEGATIVE,  # 'Q'
        38: SequenceLikelihood.UNLIKELY,  # 'R'
        30: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        46: SequenceLikelihood.UNLIKELY,  # 'U'
        45: SequenceLikelihood.NEGATIVE,  # 'V'
        54: SequenceLikelihood.NEGATIVE,  # 'W'
        61: SequenceLikelihood.NEGATIVE,  # 'X'
        60: SequenceLikelihood.NEGATIVE,  # 'Y'
        63: SequenceLikelihood.NEGATIVE,  # 'Z'
        3: SequenceLikelihood.NEGATIVE,  # 'a'
        19: SequenceLikelihood.NEGATIVE,  # 'b'
        12: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.NEGATIVE,  # 'e'
        17: SequenceLikelihood.NEGATIVE,  # 'f'
        18: SequenceLikelihood.NEGATIVE,  # 'g'
        20: SequenceLikelihood.NEGATIVE,  # 'h'
        5: SequenceLikelihood.NEGATIVE,  # 'i'
        26: SequenceLikelihood.NEGATIVE,  # 'j'
        44: SequenceLikelihood.NEGATIVE,  # 'k'
        10: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.NEGATIVE,  # 'm'
        4: SequenceLikelihood.NEGATIVE,  # 'n'
        8: SequenceLikelihood.NEGATIVE,  # 'o'
        13: SequenceLikelihood.NEGATIVE,  # 'p'
        21: SequenceLikelihood.NEGATIVE,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        2: SequenceLikelihood.NEGATIVE,  # 's'
        6: SequenceLikelihood.NEGATIVE,  # 't'
        9: SequenceLikelihood.NEGATIVE,  # 'u'
        16: SequenceLikelihood.NEGATIVE,  # 'v'
        49: SequenceLikelihood.NEGATIVE,  # 'w'
        23: SequenceLikelihood.NEGATIVE,  # 'x'
        27: SequenceLikelihood.NEGATIVE,  # 'y'
        34: SequenceLikelihood.NEGATIVE,  # 'z'
        66: SequenceLikelihood.NEGATIVE,  # 'À'
        73: SequenceLikelihood.NEGATIVE,  # 'Â'
        83: SequenceLikelihood.NEGATIVE,  # 'Æ'
        69: SequenceLikelihood.NEGATIVE,  # 'Ç'
        70: SequenceLikelihood.NEGATIVE,  # 'È'
        58: SequenceLikelihood.NEGATIVE,  # 'É'
        72: SequenceLikelihood.NEGATIVE,  # 'Ê'
        80: SequenceLikelihood.NEGATIVE,  # 'Ë'
        71: SequenceLikelihood.NEGATIVE,  # 'Î'
        77: SequenceLikelihood.NEGATIVE,  # 'Ï'
        74: SequenceLikelihood.NEGATIVE,  # 'Ô'
        82: SequenceLikelihood.NEGATIVE,  # 'Ù'
        79: SequenceLikelihood.NEGATIVE,  # 'Û'
        78: SequenceLikelihood.NEGATIVE,  # 'Ü'
        22: SequenceLikelihood.NEGATIVE,  # 'à'
        53: SequenceLikelihood.NEGATIVE,  # 'â'
        76: SequenceLikelihood.NEGATIVE,  # 'æ'
        51: SequenceLikelihood.NEGATIVE,  # 'ç'
        28: SequenceLikelihood.NEGATIVE,  # 'è'
        15: SequenceLikelihood.NEGATIVE,  # 'é'
        41: SequenceLikelihood.NEGATIVE,  # 'ê'
        67: SequenceLikelihood.NEGATIVE,  # 'ë'
        57: SequenceLikelihood.NEGATIVE,  # 'î'
        65: SequenceLikelihood.NEGATIVE,  # 'ï'
        52: SequenceLikelihood.NEGATIVE,  # 'ô'
        62: SequenceLikelihood.NEGATIVE,  # 'ù'
        59: SequenceLikelihood.NEGATIVE,  # 'û'
        68: SequenceLikelihood.NEGATIVE,  # 'ü'
        81: SequenceLikelihood.NEGATIVE,  # 'ÿ'
        75: SequenceLikelihood.NEGATIVE,  # 'Œ'
        64: SequenceLikelihood.NEGATIVE,  # 'œ'
        84: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
    },
    71: {  # 'Î'
        29: SequenceLikelihood.NEGATIVE,  # 'A'
        40: SequenceLikelihood.NEGATIVE,  # 'B'
        25: SequenceLikelihood.UNLIKELY,  # 'C'
        35: SequenceLikelihood.NEGATIVE,  # 'D'
        31: SequenceLikelihood.UNLIKELY,  # 'E'
        42: SequenceLikelihood.NEGATIVE,  # 'F'
        47: SequenceLikelihood.NEGATIVE,  # 'G'
        50: SequenceLikelihood.NEGATIVE,  # 'H'
        36: SequenceLikelihood.NEGATIVE,  # 'I'
        48: SequenceLikelihood.NEGATIVE,  # 'J'
        56: SequenceLikelihood.NEGATIVE,  # 'K'
        24: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        43: SequenceLikelihood.NEGATIVE,  # 'O'
        32: SequenceLikelihood.NEGATIVE,  # 'P'
        55: SequenceLikelihood.NEGATIVE,  # 'Q'
        38: SequenceLikelihood.NEGATIVE,  # 'R'
        30: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        46: SequenceLikelihood.NEGATIVE,  # 'U'
        45: SequenceLikelihood.NEGATIVE,  # 'V'
        54: SequenceLikelihood.NEGATIVE,  # 'W'
        61: SequenceLikelihood.NEGATIVE,  # 'X'
        60: SequenceLikelihood.NEGATIVE,  # 'Y'
        63: SequenceLikelihood.NEGATIVE,  # 'Z'
        3: SequenceLikelihood.NEGATIVE,  # 'a'
        19: SequenceLikelihood.NEGATIVE,  # 'b'
        12: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.NEGATIVE,  # 'e'
        17: SequenceLikelihood.NEGATIVE,  # 'f'
        18: SequenceLikelihood.NEGATIVE,  # 'g'
        20: SequenceLikelihood.UNLIKELY,  # 'h'
        5: SequenceLikelihood.NEGATIVE,  # 'i'
        26: SequenceLikelihood.NEGATIVE,  # 'j'
        44: SequenceLikelihood.NEGATIVE,  # 'k'
        10: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.NEGATIVE,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        8: SequenceLikelihood.NEGATIVE,  # 'o'
        13: SequenceLikelihood.NEGATIVE,  # 'p'
        21: SequenceLikelihood.NEGATIVE,  # 'q'
        7: SequenceLikelihood.NEGATIVE,  # 'r'
        2: SequenceLikelihood.UNLIKELY,  # 's'
        6: SequenceLikelihood.UNLIKELY,  # 't'
        9: SequenceLikelihood.NEGATIVE,  # 'u'
        16: SequenceLikelihood.NEGATIVE,  # 'v'
        49: SequenceLikelihood.NEGATIVE,  # 'w'
        23: SequenceLikelihood.NEGATIVE,  # 'x'
        27: SequenceLikelihood.NEGATIVE,  # 'y'
        34: SequenceLikelihood.NEGATIVE,  # 'z'
        66: SequenceLikelihood.NEGATIVE,  # 'À'
        73: SequenceLikelihood.NEGATIVE,  # 'Â'
        83: SequenceLikelihood.NEGATIVE,  # 'Æ'
        69: SequenceLikelihood.NEGATIVE,  # 'Ç'
        70: SequenceLikelihood.NEGATIVE,  # 'È'
        58: SequenceLikelihood.NEGATIVE,  # 'É'
        72: SequenceLikelihood.NEGATIVE,  # 'Ê'
        80: SequenceLikelihood.NEGATIVE,  # 'Ë'
        71: SequenceLikelihood.NEGATIVE,  # 'Î'
        77: SequenceLikelihood.NEGATIVE,  # 'Ï'
        74: SequenceLikelihood.NEGATIVE,  # 'Ô'
        82: SequenceLikelihood.NEGATIVE,  # 'Ù'
        79: SequenceLikelihood.NEGATIVE,  # 'Û'
        78: SequenceLikelihood.NEGATIVE,  # 'Ü'
        22: SequenceLikelihood.NEGATIVE,  # 'à'
        53: SequenceLikelihood.NEGATIVE,  # 'â'
        76: SequenceLikelihood.NEGATIVE,  # 'æ'
        51: SequenceLikelihood.NEGATIVE,  # 'ç'
        28: SequenceLikelihood.NEGATIVE,  # 'è'
        15: SequenceLikelihood.NEGATIVE,  # 'é'
        41: SequenceLikelihood.NEGATIVE,  # 'ê'
        67: SequenceLikelihood.NEGATIVE,  # 'ë'
        57: SequenceLikelihood.NEGATIVE,  # 'î'
        65: SequenceLikelihood.NEGATIVE,  # 'ï'
        52: SequenceLikelihood.NEGATIVE,  # 'ô'
        62: SequenceLikelihood.NEGATIVE,  # 'ù'
        59: SequenceLikelihood.NEGATIVE,  # 'û'
        68: SequenceLikelihood.NEGATIVE,  # 'ü'
        81: SequenceLikelihood.NEGATIVE,  # 'ÿ'
        75: SequenceLikelihood.NEGATIVE,  # 'Œ'
        64: SequenceLikelihood.NEGATIVE,  # 'œ'
        84: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
    },
    77: {  # 'Ï'
        29: SequenceLikelihood.UNLIKELY,  # 'A'
        40: SequenceLikelihood.UNLIKELY,  # 'B'
        25: SequenceLikelihood.UNLIKELY,  # 'C'
        35: SequenceLikelihood.UNLIKELY,  # 'D'
        31: SequenceLikelihood.UNLIKELY,  # 'E'
        42: SequenceLikelihood.UNLIKELY,  # 'F'
        47: SequenceLikelihood.UNLIKELY,  # 'G'
        50: SequenceLikelihood.NEGATIVE,  # 'H'
        36: SequenceLikelihood.NEGATIVE,  # 'I'
        48: SequenceLikelihood.NEGATIVE,  # 'J'
        56: SequenceLikelihood.UNLIKELY,  # 'K'
        24: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.NEGATIVE,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        43: SequenceLikelihood.NEGATIVE,  # 'O'
        32: SequenceLikelihood.NEGATIVE,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        38: SequenceLikelihood.UNLIKELY,  # 'R'
        30: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        46: SequenceLikelihood.NEGATIVE,  # 'U'
        45: SequenceLikelihood.NEGATIVE,  # 'V'
        54: SequenceLikelihood.NEGATIVE,  # 'W'
        61: SequenceLikelihood.UNLIKELY,  # 'X'
        60: SequenceLikelihood.NEGATIVE,  # 'Y'
        63: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.UNLIKELY,  # 'a'
        19: SequenceLikelihood.NEGATIVE,  # 'b'
        12: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.UNLIKELY,  # 'e'
        17: SequenceLikelihood.UNLIKELY,  # 'f'
        18: SequenceLikelihood.NEGATIVE,  # 'g'
        20: SequenceLikelihood.NEGATIVE,  # 'h'
        5: SequenceLikelihood.NEGATIVE,  # 'i'
        26: SequenceLikelihood.NEGATIVE,  # 'j'
        44: SequenceLikelihood.NEGATIVE,  # 'k'
        10: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.NEGATIVE,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        8: SequenceLikelihood.NEGATIVE,  # 'o'
        13: SequenceLikelihood.NEGATIVE,  # 'p'
        21: SequenceLikelihood.NEGATIVE,  # 'q'
        7: SequenceLikelihood.NEGATIVE,  # 'r'
        2: SequenceLikelihood.UNLIKELY,  # 's'
        6: SequenceLikelihood.UNLIKELY,  # 't'
        9: SequenceLikelihood.UNLIKELY,  # 'u'
        16: SequenceLikelihood.NEGATIVE,  # 'v'
        49: SequenceLikelihood.NEGATIVE,  # 'w'
        23: SequenceLikelihood.NEGATIVE,  # 'x'
        27: SequenceLikelihood.NEGATIVE,  # 'y'
        34: SequenceLikelihood.NEGATIVE,  # 'z'
        66: SequenceLikelihood.NEGATIVE,  # 'À'
        73: SequenceLikelihood.NEGATIVE,  # 'Â'
        83: SequenceLikelihood.NEGATIVE,  # 'Æ'
        69: SequenceLikelihood.NEGATIVE,  # 'Ç'
        70: SequenceLikelihood.NEGATIVE,  # 'È'
        58: SequenceLikelihood.NEGATIVE,  # 'É'
        72: SequenceLikelihood.NEGATIVE,  # 'Ê'
        80: SequenceLikelihood.NEGATIVE,  # 'Ë'
        71: SequenceLikelihood.NEGATIVE,  # 'Î'
        77: SequenceLikelihood.UNLIKELY,  # 'Ï'
        74: SequenceLikelihood.NEGATIVE,  # 'Ô'
        82: SequenceLikelihood.NEGATIVE,  # 'Ù'
        79: SequenceLikelihood.NEGATIVE,  # 'Û'
        78: SequenceLikelihood.NEGATIVE,  # 'Ü'
        22: SequenceLikelihood.NEGATIVE,  # 'à'
        53: SequenceLikelihood.NEGATIVE,  # 'â'
        76: SequenceLikelihood.NEGATIVE,  # 'æ'
        51: SequenceLikelihood.NEGATIVE,  # 'ç'
        28: SequenceLikelihood.NEGATIVE,  # 'è'
        15: SequenceLikelihood.NEGATIVE,  # 'é'
        41: SequenceLikelihood.NEGATIVE,  # 'ê'
        67: SequenceLikelihood.NEGATIVE,  # 'ë'
        57: SequenceLikelihood.NEGATIVE,  # 'î'
        65: SequenceLikelihood.NEGATIVE,  # 'ï'
        52: SequenceLikelihood.NEGATIVE,  # 'ô'
        62: SequenceLikelihood.NEGATIVE,  # 'ù'
        59: SequenceLikelihood.NEGATIVE,  # 'û'
        68: SequenceLikelihood.NEGATIVE,  # 'ü'
        81: SequenceLikelihood.NEGATIVE,  # 'ÿ'
        75: SequenceLikelihood.NEGATIVE,  # 'Œ'
        64: SequenceLikelihood.NEGATIVE,  # 'œ'
        84: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
    },
    74: {  # 'Ô'
        29: SequenceLikelihood.UNLIKELY,  # 'A'
        40: SequenceLikelihood.UNLIKELY,  # 'B'
        25: SequenceLikelihood.UNLIKELY,  # 'C'
        35: SequenceLikelihood.UNLIKELY,  # 'D'
        31: SequenceLikelihood.NEGATIVE,  # 'E'
        42: SequenceLikelihood.NEGATIVE,  # 'F'
        47: SequenceLikelihood.NEGATIVE,  # 'G'
        50: SequenceLikelihood.NEGATIVE,  # 'H'
        36: SequenceLikelihood.NEGATIVE,  # 'I'
        48: SequenceLikelihood.UNLIKELY,  # 'J'
        56: SequenceLikelihood.NEGATIVE,  # 'K'
        24: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        43: SequenceLikelihood.NEGATIVE,  # 'O'
        32: SequenceLikelihood.UNLIKELY,  # 'P'
        55: SequenceLikelihood.NEGATIVE,  # 'Q'
        38: SequenceLikelihood.UNLIKELY,  # 'R'
        30: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        46: SequenceLikelihood.UNLIKELY,  # 'U'
        45: SequenceLikelihood.NEGATIVE,  # 'V'
        54: SequenceLikelihood.NEGATIVE,  # 'W'
        61: SequenceLikelihood.NEGATIVE,  # 'X'
        60: SequenceLikelihood.NEGATIVE,  # 'Y'
        63: SequenceLikelihood.NEGATIVE,  # 'Z'
        3: SequenceLikelihood.NEGATIVE,  # 'a'
        19: SequenceLikelihood.NEGATIVE,  # 'b'
        12: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.NEGATIVE,  # 'e'
        17: SequenceLikelihood.NEGATIVE,  # 'f'
        18: SequenceLikelihood.NEGATIVE,  # 'g'
        20: SequenceLikelihood.NEGATIVE,  # 'h'
        5: SequenceLikelihood.NEGATIVE,  # 'i'
        26: SequenceLikelihood.NEGATIVE,  # 'j'
        44: SequenceLikelihood.UNLIKELY,  # 'k'
        10: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        8: SequenceLikelihood.UNLIKELY,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        21: SequenceLikelihood.NEGATIVE,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        2: SequenceLikelihood.UNLIKELY,  # 's'
        6: SequenceLikelihood.UNLIKELY,  # 't'
        9: SequenceLikelihood.NEGATIVE,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        49: SequenceLikelihood.NEGATIVE,  # 'w'
        23: SequenceLikelihood.NEGATIVE,  # 'x'
        27: SequenceLikelihood.NEGATIVE,  # 'y'
        34: SequenceLikelihood.UNLIKELY,  # 'z'
        66: SequenceLikelihood.NEGATIVE,  # 'À'
        73: SequenceLikelihood.NEGATIVE,  # 'Â'
        83: SequenceLikelihood.NEGATIVE,  # 'Æ'
        69: SequenceLikelihood.NEGATIVE,  # 'Ç'
        70: SequenceLikelihood.NEGATIVE,  # 'È'
        58: SequenceLikelihood.NEGATIVE,  # 'É'
        72: SequenceLikelihood.NEGATIVE,  # 'Ê'
        80: SequenceLikelihood.NEGATIVE,  # 'Ë'
        71: SequenceLikelihood.NEGATIVE,  # 'Î'
        77: SequenceLikelihood.NEGATIVE,  # 'Ï'
        74: SequenceLikelihood.UNLIKELY,  # 'Ô'
        82: SequenceLikelihood.NEGATIVE,  # 'Ù'
        79: SequenceLikelihood.NEGATIVE,  # 'Û'
        78: SequenceLikelihood.NEGATIVE,  # 'Ü'
        22: SequenceLikelihood.NEGATIVE,  # 'à'
        53: SequenceLikelihood.NEGATIVE,  # 'â'
        76: SequenceLikelihood.NEGATIVE,  # 'æ'
        51: SequenceLikelihood.NEGATIVE,  # 'ç'
        28: SequenceLikelihood.NEGATIVE,  # 'è'
        15: SequenceLikelihood.NEGATIVE,  # 'é'
        41: SequenceLikelihood.NEGATIVE,  # 'ê'
        67: SequenceLikelihood.NEGATIVE,  # 'ë'
        57: SequenceLikelihood.NEGATIVE,  # 'î'
        65: SequenceLikelihood.NEGATIVE,  # 'ï'
        52: SequenceLikelihood.NEGATIVE,  # 'ô'
        62: SequenceLikelihood.NEGATIVE,  # 'ù'
        59: SequenceLikelihood.NEGATIVE,  # 'û'
        68: SequenceLikelihood.NEGATIVE,  # 'ü'
        81: SequenceLikelihood.NEGATIVE,  # 'ÿ'
        75: SequenceLikelihood.NEGATIVE,  # 'Œ'
        64: SequenceLikelihood.NEGATIVE,  # 'œ'
        84: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
    },
    82: {  # 'Ù'
        29: SequenceLikelihood.NEGATIVE,  # 'A'
        40: SequenceLikelihood.NEGATIVE,  # 'B'
        25: SequenceLikelihood.NEGATIVE,  # 'C'
        35: SequenceLikelihood.NEGATIVE,  # 'D'
        31: SequenceLikelihood.NEGATIVE,  # 'E'
        42: SequenceLikelihood.NEGATIVE,  # 'F'
        47: SequenceLikelihood.NEGATIVE,  # 'G'
        50: SequenceLikelihood.NEGATIVE,  # 'H'
        36: SequenceLikelihood.NEGATIVE,  # 'I'
        48: SequenceLikelihood.NEGATIVE,  # 'J'
        56: SequenceLikelihood.NEGATIVE,  # 'K'
        24: SequenceLikelihood.NEGATIVE,  # 'L'
        33: SequenceLikelihood.NEGATIVE,  # 'M'
        39: SequenceLikelihood.NEGATIVE,  # 'N'
        43: SequenceLikelihood.NEGATIVE,  # 'O'
        32: SequenceLikelihood.NEGATIVE,  # 'P'
        55: SequenceLikelihood.NEGATIVE,  # 'Q'
        38: SequenceLikelihood.NEGATIVE,  # 'R'
        30: SequenceLikelihood.NEGATIVE,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        46: SequenceLikelihood.NEGATIVE,  # 'U'
        45: SequenceLikelihood.NEGATIVE,  # 'V'
        54: SequenceLikelihood.NEGATIVE,  # 'W'
        61: SequenceLikelihood.NEGATIVE,  # 'X'
        60: SequenceLikelihood.NEGATIVE,  # 'Y'
        63: SequenceLikelihood.NEGATIVE,  # 'Z'
        3: SequenceLikelihood.UNLIKELY,  # 'a'
        19: SequenceLikelihood.NEGATIVE,  # 'b'
        12: SequenceLikelihood.NEGATIVE,  # 'c'
        11: SequenceLikelihood.NEGATIVE,  # 'd'
        1: SequenceLikelihood.NEGATIVE,  # 'e'
        17: SequenceLikelihood.NEGATIVE,  # 'f'
        18: SequenceLikelihood.NEGATIVE,  # 'g'
        20: SequenceLikelihood.NEGATIVE,  # 'h'
        5: SequenceLikelihood.NEGATIVE,  # 'i'
        26: SequenceLikelihood.NEGATIVE,  # 'j'
        44: SequenceLikelihood.NEGATIVE,  # 'k'
        10: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.NEGATIVE,  # 'm'
        4: SequenceLikelihood.NEGATIVE,  # 'n'
        8: SequenceLikelihood.NEGATIVE,  # 'o'
        13: SequenceLikelihood.NEGATIVE,  # 'p'
        21: SequenceLikelihood.NEGATIVE,  # 'q'
        7: SequenceLikelihood.NEGATIVE,  # 'r'
        2: SequenceLikelihood.NEGATIVE,  # 's'
        6: SequenceLikelihood.NEGATIVE,  # 't'
        9: SequenceLikelihood.NEGATIVE,  # 'u'
        16: SequenceLikelihood.NEGATIVE,  # 'v'
        49: SequenceLikelihood.NEGATIVE,  # 'w'
        23: SequenceLikelihood.NEGATIVE,  # 'x'
        27: SequenceLikelihood.NEGATIVE,  # 'y'
        34: SequenceLikelihood.NEGATIVE,  # 'z'
        66: SequenceLikelihood.NEGATIVE,  # 'À'
        73: SequenceLikelihood.NEGATIVE,  # 'Â'
        83: SequenceLikelihood.NEGATIVE,  # 'Æ'
        69: SequenceLikelihood.NEGATIVE,  # 'Ç'
        70: SequenceLikelihood.NEGATIVE,  # 'È'
        58: SequenceLikelihood.NEGATIVE,  # 'É'
        72: SequenceLikelihood.NEGATIVE,  # 'Ê'
        80: SequenceLikelihood.NEGATIVE,  # 'Ë'
        71: SequenceLikelihood.NEGATIVE,  # 'Î'
        77: SequenceLikelihood.NEGATIVE,  # 'Ï'
        74: SequenceLikelihood.NEGATIVE,  # 'Ô'
        82: SequenceLikelihood.NEGATIVE,  # 'Ù'
        79: SequenceLikelihood.NEGATIVE,  # 'Û'
        78: SequenceLikelihood.NEGATIVE,  # 'Ü'
        22: SequenceLikelihood.NEGATIVE,  # 'à'
        53: SequenceLikelihood.NEGATIVE,  # 'â'
        76: SequenceLikelihood.NEGATIVE,  # 'æ'
        51: SequenceLikelihood.NEGATIVE,  # 'ç'
        28: SequenceLikelihood.NEGATIVE,  # 'è'
        15: SequenceLikelihood.NEGATIVE,  # 'é'
        41: SequenceLikelihood.NEGATIVE,  # 'ê'
        67: SequenceLikelihood.NEGATIVE,  # 'ë'
        57: SequenceLikelihood.NEGATIVE,  # 'î'
        65: SequenceLikelihood.NEGATIVE,  # 'ï'
        52: SequenceLikelihood.NEGATIVE,  # 'ô'
        62: SequenceLikelihood.NEGATIVE,  # 'ù'
        59: SequenceLikelihood.NEGATIVE,  # 'û'
        68: SequenceLikelihood.NEGATIVE,  # 'ü'
        81: SequenceLikelihood.NEGATIVE,  # 'ÿ'
        75: SequenceLikelihood.NEGATIVE,  # 'Œ'
        64: SequenceLikelihood.NEGATIVE,  # 'œ'
        84: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
    },
    79: {  # 'Û'
        29: SequenceLikelihood.NEGATIVE,  # 'A'
        40: SequenceLikelihood.NEGATIVE,  # 'B'
        25: SequenceLikelihood.NEGATIVE,  # 'C'
        35: SequenceLikelihood.NEGATIVE,  # 'D'
        31: SequenceLikelihood.NEGATIVE,  # 'E'
        42: SequenceLikelihood.NEGATIVE,  # 'F'
        47: SequenceLikelihood.NEGATIVE,  # 'G'
        50: SequenceLikelihood.NEGATIVE,  # 'H'
        36: SequenceLikelihood.NEGATIVE,  # 'I'
        48: SequenceLikelihood.UNLIKELY,  # 'J'
        56: SequenceLikelihood.NEGATIVE,  # 'K'
        24: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        43: SequenceLikelihood.NEGATIVE,  # 'O'
        32: SequenceLikelihood.NEGATIVE,  # 'P'
        55: SequenceLikelihood.NEGATIVE,  # 'Q'
        38: SequenceLikelihood.UNLIKELY,  # 'R'
        30: SequenceLikelihood.NEGATIVE,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        46: SequenceLikelihood.NEGATIVE,  # 'U'
        45: SequenceLikelihood.NEGATIVE,  # 'V'
        54: SequenceLikelihood.NEGATIVE,  # 'W'
        61: SequenceLikelihood.NEGATIVE,  # 'X'
        60: SequenceLikelihood.NEGATIVE,  # 'Y'
        63: SequenceLikelihood.NEGATIVE,  # 'Z'
        3: SequenceLikelihood.NEGATIVE,  # 'a'
        19: SequenceLikelihood.NEGATIVE,  # 'b'
        12: SequenceLikelihood.NEGATIVE,  # 'c'
        11: SequenceLikelihood.NEGATIVE,  # 'd'
        1: SequenceLikelihood.NEGATIVE,  # 'e'
        17: SequenceLikelihood.NEGATIVE,  # 'f'
        18: SequenceLikelihood.NEGATIVE,  # 'g'
        20: SequenceLikelihood.NEGATIVE,  # 'h'
        5: SequenceLikelihood.NEGATIVE,  # 'i'
        26: SequenceLikelihood.NEGATIVE,  # 'j'
        44: SequenceLikelihood.NEGATIVE,  # 'k'
        10: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.NEGATIVE,  # 'm'
        4: SequenceLikelihood.NEGATIVE,  # 'n'
        8: SequenceLikelihood.NEGATIVE,  # 'o'
        13: SequenceLikelihood.NEGATIVE,  # 'p'
        21: SequenceLikelihood.NEGATIVE,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        2: SequenceLikelihood.NEGATIVE,  # 's'
        6: SequenceLikelihood.UNLIKELY,  # 't'
        9: SequenceLikelihood.NEGATIVE,  # 'u'
        16: SequenceLikelihood.NEGATIVE,  # 'v'
        49: SequenceLikelihood.NEGATIVE,  # 'w'
        23: SequenceLikelihood.NEGATIVE,  # 'x'
        27: SequenceLikelihood.NEGATIVE,  # 'y'
        34: SequenceLikelihood.NEGATIVE,  # 'z'
        66: SequenceLikelihood.NEGATIVE,  # 'À'
        73: SequenceLikelihood.NEGATIVE,  # 'Â'
        83: SequenceLikelihood.NEGATIVE,  # 'Æ'
        69: SequenceLikelihood.NEGATIVE,  # 'Ç'
        70: SequenceLikelihood.NEGATIVE,  # 'È'
        58: SequenceLikelihood.NEGATIVE,  # 'É'
        72: SequenceLikelihood.NEGATIVE,  # 'Ê'
        80: SequenceLikelihood.NEGATIVE,  # 'Ë'
        71: SequenceLikelihood.NEGATIVE,  # 'Î'
        77: SequenceLikelihood.NEGATIVE,  # 'Ï'
        74: SequenceLikelihood.NEGATIVE,  # 'Ô'
        82: SequenceLikelihood.NEGATIVE,  # 'Ù'
        79: SequenceLikelihood.NEGATIVE,  # 'Û'
        78: SequenceLikelihood.NEGATIVE,  # 'Ü'
        22: SequenceLikelihood.NEGATIVE,  # 'à'
        53: SequenceLikelihood.NEGATIVE,  # 'â'
        76: SequenceLikelihood.NEGATIVE,  # 'æ'
        51: SequenceLikelihood.NEGATIVE,  # 'ç'
        28: SequenceLikelihood.NEGATIVE,  # 'è'
        15: SequenceLikelihood.NEGATIVE,  # 'é'
        41: SequenceLikelihood.NEGATIVE,  # 'ê'
        67: SequenceLikelihood.NEGATIVE,  # 'ë'
        57: SequenceLikelihood.NEGATIVE,  # 'î'
        65: SequenceLikelihood.NEGATIVE,  # 'ï'
        52: SequenceLikelihood.NEGATIVE,  # 'ô'
        62: SequenceLikelihood.NEGATIVE,  # 'ù'
        59: SequenceLikelihood.NEGATIVE,  # 'û'
        68: SequenceLikelihood.NEGATIVE,  # 'ü'
        81: SequenceLikelihood.NEGATIVE,  # 'ÿ'
        75: SequenceLikelihood.NEGATIVE,  # 'Œ'
        64: SequenceLikelihood.NEGATIVE,  # 'œ'
        84: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
    },
    78: {  # 'Ü'
        29: SequenceLikelihood.UNLIKELY,  # 'A'
        40: SequenceLikelihood.UNLIKELY,  # 'B'
        25: SequenceLikelihood.UNLIKELY,  # 'C'
        35: SequenceLikelihood.UNLIKELY,  # 'D'
        31: SequenceLikelihood.UNLIKELY,  # 'E'
        42: SequenceLikelihood.NEGATIVE,  # 'F'
        47: SequenceLikelihood.NEGATIVE,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.NEGATIVE,  # 'I'
        48: SequenceLikelihood.NEGATIVE,  # 'J'
        56: SequenceLikelihood.NEGATIVE,  # 'K'
        24: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        43: SequenceLikelihood.NEGATIVE,  # 'O'
        32: SequenceLikelihood.UNLIKELY,  # 'P'
        55: SequenceLikelihood.NEGATIVE,  # 'Q'
        38: SequenceLikelihood.UNLIKELY,  # 'R'
        30: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        46: SequenceLikelihood.NEGATIVE,  # 'U'
        45: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.NEGATIVE,  # 'W'
        61: SequenceLikelihood.NEGATIVE,  # 'X'
        60: SequenceLikelihood.NEGATIVE,  # 'Y'
        63: SequenceLikelihood.NEGATIVE,  # 'Z'
        3: SequenceLikelihood.NEGATIVE,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        12: SequenceLikelihood.NEGATIVE,  # 'c'
        11: SequenceLikelihood.NEGATIVE,  # 'd'
        1: SequenceLikelihood.NEGATIVE,  # 'e'
        17: SequenceLikelihood.NEGATIVE,  # 'f'
        18: SequenceLikelihood.NEGATIVE,  # 'g'
        20: SequenceLikelihood.NEGATIVE,  # 'h'
        5: SequenceLikelihood.NEGATIVE,  # 'i'
        26: SequenceLikelihood.NEGATIVE,  # 'j'
        44: SequenceLikelihood.NEGATIVE,  # 'k'
        10: SequenceLikelihood.NEGATIVE,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        8: SequenceLikelihood.NEGATIVE,  # 'o'
        13: SequenceLikelihood.NEGATIVE,  # 'p'
        21: SequenceLikelihood.NEGATIVE,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        2: SequenceLikelihood.UNLIKELY,  # 's'
        6: SequenceLikelihood.NEGATIVE,  # 't'
        9: SequenceLikelihood.NEGATIVE,  # 'u'
        16: SequenceLikelihood.NEGATIVE,  # 'v'
        49: SequenceLikelihood.NEGATIVE,  # 'w'
        23: SequenceLikelihood.NEGATIVE,  # 'x'
        27: SequenceLikelihood.NEGATIVE,  # 'y'
        34: SequenceLikelihood.UNLIKELY,  # 'z'
        66: SequenceLikelihood.NEGATIVE,  # 'À'
        73: SequenceLikelihood.NEGATIVE,  # 'Â'
        83: SequenceLikelihood.NEGATIVE,  # 'Æ'
        69: SequenceLikelihood.NEGATIVE,  # 'Ç'
        70: SequenceLikelihood.NEGATIVE,  # 'È'
        58: SequenceLikelihood.UNLIKELY,  # 'É'
        72: SequenceLikelihood.NEGATIVE,  # 'Ê'
        80: SequenceLikelihood.NEGATIVE,  # 'Ë'
        71: SequenceLikelihood.NEGATIVE,  # 'Î'
        77: SequenceLikelihood.UNLIKELY,  # 'Ï'
        74: SequenceLikelihood.NEGATIVE,  # 'Ô'
        82: SequenceLikelihood.NEGATIVE,  # 'Ù'
        79: SequenceLikelihood.NEGATIVE,  # 'Û'
        78: SequenceLikelihood.NEGATIVE,  # 'Ü'
        22: SequenceLikelihood.NEGATIVE,  # 'à'
        53: SequenceLikelihood.NEGATIVE,  # 'â'
        76: SequenceLikelihood.NEGATIVE,  # 'æ'
        51: SequenceLikelihood.NEGATIVE,  # 'ç'
        28: SequenceLikelihood.NEGATIVE,  # 'è'
        15: SequenceLikelihood.NEGATIVE,  # 'é'
        41: SequenceLikelihood.NEGATIVE,  # 'ê'
        67: SequenceLikelihood.NEGATIVE,  # 'ë'
        57: SequenceLikelihood.NEGATIVE,  # 'î'
        65: SequenceLikelihood.NEGATIVE,  # 'ï'
        52: SequenceLikelihood.NEGATIVE,  # 'ô'
        62: SequenceLikelihood.NEGATIVE,  # 'ù'
        59: SequenceLikelihood.NEGATIVE,  # 'û'
        68: SequenceLikelihood.NEGATIVE,  # 'ü'
        81: SequenceLikelihood.NEGATIVE,  # 'ÿ'
        75: SequenceLikelihood.NEGATIVE,  # 'Œ'
        64: SequenceLikelihood.NEGATIVE,  # 'œ'
        84: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
    },
    22: {  # 'à'
        29: SequenceLikelihood.UNLIKELY,  # 'A'
        40: SequenceLikelihood.UNLIKELY,  # 'B'
        25: SequenceLikelihood.UNLIKELY,  # 'C'
        35: SequenceLikelihood.UNLIKELY,  # 'D'
        31: SequenceLikelihood.UNLIKELY,  # 'E'
        42: SequenceLikelihood.UNLIKELY,  # 'F'
        47: SequenceLikelihood.UNLIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        48: SequenceLikelihood.UNLIKELY,  # 'J'
        56: SequenceLikelihood.UNLIKELY,  # 'K'
        24: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        43: SequenceLikelihood.UNLIKELY,  # 'O'
        32: SequenceLikelihood.UNLIKELY,  # 'P'
        55: SequenceLikelihood.NEGATIVE,  # 'Q'
        38: SequenceLikelihood.UNLIKELY,  # 'R'
        30: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        46: SequenceLikelihood.UNLIKELY,  # 'U'
        45: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        61: SequenceLikelihood.NEGATIVE,  # 'X'
        60: SequenceLikelihood.UNLIKELY,  # 'Y'
        63: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.UNLIKELY,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        12: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.UNLIKELY,  # 'e'
        17: SequenceLikelihood.UNLIKELY,  # 'f'
        18: SequenceLikelihood.UNLIKELY,  # 'g'
        20: SequenceLikelihood.UNLIKELY,  # 'h'
        5: SequenceLikelihood.UNLIKELY,  # 'i'
        26: SequenceLikelihood.UNLIKELY,  # 'j'
        44: SequenceLikelihood.UNLIKELY,  # 'k'
        10: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        8: SequenceLikelihood.UNLIKELY,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        21: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        2: SequenceLikelihood.UNLIKELY,  # 's'
        6: SequenceLikelihood.UNLIKELY,  # 't'
        9: SequenceLikelihood.UNLIKELY,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        49: SequenceLikelihood.NEGATIVE,  # 'w'
        23: SequenceLikelihood.UNLIKELY,  # 'x'
        27: SequenceLikelihood.UNLIKELY,  # 'y'
        34: SequenceLikelihood.UNLIKELY,  # 'z'
        66: SequenceLikelihood.NEGATIVE,  # 'À'
        73: SequenceLikelihood.NEGATIVE,  # 'Â'
        83: SequenceLikelihood.NEGATIVE,  # 'Æ'
        69: SequenceLikelihood.NEGATIVE,  # 'Ç'
        70: SequenceLikelihood.NEGATIVE,  # 'È'
        58: SequenceLikelihood.NEGATIVE,  # 'É'
        72: SequenceLikelihood.NEGATIVE,  # 'Ê'
        80: SequenceLikelihood.NEGATIVE,  # 'Ë'
        71: SequenceLikelihood.NEGATIVE,  # 'Î'
        77: SequenceLikelihood.NEGATIVE,  # 'Ï'
        74: SequenceLikelihood.NEGATIVE,  # 'Ô'
        82: SequenceLikelihood.NEGATIVE,  # 'Ù'
        79: SequenceLikelihood.NEGATIVE,  # 'Û'
        78: SequenceLikelihood.NEGATIVE,  # 'Ü'
        22: SequenceLikelihood.UNLIKELY,  # 'à'
        53: SequenceLikelihood.NEGATIVE,  # 'â'
        76: SequenceLikelihood.NEGATIVE,  # 'æ'
        51: SequenceLikelihood.UNLIKELY,  # 'ç'
        28: SequenceLikelihood.NEGATIVE,  # 'è'
        15: SequenceLikelihood.UNLIKELY,  # 'é'
        41: SequenceLikelihood.UNLIKELY,  # 'ê'
        67: SequenceLikelihood.NEGATIVE,  # 'ë'
        57: SequenceLikelihood.UNLIKELY,  # 'î'
        65: SequenceLikelihood.NEGATIVE,  # 'ï'
        52: SequenceLikelihood.NEGATIVE,  # 'ô'
        62: SequenceLikelihood.NEGATIVE,  # 'ù'
        59: SequenceLikelihood.NEGATIVE,  # 'û'
        68: SequenceLikelihood.NEGATIVE,  # 'ü'
        81: SequenceLikelihood.NEGATIVE,  # 'ÿ'
        75: SequenceLikelihood.NEGATIVE,  # 'Œ'
        64: SequenceLikelihood.NEGATIVE,  # 'œ'
        84: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
    },
    53: {  # 'â'
        29: SequenceLikelihood.NEGATIVE,  # 'A'
        40: SequenceLikelihood.UNLIKELY,  # 'B'
        25: SequenceLikelihood.NEGATIVE,  # 'C'
        35: SequenceLikelihood.NEGATIVE,  # 'D'
        31: SequenceLikelihood.NEGATIVE,  # 'E'
        42: SequenceLikelihood.NEGATIVE,  # 'F'
        47: SequenceLikelihood.UNLIKELY,  # 'G'
        50: SequenceLikelihood.NEGATIVE,  # 'H'
        36: SequenceLikelihood.NEGATIVE,  # 'I'
        48: SequenceLikelihood.NEGATIVE,  # 'J'
        56: SequenceLikelihood.NEGATIVE,  # 'K'
        24: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.NEGATIVE,  # 'M'
        39: SequenceLikelihood.NEGATIVE,  # 'N'
        43: SequenceLikelihood.NEGATIVE,  # 'O'
        32: SequenceLikelihood.NEGATIVE,  # 'P'
        55: SequenceLikelihood.NEGATIVE,  # 'Q'
        38: SequenceLikelihood.NEGATIVE,  # 'R'
        30: SequenceLikelihood.NEGATIVE,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        46: SequenceLikelihood.NEGATIVE,  # 'U'
        45: SequenceLikelihood.NEGATIVE,  # 'V'
        54: SequenceLikelihood.NEGATIVE,  # 'W'
        61: SequenceLikelihood.NEGATIVE,  # 'X'
        60: SequenceLikelihood.NEGATIVE,  # 'Y'
        63: SequenceLikelihood.NEGATIVE,  # 'Z'
        3: SequenceLikelihood.UNLIKELY,  # 'a'
        19: SequenceLikelihood.LIKELY,  # 'b'
        12: SequenceLikelihood.POSITIVE,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.NEGATIVE,  # 'e'
        17: SequenceLikelihood.UNLIKELY,  # 'f'
        18: SequenceLikelihood.LIKELY,  # 'g'
        20: SequenceLikelihood.UNLIKELY,  # 'h'
        5: SequenceLikelihood.UNLIKELY,  # 'i'
        26: SequenceLikelihood.UNLIKELY,  # 'j'
        44: SequenceLikelihood.UNLIKELY,  # 'k'
        10: SequenceLikelihood.LIKELY,  # 'l'
        14: SequenceLikelihood.LIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        8: SequenceLikelihood.UNLIKELY,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        21: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        2: SequenceLikelihood.UNLIKELY,  # 's'
        6: SequenceLikelihood.POSITIVE,  # 't'
        9: SequenceLikelihood.UNLIKELY,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        49: SequenceLikelihood.UNLIKELY,  # 'w'
        23: SequenceLikelihood.NEGATIVE,  # 'x'
        27: SequenceLikelihood.UNLIKELY,  # 'y'
        34: SequenceLikelihood.UNLIKELY,  # 'z'
        66: SequenceLikelihood.NEGATIVE,  # 'À'
        73: SequenceLikelihood.NEGATIVE,  # 'Â'
        83: SequenceLikelihood.NEGATIVE,  # 'Æ'
        69: SequenceLikelihood.NEGATIVE,  # 'Ç'
        70: SequenceLikelihood.NEGATIVE,  # 'È'
        58: SequenceLikelihood.NEGATIVE,  # 'É'
        72: SequenceLikelihood.NEGATIVE,  # 'Ê'
        80: SequenceLikelihood.NEGATIVE,  # 'Ë'
        71: SequenceLikelihood.NEGATIVE,  # 'Î'
        77: SequenceLikelihood.NEGATIVE,  # 'Ï'
        74: SequenceLikelihood.NEGATIVE,  # 'Ô'
        82: SequenceLikelihood.NEGATIVE,  # 'Ù'
        79: SequenceLikelihood.NEGATIVE,  # 'Û'
        78: SequenceLikelihood.NEGATIVE,  # 'Ü'
        22: SequenceLikelihood.NEGATIVE,  # 'à'
        53: SequenceLikelihood.UNLIKELY,  # 'â'
        76: SequenceLikelihood.NEGATIVE,  # 'æ'
        51: SequenceLikelihood.UNLIKELY,  # 'ç'
        28: SequenceLikelihood.NEGATIVE,  # 'è'
        15: SequenceLikelihood.NEGATIVE,  # 'é'
        41: SequenceLikelihood.NEGATIVE,  # 'ê'
        67: SequenceLikelihood.NEGATIVE,  # 'ë'
        57: SequenceLikelihood.UNLIKELY,  # 'î'
        65: SequenceLikelihood.NEGATIVE,  # 'ï'
        52: SequenceLikelihood.NEGATIVE,  # 'ô'
        62: SequenceLikelihood.NEGATIVE,  # 'ù'
        59: SequenceLikelihood.NEGATIVE,  # 'û'
        68: SequenceLikelihood.NEGATIVE,  # 'ü'
        81: SequenceLikelihood.NEGATIVE,  # 'ÿ'
        75: SequenceLikelihood.NEGATIVE,  # 'Œ'
        64: SequenceLikelihood.UNLIKELY,  # 'œ'
        84: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
    },
    76: {  # 'æ'
        29: SequenceLikelihood.NEGATIVE,  # 'A'
        40: SequenceLikelihood.NEGATIVE,  # 'B'
        25: SequenceLikelihood.NEGATIVE,  # 'C'
        35: SequenceLikelihood.NEGATIVE,  # 'D'
        31: SequenceLikelihood.NEGATIVE,  # 'E'
        42: SequenceLikelihood.NEGATIVE,  # 'F'
        47: SequenceLikelihood.NEGATIVE,  # 'G'
        50: SequenceLikelihood.NEGATIVE,  # 'H'
        36: SequenceLikelihood.NEGATIVE,  # 'I'
        48: SequenceLikelihood.NEGATIVE,  # 'J'
        56: SequenceLikelihood.NEGATIVE,  # 'K'
        24: SequenceLikelihood.NEGATIVE,  # 'L'
        33: SequenceLikelihood.NEGATIVE,  # 'M'
        39: SequenceLikelihood.NEGATIVE,  # 'N'
        43: SequenceLikelihood.NEGATIVE,  # 'O'
        32: SequenceLikelihood.NEGATIVE,  # 'P'
        55: SequenceLikelihood.NEGATIVE,  # 'Q'
        38: SequenceLikelihood.NEGATIVE,  # 'R'
        30: SequenceLikelihood.NEGATIVE,  # 'S'
        37: SequenceLikelihood.NEGATIVE,  # 'T'
        46: SequenceLikelihood.NEGATIVE,  # 'U'
        45: SequenceLikelihood.NEGATIVE,  # 'V'
        54: SequenceLikelihood.NEGATIVE,  # 'W'
        61: SequenceLikelihood.NEGATIVE,  # 'X'
        60: SequenceLikelihood.NEGATIVE,  # 'Y'
        63: SequenceLikelihood.NEGATIVE,  # 'Z'
        3: SequenceLikelihood.UNLIKELY,  # 'a'
        19: SequenceLikelihood.NEGATIVE,  # 'b'
        12: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.NEGATIVE,  # 'e'
        17: SequenceLikelihood.UNLIKELY,  # 'f'
        18: SequenceLikelihood.UNLIKELY,  # 'g'
        20: SequenceLikelihood.UNLIKELY,  # 'h'
        5: SequenceLikelihood.NEGATIVE,  # 'i'
        26: SequenceLikelihood.UNLIKELY,  # 'j'
        44: SequenceLikelihood.UNLIKELY,  # 'k'
        10: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        8: SequenceLikelihood.NEGATIVE,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        21: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        2: SequenceLikelihood.UNLIKELY,  # 's'
        6: SequenceLikelihood.UNLIKELY,  # 't'
        9: SequenceLikelihood.UNLIKELY,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        49: SequenceLikelihood.NEGATIVE,  # 'w'
        23: SequenceLikelihood.NEGATIVE,  # 'x'
        27: SequenceLikelihood.NEGATIVE,  # 'y'
        34: SequenceLikelihood.NEGATIVE,  # 'z'
        66: SequenceLikelihood.NEGATIVE,  # 'À'
        73: SequenceLikelihood.NEGATIVE,  # 'Â'
        83: SequenceLikelihood.NEGATIVE,  # 'Æ'
        69: SequenceLikelihood.NEGATIVE,  # 'Ç'
        70: SequenceLikelihood.NEGATIVE,  # 'È'
        58: SequenceLikelihood.NEGATIVE,  # 'É'
        72: SequenceLikelihood.NEGATIVE,  # 'Ê'
        80: SequenceLikelihood.NEGATIVE,  # 'Ë'
        71: SequenceLikelihood.NEGATIVE,  # 'Î'
        77: SequenceLikelihood.NEGATIVE,  # 'Ï'
        74: SequenceLikelihood.NEGATIVE,  # 'Ô'
        82: SequenceLikelihood.NEGATIVE,  # 'Ù'
        79: SequenceLikelihood.NEGATIVE,  # 'Û'
        78: SequenceLikelihood.NEGATIVE,  # 'Ü'
        22: SequenceLikelihood.UNLIKELY,  # 'à'
        53: SequenceLikelihood.NEGATIVE,  # 'â'
        76: SequenceLikelihood.NEGATIVE,  # 'æ'
        51: SequenceLikelihood.NEGATIVE,  # 'ç'
        28: SequenceLikelihood.NEGATIVE,  # 'è'
        15: SequenceLikelihood.NEGATIVE,  # 'é'
        41: SequenceLikelihood.NEGATIVE,  # 'ê'
        67: SequenceLikelihood.NEGATIVE,  # 'ë'
        57: SequenceLikelihood.NEGATIVE,  # 'î'
        65: SequenceLikelihood.NEGATIVE,  # 'ï'
        52: SequenceLikelihood.NEGATIVE,  # 'ô'
        62: SequenceLikelihood.NEGATIVE,  # 'ù'
        59: SequenceLikelihood.NEGATIVE,  # 'û'
        68: SequenceLikelihood.NEGATIVE,  # 'ü'
        81: SequenceLikelihood.NEGATIVE,  # 'ÿ'
        75: SequenceLikelihood.NEGATIVE,  # 'Œ'
        64: SequenceLikelihood.NEGATIVE,  # 'œ'
        84: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
    },
    51: {  # 'ç'
        29: SequenceLikelihood.UNLIKELY,  # 'A'
        40: SequenceLikelihood.NEGATIVE,  # 'B'
        25: SequenceLikelihood.NEGATIVE,  # 'C'
        35: SequenceLikelihood.NEGATIVE,  # 'D'
        31: SequenceLikelihood.NEGATIVE,  # 'E'
        42: SequenceLikelihood.NEGATIVE,  # 'F'
        47: SequenceLikelihood.NEGATIVE,  # 'G'
        50: SequenceLikelihood.NEGATIVE,  # 'H'
        36: SequenceLikelihood.NEGATIVE,  # 'I'
        48: SequenceLikelihood.NEGATIVE,  # 'J'
        56: SequenceLikelihood.NEGATIVE,  # 'K'
        24: SequenceLikelihood.NEGATIVE,  # 'L'
        33: SequenceLikelihood.NEGATIVE,  # 'M'
        39: SequenceLikelihood.NEGATIVE,  # 'N'
        43: SequenceLikelihood.UNLIKELY,  # 'O'
        32: SequenceLikelihood.NEGATIVE,  # 'P'
        55: SequenceLikelihood.NEGATIVE,  # 'Q'
        38: SequenceLikelihood.NEGATIVE,  # 'R'
        30: SequenceLikelihood.NEGATIVE,  # 'S'
        37: SequenceLikelihood.NEGATIVE,  # 'T'
        46: SequenceLikelihood.NEGATIVE,  # 'U'
        45: SequenceLikelihood.NEGATIVE,  # 'V'
        54: SequenceLikelihood.NEGATIVE,  # 'W'
        61: SequenceLikelihood.NEGATIVE,  # 'X'
        60: SequenceLikelihood.NEGATIVE,  # 'Y'
        63: SequenceLikelihood.NEGATIVE,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        12: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.NEGATIVE,  # 'd'
        1: SequenceLikelihood.UNLIKELY,  # 'e'
        17: SequenceLikelihood.UNLIKELY,  # 'f'
        18: SequenceLikelihood.UNLIKELY,  # 'g'
        20: SequenceLikelihood.UNLIKELY,  # 'h'
        5: SequenceLikelihood.UNLIKELY,  # 'i'
        26: SequenceLikelihood.UNLIKELY,  # 'j'
        44: SequenceLikelihood.NEGATIVE,  # 'k'
        10: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        8: SequenceLikelihood.POSITIVE,  # 'o'
        13: SequenceLikelihood.NEGATIVE,  # 'p'
        21: SequenceLikelihood.NEGATIVE,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        2: SequenceLikelihood.UNLIKELY,  # 's'
        6: SequenceLikelihood.UNLIKELY,  # 't'
        9: SequenceLikelihood.LIKELY,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        49: SequenceLikelihood.NEGATIVE,  # 'w'
        23: SequenceLikelihood.NEGATIVE,  # 'x'
        27: SequenceLikelihood.UNLIKELY,  # 'y'
        34: SequenceLikelihood.UNLIKELY,  # 'z'
        66: SequenceLikelihood.NEGATIVE,  # 'À'
        73: SequenceLikelihood.NEGATIVE,  # 'Â'
        83: SequenceLikelihood.NEGATIVE,  # 'Æ'
        69: SequenceLikelihood.NEGATIVE,  # 'Ç'
        70: SequenceLikelihood.NEGATIVE,  # 'È'
        58: SequenceLikelihood.NEGATIVE,  # 'É'
        72: SequenceLikelihood.NEGATIVE,  # 'Ê'
        80: SequenceLikelihood.NEGATIVE,  # 'Ë'
        71: SequenceLikelihood.NEGATIVE,  # 'Î'
        77: SequenceLikelihood.NEGATIVE,  # 'Ï'
        74: SequenceLikelihood.NEGATIVE,  # 'Ô'
        82: SequenceLikelihood.NEGATIVE,  # 'Ù'
        79: SequenceLikelihood.NEGATIVE,  # 'Û'
        78: SequenceLikelihood.NEGATIVE,  # 'Ü'
        22: SequenceLikelihood.UNLIKELY,  # 'à'
        53: SequenceLikelihood.UNLIKELY,  # 'â'
        76: SequenceLikelihood.NEGATIVE,  # 'æ'
        51: SequenceLikelihood.UNLIKELY,  # 'ç'
        28: SequenceLikelihood.UNLIKELY,  # 'è'
        15: SequenceLikelihood.UNLIKELY,  # 'é'
        41: SequenceLikelihood.NEGATIVE,  # 'ê'
        67: SequenceLikelihood.NEGATIVE,  # 'ë'
        57: SequenceLikelihood.UNLIKELY,  # 'î'
        65: SequenceLikelihood.NEGATIVE,  # 'ï'
        52: SequenceLikelihood.NEGATIVE,  # 'ô'
        62: SequenceLikelihood.NEGATIVE,  # 'ù'
        59: SequenceLikelihood.UNLIKELY,  # 'û'
        68: SequenceLikelihood.UNLIKELY,  # 'ü'
        81: SequenceLikelihood.NEGATIVE,  # 'ÿ'
        75: SequenceLikelihood.NEGATIVE,  # 'Œ'
        64: SequenceLikelihood.UNLIKELY,  # 'œ'
        84: SequenceLikelihood.UNLIKELY,  # 'Ÿ'
    },
    28: {  # 'è'
        29: SequenceLikelihood.NEGATIVE,  # 'A'
        40: SequenceLikelihood.NEGATIVE,  # 'B'
        25: SequenceLikelihood.UNLIKELY,  # 'C'
        35: SequenceLikelihood.UNLIKELY,  # 'D'
        31: SequenceLikelihood.NEGATIVE,  # 'E'
        42: SequenceLikelihood.UNLIKELY,  # 'F'
        47: SequenceLikelihood.NEGATIVE,  # 'G'
        50: SequenceLikelihood.NEGATIVE,  # 'H'
        36: SequenceLikelihood.NEGATIVE,  # 'I'
        48: SequenceLikelihood.NEGATIVE,  # 'J'
        56: SequenceLikelihood.NEGATIVE,  # 'K'
        24: SequenceLikelihood.NEGATIVE,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.NEGATIVE,  # 'N'
        43: SequenceLikelihood.NEGATIVE,  # 'O'
        32: SequenceLikelihood.NEGATIVE,  # 'P'
        55: SequenceLikelihood.NEGATIVE,  # 'Q'
        38: SequenceLikelihood.UNLIKELY,  # 'R'
        30: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        46: SequenceLikelihood.UNLIKELY,  # 'U'
        45: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.NEGATIVE,  # 'W'
        61: SequenceLikelihood.NEGATIVE,  # 'X'
        60: SequenceLikelihood.UNLIKELY,  # 'Y'
        63: SequenceLikelihood.NEGATIVE,  # 'Z'
        3: SequenceLikelihood.UNLIKELY,  # 'a'
        19: SequenceLikelihood.LIKELY,  # 'b'
        12: SequenceLikelihood.POSITIVE,  # 'c'
        11: SequenceLikelihood.LIKELY,  # 'd'
        1: SequenceLikelihood.UNLIKELY,  # 'e'
        17: SequenceLikelihood.UNLIKELY,  # 'f'
        18: SequenceLikelihood.POSITIVE,  # 'g'
        20: SequenceLikelihood.UNLIKELY,  # 'h'
        5: SequenceLikelihood.UNLIKELY,  # 'i'
        26: SequenceLikelihood.UNLIKELY,  # 'j'
        44: SequenceLikelihood.UNLIKELY,  # 'k'
        10: SequenceLikelihood.POSITIVE,  # 'l'
        14: SequenceLikelihood.POSITIVE,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        8: SequenceLikelihood.UNLIKELY,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        21: SequenceLikelihood.LIKELY,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        2: SequenceLikelihood.POSITIVE,  # 's'
        6: SequenceLikelihood.POSITIVE,  # 't'
        9: SequenceLikelihood.UNLIKELY,  # 'u'
        16: SequenceLikelihood.POSITIVE,  # 'v'
        49: SequenceLikelihood.UNLIKELY,  # 'w'
        23: SequenceLikelihood.UNLIKELY,  # 'x'
        27: SequenceLikelihood.UNLIKELY,  # 'y'
        34: SequenceLikelihood.UNLIKELY,  # 'z'
        66: SequenceLikelihood.NEGATIVE,  # 'À'
        73: SequenceLikelihood.NEGATIVE,  # 'Â'
        83: SequenceLikelihood.NEGATIVE,  # 'Æ'
        69: SequenceLikelihood.NEGATIVE,  # 'Ç'
        70: SequenceLikelihood.NEGATIVE,  # 'È'
        58: SequenceLikelihood.NEGATIVE,  # 'É'
        72: SequenceLikelihood.NEGATIVE,  # 'Ê'
        80: SequenceLikelihood.NEGATIVE,  # 'Ë'
        71: SequenceLikelihood.NEGATIVE,  # 'Î'
        77: SequenceLikelihood.NEGATIVE,  # 'Ï'
        74: SequenceLikelihood.NEGATIVE,  # 'Ô'
        82: SequenceLikelihood.NEGATIVE,  # 'Ù'
        79: SequenceLikelihood.NEGATIVE,  # 'Û'
        78: SequenceLikelihood.NEGATIVE,  # 'Ü'
        22: SequenceLikelihood.NEGATIVE,  # 'à'
        53: SequenceLikelihood.NEGATIVE,  # 'â'
        76: SequenceLikelihood.UNLIKELY,  # 'æ'
        51: SequenceLikelihood.UNLIKELY,  # 'ç'
        28: SequenceLikelihood.UNLIKELY,  # 'è'
        15: SequenceLikelihood.UNLIKELY,  # 'é'
        41: SequenceLikelihood.NEGATIVE,  # 'ê'
        67: SequenceLikelihood.NEGATIVE,  # 'ë'
        57: SequenceLikelihood.NEGATIVE,  # 'î'
        65: SequenceLikelihood.UNLIKELY,  # 'ï'
        52: SequenceLikelihood.NEGATIVE,  # 'ô'
        62: SequenceLikelihood.NEGATIVE,  # 'ù'
        59: SequenceLikelihood.NEGATIVE,  # 'û'
        68: SequenceLikelihood.NEGATIVE,  # 'ü'
        81: SequenceLikelihood.NEGATIVE,  # 'ÿ'
        75: SequenceLikelihood.NEGATIVE,  # 'Œ'
        64: SequenceLikelihood.NEGATIVE,  # 'œ'
        84: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
    },
    15: {  # 'é'
        29: SequenceLikelihood.UNLIKELY,  # 'A'
        40: SequenceLikelihood.UNLIKELY,  # 'B'
        25: SequenceLikelihood.UNLIKELY,  # 'C'
        35: SequenceLikelihood.UNLIKELY,  # 'D'
        31: SequenceLikelihood.UNLIKELY,  # 'E'
        42: SequenceLikelihood.UNLIKELY,  # 'F'
        47: SequenceLikelihood.UNLIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        48: SequenceLikelihood.UNLIKELY,  # 'J'
        56: SequenceLikelihood.UNLIKELY,  # 'K'
        24: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        43: SequenceLikelihood.UNLIKELY,  # 'O'
        32: SequenceLikelihood.UNLIKELY,  # 'P'
        55: SequenceLikelihood.UNLIKELY,  # 'Q'
        38: SequenceLikelihood.UNLIKELY,  # 'R'
        30: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        46: SequenceLikelihood.UNLIKELY,  # 'U'
        45: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        61: SequenceLikelihood.NEGATIVE,  # 'X'
        60: SequenceLikelihood.UNLIKELY,  # 'Y'
        63: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        19: SequenceLikelihood.POSITIVE,  # 'b'
        12: SequenceLikelihood.POSITIVE,  # 'c'
        11: SequenceLikelihood.POSITIVE,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        17: SequenceLikelihood.POSITIVE,  # 'f'
        18: SequenceLikelihood.POSITIVE,  # 'g'
        20: SequenceLikelihood.LIKELY,  # 'h'
        5: SequenceLikelihood.LIKELY,  # 'i'
        26: SequenceLikelihood.POSITIVE,  # 'j'
        44: SequenceLikelihood.UNLIKELY,  # 'k'
        10: SequenceLikelihood.POSITIVE,  # 'l'
        14: SequenceLikelihood.POSITIVE,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        8: SequenceLikelihood.POSITIVE,  # 'o'
        13: SequenceLikelihood.POSITIVE,  # 'p'
        21: SequenceLikelihood.POSITIVE,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        2: SequenceLikelihood.POSITIVE,  # 's'
        6: SequenceLikelihood.POSITIVE,  # 't'
        9: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.POSITIVE,  # 'v'
        49: SequenceLikelihood.UNLIKELY,  # 'w'
        23: SequenceLikelihood.UNLIKELY,  # 'x'
        27: SequenceLikelihood.UNLIKELY,  # 'y'
        34: SequenceLikelihood.UNLIKELY,  # 'z'
        66: SequenceLikelihood.NEGATIVE,  # 'À'
        73: SequenceLikelihood.NEGATIVE,  # 'Â'
        83: SequenceLikelihood.NEGATIVE,  # 'Æ'
        69: SequenceLikelihood.NEGATIVE,  # 'Ç'
        70: SequenceLikelihood.NEGATIVE,  # 'È'
        58: SequenceLikelihood.UNLIKELY,  # 'É'
        72: SequenceLikelihood.NEGATIVE,  # 'Ê'
        80: SequenceLikelihood.NEGATIVE,  # 'Ë'
        71: SequenceLikelihood.UNLIKELY,  # 'Î'
        77: SequenceLikelihood.UNLIKELY,  # 'Ï'
        74: SequenceLikelihood.UNLIKELY,  # 'Ô'
        82: SequenceLikelihood.NEGATIVE,  # 'Ù'
        79: SequenceLikelihood.NEGATIVE,  # 'Û'
        78: SequenceLikelihood.NEGATIVE,  # 'Ü'
        22: SequenceLikelihood.UNLIKELY,  # 'à'
        53: SequenceLikelihood.LIKELY,  # 'â'
        76: SequenceLikelihood.NEGATIVE,  # 'æ'
        51: SequenceLikelihood.UNLIKELY,  # 'ç'
        28: SequenceLikelihood.UNLIKELY,  # 'è'
        15: SequenceLikelihood.LIKELY,  # 'é'
        41: SequenceLikelihood.UNLIKELY,  # 'ê'
        67: SequenceLikelihood.NEGATIVE,  # 'ë'
        57: SequenceLikelihood.UNLIKELY,  # 'î'
        65: SequenceLikelihood.UNLIKELY,  # 'ï'
        52: SequenceLikelihood.UNLIKELY,  # 'ô'
        62: SequenceLikelihood.UNLIKELY,  # 'ù'
        59: SequenceLikelihood.NEGATIVE,  # 'û'
        68: SequenceLikelihood.UNLIKELY,  # 'ü'
        81: SequenceLikelihood.UNLIKELY,  # 'ÿ'
        75: SequenceLikelihood.NEGATIVE,  # 'Œ'
        64: SequenceLikelihood.UNLIKELY,  # 'œ'
        84: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
    },
    41: {  # 'ê'
        29: SequenceLikelihood.NEGATIVE,  # 'A'
        40: SequenceLikelihood.NEGATIVE,  # 'B'
        25: SequenceLikelihood.NEGATIVE,  # 'C'
        35: SequenceLikelihood.NEGATIVE,  # 'D'
        31: SequenceLikelihood.UNLIKELY,  # 'E'
        42: SequenceLikelihood.NEGATIVE,  # 'F'
        47: SequenceLikelihood.NEGATIVE,  # 'G'
        50: SequenceLikelihood.NEGATIVE,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        48: SequenceLikelihood.NEGATIVE,  # 'J'
        56: SequenceLikelihood.NEGATIVE,  # 'K'
        24: SequenceLikelihood.NEGATIVE,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.NEGATIVE,  # 'N'
        43: SequenceLikelihood.UNLIKELY,  # 'O'
        32: SequenceLikelihood.NEGATIVE,  # 'P'
        55: SequenceLikelihood.NEGATIVE,  # 'Q'
        38: SequenceLikelihood.NEGATIVE,  # 'R'
        30: SequenceLikelihood.NEGATIVE,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        46: SequenceLikelihood.NEGATIVE,  # 'U'
        45: SequenceLikelihood.NEGATIVE,  # 'V'
        54: SequenceLikelihood.NEGATIVE,  # 'W'
        61: SequenceLikelihood.NEGATIVE,  # 'X'
        60: SequenceLikelihood.NEGATIVE,  # 'Y'
        63: SequenceLikelihood.NEGATIVE,  # 'Z'
        3: SequenceLikelihood.UNLIKELY,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        12: SequenceLikelihood.LIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.UNLIKELY,  # 'e'
        17: SequenceLikelihood.UNLIKELY,  # 'f'
        18: SequenceLikelihood.UNLIKELY,  # 'g'
        20: SequenceLikelihood.UNLIKELY,  # 'h'
        5: SequenceLikelihood.NEGATIVE,  # 'i'
        26: SequenceLikelihood.NEGATIVE,  # 'j'
        44: SequenceLikelihood.UNLIKELY,  # 'k'
        10: SequenceLikelihood.LIKELY,  # 'l'
        14: SequenceLikelihood.POSITIVE,  # 'm'
        4: SequenceLikelihood.LIKELY,  # 'n'
        8: SequenceLikelihood.UNLIKELY,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        21: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        2: SequenceLikelihood.UNLIKELY,  # 's'
        6: SequenceLikelihood.POSITIVE,  # 't'
        9: SequenceLikelihood.UNLIKELY,  # 'u'
        16: SequenceLikelihood.LIKELY,  # 'v'
        49: SequenceLikelihood.UNLIKELY,  # 'w'
        23: SequenceLikelihood.UNLIKELY,  # 'x'
        27: SequenceLikelihood.NEGATIVE,  # 'y'
        34: SequenceLikelihood.NEGATIVE,  # 'z'
        66: SequenceLikelihood.NEGATIVE,  # 'À'
        73: SequenceLikelihood.NEGATIVE,  # 'Â'
        83: SequenceLikelihood.NEGATIVE,  # 'Æ'
        69: SequenceLikelihood.NEGATIVE,  # 'Ç'
        70: SequenceLikelihood.NEGATIVE,  # 'È'
        58: SequenceLikelihood.NEGATIVE,  # 'É'
        72: SequenceLikelihood.NEGATIVE,  # 'Ê'
        80: SequenceLikelihood.NEGATIVE,  # 'Ë'
        71: SequenceLikelihood.NEGATIVE,  # 'Î'
        77: SequenceLikelihood.NEGATIVE,  # 'Ï'
        74: SequenceLikelihood.NEGATIVE,  # 'Ô'
        82: SequenceLikelihood.NEGATIVE,  # 'Ù'
        79: SequenceLikelihood.NEGATIVE,  # 'Û'
        78: SequenceLikelihood.UNLIKELY,  # 'Ü'
        22: SequenceLikelihood.UNLIKELY,  # 'à'
        53: SequenceLikelihood.NEGATIVE,  # 'â'
        76: SequenceLikelihood.NEGATIVE,  # 'æ'
        51: SequenceLikelihood.NEGATIVE,  # 'ç'
        28: SequenceLikelihood.NEGATIVE,  # 'è'
        15: SequenceLikelihood.UNLIKELY,  # 'é'
        41: SequenceLikelihood.UNLIKELY,  # 'ê'
        67: SequenceLikelihood.NEGATIVE,  # 'ë'
        57: SequenceLikelihood.NEGATIVE,  # 'î'
        65: SequenceLikelihood.NEGATIVE,  # 'ï'
        52: SequenceLikelihood.NEGATIVE,  # 'ô'
        62: SequenceLikelihood.NEGATIVE,  # 'ù'
        59: SequenceLikelihood.NEGATIVE,  # 'û'
        68: SequenceLikelihood.NEGATIVE,  # 'ü'
        81: SequenceLikelihood.NEGATIVE,  # 'ÿ'
        75: SequenceLikelihood.NEGATIVE,  # 'Œ'
        64: SequenceLikelihood.UNLIKELY,  # 'œ'
        84: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
    },
    67: {  # 'ë'
        29: SequenceLikelihood.NEGATIVE,  # 'A'
        40: SequenceLikelihood.UNLIKELY,  # 'B'
        25: SequenceLikelihood.NEGATIVE,  # 'C'
        35: SequenceLikelihood.NEGATIVE,  # 'D'
        31: SequenceLikelihood.UNLIKELY,  # 'E'
        42: SequenceLikelihood.NEGATIVE,  # 'F'
        47: SequenceLikelihood.NEGATIVE,  # 'G'
        50: SequenceLikelihood.NEGATIVE,  # 'H'
        36: SequenceLikelihood.NEGATIVE,  # 'I'
        48: SequenceLikelihood.NEGATIVE,  # 'J'
        56: SequenceLikelihood.NEGATIVE,  # 'K'
        24: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.NEGATIVE,  # 'N'
        43: SequenceLikelihood.NEGATIVE,  # 'O'
        32: SequenceLikelihood.NEGATIVE,  # 'P'
        55: SequenceLikelihood.NEGATIVE,  # 'Q'
        38: SequenceLikelihood.NEGATIVE,  # 'R'
        30: SequenceLikelihood.NEGATIVE,  # 'S'
        37: SequenceLikelihood.NEGATIVE,  # 'T'
        46: SequenceLikelihood.NEGATIVE,  # 'U'
        45: SequenceLikelihood.NEGATIVE,  # 'V'
        54: SequenceLikelihood.NEGATIVE,  # 'W'
        61: SequenceLikelihood.NEGATIVE,  # 'X'
        60: SequenceLikelihood.NEGATIVE,  # 'Y'
        63: SequenceLikelihood.NEGATIVE,  # 'Z'
        3: SequenceLikelihood.UNLIKELY,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        12: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.UNLIKELY,  # 'e'
        17: SequenceLikelihood.UNLIKELY,  # 'f'
        18: SequenceLikelihood.UNLIKELY,  # 'g'
        20: SequenceLikelihood.UNLIKELY,  # 'h'
        5: SequenceLikelihood.UNLIKELY,  # 'i'
        26: SequenceLikelihood.UNLIKELY,  # 'j'
        44: SequenceLikelihood.UNLIKELY,  # 'k'
        10: SequenceLikelihood.LIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        8: SequenceLikelihood.UNLIKELY,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        21: SequenceLikelihood.NEGATIVE,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        2: SequenceLikelihood.UNLIKELY,  # 's'
        6: SequenceLikelihood.UNLIKELY,  # 't'
        9: SequenceLikelihood.NEGATIVE,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        49: SequenceLikelihood.UNLIKELY,  # 'w'
        23: SequenceLikelihood.UNLIKELY,  # 'x'
        27: SequenceLikelihood.UNLIKELY,  # 'y'
        34: SequenceLikelihood.UNLIKELY,  # 'z'
        66: SequenceLikelihood.NEGATIVE,  # 'À'
        73: SequenceLikelihood.NEGATIVE,  # 'Â'
        83: SequenceLikelihood.NEGATIVE,  # 'Æ'
        69: SequenceLikelihood.NEGATIVE,  # 'Ç'
        70: SequenceLikelihood.NEGATIVE,  # 'È'
        58: SequenceLikelihood.NEGATIVE,  # 'É'
        72: SequenceLikelihood.NEGATIVE,  # 'Ê'
        80: SequenceLikelihood.NEGATIVE,  # 'Ë'
        71: SequenceLikelihood.NEGATIVE,  # 'Î'
        77: SequenceLikelihood.NEGATIVE,  # 'Ï'
        74: SequenceLikelihood.NEGATIVE,  # 'Ô'
        82: SequenceLikelihood.NEGATIVE,  # 'Ù'
        79: SequenceLikelihood.NEGATIVE,  # 'Û'
        78: SequenceLikelihood.NEGATIVE,  # 'Ü'
        22: SequenceLikelihood.UNLIKELY,  # 'à'
        53: SequenceLikelihood.NEGATIVE,  # 'â'
        76: SequenceLikelihood.NEGATIVE,  # 'æ'
        51: SequenceLikelihood.NEGATIVE,  # 'ç'
        28: SequenceLikelihood.NEGATIVE,  # 'è'
        15: SequenceLikelihood.NEGATIVE,  # 'é'
        41: SequenceLikelihood.NEGATIVE,  # 'ê'
        67: SequenceLikelihood.NEGATIVE,  # 'ë'
        57: SequenceLikelihood.NEGATIVE,  # 'î'
        65: SequenceLikelihood.NEGATIVE,  # 'ï'
        52: SequenceLikelihood.NEGATIVE,  # 'ô'
        62: SequenceLikelihood.NEGATIVE,  # 'ù'
        59: SequenceLikelihood.NEGATIVE,  # 'û'
        68: SequenceLikelihood.UNLIKELY,  # 'ü'
        81: SequenceLikelihood.NEGATIVE,  # 'ÿ'
        75: SequenceLikelihood.NEGATIVE,  # 'Œ'
        64: SequenceLikelihood.NEGATIVE,  # 'œ'
        84: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
    },
    57: {  # 'î'
        29: SequenceLikelihood.NEGATIVE,  # 'A'
        40: SequenceLikelihood.NEGATIVE,  # 'B'
        25: SequenceLikelihood.NEGATIVE,  # 'C'
        35: SequenceLikelihood.NEGATIVE,  # 'D'
        31: SequenceLikelihood.NEGATIVE,  # 'E'
        42: SequenceLikelihood.NEGATIVE,  # 'F'
        47: SequenceLikelihood.NEGATIVE,  # 'G'
        50: SequenceLikelihood.NEGATIVE,  # 'H'
        36: SequenceLikelihood.NEGATIVE,  # 'I'
        48: SequenceLikelihood.NEGATIVE,  # 'J'
        56: SequenceLikelihood.NEGATIVE,  # 'K'
        24: SequenceLikelihood.NEGATIVE,  # 'L'
        33: SequenceLikelihood.NEGATIVE,  # 'M'
        39: SequenceLikelihood.NEGATIVE,  # 'N'
        43: SequenceLikelihood.NEGATIVE,  # 'O'
        32: SequenceLikelihood.NEGATIVE,  # 'P'
        55: SequenceLikelihood.NEGATIVE,  # 'Q'
        38: SequenceLikelihood.NEGATIVE,  # 'R'
        30: SequenceLikelihood.NEGATIVE,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        46: SequenceLikelihood.NEGATIVE,  # 'U'
        45: SequenceLikelihood.NEGATIVE,  # 'V'
        54: SequenceLikelihood.NEGATIVE,  # 'W'
        61: SequenceLikelihood.NEGATIVE,  # 'X'
        60: SequenceLikelihood.NEGATIVE,  # 'Y'
        63: SequenceLikelihood.NEGATIVE,  # 'Z'
        3: SequenceLikelihood.UNLIKELY,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        12: SequenceLikelihood.LIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.UNLIKELY,  # 'e'
        17: SequenceLikelihood.UNLIKELY,  # 'f'
        18: SequenceLikelihood.UNLIKELY,  # 'g'
        20: SequenceLikelihood.UNLIKELY,  # 'h'
        5: SequenceLikelihood.UNLIKELY,  # 'i'
        26: SequenceLikelihood.NEGATIVE,  # 'j'
        44: SequenceLikelihood.UNLIKELY,  # 'k'
        10: SequenceLikelihood.LIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        8: SequenceLikelihood.UNLIKELY,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        21: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        2: SequenceLikelihood.UNLIKELY,  # 's'
        6: SequenceLikelihood.POSITIVE,  # 't'
        9: SequenceLikelihood.NEGATIVE,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        49: SequenceLikelihood.UNLIKELY,  # 'w'
        23: SequenceLikelihood.UNLIKELY,  # 'x'
        27: SequenceLikelihood.UNLIKELY,  # 'y'
        34: SequenceLikelihood.UNLIKELY,  # 'z'
        66: SequenceLikelihood.NEGATIVE,  # 'À'
        73: SequenceLikelihood.NEGATIVE,  # 'Â'
        83: SequenceLikelihood.NEGATIVE,  # 'Æ'
        69: SequenceLikelihood.NEGATIVE,  # 'Ç'
        70: SequenceLikelihood.NEGATIVE,  # 'È'
        58: SequenceLikelihood.NEGATIVE,  # 'É'
        72: SequenceLikelihood.NEGATIVE,  # 'Ê'
        80: SequenceLikelihood.NEGATIVE,  # 'Ë'
        71: SequenceLikelihood.NEGATIVE,  # 'Î'
        77: SequenceLikelihood.NEGATIVE,  # 'Ï'
        74: SequenceLikelihood.NEGATIVE,  # 'Ô'
        82: SequenceLikelihood.NEGATIVE,  # 'Ù'
        79: SequenceLikelihood.NEGATIVE,  # 'Û'
        78: SequenceLikelihood.NEGATIVE,  # 'Ü'
        22: SequenceLikelihood.NEGATIVE,  # 'à'
        53: SequenceLikelihood.UNLIKELY,  # 'â'
        76: SequenceLikelihood.NEGATIVE,  # 'æ'
        51: SequenceLikelihood.NEGATIVE,  # 'ç'
        28: SequenceLikelihood.NEGATIVE,  # 'è'
        15: SequenceLikelihood.NEGATIVE,  # 'é'
        41: SequenceLikelihood.NEGATIVE,  # 'ê'
        67: SequenceLikelihood.NEGATIVE,  # 'ë'
        57: SequenceLikelihood.UNLIKELY,  # 'î'
        65: SequenceLikelihood.NEGATIVE,  # 'ï'
        52: SequenceLikelihood.NEGATIVE,  # 'ô'
        62: SequenceLikelihood.NEGATIVE,  # 'ù'
        59: SequenceLikelihood.NEGATIVE,  # 'û'
        68: SequenceLikelihood.NEGATIVE,  # 'ü'
        81: SequenceLikelihood.NEGATIVE,  # 'ÿ'
        75: SequenceLikelihood.NEGATIVE,  # 'Œ'
        64: SequenceLikelihood.NEGATIVE,  # 'œ'
        84: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
    },
    65: {  # 'ï'
        29: SequenceLikelihood.NEGATIVE,  # 'A'
        40: SequenceLikelihood.UNLIKELY,  # 'B'
        25: SequenceLikelihood.UNLIKELY,  # 'C'
        35: SequenceLikelihood.UNLIKELY,  # 'D'
        31: SequenceLikelihood.NEGATIVE,  # 'E'
        42: SequenceLikelihood.NEGATIVE,  # 'F'
        47: SequenceLikelihood.NEGATIVE,  # 'G'
        50: SequenceLikelihood.NEGATIVE,  # 'H'
        36: SequenceLikelihood.NEGATIVE,  # 'I'
        48: SequenceLikelihood.NEGATIVE,  # 'J'
        56: SequenceLikelihood.UNLIKELY,  # 'K'
        24: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.NEGATIVE,  # 'N'
        43: SequenceLikelihood.NEGATIVE,  # 'O'
        32: SequenceLikelihood.NEGATIVE,  # 'P'
        55: SequenceLikelihood.NEGATIVE,  # 'Q'
        38: SequenceLikelihood.NEGATIVE,  # 'R'
        30: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        46: SequenceLikelihood.NEGATIVE,  # 'U'
        45: SequenceLikelihood.NEGATIVE,  # 'V'
        54: SequenceLikelihood.NEGATIVE,  # 'W'
        61: SequenceLikelihood.UNLIKELY,  # 'X'
        60: SequenceLikelihood.NEGATIVE,  # 'Y'
        63: SequenceLikelihood.NEGATIVE,  # 'Z'
        3: SequenceLikelihood.UNLIKELY,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        12: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.LIKELY,  # 'd'
        1: SequenceLikelihood.UNLIKELY,  # 'e'
        17: SequenceLikelihood.UNLIKELY,  # 'f'
        18: SequenceLikelihood.UNLIKELY,  # 'g'
        20: SequenceLikelihood.UNLIKELY,  # 'h'
        5: SequenceLikelihood.UNLIKELY,  # 'i'
        26: SequenceLikelihood.UNLIKELY,  # 'j'
        44: SequenceLikelihood.UNLIKELY,  # 'k'
        10: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        8: SequenceLikelihood.UNLIKELY,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        21: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        2: SequenceLikelihood.LIKELY,  # 's'
        6: SequenceLikelihood.UNLIKELY,  # 't'
        9: SequenceLikelihood.UNLIKELY,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        49: SequenceLikelihood.UNLIKELY,  # 'w'
        23: SequenceLikelihood.UNLIKELY,  # 'x'
        27: SequenceLikelihood.UNLIKELY,  # 'y'
        34: SequenceLikelihood.UNLIKELY,  # 'z'
        66: SequenceLikelihood.NEGATIVE,  # 'À'
        73: SequenceLikelihood.NEGATIVE,  # 'Â'
        83: SequenceLikelihood.NEGATIVE,  # 'Æ'
        69: SequenceLikelihood.NEGATIVE,  # 'Ç'
        70: SequenceLikelihood.NEGATIVE,  # 'È'
        58: SequenceLikelihood.NEGATIVE,  # 'É'
        72: SequenceLikelihood.NEGATIVE,  # 'Ê'
        80: SequenceLikelihood.NEGATIVE,  # 'Ë'
        71: SequenceLikelihood.NEGATIVE,  # 'Î'
        77: SequenceLikelihood.NEGATIVE,  # 'Ï'
        74: SequenceLikelihood.NEGATIVE,  # 'Ô'
        82: SequenceLikelihood.NEGATIVE,  # 'Ù'
        79: SequenceLikelihood.NEGATIVE,  # 'Û'
        78: SequenceLikelihood.NEGATIVE,  # 'Ü'
        22: SequenceLikelihood.NEGATIVE,  # 'à'
        53: SequenceLikelihood.NEGATIVE,  # 'â'
        76: SequenceLikelihood.NEGATIVE,  # 'æ'
        51: SequenceLikelihood.NEGATIVE,  # 'ç'
        28: SequenceLikelihood.UNLIKELY,  # 'è'
        15: SequenceLikelihood.UNLIKELY,  # 'é'
        41: SequenceLikelihood.NEGATIVE,  # 'ê'
        67: SequenceLikelihood.NEGATIVE,  # 'ë'
        57: SequenceLikelihood.UNLIKELY,  # 'î'
        65: SequenceLikelihood.UNLIKELY,  # 'ï'
        52: SequenceLikelihood.UNLIKELY,  # 'ô'
        62: SequenceLikelihood.NEGATIVE,  # 'ù'
        59: SequenceLikelihood.NEGATIVE,  # 'û'
        68: SequenceLikelihood.NEGATIVE,  # 'ü'
        81: SequenceLikelihood.NEGATIVE,  # 'ÿ'
        75: SequenceLikelihood.NEGATIVE,  # 'Œ'
        64: SequenceLikelihood.NEGATIVE,  # 'œ'
        84: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
    },
    52: {  # 'ô'
        29: SequenceLikelihood.NEGATIVE,  # 'A'
        40: SequenceLikelihood.UNLIKELY,  # 'B'
        25: SequenceLikelihood.NEGATIVE,  # 'C'
        35: SequenceLikelihood.NEGATIVE,  # 'D'
        31: SequenceLikelihood.UNLIKELY,  # 'E'
        42: SequenceLikelihood.NEGATIVE,  # 'F'
        47: SequenceLikelihood.NEGATIVE,  # 'G'
        50: SequenceLikelihood.NEGATIVE,  # 'H'
        36: SequenceLikelihood.NEGATIVE,  # 'I'
        48: SequenceLikelihood.NEGATIVE,  # 'J'
        56: SequenceLikelihood.NEGATIVE,  # 'K'
        24: SequenceLikelihood.NEGATIVE,  # 'L'
        33: SequenceLikelihood.NEGATIVE,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        43: SequenceLikelihood.NEGATIVE,  # 'O'
        32: SequenceLikelihood.UNLIKELY,  # 'P'
        55: SequenceLikelihood.NEGATIVE,  # 'Q'
        38: SequenceLikelihood.NEGATIVE,  # 'R'
        30: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        46: SequenceLikelihood.NEGATIVE,  # 'U'
        45: SequenceLikelihood.NEGATIVE,  # 'V'
        54: SequenceLikelihood.NEGATIVE,  # 'W'
        61: SequenceLikelihood.NEGATIVE,  # 'X'
        60: SequenceLikelihood.NEGATIVE,  # 'Y'
        63: SequenceLikelihood.NEGATIVE,  # 'Z'
        3: SequenceLikelihood.UNLIKELY,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        12: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.UNLIKELY,  # 'e'
        17: SequenceLikelihood.UNLIKELY,  # 'f'
        18: SequenceLikelihood.UNLIKELY,  # 'g'
        20: SequenceLikelihood.UNLIKELY,  # 'h'
        5: SequenceLikelihood.UNLIKELY,  # 'i'
        26: SequenceLikelihood.UNLIKELY,  # 'j'
        44: SequenceLikelihood.UNLIKELY,  # 'k'
        10: SequenceLikelihood.POSITIVE,  # 'l'
        14: SequenceLikelihood.LIKELY,  # 'm'
        4: SequenceLikelihood.LIKELY,  # 'n'
        8: SequenceLikelihood.UNLIKELY,  # 'o'
        13: SequenceLikelihood.LIKELY,  # 'p'
        21: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        2: SequenceLikelihood.UNLIKELY,  # 's'
        6: SequenceLikelihood.POSITIVE,  # 't'
        9: SequenceLikelihood.UNLIKELY,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        49: SequenceLikelihood.UNLIKELY,  # 'w'
        23: SequenceLikelihood.NEGATIVE,  # 'x'
        27: SequenceLikelihood.UNLIKELY,  # 'y'
        34: SequenceLikelihood.UNLIKELY,  # 'z'
        66: SequenceLikelihood.NEGATIVE,  # 'À'
        73: SequenceLikelihood.NEGATIVE,  # 'Â'
        83: SequenceLikelihood.NEGATIVE,  # 'Æ'
        69: SequenceLikelihood.NEGATIVE,  # 'Ç'
        70: SequenceLikelihood.NEGATIVE,  # 'È'
        58: SequenceLikelihood.NEGATIVE,  # 'É'
        72: SequenceLikelihood.NEGATIVE,  # 'Ê'
        80: SequenceLikelihood.NEGATIVE,  # 'Ë'
        71: SequenceLikelihood.NEGATIVE,  # 'Î'
        77: SequenceLikelihood.NEGATIVE,  # 'Ï'
        74: SequenceLikelihood.NEGATIVE,  # 'Ô'
        82: SequenceLikelihood.NEGATIVE,  # 'Ù'
        79: SequenceLikelihood.NEGATIVE,  # 'Û'
        78: SequenceLikelihood.NEGATIVE,  # 'Ü'
        22: SequenceLikelihood.NEGATIVE,  # 'à'
        53: SequenceLikelihood.NEGATIVE,  # 'â'
        76: SequenceLikelihood.NEGATIVE,  # 'æ'
        51: SequenceLikelihood.UNLIKELY,  # 'ç'
        28: SequenceLikelihood.UNLIKELY,  # 'è'
        15: SequenceLikelihood.NEGATIVE,  # 'é'
        41: SequenceLikelihood.UNLIKELY,  # 'ê'
        67: SequenceLikelihood.NEGATIVE,  # 'ë'
        57: SequenceLikelihood.NEGATIVE,  # 'î'
        65: SequenceLikelihood.NEGATIVE,  # 'ï'
        52: SequenceLikelihood.UNLIKELY,  # 'ô'
        62: SequenceLikelihood.NEGATIVE,  # 'ù'
        59: SequenceLikelihood.NEGATIVE,  # 'û'
        68: SequenceLikelihood.NEGATIVE,  # 'ü'
        81: SequenceLikelihood.NEGATIVE,  # 'ÿ'
        75: SequenceLikelihood.NEGATIVE,  # 'Œ'
        64: SequenceLikelihood.NEGATIVE,  # 'œ'
        84: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
    },
    62: {  # 'ù'
        29: SequenceLikelihood.NEGATIVE,  # 'A'
        40: SequenceLikelihood.NEGATIVE,  # 'B'
        25: SequenceLikelihood.NEGATIVE,  # 'C'
        35: SequenceLikelihood.UNLIKELY,  # 'D'
        31: SequenceLikelihood.NEGATIVE,  # 'E'
        42: SequenceLikelihood.NEGATIVE,  # 'F'
        47: SequenceLikelihood.NEGATIVE,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        36: SequenceLikelihood.NEGATIVE,  # 'I'
        48: SequenceLikelihood.NEGATIVE,  # 'J'
        56: SequenceLikelihood.NEGATIVE,  # 'K'
        24: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.NEGATIVE,  # 'M'
        39: SequenceLikelihood.NEGATIVE,  # 'N'
        43: SequenceLikelihood.NEGATIVE,  # 'O'
        32: SequenceLikelihood.NEGATIVE,  # 'P'
        55: SequenceLikelihood.NEGATIVE,  # 'Q'
        38: SequenceLikelihood.NEGATIVE,  # 'R'
        30: SequenceLikelihood.NEGATIVE,  # 'S'
        37: SequenceLikelihood.NEGATIVE,  # 'T'
        46: SequenceLikelihood.NEGATIVE,  # 'U'
        45: SequenceLikelihood.NEGATIVE,  # 'V'
        54: SequenceLikelihood.NEGATIVE,  # 'W'
        61: SequenceLikelihood.NEGATIVE,  # 'X'
        60: SequenceLikelihood.NEGATIVE,  # 'Y'
        63: SequenceLikelihood.NEGATIVE,  # 'Z'
        3: SequenceLikelihood.UNLIKELY,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        12: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.UNLIKELY,  # 'e'
        17: SequenceLikelihood.UNLIKELY,  # 'f'
        18: SequenceLikelihood.UNLIKELY,  # 'g'
        20: SequenceLikelihood.NEGATIVE,  # 'h'
        5: SequenceLikelihood.UNLIKELY,  # 'i'
        26: SequenceLikelihood.UNLIKELY,  # 'j'
        44: SequenceLikelihood.NEGATIVE,  # 'k'
        10: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        8: SequenceLikelihood.UNLIKELY,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        21: SequenceLikelihood.NEGATIVE,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        2: SequenceLikelihood.UNLIKELY,  # 's'
        6: SequenceLikelihood.UNLIKELY,  # 't'
        9: SequenceLikelihood.NEGATIVE,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        49: SequenceLikelihood.NEGATIVE,  # 'w'
        23: SequenceLikelihood.NEGATIVE,  # 'x'
        27: SequenceLikelihood.UNLIKELY,  # 'y'
        34: SequenceLikelihood.UNLIKELY,  # 'z'
        66: SequenceLikelihood.NEGATIVE,  # 'À'
        73: SequenceLikelihood.NEGATIVE,  # 'Â'
        83: SequenceLikelihood.NEGATIVE,  # 'Æ'
        69: SequenceLikelihood.NEGATIVE,  # 'Ç'
        70: SequenceLikelihood.NEGATIVE,  # 'È'
        58: SequenceLikelihood.NEGATIVE,  # 'É'
        72: SequenceLikelihood.NEGATIVE,  # 'Ê'
        80: SequenceLikelihood.NEGATIVE,  # 'Ë'
        71: SequenceLikelihood.NEGATIVE,  # 'Î'
        77: SequenceLikelihood.NEGATIVE,  # 'Ï'
        74: SequenceLikelihood.NEGATIVE,  # 'Ô'
        82: SequenceLikelihood.NEGATIVE,  # 'Ù'
        79: SequenceLikelihood.NEGATIVE,  # 'Û'
        78: SequenceLikelihood.NEGATIVE,  # 'Ü'
        22: SequenceLikelihood.NEGATIVE,  # 'à'
        53: SequenceLikelihood.NEGATIVE,  # 'â'
        76: SequenceLikelihood.NEGATIVE,  # 'æ'
        51: SequenceLikelihood.NEGATIVE,  # 'ç'
        28: SequenceLikelihood.UNLIKELY,  # 'è'
        15: SequenceLikelihood.NEGATIVE,  # 'é'
        41: SequenceLikelihood.NEGATIVE,  # 'ê'
        67: SequenceLikelihood.NEGATIVE,  # 'ë'
        57: SequenceLikelihood.NEGATIVE,  # 'î'
        65: SequenceLikelihood.NEGATIVE,  # 'ï'
        52: SequenceLikelihood.NEGATIVE,  # 'ô'
        62: SequenceLikelihood.NEGATIVE,  # 'ù'
        59: SequenceLikelihood.NEGATIVE,  # 'û'
        68: SequenceLikelihood.NEGATIVE,  # 'ü'
        81: SequenceLikelihood.NEGATIVE,  # 'ÿ'
        75: SequenceLikelihood.NEGATIVE,  # 'Œ'
        64: SequenceLikelihood.NEGATIVE,  # 'œ'
        84: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
    },
    59: {  # 'û'
        29: SequenceLikelihood.NEGATIVE,  # 'A'
        40: SequenceLikelihood.UNLIKELY,  # 'B'
        25: SequenceLikelihood.NEGATIVE,  # 'C'
        35: SequenceLikelihood.NEGATIVE,  # 'D'
        31: SequenceLikelihood.UNLIKELY,  # 'E'
        42: SequenceLikelihood.NEGATIVE,  # 'F'
        47: SequenceLikelihood.NEGATIVE,  # 'G'
        50: SequenceLikelihood.NEGATIVE,  # 'H'
        36: SequenceLikelihood.NEGATIVE,  # 'I'
        48: SequenceLikelihood.NEGATIVE,  # 'J'
        56: SequenceLikelihood.NEGATIVE,  # 'K'
        24: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.NEGATIVE,  # 'M'
        39: SequenceLikelihood.NEGATIVE,  # 'N'
        43: SequenceLikelihood.NEGATIVE,  # 'O'
        32: SequenceLikelihood.NEGATIVE,  # 'P'
        55: SequenceLikelihood.NEGATIVE,  # 'Q'
        38: SequenceLikelihood.UNLIKELY,  # 'R'
        30: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.NEGATIVE,  # 'T'
        46: SequenceLikelihood.NEGATIVE,  # 'U'
        45: SequenceLikelihood.NEGATIVE,  # 'V'
        54: SequenceLikelihood.NEGATIVE,  # 'W'
        61: SequenceLikelihood.NEGATIVE,  # 'X'
        60: SequenceLikelihood.NEGATIVE,  # 'Y'
        63: SequenceLikelihood.NEGATIVE,  # 'Z'
        3: SequenceLikelihood.NEGATIVE,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        12: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.UNLIKELY,  # 'e'
        17: SequenceLikelihood.UNLIKELY,  # 'f'
        18: SequenceLikelihood.UNLIKELY,  # 'g'
        20: SequenceLikelihood.UNLIKELY,  # 'h'
        5: SequenceLikelihood.UNLIKELY,  # 'i'
        26: SequenceLikelihood.UNLIKELY,  # 'j'
        44: SequenceLikelihood.UNLIKELY,  # 'k'
        10: SequenceLikelihood.LIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        8: SequenceLikelihood.UNLIKELY,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        21: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.LIKELY,  # 'r'
        2: SequenceLikelihood.UNLIKELY,  # 's'
        6: SequenceLikelihood.POSITIVE,  # 't'
        9: SequenceLikelihood.UNLIKELY,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        49: SequenceLikelihood.NEGATIVE,  # 'w'
        23: SequenceLikelihood.NEGATIVE,  # 'x'
        27: SequenceLikelihood.NEGATIVE,  # 'y'
        34: SequenceLikelihood.NEGATIVE,  # 'z'
        66: SequenceLikelihood.NEGATIVE,  # 'À'
        73: SequenceLikelihood.NEGATIVE,  # 'Â'
        83: SequenceLikelihood.NEGATIVE,  # 'Æ'
        69: SequenceLikelihood.NEGATIVE,  # 'Ç'
        70: SequenceLikelihood.NEGATIVE,  # 'È'
        58: SequenceLikelihood.NEGATIVE,  # 'É'
        72: SequenceLikelihood.NEGATIVE,  # 'Ê'
        80: SequenceLikelihood.NEGATIVE,  # 'Ë'
        71: SequenceLikelihood.NEGATIVE,  # 'Î'
        77: SequenceLikelihood.NEGATIVE,  # 'Ï'
        74: SequenceLikelihood.NEGATIVE,  # 'Ô'
        82: SequenceLikelihood.NEGATIVE,  # 'Ù'
        79: SequenceLikelihood.NEGATIVE,  # 'Û'
        78: SequenceLikelihood.NEGATIVE,  # 'Ü'
        22: SequenceLikelihood.NEGATIVE,  # 'à'
        53: SequenceLikelihood.NEGATIVE,  # 'â'
        76: SequenceLikelihood.NEGATIVE,  # 'æ'
        51: SequenceLikelihood.UNLIKELY,  # 'ç'
        28: SequenceLikelihood.NEGATIVE,  # 'è'
        15: SequenceLikelihood.NEGATIVE,  # 'é'
        41: SequenceLikelihood.NEGATIVE,  # 'ê'
        67: SequenceLikelihood.NEGATIVE,  # 'ë'
        57: SequenceLikelihood.NEGATIVE,  # 'î'
        65: SequenceLikelihood.NEGATIVE,  # 'ï'
        52: SequenceLikelihood.NEGATIVE,  # 'ô'
        62: SequenceLikelihood.NEGATIVE,  # 'ù'
        59: SequenceLikelihood.UNLIKELY,  # 'û'
        68: SequenceLikelihood.NEGATIVE,  # 'ü'
        81: SequenceLikelihood.NEGATIVE,  # 'ÿ'
        75: SequenceLikelihood.NEGATIVE,  # 'Œ'
        64: SequenceLikelihood.NEGATIVE,  # 'œ'
        84: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
    },
    68: {  # 'ü'
        29: SequenceLikelihood.NEGATIVE,  # 'A'
        40: SequenceLikelihood.NEGATIVE,  # 'B'
        25: SequenceLikelihood.NEGATIVE,  # 'C'
        35: SequenceLikelihood.NEGATIVE,  # 'D'
        31: SequenceLikelihood.NEGATIVE,  # 'E'
        42: SequenceLikelihood.NEGATIVE,  # 'F'
        47: SequenceLikelihood.NEGATIVE,  # 'G'
        50: SequenceLikelihood.NEGATIVE,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        48: SequenceLikelihood.NEGATIVE,  # 'J'
        56: SequenceLikelihood.NEGATIVE,  # 'K'
        24: SequenceLikelihood.NEGATIVE,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.NEGATIVE,  # 'N'
        43: SequenceLikelihood.NEGATIVE,  # 'O'
        32: SequenceLikelihood.NEGATIVE,  # 'P'
        55: SequenceLikelihood.NEGATIVE,  # 'Q'
        38: SequenceLikelihood.NEGATIVE,  # 'R'
        30: SequenceLikelihood.NEGATIVE,  # 'S'
        37: SequenceLikelihood.NEGATIVE,  # 'T'
        46: SequenceLikelihood.NEGATIVE,  # 'U'
        45: SequenceLikelihood.NEGATIVE,  # 'V'
        54: SequenceLikelihood.NEGATIVE,  # 'W'
        61: SequenceLikelihood.NEGATIVE,  # 'X'
        60: SequenceLikelihood.NEGATIVE,  # 'Y'
        63: SequenceLikelihood.NEGATIVE,  # 'Z'
        3: SequenceLikelihood.UNLIKELY,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        12: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.UNLIKELY,  # 'e'
        17: SequenceLikelihood.UNLIKELY,  # 'f'
        18: SequenceLikelihood.UNLIKELY,  # 'g'
        20: SequenceLikelihood.UNLIKELY,  # 'h'
        5: SequenceLikelihood.UNLIKELY,  # 'i'
        26: SequenceLikelihood.NEGATIVE,  # 'j'
        44: SequenceLikelihood.UNLIKELY,  # 'k'
        10: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        8: SequenceLikelihood.UNLIKELY,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        21: SequenceLikelihood.NEGATIVE,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        2: SequenceLikelihood.UNLIKELY,  # 's'
        6: SequenceLikelihood.UNLIKELY,  # 't'
        9: SequenceLikelihood.NEGATIVE,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        49: SequenceLikelihood.UNLIKELY,  # 'w'
        23: SequenceLikelihood.NEGATIVE,  # 'x'
        27: SequenceLikelihood.UNLIKELY,  # 'y'
        34: SequenceLikelihood.UNLIKELY,  # 'z'
        66: SequenceLikelihood.NEGATIVE,  # 'À'
        73: SequenceLikelihood.NEGATIVE,  # 'Â'
        83: SequenceLikelihood.NEGATIVE,  # 'Æ'
        69: SequenceLikelihood.NEGATIVE,  # 'Ç'
        70: SequenceLikelihood.NEGATIVE,  # 'È'
        58: SequenceLikelihood.NEGATIVE,  # 'É'
        72: SequenceLikelihood.NEGATIVE,  # 'Ê'
        80: SequenceLikelihood.NEGATIVE,  # 'Ë'
        71: SequenceLikelihood.NEGATIVE,  # 'Î'
        77: SequenceLikelihood.NEGATIVE,  # 'Ï'
        74: SequenceLikelihood.NEGATIVE,  # 'Ô'
        82: SequenceLikelihood.NEGATIVE,  # 'Ù'
        79: SequenceLikelihood.NEGATIVE,  # 'Û'
        78: SequenceLikelihood.NEGATIVE,  # 'Ü'
        22: SequenceLikelihood.NEGATIVE,  # 'à'
        53: SequenceLikelihood.NEGATIVE,  # 'â'
        76: SequenceLikelihood.NEGATIVE,  # 'æ'
        51: SequenceLikelihood.UNLIKELY,  # 'ç'
        28: SequenceLikelihood.NEGATIVE,  # 'è'
        15: SequenceLikelihood.UNLIKELY,  # 'é'
        41: SequenceLikelihood.NEGATIVE,  # 'ê'
        67: SequenceLikelihood.NEGATIVE,  # 'ë'
        57: SequenceLikelihood.NEGATIVE,  # 'î'
        65: SequenceLikelihood.NEGATIVE,  # 'ï'
        52: SequenceLikelihood.NEGATIVE,  # 'ô'
        62: SequenceLikelihood.NEGATIVE,  # 'ù'
        59: SequenceLikelihood.NEGATIVE,  # 'û'
        68: SequenceLikelihood.UNLIKELY,  # 'ü'
        81: SequenceLikelihood.NEGATIVE,  # 'ÿ'
        75: SequenceLikelihood.NEGATIVE,  # 'Œ'
        64: SequenceLikelihood.NEGATIVE,  # 'œ'
        84: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
    },
    81: {  # 'ÿ'
        29: SequenceLikelihood.NEGATIVE,  # 'A'
        40: SequenceLikelihood.NEGATIVE,  # 'B'
        25: SequenceLikelihood.NEGATIVE,  # 'C'
        35: SequenceLikelihood.NEGATIVE,  # 'D'
        31: SequenceLikelihood.NEGATIVE,  # 'E'
        42: SequenceLikelihood.NEGATIVE,  # 'F'
        47: SequenceLikelihood.NEGATIVE,  # 'G'
        50: SequenceLikelihood.NEGATIVE,  # 'H'
        36: SequenceLikelihood.NEGATIVE,  # 'I'
        48: SequenceLikelihood.NEGATIVE,  # 'J'
        56: SequenceLikelihood.NEGATIVE,  # 'K'
        24: SequenceLikelihood.NEGATIVE,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        39: SequenceLikelihood.NEGATIVE,  # 'N'
        43: SequenceLikelihood.NEGATIVE,  # 'O'
        32: SequenceLikelihood.NEGATIVE,  # 'P'
        55: SequenceLikelihood.NEGATIVE,  # 'Q'
        38: SequenceLikelihood.NEGATIVE,  # 'R'
        30: SequenceLikelihood.NEGATIVE,  # 'S'
        37: SequenceLikelihood.NEGATIVE,  # 'T'
        46: SequenceLikelihood.NEGATIVE,  # 'U'
        45: SequenceLikelihood.NEGATIVE,  # 'V'
        54: SequenceLikelihood.NEGATIVE,  # 'W'
        61: SequenceLikelihood.NEGATIVE,  # 'X'
        60: SequenceLikelihood.NEGATIVE,  # 'Y'
        63: SequenceLikelihood.NEGATIVE,  # 'Z'
        3: SequenceLikelihood.UNLIKELY,  # 'a'
        19: SequenceLikelihood.NEGATIVE,  # 'b'
        12: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.NEGATIVE,  # 'd'
        1: SequenceLikelihood.UNLIKELY,  # 'e'
        17: SequenceLikelihood.UNLIKELY,  # 'f'
        18: SequenceLikelihood.UNLIKELY,  # 'g'
        20: SequenceLikelihood.NEGATIVE,  # 'h'
        5: SequenceLikelihood.UNLIKELY,  # 'i'
        26: SequenceLikelihood.NEGATIVE,  # 'j'
        44: SequenceLikelihood.NEGATIVE,  # 'k'
        10: SequenceLikelihood.NEGATIVE,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        8: SequenceLikelihood.NEGATIVE,  # 'o'
        13: SequenceLikelihood.NEGATIVE,  # 'p'
        21: SequenceLikelihood.NEGATIVE,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        2: SequenceLikelihood.UNLIKELY,  # 's'
        6: SequenceLikelihood.UNLIKELY,  # 't'
        9: SequenceLikelihood.NEGATIVE,  # 'u'
        16: SequenceLikelihood.NEGATIVE,  # 'v'
        49: SequenceLikelihood.NEGATIVE,  # 'w'
        23: SequenceLikelihood.NEGATIVE,  # 'x'
        27: SequenceLikelihood.NEGATIVE,  # 'y'
        34: SequenceLikelihood.NEGATIVE,  # 'z'
        66: SequenceLikelihood.NEGATIVE,  # 'À'
        73: SequenceLikelihood.NEGATIVE,  # 'Â'
        83: SequenceLikelihood.NEGATIVE,  # 'Æ'
        69: SequenceLikelihood.NEGATIVE,  # 'Ç'
        70: SequenceLikelihood.NEGATIVE,  # 'È'
        58: SequenceLikelihood.NEGATIVE,  # 'É'
        72: SequenceLikelihood.NEGATIVE,  # 'Ê'
        80: SequenceLikelihood.NEGATIVE,  # 'Ë'
        71: SequenceLikelihood.NEGATIVE,  # 'Î'
        77: SequenceLikelihood.NEGATIVE,  # 'Ï'
        74: SequenceLikelihood.NEGATIVE,  # 'Ô'
        82: SequenceLikelihood.NEGATIVE,  # 'Ù'
        79: SequenceLikelihood.NEGATIVE,  # 'Û'
        78: SequenceLikelihood.NEGATIVE,  # 'Ü'
        22: SequenceLikelihood.NEGATIVE,  # 'à'
        53: SequenceLikelihood.NEGATIVE,  # 'â'
        76: SequenceLikelihood.NEGATIVE,  # 'æ'
        51: SequenceLikelihood.NEGATIVE,  # 'ç'
        28: SequenceLikelihood.NEGATIVE,  # 'è'
        15: SequenceLikelihood.NEGATIVE,  # 'é'
        41: SequenceLikelihood.NEGATIVE,  # 'ê'
        67: SequenceLikelihood.NEGATIVE,  # 'ë'
        57: SequenceLikelihood.NEGATIVE,  # 'î'
        65: SequenceLikelihood.NEGATIVE,  # 'ï'
        52: SequenceLikelihood.NEGATIVE,  # 'ô'
        62: SequenceLikelihood.NEGATIVE,  # 'ù'
        59: SequenceLikelihood.NEGATIVE,  # 'û'
        68: SequenceLikelihood.NEGATIVE,  # 'ü'
        81: SequenceLikelihood.NEGATIVE,  # 'ÿ'
        75: SequenceLikelihood.NEGATIVE,  # 'Œ'
        64: SequenceLikelihood.NEGATIVE,  # 'œ'
        84: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
    },
    75: {  # 'Œ'
        29: SequenceLikelihood.NEGATIVE,  # 'A'
        40: SequenceLikelihood.NEGATIVE,  # 'B'
        25: SequenceLikelihood.NEGATIVE,  # 'C'
        35: SequenceLikelihood.NEGATIVE,  # 'D'
        31: SequenceLikelihood.NEGATIVE,  # 'E'
        42: SequenceLikelihood.NEGATIVE,  # 'F'
        47: SequenceLikelihood.NEGATIVE,  # 'G'
        50: SequenceLikelihood.NEGATIVE,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        48: SequenceLikelihood.NEGATIVE,  # 'J'
        56: SequenceLikelihood.NEGATIVE,  # 'K'
        24: SequenceLikelihood.NEGATIVE,  # 'L'
        33: SequenceLikelihood.NEGATIVE,  # 'M'
        39: SequenceLikelihood.UNLIKELY,  # 'N'
        43: SequenceLikelihood.NEGATIVE,  # 'O'
        32: SequenceLikelihood.NEGATIVE,  # 'P'
        55: SequenceLikelihood.NEGATIVE,  # 'Q'
        38: SequenceLikelihood.NEGATIVE,  # 'R'
        30: SequenceLikelihood.NEGATIVE,  # 'S'
        37: SequenceLikelihood.NEGATIVE,  # 'T'
        46: SequenceLikelihood.UNLIKELY,  # 'U'
        45: SequenceLikelihood.NEGATIVE,  # 'V'
        54: SequenceLikelihood.NEGATIVE,  # 'W'
        61: SequenceLikelihood.NEGATIVE,  # 'X'
        60: SequenceLikelihood.NEGATIVE,  # 'Y'
        63: SequenceLikelihood.NEGATIVE,  # 'Z'
        3: SequenceLikelihood.NEGATIVE,  # 'a'
        19: SequenceLikelihood.NEGATIVE,  # 'b'
        12: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.NEGATIVE,  # 'e'
        17: SequenceLikelihood.NEGATIVE,  # 'f'
        18: SequenceLikelihood.NEGATIVE,  # 'g'
        20: SequenceLikelihood.NEGATIVE,  # 'h'
        5: SequenceLikelihood.UNLIKELY,  # 'i'
        26: SequenceLikelihood.NEGATIVE,  # 'j'
        44: SequenceLikelihood.UNLIKELY,  # 'k'
        10: SequenceLikelihood.NEGATIVE,  # 'l'
        14: SequenceLikelihood.NEGATIVE,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        8: SequenceLikelihood.NEGATIVE,  # 'o'
        13: SequenceLikelihood.NEGATIVE,  # 'p'
        21: SequenceLikelihood.NEGATIVE,  # 'q'
        7: SequenceLikelihood.NEGATIVE,  # 'r'
        2: SequenceLikelihood.UNLIKELY,  # 's'
        6: SequenceLikelihood.UNLIKELY,  # 't'
        9: SequenceLikelihood.UNLIKELY,  # 'u'
        16: SequenceLikelihood.NEGATIVE,  # 'v'
        49: SequenceLikelihood.NEGATIVE,  # 'w'
        23: SequenceLikelihood.NEGATIVE,  # 'x'
        27: SequenceLikelihood.NEGATIVE,  # 'y'
        34: SequenceLikelihood.NEGATIVE,  # 'z'
        66: SequenceLikelihood.NEGATIVE,  # 'À'
        73: SequenceLikelihood.NEGATIVE,  # 'Â'
        83: SequenceLikelihood.NEGATIVE,  # 'Æ'
        69: SequenceLikelihood.NEGATIVE,  # 'Ç'
        70: SequenceLikelihood.NEGATIVE,  # 'È'
        58: SequenceLikelihood.NEGATIVE,  # 'É'
        72: SequenceLikelihood.NEGATIVE,  # 'Ê'
        80: SequenceLikelihood.NEGATIVE,  # 'Ë'
        71: SequenceLikelihood.NEGATIVE,  # 'Î'
        77: SequenceLikelihood.NEGATIVE,  # 'Ï'
        74: SequenceLikelihood.NEGATIVE,  # 'Ô'
        82: SequenceLikelihood.NEGATIVE,  # 'Ù'
        79: SequenceLikelihood.NEGATIVE,  # 'Û'
        78: SequenceLikelihood.NEGATIVE,  # 'Ü'
        22: SequenceLikelihood.NEGATIVE,  # 'à'
        53: SequenceLikelihood.NEGATIVE,  # 'â'
        76: SequenceLikelihood.NEGATIVE,  # 'æ'
        51: SequenceLikelihood.NEGATIVE,  # 'ç'
        28: SequenceLikelihood.NEGATIVE,  # 'è'
        15: SequenceLikelihood.NEGATIVE,  # 'é'
        41: SequenceLikelihood.NEGATIVE,  # 'ê'
        67: SequenceLikelihood.NEGATIVE,  # 'ë'
        57: SequenceLikelihood.NEGATIVE,  # 'î'
        65: SequenceLikelihood.NEGATIVE,  # 'ï'
        52: SequenceLikelihood.NEGATIVE,  # 'ô'
        62: SequenceLikelihood.NEGATIVE,  # 'ù'
        59: SequenceLikelihood.NEGATIVE,  # 'û'
        68: SequenceLikelihood.NEGATIVE,  # 'ü'
        81: SequenceLikelihood.NEGATIVE,  # 'ÿ'
        75: SequenceLikelihood.NEGATIVE,  # 'Œ'
        64: SequenceLikelihood.NEGATIVE,  # 'œ'
        84: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
    },
    64: {  # 'œ'
        29: SequenceLikelihood.NEGATIVE,  # 'A'
        40: SequenceLikelihood.NEGATIVE,  # 'B'
        25: SequenceLikelihood.NEGATIVE,  # 'C'
        35: SequenceLikelihood.NEGATIVE,  # 'D'
        31: SequenceLikelihood.NEGATIVE,  # 'E'
        42: SequenceLikelihood.NEGATIVE,  # 'F'
        47: SequenceLikelihood.NEGATIVE,  # 'G'
        50: SequenceLikelihood.NEGATIVE,  # 'H'
        36: SequenceLikelihood.UNLIKELY,  # 'I'
        48: SequenceLikelihood.NEGATIVE,  # 'J'
        56: SequenceLikelihood.NEGATIVE,  # 'K'
        24: SequenceLikelihood.NEGATIVE,  # 'L'
        33: SequenceLikelihood.NEGATIVE,  # 'M'
        39: SequenceLikelihood.NEGATIVE,  # 'N'
        43: SequenceLikelihood.NEGATIVE,  # 'O'
        32: SequenceLikelihood.NEGATIVE,  # 'P'
        55: SequenceLikelihood.NEGATIVE,  # 'Q'
        38: SequenceLikelihood.NEGATIVE,  # 'R'
        30: SequenceLikelihood.NEGATIVE,  # 'S'
        37: SequenceLikelihood.NEGATIVE,  # 'T'
        46: SequenceLikelihood.UNLIKELY,  # 'U'
        45: SequenceLikelihood.NEGATIVE,  # 'V'
        54: SequenceLikelihood.NEGATIVE,  # 'W'
        61: SequenceLikelihood.UNLIKELY,  # 'X'
        60: SequenceLikelihood.NEGATIVE,  # 'Y'
        63: SequenceLikelihood.NEGATIVE,  # 'Z'
        3: SequenceLikelihood.NEGATIVE,  # 'a'
        19: SequenceLikelihood.UNLIKELY,  # 'b'
        12: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.UNLIKELY,  # 'e'
        17: SequenceLikelihood.UNLIKELY,  # 'f'
        18: SequenceLikelihood.UNLIKELY,  # 'g'
        20: SequenceLikelihood.UNLIKELY,  # 'h'
        5: SequenceLikelihood.LIKELY,  # 'i'
        26: SequenceLikelihood.NEGATIVE,  # 'j'
        44: SequenceLikelihood.UNLIKELY,  # 'k'
        10: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        8: SequenceLikelihood.UNLIKELY,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        21: SequenceLikelihood.NEGATIVE,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        2: SequenceLikelihood.UNLIKELY,  # 's'
        6: SequenceLikelihood.UNLIKELY,  # 't'
        9: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        49: SequenceLikelihood.UNLIKELY,  # 'w'
        23: SequenceLikelihood.UNLIKELY,  # 'x'
        27: SequenceLikelihood.NEGATIVE,  # 'y'
        34: SequenceLikelihood.NEGATIVE,  # 'z'
        66: SequenceLikelihood.NEGATIVE,  # 'À'
        73: SequenceLikelihood.NEGATIVE,  # 'Â'
        83: SequenceLikelihood.NEGATIVE,  # 'Æ'
        69: SequenceLikelihood.NEGATIVE,  # 'Ç'
        70: SequenceLikelihood.NEGATIVE,  # 'È'
        58: SequenceLikelihood.NEGATIVE,  # 'É'
        72: SequenceLikelihood.NEGATIVE,  # 'Ê'
        80: SequenceLikelihood.NEGATIVE,  # 'Ë'
        71: SequenceLikelihood.NEGATIVE,  # 'Î'
        77: SequenceLikelihood.NEGATIVE,  # 'Ï'
        74: SequenceLikelihood.NEGATIVE,  # 'Ô'
        82: SequenceLikelihood.NEGATIVE,  # 'Ù'
        79: SequenceLikelihood.NEGATIVE,  # 'Û'
        78: SequenceLikelihood.NEGATIVE,  # 'Ü'
        22: SequenceLikelihood.NEGATIVE,  # 'à'
        53: SequenceLikelihood.NEGATIVE,  # 'â'
        76: SequenceLikelihood.NEGATIVE,  # 'æ'
        51: SequenceLikelihood.NEGATIVE,  # 'ç'
        28: SequenceLikelihood.NEGATIVE,  # 'è'
        15: SequenceLikelihood.NEGATIVE,  # 'é'
        41: SequenceLikelihood.NEGATIVE,  # 'ê'
        67: SequenceLikelihood.NEGATIVE,  # 'ë'
        57: SequenceLikelihood.NEGATIVE,  # 'î'
        65: SequenceLikelihood.NEGATIVE,  # 'ï'
        52: SequenceLikelihood.NEGATIVE,  # 'ô'
        62: SequenceLikelihood.NEGATIVE,  # 'ù'
        59: SequenceLikelihood.NEGATIVE,  # 'û'
        68: SequenceLikelihood.NEGATIVE,  # 'ü'
        81: SequenceLikelihood.NEGATIVE,  # 'ÿ'
        75: SequenceLikelihood.NEGATIVE,  # 'Œ'
        64: SequenceLikelihood.NEGATIVE,  # 'œ'
        84: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
    },
    84: {  # 'Ÿ'
        29: SequenceLikelihood.NEGATIVE,  # 'A'
        40: SequenceLikelihood.NEGATIVE,  # 'B'
        25: SequenceLikelihood.NEGATIVE,  # 'C'
        35: SequenceLikelihood.NEGATIVE,  # 'D'
        31: SequenceLikelihood.NEGATIVE,  # 'E'
        42: SequenceLikelihood.NEGATIVE,  # 'F'
        47: SequenceLikelihood.NEGATIVE,  # 'G'
        50: SequenceLikelihood.NEGATIVE,  # 'H'
        36: SequenceLikelihood.NEGATIVE,  # 'I'
        48: SequenceLikelihood.NEGATIVE,  # 'J'
        56: SequenceLikelihood.NEGATIVE,  # 'K'
        24: SequenceLikelihood.NEGATIVE,  # 'L'
        33: SequenceLikelihood.NEGATIVE,  # 'M'
        39: SequenceLikelihood.NEGATIVE,  # 'N'
        43: SequenceLikelihood.NEGATIVE,  # 'O'
        32: SequenceLikelihood.NEGATIVE,  # 'P'
        55: SequenceLikelihood.NEGATIVE,  # 'Q'
        38: SequenceLikelihood.NEGATIVE,  # 'R'
        30: SequenceLikelihood.NEGATIVE,  # 'S'
        37: SequenceLikelihood.NEGATIVE,  # 'T'
        46: SequenceLikelihood.NEGATIVE,  # 'U'
        45: SequenceLikelihood.NEGATIVE,  # 'V'
        54: SequenceLikelihood.NEGATIVE,  # 'W'
        61: SequenceLikelihood.NEGATIVE,  # 'X'
        60: SequenceLikelihood.NEGATIVE,  # 'Y'
        63: SequenceLikelihood.NEGATIVE,  # 'Z'
        3: SequenceLikelihood.NEGATIVE,  # 'a'
        19: SequenceLikelihood.NEGATIVE,  # 'b'
        12: SequenceLikelihood.NEGATIVE,  # 'c'
        11: SequenceLikelihood.NEGATIVE,  # 'd'
        1: SequenceLikelihood.NEGATIVE,  # 'e'
        17: SequenceLikelihood.NEGATIVE,  # 'f'
        18: SequenceLikelihood.NEGATIVE,  # 'g'
        20: SequenceLikelihood.NEGATIVE,  # 'h'
        5: SequenceLikelihood.NEGATIVE,  # 'i'
        26: SequenceLikelihood.NEGATIVE,  # 'j'
        44: SequenceLikelihood.NEGATIVE,  # 'k'
        10: SequenceLikelihood.NEGATIVE,  # 'l'
        14: SequenceLikelihood.NEGATIVE,  # 'm'
        4: SequenceLikelihood.NEGATIVE,  # 'n'
        8: SequenceLikelihood.NEGATIVE,  # 'o'
        13: SequenceLikelihood.NEGATIVE,  # 'p'
        21: SequenceLikelihood.NEGATIVE,  # 'q'
        7: SequenceLikelihood.NEGATIVE,  # 'r'
        2: SequenceLikelihood.NEGATIVE,  # 's'
        6: SequenceLikelihood.NEGATIVE,  # 't'
        9: SequenceLikelihood.NEGATIVE,  # 'u'
        16: SequenceLikelihood.NEGATIVE,  # 'v'
        49: SequenceLikelihood.NEGATIVE,  # 'w'
        23: SequenceLikelihood.NEGATIVE,  # 'x'
        27: SequenceLikelihood.NEGATIVE,  # 'y'
        34: SequenceLikelihood.NEGATIVE,  # 'z'
        66: SequenceLikelihood.NEGATIVE,  # 'À'
        73: SequenceLikelihood.NEGATIVE,  # 'Â'
        83: SequenceLikelihood.NEGATIVE,  # 'Æ'
        69: SequenceLikelihood.NEGATIVE,  # 'Ç'
        70: SequenceLikelihood.NEGATIVE,  # 'È'
        58: SequenceLikelihood.NEGATIVE,  # 'É'
        72: SequenceLikelihood.NEGATIVE,  # 'Ê'
        80: SequenceLikelihood.NEGATIVE,  # 'Ë'
        71: SequenceLikelihood.NEGATIVE,  # 'Î'
        77: SequenceLikelihood.NEGATIVE,  # 'Ï'
        74: SequenceLikelihood.NEGATIVE,  # 'Ô'
        82: SequenceLikelihood.NEGATIVE,  # 'Ù'
        79: SequenceLikelihood.NEGATIVE,  # 'Û'
        78: SequenceLikelihood.NEGATIVE,  # 'Ü'
        22: SequenceLikelihood.NEGATIVE,  # 'à'
        53: SequenceLikelihood.NEGATIVE,  # 'â'
        76: SequenceLikelihood.NEGATIVE,  # 'æ'
        51: SequenceLikelihood.NEGATIVE,  # 'ç'
        28: SequenceLikelihood.NEGATIVE,  # 'è'
        15: SequenceLikelihood.NEGATIVE,  # 'é'
        41: SequenceLikelihood.NEGATIVE,  # 'ê'
        67: SequenceLikelihood.NEGATIVE,  # 'ë'
        57: SequenceLikelihood.NEGATIVE,  # 'î'
        65: SequenceLikelihood.NEGATIVE,  # 'ï'
        52: SequenceLikelihood.NEGATIVE,  # 'ô'
        62: SequenceLikelihood.NEGATIVE,  # 'ù'
        59: SequenceLikelihood.NEGATIVE,  # 'û'
        68: SequenceLikelihood.NEGATIVE,  # 'ü'
        81: SequenceLikelihood.NEGATIVE,  # 'ÿ'
        75: SequenceLikelihood.NEGATIVE,  # 'Œ'
        64: SequenceLikelihood.NEGATIVE,  # 'œ'
        84: SequenceLikelihood.NEGATIVE,  # 'Ÿ'
    },
}

# Character Mapping Table(s):
CP037_FRENCH_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x9c'
    5: CharacterCategory.CONTROL,  # '\t'
    6: CharacterCategory.CONTROL,  # '\x86'
    7: CharacterCategory.CONTROL,  # '\x7f'
    8: CharacterCategory.CONTROL,  # '\x97'
    9: CharacterCategory.CONTROL,  # '\x8d'
    10: CharacterCategory.CONTROL,  # '\x8e'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x9d'
    21: CharacterCategory.CONTROL,  # '\x85'
    22: CharacterCategory.CONTROL,  # '\x08'
    23: CharacterCategory.CONTROL,  # '\x87'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x92'
    27: CharacterCategory.CONTROL,  # '\x8f'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # '\x80'
    33: CharacterCategory.CONTROL,  # '\x81'
    34: CharacterCategory.CONTROL,  # '\x82'
    35: CharacterCategory.CONTROL,  # '\x83'
    36: CharacterCategory.CONTROL,  # '\x84'
    37: CharacterCategory.LINE_BREAK,  # '\n'
    38: CharacterCategory.CONTROL,  # '\x17'
    39: CharacterCategory.CONTROL,  # '\x1b'
    40: CharacterCategory.CONTROL,  # '\x88'
    41: CharacterCategory.CONTROL,  # '\x89'
    42: CharacterCategory.CONTROL,  # '\x8a'
    43: CharacterCategory.CONTROL,  # '\x8b'
    44: CharacterCategory.CONTROL,  # '\x8c'
    45: CharacterCategory.CONTROL,  # '\x05'
    46: CharacterCategory.CONTROL,  # '\x06'
    47: CharacterCategory.CONTROL,  # '\x07'
    48: CharacterCategory.CONTROL,  # '\x90'
    49: CharacterCategory.CONTROL,  # '\x91'
    50: CharacterCategory.CONTROL,  # '\x16'
    51: CharacterCategory.CONTROL,  # '\x93'
    52: CharacterCategory.CONTROL,  # '\x94'
    53: CharacterCategory.CONTROL,  # '\x95'
    54: CharacterCategory.CONTROL,  # '\x96'
    55: CharacterCategory.CONTROL,  # '\x04'
    56: CharacterCategory.CONTROL,  # '\x98'
    57: CharacterCategory.CONTROL,  # '\x99'
    58: CharacterCategory.CONTROL,  # '\x9a'
    59: CharacterCategory.CONTROL,  # '\x9b'
    60: CharacterCategory.CONTROL,  # '\x14'
    61: CharacterCategory.CONTROL,  # '\x15'
    62: CharacterCategory.CONTROL,  # '\x9e'
    63: CharacterCategory.CONTROL,  # '\x1a'
    64: CharacterCategory.CONTROL,  # ' '
    65: CharacterCategory.CONTROL,  # '\xa0'
    66: 53,  # 'â'
    67: 0,  # 'ä'
    68: 22,  # 'à'
    69: 0,  # 'á'
    70: 0,  # 'ã'
    71: 0,  # 'å'
    72: 51,  # 'ç'
    73: 0,  # 'ñ'
    74: CharacterCategory.SYMBOL,  # '¢'
    75: CharacterCategory.SYMBOL,  # '.'
    76: CharacterCategory.SYMBOL,  # '<'
    77: CharacterCategory.SYMBOL,  # '('
    78: CharacterCategory.SYMBOL,  # '+'
    79: CharacterCategory.SYMBOL,  # '|'
    80: CharacterCategory.SYMBOL,  # '&'
    81: 15,  # 'é'
    82: 41,  # 'ê'
    83: 67,  # 'ë'
    84: 28,  # 'è'
    85: 0,  # 'í'
    86: 57,  # 'î'
    87: 65,  # 'ï'
    88: 0,  # 'ì'
    89: 0,  # 'ß'
    90: CharacterCategory.SYMBOL,  # '!'
    91: CharacterCategory.SYMBOL,  # '$'
    92: CharacterCategory.SYMBOL,  # '*'
    93: CharacterCategory.SYMBOL,  # ')'
    94: CharacterCategory.SYMBOL,  # ';'
    95: CharacterCategory.SYMBOL,  # '¬'
    96: CharacterCategory.SYMBOL,  # '-'
    97: CharacterCategory.SYMBOL,  # '/'
    98: 73,  # 'Â'
    99: 0,  # 'Ä'
    100: 66,  # 'À'
    101: 0,  # 'Á'
    102: 0,  # 'Ã'
    103: 0,  # 'Å'
    104: 69,  # 'Ç'
    105: 0,  # 'Ñ'
    106: CharacterCategory.SYMBOL,  # '¦'
    107: CharacterCategory.SYMBOL,  # ','
    108: CharacterCategory.SYMBOL,  # '%'
    109: CharacterCategory.SYMBOL,  # '_'
    110: CharacterCategory.SYMBOL,  # '>'
    111: CharacterCategory.SYMBOL,  # '?'
    112: 0,  # 'ø'
    113: 58,  # 'É'
    114: 72,  # 'Ê'
    115: 80,  # 'Ë'
    116: 70,  # 'È'
    117: 0,  # 'Í'
    118: 71,  # 'Î'
    119: 77,  # 'Ï'
    120: 0,  # 'Ì'
    121: CharacterCategory.SYMBOL,  # '`'
    122: CharacterCategory.SYMBOL,  # ':'
    123: CharacterCategory.SYMBOL,  # '#'
    124: CharacterCategory.SYMBOL,  # '@'
    125: CharacterCategory.SYMBOL,  # "'"
    126: CharacterCategory.SYMBOL,  # '='
    127: CharacterCategory.SYMBOL,  # '"'
    128: 0,  # 'Ø'
    129: 3,  # 'a'
    130: 19,  # 'b'
    131: 12,  # 'c'
    132: 11,  # 'd'
    133: 1,  # 'e'
    134: 17,  # 'f'
    135: 18,  # 'g'
    136: 20,  # 'h'
    137: 5,  # 'i'
    138: CharacterCategory.SYMBOL,  # '«'
    139: CharacterCategory.SYMBOL,  # '»'
    140: 0,  # 'ð'
    141: 0,  # 'ý'
    142: 0,  # 'þ'
    143: CharacterCategory.SYMBOL,  # '±'
    144: CharacterCategory.SYMBOL,  # '°'
    145: 26,  # 'j'
    146: 44,  # 'k'
    147: 10,  # 'l'
    148: 14,  # 'm'
    149: 4,  # 'n'
    150: 8,  # 'o'
    151: 13,  # 'p'
    152: 21,  # 'q'
    153: 7,  # 'r'
    154: 0,  # 'ª'
    155: 0,  # 'º'
    156: 76,  # 'æ'
    157: CharacterCategory.SYMBOL,  # '¸'
    158: 83,  # 'Æ'
    159: CharacterCategory.SYMBOL,  # '¤'
    160: 0,  # 'µ'
    161: CharacterCategory.SYMBOL,  # '~'
    162: 2,  # 's'
    163: 6,  # 't'
    164: 9,  # 'u'
    165: 16,  # 'v'
    166: 49,  # 'w'
    167: 23,  # 'x'
    168: 27,  # 'y'
    169: 34,  # 'z'
    170: CharacterCategory.SYMBOL,  # '¡'
    171: CharacterCategory.SYMBOL,  # '¿'
    172: 0,  # 'Ð'
    173: 0,  # 'Ý'
    174: 0,  # 'Þ'
    175: CharacterCategory.SYMBOL,  # '®'
    176: CharacterCategory.SYMBOL,  # '^'
    177: CharacterCategory.SYMBOL,  # '£'
    178: CharacterCategory.SYMBOL,  # '¥'
    179: CharacterCategory.SYMBOL,  # '·'
    180: CharacterCategory.SYMBOL,  # '©'
    181: CharacterCategory.SYMBOL,  # '§'
    182: CharacterCategory.SYMBOL,  # '¶'
    183: CharacterCategory.DIGIT,  # '¼'
    184: CharacterCategory.DIGIT,  # '½'
    185: CharacterCategory.DIGIT,  # '¾'
    186: CharacterCategory.SYMBOL,  # '['
    187: CharacterCategory.SYMBOL,  # ']'
    188: CharacterCategory.SYMBOL,  # '¯'
    189: CharacterCategory.SYMBOL,  # '¨'
    190: CharacterCategory.SYMBOL,  # '´'
    191: CharacterCategory.SYMBOL,  # '×'
    192: CharacterCategory.SYMBOL,  # '{'
    193: 29,  # 'A'
    194: 40,  # 'B'
    195: 25,  # 'C'
    196: 35,  # 'D'
    197: 31,  # 'E'
    198: 42,  # 'F'
    199: 47,  # 'G'
    200: 50,  # 'H'
    201: 36,  # 'I'
    202: CharacterCategory.CONTROL,  # '\xad'
    203: 52,  # 'ô'
    204: 0,  # 'ö'
    205: 0,  # 'ò'
    206: 0,  # 'ó'
    207: 0,  # 'õ'
    208: CharacterCategory.SYMBOL,  # '}'
    209: 48,  # 'J'
    210: 56,  # 'K'
    211: 24,  # 'L'
    212: 33,  # 'M'
    213: 39,  # 'N'
    214: 43,  # 'O'
    215: 32,  # 'P'
    216: 55,  # 'Q'
    217: 38,  # 'R'
    218: CharacterCategory.DIGIT,  # '¹'
    219: 59,  # 'û'
    220: 68,  # 'ü'
    221: 62,  # 'ù'
    222: 0,  # 'ú'
    223: 81,  # 'ÿ'
    224: CharacterCategory.SYMBOL,  # '\\'
    225: CharacterCategory.SYMBOL,  # '÷'
    226: 30,  # 'S'
    227: 37,  # 'T'
    228: 46,  # 'U'
    229: 45,  # 'V'
    230: 54,  # 'W'
    231: 61,  # 'X'
    232: 60,  # 'Y'
    233: 63,  # 'Z'
    234: CharacterCategory.DIGIT,  # '²'
    235: 74,  # 'Ô'
    236: 0,  # 'Ö'
    237: 0,  # 'Ò'
    238: 0,  # 'Ó'
    239: 0,  # 'Õ'
    240: CharacterCategory.DIGIT,  # '0'
    241: CharacterCategory.DIGIT,  # '1'
    242: CharacterCategory.DIGIT,  # '2'
    243: CharacterCategory.DIGIT,  # '3'
    244: CharacterCategory.DIGIT,  # '4'
    245: CharacterCategory.DIGIT,  # '5'
    246: CharacterCategory.DIGIT,  # '6'
    247: CharacterCategory.DIGIT,  # '7'
    248: CharacterCategory.DIGIT,  # '8'
    249: CharacterCategory.DIGIT,  # '9'
    250: CharacterCategory.DIGIT,  # '³'
    251: 79,  # 'Û'
    252: 78,  # 'Ü'
    253: 82,  # 'Ù'
    254: 0,  # 'Ú'
    255: CharacterCategory.CONTROL,  # '\x9f'
}

CP037_FRENCH_MODEL = SingleByteCharSetModel(
    charset_name="CP037",
    language="French",
    char_to_order_map=CP037_FRENCH_CHAR_TO_ORDER,
    language_model=FRENCH_LANG_MODEL,
    typical_positive_ratio=0.9776429532774372,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzÀÂÆÇÈÉÊËÎÏÔÙÛÜàâæçèéêëîïôùûüÿŒœŸ",
)

CP437_FRENCH_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 29,  # 'A'
    66: 40,  # 'B'
    67: 25,  # 'C'
    68: 35,  # 'D'
    69: 31,  # 'E'
    70: 42,  # 'F'
    71: 47,  # 'G'
    72: 50,  # 'H'
    73: 36,  # 'I'
    74: 48,  # 'J'
    75: 56,  # 'K'
    76: 24,  # 'L'
    77: 33,  # 'M'
    78: 39,  # 'N'
    79: 43,  # 'O'
    80: 32,  # 'P'
    81: 55,  # 'Q'
    82: 38,  # 'R'
    83: 30,  # 'S'
    84: 37,  # 'T'
    85: 46,  # 'U'
    86: 45,  # 'V'
    87: 54,  # 'W'
    88: 61,  # 'X'
    89: 60,  # 'Y'
    90: 63,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 3,  # 'a'
    98: 19,  # 'b'
    99: 12,  # 'c'
    100: 11,  # 'd'
    101: 1,  # 'e'
    102: 17,  # 'f'
    103: 18,  # 'g'
    104: 20,  # 'h'
    105: 5,  # 'i'
    106: 26,  # 'j'
    107: 44,  # 'k'
    108: 10,  # 'l'
    109: 14,  # 'm'
    110: 4,  # 'n'
    111: 8,  # 'o'
    112: 13,  # 'p'
    113: 21,  # 'q'
    114: 7,  # 'r'
    115: 2,  # 's'
    116: 6,  # 't'
    117: 9,  # 'u'
    118: 16,  # 'v'
    119: 49,  # 'w'
    120: 23,  # 'x'
    121: 27,  # 'y'
    122: 34,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: 69,  # 'Ç'
    129: 68,  # 'ü'
    130: 15,  # 'é'
    131: 53,  # 'â'
    132: 0,  # 'ä'
    133: 22,  # 'à'
    134: 0,  # 'å'
    135: 51,  # 'ç'
    136: 41,  # 'ê'
    137: 67,  # 'ë'
    138: 28,  # 'è'
    139: 65,  # 'ï'
    140: 57,  # 'î'
    141: 0,  # 'ì'
    142: 0,  # 'Ä'
    143: 0,  # 'Å'
    144: 58,  # 'É'
    145: 76,  # 'æ'
    146: 83,  # 'Æ'
    147: 52,  # 'ô'
    148: 0,  # 'ö'
    149: 0,  # 'ò'
    150: 59,  # 'û'
    151: 62,  # 'ù'
    152: 81,  # 'ÿ'
    153: 0,  # 'Ö'
    154: 78,  # 'Ü'
    155: CharacterCategory.SYMBOL,  # '¢'
    156: CharacterCategory.SYMBOL,  # '£'
    157: CharacterCategory.SYMBOL,  # '¥'
    158: CharacterCategory.SYMBOL,  # '₧'
    159: 0,  # 'ƒ'
    160: 0,  # 'á'
    161: 0,  # 'í'
    162: 0,  # 'ó'
    163: 0,  # 'ú'
    164: 0,  # 'ñ'
    165: 0,  # 'Ñ'
    166: 0,  # 'ª'
    167: 0,  # 'º'
    168: CharacterCategory.SYMBOL,  # '¿'
    169: CharacterCategory.SYMBOL,  # '⌐'
    170: CharacterCategory.SYMBOL,  # '¬'
    171: CharacterCategory.DIGIT,  # '½'
    172: CharacterCategory.DIGIT,  # '¼'
    173: CharacterCategory.SYMBOL,  # '¡'
    174: CharacterCategory.SYMBOL,  # '«'
    175: CharacterCategory.SYMBOL,  # '»'
    176: CharacterCategory.SYMBOL,  # '░'
    177: CharacterCategory.SYMBOL,  # '▒'
    178: CharacterCategory.SYMBOL,  # '▓'
    179: CharacterCategory.SYMBOL,  # '│'
    180: CharacterCategory.SYMBOL,  # '┤'
    181: CharacterCategory.SYMBOL,  # '╡'
    182: CharacterCategory.SYMBOL,  # '╢'
    183: CharacterCategory.SYMBOL,  # '╖'
    184: CharacterCategory.SYMBOL,  # '╕'
    185: CharacterCategory.SYMBOL,  # '╣'
    186: CharacterCategory.SYMBOL,  # '║'
    187: CharacterCategory.SYMBOL,  # '╗'
    188: CharacterCategory.SYMBOL,  # '╝'
    189: CharacterCategory.SYMBOL,  # '╜'
    190: CharacterCategory.SYMBOL,  # '╛'
    191: CharacterCategory.SYMBOL,  # '┐'
    192: CharacterCategory.SYMBOL,  # '└'
    193: CharacterCategory.SYMBOL,  # '┴'
    194: CharacterCategory.SYMBOL,  # '┬'
    195: CharacterCategory.SYMBOL,  # '├'
    196: CharacterCategory.SYMBOL,  # '─'
    197: CharacterCategory.SYMBOL,  # '┼'
    198: CharacterCategory.SYMBOL,  # '╞'
    199: CharacterCategory.SYMBOL,  # '╟'
    200: CharacterCategory.SYMBOL,  # '╚'
    201: CharacterCategory.SYMBOL,  # '╔'
    202: CharacterCategory.SYMBOL,  # '╩'
    203: CharacterCategory.SYMBOL,  # '╦'
    204: CharacterCategory.SYMBOL,  # '╠'
    205: CharacterCategory.SYMBOL,  # '═'
    206: CharacterCategory.SYMBOL,  # '╬'
    207: CharacterCategory.SYMBOL,  # '╧'
    208: CharacterCategory.SYMBOL,  # '╨'
    209: CharacterCategory.SYMBOL,  # '╤'
    210: CharacterCategory.SYMBOL,  # '╥'
    211: CharacterCategory.SYMBOL,  # '╙'
    212: CharacterCategory.SYMBOL,  # '╘'
    213: CharacterCategory.SYMBOL,  # '╒'
    214: CharacterCategory.SYMBOL,  # '╓'
    215: CharacterCategory.SYMBOL,  # '╫'
    216: CharacterCategory.SYMBOL,  # '╪'
    217: CharacterCategory.SYMBOL,  # '┘'
    218: CharacterCategory.SYMBOL,  # '┌'
    219: CharacterCategory.SYMBOL,  # '█'
    220: CharacterCategory.SYMBOL,  # '▄'
    221: CharacterCategory.SYMBOL,  # '▌'
    222: CharacterCategory.SYMBOL,  # '▐'
    223: CharacterCategory.SYMBOL,  # '▀'
    224: 0,  # 'α'
    225: 0,  # 'ß'
    226: 0,  # 'Γ'
    227: 0,  # 'π'
    228: 0,  # 'Σ'
    229: 0,  # 'σ'
    230: 0,  # 'µ'
    231: 0,  # 'τ'
    232: 0,  # 'Φ'
    233: 0,  # 'Θ'
    234: 0,  # 'Ω'
    235: 0,  # 'δ'
    236: CharacterCategory.SYMBOL,  # '∞'
    237: 0,  # 'φ'
    238: 0,  # 'ε'
    239: CharacterCategory.SYMBOL,  # '∩'
    240: CharacterCategory.SYMBOL,  # '≡'
    241: CharacterCategory.SYMBOL,  # '±'
    242: CharacterCategory.SYMBOL,  # '≥'
    243: CharacterCategory.SYMBOL,  # '≤'
    244: CharacterCategory.SYMBOL,  # '⌠'
    245: CharacterCategory.SYMBOL,  # '⌡'
    246: CharacterCategory.SYMBOL,  # '÷'
    247: CharacterCategory.SYMBOL,  # '≈'
    248: CharacterCategory.SYMBOL,  # '°'
    249: CharacterCategory.SYMBOL,  # '∙'
    250: CharacterCategory.SYMBOL,  # '·'
    251: CharacterCategory.SYMBOL,  # '√'
    252: 0,  # 'ⁿ'
    253: CharacterCategory.DIGIT,  # '²'
    254: CharacterCategory.SYMBOL,  # '■'
    255: CharacterCategory.CONTROL,  # '\xa0'
}

CP437_FRENCH_MODEL = SingleByteCharSetModel(
    charset_name="CP437",
    language="French",
    char_to_order_map=CP437_FRENCH_CHAR_TO_ORDER,
    language_model=FRENCH_LANG_MODEL,
    typical_positive_ratio=0.9777012493146959,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzÀÂÆÇÈÉÊËÎÏÔÙÛÜàâæçèéêëîïôùûüÿŒœŸ",
)

CP500_FRENCH_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x9c'
    5: CharacterCategory.CONTROL,  # '\t'
    6: CharacterCategory.CONTROL,  # '\x86'
    7: CharacterCategory.CONTROL,  # '\x7f'
    8: CharacterCategory.CONTROL,  # '\x97'
    9: CharacterCategory.CONTROL,  # '\x8d'
    10: CharacterCategory.CONTROL,  # '\x8e'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x9d'
    21: CharacterCategory.CONTROL,  # '\x85'
    22: CharacterCategory.CONTROL,  # '\x08'
    23: CharacterCategory.CONTROL,  # '\x87'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x92'
    27: CharacterCategory.CONTROL,  # '\x8f'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # '\x80'
    33: CharacterCategory.CONTROL,  # '\x81'
    34: CharacterCategory.CONTROL,  # '\x82'
    35: CharacterCategory.CONTROL,  # '\x83'
    36: CharacterCategory.CONTROL,  # '\x84'
    37: CharacterCategory.LINE_BREAK,  # '\n'
    38: CharacterCategory.CONTROL,  # '\x17'
    39: CharacterCategory.CONTROL,  # '\x1b'
    40: CharacterCategory.CONTROL,  # '\x88'
    41: CharacterCategory.CONTROL,  # '\x89'
    42: CharacterCategory.CONTROL,  # '\x8a'
    43: CharacterCategory.CONTROL,  # '\x8b'
    44: CharacterCategory.CONTROL,  # '\x8c'
    45: CharacterCategory.CONTROL,  # '\x05'
    46: CharacterCategory.CONTROL,  # '\x06'
    47: CharacterCategory.CONTROL,  # '\x07'
    48: CharacterCategory.CONTROL,  # '\x90'
    49: CharacterCategory.CONTROL,  # '\x91'
    50: CharacterCategory.CONTROL,  # '\x16'
    51: CharacterCategory.CONTROL,  # '\x93'
    52: CharacterCategory.CONTROL,  # '\x94'
    53: CharacterCategory.CONTROL,  # '\x95'
    54: CharacterCategory.CONTROL,  # '\x96'
    55: CharacterCategory.CONTROL,  # '\x04'
    56: CharacterCategory.CONTROL,  # '\x98'
    57: CharacterCategory.CONTROL,  # '\x99'
    58: CharacterCategory.CONTROL,  # '\x9a'
    59: CharacterCategory.CONTROL,  # '\x9b'
    60: CharacterCategory.CONTROL,  # '\x14'
    61: CharacterCategory.CONTROL,  # '\x15'
    62: CharacterCategory.CONTROL,  # '\x9e'
    63: CharacterCategory.CONTROL,  # '\x1a'
    64: CharacterCategory.CONTROL,  # ' '
    65: CharacterCategory.CONTROL,  # '\xa0'
    66: 53,  # 'â'
    67: 0,  # 'ä'
    68: 22,  # 'à'
    69: 0,  # 'á'
    70: 0,  # 'ã'
    71: 0,  # 'å'
    72: 51,  # 'ç'
    73: 0,  # 'ñ'
    74: CharacterCategory.SYMBOL,  # '['
    75: CharacterCategory.SYMBOL,  # '.'
    76: CharacterCategory.SYMBOL,  # '<'
    77: CharacterCategory.SYMBOL,  # '('
    78: CharacterCategory.SYMBOL,  # '+'
    79: CharacterCategory.SYMBOL,  # '!'
    80: CharacterCategory.SYMBOL,  # '&'
    81: 15,  # 'é'
    82: 41,  # 'ê'
    83: 67,  # 'ë'
    84: 28,  # 'è'
    85: 0,  # 'í'
    86: 57,  # 'î'
    87: 65,  # 'ï'
    88: 0,  # 'ì'
    89: 0,  # 'ß'
    90: CharacterCategory.SYMBOL,  # ']'
    91: CharacterCategory.SYMBOL,  # '$'
    92: CharacterCategory.SYMBOL,  # '*'
    93: CharacterCategory.SYMBOL,  # ')'
    94: CharacterCategory.SYMBOL,  # ';'
    95: CharacterCategory.SYMBOL,  # '^'
    96: CharacterCategory.SYMBOL,  # '-'
    97: CharacterCategory.SYMBOL,  # '/'
    98: 73,  # 'Â'
    99: 0,  # 'Ä'
    100: 66,  # 'À'
    101: 0,  # 'Á'
    102: 0,  # 'Ã'
    103: 0,  # 'Å'
    104: 69,  # 'Ç'
    105: 0,  # 'Ñ'
    106: CharacterCategory.SYMBOL,  # '¦'
    107: CharacterCategory.SYMBOL,  # ','
    108: CharacterCategory.SYMBOL,  # '%'
    109: CharacterCategory.SYMBOL,  # '_'
    110: CharacterCategory.SYMBOL,  # '>'
    111: CharacterCategory.SYMBOL,  # '?'
    112: 0,  # 'ø'
    113: 58,  # 'É'
    114: 72,  # 'Ê'
    115: 80,  # 'Ë'
    116: 70,  # 'È'
    117: 0,  # 'Í'
    118: 71,  # 'Î'
    119: 77,  # 'Ï'
    120: 0,  # 'Ì'
    121: CharacterCategory.SYMBOL,  # '`'
    122: CharacterCategory.SYMBOL,  # ':'
    123: CharacterCategory.SYMBOL,  # '#'
    124: CharacterCategory.SYMBOL,  # '@'
    125: CharacterCategory.SYMBOL,  # "'"
    126: CharacterCategory.SYMBOL,  # '='
    127: CharacterCategory.SYMBOL,  # '"'
    128: 0,  # 'Ø'
    129: 3,  # 'a'
    130: 19,  # 'b'
    131: 12,  # 'c'
    132: 11,  # 'd'
    133: 1,  # 'e'
    134: 17,  # 'f'
    135: 18,  # 'g'
    136: 20,  # 'h'
    137: 5,  # 'i'
    138: CharacterCategory.SYMBOL,  # '«'
    139: CharacterCategory.SYMBOL,  # '»'
    140: 0,  # 'ð'
    141: 0,  # 'ý'
    142: 0,  # 'þ'
    143: CharacterCategory.SYMBOL,  # '±'
    144: CharacterCategory.SYMBOL,  # '°'
    145: 26,  # 'j'
    146: 44,  # 'k'
    147: 10,  # 'l'
    148: 14,  # 'm'
    149: 4,  # 'n'
    150: 8,  # 'o'
    151: 13,  # 'p'
    152: 21,  # 'q'
    153: 7,  # 'r'
    154: 0,  # 'ª'
    155: 0,  # 'º'
    156: 76,  # 'æ'
    157: CharacterCategory.SYMBOL,  # '¸'
    158: 83,  # 'Æ'
    159: CharacterCategory.SYMBOL,  # '¤'
    160: 0,  # 'µ'
    161: CharacterCategory.SYMBOL,  # '~'
    162: 2,  # 's'
    163: 6,  # 't'
    164: 9,  # 'u'
    165: 16,  # 'v'
    166: 49,  # 'w'
    167: 23,  # 'x'
    168: 27,  # 'y'
    169: 34,  # 'z'
    170: CharacterCategory.SYMBOL,  # '¡'
    171: CharacterCategory.SYMBOL,  # '¿'
    172: 0,  # 'Ð'
    173: 0,  # 'Ý'
    174: 0,  # 'Þ'
    175: CharacterCategory.SYMBOL,  # '®'
    176: CharacterCategory.SYMBOL,  # '¢'
    177: CharacterCategory.SYMBOL,  # '£'
    178: CharacterCategory.SYMBOL,  # '¥'
    179: CharacterCategory.SYMBOL,  # '·'
    180: CharacterCategory.SYMBOL,  # '©'
    181: CharacterCategory.SYMBOL,  # '§'
    182: CharacterCategory.SYMBOL,  # '¶'
    183: CharacterCategory.DIGIT,  # '¼'
    184: CharacterCategory.DIGIT,  # '½'
    185: CharacterCategory.DIGIT,  # '¾'
    186: CharacterCategory.SYMBOL,  # '¬'
    187: CharacterCategory.SYMBOL,  # '|'
    188: CharacterCategory.SYMBOL,  # '¯'
    189: CharacterCategory.SYMBOL,  # '¨'
    190: CharacterCategory.SYMBOL,  # '´'
    191: CharacterCategory.SYMBOL,  # '×'
    192: CharacterCategory.SYMBOL,  # '{'
    193: 29,  # 'A'
    194: 40,  # 'B'
    195: 25,  # 'C'
    196: 35,  # 'D'
    197: 31,  # 'E'
    198: 42,  # 'F'
    199: 47,  # 'G'
    200: 50,  # 'H'
    201: 36,  # 'I'
    202: CharacterCategory.CONTROL,  # '\xad'
    203: 52,  # 'ô'
    204: 0,  # 'ö'
    205: 0,  # 'ò'
    206: 0,  # 'ó'
    207: 0,  # 'õ'
    208: CharacterCategory.SYMBOL,  # '}'
    209: 48,  # 'J'
    210: 56,  # 'K'
    211: 24,  # 'L'
    212: 33,  # 'M'
    213: 39,  # 'N'
    214: 43,  # 'O'
    215: 32,  # 'P'
    216: 55,  # 'Q'
    217: 38,  # 'R'
    218: CharacterCategory.DIGIT,  # '¹'
    219: 59,  # 'û'
    220: 68,  # 'ü'
    221: 62,  # 'ù'
    222: 0,  # 'ú'
    223: 81,  # 'ÿ'
    224: CharacterCategory.SYMBOL,  # '\\'
    225: CharacterCategory.SYMBOL,  # '÷'
    226: 30,  # 'S'
    227: 37,  # 'T'
    228: 46,  # 'U'
    229: 45,  # 'V'
    230: 54,  # 'W'
    231: 61,  # 'X'
    232: 60,  # 'Y'
    233: 63,  # 'Z'
    234: CharacterCategory.DIGIT,  # '²'
    235: 74,  # 'Ô'
    236: 0,  # 'Ö'
    237: 0,  # 'Ò'
    238: 0,  # 'Ó'
    239: 0,  # 'Õ'
    240: CharacterCategory.DIGIT,  # '0'
    241: CharacterCategory.DIGIT,  # '1'
    242: CharacterCategory.DIGIT,  # '2'
    243: CharacterCategory.DIGIT,  # '3'
    244: CharacterCategory.DIGIT,  # '4'
    245: CharacterCategory.DIGIT,  # '5'
    246: CharacterCategory.DIGIT,  # '6'
    247: CharacterCategory.DIGIT,  # '7'
    248: CharacterCategory.DIGIT,  # '8'
    249: CharacterCategory.DIGIT,  # '9'
    250: CharacterCategory.DIGIT,  # '³'
    251: 79,  # 'Û'
    252: 78,  # 'Ü'
    253: 82,  # 'Ù'
    254: 0,  # 'Ú'
    255: CharacterCategory.CONTROL,  # '\x9f'
}

CP500_FRENCH_MODEL = SingleByteCharSetModel(
    charset_name="CP500",
    language="French",
    char_to_order_map=CP500_FRENCH_CHAR_TO_ORDER,
    language_model=FRENCH_LANG_MODEL,
    typical_positive_ratio=0.9776429532774372,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzÀÂÆÇÈÉÊËÎÏÔÙÛÜàâæçèéêëîïôùûüÿŒœŸ",
)

CP850_FRENCH_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 29,  # 'A'
    66: 40,  # 'B'
    67: 25,  # 'C'
    68: 35,  # 'D'
    69: 31,  # 'E'
    70: 42,  # 'F'
    71: 47,  # 'G'
    72: 50,  # 'H'
    73: 36,  # 'I'
    74: 48,  # 'J'
    75: 56,  # 'K'
    76: 24,  # 'L'
    77: 33,  # 'M'
    78: 39,  # 'N'
    79: 43,  # 'O'
    80: 32,  # 'P'
    81: 55,  # 'Q'
    82: 38,  # 'R'
    83: 30,  # 'S'
    84: 37,  # 'T'
    85: 46,  # 'U'
    86: 45,  # 'V'
    87: 54,  # 'W'
    88: 61,  # 'X'
    89: 60,  # 'Y'
    90: 63,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 3,  # 'a'
    98: 19,  # 'b'
    99: 12,  # 'c'
    100: 11,  # 'd'
    101: 1,  # 'e'
    102: 17,  # 'f'
    103: 18,  # 'g'
    104: 20,  # 'h'
    105: 5,  # 'i'
    106: 26,  # 'j'
    107: 44,  # 'k'
    108: 10,  # 'l'
    109: 14,  # 'm'
    110: 4,  # 'n'
    111: 8,  # 'o'
    112: 13,  # 'p'
    113: 21,  # 'q'
    114: 7,  # 'r'
    115: 2,  # 's'
    116: 6,  # 't'
    117: 9,  # 'u'
    118: 16,  # 'v'
    119: 49,  # 'w'
    120: 23,  # 'x'
    121: 27,  # 'y'
    122: 34,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: 69,  # 'Ç'
    129: 68,  # 'ü'
    130: 15,  # 'é'
    131: 53,  # 'â'
    132: 0,  # 'ä'
    133: 22,  # 'à'
    134: 0,  # 'å'
    135: 51,  # 'ç'
    136: 41,  # 'ê'
    137: 67,  # 'ë'
    138: 28,  # 'è'
    139: 65,  # 'ï'
    140: 57,  # 'î'
    141: 0,  # 'ì'
    142: 0,  # 'Ä'
    143: 0,  # 'Å'
    144: 58,  # 'É'
    145: 76,  # 'æ'
    146: 83,  # 'Æ'
    147: 52,  # 'ô'
    148: 0,  # 'ö'
    149: 0,  # 'ò'
    150: 59,  # 'û'
    151: 62,  # 'ù'
    152: 81,  # 'ÿ'
    153: 0,  # 'Ö'
    154: 78,  # 'Ü'
    155: 0,  # 'ø'
    156: CharacterCategory.SYMBOL,  # '£'
    157: 0,  # 'Ø'
    158: CharacterCategory.SYMBOL,  # '×'
    159: 0,  # 'ƒ'
    160: 0,  # 'á'
    161: 0,  # 'í'
    162: 0,  # 'ó'
    163: 0,  # 'ú'
    164: 0,  # 'ñ'
    165: 0,  # 'Ñ'
    166: 0,  # 'ª'
    167: 0,  # 'º'
    168: CharacterCategory.SYMBOL,  # '¿'
    169: CharacterCategory.SYMBOL,  # '®'
    170: CharacterCategory.SYMBOL,  # '¬'
    171: CharacterCategory.DIGIT,  # '½'
    172: CharacterCategory.DIGIT,  # '¼'
    173: CharacterCategory.SYMBOL,  # '¡'
    174: CharacterCategory.SYMBOL,  # '«'
    175: CharacterCategory.SYMBOL,  # '»'
    176: CharacterCategory.SYMBOL,  # '░'
    177: CharacterCategory.SYMBOL,  # '▒'
    178: CharacterCategory.SYMBOL,  # '▓'
    179: CharacterCategory.SYMBOL,  # '│'
    180: CharacterCategory.SYMBOL,  # '┤'
    181: 0,  # 'Á'
    182: 73,  # 'Â'
    183: 66,  # 'À'
    184: CharacterCategory.SYMBOL,  # '©'
    185: CharacterCategory.SYMBOL,  # '╣'
    186: CharacterCategory.SYMBOL,  # '║'
    187: CharacterCategory.SYMBOL,  # '╗'
    188: CharacterCategory.SYMBOL,  # '╝'
    189: CharacterCategory.SYMBOL,  # '¢'
    190: CharacterCategory.SYMBOL,  # '¥'
    191: CharacterCategory.SYMBOL,  # '┐'
    192: CharacterCategory.SYMBOL,  # '└'
    193: CharacterCategory.SYMBOL,  # '┴'
    194: CharacterCategory.SYMBOL,  # '┬'
    195: CharacterCategory.SYMBOL,  # '├'
    196: CharacterCategory.SYMBOL,  # '─'
    197: CharacterCategory.SYMBOL,  # '┼'
    198: 0,  # 'ã'
    199: 0,  # 'Ã'
    200: CharacterCategory.SYMBOL,  # '╚'
    201: CharacterCategory.SYMBOL,  # '╔'
    202: CharacterCategory.SYMBOL,  # '╩'
    203: CharacterCategory.SYMBOL,  # '╦'
    204: CharacterCategory.SYMBOL,  # '╠'
    205: CharacterCategory.SYMBOL,  # '═'
    206: CharacterCategory.SYMBOL,  # '╬'
    207: CharacterCategory.SYMBOL,  # '¤'
    208: 0,  # 'ð'
    209: 0,  # 'Ð'
    210: 72,  # 'Ê'
    211: 80,  # 'Ë'
    212: 70,  # 'È'
    213: 0,  # 'ı'
    214: 0,  # 'Í'
    215: 71,  # 'Î'
    216: 77,  # 'Ï'
    217: CharacterCategory.SYMBOL,  # '┘'
    218: CharacterCategory.SYMBOL,  # '┌'
    219: CharacterCategory.SYMBOL,  # '█'
    220: CharacterCategory.SYMBOL,  # '▄'
    221: CharacterCategory.SYMBOL,  # '¦'
    222: 0,  # 'Ì'
    223: CharacterCategory.SYMBOL,  # '▀'
    224: 0,  # 'Ó'
    225: 0,  # 'ß'
    226: 74,  # 'Ô'
    227: 0,  # 'Ò'
    228: 0,  # 'õ'
    229: 0,  # 'Õ'
    230: 0,  # 'µ'
    231: 0,  # 'þ'
    232: 0,  # 'Þ'
    233: 0,  # 'Ú'
    234: 79,  # 'Û'
    235: 82,  # 'Ù'
    236: 0,  # 'ý'
    237: 0,  # 'Ý'
    238: CharacterCategory.SYMBOL,  # '¯'
    239: CharacterCategory.SYMBOL,  # '´'
    240: CharacterCategory.CONTROL,  # '\xad'
    241: CharacterCategory.SYMBOL,  # '±'
    242: CharacterCategory.SYMBOL,  # '‗'
    243: CharacterCategory.DIGIT,  # '¾'
    244: CharacterCategory.SYMBOL,  # '¶'
    245: CharacterCategory.SYMBOL,  # '§'
    246: CharacterCategory.SYMBOL,  # '÷'
    247: CharacterCategory.SYMBOL,  # '¸'
    248: CharacterCategory.SYMBOL,  # '°'
    249: CharacterCategory.SYMBOL,  # '¨'
    250: CharacterCategory.SYMBOL,  # '·'
    251: CharacterCategory.DIGIT,  # '¹'
    252: CharacterCategory.DIGIT,  # '³'
    253: CharacterCategory.DIGIT,  # '²'
    254: CharacterCategory.SYMBOL,  # '■'
    255: CharacterCategory.CONTROL,  # '\xa0'
}

CP850_FRENCH_MODEL = SingleByteCharSetModel(
    charset_name="CP850",
    language="French",
    char_to_order_map=CP850_FRENCH_CHAR_TO_ORDER,
    language_model=FRENCH_LANG_MODEL,
    typical_positive_ratio=0.9776429532774372,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzÀÂÆÇÈÉÊËÎÏÔÙÛÜàâæçèéêëîïôùûüÿŒœŸ",
)

CP858_FRENCH_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 29,  # 'A'
    66: 40,  # 'B'
    67: 25,  # 'C'
    68: 35,  # 'D'
    69: 31,  # 'E'
    70: 42,  # 'F'
    71: 47,  # 'G'
    72: 50,  # 'H'
    73: 36,  # 'I'
    74: 48,  # 'J'
    75: 56,  # 'K'
    76: 24,  # 'L'
    77: 33,  # 'M'
    78: 39,  # 'N'
    79: 43,  # 'O'
    80: 32,  # 'P'
    81: 55,  # 'Q'
    82: 38,  # 'R'
    83: 30,  # 'S'
    84: 37,  # 'T'
    85: 46,  # 'U'
    86: 45,  # 'V'
    87: 54,  # 'W'
    88: 61,  # 'X'
    89: 60,  # 'Y'
    90: 63,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 3,  # 'a'
    98: 19,  # 'b'
    99: 12,  # 'c'
    100: 11,  # 'd'
    101: 1,  # 'e'
    102: 17,  # 'f'
    103: 18,  # 'g'
    104: 20,  # 'h'
    105: 5,  # 'i'
    106: 26,  # 'j'
    107: 44,  # 'k'
    108: 10,  # 'l'
    109: 14,  # 'm'
    110: 4,  # 'n'
    111: 8,  # 'o'
    112: 13,  # 'p'
    113: 21,  # 'q'
    114: 7,  # 'r'
    115: 2,  # 's'
    116: 6,  # 't'
    117: 9,  # 'u'
    118: 16,  # 'v'
    119: 49,  # 'w'
    120: 23,  # 'x'
    121: 27,  # 'y'
    122: 34,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: 69,  # 'Ç'
    129: 68,  # 'ü'
    130: 15,  # 'é'
    131: 53,  # 'â'
    132: 0,  # 'ä'
    133: 22,  # 'à'
    134: 0,  # 'å'
    135: 51,  # 'ç'
    136: 41,  # 'ê'
    137: 67,  # 'ë'
    138: 28,  # 'è'
    139: 65,  # 'ï'
    140: 57,  # 'î'
    141: 0,  # 'ì'
    142: 0,  # 'Ä'
    143: 0,  # 'Å'
    144: 58,  # 'É'
    145: 76,  # 'æ'
    146: 83,  # 'Æ'
    147: 52,  # 'ô'
    148: 0,  # 'ö'
    149: 0,  # 'ò'
    150: 59,  # 'û'
    151: 62,  # 'ù'
    152: 81,  # 'ÿ'
    153: 0,  # 'Ö'
    154: 78,  # 'Ü'
    155: 0,  # 'ø'
    156: CharacterCategory.SYMBOL,  # '£'
    157: 0,  # 'Ø'
    158: CharacterCategory.SYMBOL,  # '×'
    159: 0,  # 'ƒ'
    160: 0,  # 'á'
    161: 0,  # 'í'
    162: 0,  # 'ó'
    163: 0,  # 'ú'
    164: 0,  # 'ñ'
    165: 0,  # 'Ñ'
    166: 0,  # 'ª'
    167: 0,  # 'º'
    168: CharacterCategory.SYMBOL,  # '¿'
    169: CharacterCategory.SYMBOL,  # '®'
    170: CharacterCategory.SYMBOL,  # '¬'
    171: CharacterCategory.DIGIT,  # '½'
    172: CharacterCategory.DIGIT,  # '¼'
    173: CharacterCategory.SYMBOL,  # '¡'
    174: CharacterCategory.SYMBOL,  # '«'
    175: CharacterCategory.SYMBOL,  # '»'
    176: CharacterCategory.SYMBOL,  # '░'
    177: CharacterCategory.SYMBOL,  # '▒'
    178: CharacterCategory.SYMBOL,  # '▓'
    179: CharacterCategory.SYMBOL,  # '│'
    180: CharacterCategory.SYMBOL,  # '┤'
    181: 0,  # 'Á'
    182: 73,  # 'Â'
    183: 66,  # 'À'
    184: CharacterCategory.SYMBOL,  # '©'
    185: CharacterCategory.SYMBOL,  # '╣'
    186: CharacterCategory.SYMBOL,  # '║'
    187: CharacterCategory.SYMBOL,  # '╗'
    188: CharacterCategory.SYMBOL,  # '╝'
    189: CharacterCategory.SYMBOL,  # '¢'
    190: CharacterCategory.SYMBOL,  # '¥'
    191: CharacterCategory.SYMBOL,  # '┐'
    192: CharacterCategory.SYMBOL,  # '└'
    193: CharacterCategory.SYMBOL,  # '┴'
    194: CharacterCategory.SYMBOL,  # '┬'
    195: CharacterCategory.SYMBOL,  # '├'
    196: CharacterCategory.SYMBOL,  # '─'
    197: CharacterCategory.SYMBOL,  # '┼'
    198: 0,  # 'ã'
    199: 0,  # 'Ã'
    200: CharacterCategory.SYMBOL,  # '╚'
    201: CharacterCategory.SYMBOL,  # '╔'
    202: CharacterCategory.SYMBOL,  # '╩'
    203: CharacterCategory.SYMBOL,  # '╦'
    204: CharacterCategory.SYMBOL,  # '╠'
    205: CharacterCategory.SYMBOL,  # '═'
    206: CharacterCategory.SYMBOL,  # '╬'
    207: CharacterCategory.SYMBOL,  # '¤'
    208: 0,  # 'ð'
    209: 0,  # 'Ð'
    210: 72,  # 'Ê'
    211: 80,  # 'Ë'
    212: 70,  # 'È'
    213: CharacterCategory.SYMBOL,  # '€'
    214: 0,  # 'Í'
    215: 71,  # 'Î'
    216: 77,  # 'Ï'
    217: CharacterCategory.SYMBOL,  # '┘'
    218: CharacterCategory.SYMBOL,  # '┌'
    219: CharacterCategory.SYMBOL,  # '█'
    220: CharacterCategory.SYMBOL,  # '▄'
    221: CharacterCategory.SYMBOL,  # '¦'
    222: 0,  # 'Ì'
    223: CharacterCategory.SYMBOL,  # '▀'
    224: 0,  # 'Ó'
    225: 0,  # 'ß'
    226: 74,  # 'Ô'
    227: 0,  # 'Ò'
    228: 0,  # 'õ'
    229: 0,  # 'Õ'
    230: 0,  # 'µ'
    231: 0,  # 'þ'
    232: 0,  # 'Þ'
    233: 0,  # 'Ú'
    234: 79,  # 'Û'
    235: 82,  # 'Ù'
    236: 0,  # 'ý'
    237: 0,  # 'Ý'
    238: CharacterCategory.SYMBOL,  # '¯'
    239: CharacterCategory.SYMBOL,  # '´'
    240: CharacterCategory.CONTROL,  # '\xad'
    241: CharacterCategory.SYMBOL,  # '±'
    242: CharacterCategory.SYMBOL,  # '‗'
    243: CharacterCategory.DIGIT,  # '¾'
    244: CharacterCategory.SYMBOL,  # '¶'
    245: CharacterCategory.SYMBOL,  # '§'
    246: CharacterCategory.SYMBOL,  # '÷'
    247: CharacterCategory.SYMBOL,  # '¸'
    248: CharacterCategory.SYMBOL,  # '°'
    249: CharacterCategory.SYMBOL,  # '¨'
    250: CharacterCategory.SYMBOL,  # '·'
    251: CharacterCategory.DIGIT,  # '¹'
    252: CharacterCategory.DIGIT,  # '³'
    253: CharacterCategory.DIGIT,  # '²'
    254: CharacterCategory.SYMBOL,  # '■'
    255: CharacterCategory.CONTROL,  # '\xa0'
}

CP858_FRENCH_MODEL = SingleByteCharSetModel(
    charset_name="CP858",
    language="French",
    char_to_order_map=CP858_FRENCH_CHAR_TO_ORDER,
    language_model=FRENCH_LANG_MODEL,
    typical_positive_ratio=0.9776429532774372,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzÀÂÆÇÈÉÊËÎÏÔÙÛÜàâæçèéêëîïôùûüÿŒœŸ",
)

CP863_FRENCH_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 29,  # 'A'
    66: 40,  # 'B'
    67: 25,  # 'C'
    68: 35,  # 'D'
    69: 31,  # 'E'
    70: 42,  # 'F'
    71: 47,  # 'G'
    72: 50,  # 'H'
    73: 36,  # 'I'
    74: 48,  # 'J'
    75: 56,  # 'K'
    76: 24,  # 'L'
    77: 33,  # 'M'
    78: 39,  # 'N'
    79: 43,  # 'O'
    80: 32,  # 'P'
    81: 55,  # 'Q'
    82: 38,  # 'R'
    83: 30,  # 'S'
    84: 37,  # 'T'
    85: 46,  # 'U'
    86: 45,  # 'V'
    87: 54,  # 'W'
    88: 61,  # 'X'
    89: 60,  # 'Y'
    90: 63,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 3,  # 'a'
    98: 19,  # 'b'
    99: 12,  # 'c'
    100: 11,  # 'd'
    101: 1,  # 'e'
    102: 17,  # 'f'
    103: 18,  # 'g'
    104: 20,  # 'h'
    105: 5,  # 'i'
    106: 26,  # 'j'
    107: 44,  # 'k'
    108: 10,  # 'l'
    109: 14,  # 'm'
    110: 4,  # 'n'
    111: 8,  # 'o'
    112: 13,  # 'p'
    113: 21,  # 'q'
    114: 7,  # 'r'
    115: 2,  # 's'
    116: 6,  # 't'
    117: 9,  # 'u'
    118: 16,  # 'v'
    119: 49,  # 'w'
    120: 23,  # 'x'
    121: 27,  # 'y'
    122: 34,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: 69,  # 'Ç'
    129: 68,  # 'ü'
    130: 15,  # 'é'
    131: 53,  # 'â'
    132: 73,  # 'Â'
    133: 22,  # 'à'
    134: CharacterCategory.SYMBOL,  # '¶'
    135: 51,  # 'ç'
    136: 41,  # 'ê'
    137: 67,  # 'ë'
    138: 28,  # 'è'
    139: 65,  # 'ï'
    140: 57,  # 'î'
    141: CharacterCategory.SYMBOL,  # '‗'
    142: 66,  # 'À'
    143: CharacterCategory.SYMBOL,  # '§'
    144: 58,  # 'É'
    145: 70,  # 'È'
    146: 72,  # 'Ê'
    147: 52,  # 'ô'
    148: 80,  # 'Ë'
    149: 77,  # 'Ï'
    150: 59,  # 'û'
    151: 62,  # 'ù'
    152: CharacterCategory.SYMBOL,  # '¤'
    153: 74,  # 'Ô'
    154: 78,  # 'Ü'
    155: CharacterCategory.SYMBOL,  # '¢'
    156: CharacterCategory.SYMBOL,  # '£'
    157: 82,  # 'Ù'
    158: 79,  # 'Û'
    159: 0,  # 'ƒ'
    160: CharacterCategory.SYMBOL,  # '¦'
    161: CharacterCategory.SYMBOL,  # '´'
    162: 0,  # 'ó'
    163: 0,  # 'ú'
    164: CharacterCategory.SYMBOL,  # '¨'
    165: CharacterCategory.SYMBOL,  # '¸'
    166: CharacterCategory.DIGIT,  # '³'
    167: CharacterCategory.SYMBOL,  # '¯'
    168: 71,  # 'Î'
    169: CharacterCategory.SYMBOL,  # '⌐'
    170: CharacterCategory.SYMBOL,  # '¬'
    171: CharacterCategory.DIGIT,  # '½'
    172: CharacterCategory.DIGIT,  # '¼'
    173: CharacterCategory.DIGIT,  # '¾'
    174: CharacterCategory.SYMBOL,  # '«'
    175: CharacterCategory.SYMBOL,  # '»'
    176: CharacterCategory.SYMBOL,  # '░'
    177: CharacterCategory.SYMBOL,  # '▒'
    178: CharacterCategory.SYMBOL,  # '▓'
    179: CharacterCategory.SYMBOL,  # '│'
    180: CharacterCategory.SYMBOL,  # '┤'
    181: CharacterCategory.SYMBOL,  # '╡'
    182: CharacterCategory.SYMBOL,  # '╢'
    183: CharacterCategory.SYMBOL,  # '╖'
    184: CharacterCategory.SYMBOL,  # '╕'
    185: CharacterCategory.SYMBOL,  # '╣'
    186: CharacterCategory.SYMBOL,  # '║'
    187: CharacterCategory.SYMBOL,  # '╗'
    188: CharacterCategory.SYMBOL,  # '╝'
    189: CharacterCategory.SYMBOL,  # '╜'
    190: CharacterCategory.SYMBOL,  # '╛'
    191: CharacterCategory.SYMBOL,  # '┐'
    192: CharacterCategory.SYMBOL,  # '└'
    193: CharacterCategory.SYMBOL,  # '┴'
    194: CharacterCategory.SYMBOL,  # '┬'
    195: CharacterCategory.SYMBOL,  # '├'
    196: CharacterCategory.SYMBOL,  # '─'
    197: CharacterCategory.SYMBOL,  # '┼'
    198: CharacterCategory.SYMBOL,  # '╞'
    199: CharacterCategory.SYMBOL,  # '╟'
    200: CharacterCategory.SYMBOL,  # '╚'
    201: CharacterCategory.SYMBOL,  # '╔'
    202: CharacterCategory.SYMBOL,  # '╩'
    203: CharacterCategory.SYMBOL,  # '╦'
    204: CharacterCategory.SYMBOL,  # '╠'
    205: CharacterCategory.SYMBOL,  # '═'
    206: CharacterCategory.SYMBOL,  # '╬'
    207: CharacterCategory.SYMBOL,  # '╧'
    208: CharacterCategory.SYMBOL,  # '╨'
    209: CharacterCategory.SYMBOL,  # '╤'
    210: CharacterCategory.SYMBOL,  # '╥'
    211: CharacterCategory.SYMBOL,  # '╙'
    212: CharacterCategory.SYMBOL,  # '╘'
    213: CharacterCategory.SYMBOL,  # '╒'
    214: CharacterCategory.SYMBOL,  # '╓'
    215: CharacterCategory.SYMBOL,  # '╫'
    216: CharacterCategory.SYMBOL,  # '╪'
    217: CharacterCategory.SYMBOL,  # '┘'
    218: CharacterCategory.SYMBOL,  # '┌'
    219: CharacterCategory.SYMBOL,  # '█'
    220: CharacterCategory.SYMBOL,  # '▄'
    221: CharacterCategory.SYMBOL,  # '▌'
    222: CharacterCategory.SYMBOL,  # '▐'
    223: CharacterCategory.SYMBOL,  # '▀'
    224: 0,  # 'α'
    225: 0,  # 'ß'
    226: 0,  # 'Γ'
    227: 0,  # 'π'
    228: 0,  # 'Σ'
    229: 0,  # 'σ'
    230: 0,  # 'µ'
    231: 0,  # 'τ'
    232: 0,  # 'Φ'
    233: 0,  # 'Θ'
    234: 0,  # 'Ω'
    235: 0,  # 'δ'
    236: CharacterCategory.SYMBOL,  # '∞'
    237: 0,  # 'φ'
    238: 0,  # 'ε'
    239: CharacterCategory.SYMBOL,  # '∩'
    240: CharacterCategory.SYMBOL,  # '≡'
    241: CharacterCategory.SYMBOL,  # '±'
    242: CharacterCategory.SYMBOL,  # '≥'
    243: CharacterCategory.SYMBOL,  # '≤'
    244: CharacterCategory.SYMBOL,  # '⌠'
    245: CharacterCategory.SYMBOL,  # '⌡'
    246: CharacterCategory.SYMBOL,  # '÷'
    247: CharacterCategory.SYMBOL,  # '≈'
    248: CharacterCategory.SYMBOL,  # '°'
    249: CharacterCategory.SYMBOL,  # '∙'
    250: CharacterCategory.SYMBOL,  # '·'
    251: CharacterCategory.SYMBOL,  # '√'
    252: 0,  # 'ⁿ'
    253: CharacterCategory.DIGIT,  # '²'
    254: CharacterCategory.SYMBOL,  # '■'
    255: CharacterCategory.CONTROL,  # '\xa0'
}

CP863_FRENCH_MODEL = SingleByteCharSetModel(
    charset_name="CP863",
    language="French",
    char_to_order_map=CP863_FRENCH_CHAR_TO_ORDER,
    language_model=FRENCH_LANG_MODEL,
    typical_positive_ratio=0.9776464415485024,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzÀÂÆÇÈÉÊËÎÏÔÙÛÜàâæçèéêëîïôùûüÿŒœŸ",
)

ISO_8859_1_FRENCH_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 29,  # 'A'
    66: 40,  # 'B'
    67: 25,  # 'C'
    68: 35,  # 'D'
    69: 31,  # 'E'
    70: 42,  # 'F'
    71: 47,  # 'G'
    72: 50,  # 'H'
    73: 36,  # 'I'
    74: 48,  # 'J'
    75: 56,  # 'K'
    76: 24,  # 'L'
    77: 33,  # 'M'
    78: 39,  # 'N'
    79: 43,  # 'O'
    80: 32,  # 'P'
    81: 55,  # 'Q'
    82: 38,  # 'R'
    83: 30,  # 'S'
    84: 37,  # 'T'
    85: 46,  # 'U'
    86: 45,  # 'V'
    87: 54,  # 'W'
    88: 61,  # 'X'
    89: 60,  # 'Y'
    90: 63,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 3,  # 'a'
    98: 19,  # 'b'
    99: 12,  # 'c'
    100: 11,  # 'd'
    101: 1,  # 'e'
    102: 17,  # 'f'
    103: 18,  # 'g'
    104: 20,  # 'h'
    105: 5,  # 'i'
    106: 26,  # 'j'
    107: 44,  # 'k'
    108: 10,  # 'l'
    109: 14,  # 'm'
    110: 4,  # 'n'
    111: 8,  # 'o'
    112: 13,  # 'p'
    113: 21,  # 'q'
    114: 7,  # 'r'
    115: 2,  # 's'
    116: 6,  # 't'
    117: 9,  # 'u'
    118: 16,  # 'v'
    119: 49,  # 'w'
    120: 23,  # 'x'
    121: 27,  # 'y'
    122: 34,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: CharacterCategory.CONTROL,  # '\x80'
    129: CharacterCategory.CONTROL,  # '\x81'
    130: CharacterCategory.CONTROL,  # '\x82'
    131: CharacterCategory.CONTROL,  # '\x83'
    132: CharacterCategory.CONTROL,  # '\x84'
    133: CharacterCategory.CONTROL,  # '\x85'
    134: CharacterCategory.CONTROL,  # '\x86'
    135: CharacterCategory.CONTROL,  # '\x87'
    136: CharacterCategory.CONTROL,  # '\x88'
    137: CharacterCategory.CONTROL,  # '\x89'
    138: CharacterCategory.CONTROL,  # '\x8a'
    139: CharacterCategory.CONTROL,  # '\x8b'
    140: CharacterCategory.CONTROL,  # '\x8c'
    141: CharacterCategory.CONTROL,  # '\x8d'
    142: CharacterCategory.CONTROL,  # '\x8e'
    143: CharacterCategory.CONTROL,  # '\x8f'
    144: CharacterCategory.CONTROL,  # '\x90'
    145: CharacterCategory.CONTROL,  # '\x91'
    146: CharacterCategory.CONTROL,  # '\x92'
    147: CharacterCategory.CONTROL,  # '\x93'
    148: CharacterCategory.CONTROL,  # '\x94'
    149: CharacterCategory.CONTROL,  # '\x95'
    150: CharacterCategory.CONTROL,  # '\x96'
    151: CharacterCategory.CONTROL,  # '\x97'
    152: CharacterCategory.CONTROL,  # '\x98'
    153: CharacterCategory.CONTROL,  # '\x99'
    154: CharacterCategory.CONTROL,  # '\x9a'
    155: CharacterCategory.CONTROL,  # '\x9b'
    156: CharacterCategory.CONTROL,  # '\x9c'
    157: CharacterCategory.CONTROL,  # '\x9d'
    158: CharacterCategory.CONTROL,  # '\x9e'
    159: CharacterCategory.CONTROL,  # '\x9f'
    160: CharacterCategory.CONTROL,  # '\xa0'
    161: CharacterCategory.SYMBOL,  # '¡'
    162: CharacterCategory.SYMBOL,  # '¢'
    163: CharacterCategory.SYMBOL,  # '£'
    164: CharacterCategory.SYMBOL,  # '¤'
    165: CharacterCategory.SYMBOL,  # '¥'
    166: CharacterCategory.SYMBOL,  # '¦'
    167: CharacterCategory.SYMBOL,  # '§'
    168: CharacterCategory.SYMBOL,  # '¨'
    169: CharacterCategory.SYMBOL,  # '©'
    170: 0,  # 'ª'
    171: CharacterCategory.SYMBOL,  # '«'
    172: CharacterCategory.SYMBOL,  # '¬'
    173: CharacterCategory.CONTROL,  # '\xad'
    174: CharacterCategory.SYMBOL,  # '®'
    175: CharacterCategory.SYMBOL,  # '¯'
    176: CharacterCategory.SYMBOL,  # '°'
    177: CharacterCategory.SYMBOL,  # '±'
    178: CharacterCategory.DIGIT,  # '²'
    179: CharacterCategory.DIGIT,  # '³'
    180: CharacterCategory.SYMBOL,  # '´'
    181: 0,  # 'µ'
    182: CharacterCategory.SYMBOL,  # '¶'
    183: CharacterCategory.SYMBOL,  # '·'
    184: CharacterCategory.SYMBOL,  # '¸'
    185: CharacterCategory.DIGIT,  # '¹'
    186: 0,  # 'º'
    187: CharacterCategory.SYMBOL,  # '»'
    188: CharacterCategory.DIGIT,  # '¼'
    189: CharacterCategory.DIGIT,  # '½'
    190: CharacterCategory.DIGIT,  # '¾'
    191: CharacterCategory.SYMBOL,  # '¿'
    192: 66,  # 'À'
    193: 0,  # 'Á'
    194: 73,  # 'Â'
    195: 0,  # 'Ã'
    196: 0,  # 'Ä'
    197: 0,  # 'Å'
    198: 83,  # 'Æ'
    199: 69,  # 'Ç'
    200: 70,  # 'È'
    201: 58,  # 'É'
    202: 72,  # 'Ê'
    203: 80,  # 'Ë'
    204: 0,  # 'Ì'
    205: 0,  # 'Í'
    206: 71,  # 'Î'
    207: 77,  # 'Ï'
    208: 0,  # 'Ð'
    209: 0,  # 'Ñ'
    210: 0,  # 'Ò'
    211: 0,  # 'Ó'
    212: 74,  # 'Ô'
    213: 0,  # 'Õ'
    214: 0,  # 'Ö'
    215: CharacterCategory.SYMBOL,  # '×'
    216: 0,  # 'Ø'
    217: 82,  # 'Ù'
    218: 0,  # 'Ú'
    219: 79,  # 'Û'
    220: 78,  # 'Ü'
    221: 0,  # 'Ý'
    222: 0,  # 'Þ'
    223: 0,  # 'ß'
    224: 22,  # 'à'
    225: 0,  # 'á'
    226: 53,  # 'â'
    227: 0,  # 'ã'
    228: 0,  # 'ä'
    229: 0,  # 'å'
    230: 76,  # 'æ'
    231: 51,  # 'ç'
    232: 28,  # 'è'
    233: 15,  # 'é'
    234: 41,  # 'ê'
    235: 67,  # 'ë'
    236: 0,  # 'ì'
    237: 0,  # 'í'
    238: 57,  # 'î'
    239: 65,  # 'ï'
    240: 0,  # 'ð'
    241: 0,  # 'ñ'
    242: 0,  # 'ò'
    243: 0,  # 'ó'
    244: 52,  # 'ô'
    245: 0,  # 'õ'
    246: 0,  # 'ö'
    247: CharacterCategory.SYMBOL,  # '÷'
    248: 0,  # 'ø'
    249: 62,  # 'ù'
    250: 0,  # 'ú'
    251: 59,  # 'û'
    252: 68,  # 'ü'
    253: 0,  # 'ý'
    254: 0,  # 'þ'
    255: 81,  # 'ÿ'
}

ISO_8859_1_FRENCH_MODEL = SingleByteCharSetModel(
    charset_name="ISO-8859-1",
    language="French",
    char_to_order_map=ISO_8859_1_FRENCH_CHAR_TO_ORDER,
    language_model=FRENCH_LANG_MODEL,
    typical_positive_ratio=0.9776429532774372,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzÀÂÆÇÈÉÊËÎÏÔÙÛÜàâæçèéêëîïôùûüÿŒœŸ",
)

ISO_8859_15_FRENCH_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 29,  # 'A'
    66: 40,  # 'B'
    67: 25,  # 'C'
    68: 35,  # 'D'
    69: 31,  # 'E'
    70: 42,  # 'F'
    71: 47,  # 'G'
    72: 50,  # 'H'
    73: 36,  # 'I'
    74: 48,  # 'J'
    75: 56,  # 'K'
    76: 24,  # 'L'
    77: 33,  # 'M'
    78: 39,  # 'N'
    79: 43,  # 'O'
    80: 32,  # 'P'
    81: 55,  # 'Q'
    82: 38,  # 'R'
    83: 30,  # 'S'
    84: 37,  # 'T'
    85: 46,  # 'U'
    86: 45,  # 'V'
    87: 54,  # 'W'
    88: 61,  # 'X'
    89: 60,  # 'Y'
    90: 63,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 3,  # 'a'
    98: 19,  # 'b'
    99: 12,  # 'c'
    100: 11,  # 'd'
    101: 1,  # 'e'
    102: 17,  # 'f'
    103: 18,  # 'g'
    104: 20,  # 'h'
    105: 5,  # 'i'
    106: 26,  # 'j'
    107: 44,  # 'k'
    108: 10,  # 'l'
    109: 14,  # 'm'
    110: 4,  # 'n'
    111: 8,  # 'o'
    112: 13,  # 'p'
    113: 21,  # 'q'
    114: 7,  # 'r'
    115: 2,  # 's'
    116: 6,  # 't'
    117: 9,  # 'u'
    118: 16,  # 'v'
    119: 49,  # 'w'
    120: 23,  # 'x'
    121: 27,  # 'y'
    122: 34,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: CharacterCategory.CONTROL,  # '\x80'
    129: CharacterCategory.CONTROL,  # '\x81'
    130: CharacterCategory.CONTROL,  # '\x82'
    131: CharacterCategory.CONTROL,  # '\x83'
    132: CharacterCategory.CONTROL,  # '\x84'
    133: CharacterCategory.CONTROL,  # '\x85'
    134: CharacterCategory.CONTROL,  # '\x86'
    135: CharacterCategory.CONTROL,  # '\x87'
    136: CharacterCategory.CONTROL,  # '\x88'
    137: CharacterCategory.CONTROL,  # '\x89'
    138: CharacterCategory.CONTROL,  # '\x8a'
    139: CharacterCategory.CONTROL,  # '\x8b'
    140: CharacterCategory.CONTROL,  # '\x8c'
    141: CharacterCategory.CONTROL,  # '\x8d'
    142: CharacterCategory.CONTROL,  # '\x8e'
    143: CharacterCategory.CONTROL,  # '\x8f'
    144: CharacterCategory.CONTROL,  # '\x90'
    145: CharacterCategory.CONTROL,  # '\x91'
    146: CharacterCategory.CONTROL,  # '\x92'
    147: CharacterCategory.CONTROL,  # '\x93'
    148: CharacterCategory.CONTROL,  # '\x94'
    149: CharacterCategory.CONTROL,  # '\x95'
    150: CharacterCategory.CONTROL,  # '\x96'
    151: CharacterCategory.CONTROL,  # '\x97'
    152: CharacterCategory.CONTROL,  # '\x98'
    153: CharacterCategory.CONTROL,  # '\x99'
    154: CharacterCategory.CONTROL,  # '\x9a'
    155: CharacterCategory.CONTROL,  # '\x9b'
    156: CharacterCategory.CONTROL,  # '\x9c'
    157: CharacterCategory.CONTROL,  # '\x9d'
    158: CharacterCategory.CONTROL,  # '\x9e'
    159: CharacterCategory.CONTROL,  # '\x9f'
    160: CharacterCategory.CONTROL,  # '\xa0'
    161: CharacterCategory.SYMBOL,  # '¡'
    162: CharacterCategory.SYMBOL,  # '¢'
    163: CharacterCategory.SYMBOL,  # '£'
    164: CharacterCategory.SYMBOL,  # '€'
    165: CharacterCategory.SYMBOL,  # '¥'
    166: 0,  # 'Š'
    167: CharacterCategory.SYMBOL,  # '§'
    168: 0,  # 'š'
    169: CharacterCategory.SYMBOL,  # '©'
    170: 0,  # 'ª'
    171: CharacterCategory.SYMBOL,  # '«'
    172: CharacterCategory.SYMBOL,  # '¬'
    173: CharacterCategory.CONTROL,  # '\xad'
    174: CharacterCategory.SYMBOL,  # '®'
    175: CharacterCategory.SYMBOL,  # '¯'
    176: CharacterCategory.SYMBOL,  # '°'
    177: CharacterCategory.SYMBOL,  # '±'
    178: CharacterCategory.DIGIT,  # '²'
    179: CharacterCategory.DIGIT,  # '³'
    180: 0,  # 'Ž'
    181: 0,  # 'µ'
    182: CharacterCategory.SYMBOL,  # '¶'
    183: CharacterCategory.SYMBOL,  # '·'
    184: 0,  # 'ž'
    185: CharacterCategory.DIGIT,  # '¹'
    186: 0,  # 'º'
    187: CharacterCategory.SYMBOL,  # '»'
    188: 75,  # 'Œ'
    189: 64,  # 'œ'
    190: 84,  # 'Ÿ'
    191: CharacterCategory.SYMBOL,  # '¿'
    192: 66,  # 'À'
    193: 0,  # 'Á'
    194: 73,  # 'Â'
    195: 0,  # 'Ã'
    196: 0,  # 'Ä'
    197: 0,  # 'Å'
    198: 83,  # 'Æ'
    199: 69,  # 'Ç'
    200: 70,  # 'È'
    201: 58,  # 'É'
    202: 72,  # 'Ê'
    203: 80,  # 'Ë'
    204: 0,  # 'Ì'
    205: 0,  # 'Í'
    206: 71,  # 'Î'
    207: 77,  # 'Ï'
    208: 0,  # 'Ð'
    209: 0,  # 'Ñ'
    210: 0,  # 'Ò'
    211: 0,  # 'Ó'
    212: 74,  # 'Ô'
    213: 0,  # 'Õ'
    214: 0,  # 'Ö'
    215: CharacterCategory.SYMBOL,  # '×'
    216: 0,  # 'Ø'
    217: 82,  # 'Ù'
    218: 0,  # 'Ú'
    219: 79,  # 'Û'
    220: 78,  # 'Ü'
    221: 0,  # 'Ý'
    222: 0,  # 'Þ'
    223: 0,  # 'ß'
    224: 22,  # 'à'
    225: 0,  # 'á'
    226: 53,  # 'â'
    227: 0,  # 'ã'
    228: 0,  # 'ä'
    229: 0,  # 'å'
    230: 76,  # 'æ'
    231: 51,  # 'ç'
    232: 28,  # 'è'
    233: 15,  # 'é'
    234: 41,  # 'ê'
    235: 67,  # 'ë'
    236: 0,  # 'ì'
    237: 0,  # 'í'
    238: 57,  # 'î'
    239: 65,  # 'ï'
    240: 0,  # 'ð'
    241: 0,  # 'ñ'
    242: 0,  # 'ò'
    243: 0,  # 'ó'
    244: 52,  # 'ô'
    245: 0,  # 'õ'
    246: 0,  # 'ö'
    247: CharacterCategory.SYMBOL,  # '÷'
    248: 0,  # 'ø'
    249: 62,  # 'ù'
    250: 0,  # 'ú'
    251: 59,  # 'û'
    252: 68,  # 'ü'
    253: 0,  # 'ý'
    254: 0,  # 'þ'
    255: 81,  # 'ÿ'
}

ISO_8859_15_FRENCH_MODEL = SingleByteCharSetModel(
    charset_name="ISO-8859-15",
    language="French",
    char_to_order_map=ISO_8859_15_FRENCH_CHAR_TO_ORDER,
    language_model=FRENCH_LANG_MODEL,
    typical_positive_ratio=0.97755643226728,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzÀÂÆÇÈÉÊËÎÏÔÙÛÜàâæçèéêëîïôùûüÿŒœŸ",
)

MACROMAN_FRENCH_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 29,  # 'A'
    66: 40,  # 'B'
    67: 25,  # 'C'
    68: 35,  # 'D'
    69: 31,  # 'E'
    70: 42,  # 'F'
    71: 47,  # 'G'
    72: 50,  # 'H'
    73: 36,  # 'I'
    74: 48,  # 'J'
    75: 56,  # 'K'
    76: 24,  # 'L'
    77: 33,  # 'M'
    78: 39,  # 'N'
    79: 43,  # 'O'
    80: 32,  # 'P'
    81: 55,  # 'Q'
    82: 38,  # 'R'
    83: 30,  # 'S'
    84: 37,  # 'T'
    85: 46,  # 'U'
    86: 45,  # 'V'
    87: 54,  # 'W'
    88: 61,  # 'X'
    89: 60,  # 'Y'
    90: 63,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 3,  # 'a'
    98: 19,  # 'b'
    99: 12,  # 'c'
    100: 11,  # 'd'
    101: 1,  # 'e'
    102: 17,  # 'f'
    103: 18,  # 'g'
    104: 20,  # 'h'
    105: 5,  # 'i'
    106: 26,  # 'j'
    107: 44,  # 'k'
    108: 10,  # 'l'
    109: 14,  # 'm'
    110: 4,  # 'n'
    111: 8,  # 'o'
    112: 13,  # 'p'
    113: 21,  # 'q'
    114: 7,  # 'r'
    115: 2,  # 's'
    116: 6,  # 't'
    117: 9,  # 'u'
    118: 16,  # 'v'
    119: 49,  # 'w'
    120: 23,  # 'x'
    121: 27,  # 'y'
    122: 34,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: 0,  # 'Ä'
    129: 0,  # 'Å'
    130: 69,  # 'Ç'
    131: 58,  # 'É'
    132: 0,  # 'Ñ'
    133: 0,  # 'Ö'
    134: 78,  # 'Ü'
    135: 0,  # 'á'
    136: 22,  # 'à'
    137: 53,  # 'â'
    138: 0,  # 'ä'
    139: 0,  # 'ã'
    140: 0,  # 'å'
    141: 51,  # 'ç'
    142: 15,  # 'é'
    143: 28,  # 'è'
    144: 41,  # 'ê'
    145: 67,  # 'ë'
    146: 0,  # 'í'
    147: 0,  # 'ì'
    148: 57,  # 'î'
    149: 65,  # 'ï'
    150: 0,  # 'ñ'
    151: 0,  # 'ó'
    152: 0,  # 'ò'
    153: 52,  # 'ô'
    154: 0,  # 'ö'
    155: 0,  # 'õ'
    156: 0,  # 'ú'
    157: 62,  # 'ù'
    158: 59,  # 'û'
    159: 68,  # 'ü'
    160: CharacterCategory.SYMBOL,  # '†'
    161: CharacterCategory.SYMBOL,  # '°'
    162: CharacterCategory.SYMBOL,  # '¢'
    163: CharacterCategory.SYMBOL,  # '£'
    164: CharacterCategory.SYMBOL,  # '§'
    165: CharacterCategory.SYMBOL,  # '•'
    166: CharacterCategory.SYMBOL,  # '¶'
    167: 0,  # 'ß'
    168: CharacterCategory.SYMBOL,  # '®'
    169: CharacterCategory.SYMBOL,  # '©'
    170: CharacterCategory.SYMBOL,  # '™'
    171: CharacterCategory.SYMBOL,  # '´'
    172: CharacterCategory.SYMBOL,  # '¨'
    173: CharacterCategory.SYMBOL,  # '≠'
    174: 83,  # 'Æ'
    175: 0,  # 'Ø'
    176: CharacterCategory.SYMBOL,  # '∞'
    177: CharacterCategory.SYMBOL,  # '±'
    178: CharacterCategory.SYMBOL,  # '≤'
    179: CharacterCategory.SYMBOL,  # '≥'
    180: CharacterCategory.SYMBOL,  # '¥'
    181: 0,  # 'µ'
    182: CharacterCategory.SYMBOL,  # '∂'
    183: CharacterCategory.SYMBOL,  # '∑'
    184: CharacterCategory.SYMBOL,  # '∏'
    185: 0,  # 'π'
    186: CharacterCategory.SYMBOL,  # '∫'
    187: 0,  # 'ª'
    188: 0,  # 'º'
    189: 0,  # 'Ω'
    190: 76,  # 'æ'
    191: 0,  # 'ø'
    192: CharacterCategory.SYMBOL,  # '¿'
    193: CharacterCategory.SYMBOL,  # '¡'
    194: CharacterCategory.SYMBOL,  # '¬'
    195: CharacterCategory.SYMBOL,  # '√'
    196: 0,  # 'ƒ'
    197: CharacterCategory.SYMBOL,  # '≈'
    198: CharacterCategory.SYMBOL,  # '∆'
    199: CharacterCategory.SYMBOL,  # '«'
    200: CharacterCategory.SYMBOL,  # '»'
    201: CharacterCategory.SYMBOL,  # '…'
    202: CharacterCategory.CONTROL,  # '\xa0'
    203: 66,  # 'À'
    204: 0,  # 'Ã'
    205: 0,  # 'Õ'
    206: 75,  # 'Œ'
    207: 64,  # 'œ'
    208: CharacterCategory.SYMBOL,  # '–'
    209: CharacterCategory.SYMBOL,  # '—'
    210: CharacterCategory.SYMBOL,  # '“'
    211: CharacterCategory.SYMBOL,  # '”'
    212: CharacterCategory.SYMBOL,  # '‘'
    213: CharacterCategory.SYMBOL,  # '’'
    214: CharacterCategory.SYMBOL,  # '÷'
    215: CharacterCategory.SYMBOL,  # '◊'
    216: 81,  # 'ÿ'
    217: 84,  # 'Ÿ'
    218: CharacterCategory.SYMBOL,  # '⁄'
    219: CharacterCategory.SYMBOL,  # '€'
    220: CharacterCategory.SYMBOL,  # '‹'
    221: CharacterCategory.SYMBOL,  # '›'
    222: 0,  # 'ﬁ'
    223: 0,  # 'ﬂ'
    224: CharacterCategory.SYMBOL,  # '‡'
    225: CharacterCategory.SYMBOL,  # '·'
    226: CharacterCategory.SYMBOL,  # '‚'
    227: CharacterCategory.SYMBOL,  # '„'
    228: CharacterCategory.SYMBOL,  # '‰'
    229: 73,  # 'Â'
    230: 72,  # 'Ê'
    231: 0,  # 'Á'
    232: 80,  # 'Ë'
    233: 70,  # 'È'
    234: 0,  # 'Í'
    235: 71,  # 'Î'
    236: 77,  # 'Ï'
    237: 0,  # 'Ì'
    238: 0,  # 'Ó'
    239: 74,  # 'Ô'
    240: CharacterCategory.CONTROL,  # '\uf8ff'
    241: 0,  # 'Ò'
    242: 0,  # 'Ú'
    243: 79,  # 'Û'
    244: 82,  # 'Ù'
    245: 0,  # 'ı'
    246: 0,  # 'ˆ'
    247: CharacterCategory.SYMBOL,  # '˜'
    248: CharacterCategory.SYMBOL,  # '¯'
    249: CharacterCategory.SYMBOL,  # '˘'
    250: CharacterCategory.SYMBOL,  # '˙'
    251: CharacterCategory.SYMBOL,  # '˚'
    252: CharacterCategory.SYMBOL,  # '¸'
    253: CharacterCategory.SYMBOL,  # '˝'
    254: CharacterCategory.SYMBOL,  # '˛'
    255: 0,  # 'ˇ'
}

MACROMAN_FRENCH_MODEL = SingleByteCharSetModel(
    charset_name="MacRoman",
    language="French",
    char_to_order_map=MACROMAN_FRENCH_CHAR_TO_ORDER,
    language_model=FRENCH_LANG_MODEL,
    typical_positive_ratio=0.97755643226728,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzÀÂÆÇÈÉÊËÎÏÔÙÛÜàâæçèéêëîïôùûüÿŒœŸ",
)

WINDOWS_1252_FRENCH_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 29,  # 'A'
    66: 40,  # 'B'
    67: 25,  # 'C'
    68: 35,  # 'D'
    69: 31,  # 'E'
    70: 42,  # 'F'
    71: 47,  # 'G'
    72: 50,  # 'H'
    73: 36,  # 'I'
    74: 48,  # 'J'
    75: 56,  # 'K'
    76: 24,  # 'L'
    77: 33,  # 'M'
    78: 39,  # 'N'
    79: 43,  # 'O'
    80: 32,  # 'P'
    81: 55,  # 'Q'
    82: 38,  # 'R'
    83: 30,  # 'S'
    84: 37,  # 'T'
    85: 46,  # 'U'
    86: 45,  # 'V'
    87: 54,  # 'W'
    88: 61,  # 'X'
    89: 60,  # 'Y'
    90: 63,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 3,  # 'a'
    98: 19,  # 'b'
    99: 12,  # 'c'
    100: 11,  # 'd'
    101: 1,  # 'e'
    102: 17,  # 'f'
    103: 18,  # 'g'
    104: 20,  # 'h'
    105: 5,  # 'i'
    106: 26,  # 'j'
    107: 44,  # 'k'
    108: 10,  # 'l'
    109: 14,  # 'm'
    110: 4,  # 'n'
    111: 8,  # 'o'
    112: 13,  # 'p'
    113: 21,  # 'q'
    114: 7,  # 'r'
    115: 2,  # 's'
    116: 6,  # 't'
    117: 9,  # 'u'
    118: 16,  # 'v'
    119: 49,  # 'w'
    120: 23,  # 'x'
    121: 27,  # 'y'
    122: 34,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: CharacterCategory.SYMBOL,  # '€'
    129: CharacterCategory.UNDEFINED,  # None
    130: CharacterCategory.SYMBOL,  # '‚'
    131: 0,  # 'ƒ'
    132: CharacterCategory.SYMBOL,  # '„'
    133: CharacterCategory.SYMBOL,  # '…'
    134: CharacterCategory.SYMBOL,  # '†'
    135: CharacterCategory.SYMBOL,  # '‡'
    136: 0,  # 'ˆ'
    137: CharacterCategory.SYMBOL,  # '‰'
    138: 0,  # 'Š'
    139: CharacterCategory.SYMBOL,  # '‹'
    140: 75,  # 'Œ'
    141: CharacterCategory.UNDEFINED,  # None
    142: 0,  # 'Ž'
    143: CharacterCategory.UNDEFINED,  # None
    144: CharacterCategory.UNDEFINED,  # None
    145: CharacterCategory.SYMBOL,  # '‘'
    146: CharacterCategory.SYMBOL,  # '’'
    147: CharacterCategory.SYMBOL,  # '“'
    148: CharacterCategory.SYMBOL,  # '”'
    149: CharacterCategory.SYMBOL,  # '•'
    150: CharacterCategory.SYMBOL,  # '–'
    151: CharacterCategory.SYMBOL,  # '—'
    152: CharacterCategory.SYMBOL,  # '˜'
    153: CharacterCategory.SYMBOL,  # '™'
    154: 0,  # 'š'
    155: CharacterCategory.SYMBOL,  # '›'
    156: 64,  # 'œ'
    157: CharacterCategory.UNDEFINED,  # None
    158: 0,  # 'ž'
    159: 84,  # 'Ÿ'
    160: CharacterCategory.CONTROL,  # '\xa0'
    161: CharacterCategory.SYMBOL,  # '¡'
    162: CharacterCategory.SYMBOL,  # '¢'
    163: CharacterCategory.SYMBOL,  # '£'
    164: CharacterCategory.SYMBOL,  # '¤'
    165: CharacterCategory.SYMBOL,  # '¥'
    166: CharacterCategory.SYMBOL,  # '¦'
    167: CharacterCategory.SYMBOL,  # '§'
    168: CharacterCategory.SYMBOL,  # '¨'
    169: CharacterCategory.SYMBOL,  # '©'
    170: 0,  # 'ª'
    171: CharacterCategory.SYMBOL,  # '«'
    172: CharacterCategory.SYMBOL,  # '¬'
    173: CharacterCategory.CONTROL,  # '\xad'
    174: CharacterCategory.SYMBOL,  # '®'
    175: CharacterCategory.SYMBOL,  # '¯'
    176: CharacterCategory.SYMBOL,  # '°'
    177: CharacterCategory.SYMBOL,  # '±'
    178: CharacterCategory.DIGIT,  # '²'
    179: CharacterCategory.DIGIT,  # '³'
    180: CharacterCategory.SYMBOL,  # '´'
    181: 0,  # 'µ'
    182: CharacterCategory.SYMBOL,  # '¶'
    183: CharacterCategory.SYMBOL,  # '·'
    184: CharacterCategory.SYMBOL,  # '¸'
    185: CharacterCategory.DIGIT,  # '¹'
    186: 0,  # 'º'
    187: CharacterCategory.SYMBOL,  # '»'
    188: CharacterCategory.DIGIT,  # '¼'
    189: CharacterCategory.DIGIT,  # '½'
    190: CharacterCategory.DIGIT,  # '¾'
    191: CharacterCategory.SYMBOL,  # '¿'
    192: 66,  # 'À'
    193: 0,  # 'Á'
    194: 73,  # 'Â'
    195: 0,  # 'Ã'
    196: 0,  # 'Ä'
    197: 0,  # 'Å'
    198: 83,  # 'Æ'
    199: 69,  # 'Ç'
    200: 70,  # 'È'
    201: 58,  # 'É'
    202: 72,  # 'Ê'
    203: 80,  # 'Ë'
    204: 0,  # 'Ì'
    205: 0,  # 'Í'
    206: 71,  # 'Î'
    207: 77,  # 'Ï'
    208: 0,  # 'Ð'
    209: 0,  # 'Ñ'
    210: 0,  # 'Ò'
    211: 0,  # 'Ó'
    212: 74,  # 'Ô'
    213: 0,  # 'Õ'
    214: 0,  # 'Ö'
    215: CharacterCategory.SYMBOL,  # '×'
    216: 0,  # 'Ø'
    217: 82,  # 'Ù'
    218: 0,  # 'Ú'
    219: 79,  # 'Û'
    220: 78,  # 'Ü'
    221: 0,  # 'Ý'
    222: 0,  # 'Þ'
    223: 0,  # 'ß'
    224: 22,  # 'à'
    225: 0,  # 'á'
    226: 53,  # 'â'
    227: 0,  # 'ã'
    228: 0,  # 'ä'
    229: 0,  # 'å'
    230: 76,  # 'æ'
    231: 51,  # 'ç'
    232: 28,  # 'è'
    233: 15,  # 'é'
    234: 41,  # 'ê'
    235: 67,  # 'ë'
    236: 0,  # 'ì'
    237: 0,  # 'í'
    238: 57,  # 'î'
    239: 65,  # 'ï'
    240: 0,  # 'ð'
    241: 0,  # 'ñ'
    242: 0,  # 'ò'
    243: 0,  # 'ó'
    244: 52,  # 'ô'
    245: 0,  # 'õ'
    246: 0,  # 'ö'
    247: CharacterCategory.SYMBOL,  # '÷'
    248: 0,  # 'ø'
    249: 62,  # 'ù'
    250: 0,  # 'ú'
    251: 59,  # 'û'
    252: 68,  # 'ü'
    253: 0,  # 'ý'
    254: 0,  # 'þ'
    255: 81,  # 'ÿ'
}

WINDOWS_1252_FRENCH_MODEL = SingleByteCharSetModel(
    charset_name="WINDOWS-1252",
    language="French",
    char_to_order_map=WINDOWS_1252_FRENCH_CHAR_TO_ORDER,
    language_model=FRENCH_LANG_MODEL,
    typical_positive_ratio=0.97755643226728,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzÀÂÆÇÈÉÊËÎÏÔÙÛÜàâæçèéêëîïôùûüÿŒœŸ",
)
