/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.block.session;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.util.Key;
import com.intellij.terminal.JBTerminalSystemSettingsProviderBase;
import com.intellij.terminal.TerminalColorPalette;
import com.intellij.terminal.TerminalExecutorServiceManagerImpl;
import com.jediterm.core.typeahead.Debouncer;
import com.jediterm.core.typeahead.TerminalTypeAheadManager;
import com.jediterm.core.typeahead.TypeAheadTerminalModel;
import com.jediterm.core.util.TermSize;
import com.jediterm.terminal.RequestOrigin;
import com.jediterm.terminal.Terminal;
import com.jediterm.terminal.TerminalDataStream;
import com.jediterm.terminal.TerminalDisplay;
import com.jediterm.terminal.TerminalExecutorServiceManager;
import com.jediterm.terminal.TerminalOutputStream;
import com.jediterm.terminal.TerminalStarter;
import com.jediterm.terminal.TtyBasedArrayDataStream;
import com.jediterm.terminal.TtyConnector;
import com.jediterm.terminal.model.JediTermDebouncerImpl;
import com.jediterm.terminal.model.JediTermTypeAheadModel;
import com.jediterm.terminal.model.JediTerminal;
import com.jediterm.terminal.model.StyleState;
import com.jediterm.terminal.model.TerminalTextBuffer;
import com.jediterm.terminal.ui.settings.SettingsProvider;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.terminal.TerminalUtil;
import org.jetbrains.plugins.terminal.block.output.TerminalAlarmManager;
import org.jetbrains.plugins.terminal.block.session.ModelUpdatingTerminalDisplay;
import org.jetbrains.plugins.terminal.block.session.ShellCommandExecutionManager;
import org.jetbrains.plugins.terminal.block.session.ShellCommandExecutionManagerImpl;
import org.jetbrains.plugins.terminal.block.session.ShellCommandListener;
import org.jetbrains.plugins.terminal.block.session.ShellCommandManager;
import org.jetbrains.plugins.terminal.block.session.TerminalModel;
import org.jetbrains.plugins.terminal.block.session.util.FutureTerminalOutputStream;
import org.jetbrains.plugins.terminal.util.ShellIntegration;
import org.jetbrains.plugins.terminal.util.TerminalUtilKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 A2\u00020\u0001:\u0001AB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u00102\u001a\u0002032\u0006\u00104\u001a\u000205J\u0016\u00106\u001a\u0002032\u0006\u00107\u001a\u0002012\u0006\u00108\u001a\u00020\u0001J\u000e\u00109\u001a\u0002032\u0006\u0010:\u001a\u00020;J\u0018\u0010<\u001a\u0002032\u0006\u0010=\u001a\u00020>2\b\b\u0002\u00108\u001a\u00020\u0001J\f\u0010?\u001a\u000203*\u000205H\u0002J\b\u0010@\u001a\u000203H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001e\u0010\u0014\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00160\u00158\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010!\u001a\u00020\"\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0011\u0010%\u001a\u00020&\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u0011\u0010)\u001a\u00020*\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\u000e\u0010-\u001a\u00020.X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010/\u001a\b\u0012\u0004\u0012\u00020100X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006B"}, d2={"Lorg/jetbrains/plugins/terminal/block/session/BlockTerminalSession;", "Lcom/intellij/openapi/Disposable;", "settings", "Lcom/intellij/terminal/JBTerminalSystemSettingsProviderBase;", "colorPalette", "Lcom/intellij/terminal/TerminalColorPalette;", "shellIntegration", "Lorg/jetbrains/plugins/terminal/util/ShellIntegration;", "<init>", "(Lcom/intellij/terminal/JBTerminalSystemSettingsProviderBase;Lcom/intellij/terminal/TerminalColorPalette;Lorg/jetbrains/plugins/terminal/util/ShellIntegration;)V", "getSettings", "()Lcom/intellij/terminal/JBTerminalSystemSettingsProviderBase;", "getColorPalette", "()Lcom/intellij/terminal/TerminalColorPalette;", "getShellIntegration", "()Lorg/jetbrains/plugins/terminal/util/ShellIntegration;", "model", "Lorg/jetbrains/plugins/terminal/block/session/TerminalModel;", "getModel", "()Lorg/jetbrains/plugins/terminal/block/session/TerminalModel;", "terminalStarterFuture", "Ljava/util/concurrent/CompletableFuture;", "Lcom/jediterm/terminal/TerminalStarter;", "getTerminalStarterFuture", "()Ljava/util/concurrent/CompletableFuture;", "terminalOutputStream", "Lcom/jediterm/terminal/TerminalOutputStream;", "getTerminalOutputStream", "()Lcom/jediterm/terminal/TerminalOutputStream;", "executorServiceManager", "Lcom/jediterm/terminal/TerminalExecutorServiceManager;", "textBuffer", "Lcom/jediterm/terminal/model/TerminalTextBuffer;", "controller", "Lcom/jediterm/terminal/model/JediTerminal;", "getController", "()Lcom/jediterm/terminal/model/JediTerminal;", "commandManager", "Lorg/jetbrains/plugins/terminal/block/session/ShellCommandManager;", "getCommandManager", "()Lorg/jetbrains/plugins/terminal/block/session/ShellCommandManager;", "commandExecutionManager", "Lorg/jetbrains/plugins/terminal/block/session/ShellCommandExecutionManager;", "getCommandExecutionManager", "()Lorg/jetbrains/plugins/terminal/block/session/ShellCommandExecutionManager;", "typeAheadManager", "Lcom/jediterm/core/typeahead/TerminalTypeAheadManager;", "terminationListeners", "", "Ljava/lang/Runnable;", "start", "", "ttyConnector", "Lcom/jediterm/terminal/TtyConnector;", "addTerminationCallback", "onTerminated", "parentDisposable", "postResize", "newSize", "Lcom/jediterm/core/util/TermSize;", "addCommandListener", "listener", "Lorg/jetbrains/plugins/terminal/block/session/ShellCommandListener;", "closeSafely", "dispose", "Companion", "intellij.terminal"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nBlockTerminalSession.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BlockTerminalSession.kt\norg/jetbrains/plugins/terminal/block/session/BlockTerminalSession\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,153:1\n23#2:154\n23#2:155\n23#2:156\n*S KotlinDebug\n*F\n+ 1 BlockTerminalSession.kt\norg/jetbrains/plugins/terminal/block/session/BlockTerminalSession\n*L\n131#1:154\n102#1:155\n93#1:156\n*E\n"})
public final class BlockTerminalSession
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JBTerminalSystemSettingsProviderBase settings;
    @NotNull
    private final TerminalColorPalette colorPalette;
    @NotNull
    private final ShellIntegration shellIntegration;
    @NotNull
    private final TerminalModel model;
    @ApiStatus.Internal
    @NotNull
    private final CompletableFuture<TerminalStarter> terminalStarterFuture;
    @NotNull
    private final TerminalOutputStream terminalOutputStream;
    @NotNull
    private final TerminalExecutorServiceManager executorServiceManager;
    @NotNull
    private final TerminalTextBuffer textBuffer;
    @NotNull
    private final JediTerminal controller;
    @NotNull
    private final ShellCommandManager commandManager;
    @NotNull
    private final ShellCommandExecutionManager commandExecutionManager;
    @NotNull
    private final TerminalTypeAheadManager typeAheadManager;
    @NotNull
    private final List<Runnable> terminationListeners;
    @NotNull
    private static final Key<BlockTerminalSession> KEY;
    @NotNull
    private static final DataKey<BlockTerminalSession> DATA_KEY;

    public BlockTerminalSession(@NotNull JBTerminalSystemSettingsProviderBase settings, @NotNull TerminalColorPalette colorPalette, @NotNull ShellIntegration shellIntegration) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)colorPalette, (String)"colorPalette");
        Intrinsics.checkNotNullParameter((Object)shellIntegration, (String)"shellIntegration");
        this.settings = settings;
        this.colorPalette = colorPalette;
        this.shellIntegration = shellIntegration;
        this.terminalStarterFuture = new CompletableFuture();
        this.terminalOutputStream = new FutureTerminalOutputStream(this.terminalStarterFuture);
        this.executorServiceManager = (TerminalExecutorServiceManager)new TerminalExecutorServiceManagerImpl();
        this.terminationListeners = new CopyOnWriteArrayList();
        StyleState styleState = new StyleState();
        this.textBuffer = new TerminalTextBuffer(80, 24, styleState, AdvancedSettings.Companion.getInt("terminal.buffer.max.lines.count"));
        this.model = new TerminalModel(this.textBuffer);
        TerminalAlarmManager alarmManager = new TerminalAlarmManager(this.settings);
        this.controller = new JediTerminal((TerminalDisplay)new ModelUpdatingTerminalDisplay(alarmManager, this.model, this.settings), this.textBuffer, styleState);
        this.commandManager = new ShellCommandManager(this);
        Terminal terminal = (Terminal)this.controller;
        Intrinsics.checkNotNull((Object)this, (String)"null cannot be cast to non-null type com.intellij.openapi.Disposable");
        this.commandExecutionManager = new ShellCommandExecutionManagerImpl(this, this.commandManager, this.shellIntegration, terminal, this);
        this.commandManager.addListener(alarmManager, this);
        JediTermTypeAheadModel typeAheadTerminalModel = new JediTermTypeAheadModel((Terminal)this.controller, this.textBuffer, (SettingsProvider)this.settings);
        this.typeAheadManager = new TerminalTypeAheadManager((TypeAheadTerminalModel)typeAheadTerminalModel);
        JediTermDebouncerImpl typeAheadDebouncer = new JediTermDebouncerImpl(() -> ((TerminalTypeAheadManager)this.typeAheadManager).debounce(), TerminalTypeAheadManager.MAX_TERMINAL_DELAY, this.executorServiceManager);
        this.typeAheadManager.setClearPredictionsDebouncer((Debouncer)typeAheadDebouncer);
    }

    @NotNull
    public final JBTerminalSystemSettingsProviderBase getSettings() {
        return this.settings;
    }

    @NotNull
    public final TerminalColorPalette getColorPalette() {
        return this.colorPalette;
    }

    @NotNull
    public final ShellIntegration getShellIntegration() {
        return this.shellIntegration;
    }

    @NotNull
    public final TerminalModel getModel() {
        return this.model;
    }

    @NotNull
    public final CompletableFuture<TerminalStarter> getTerminalStarterFuture() {
        return this.terminalStarterFuture;
    }

    @NotNull
    public final TerminalOutputStream getTerminalOutputStream() {
        return this.terminalOutputStream;
    }

    @NotNull
    public final JediTerminal getController() {
        return this.controller;
    }

    @NotNull
    public final ShellCommandManager getCommandManager() {
        return this.commandManager;
    }

    @NotNull
    public final ShellCommandExecutionManager getCommandExecutionManager() {
        return this.commandExecutionManager;
    }

    public final void start(@NotNull TtyConnector ttyConnector) {
        Intrinsics.checkNotNullParameter((Object)ttyConnector, (String)"ttyConnector");
        TerminalStarter terminalStarter = new TerminalStarter(this.controller, ttyConnector, (TerminalDataStream)new TtyBasedArrayDataStream(ttyConnector), this.typeAheadManager, this.executorServiceManager);
        this.terminalStarterFuture.complete(terminalStarter);
        this.executorServiceManager.getUnboundedExecutorService().submit(() -> BlockTerminalSession.start$lambda$0(terminalStarter, this, ttyConnector));
    }

    public final void addTerminationCallback(@NotNull Runnable onTerminated, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)onTerminated, (String)"onTerminated");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        TerminalUtil.addItem(this.terminationListeners, onTerminated, parentDisposable);
    }

    public final void postResize(@NotNull TermSize newSize) {
        Intrinsics.checkNotNullParameter((Object)newSize, (String)"newSize");
        this.terminalStarterFuture.thenAccept(arg_0 -> BlockTerminalSession.postResize$lambda$1(arg_0 -> BlockTerminalSession.postResize$lambda$0(newSize, this, arg_0), arg_0));
    }

    public final void addCommandListener(@NotNull ShellCommandListener listener2, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        this.commandManager.addListener(listener2, parentDisposable);
    }

    public static /* synthetic */ void addCommandListener$default(BlockTerminalSession blockTerminalSession, ShellCommandListener shellCommandListener, Disposable disposable, int n, Object object) {
        if ((n & 2) != 0) {
            disposable = blockTerminalSession;
        }
        blockTerminalSession.addCommandListener(shellCommandListener, disposable);
    }

    private final void closeSafely(TtyConnector $this$closeSafely) {
        try {
            $this$closeSafely.close();
        }
        catch (Throwable t) {
            TtyConnector $this$thisLogger$iv = $this$closeSafely;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(TtyConnector.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("Error closing TtyConnector", t);
        }
    }

    public void dispose() {
        this.terminalStarterFuture.complete(null);
        TerminalStarter terminalStarter = this.terminalStarterFuture.getNow(null);
        if (terminalStarter != null) {
            TerminalStarter it = terminalStarter;
            boolean bl = false;
            it.close();
            TtyConnector ttyConnector = it.getTtyConnector();
            Intrinsics.checkNotNullExpressionValue((Object)ttyConnector, (String)"getTtyConnector(...)");
            TerminalUtilKt.waitFor(ttyConnector, TerminalUtilKt.STOP_EMULATOR_TIMEOUT, (Function0<Unit>)((Function0)() -> BlockTerminalSession.dispose$lambda$0$0(it)));
        }
        this.executorServiceManager.shutdownWhenAllExecuted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void start$lambda$0(TerminalStarter $terminalStarter, BlockTerminalSession this$0, TtyConnector $ttyConnector) {
        try {
            $terminalStarter.start();
        }
        catch (Throwable t) {
            BlockTerminalSession $this$thisLogger$iv = this$0;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(BlockTerminalSession.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error(t);
        }
        finally {
            this$0.closeSafely($ttyConnector);
            for (Runnable terminationListener : this$0.terminationListeners) {
                try {
                    terminationListener.run();
                }
                catch (Throwable t) {
                    BlockTerminalSession $this$thisLogger$iv = this$0;
                    boolean $i$f$thisLogger = false;
                    Logger logger = Logger.getInstance(BlockTerminalSession.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                    logger.error("Unhandled exception in termination listener", t);
                }
            }
        }
    }

    private static final Unit postResize$lambda$0(TermSize $newSize, BlockTerminalSession this$0, TerminalStarter it) {
        if (it != null && ($newSize.getColumns() != this$0.model.getWidth() || $newSize.getRows() != this$0.model.getHeight())) {
            this$0.typeAheadManager.onResize();
            it.postResize($newSize, RequestOrigin.User);
        }
        return Unit.INSTANCE;
    }

    private static final void postResize$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit dispose$lambda$0$0(TerminalStarter $it) {
        $it.requestEmulatorStop();
        return Unit.INSTANCE;
    }

    static {
        Key key = Key.create((String)"TerminalSession");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        KEY = key;
        DATA_KEY = DataKey.Companion.create("TerminalSession");
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lorg/jetbrains/plugins/terminal/block/session/BlockTerminalSession$Companion;", "", "<init>", "()V", "KEY", "Lcom/intellij/openapi/util/Key;", "Lorg/jetbrains/plugins/terminal/block/session/BlockTerminalSession;", "getKEY", "()Lcom/intellij/openapi/util/Key;", "DATA_KEY", "Lcom/intellij/openapi/actionSystem/DataKey;", "getDATA_KEY", "()Lcom/intellij/openapi/actionSystem/DataKey;", "intellij.terminal"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Key<BlockTerminalSession> getKEY() {
            return KEY;
        }

        @NotNull
        public final DataKey<BlockTerminalSession> getDATA_KEY() {
            return DATA_KEY;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

