/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.validator.storage;

import com.intellij.internal.statistic.eventLog.EventLogBuild;
import com.intellij.internal.statistic.eventLog.validator.IEventGroupRules;
import com.intellij.internal.statistic.eventLog.validator.IEventGroupsFilterRules;
import com.intellij.internal.statistic.eventLog.validator.IGroupValidators;
import com.intellij.internal.statistic.eventLog.validator.rules.beans.EventGroupRules;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.RecorderDataValidationRule;
import com.intellij.internal.statistic.eventLog.validator.storage.ValidationTestRulesPersistedStorage;
import com.intellij.internal.statistic.eventLog.validator.storage.ValidationTestRulesStorageHolder;
import com.jetbrains.fus.reporting.MetadataStorage;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0007\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0002\u001f B\u001f\b\u0000\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u000eH\u0016J\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0096@\u00a2\u0006\u0002\u0010\u0013J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0006H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u001e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\f0\u001a2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\fH\u0016J\b\u0010\u001c\u001a\u00020\u0018H\u0016J\u000e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\f0\u001aH\u0016J\b\u0010\u001e\u001a\u00020\u0018H\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/intellij/internal/statistic/eventLog/validator/storage/CompositeValidationRulesStorage;", "Lcom/jetbrains/fus/reporting/MetadataStorage;", "Lcom/intellij/internal/statistic/eventLog/EventLogBuild;", "Lcom/intellij/internal/statistic/eventLog/validator/storage/ValidationTestRulesStorageHolder;", "myMetadataStorage", "myTestRulesStorage", "Lcom/intellij/internal/statistic/eventLog/validator/storage/ValidationTestRulesPersistedStorage;", "<init>", "(Lcom/jetbrains/fus/reporting/MetadataStorage;Lcom/intellij/internal/statistic/eventLog/validator/storage/ValidationTestRulesPersistedStorage;)V", "getGroupValidators", "Lcom/intellij/internal/statistic/eventLog/validator/IGroupValidators;", "groupId", "", "isUnreachable", "", "update", "Lkotlinx/coroutines/Job;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "(Lkotlinx/coroutines/CoroutineScope;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "reload", "", "getTestGroupStorage", "getClientDataRulesRevisions", "Lcom/intellij/internal/statistic/eventLog/validator/rules/impl/RecorderDataValidationRule;", "getFieldsToAnonymize", "", "eventId", "getIdsRulesRevisions", "getSkipAnonymizationIds", "getSystemDataRulesRevisions", "TestGroupValidators", "EmptyGroupValidators", "intellij.platform.statistics"})
@ApiStatus.Internal
public final class CompositeValidationRulesStorage
implements MetadataStorage<EventLogBuild>,
ValidationTestRulesStorageHolder {
    @NotNull
    private final MetadataStorage<EventLogBuild> myMetadataStorage;
    @NotNull
    private final ValidationTestRulesPersistedStorage myTestRulesStorage;

    public CompositeValidationRulesStorage(@NotNull MetadataStorage<EventLogBuild> myMetadataStorage, @NotNull ValidationTestRulesPersistedStorage myTestRulesStorage) {
        Intrinsics.checkNotNullParameter(myMetadataStorage, (String)"myMetadataStorage");
        Intrinsics.checkNotNullParameter((Object)myTestRulesStorage, (String)"myTestRulesStorage");
        this.myMetadataStorage = myMetadataStorage;
        this.myTestRulesStorage = myTestRulesStorage;
    }

    @NotNull
    public IGroupValidators<EventLogBuild> getGroupValidators(@NotNull String groupId) {
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        EventGroupRules testGroupRules = this.myTestRulesStorage.getGroupRules(groupId);
        if (testGroupRules != null) {
            return new TestGroupValidators((IEventGroupRules)testGroupRules);
        }
        if (this.myTestRulesStorage.hasCustomPathMetadata()) {
            return new EmptyGroupValidators();
        }
        return this.myMetadataStorage.getGroupValidators(groupId);
    }

    public boolean isUnreachable() {
        return this.myMetadataStorage.isUnreachable() && this.myTestRulesStorage.isUnreachable();
    }

    public boolean update() {
        return this.myMetadataStorage.update() && this.myTestRulesStorage.update();
    }

    @Nullable
    public Object update(@NotNull CoroutineScope scope, @NotNull Continuation<? super Job> $completion) {
        return this.myMetadataStorage.update(scope, $completion);
    }

    public void reload() {
        this.myMetadataStorage.reload();
        this.myTestRulesStorage.reload();
    }

    @Override
    @NotNull
    public ValidationTestRulesPersistedStorage getTestGroupStorage() {
        return this.myTestRulesStorage;
    }

    @NotNull
    public RecorderDataValidationRule getClientDataRulesRevisions() {
        throw new NotImplementedError(null, 1, null);
    }

    @NotNull
    public Set<String> getFieldsToAnonymize(@NotNull String groupId, @NotNull String eventId) {
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        Intrinsics.checkNotNullParameter((Object)eventId, (String)"eventId");
        throw new NotImplementedError(null, 1, null);
    }

    @NotNull
    public RecorderDataValidationRule getIdsRulesRevisions() {
        throw new NotImplementedError(null, 1, null);
    }

    @NotNull
    public Set<String> getSkipAnonymizationIds() {
        throw new NotImplementedError(null, 1, null);
    }

    @NotNull
    public RecorderDataValidationRule getSystemDataRulesRevisions() {
        throw new NotImplementedError(null, 1, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004R\u0016\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001c\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lcom/intellij/internal/statistic/eventLog/validator/storage/CompositeValidationRulesStorage$EmptyGroupValidators;", "Lcom/intellij/internal/statistic/eventLog/validator/IGroupValidators;", "Lcom/intellij/internal/statistic/eventLog/EventLogBuild;", "<init>", "()V", "eventGroupRules", "Lcom/intellij/internal/statistic/eventLog/validator/IEventGroupRules;", "getEventGroupRules", "()Lcom/intellij/internal/statistic/eventLog/validator/IEventGroupRules;", "versionFilter", "Lcom/intellij/internal/statistic/eventLog/validator/IEventGroupsFilterRules;", "getVersionFilter", "()Lcom/intellij/internal/statistic/eventLog/validator/IEventGroupsFilterRules;", "intellij.platform.statistics"})
    private static final class EmptyGroupValidators
    implements IGroupValidators<EventLogBuild> {
        @Nullable
        private final IEventGroupRules eventGroupRules;
        @Nullable
        private final IEventGroupsFilterRules<EventLogBuild> versionFilter;

        @Nullable
        public IEventGroupRules getEventGroupRules() {
            return this.eventGroupRules;
        }

        @Nullable
        public IEventGroupsFilterRules<EventLogBuild> getVersionFilter() {
            return this.versionFilter;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u001c\u0010\n\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lcom/intellij/internal/statistic/eventLog/validator/storage/CompositeValidationRulesStorage$TestGroupValidators;", "Lcom/intellij/internal/statistic/eventLog/validator/IGroupValidators;", "Lcom/intellij/internal/statistic/eventLog/EventLogBuild;", "testGroupRules", "Lcom/intellij/internal/statistic/eventLog/validator/IEventGroupRules;", "<init>", "(Lcom/intellij/internal/statistic/eventLog/validator/IEventGroupRules;)V", "eventGroupRules", "getEventGroupRules", "()Lcom/intellij/internal/statistic/eventLog/validator/IEventGroupRules;", "versionFilter", "Lcom/intellij/internal/statistic/eventLog/validator/IEventGroupsFilterRules;", "getVersionFilter", "()Lcom/intellij/internal/statistic/eventLog/validator/IEventGroupsFilterRules;", "intellij.platform.statistics"})
    private static final class TestGroupValidators
    implements IGroupValidators<EventLogBuild> {
        @NotNull
        private final IEventGroupRules testGroupRules;

        public TestGroupValidators(@NotNull IEventGroupRules testGroupRules) {
            Intrinsics.checkNotNullParameter((Object)testGroupRules, (String)"testGroupRules");
            this.testGroupRules = testGroupRules;
        }

        @NotNull
        public IEventGroupRules getEventGroupRules() {
            return this.testGroupRules;
        }

        @Nullable
        public IEventGroupsFilterRules<EventLogBuild> getVersionFilter() {
            return null;
        }
    }
}

