/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.util.SequentialNumber;

@InterfaceAudience.Private
public class SequentialBlockGroupIdGenerator
extends SequentialNumber {
    private final BlockManager blockManager;

    SequentialBlockGroupIdGenerator(BlockManager blockManagerRef) {
        super(Long.MIN_VALUE);
        this.blockManager = blockManagerRef;
    }

    public long nextValue() {
        this.skipTo((this.getCurrentValue() & 0xFFFFFFFFFFFFFFF0L) + 16L);
        Block b = new Block(this.getCurrentValue());
        while (this.hasValidBlockInRange(b)) {
            this.skipTo(this.getCurrentValue() + 16L);
            b.setBlockId(this.getCurrentValue());
        }
        if (b.getBlockId() >= 0L) {
            throw new IllegalStateException("All negative block group IDs are used, growing into positive IDs, which might conflict with non-erasure coded blocks.");
        }
        return this.getCurrentValue();
    }

    private boolean hasValidBlockInRange(Block b) {
        long id = b.getBlockId();
        for (int i = 0; i < 16; ++i) {
            b.setBlockId(id + (long)i);
            if (this.blockManager.getStoredBlock(b) == null) continue;
            return true;
        }
        return false;
    }
}

