/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.transport;

import java.io.IOException;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.action.ValidateActions;
import org.opensearch.action.support.nodes.BaseNodesRequest;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.core.common.Strings;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;

public class ADCancelTaskRequest
extends BaseNodesRequest<ADCancelTaskRequest> {
    private String detectorId;
    private String detectorTaskId;
    private String userName;
    private String reason;

    public ADCancelTaskRequest(StreamInput in) throws IOException {
        super(in);
        this.detectorId = in.readOptionalString();
        this.userName = in.readOptionalString();
        if (in.available() > 0) {
            this.detectorTaskId = in.readOptionalString();
            this.reason = in.readOptionalString();
        }
    }

    public ADCancelTaskRequest(String detectorId, String detectorTaskId, String userName, DiscoveryNode ... nodes) {
        this(detectorId, detectorTaskId, userName, (String)null, nodes);
    }

    public ADCancelTaskRequest(String detectorId, String detectorTaskId, String userName, String reason, DiscoveryNode ... nodes) {
        super(nodes);
        this.detectorId = detectorId;
        this.detectorTaskId = detectorTaskId;
        this.userName = userName;
        this.reason = reason;
    }

    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (Strings.isEmpty((CharSequence)this.detectorId)) {
            validationException = ValidateActions.addValidationError((String)"AD ID is missing", validationException);
        }
        return validationException;
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeOptionalString(this.detectorId);
        out.writeOptionalString(this.userName);
        out.writeOptionalString(this.detectorTaskId);
        out.writeOptionalString(this.reason);
    }

    public String getId() {
        return this.detectorId;
    }

    public String getDetectorTaskId() {
        return this.detectorTaskId;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getReason() {
        return this.reason;
    }
}

