/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.analysis;

import java.io.IOException;
import org.opensearch.Version;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.common.settings.Settings;
import org.opensearch.env.Environment;
import org.opensearch.index.IndexSettings;
import org.opensearch.indices.analysis.AnalysisModule;
import org.opensearch.indices.analysis.PreBuiltCacheFactory;

public abstract class PreConfiguredAnalysisComponent<T>
implements AnalysisModule.AnalysisProvider<T> {
    protected final String name;
    protected final PreBuiltCacheFactory.PreBuiltCache<T> cache;

    protected PreConfiguredAnalysisComponent(String name, PreBuiltCacheFactory.CachingStrategy cache) {
        this.name = name;
        this.cache = PreBuiltCacheFactory.getCache(cache);
    }

    protected PreConfiguredAnalysisComponent(String name, PreBuiltCacheFactory.PreBuiltCache<T> cache) {
        this.name = name;
        this.cache = cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get(IndexSettings indexSettings, Environment environment, String name, Settings settings) throws IOException {
        Version versionCreated = IndexMetadata.indexCreated(settings);
        PreConfiguredAnalysisComponent preConfiguredAnalysisComponent = this;
        synchronized (preConfiguredAnalysisComponent) {
            T factory = this.cache.get(versionCreated);
            if (factory == null) {
                factory = this.create(versionCreated);
                this.cache.put(versionCreated, factory);
            }
            return factory;
        }
    }

    public String getName() {
        return this.name;
    }

    protected abstract T create(Version var1);
}

