/*
 * SPDX-FileCopyrightText: NVIDIA CORPORATION & AFFILIATES
 * Copyright (c) 2023-2025 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
 *
 * This software is available to you under the terms of the
 * OpenIB.org BSD license included below:
 *
 *     Redistribution and use in source and binary forms, with or
 *     without modification, are permitted provided that the following
 *     conditions are met:
 *
 *      - Redistributions of source code must retain the above
 *        copyright notice, this list of conditions and the following
 *        disclaimer.
 *
 *      - Redistributions in binary form must reproduce the above
 *        copyright notice, this list of conditions and the following
 *        disclaimer in the documentation and/or other materials
 *        provided with the distribution.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
 * BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
 * ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 */

#pragma once

#include <pthread.h>

#include "agg_types.h"

class CommandManager;
class TreeNode;

class TrapHandler
{
   public:
    virtual void Handle(CommandManager& command_manager) = 0;

    virtual ~TrapHandler() {}
};

class QpErrorTrapHandler : public TrapHandler
{
    TrapQpError m_qp_error_;

   public:
    QpErrorTrapHandler(TrapQpError& qp_error) : m_qp_error_(qp_error) {}

    virtual void Handle(CommandManager& command_manager);
    virtual ~QpErrorTrapHandler() {}

    static TreeNode* GetTreeNode(lid_t an_port_lid, sharp_trees_t tree_id);
};

class InvalidReqTrapHandler : public TrapHandler
{
    sharp_job_id_t m_sharp_job_id_;
    port_key_t m_an_port_key_;

   public:
    InvalidReqTrapHandler(sharp_job_id_t sharp_job_id, port_key_t an_port_key) : m_sharp_job_id_(sharp_job_id), m_an_port_key_(an_port_key)
    {}

    virtual void Handle(CommandManager& command_manager);
    virtual ~InvalidReqTrapHandler() {}
};

class SharpErrorTrapHandler : public TrapHandler
{
    TrapSharpError m_sharp_error_;
    port_key_t m_an_port_key_;

   public:
    SharpErrorTrapHandler(TrapSharpError sharp_error, port_key_t an_port_key) : m_sharp_error_(sharp_error), m_an_port_key_(an_port_key) {}

    virtual void Handle(CommandManager& command_manager);
    virtual ~SharpErrorTrapHandler() {}
};
