/*++

Copyright (C) 2024 3MF Consortium (Original Author)

All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice, this
list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright notice,
this list of conditions and the following disclaimer in the documentation
and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

This file has been generated by the Automatic Component Toolkit (ACT) version 1.8.1-develop.

Abstract: This is an autogenerated Java file in order to allow an easy
 use of the 3MF Library

Interface version: 2.5.0

*/

package lib3mf;

import com.sun.jna.Library;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;


import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;

public class SelectNode extends OneInputNode {

	public SelectNode(Lib3MFWrapper wrapper, Pointer handle) {
		super(wrapper, handle);
	}

	/**
	 * Retrieves the second input
	 *
	 * @return the second input
	 * @throws Lib3MFException
	 */
	public ImplicitPort getInputB() throws Lib3MFException {
		Pointer bufferB = new Memory(8);
		mWrapper.checkError(this, mWrapper.lib3mf_selectnode_getinputb.invokeInt(new java.lang.Object[]{mHandle, bufferB}));
		Pointer valueB = bufferB.getPointer(0);
		ImplicitPort b = null;
		if (valueB == Pointer.NULL) {
		  throw new Lib3MFException(Lib3MFException.LIB3MF_ERROR_INVALIDPARAM, "B was a null pointer");
		}
		b = mWrapper.PolymorphicFactory(valueB, ImplicitPort.class);
		return b;
	}

	/**
	 * Retrieves the third input
	 *
	 * @return the third input
	 * @throws Lib3MFException
	 */
	public ImplicitPort getInputC() throws Lib3MFException {
		Pointer bufferC = new Memory(8);
		mWrapper.checkError(this, mWrapper.lib3mf_selectnode_getinputc.invokeInt(new java.lang.Object[]{mHandle, bufferC}));
		Pointer valueC = bufferC.getPointer(0);
		ImplicitPort c = null;
		if (valueC == Pointer.NULL) {
		  throw new Lib3MFException(Lib3MFException.LIB3MF_ERROR_INVALIDPARAM, "C was a null pointer");
		}
		c = mWrapper.PolymorphicFactory(valueC, ImplicitPort.class);
		return c;
	}

	/**
	 * Retrieves the fourth input
	 *
	 * @return the fourth input
	 * @throws Lib3MFException
	 */
	public ImplicitPort getInputD() throws Lib3MFException {
		Pointer bufferD = new Memory(8);
		mWrapper.checkError(this, mWrapper.lib3mf_selectnode_getinputd.invokeInt(new java.lang.Object[]{mHandle, bufferD}));
		Pointer valueD = bufferD.getPointer(0);
		ImplicitPort d = null;
		if (valueD == Pointer.NULL) {
		  throw new Lib3MFException(Lib3MFException.LIB3MF_ERROR_INVALIDPARAM, "D was a null pointer");
		}
		d = mWrapper.PolymorphicFactory(valueD, ImplicitPort.class);
		return d;
	}


}

