/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.html.examples;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.owasp.html.HtmlPolicyBuilder;
import org.owasp.html.HtmlStreamEventProcessor;
import org.owasp.html.HtmlStreamEventReceiver;
import org.owasp.html.HtmlStreamEventReceiverWrapper;
import org.owasp.html.HtmlTextEscapingMode;
import org.owasp.html.PolicyFactory;

public class UrlTextExample {
    public static void run(Appendable out, String ... inputs) throws IOException {
        PolicyFactory policyBuilder = new HtmlPolicyBuilder().allowAttributes("src").onElements("img").allowAttributes("href").onElements("a").allowStandardUrlProtocols().allowElements("a", "label", "h1", "h2", "h3", "h4", "h5", "h6", "p", "i", "b", "u", "strong", "em", "small", "big", "pre", "code", "cite", "samp", "sub", "sup", "strike", "center", "blockquote", "hr", "br", "col", "font", "span", "div", "img", "ul", "ol", "li", "dd", "dt", "dl", "tbody", "thead", "tfoot", "table", "td", "th", "tr", "colgroup", "fieldset", "legend").withPostprocessor(new HtmlStreamEventProcessor(){

            @Override
            public HtmlStreamEventReceiver wrap(HtmlStreamEventReceiver sink) {
                return new AppendDomainAfterText(sink);
            }
        }).toFactory();
        out.append(policyBuilder.sanitize(Arrays.stream(inputs).collect(Collectors.joining("\n"))));
    }

    public static void main(String ... argv) throws IOException {
        UrlTextExample.run(System.out, argv);
        System.out.println();
    }

    static String domainOf(String url) {
        int start = -1;
        if (url.startsWith("//")) {
            start = 2;
        } else {
            start = url.indexOf("://");
            if (start >= 0) {
                start += 3;
            }
        }
        if (start < 0) {
            return null;
        }
        for (int i = 0; i < start - 3; ++i) {
            switch (url.charAt(i)) {
                case '#': 
                case '/': 
                case '?': {
                    return null;
                }
            }
        }
        int end = url.length();
        block7: for (int i = start; i < end; ++i) {
            switch (url.charAt(i)) {
                case '#': 
                case '/': 
                case '?': {
                    end = i;
                    continue block7;
                }
            }
        }
        if (start < end) {
            return url.substring(start, end);
        }
        return null;
    }

    static class AppendDomainAfterText
    extends HtmlStreamEventReceiverWrapper {
        private final List<String> pendingText = new ArrayList<String>();

        AppendDomainAfterText(HtmlStreamEventReceiver underlying) {
            super(underlying);
        }

        @Override
        public void openTag(String elementName, List<String> attribs) {
            this.underlying.openTag(elementName, attribs);
            String trailingText = null;
            if (!attribs.isEmpty()) {
                String urlAttrName = null;
                if ("a".equals(elementName)) {
                    urlAttrName = "href";
                } else if ("img".equals(elementName)) {
                    urlAttrName = "src";
                }
                if (urlAttrName != null) {
                    int n = attribs.size();
                    for (int i = 0; i < n; i += 2) {
                        if (!urlAttrName.equals(attribs.get(i))) continue;
                        String url = attribs.get(i + 1).trim();
                        String domain = UrlTextExample.domainOf(url);
                        if (domain == null) break;
                        trailingText = " - " + domain;
                        break;
                    }
                }
            }
            if (HtmlTextEscapingMode.isVoidElement(elementName)) {
                if (trailingText != null) {
                    this.text(trailingText);
                }
            } else {
                this.pendingText.add(trailingText);
            }
        }

        @Override
        public void closeTag(String elementName) {
            String trailingText;
            this.underlying.closeTag(elementName);
            int pendingTextSize = this.pendingText.size();
            if (pendingTextSize != 0 && (trailingText = this.pendingText.remove(pendingTextSize - 1)) != null) {
                this.text(trailingText);
            }
        }
    }
}

