/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.cluster.infinispan;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.jboss.logging.Logger;

public class TaskCallback {
    protected static final Logger logger = Logger.getLogger(TaskCallback.class);
    static final int LATCH_TIMEOUT_MS = 10000;
    private volatile boolean success;
    private volatile Future<Boolean> future;
    private final CountDownLatch taskCompletedLatch = new CountDownLatch(1);
    private final CountDownLatch futureAvailableLatch = new CountDownLatch(1);

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public void setFuture(Future<Boolean> future) {
        this.future = future;
        this.futureAvailableLatch.countDown();
    }

    public Future<Boolean> getFuture() {
        try {
            this.futureAvailableLatch.await(10000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException ie) {
            logger.error((Object)"Interrupted thread!");
            Thread.currentThread().interrupt();
        }
        return this.future;
    }

    public CountDownLatch getTaskCompletedLatch() {
        return this.taskCompletedLatch;
    }
}

