/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.4.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Opening by reconstruction of an image.


This filter preserves regions, in the foreground, that can completely
contain the structuring element. At the same time, this filter
eliminates all other regions of foreground pixels. Contrary to the
morphological opening, the opening by reconstruction preserves the
shape of the components that are not removed by erosion. The opening
by reconstruction of an image "f" is defined as:

OpeningByReconstruction(f) = DilationByReconstruction(f, Erosion(f)).

Opening by reconstruction not only removes structures destroyed by the
erosion, but also levels down the contrast of the brightest regions.
If PreserveIntensities is on, a subsequent reconstruction by dilation
using a marker image that is the original image for all unaffected
pixels.

Opening by reconstruction is described in Chapter 6.3.9 of Pierre
Soille's book "Morphological Image Analysis: Principles and
Applications", Second Edition, Springer, 2003.


Gaetan Lehmann. Biologie du Developpement et de la Reproduction, INRA
de Jouy-en-Josas, France.

See:
 GrayscaleMorphologicalOpeningImageFilter

 itk::simple::OpeningByReconstruction for the procedural interface

 itk::OpeningByReconstructionImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkOpeningByReconstructionImageFilter.h
*/
public class OpeningByReconstructionImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected OpeningByReconstructionImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.OpeningByReconstructionImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(OpeningByReconstructionImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(OpeningByReconstructionImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::OpeningByReconstructionImageFilter::~OpeningByReconstructionImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_OpeningByReconstructionImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::OpeningByReconstructionImageFilter::OpeningByReconstructionImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  OpeningByReconstructionImageFilter() {
    this(SimpleITKJNI.new_OpeningByReconstructionImageFilter(), true);
  }

  /**
Self&amp; itk::simple::OpeningByReconstructionImageFilter::SetKernelRadius(unsigned int value)

Set the values of the KernelRadius vector all to value

*/
public  void setKernelRadius(VectorUInt32 KernelRadius) {
    SimpleITKJNI.OpeningByReconstructionImageFilter_setKernelRadius__SWIG_0(swigCPtr, this, VectorUInt32.getCPtr(KernelRadius), KernelRadius);
  }

  /**
Self&amp; itk::simple::OpeningByReconstructionImageFilter::SetKernelRadius(unsigned int value)

Set the values of the KernelRadius vector all to value

*/
public  void setKernelRadius(long value) {
    SimpleITKJNI.OpeningByReconstructionImageFilter_setKernelRadius__SWIG_1(swigCPtr, this, value);
  }

  /**
std::vector&lt;unsigned int&gt; itk::simple::OpeningByReconstructionImageFilter::GetKernelRadius() const

Get the radius of the kernel structuring element.

*/
public  VectorUInt32 getKernelRadius() {
    return new VectorUInt32(SimpleITKJNI.OpeningByReconstructionImageFilter_getKernelRadius(swigCPtr, this), true);
  }

  /**
Self&amp; itk::simple::OpeningByReconstructionImageFilter::SetKernelType(KernelEnum KernelType)

Set the kernel or structuring element used for the morphology.

*/
public  void setKernelType(KernelEnum KernelType) {
    SimpleITKJNI.OpeningByReconstructionImageFilter_setKernelType(swigCPtr, this, KernelType.swigValue());
  }

  /**
KernelEnum itk::simple::OpeningByReconstructionImageFilter::GetKernelType() const

Get the kernel or structuring element used for the morphology.

*/
public  KernelEnum getKernelType() {
    return KernelEnum.swigToEnum(SimpleITKJNI.OpeningByReconstructionImageFilter_getKernelType(swigCPtr, this));
  }

  /**
Self&amp; itk::simple::OpeningByReconstructionImageFilter::SetFullyConnected(bool FullyConnected)

Set/Get whether the connected components are defined strictly by face
connectivity or by face+edge+vertex connectivity. Default is
FullyConnectedOff. For objects that are 1 pixel wide, use
FullyConnectedOn.

*/
public  void setFullyConnected(boolean FullyConnected) {
    SimpleITKJNI.OpeningByReconstructionImageFilter_setFullyConnected(swigCPtr, this, FullyConnected);
  }

  /**
Self&amp; itk::simple::OpeningByReconstructionImageFilter::FullyConnectedOn()

Set the value of FullyConnected to true or false respectfully.

*/
public  void fullyConnectedOn() {
    SimpleITKJNI.OpeningByReconstructionImageFilter_fullyConnectedOn(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::OpeningByReconstructionImageFilter::FullyConnectedOff()
*/
public  void fullyConnectedOff() {
    SimpleITKJNI.OpeningByReconstructionImageFilter_fullyConnectedOff(swigCPtr, this);
  }

  /**
bool itk::simple::OpeningByReconstructionImageFilter::GetFullyConnected() const

Set/Get whether the connected components are defined strictly by face
connectivity or by face+edge+vertex connectivity. Default is
FullyConnectedOff. For objects that are 1 pixel wide, use
FullyConnectedOn.

*/
public  boolean getFullyConnected() {
    return SimpleITKJNI.OpeningByReconstructionImageFilter_getFullyConnected(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::OpeningByReconstructionImageFilter::SetPreserveIntensities(bool PreserveIntensities)

Set/Get whether the original intensities of the image retained for
those pixels unaffected by the opening by reconstruction. If Off, the
output pixel contrast will be reduced.

*/
public  void setPreserveIntensities(boolean PreserveIntensities) {
    SimpleITKJNI.OpeningByReconstructionImageFilter_setPreserveIntensities(swigCPtr, this, PreserveIntensities);
  }

  /**
Self&amp; itk::simple::OpeningByReconstructionImageFilter::PreserveIntensitiesOn()

Set the value of PreserveIntensities to true or false respectfully.

*/
public  void preserveIntensitiesOn() {
    SimpleITKJNI.OpeningByReconstructionImageFilter_preserveIntensitiesOn(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::OpeningByReconstructionImageFilter::PreserveIntensitiesOff()
*/
public  void preserveIntensitiesOff() {
    SimpleITKJNI.OpeningByReconstructionImageFilter_preserveIntensitiesOff(swigCPtr, this);
  }

  /**
bool itk::simple::OpeningByReconstructionImageFilter::GetPreserveIntensities() const

Set/Get whether the original intensities of the image retained for
those pixels unaffected by the opening by reconstruction. If Off, the
output pixel contrast will be reduced.

*/
public  boolean getPreserveIntensities() {
    return SimpleITKJNI.OpeningByReconstructionImageFilter_getPreserveIntensities(swigCPtr, this);
  }

  /**
std::string itk::simple::OpeningByReconstructionImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.OpeningByReconstructionImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::OpeningByReconstructionImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.OpeningByReconstructionImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::OpeningByReconstructionImageFilter::Execute(const Image &amp;image1)

Execute the filter on the input image

*/
public  Image execute(Image image1) {
    return new Image(SimpleITKJNI.OpeningByReconstructionImageFilter_execute(swigCPtr, this, Image.getCPtr(image1), image1), true);
  }

}
