/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.4.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Alter an image with shot noise.


The shot noise follows a Poisson distribution:


$ I = N(I_0) $

where $ N(I_0) $ is a Poisson-distributed random variable of mean $ I_0 $ . The noise is thus dependent on the pixel intensities in the image.
 The intensities in the image can be scaled by a user provided value
to map pixel values to the actual number of particles. The scaling can
be seen as the inverse of the gain used during the acquisition. The
noisy signal is then scaled back to its input intensity range:


$ I = \\frac{N(I_0 \\times s)}{s} $

where $ s $ is the scale factor.
 The Poisson-distributed variable $ \\lambda $ is computed by using the algorithm:


$ \\begin{array}{l} k \\leftarrow 0 \\\\ p \\leftarrow 1
\\\\ \\textbf{repeat} \\\\ \\left\\{ \\begin{array}{l}
k \\leftarrow k+1 \\\\ p \\leftarrow p \\ast U()
\\end{array} \\right. \\\\ \\textbf{until } p &gt;
e^{\\lambda} \\\\ \\textbf{return} (k) \\end{array} $

where $ U() $ provides a uniformly distributed random variable in the interval $ [0,1] $ .
 This algorithm is very inefficient for large values of $ \\lambda $ , though. Fortunately, the Poisson distribution can be accurately
approximated by a Gaussian distribution of mean and variance $ \\lambda $ when $ \\lambda $ is large enough. In this implementation, this value is considered to
be 50. This leads to the faster algorithm:


$ \\lambda + \\sqrt{\\lambda} \\times N()$

where $ N() $ is a normally distributed random variable of mean 0 and variance 1.

Gaetan Lehmann
 This code was contributed in the Insight Journal paper "Noise
Simulation". https://doi.org/10.54294/vh6vbw
See:
 itk::simple::ShotNoise for the procedural interface

 itk::ShotNoiseImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkShotNoiseImageFilter.h
*/
public class ShotNoiseImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected ShotNoiseImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.ShotNoiseImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(ShotNoiseImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(ShotNoiseImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::ShotNoiseImageFilter::~ShotNoiseImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_ShotNoiseImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::ShotNoiseImageFilter::ShotNoiseImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  ShotNoiseImageFilter() {
    this(SimpleITKJNI.new_ShotNoiseImageFilter(), true);
  }

  /**
Self&amp; itk::simple::ShotNoiseImageFilter::SetScale(double Scale)

Set/Get the value to map the pixel value to the actual particle
counting. The scaling can be seen as the inverse of the gain used
during the acquisition. The noisy signal is then scaled back to its
input intensity range. Defaults to 1.0.

*/
public  void setScale(double Scale) {
    SimpleITKJNI.ShotNoiseImageFilter_setScale(swigCPtr, this, Scale);
  }

  /**
double itk::simple::ShotNoiseImageFilter::GetScale() const

Set/Get the value to map the pixel value to the actual particle
counting. The scaling can be seen as the inverse of the gain used
during the acquisition. The noisy signal is then scaled back to its
input intensity range. Defaults to 1.0.

*/
public  double getScale() {
    return SimpleITKJNI.ShotNoiseImageFilter_getScale(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::ShotNoiseImageFilter::SetSeed(uint32_t Seed)
*/
public  void setSeed(long Seed) {
    SimpleITKJNI.ShotNoiseImageFilter_setSeed(swigCPtr, this, Seed);
  }

  /**
uint32_t itk::simple::ShotNoiseImageFilter::GetSeed() const
*/
public  long getSeed() {
    return SimpleITKJNI.ShotNoiseImageFilter_getSeed(swigCPtr, this);
  }

  /**
std::string itk::simple::ShotNoiseImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.ShotNoiseImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::ShotNoiseImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.ShotNoiseImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::ShotNoiseImageFilter::Execute(Image &amp;&amp;image1)

Execute the filter on the input image

*/
public  Image execute(Image image1) {
    return new Image(SimpleITKJNI.ShotNoiseImageFilter_execute(swigCPtr, this, Image.getCPtr(image1), image1), true);
  }

}
