/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader;

import ghidra.app.util.bin.format.pdb2.pdbreader.C13ExtendedInlineeSourceLine;
import ghidra.app.util.bin.format.pdb2.pdbreader.C13InlineeSourceLine;
import ghidra.app.util.bin.format.pdb2.pdbreader.C13Section;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

public class InlineeLinesC13Section
extends C13Section {
    private static final int InlineeSourceLineSignature = 0;
    private static final int ExtendedInlineeSourceLineSignature = 1;
    private int signature;
    private List<C13InlineeSourceLine> inlineeLines = new ArrayList<C13InlineeSourceLine>();

    static InlineeLinesC13Section parse(PdbByteReader reader, boolean ignore, TaskMonitor monitor) throws PdbException, CancelledException {
        return new InlineeLinesC13Section(reader, ignore, monitor);
    }

    private static List<C13InlineeSourceLine> parseInlineeLines(PdbByteReader reader, TaskMonitor monitor) throws CancelledException, PdbException {
        ArrayList<C13InlineeSourceLine> lines = new ArrayList<C13InlineeSourceLine>();
        while (reader.numRemaining() >= C13InlineeSourceLine.getBaseRecordSize()) {
            monitor.checkCancelled();
            C13InlineeSourceLine line = new C13InlineeSourceLine(reader);
            lines.add(line);
        }
        return lines;
    }

    private static List<C13InlineeSourceLine> parseExtendedInlineeLines(PdbByteReader reader, TaskMonitor monitor) throws CancelledException, PdbException {
        ArrayList<C13InlineeSourceLine> lines = new ArrayList<C13InlineeSourceLine>();
        while (reader.numRemaining() >= C13ExtendedInlineeSourceLine.getBaseRecordSize()) {
            monitor.checkCancelled();
            C13ExtendedInlineeSourceLine line = new C13ExtendedInlineeSourceLine(reader, monitor);
            lines.add(line);
        }
        return lines;
    }

    private InlineeLinesC13Section(PdbByteReader reader, boolean ignore, TaskMonitor monitor) throws PdbException, CancelledException {
        super(ignore);
        this.signature = reader.parseInt();
        switch (this.signature) {
            case 0: {
                this.inlineeLines = InlineeLinesC13Section.parseInlineeLines(reader, monitor);
                break;
            }
            case 1: {
                this.inlineeLines = InlineeLinesC13Section.parseExtendedInlineeLines(reader, monitor);
                break;
            }
            default: {
                this.inlineeLines = new ArrayList<C13InlineeSourceLine>();
            }
        }
        if (reader.hasMore()) {
            Msg.debug(InlineeLinesC13Section.class, (Object)String.format("Extra inlinee bytes remain for signature: 0x%03x", this.signature));
        }
    }

    public int getSignature() {
        return this.signature;
    }

    public List<C13InlineeSourceLine> getInlineeLines() {
        return this.inlineeLines;
    }

    public String toString() {
        return String.format("%s: num inlinee lines = %d", this.getClass().getSimpleName(), this.inlineeLines.size());
    }

    @Override
    protected void dumpInternal(Writer writer, TaskMonitor monitor) throws IOException, CancelledException {
        writer.write(String.format("Signature: 0x%03x\n", this.signature));
        for (C13InlineeSourceLine line : this.inlineeLines) {
            monitor.checkCancelled();
            writer.write(line.toString());
            writer.write(10);
        }
    }
}

