/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.bsim.query.client.tables;

import ghidra.features.bsim.query.client.tables.CachedStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.TreeMap;

public class SQLStringTable {
    private final String name;
    private final int maxLoaded;
    private final String insertSQL;
    private final String selectByIdSQL;
    private final String selectByValueSQL;
    private final CachedStatement<PreparedStatement> insertStatement;
    private final CachedStatement<PreparedStatement> selectByIdStatement;
    private final CachedStatement<PreparedStatement> selectByValueStatement;
    private final TreeMap<String, StringRecord> stringMap;
    private final TreeMap<Integer, StringRecord> idMap;
    private StringRecord loadedHead;
    private StringRecord loadedTail;
    private Connection db;

    public SQLStringTable(String name, int maxloaded) {
        this.name = name;
        this.maxLoaded = maxloaded;
        this.stringMap = new TreeMap();
        this.idMap = new TreeMap();
        this.insertSQL = this.generateSQLCommand("INSERT INTO # (id,val) VALUES(DEFAULT,?)");
        this.selectByIdSQL = this.generateSQLCommand("SELECT val FROM # WHERE id = ?");
        this.selectByValueSQL = this.generateSQLCommand("SELECT id FROM # WHERE val = ?");
        this.insertStatement = new CachedStatement();
        this.selectByIdStatement = new CachedStatement();
        this.selectByValueStatement = new CachedStatement();
    }

    public void setConnection(Connection db) {
        this.db = db;
    }

    public void close() {
        this.insertStatement.close();
        this.selectByIdStatement.close();
        this.selectByValueStatement.close();
        this.db = null;
        if (this.stringMap != null) {
            this.stringMap.clear();
        }
        if (this.idMap != null) {
            this.idMap.clear();
        }
        this.loadedHead = null;
        this.loadedTail = null;
    }

    public void createTable() throws SQLException {
        String sqlstring = this.generateSQLCommand("CREATE TABLE # (id SERIAL PRIMARY KEY,val TEXT UNIQUE)");
        Statement st = this.db.createStatement();
        st.executeUpdate(sqlstring);
        st.close();
    }

    public String getString(long id) throws SQLException {
        if (id == 0L) {
            return null;
        }
        StringRecord rec = this.idMap.get((int)id);
        if (rec != null) {
            this.moveToEnd(rec);
            return rec.value;
        }
        String res = this.readStringRecord(id);
        if (res == null) {
            throw new SQLException("Id is not present in string table: " + this.name);
        }
        return res;
    }

    public long writeString(String val) throws SQLException {
        if (val == null || val.length() == 0) {
            return 0L;
        }
        StringRecord rec = this.stringMap.get(val);
        if (rec != null) {
            this.moveToEnd(rec);
            return rec.id;
        }
        long id = this.readStringId(val);
        if (id != 0L) {
            return id;
        }
        return this.writeNewString(val);
    }

    private void insertAtEnd(StringRecord rec) {
        if (this.loadedTail == null) {
            this.loadedHead = rec;
            this.loadedHead.prev = null;
            this.loadedHead.next = null;
            this.loadedTail = rec;
            return;
        }
        rec.prev = this.loadedTail;
        this.loadedTail.next = rec;
        rec.next = null;
        this.loadedTail = rec;
    }

    private StringRecord popFirst() {
        StringRecord res = this.loadedHead;
        this.loadedHead = this.loadedHead.next;
        if (this.loadedHead == null) {
            this.loadedTail = null;
            return res;
        }
        this.loadedHead.prev = null;
        return res;
    }

    private void moveToEnd(StringRecord rec) {
        StringRecord prev;
        if (rec.next == null) {
            return;
        }
        rec.next.prev = prev = rec.prev;
        if (prev == null) {
            this.loadedHead = rec.next;
        } else {
            prev.next = rec.next;
        }
        this.insertAtEnd(rec);
    }

    private void purgeString() {
        StringRecord rec = this.popFirst();
        this.stringMap.remove(rec.value);
        this.idMap.remove((int)rec.id);
    }

    private String generateSQLCommand(String ptr) {
        int first = ptr.indexOf(35);
        int second = ptr.indexOf(35, first + 1);
        Object res = ptr.substring(0, first);
        res = (String)res + this.name;
        if (second >= 0) {
            res = (String)res + ptr.substring(first + 1, second);
            res = (String)res + this.name;
            res = (String)res + ptr.substring(second + 1);
        } else {
            res = (String)res + ptr.substring(first + 1);
        }
        return res;
    }

    private void insertRecord(long id, String value) {
        while (this.idMap.size() >= this.maxLoaded) {
            this.purgeString();
        }
        StringRecord rec = new StringRecord();
        this.insertAtEnd(rec);
        rec.id = id;
        rec.value = value;
        this.stringMap.put(value, rec);
        this.idMap.put((int)id, rec);
    }

    private String readStringRecord(long id) throws SQLException {
        PreparedStatement s = this.selectByIdStatement.prepareIfNeeded(() -> this.db.prepareStatement(this.selectByIdSQL));
        String value = null;
        s.setInt(1, (int)id);
        try (ResultSet rs = s.executeQuery();){
            if (!rs.next()) {
                String string = value;
                return string;
            }
            value = rs.getString(1);
        }
        this.insertRecord(id, value);
        return value;
    }

    public long readStringId(String value) throws SQLException {
        PreparedStatement s = this.selectByValueStatement.prepareIfNeeded(() -> this.db.prepareStatement(this.selectByValueSQL));
        long id = 0L;
        s.setString(1, value);
        try (ResultSet rs = s.executeQuery();){
            if (!rs.next()) {
                long l = id;
                return l;
            }
            id = rs.getInt(1);
        }
        this.insertRecord(id, value);
        return id;
    }

    private long writeNewString(String value) throws SQLException {
        PreparedStatement s = this.insertStatement.prepareIfNeeded(() -> this.db.prepareStatement(this.insertSQL, 1));
        s.setString(1, value);
        s.executeUpdate();
        try (ResultSet rs = s.getGeneratedKeys();){
            if (!rs.next()) {
                throw new SQLException("Error during insertion");
            }
            long id = rs.getInt(1);
            this.insertRecord(id, value);
            long l = id;
            return l;
        }
    }

    public static class StringRecord {
        public long id;
        public String value;
        public StringRecord prev;
        public StringRecord next;
    }
}

