/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.datastruct;

import ghidra.util.datastruct.Range;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.SortedSet;
import java.util.TreeSet;

public class SortedRangeList
implements Iterable<Range> {
    TreeSet<Range> set = new TreeSet();

    public SortedRangeList() {
    }

    public SortedRangeList(SortedRangeList list) {
        for (Range r : list.set) {
            this.addRange(r.min, r.max);
        }
    }

    public void addRange(int min, int max) {
        SortedSet<Range> ss;
        Range key = new Range(min, min);
        SortedSet<Range> headSet = this.set.headSet(key);
        if (!headSet.isEmpty()) {
            Range last = headSet.last();
            if (min <= last.max + 1) {
                last.max = Math.max(last.max, max);
                this.coalesce(last, this.set.tailSet(key).iterator());
                return;
            }
        }
        if ((ss = this.set.tailSet(key)).isEmpty()) {
            this.set.add(new Range(min, max));
            return;
        }
        Iterator<Range> it = ss.iterator();
        Range first = (Range)it.next();
        if (max < first.min - 1) {
            this.set.add(new Range(min, max));
            return;
        }
        first.min = Math.min(first.min, min);
        first.max = Math.max(first.max, max);
        this.coalesce(first, it);
    }

    public Iterator<Range> getRanges() {
        return this.set.iterator();
    }

    public Iterator<Range> getRanges(boolean forward) {
        if (forward) {
            return this.set.iterator();
        }
        Iterator<Range> it = this.set.iterator();
        LinkedList<Range> ll = new LinkedList<Range>();
        while (it.hasNext()) {
            ll.addFirst(it.next());
        }
        return ll.iterator();
    }

    public int getMin() throws NoSuchElementException {
        Range r = this.set.first();
        return r.min;
    }

    public int getMax() throws NoSuchElementException {
        Range r = this.set.last();
        return r.max;
    }

    public int getNumRanges() {
        return this.set.size();
    }

    public void removeRange(int min, int max) {
        Range key = new Range(min, min);
        SortedSet<Range> headSet = this.set.headSet(key);
        if (!headSet.isEmpty()) {
            Range last = headSet.last();
            if (last.max >= min) {
                if (max < last.max) {
                    this.set.add(new Range(max + 1, last.max));
                    last.max = Math.min(last.max, min - 1);
                    return;
                }
                last.max = Math.min(last.max, min - 1);
            }
        }
        Iterator it = this.set.tailSet(key).iterator();
        while (it.hasNext()) {
            Range next = (Range)it.next();
            if (next.min > max) break;
            if (next.max > max) {
                next.min = max + 1;
                break;
            }
            it.remove();
        }
    }

    void coalesce(Range range, Iterator<Range> it) {
        while (it.hasNext()) {
            Range next = it.next();
            if (next.min > range.max + 1) break;
            range.max = Math.max(range.max, next.max);
            it.remove();
        }
    }

    public boolean contains(int value) {
        Range key = new Range(value, value);
        SortedSet<Range> head = this.set.headSet(key);
        if (!head.isEmpty() && head.last().max >= value) {
            return true;
        }
        return this.set.contains(key);
    }

    private Range getRangeContaining(int value) {
        SortedSet<Range> tail;
        Range key = new Range(value, value);
        SortedSet<Range> head = this.set.headSet(key);
        if (!head.isEmpty()) {
            Range last = head.last();
            if (last.max >= value) {
                return last;
            }
        }
        if (!(tail = this.set.tailSet(key)).isEmpty()) {
            Range range = tail.first();
            if (range.min == value) {
                return range;
            }
        }
        return null;
    }

    public boolean contains(int min, int max) {
        Range range = this.getRangeContaining(min);
        if (range != null) {
            return range.contains(max);
        }
        return false;
    }

    public int getRangeIndex(int value) {
        Range key = new Range(value, value);
        SortedSet<Range> head = this.set.headSet(key);
        int index = head.size() - 1;
        if (!head.isEmpty()) {
            Range last = head.last();
            if (last.max >= value) {
                return index;
            }
        }
        ++index;
        SortedSet<Range> tail = this.set.tailSet(key);
        if (!tail.isEmpty()) {
            Range range = tail.first();
            if (range.min == value) {
                return index;
            }
        }
        return -index - 1;
    }

    public Range getRange(int index) {
        Iterator<Range> it = this.set.iterator();
        while (index > 0 && it.hasNext()) {
            it.next();
            --index;
        }
        if (index == 0 && it.hasNext()) {
            return it.next();
        }
        return null;
    }

    public long getNumValues() {
        Iterator<Range> it = this.set.iterator();
        long n = 0L;
        while (it.hasNext()) {
            Range r = it.next();
            n += r.size();
        }
        return n;
    }

    public boolean intersects(int min, int max) {
        SortedSet<Range> tail;
        Range key = new Range(min, min);
        SortedSet<Range> head = this.set.headSet(key);
        if (!head.isEmpty()) {
            Range last = head.last();
            if (last.max >= min) {
                return true;
            }
        }
        if (!(tail = this.set.tailSet(key)).isEmpty()) {
            Range next = tail.first();
            if (next.min <= max) {
                return true;
            }
        }
        return false;
    }

    public boolean isEmpty() {
        return this.set.isEmpty();
    }

    public void remove(SortedRangeList other) {
        Iterator<Range> it = other.getRanges();
        while (it.hasNext()) {
            Range r = it.next();
            this.removeRange(r.min, r.max);
        }
    }

    public SortedRangeList intersect(SortedRangeList other) {
        SortedRangeList srl = new SortedRangeList(this);
        srl.remove(other);
        SortedRangeList srl2 = new SortedRangeList(this);
        srl2.remove(srl);
        return srl2;
    }

    public String toString() {
        Range r;
        StringBuilder buf = new StringBuilder();
        Iterator<Range> it = this.getRanges();
        if (it.hasNext()) {
            r = it.next();
            buf.append("[" + r.min + "," + r.max + "]");
        }
        while (it.hasNext()) {
            r = it.next();
            buf.append(" [" + r.min + "," + r.max + "]");
        }
        return buf.toString();
    }

    @Override
    public Iterator<Range> iterator() {
        return this.getRanges(true);
    }

    public void clear() {
        this.set.clear();
    }

    public int hashCode() {
        return Objects.hash(this.set);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SortedRangeList other = (SortedRangeList)obj;
        return Objects.equals(this.set, other.set);
    }
}

