/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.util;

import ghidra.program.model.address.Address;
import ghidra.program.model.util.PropertyMap;
import ghidra.util.Saveable;

public interface ObjectPropertyMap<T extends Saveable>
extends PropertyMap<T> {
    @Override
    public void add(Address var1, T var2) throws IllegalArgumentException;

    @Override
    default public void add(Address addr, Object value) {
        if (value == null) {
            this.remove(addr);
            return;
        }
        Class saveableObjectClass = this.getValueClass();
        if (!saveableObjectClass.isAssignableFrom(value.getClass())) {
            throw new IllegalArgumentException("value is not " + saveableObjectClass.getName());
        }
        this.add(addr, (T)((Saveable)value));
    }
}

