/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.data;

import db.DBHandle;
import db.DBRecord;
import db.Field;
import db.LongField;
import db.Schema;
import db.StringField;
import db.Table;
import ghidra.program.database.data.CategoryDBAdapter;
import ghidra.util.exception.VersionException;
import java.io.IOException;

class CategoryDBAdapterV0
extends CategoryDBAdapter {
    private static final int VERSION = 0;
    static final String CATEGORY_TABLE_NAME = "Categories";
    static final int V0_CATEGORY_NAME_COL = 0;
    static final int V0_CATEGORY_PARENT_COL = 1;
    static final Schema V0_SCHEMA = new Schema(0, "Category ID", new Field[]{StringField.INSTANCE, LongField.INSTANCE}, new String[]{"Name", "Parent ID"});
    private Table table;

    CategoryDBAdapterV0(DBHandle handle, String tablePrefix, boolean create) throws VersionException, IOException {
        String tableName = tablePrefix + CATEGORY_TABLE_NAME;
        if (create) {
            this.table = handle.createTable(tableName, V0_SCHEMA, new int[]{1});
        } else {
            this.table = handle.getTable(tableName);
            if (this.table == null) {
                throw new VersionException("Missing Table: " + tableName);
            }
            if (this.table.getSchema().getVersion() != 0) {
                throw new VersionException(false);
            }
        }
    }

    @Override
    DBRecord getRecord(long categoryID) throws IOException {
        return this.table.getRecord(categoryID);
    }

    @Override
    Field[] getRecordIdsWithParent(long categoryID) throws IOException {
        return this.table.findRecords((Field)new LongField(categoryID), 1);
    }

    @Override
    void updateRecord(long categoryID, long parentID, String name) throws IOException {
        DBRecord rec = this.table.getSchema().createRecord(categoryID);
        rec.setString(0, name);
        rec.setLongValue(1, parentID);
        this.table.putRecord(rec);
    }

    @Override
    void putRecord(DBRecord record) throws IOException {
        this.table.putRecord(record);
    }

    @Override
    DBRecord createCategory(String name, long parentID) throws IOException {
        long key = this.table.getKey();
        if (key == 0L) {
            key = 1L;
        }
        DBRecord rec = this.table.getSchema().createRecord(key);
        rec.setString(0, name);
        rec.setLongValue(1, parentID);
        this.table.putRecord(rec);
        return rec;
    }

    @Override
    boolean removeCategory(long categoryID) throws IOException {
        return this.table.deleteRecord(categoryID);
    }

    @Override
    DBRecord getRootRecord() throws IOException {
        Field[] keys = this.table.findRecords((Field)new LongField(-1L), 1);
        if (keys.length != 1) {
            throw new IOException("Found " + keys.length + " entries for root category");
        }
        return this.getRecord(keys[0].getLongValue());
    }

    @Override
    int getRecordCount() {
        return this.table.getRecordCount();
    }
}

