/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.client;

import ghidra.framework.client.ClientAuthenticator;
import ghidra.framework.client.ClientUtil;
import ghidra.framework.client.DefaultClientAuthenticator;
import ghidra.framework.remote.AnonymousCallback;
import ghidra.framework.remote.SSHSignatureCallback;
import ghidra.framework.remote.security.SSHKeyManager;
import ghidra.net.DefaultKeyManagerFactory;
import ghidra.util.Msg;
import java.awt.Component;
import java.io.Console;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.security.InvalidKeyException;
import javax.security.auth.callback.ChoiceCallback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import org.apache.commons.lang3.StringUtils;

public class HeadlessClientAuthenticator
implements ClientAuthenticator {
    private static final char[] BADPASSWORD = "".toCharArray();
    private static Object sshPrivateKey;
    private static String preferredName;
    private static boolean passwordPromptAllowed;
    private Authenticator authenticator = new Authenticator(){

        @Override
        protected PasswordAuthentication getPasswordAuthentication() {
            String serverName = this.getRequestingHost();
            URL requestingURL = this.getRequestingURL();
            String pwd = null;
            String name = preferredName;
            if (requestingURL != null) {
                URL minimalURL;
                String userInfo = requestingURL.getUserInfo();
                if (userInfo != null) {
                    int pwdSep = userInfo.indexOf(58);
                    if (pwdSep < 0) {
                        name = userInfo;
                    } else {
                        pwd = userInfo.substring(pwdSep + 1);
                        if (pwdSep != 0) {
                            name = userInfo.substring(0, pwdSep);
                        }
                    }
                }
                if ((minimalURL = DefaultClientAuthenticator.getMinimalURL(requestingURL)) != null) {
                    serverName = minimalURL.toExternalForm();
                }
            }
            Msg.debug((Object)this, (Object)("PasswordAuthentication requested for " + serverName));
            if (StringUtils.isBlank((CharSequence)name)) {
                throw new IllegalStateException("Connection user name is unknown");
            }
            if (pwd != null) {
                return new PasswordAuthentication(name, pwd.toCharArray());
            }
            String usage = "Access password requested for " + serverName;
            Object prompt = this.getRequestingPrompt();
            if (StringUtils.isBlank((CharSequence)prompt) || "security".equals(prompt)) {
                prompt = "Password for " + name + ":";
            }
            return new PasswordAuthentication(name, HeadlessClientAuthenticator.this.getPassword(usage, (String)prompt));
        }
    };

    HeadlessClientAuthenticator() {
    }

    @Override
    public Authenticator getAuthenticator() {
        return this.authenticator;
    }

    public static void installHeadlessClientAuthenticator(String username, String keystorePath, boolean allowPasswordPrompt) throws IOException {
        passwordPromptAllowed = allowPasswordPrompt;
        if (username != null) {
            preferredName = username;
        }
        sshPrivateKey = null;
        HeadlessClientAuthenticator authenticator = new HeadlessClientAuthenticator();
        ClientUtil.setClientAuthenticator(authenticator);
        if (keystorePath != null) {
            File keyfile = new File(keystorePath);
            if (!keyfile.exists()) {
                try (InputStream keyIn = HeadlessClientAuthenticator.class.getResourceAsStream(keystorePath);){
                    if (keyIn != null) {
                        try {
                            sshPrivateKey = SSHKeyManager.getSSHPrivateKey(keyIn);
                            Msg.info(HeadlessClientAuthenticator.class, (Object)("Loaded SSH key: " + keystorePath));
                            return;
                        }
                        catch (Exception e) {
                            Msg.error(HeadlessClientAuthenticator.class, (Object)("Failed to open keystore for SSH use: " + keystorePath), (Throwable)e);
                            throw new IOException("Failed to parse keystore: " + keystorePath);
                        }
                    }
                }
                Msg.error(HeadlessClientAuthenticator.class, (Object)("Keystore not found: " + keystorePath));
                throw new FileNotFoundException("Keystore not found: " + keystorePath);
            }
            boolean success = false;
            try {
                sshPrivateKey = SSHKeyManager.getSSHPrivateKey(keyfile);
                success = true;
                Msg.info(HeadlessClientAuthenticator.class, (Object)("Loaded SSH key: " + keystorePath));
            }
            catch (InvalidKeyException e) {
                if (DefaultKeyManagerFactory.setDefaultKeyStore((String)keystorePath, (boolean)false)) {
                    success = true;
                    Msg.info(HeadlessClientAuthenticator.class, (Object)("Loaded PKI keystore: " + keystorePath));
                }
            }
            catch (IOException e) {
                Msg.error(HeadlessClientAuthenticator.class, (Object)("Failed to open keystore for SSH use: " + keystorePath), (Throwable)e);
            }
            if (!success) {
                throw new IOException("Failed to parse keystore: " + keystorePath);
            }
        } else {
            sshPrivateKey = null;
        }
    }

    private char[] getPassword(String usage, String prompt) {
        if (!passwordPromptAllowed) {
            Msg.warn((Object)this, (Object)"Headless client not configured to supply required password");
            return BADPASSWORD;
        }
        char[] password = null;
        try {
            Console cons;
            Object passwordPrompt = "";
            if (usage != null) {
                passwordPrompt = (String)passwordPrompt + usage;
                passwordPrompt = (String)passwordPrompt + "\n";
            }
            if (StringUtils.isBlank((CharSequence)prompt)) {
                prompt = "Password:";
            }
            if ((cons = System.console()) != null) {
                passwordPrompt = (String)passwordPrompt + prompt + " ";
                password = cons.readPassword((String)passwordPrompt, new Object[0]);
            } else {
                int c;
                passwordPrompt = (String)passwordPrompt + "*** WARNING! Password entry will NOT be masked ***\n" + prompt;
                System.out.print((String)passwordPrompt);
                while (!((c = System.in.read()) <= 0 || Character.isWhitespace((char)c) && c != 32)) {
                    if (password == null) {
                        password = new char[1];
                    } else {
                        char[] newPass = new char[password.length + 1];
                        for (int i = 0; i < password.length; ++i) {
                            newPass[i] = password[i];
                            password[i] = '\u0000';
                        }
                        password = newPass;
                    }
                    password[password.length - 1] = (char)c;
                }
            }
        }
        catch (IOException e) {
            Msg.error((Object)this, (Object)"Error reading standard-input for password", (Throwable)e);
        }
        return password;
    }

    @Override
    public char[] getNewPassword(Component parent, String serverInfo, String username) {
        throw new UnsupportedOperationException("Server password change not permitted");
    }

    @Override
    public boolean processPasswordCallbacks(String title, String serverType, String serverName, boolean allowUserNameEntry, NameCallback nameCb, PasswordCallback passCb, ChoiceCallback choiceCb, AnonymousCallback anonymousCb, String loginError) {
        if (anonymousCb != null && !passwordPromptAllowed) {
            anonymousCb.setAnonymousAccessRequested(true);
            return true;
        }
        if (choiceCb != null) {
            choiceCb.setSelectedIndex(1);
        }
        String userName = null;
        if (nameCb != null) {
            if (allowUserNameEntry) {
                userName = preferredName;
            }
            if (StringUtils.isBlank((CharSequence)userName) && StringUtils.isBlank((CharSequence)(userName = nameCb.getName()))) {
                userName = nameCb.getDefaultName();
            }
            if (allowUserNameEntry) {
                nameCb.setName(userName);
            }
        }
        if (StringUtils.isBlank(userName)) {
            userName = ClientUtil.getUserName();
        }
        String usage = null;
        if (serverName != null) {
            usage = serverType + ": " + serverName;
        }
        String prompt = "Password for " + userName + ":";
        char[] password = this.getPassword(usage, prompt);
        passCb.setPassword(password);
        return password != null;
    }

    @Override
    public boolean promptForReconnect(Component parent, String message) {
        return false;
    }

    public char[] getKeyStorePassword(String keystorePath, boolean passwordError) {
        if (passwordError) {
            if (passwordPromptAllowed) {
                Msg.error((Object)this, (Object)("Incorrect keystore password specified: " + keystorePath));
            } else {
                Msg.error((Object)this, (Object)("Keystore password required but password entry has been disabled: " + keystorePath));
            }
            return null;
        }
        return this.getPassword("Certificate keystore: " + keystorePath, "Keystore password: ");
    }

    @Override
    public boolean processSSHSignatureCallbacks(String serverName, NameCallback nameCb, SSHSignatureCallback sshCb) {
        if (sshPrivateKey == null) {
            return false;
        }
        if (nameCb != null) {
            String userName = preferredName;
            if (StringUtils.isBlank((CharSequence)userName)) {
                userName = nameCb.getName();
                if (StringUtils.isBlank((CharSequence)userName)) {
                    userName = nameCb.getDefaultName();
                }
                if (!StringUtils.isBlank((CharSequence)userName)) {
                    userName = ClientUtil.getUserName();
                }
            }
            nameCb.setName(userName);
        }
        try {
            sshCb.sign(sshPrivateKey);
            return true;
        }
        catch (IOException e) {
            Msg.error((Object)this, (Object)"Failed to authenticate with SSH private key", (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean isSSHKeyAvailable() {
        return sshPrivateKey != null;
    }

    static {
        preferredName = null;
    }
}

