/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.data;

import ghidra.framework.client.RepositoryAdapter;
import ghidra.framework.data.ContentHandler;
import ghidra.framework.data.DefaultProjectData;
import ghidra.framework.data.DomainObjectAdapter;
import ghidra.framework.data.FolderLinkContentHandler;
import ghidra.framework.data.GhidraFile;
import ghidra.framework.data.GhidraFileData;
import ghidra.framework.data.GhidraFolder;
import ghidra.framework.data.LinkHandler;
import ghidra.framework.data.RootGhidraFolderData;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainFolderChangeListener;
import ghidra.framework.model.DomainObject;
import ghidra.framework.model.ProjectData;
import ghidra.framework.model.ProjectLocator;
import ghidra.framework.model.ServerInfo;
import ghidra.framework.protocol.ghidra.GhidraURL;
import ghidra.framework.protocol.ghidra.TransientProjectData;
import ghidra.framework.store.FileSystem;
import ghidra.framework.store.FolderItem;
import ghidra.framework.store.UnknownFolderItem;
import ghidra.framework.store.local.LocalFileSystem;
import ghidra.framework.store.local.LocalFolderItem;
import ghidra.util.InvalidNameException;
import ghidra.util.Msg;
import ghidra.util.ReadOnlyException;
import ghidra.util.SystemUtilities;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.ClosedException;
import ghidra.util.exception.DuplicateFileException;
import ghidra.util.exception.FileInUseException;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

class GhidraFolderData {
    private DefaultProjectData projectData;
    private DomainFolderChangeListener listener;
    protected LocalFileSystem fileSystem;
    protected FileSystem versionedFileSystem;
    private GhidraFolderData parent;
    private String name;
    private Set<String> folderList = new TreeSet<String>();
    private boolean visited;
    private Map<String, GhidraFileData> fileDataCache = new HashMap<String, GhidraFileData>();
    private Map<String, GhidraFolderData> folderDataCache = new HashMap<String, GhidraFolderData>();
    private boolean folderExists;
    private boolean versionedFolderExists;

    GhidraFolderData(DefaultProjectData projectData, DomainFolderChangeListener listener) {
        this.projectData = projectData;
        this.fileSystem = projectData.getLocalFileSystem();
        this.versionedFileSystem = projectData.getVersionedFileSystem();
        this.listener = listener;
    }

    GhidraFolderData(GhidraFolderData parent, String name) throws FileNotFoundException {
        if (name == null || name.isEmpty()) {
            throw new FileNotFoundException("Bad folder name: blank or null");
        }
        this.parent = parent;
        this.name = name;
        this.projectData = parent.getProjectData();
        this.fileSystem = parent.getLocalFileSystem();
        this.versionedFileSystem = parent.getVersionedFileSystem();
        this.listener = parent.getChangeListener();
        try {
            this.updateExistenceState();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!this.folderExists && !this.versionedFolderExists) {
            throw new FileNotFoundException("folder " + name + " not found");
        }
    }

    boolean visited() {
        return this.visited;
    }

    boolean mustVisit() {
        RootGhidraFolderData rootFolderData = this.projectData.getRootFolderData();
        return rootFolderData.mustVisit(this.getPathname());
    }

    LocalFileSystem getLocalFileSystem() {
        return this.fileSystem;
    }

    FileSystem getVersionedFileSystem() {
        return this.versionedFileSystem;
    }

    LocalFileSystem getUserFileSystem() {
        return this.projectData.getUserFileSystem();
    }

    DomainFolderChangeListener getChangeListener() {
        return this.listener;
    }

    DefaultProjectData getProjectData() {
        return this.projectData;
    }

    ProjectLocator getProjectLocator() {
        return this.projectData.getProjectLocator();
    }

    GhidraFolderData getParentData() {
        return this.parent;
    }

    GhidraFolderData getFolderPathData(String folderPath, boolean lazy) {
        if (this.parent == null) {
            if (folderPath.startsWith(FileSystem.SEPARATOR)) {
                folderPath = folderPath.substring(FileSystem.SEPARATOR.length());
            }
        } else if (folderPath.startsWith(FileSystem.SEPARATOR)) {
            return this.projectData.getRootFolderData().getFolderPathData(folderPath, lazy);
        }
        if (folderPath.length() == 0) {
            return this;
        }
        int index = folderPath.indexOf(FileSystem.SEPARATOR);
        String nextPath = "";
        String nextName = folderPath;
        if (index > 0) {
            nextPath = folderPath.substring(index + 1);
            nextName = folderPath.substring(0, index);
        } else if (index == 0) {
            throw new IllegalArgumentException("Invalid path specified with double separator");
        }
        GhidraFolderData folderData = this.getFolderData(nextName, lazy);
        if (folderData == null) {
            return null;
        }
        if (nextPath.length() == 0) {
            return folderData;
        }
        return folderData.getFolderPathData(nextPath, lazy);
    }

    String getName() {
        return this.parent != null ? this.name : this.projectData.getProjectLocator().getName();
    }

    private void checkFolderLinkConflict(String folderName) throws DuplicateFileException {
        GhidraFile file = this.getDomainFile(folderName);
        if (file != null && file.isFolderLink()) {
            throw new DuplicateFileException("Name conflict. Folder-link named " + folderName + " already exists in " + this.getPathname());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    GhidraFolder setName(String newName) throws InvalidNameException, IOException {
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            if (this.parent == null || this.fileSystem.isReadOnly()) {
                throw new IOException("setName not permitted on this folder");
            }
            this.updateExistenceState();
            this.checkInUse();
            this.parent.checkFolderLinkConflict(newName);
            String oldName = this.name;
            String parentPath = this.parent.getPathname();
            if (this.folderExists) {
                this.fileSystem.renameFolder(parentPath, this.name, newName);
            }
            if (this.versionedFolderExists) {
                try {
                    this.versionedFileSystem.renameFolder(parentPath, this.name, newName);
                }
                catch (IOException e) {
                    if (this.folderExists) {
                        this.fileSystem.renameFolder(parentPath, newName, this.name);
                    }
                    throw e;
                }
            }
            this.parent.folderDataCache.remove(this.name);
            this.name = newName;
            this.parent.folderDataCache.put(newName, this);
            GhidraFolder newFolder = this.getDomainFolder();
            if (this.parent.visited) {
                this.parent.folderList.remove(oldName);
                this.parent.folderList.add(newName);
                this.refresh(true, true, this.projectData.getProjectDisposalMonitor());
                this.listener.domainFolderRenamed(newFolder, oldName);
            }
            return newFolder;
        }
    }

    private void checkInUse() throws FileInUseException {
        try {
            for (GhidraFolderData folder : this.folderDataCache.values()) {
                folder.checkInUse();
            }
            for (GhidraFileData file : this.fileDataCache.values()) {
                file.checkInUse();
            }
        }
        catch (FileInUseException e) {
            throw new FileInUseException(this.name + " has one or more files in use");
        }
    }

    String getPathname(String childName) {
        Object path = this.getPathname();
        if (((String)path).length() != FileSystem.SEPARATOR.length()) {
            path = (String)path + FileSystem.SEPARATOR;
        }
        path = (String)path + childName;
        return path;
    }

    String getPathname() {
        if (this.parent == null) {
            return FileSystem.SEPARATOR;
        }
        Object path = this.parent.getPathname();
        if (((String)path).length() != FileSystem.SEPARATOR.length()) {
            path = (String)path + FileSystem.SEPARATOR;
        }
        path = (String)path + this.name;
        return path;
    }

    boolean isEmpty() {
        try {
            this.refresh(false, false, null);
            return this.folderList.isEmpty() && this.fileDataCache.isEmpty();
        }
        catch (IOException e) {
            return true;
        }
    }

    List<String> getFileNames() {
        try {
            this.refresh(false, false, null);
        }
        catch (IOException e) {
            Msg.error((Object)this, (Object)("Folder refresh failed: " + e.getMessage()));
            return new ArrayList<String>();
        }
        return new ArrayList<String>(this.fileDataCache.keySet());
    }

    List<String> getFolderNames() {
        try {
            this.refresh(false, false, null);
        }
        catch (IOException e) {
            Msg.error((Object)this, (Object)("Folder refresh failed: " + e.getMessage()));
            return new ArrayList<String>();
        }
        return new ArrayList<String>(this.folderList);
    }

    void fileRenamed(String oldFileName, String newFileName) {
        GhidraFileData fileData = this.fileDataCache.remove(oldFileName);
        if (fileData == null || this != fileData.getParent() || !newFileName.equals(fileData.getName())) {
            throw new AssertException();
        }
        this.fileDataCache.put(newFileName, fileData);
        if (this.visited) {
            this.listener.domainFileRenamed(this.getDomainFile(newFileName), oldFileName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fileMoved(GhidraFolderData newParent, String oldFileName, String newFileName) {
        GhidraFileData fileData;
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            fileData = this.fileDataCache.remove(oldFileName);
            if (fileData == null || newParent != fileData.getParent() || !newFileName.equals(fileData.getName())) {
                throw new AssertException();
            }
            newParent.fileDataCache.put(newFileName, fileData);
        }
        if (this.visited || newParent.visited) {
            this.listener.domainFileMoved(fileData.getDomainFile(), this.getDomainFolder(), oldFileName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fileChanged(String fileName) {
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            GhidraFileData fileData = this.fileDataCache.get(fileName);
            if (fileData != null) {
                block10: {
                    String fileID = fileData.getFileID();
                    try {
                        fileData.statusChanged();
                    }
                    catch (IOException e) {
                        fileData.dispose();
                        this.fileDataCache.remove(fileName);
                        if (!this.visited) break block10;
                        this.listener.domainFileRemoved(this.getDomainFolder(), fileName, fileID);
                    }
                }
                return;
            }
            if (this.visited) {
                try {
                    fileData = this.addFileData(fileName);
                    if (fileData != null) {
                        this.listener.domainFileAdded(fileData.getDomainFile());
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void folderChanged(String folderName) throws IOException {
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            GhidraFolderData folderData = this.folderDataCache.get(folderName);
            if (folderData != null) {
                try {
                    folderData.updateExistenceState();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (folderData.versionedFolderExists || folderData.folderExists) {
                    if (folderData.visited) {
                        folderData.refresh(true, true, this.projectData.getProjectDisposalMonitor());
                    }
                    return;
                }
                this.folderDataCache.remove(folderName);
                folderData.dispose();
                folderData = null;
            }
            if (this.visited) {
                folderData = this.addFolderData(folderName);
                if (folderData == null) {
                    if (this.folderList.remove(folderName)) {
                        this.listener.domainFolderRemoved(this.getDomainFolder(), folderName);
                    }
                } else if (this.folderList.add(folderName)) {
                    this.listener.domainFolderAdded(folderData.getDomainFolder());
                }
            }
        }
    }

    private void folderRemoved(String folderName) {
        GhidraFolderData folderData = this.folderDataCache.remove(folderName);
        if (folderData != null) {
            folderData.dispose();
        }
        if (this.visited && this.folderList.remove(folderName)) {
            this.listener.domainFolderRemoved(this.getDomainFolder(), folderName);
        }
    }

    void dispose() {
        this.visited = false;
        this.folderList.clear();
        for (GhidraFolderData folderData : this.folderDataCache.values()) {
            folderData.dispose();
        }
        this.folderDataCache.clear();
        for (GhidraFileData fileData : this.fileDataCache.values()) {
            fileData.dispose();
        }
        this.fileDataCache.clear();
    }

    private void updateExistenceState() throws IOException {
        this.folderExists = this.fileSystem.folderExists(this.getPathname());
        this.versionedFolderExists = this.versionedFileSystem.isOnline() && this.versionedFileSystem.folderExists(this.getPathname());
    }

    private void refreshFolders(boolean recursive, boolean notifyAdd, TaskMonitor monitor) throws IOException {
        GhidraFolderData folderData;
        String[] folders;
        String path = this.getPathname();
        HashSet<String> newSet = new HashSet<String>();
        if (this.folderExists) {
            try {
                folders = this.fileSystem.getFolderNames(path);
                newSet.addAll(Arrays.asList(folders));
            }
            catch (IOException e) {
                if (this.parent != null) {
                    this.parent.folderRemoved(this.name);
                }
                throw e;
            }
        }
        if (this.versionedFolderExists) {
            try {
                folders = this.versionedFileSystem.getFolderNames(path);
                newSet.addAll(Arrays.asList(folders));
            }
            catch (Exception e) {
                Msg.error((Object)this, (Object)("versioned folder refresh failed: " + e.getMessage()));
                this.versionedFolderExists = false;
            }
        }
        HashSet<String> oldSet = new HashSet<String>();
        for (String folder : this.folderList) {
            oldSet.add(folder);
        }
        HashSet oldSetClone = new HashSet(oldSet);
        oldSet.removeAll(newSet);
        for (String folderName : oldSet) {
            folderData = this.folderDataCache.remove(folderName);
            if (folderData != null) {
                folderData.dispose();
            }
            this.folderList.remove(folderName);
            if (!this.visited) continue;
            this.listener.domainFolderRemoved(this.getDomainFolder(), folderName);
        }
        if (recursive) {
            for (String folderName : this.folderList) {
                if (monitor != null && monitor.isCancelled()) break;
                folderData = this.folderDataCache.get(folderName);
                if (folderData == null || !folderData.visited) continue;
                folderData.refresh(true, true, monitor);
            }
        }
        newSet.removeAll(oldSetClone);
        for (String folderName : newSet) {
            folderData = this.addFolderData(folderName);
            if (folderData == null) continue;
            this.folderList.add(folderName);
            if (!notifyAdd) continue;
            this.listener.domainFolderAdded(folderData.getDomainFolder());
        }
    }

    private <T extends FolderItem> Map<String, T> itemMapOf(T[] items) {
        HashMap<String, T> map = new HashMap<String, T>();
        int badItemCount = 0;
        int nullNameCount = 0;
        int unknownItemCount = 0;
        for (T item : items) {
            if (item == null) {
                ++badItemCount;
                continue;
            }
            String itemName = item.getName();
            if (itemName == null) {
                ++nullNameCount;
                continue;
            }
            if (item instanceof UnknownFolderItem) {
                UnknownFolderItem unk = (UnknownFolderItem)item;
                if (unk.getFileType() == -1) {
                    ++badItemCount;
                    continue;
                }
                Msg.error((Object)this, (Object)("Unsupported folder item encountered (" + unk.getFileType() + "): " + this.getPathname(item.getName())));
                ++unknownItemCount;
            }
            map.put(itemName, item);
        }
        if (badItemCount != 0) {
            Msg.error((Object)this, (Object)("Project folder contains " + badItemCount + " bad items: " + this.getPathname()));
        }
        if (nullNameCount != 0) {
            Msg.error((Object)this, (Object)("Project folder contains " + nullNameCount + " null items: " + this.getPathname()));
        }
        if (unknownItemCount != 0) {
            Msg.error((Object)this, (Object)("Project folder contains " + unknownItemCount + " unsupported items: " + this.getPathname()));
        }
        return map;
    }

    private void refreshFiles(boolean notifyAdd, TaskMonitor monitor) throws IOException {
        String path = this.getPathname();
        Map localItemMap = Map.of();
        Map versionedItemMap = Map.of();
        HashSet newSet = new HashSet();
        if (this.folderExists) {
            try {
                localItemMap = this.itemMapOf((FolderItem[])this.fileSystem.getItems(path));
                newSet.addAll(localItemMap.keySet());
            }
            catch (IOException e) {
                if (this.parent != null) {
                    this.parent.folderRemoved(this.name);
                }
                throw e;
            }
        }
        if (this.versionedFolderExists) {
            try {
                versionedItemMap = this.itemMapOf(this.versionedFileSystem.getItems(path));
                newSet.addAll(versionedItemMap.keySet());
            }
            catch (Exception e) {
                Msg.error((Object)this, (Object)("versioned folder refresh failed: " + e.getMessage()));
                this.versionedFolderExists = false;
            }
        }
        HashSet<String> oldSet = new HashSet<String>();
        for (String file : this.fileDataCache.keySet()) {
            oldSet.add(file);
        }
        HashSet oldSetClone = new HashSet(oldSet);
        oldSet.removeAll(newSet);
        for (String fileName : oldSet) {
            this.fileRemoved(fileName);
        }
        for (GhidraFileData fileData : this.fileDataCache.values()) {
            String fileName = fileData.getName();
            LocalFolderItem localFolderItem = (LocalFolderItem)localItemMap.get(fileName);
            FolderItem versionedFolderItem = (FolderItem)versionedItemMap.get(fileName);
            if (localFolderItem == null && versionedFolderItem == null) {
                this.fileRemoved(fileName);
                continue;
            }
            fileData.refresh((LocalFolderItem)localItemMap.get(fileName), (FolderItem)versionedItemMap.get(fileName));
        }
        newSet.removeAll(oldSetClone);
        for (String fileName : newSet) {
            if (monitor != null && monitor.isCancelled()) break;
            LocalFolderItem localFolderItem = (LocalFolderItem)localItemMap.get(fileName);
            FolderItem versionedFolderItem = (FolderItem)versionedItemMap.get(fileName);
            GhidraFileData fileData = this.addFileData(fileName, localFolderItem, versionedFolderItem);
            if (!notifyAdd) continue;
            this.listener.domainFileAdded(fileData.getDomainFile());
        }
    }

    private void fileRemoved(String filename) {
        String fileID = null;
        GhidraFileData fileData = this.fileDataCache.remove(filename);
        if (fileData != null) {
            fileID = fileData.getFileID();
            fileData.dispose();
        }
        if (this.visited) {
            this.listener.domainFileRemoved(this.getDomainFolder(), filename, fileID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void refresh(boolean recursive, boolean force, TaskMonitor monitor) throws IOException {
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            if (recursive && !force) {
                throw new IllegalArgumentException("force must be true when recursive");
            }
            if (monitor != null && monitor.isCancelled()) {
                return;
            }
            if (this.visited && !force) {
                return;
            }
            boolean notifyAdd = this.visited;
            this.visited = true;
            try {
                this.updateExistenceState();
            }
            catch (IOException e) {
                if (this.parent != null) {
                    this.parent.folderRemoved(this.name);
                }
                throw e;
            }
            if (!this.folderExists && !this.versionedFolderExists) {
                if (this.parent != null) {
                    this.parent.folderRemoved(this.name);
                }
                throw new FileNotFoundException("Folder not found: " + this.getPathname());
            }
            this.refreshFiles(notifyAdd, monitor);
            if (monitor != null && monitor.isCancelled()) {
                return;
            }
            this.refreshFolders(recursive, notifyAdd, monitor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean containsFolder(String folderName) throws IOException {
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            if (this.folderDataCache.containsKey(folderName)) {
                return true;
            }
            if (this.visited) {
                return this.folderList.contains(folderName);
            }
            return this.addFolderData(folderName) != null;
        }
    }

    private GhidraFolderData addFolderData(String folderName) {
        GhidraFolderData folderData = this.folderDataCache.get(folderName);
        if (folderData == null) {
            try {
                folderData = new GhidraFolderData(this, folderName);
                this.folderDataCache.put(folderName, folderData);
                if (folderData.mustVisit()) {
                    folderData.refresh(false, true, TaskMonitor.DUMMY);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return folderData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    GhidraFolderData getFolderData(String folderName, boolean lazy) {
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            try {
                if (lazy || this.containsFolder(folderName)) {
                    GhidraFolderData folderData = this.folderDataCache.get(folderName);
                    if (folderData == null) {
                        folderData = this.addFolderData(folderName);
                    }
                    return folderData;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsFile(String fileName) throws IOException {
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            if (this.fileDataCache.containsKey(fileName)) {
                return true;
            }
            if (this.visited) {
                return false;
            }
            return this.addFileData(fileName) != null;
        }
    }

    private GhidraFileData addFileData(String fileName) throws IOException {
        GhidraFileData fileData = this.fileDataCache.get(fileName);
        if (fileData == null) {
            try {
                fileData = new GhidraFileData(this, fileName);
                this.fileDataCache.put(fileName, fileData);
                this.projectData.updateFileIndex(fileData);
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        return fileData;
    }

    private GhidraFileData addFileData(String fileName, LocalFolderItem folderItem, FolderItem versionedFolderItem) {
        GhidraFileData fileData = new GhidraFileData(this, fileName, folderItem, versionedFolderItem);
        this.fileDataCache.put(fileName, fileData);
        this.projectData.updateFileIndex(fileData);
        return fileData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    GhidraFileData getFileData(String fileName, boolean lazy) throws IOException {
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            if (lazy || this.containsFile(fileName)) {
                GhidraFileData fileData = this.fileDataCache.get(fileName);
                if (fileData == null) {
                    fileData = this.addFileData(fileName);
                }
                return fileData;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    GhidraFile getDomainFile(String fileName) {
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            try {
                if (this.containsFile(fileName)) {
                    return new GhidraFile(this.getDomainFolder(), fileName);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    GhidraFolder getDomainFolder(String subfolderName) {
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            try {
                if (this.containsFolder(subfolderName)) {
                    return new GhidraFolder(this.getDomainFolder(), subfolderName);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    GhidraFolder getDomainFolder() {
        return new GhidraFolder(this.parent.getDomainFolder(), this.name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    GhidraFile createFile(String fileName, DomainObject obj, TaskMonitor monitor) throws InvalidNameException, IOException, CancelledException {
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            GhidraFile ghidraFile;
            if (this.fileSystem.isReadOnly()) {
                throw new AssertException("createFile permitted within writeable project only");
            }
            DomainObjectAdapter doa = (DomainObjectAdapter)obj;
            if (doa.isClosed()) {
                throw new ClosedException();
            }
            if (!doa.lock(null)) {
                throw new IOException("Object is busy and can not be saved");
            }
            DomainFile oldDf = doa.getDomainFile();
            try {
                ContentHandler<?> ch = DomainObjectAdapter.getContentHandler(doa);
                ch.createFile((FileSystem)this.fileSystem, null, this.getPathname(), fileName, obj, monitor);
                if (oldDf != null) {
                    this.listener.domainFileObjectClosed(oldDf, doa);
                }
                this.fileChanged(fileName);
                GhidraFile file = this.getDomainFile(fileName);
                if (file == null) {
                    throw new IOException("File creation failed for unknown reason");
                }
                this.projectData.setDomainObject(file.getPathname(), doa);
                doa.setDomainFile(file);
                doa.setChanged(false);
                this.projectData.trackDomainFileInUse(doa);
                this.listener.domainFileObjectOpenedForUpdate(file, doa);
                ghidraFile = file;
            }
            catch (Throwable throwable) {
                doa.unlock();
                throw throwable;
            }
            doa.unlock();
            return ghidraFile;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    GhidraFile createFile(String fileName, File packFile, TaskMonitor monitor) throws InvalidNameException, IOException, CancelledException {
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            if (this.fileSystem.isReadOnly()) {
                throw new AssertException("createFile permitted within writeable project only");
            }
            this.fileSystem.createFile(this.getPathname(), fileName, packFile, monitor, SystemUtilities.getUserName());
            this.fileChanged(fileName);
            GhidraFile file = this.getDomainFile(fileName);
            if (file == null) {
                throw new IOException("File creation failed for unknown reason");
            }
            return file;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    GhidraFolderData createFolder(String folderName) throws InvalidNameException, IOException {
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            if (this.fileSystem.isReadOnly()) {
                throw new AssertException("createFile permitted within writeable project only");
            }
            this.checkFolderLinkConflict(folderName);
            this.fileSystem.createFolder(this.getPathname(), folderName);
            this.folderChanged(folderName);
            if (!this.containsFolder(folderName)) {
                throw new IOException("Folder creation failed for unknown reason");
            }
            return this.folderDataCache.get(folderName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void delete() throws IOException {
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            if (this.fileSystem.isReadOnly()) {
                throw new AssertException("delete permitted within writeable project only");
            }
            if (this.parent == null) {
                throw new IOException("root folder may not be deleted");
            }
            this.checkInUse();
            try {
                this.fileSystem.deleteFolder(this.getPathname());
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
            this.parent.folderChanged(this.name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deleteLocalFolderIfEmpty() {
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            try {
                String path = this.getPathname();
                if (this.fileSystem.getFolderNames(path).length != 0) {
                    return;
                }
                if (this.fileSystem.getItemNames(path, false).length != 0) {
                    return;
                }
                this.delete();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    GhidraFolder moveTo(GhidraFolderData newParent) throws IOException {
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            if (newParent.getLocalFileSystem() != this.fileSystem || this.fileSystem.isReadOnly()) {
                throw new IOException("moveTo permitted within writeable project only");
            }
            if (this.parent == null) {
                throw new IOException("root folder may not be moved");
            }
            if (this.getPathname().equals(newParent.getPathname())) {
                throw new IllegalArgumentException("new parent must differ from current parent: " + String.valueOf(newParent));
            }
            this.checkInUse();
            if (newParent.containsFolder(this.name)) {
                throw new DuplicateFileException("Folder named " + this.name + " already exists in " + String.valueOf(newParent));
            }
            newParent.checkFolderLinkConflict(this.name);
            this.updateExistenceState();
            try {
                if (this.folderExists) {
                    this.fileSystem.moveFolder(this.parent.getPathname(), this.name, newParent.getPathname());
                }
                if (this.versionedFolderExists) {
                    try {
                        this.versionedFileSystem.moveFolder(this.parent.getPathname(), this.name, newParent.getPathname());
                    }
                    catch (IOException e) {
                        if (this.folderExists) {
                            this.fileSystem.moveFolder(newParent.getPathname(), this.name, this.parent.getPathname());
                        }
                        throw e;
                    }
                }
                GhidraFolder oldParent = this.parent.getDomainFolder();
                if (this.parent.visited) {
                    this.parent.folderList.remove(this.name);
                }
                this.parent.folderDataCache.remove(this.name);
                if (newParent.visited) {
                    newParent.folderList.add(this.name);
                }
                newParent.folderDataCache.put(this.name, this);
                this.parent = newParent;
                GhidraFolder newFolder = this.getDomainFolder();
                if (this.parent.visited || newParent.visited) {
                    this.refresh(true, true, this.projectData.getProjectDisposalMonitor());
                    this.listener.domainFolderMoved(newFolder, oldParent);
                }
                return newFolder;
            }
            catch (InvalidNameException e) {
                throw new AssertException("Unexpected error", (Throwable)e);
            }
        }
    }

    boolean isAncestor(GhidraFolderData folderData) {
        if (!this.hasSameProjectOrRepository(folderData)) {
            return false;
        }
        for (GhidraFolderData checkParent = folderData; checkParent != null; checkParent = checkParent.getParentData()) {
            if (!checkParent.equals(this)) continue;
            return true;
        }
        return false;
    }

    boolean hasSameProjectOrRepository(GhidraFolderData folderData) {
        if (folderData.projectData.getProjectLocator().equals(this.projectData.getProjectLocator())) {
            return true;
        }
        RepositoryAdapter myRepository = this.projectData.getRepository();
        RepositoryAdapter otherRepository = folderData.projectData.getRepository();
        return myRepository != null && otherRepository != null && myRepository.getServerInfo().equals((Object)otherRepository.getServerInfo()) && myRepository.getName().equals(otherRepository.getName());
    }

    boolean isSame(GhidraFolderData folderData) {
        if (!this.hasSameProjectOrRepository(folderData)) {
            return false;
        }
        return this.getPathname().equals(folderData.getPathname());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    GhidraFolder copyTo(GhidraFolderData newParent, TaskMonitor monitor) throws IOException, CancelledException {
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            if (newParent.fileSystem.isReadOnly()) {
                throw new ReadOnlyException("copyTo permitted to writeable project only");
            }
            if (this.isAncestor(newParent)) {
                throw new IOException("self-referencing copy not permitted");
            }
            String folderName = this.getName();
            GhidraFolderData newFolderData = newParent.getFolderData(folderName, false);
            if (newFolderData == null) {
                try {
                    newFolderData = newParent.createFolder(folderName);
                }
                catch (InvalidNameException e) {
                    throw new AssertException("Unexpected error", (Throwable)e);
                }
            } else if (this.isSame(newFolderData)) {
                throw new IOException("self-referencing copy not permitted");
            }
            List<String> files = this.getFileNames();
            for (String file : files) {
                monitor.checkCancelled();
                GhidraFileData fileData = this.getFileData(file, false);
                if (fileData == null) continue;
                fileData.copyTo(newFolderData, monitor);
            }
            List<String> folders = this.getFolderNames();
            for (String folder : folders) {
                monitor.checkCancelled();
                GhidraFolderData folderData = this.getFolderData(folder, false);
                if (folderData == null) continue;
                folderData.copyTo(newFolderData, monitor);
            }
            return newFolderData.getDomainFolder();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DomainFile copyToAsLink(GhidraFolderData newParent, boolean relative) throws IOException {
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            String linkFilename = this.name;
            if (linkFilename == null) {
                linkFilename = this.projectData instanceof TransientProjectData ? this.projectData.getRepository().getName() : this.projectData.getProjectLocator().getName();
            }
            return newParent.createLinkFile(this.projectData, this.getPathname(), relative, linkFilename, FolderLinkContentHandler.INSTANCE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DomainFile createLinkFile(ProjectData sourceProjectData, String pathname, boolean makeRelative, String linkFilename, LinkHandler<?> lh) throws IOException {
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            Object linkPath;
            if (this.fileSystem.isReadOnly()) {
                throw new ReadOnlyException("createLinkFile permitted to writeable project only");
            }
            boolean referenceMyProject = sourceProjectData == this.projectData;
            boolean isFolderLink = lh instanceof FolderLinkContentHandler;
            if (!((String)pathname).startsWith(FileSystem.SEPARATOR)) {
                throw new IllegalArgumentException("invalid absolute pathname specified: " + (String)pathname);
            }
            if (isFolderLink) {
                if (!referenceMyProject && !((String)pathname).endsWith(FileSystem.SEPARATOR)) {
                    pathname = (String)pathname + FileSystem.SEPARATOR;
                }
            } else if (((String)pathname).endsWith(FileSystem.SEPARATOR) || ((String)pathname).endsWith("/.") || ((String)pathname).endsWith("/..")) {
                throw new IllegalArgumentException("invalid file pathname specified: " + (String)pathname);
            }
            pathname = FileSystem.normalizePath((String)pathname);
            if (referenceMyProject) {
                linkPath = makeRelative ? GhidraFolderData.getRelativePath((String)pathname, this.getPathname(), isFolderLink) : pathname;
            } else if (sourceProjectData instanceof TransientProjectData) {
                RepositoryAdapter repository = sourceProjectData.getRepository();
                ServerInfo serverInfo = repository.getServerInfo();
                URL ghidraUrl = GhidraURL.makeURL(serverInfo.getServerName(), serverInfo.getPortNumber(), repository.getName(), (String)pathname);
                linkPath = ghidraUrl.toExternalForm();
            } else {
                ProjectLocator projectLocator = sourceProjectData.getProjectLocator();
                if (projectLocator.equals(this.projectData.getProjectLocator())) {
                    return null;
                }
                URL ghidraUrl = GhidraURL.makeURL(projectLocator, (String)pathname, null);
                linkPath = ghidraUrl.toExternalForm();
            }
            String newName = this.getUniqueName(linkFilename);
            try {
                lh.createLink((String)linkPath, this.fileSystem, this.getPathname(), newName);
            }
            catch (InvalidNameException e) {
                throw new IOException(e);
            }
            this.fileChanged(newName);
            return this.getDomainFile(newName);
        }
    }

    DomainFile createLinkFile(String ghidraUrl, String linkFilename, LinkHandler<?> lh) throws IOException {
        URL url = new URL(ghidraUrl);
        if (!GhidraURL.isLocalGhidraURL(ghidraUrl) && !GhidraURL.isServerRepositoryURL(url)) {
            throw new IllegalArgumentException("Invalid Ghidra URL specified");
        }
        String newName = this.getUniqueName(linkFilename);
        try {
            lh.createLink(ghidraUrl, this.fileSystem, this.getPathname(), newName);
        }
        catch (InvalidNameException e) {
            throw new IOException(e);
        }
        this.fileChanged(newName);
        return this.getDomainFile(newName);
    }

    private String getUniqueName(String name) throws IOException {
        Object newName = name;
        int i = 1;
        while (this.getFileData((String)newName, false) != null || this.getFolderData((String)newName, false) != null) {
            newName = name + "." + i;
            ++i;
        }
        return newName;
    }

    static String getRelativePath(String normalizedReferencedPathname, String linkParentPathname, boolean isFolderRef) throws IllegalArgumentException {
        int lastSepIx;
        String finalRefElement = null;
        if (!isFolderRef && !normalizedReferencedPathname.endsWith(FileSystem.SEPARATOR) && (lastSepIx = normalizedReferencedPathname.lastIndexOf(FileSystem.SEPARATOR)) != 0) {
            finalRefElement = normalizedReferencedPathname.substring(lastSepIx + 1);
            normalizedReferencedPathname = normalizedReferencedPathname.substring(0, lastSepIx);
        }
        Path referencedPath = Paths.get(normalizedReferencedPathname, new String[0]);
        Path linkParentPath = Paths.get(linkParentPathname, new String[0]);
        Path relativePath = linkParentPath.relativize(referencedPath);
        Object path = relativePath.toString();
        if (finalRefElement != null) {
            if (!((String)path).isBlank()) {
                path = (String)path + FileSystem.SEPARATOR;
            }
            path = (String)path + finalRefElement;
        }
        if (((String)path).isBlank()) {
            return ".";
        }
        if (normalizedReferencedPathname.endsWith(FileSystem.SEPARATOR) && !((String)path).endsWith(FileSystem.SEPARATOR)) {
            path = (String)path + FileSystem.SEPARATOR;
        }
        return path;
    }

    String getUniqueFileName(String preferredName, boolean checkFilesAndFolders) throws IOException {
        Object newName = preferredName;
        int i = 1;
        while (this.getFileData((String)newName, false) != null || checkFilesAndFolders && this.containsFolder((String)newName)) {
            newName = preferredName + "." + i;
            ++i;
        }
        return newName;
    }

    boolean privateExists() {
        return this.folderExists;
    }

    boolean sharedExists() {
        return this.versionedFolderExists;
    }

    public String toString() {
        ProjectLocator projectLocator = this.projectData.getProjectLocator();
        if (projectLocator.isTransient()) {
            return this.projectData.getProjectLocator().getName() + this.getPathname();
        }
        return this.projectData.getProjectLocator().getName() + ":" + this.getPathname();
    }
}

