/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.opinion;

import java.io.IOException;
import java.util.StringTokenizer;

class DefExportLine {
    private String name;
    private String internalName;
    private String otherModuleName;
    private String otherModuleExportedName;
    private Integer otherModuleOrdinal;
    private Integer ordinal;
    private boolean isNoName;
    private boolean isPrivate;
    private boolean isData;

    DefExportLine(String exportLine) throws IOException {
        StringTokenizer st = new StringTokenizer(exportLine);
        if (!st.hasMoreTokens()) {
            throw new IOException("Line is empty");
        }
        block10: while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (this.name == null) {
                String[] equalsParts = token.split("=", 2);
                this.name = equalsParts[0];
                if (equalsParts.length <= 1) continue;
                String[] dotParts = equalsParts[1].split("\\.", 2);
                if (dotParts.length == 1) {
                    this.internalName = equalsParts[1];
                    continue;
                }
                this.otherModuleName = dotParts[0];
                if (dotParts[1].startsWith("#")) {
                    this.otherModuleOrdinal = this.parseInt(dotParts[1].substring(1));
                    continue;
                }
                this.otherModuleExportedName = dotParts[1];
                continue;
            }
            if (this.ordinal == null && token.startsWith("@")) {
                if (!token.equals("@")) {
                    this.ordinal = this.parseInt(token.substring(1));
                    continue;
                }
                if (!st.hasMoreTokens()) continue;
                this.ordinal = this.parseInt(st.nextToken());
                continue;
            }
            switch (token) {
                case "NONAME": {
                    this.isNoName = true;
                    continue block10;
                }
                case "PRIVATE": {
                    this.isPrivate = true;
                    continue block10;
                }
                case "DATA": {
                    this.isData = true;
                    continue block10;
                }
            }
            throw new IOException("Invalid type: " + token);
        }
    }

    String getName() {
        return this.name;
    }

    String getInternalName() {
        return this.internalName;
    }

    String getOtherModuleName() {
        return this.otherModuleName;
    }

    String getOtherModuleExportedName() {
        return this.otherModuleExportedName;
    }

    Integer getOtherModuleOrdinal() {
        return this.otherModuleOrdinal;
    }

    Integer getOrdinal() {
        return this.ordinal;
    }

    boolean isNoName() {
        return this.isNoName;
    }

    boolean isPrivate() {
        return this.isPrivate;
    }

    boolean isData() {
        return this.isData;
    }

    private int parseInt(String str) throws IOException {
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            throw new IOException(e);
        }
    }
}

