/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.macho.relocation;

import ghidra.app.util.bin.format.RelocationException;
import ghidra.app.util.bin.format.macho.MachHeader;
import ghidra.app.util.bin.format.macho.RelocationInfo;
import ghidra.app.util.bin.format.macho.relocation.MachoRelocation;
import ghidra.program.model.address.Address;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.reloc.RelocationResult;
import ghidra.util.classfinder.ExtensionPoint;

public abstract class MachoRelocationHandler
implements ExtensionPoint {
    public abstract boolean canRelocate(MachHeader var1);

    public abstract boolean isPairedRelocation(RelocationInfo var1);

    public abstract RelocationResult relocate(MachoRelocation var1) throws MemoryAccessException, RelocationException;

    public static long read(MachoRelocation relocation) throws MemoryAccessException {
        Memory mem = relocation.getProgram().getMemory();
        int len = relocation.getRelocationInfo().getLength();
        Address addr = relocation.getRelocationAddress();
        if (len == 3) {
            return mem.getLong(addr);
        }
        if (len == 2) {
            return mem.getInt(addr);
        }
        if (len == 1) {
            return mem.getShort(addr);
        }
        return mem.getByte(addr);
    }

    public static int write(MachoRelocation relocation, long value) throws MemoryAccessException {
        Memory mem = relocation.getProgram().getMemory();
        Address addr = relocation.getRelocationAddress();
        switch (relocation.getRelocationInfo().getLength()) {
            case 3: {
                mem.setLong(addr, value);
                return 8;
            }
            case 2: {
                mem.setInt(addr, (int)value);
                return 4;
            }
            case 1: {
                mem.setShort(addr, (short)value);
                return 2;
            }
        }
        mem.setByte(addr, (byte)value);
        return 1;
    }
}

