/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.services;

import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginDescription;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import ghidra.util.HelpLocation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public interface StringTranslationService {
    public static List<StringTranslationService> getCurrentStringTranslationServices(PluginTool tool) {
        ArrayList<StringTranslationService> translationServices = new ArrayList<StringTranslationService>(List.of((StringTranslationService[])tool.getServices(StringTranslationService.class)));
        Collections.sort(translationServices, (s1, s2) -> s1.getTranslationServiceName().compareTo(s2.getTranslationServiceName()));
        return translationServices;
    }

    public String getTranslationServiceName();

    default public HelpLocation getHelpLocation() {
        return null;
    }

    public void translate(Program var1, List<ProgramLocation> var2, TranslateOptions var3);

    public static HelpLocation createStringTranslationServiceHelpLocation(Class<? extends Plugin> pluginClass, StringTranslationService sts) {
        return new HelpLocation(PluginDescription.getPluginDescription(pluginClass).getName(), sts.getTranslationServiceName() + "_String_Translation_Service");
    }

    public record TranslateOptions(boolean autoTranslate) {
        public static TranslateOptions NONE = new TranslateOptions(false);
    }
}

