/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.datamgr.actions;

import docking.ActionContext;
import docking.action.MenuData;
import docking.action.ToggleDockingAction;
import docking.widgets.tree.GTree;
import docking.widgets.tree.GTreeNode;
import ghidra.app.plugin.core.datamgr.DataTypeManagerPlugin;
import ghidra.app.plugin.core.datamgr.DataTypesActionContext;
import ghidra.app.plugin.core.datamgr.tree.DataTypeNode;
import ghidra.program.model.data.DataType;
import ghidra.util.HelpLocation;
import javax.swing.tree.TreePath;

public class SetFavoriteDataTypeAction
extends ToggleDockingAction {
    public SetFavoriteDataTypeAction(DataTypeManagerPlugin plugin) {
        super("Set Favorite Data Type", plugin.getName());
        this.setSelected(false);
        this.setPopupMenuData(new MenuData(new String[]{"Favorite"}, null, "VeryLast"));
        this.setHelpLocation(new HelpLocation("DataPlugin", "Favorites"));
        this.setEnabled(true);
    }

    public boolean isEnabledForContext(ActionContext context) {
        if (!(context instanceof DataTypesActionContext)) {
            return false;
        }
        Object contextObject = context.getContextObject();
        GTree gTree = (GTree)contextObject;
        TreePath[] selectionPaths = gTree.getSelectionPaths();
        if (selectionPaths.length == 0) {
            return false;
        }
        for (TreePath path : selectionPaths) {
            GTreeNode node = (GTreeNode)path.getLastPathComponent();
            if (node instanceof DataTypeNode) continue;
            return false;
        }
        boolean isFavorite = ((DataTypeNode)((Object)selectionPaths[0].getLastPathComponent())).isFavorite();
        for (TreePath path : selectionPaths) {
            DataTypeNode dataTypeNode = (DataTypeNode)((Object)path.getLastPathComponent());
            if (isFavorite == dataTypeNode.isFavorite()) continue;
            return false;
        }
        this.setSelected(isFavorite);
        return true;
    }

    public void actionPerformed(ActionContext context) {
        TreePath[] selectionPaths;
        GTree gTree = (GTree)context.getContextObject();
        for (TreePath path : selectionPaths = gTree.getSelectionPaths()) {
            DataTypeNode node = (DataTypeNode)((Object)path.getLastPathComponent());
            this.toggleFavorite(node, this.isSelected());
        }
    }

    private void toggleFavorite(DataTypeNode node, boolean isFavorite) {
        DataType dataType = node.getDataType();
        dataType.getDataTypeManager().setFavorite(dataType, isFavorite);
    }
}

