/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.table.constrainteditor;

import docking.widgets.table.constraint.ColumnConstraint;
import docking.widgets.table.constraint.SingleValueColumnConstraint;
import docking.widgets.table.constraint.provider.DateColumnConstraintProvider;
import docking.widgets.table.constrainteditor.AbstractColumnConstraintEditor;
import docking.widgets.table.constrainteditor.DateSpinner;
import docking.widgets.table.constrainteditor.LocalDateSpinnerModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import javax.swing.JPanel;

public class DateValueConstraintEditor
extends AbstractColumnConstraintEditor<LocalDate> {
    public static final String DATE_PATTERN = "MM/dd/yyyy";
    public static final DateTimeFormatter LOCAL_DATE_FORMAT = DateTimeFormatter.ofPattern("MM/dd/yyyy");
    private final ZonedDateTime now = ZonedDateTime.now(ZoneId.systemDefault());
    private final LocalDate minDate = LocalDate.of(this.now.getYear(), 1, 1).minusYears(30L);
    private final LocalDate maxDate = LocalDate.of(this.now.getYear(), 12, 31).plusYears(30L);
    private DateSpinner dateSpinner;
    private LocalDateSpinnerModel spinnerModel;

    public DateValueConstraintEditor(ColumnConstraint<LocalDate> constraint) {
        super(constraint);
    }

    @Override
    protected Component buildInlineEditorComponent() {
        JPanel panel = new JPanel(new BorderLayout());
        LocalDate value = this.getConstraint().getConstraintValue();
        if (!DateValueConstraintEditor.isValidDate(value)) {
            value = LocalDate.now();
        }
        this.spinnerModel = new LocalDateSpinnerModel(value, this.minDate, this.maxDate, 5);
        this.dateSpinner = new DateSpinner(this.spinnerModel, DATE_PATTERN);
        this.spinnerModel.addChangeListener(e -> this.valueChanged());
        panel.add(this.dateSpinner.getSpinner());
        return panel;
    }

    private static boolean isValidDate(LocalDate date) {
        if (date == null) {
            return false;
        }
        if (date == DateColumnConstraintProvider.DEFAULT_DATE) {
            return false;
        }
        return date.toEpochDay() != DateColumnConstraintProvider.DEFAULT_DATE.toEpochDay();
    }

    @Override
    public ColumnConstraint<LocalDate> getValueFromComponent() {
        LocalDate spinnerDate;
        LocalDate spinnerLocalDate = spinnerDate = this.spinnerModel.getDate();
        return this.getConstraint().copy(spinnerLocalDate);
    }

    @Override
    protected void updateEditorComponent() {
        LocalDate constraintValue;
        if (this.hasEditorComponents() && (constraintValue = this.getConstraint().getConstraintValue()) instanceof LocalDate) {
            LocalDate constraintDate = constraintValue;
            this.spinnerModel.setValue(constraintDate);
        }
    }

    @Override
    public void reset() {
        this.setValue(this.getConstraint().copy(LocalDate.now()));
    }

    @Override
    protected boolean checkEditorValueValidity() {
        return true;
    }

    @Override
    protected void updateInfoMessage(boolean isValid) {
    }

    @Override
    public String getErrorMessage() {
        return "";
    }

    private SingleValueColumnConstraint<LocalDate> getConstraint() {
        return (SingleValueColumnConstraint)this.currentConstraint;
    }
}

