/*
 * Decompiled with CFR 0.152.
 */
package docking.util.image;

import generic.util.image.ImageUtils;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.SwingUtilities;

public class CalloutInfo {
    private Rectangle clientShape;
    private Component source;
    private Component destination;
    private double magnification = 2.0;

    public CalloutInfo(Component destinationComponent, Component sourceComponent) {
        this(destinationComponent, sourceComponent, sourceComponent.getBounds());
    }

    public CalloutInfo(Component destinationComponent, Component sourceComponent, Rectangle clientShape) {
        this.destination = destinationComponent;
        this.source = sourceComponent;
        this.clientShape = clientShape;
    }

    public void setMagnification(double magnification) {
        this.magnification = magnification;
    }

    public double getMagnification() {
        return this.magnification;
    }

    public void moveToImage(Rectangle r, ImageUtils.Padding padding) {
        this.moveToDestination(r);
        r.x += padding.left();
        r.y += padding.top();
    }

    public void moveToDestination(Rectangle r) {
        Point oldPoint = r.getLocation();
        Point newPoint = SwingUtilities.convertPoint(this.source.getParent(), oldPoint, this.destination);
        r.setLocation(newPoint);
    }

    public void moveToScreen(Rectangle r) {
        Point p = r.getLocation();
        SwingUtilities.convertPointToScreen(p, this.source.getParent());
        r.setLocation(p);
    }

    public Rectangle getBounds() {
        return new Rectangle(this.clientShape);
    }
}

