/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.bookmarks.mindmapmode.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.DropTarget;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JList;
import javax.swing.LayoutFocusTraversalPolicy;
import javax.swing.border.Border;
import javax.swing.border.EtchedBorder;
import javax.swing.plaf.ToolBarUI;
import org.freeplane.core.ui.components.FreeplaneToolBar;
import org.freeplane.core.ui.components.ToolbarLayout;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.features.bookmarks.mindmapmode.BookmarksController;
import org.freeplane.features.bookmarks.mindmapmode.ui.BookmarkClipboardHandler;
import org.freeplane.features.bookmarks.mindmapmode.ui.BookmarkDropTargetListener;
import org.freeplane.features.bookmarks.mindmapmode.ui.BookmarkIndexCalculator;
import org.freeplane.features.bookmarks.mindmapmode.ui.DropExecutor;
import org.freeplane.features.map.MapModel;

public class BookmarkToolbar
extends FreeplaneToolBar {
    private static final LayoutFocusTraversalPolicy FOCUS_TRAVERSAL_POLICY = new LayoutFocusTraversalPolicy();
    static final int GAP;
    private static final long serialVersionUID = 1L;
    private static final Border TOOLBAR_BORDER;
    private final BookmarkIndexCalculator indexCalculator;
    private Component targetComponent;
    private DropIndicatorType indicatorType = DropIndicatorType.NONE;
    private final BookmarkClipboardHandler clipboardHandler;
    private final DropExecutor dropExecutor;
    private MapModel map;

    public BookmarkToolbar(BookmarksController bookmarksController, MapModel map) {
        super(2);
        this.map = map;
        ToolbarLayout layout = (ToolbarLayout)this.getLayout();
        layout.setGap(GAP, 0, true, false);
        this.setDisablesFocus(false);
        this.setFocusable(true);
        this.setFocusCycleRoot(true);
        LayoutFocusTraversalPolicy policy = FOCUS_TRAVERSAL_POLICY;
        this.setFocusTraversalPolicy(policy);
        this.addFocusMouseListener();
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                BookmarkToolbar.this.repaint();
            }

            @Override
            public void focusGained(FocusEvent e) {
                BookmarkToolbar.this.repaint();
            }
        });
        this.indexCalculator = new BookmarkIndexCalculator(this);
        this.dropExecutor = new DropExecutor(this, bookmarksController);
        this.clipboardHandler = new BookmarkClipboardHandler(bookmarksController, this.dropExecutor);
        new DropTarget((Component)((Object)this), 3, new BookmarkDropTargetListener(this, bookmarksController));
        this.clipboardHandler.setupToolbarClipboardActions(this);
    }

    public MapModel getMap() {
        return this.map;
    }

    public void setMap(MapModel map) {
        this.map = map;
    }

    public BookmarkClipboardHandler getClipboardHandler() {
        return this.clipboardHandler;
    }

    private void addFocusMouseListener() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getButton() == 1) {
                    BookmarkToolbar.this.handleFocusOnClick(e.getPoint());
                }
            }
        });
    }

    private void handleFocusOnClick(Point clickPoint) {
        if (this.getComponentCount() == 0) {
            this.requestFocusInWindow();
        } else if (this.indexCalculator != null) {
            BookmarkIndexCalculator.ToolbarDropPosition position = this.indexCalculator.calculateToolbarDropPosition(clickPoint);
            Component componentToFocus = this.getComponentToFocus(position);
            if (componentToFocus != null) {
                componentToFocus.requestFocusInWindow();
            } else {
                this.requestFocusInWindow();
            }
        }
    }

    private Component getComponentToFocus(BookmarkIndexCalculator.ToolbarDropPosition position) {
        if (position.buttonIndex >= 0 && (position.type == BookmarkIndexCalculator.ToolbarDropPosition.Type.BEFORE_BUTTON && position.buttonIndex < this.getComponentCount() || position.type == BookmarkIndexCalculator.ToolbarDropPosition.Type.AFTER_BUTTON && position.buttonIndex < this.getComponentCount() - 1)) {
            return this.getComponent(position.buttonIndex);
        }
        return this;
    }

    public void setUI(ToolBarUI ui) {
        super.setUI(ui);
        this.setBorder(TOOLBAR_BORDER);
        Insets borderInsets = TOOLBAR_BORDER.getBorderInsets((Component)((Object)this));
        this.setMinimumSize(new Dimension(2 * GAP + borderInsets.left + borderInsets.right, 2 * GAP + borderInsets.top + borderInsets.bottom));
    }

    public void showVisualFeedback(Component button, DropIndicatorType type) {
        this.targetComponent = button;
        this.indicatorType = type;
        this.repaint();
    }

    public void clearVisualFeedback() {
        this.showVisualFeedback(null, DropIndicatorType.NONE);
    }

    public void showEndDropIndicator() {
        this.showVisualFeedback((Component)((Object)this), DropIndicatorType.END_DROP_INDICATOR);
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.targetComponent != null && this.indicatorType != DropIndicatorType.NONE) {
            g.setColor(this.targetComponent.getForeground());
            this.paintVisualFeedback(g);
        }
    }

    protected void paintBorder(Graphics g) {
        super.paintBorder(g);
        if (this.hasFocus()) {
            g.setColor(Color.BLUE);
            g.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
        }
    }

    private void paintVisualFeedback(Graphics g) {
        if (this.indicatorType == DropIndicatorType.END_DROP_INDICATOR) {
            this.paintEndDropLine(g);
        } else {
            Rectangle buttonBounds = this.targetComponent.getBounds();
            switch (this.indicatorType.ordinal()) {
                case 1: {
                    this.paintDropLine(g, buttonBounds, true);
                    break;
                }
                case 2: {
                    this.paintDropLine(g, buttonBounds, false);
                    break;
                }
                case 3: 
                case 4: {
                    this.paintHoverFeedback(g, buttonBounds);
                    break;
                }
            }
        }
    }

    private void paintDropLine(Graphics g, Rectangle buttonBounds, boolean before) {
        this.paintDropLine(g, buttonBounds, GAP, before);
    }

    private void paintDropLine(Graphics g, Rectangle buttonBounds, int lineWidth, boolean before) {
        int x = before ? buttonBounds.x - lineWidth : buttonBounds.x + buttonBounds.width;
        int y1 = buttonBounds.y + 2;
        int y2 = buttonBounds.y + buttonBounds.height - 2;
        g.fillRect(x, y1, lineWidth, y2 - y1);
    }

    private void paintHoverFeedback(Graphics g, Rectangle buttonBounds) {
        this.paintDropLine(g, buttonBounds, GAP / 2, false);
        this.paintDropLine(g, buttonBounds, GAP / 2, true);
    }

    private void paintEndDropLine(Graphics g) {
        Rectangle bounds = this.getComponent(this.getComponentCount() - 2).getBounds();
        this.paintDropLine(g, bounds, GAP, true);
    }

    public void requestInitialFocusInWindow() {
        int i = 0;
        if (i < this.getComponentCount()) {
            Component component = this.getComponent(i);
            if (component.isEnabled() && component.isFocusable()) {
                component.requestFocusInWindow();
            }
            return;
        }
        this.requestFocusInWindow();
    }

    static {
        FOCUS_TRAVERSAL_POLICY.setImplicitDownCycleTraversal(false);
        GAP = (int)(10.0f * UITools.FONT_SCALE_FACTOR);
        TOOLBAR_BORDER = new BookmarkToolbarBorder();
    }

    static enum DropIndicatorType {
        NONE,
        DROP_BEFORE,
        DROP_AFTER,
        HOVER_FEEDBACK,
        NAVIGATE_FEEDBACK,
        END_DROP_INDICATOR;

    }

    private static class BookmarkToolbarBorder
    extends EtchedBorder {
        private static final long serialVersionUID = 1L;
        private static final Color focusColor = new JList().getSelectionBackground();

        private BookmarkToolbarBorder() {
        }

        @Override
        public Color getHighlightColor(Component c) {
            return c.hasFocus() ? focusColor : super.getHighlightColor(c);
        }
    }
}

