/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.ai.chat;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import org.freeplane.core.ui.textchanger.TranslatedElementFactory;
import org.freeplane.core.util.TextUtils;
import org.freeplane.plugin.ai.chat.AIChatPanel;
import org.freeplane.plugin.ai.chat.ChatListItem;
import org.freeplane.plugin.ai.chat.ChatListItemStatus;
import org.freeplane.plugin.ai.chat.LiveChatSessionId;
import org.freeplane.plugin.ai.chat.LiveChatSessionManager;
import org.freeplane.plugin.ai.chat.LiveChatSessionSummary;
import org.freeplane.plugin.ai.chat.MapRootShortTextCountsMerger;
import org.freeplane.plugin.ai.chat.MapRootShortTextFormatter;
import org.freeplane.plugin.ai.chat.history.ChatTranscriptId;
import org.freeplane.plugin.ai.chat.history.ChatTranscriptStatus;
import org.freeplane.plugin.ai.chat.history.ChatTranscriptStore;
import org.freeplane.plugin.ai.chat.history.ChatTranscriptSummary;
import org.freeplane.plugin.ai.chat.history.MapRootShortTextCount;

class ChatListDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private static final MapRootShortTextCountsMerger MAP_COUNTS_MERGER = new MapRootShortTextCountsMerger();
    private final LiveChatSessionManager sessionManager;
    private final ChatListHandler listHandler;
    private final ChatListTableModel tableModel;
    private final JTable table;
    private final JButton openChatButton;
    private final JButton deleteChatButton;
    private final JButton closeDialogButton;

    ChatListDialog(AIChatPanel owner, LiveChatSessionManager sessionManager, ChatTranscriptStore transcriptStore, MapRootShortTextFormatter mapRootShortTextFormatter, ChatListHandler listHandler) {
        super(ChatListDialog.findOwnerWindow(owner), TextUtils.getText((String)"ai_chat_chats_dialog"), Dialog.ModalityType.DOCUMENT_MODAL);
        this.sessionManager = sessionManager;
        this.listHandler = listHandler;
        this.tableModel = new ChatListTableModel(sessionManager, transcriptStore, mapRootShortTextFormatter, listHandler, TextUtils.getText((String)"ai_chat_chats_column_name"), TextUtils.getText((String)"ai_chat_chats_column_maps"));
        this.table = new JTable(this.tableModel);
        this.table.setSelectionMode(2);
        this.table.setFillsViewportHeight(true);
        this.table.getColumnModel().getColumn(0).setPreferredWidth(24);
        this.table.getColumnModel().getColumn(1).setPreferredWidth(220);
        this.table.getColumnModel().getColumn(2).setPreferredWidth(320);
        this.table.getColumnModel().getColumn(0).setCellRenderer(new StatusIconRenderer(this.tableModel));
        this.table.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent event) {
                int column = ChatListDialog.this.table.columnAtPoint(event.getPoint());
                if (column == 1) {
                    ChatListDialog.this.table.setCursor(Cursor.getPredefinedCursor(2));
                } else {
                    ChatListDialog.this.table.setCursor(Cursor.getDefaultCursor());
                }
            }
        });
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                if (event.getClickCount() != 2 || event.getButton() != 1) {
                    return;
                }
                int row = ChatListDialog.this.table.rowAtPoint(event.getPoint());
                if (row < 0) {
                    return;
                }
                ChatListDialog.this.table.setRowSelectionInterval(row, row);
                ChatListDialog.this.openChat();
            }
        });
        this.openChatButton = TranslatedElementFactory.createButton((String)"ai_chat_chats_open");
        this.openChatButton.addActionListener(event -> this.openChat());
        this.deleteChatButton = new JButton(TextUtils.getText((String)"delete"));
        this.deleteChatButton.addActionListener(event -> this.deleteChat());
        this.closeDialogButton = TranslatedElementFactory.createButton((String)"ai_chat_chats_close");
        this.closeDialogButton.addActionListener(event -> this.closeDialog());
        this.table.getSelectionModel().addListSelectionListener(event -> this.updateButtonState());
        JScrollPane scrollPane = new JScrollPane(this.table);
        this.setLayout(new BorderLayout());
        this.add((Component)scrollPane, "Center");
        FlowLayout flowLayout = new FlowLayout(2);
        JPanel buttonPanel = new JPanel(flowLayout);
        buttonPanel.add(this.openChatButton);
        buttonPanel.add(this.deleteChatButton);
        buttonPanel.add(this.closeDialogButton);
        this.add((Component)buttonPanel, "South");
        this.setDefaultCloseOperation(2);
        this.setSize(720, 380);
        this.setLocationRelativeTo(owner);
        this.updateButtonState();
    }

    void openDialog() {
        this.refresh();
        this.selectCurrentSession();
        this.setVisible(true);
    }

    void refresh() {
        this.tableModel.refresh();
        this.selectCurrentSession();
        this.updateButtonState();
    }

    private void openChat() {
        ChatListItem item = this.tableModel.itemAt(this.table.getSelectedRow());
        if (item == null) {
            return;
        }
        if (item.getStatus() == ChatListItemStatus.LIVE) {
            this.listHandler.switchTo(item.getLiveSessionId());
            this.dispose();
        } else if (item.getStatus() == ChatListItemStatus.TRANSCRIPT) {
            this.listHandler.startChatFromTranscript(item.getTranscriptId());
            this.dispose();
        }
    }

    private void deleteChat() {
        List<ChatListItem> selectedItems = this.selectedItems();
        if (selectedItems.isEmpty()) {
            return;
        }
        DeletionTargets deletionTargets = ChatListDialog.deletionTargets(selectedItems);
        for (LiveChatSessionId liveSessionId : deletionTargets.liveSessionIds()) {
            this.listHandler.deleteLiveSession(liveSessionId);
        }
        for (ChatTranscriptId transcriptId : deletionTargets.transcriptIds()) {
            this.listHandler.deleteTranscript(transcriptId);
        }
        this.refresh();
    }

    private void selectCurrentSession() {
        int rowIndex = this.tableModel.rowIndexForSession(this.sessionManager.getCurrentSessionId());
        if (rowIndex >= 0) {
            this.table.setRowSelectionInterval(rowIndex, rowIndex);
            return;
        }
        if (this.tableModel.getRowCount() > 0 && this.table.getSelectedRow() < 0) {
            this.table.setRowSelectionInterval(0, 0);
        }
    }

    private void closeDialog() {
        this.dispose();
    }

    private static Window findOwnerWindow(AIChatPanel owner) {
        if (owner == null) {
            return null;
        }
        return SwingUtilities.getWindowAncestor(owner);
    }

    private void updateButtonState() {
        List<ChatListItem> selectedItems = this.selectedItems();
        boolean hasSelection = !selectedItems.isEmpty();
        boolean hasSingleOpenableSelection = selectedItems.size() == 1 && (selectedItems.get(0).getStatus() == ChatListItemStatus.LIVE || selectedItems.get(0).getStatus() == ChatListItemStatus.TRANSCRIPT);
        this.openChatButton.setEnabled(hasSingleOpenableSelection);
        this.deleteChatButton.setEnabled(hasSelection && ChatListDialog.hasDeletableSelection(selectedItems));
        this.closeDialogButton.setEnabled(true);
    }

    private static boolean hasDeletableSelection(List<ChatListItem> selectedItems) {
        for (ChatListItem item : selectedItems) {
            if (item.getStatus() != ChatListItemStatus.LIVE && item.getStatus() != ChatListItemStatus.TRANSCRIPT && item.getStatus() != ChatListItemStatus.ERROR) continue;
            return true;
        }
        return false;
    }

    private List<ChatListItem> selectedItems() {
        int[] selectedRows = this.table.getSelectedRows();
        ArrayList<ChatListItem> selectedItems = new ArrayList<ChatListItem>(selectedRows.length);
        for (int selectedRow : selectedRows) {
            ChatListItem item = this.tableModel.itemAt(selectedRow);
            if (item == null) continue;
            selectedItems.add(item);
        }
        return selectedItems;
    }

    static DeletionTargets deletionTargets(List<ChatListItem> items) {
        HashSet<LiveChatSessionId> liveSessionIds = new HashSet<LiveChatSessionId>();
        HashSet<ChatTranscriptId> transcriptIds = new HashSet<ChatTranscriptId>();
        for (ChatListItem item : items) {
            if (item == null) continue;
            if (item.getLiveSessionId() != null) {
                liveSessionIds.add(item.getLiveSessionId());
            }
            if (item.getTranscriptId() == null) continue;
            transcriptIds.add(item.getTranscriptId());
        }
        return new DeletionTargets(liveSessionIds, transcriptIds);
    }

    static List<MapRootShortTextCount> mergeLiveMapCounts(List<MapRootShortTextCount> cachedCounts, List<MapRootShortTextCount> freshCounts) {
        return MAP_COUNTS_MERGER.mergeByMax(cachedCounts, freshCounts);
    }

    static interface ChatListHandler {
        public void switchTo(LiveChatSessionId var1);

        public void close(LiveChatSessionId var1);

        public void deleteLiveSession(LiveChatSessionId var1);

        public void rename(LiveChatSessionId var1, String var2);

        public void renameTranscript(ChatTranscriptId var1, String var2);

        public void startChatFromTranscript(ChatTranscriptId var1);

        public void deleteTranscript(ChatTranscriptId var1);
    }

    private static class ChatListTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        private static final int COLUMN_STATUS = 0;
        private static final int COLUMN_NAME = 1;
        private static final int COLUMN_MAPS = 2;
        private final LiveChatSessionManager sessionManager;
        private final ChatTranscriptStore transcriptStore;
        private final MapRootShortTextFormatter mapRootShortTextFormatter;
        private final ChatListHandler handler;
        private List<ChatListItem> items;
        private final String nameColumnLabel;
        private final String mapsColumnLabel;

        private ChatListTableModel(LiveChatSessionManager sessionManager, ChatTranscriptStore transcriptStore, MapRootShortTextFormatter mapRootShortTextFormatter, ChatListHandler handler, String nameColumnLabel, String mapsColumnLabel) {
            this.sessionManager = sessionManager;
            this.transcriptStore = transcriptStore;
            this.mapRootShortTextFormatter = mapRootShortTextFormatter;
            this.handler = handler;
            this.nameColumnLabel = nameColumnLabel;
            this.mapsColumnLabel = mapsColumnLabel;
            this.items = new ArrayList<ChatListItem>();
            this.refresh();
        }

        @Override
        public int getRowCount() {
            return this.items.size();
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public String getColumnName(int column) {
            if (column == 1) {
                return this.nameColumnLabel;
            }
            if (column == 2) {
                return this.mapsColumnLabel;
            }
            return "";
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return Object.class;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            if (columnIndex != 1) {
                return false;
            }
            ChatListItem item = this.itemAt(rowIndex);
            return item != null && item.getStatus() != ChatListItemStatus.ERROR;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            ChatListItem item = this.items.get(rowIndex);
            if (columnIndex == 0) {
                return item.getStatus();
            }
            if (columnIndex == 1) {
                return item.getDisplayName();
            }
            if (columnIndex == 2) {
                return this.mapRootShortTextFormatter.formatCounts(item.getMapRootShortTextCounts());
            }
            return "";
        }

        @Override
        public void setValueAt(Object value, int rowIndex, int columnIndex) {
            String displayName;
            if (columnIndex != 1) {
                return;
            }
            ChatListItem item = this.itemAt(rowIndex);
            if (item == null) {
                return;
            }
            String string = displayName = value == null ? "" : value.toString().trim();
            if (displayName.isEmpty()) {
                return;
            }
            if (item.getLiveSessionId() != null) {
                this.handler.rename(item.getLiveSessionId(), displayName);
            } else if (item.getTranscriptId() != null) {
                this.handler.renameTranscript(item.getTranscriptId(), displayName);
            }
            this.refresh();
        }

        ChatListItem itemAt(int rowIndex) {
            if (rowIndex < 0 || rowIndex >= this.items.size()) {
                return null;
            }
            return this.items.get(rowIndex);
        }

        int rowIndexForSession(LiveChatSessionId sessionId) {
            if (sessionId == null) {
                return -1;
            }
            for (int index = 0; index < this.items.size(); ++index) {
                ChatListItem item = this.items.get(index);
                if (!sessionId.equals(item.getLiveSessionId())) continue;
                return index;
            }
            return -1;
        }

        void refresh() {
            this.items = this.buildItems();
            this.fireTableDataChanged();
        }

        private List<ChatListItem> buildItems() {
            ArrayList<ChatListItem> results = new ArrayList<ChatListItem>();
            HashMap<String, ChatTranscriptSummary> transcriptById = new HashMap<String, ChatTranscriptSummary>();
            LiveChatSessionId currentSessionId = this.sessionManager.getCurrentSessionId();
            for (ChatTranscriptSummary summary : this.transcriptStore.list()) {
                if (summary == null || summary.getId() == null || summary.getId().getFileName() == null) continue;
                transcriptById.put(summary.getId().getFileName(), summary);
            }
            for (LiveChatSessionSummary session : this.sessionManager.listSessions()) {
                ChatTranscriptId transcriptId = session.getTranscriptId();
                if (transcriptId != null) {
                    transcriptById.remove(transcriptId.getFileName());
                }
                List<MapRootShortTextCount> mapCounts = ChatListDialog.mergeLiveMapCounts(session.getMapRootShortTextCounts(), this.mapRootShortTextFormatter.buildCounts(session.getMapIds()));
                boolean currentLiveSession = session.getId() != null && session.getId().equals(currentSessionId);
                results.add(new ChatListItem(ChatListItemStatus.LIVE, session.getId(), transcriptId, session.getDisplayName(), mapCounts, session.getLastActivityTimestamp(), currentLiveSession));
            }
            for (ChatTranscriptSummary summary : transcriptById.values()) {
                ChatListItemStatus status = summary.getStatus() == ChatTranscriptStatus.ERROR ? ChatListItemStatus.ERROR : ChatListItemStatus.TRANSCRIPT;
                String displayName = summary.getDisplayName();
                if (displayName == null || displayName.trim().isEmpty()) {
                    displayName = summary.getId() == null ? "" : summary.getId().getLeafFileName();
                }
                results.add(new ChatListItem(status, null, summary.getId(), displayName, summary.getMapRootShortTextCounts(), summary.getTimestamp(), false));
            }
            results.sort(Comparator.comparingLong(ChatListItem::getLastUpdatedTimestamp).reversed());
            return results;
        }
    }

    private static class StatusIconRenderer
    implements TableCellRenderer {
        private static final int MARKER_SIZE = 6;
        private final DefaultTableCellRenderer fallback = new DefaultTableCellRenderer();
        private final Icon liveCurrentIcon = new StatusTriangleIcon(new Color(3046706), 6);
        private final Icon liveIcon = new StatusDotIcon(new Color(3046706), 6);
        private final Icon transcriptIcon = new StatusDotIcon(new Color(16361509), 6);
        private final Icon errorIcon = new StatusDotIcon(new Color(12986408), 6);
        private final ChatListTableModel model;

        private StatusIconRenderer(ChatListTableModel model) {
            this.model = model;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel label = (JLabel)this.fallback.getTableCellRendererComponent(table, "", isSelected, hasFocus, row, column);
            ChatListItem item = this.model.itemAt(row);
            if (item == null) {
                label.setIcon(null);
                return label;
            }
            if (item.getStatus() == ChatListItemStatus.LIVE) {
                label.setIcon(item.isCurrentLiveSession() ? this.liveCurrentIcon : this.liveIcon);
            } else if (item.getStatus() == ChatListItemStatus.ERROR) {
                label.setIcon(this.errorIcon);
            } else {
                label.setIcon(this.transcriptIcon);
            }
            label.setHorizontalAlignment(0);
            return label;
        }
    }

    static class DeletionTargets {
        private final Set<LiveChatSessionId> liveSessionIds;
        private final Set<ChatTranscriptId> transcriptIds;

        DeletionTargets(Set<LiveChatSessionId> liveSessionIds, Set<ChatTranscriptId> transcriptIds) {
            this.liveSessionIds = new HashSet<LiveChatSessionId>(liveSessionIds);
            this.transcriptIds = new HashSet<ChatTranscriptId>(transcriptIds);
        }

        Set<LiveChatSessionId> liveSessionIds() {
            return new HashSet<LiveChatSessionId>(this.liveSessionIds);
        }

        Set<ChatTranscriptId> transcriptIds() {
            return new HashSet<ChatTranscriptId>(this.transcriptIds);
        }
    }

    private static class StatusTriangleIcon
    implements Icon {
        private final Color color;
        private final int size;

        private StatusTriangleIcon(Color color, int size) {
            this.color = color;
            this.size = size;
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int x, int y) {
            int[] xPoints = new int[]{x, x, x + this.size};
            int[] yPoints = new int[]{y, y + this.size, y + this.size / 2};
            graphics.setColor(this.color);
            graphics.fillPolygon(xPoints, yPoints, 3);
        }

        @Override
        public int getIconWidth() {
            return this.size;
        }

        @Override
        public int getIconHeight() {
            return this.size;
        }
    }

    private static class StatusDotIcon
    implements Icon {
        private final Color color;
        private final int diameter;

        private StatusDotIcon(Color color, int diameter) {
            this.color = color;
            this.diameter = diameter;
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int x, int y) {
            graphics.setColor(this.color);
            graphics.fillOval(x, y, this.diameter, this.diameter);
        }

        @Override
        public int getIconWidth() {
            return this.diameter;
        }

        @Override
        public int getIconHeight() {
            return this.diameter;
        }
    }
}

