/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.navigator.actions;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.app.DBPPlatformDesktop;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.rcp.RCPProject;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.EnterNameDialog;
import org.jkiss.dbeaver.ui.internal.UINavigatorMessages;
import org.jkiss.dbeaver.ui.navigator.actions.NavigatorHandlerObjectBase;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

public class NavigatorHandlerCreateFolder
extends NavigatorHandlerObjectBase {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection) {
            String folderName;
            IStructuredSelection structSelection = (IStructuredSelection)selection;
            final IResource resource = (IResource)GeneralUtils.adapt((Object)structSelection.getFirstElement(), IResource.class);
            if (resource == null) {
                return null;
            }
            Shell activeShell = HandlerUtil.getActiveShell((ExecutionEvent)event);
            EnterNameDialog dialog = new EnterNameDialog(this, activeShell, UINavigatorMessages.actions_navigator_create_folder_folder_name, null){

                protected Composite createDialogArea(Composite parent) {
                    Composite area = super.createDialogArea(parent);
                    UIUtils.createLabelText((Composite)area, (String)"Container", (String)resource.getFullPath().toString(), (int)2056);
                    return area;
                }
            };
            if (dialog.open() == 0 && !CommonUtils.isEmpty((String)(folderName = dialog.getResult()))) {
                try {
                    NavigatorHandlerCreateFolder.createNewFolder(resource, folderName);
                }
                catch (DBException e) {
                    DBWorkbench.getPlatformUI().showError(UINavigatorMessages.actions_navigator_create_folder_error_title, NLS.bind((String)UINavigatorMessages.actions_navigator_create_folder_error_message, (Object)folderName), (Throwable)e);
                }
            }
        }
        return null;
    }

    private static void createNewFolder(@NotNull IResource resource, @NotNull String folderName) throws DBException {
        try {
            DBPProject project;
            if (resource instanceof IProject && (project = DBPPlatformDesktop.getInstance().getWorkspace().getProject((IProject)resource)) instanceof RCPProject) {
                RCPProject rcpProject = (RCPProject)project;
                resource = rcpProject.getRootResource();
            }
            if (resource instanceof IProject) {
                newFolder = ((IProject)resource).getFolder(folderName);
                if (newFolder.exists()) {
                    throw new DBException("Folder '" + folderName + "' already exists in project '" + resource.getName() + "'");
                }
                newFolder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
            } else if (resource instanceof IFolder) {
                IFolder parentFolder = (IFolder)resource;
                if (!parentFolder.exists()) {
                    parentFolder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
                }
                if ((newFolder = parentFolder.getFolder(folderName)).exists()) {
                    throw new DBException("Folder '" + folderName + "' already exists in '" + resource.getFullPath().toString() + "'");
                }
                newFolder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (CoreException e) {
            throw new DBException("Can't create new folder: " + e.getMessage(), (Throwable)e);
        }
    }
}

