/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer.stream.exporter;

import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.Map;
import javax.imageio.ImageIO;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDContent;
import org.jkiss.dbeaver.model.data.DBDContentStorage;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.tools.transfer.DTUtils;
import org.jkiss.dbeaver.tools.transfer.stream.IStreamDataExporterSite;
import org.jkiss.dbeaver.tools.transfer.stream.exporter.StreamExporterAbstract;
import org.jkiss.dbeaver.utils.ContentUtils;
import org.jkiss.utils.CommonUtils;

public class DataExporterHTML
extends StreamExporterAbstract {
    private static final String PROP_HEADER = "tableHeader";
    private static final String PROP_COLUMN_HEADERS = "columnHeaders";
    private String name;
    private static final int IMAGE_FRAME_SIZE = 200;
    private DBDAttributeBinding[] columns;
    private int rowCount = 0;
    private boolean outputHeader = true;
    private boolean outputColumnHeaders = true;

    @Override
    public void init(IStreamDataExporterSite site) throws DBException {
        super.init(site);
        Map<String, Object> properties = site.getProperties();
        this.outputHeader = CommonUtils.getBoolean((Object)properties.get(PROP_HEADER), (boolean)this.outputHeader);
        this.outputColumnHeaders = CommonUtils.getBoolean((Object)properties.get(PROP_COLUMN_HEADERS), (boolean)this.outputColumnHeaders);
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    @Override
    public void exportHeader(DBCSession session) throws DBException, IOException {
        this.name = this.getSite().getSource().getName();
        this.columns = this.getSite().getAttributes();
        this.printHeader();
    }

    private void printHeader() {
        PrintWriter out = this.getWriter();
        out.write("<!DOCTYPE html>\n<html>\n");
        out.write("<head>\n<meta charset=\"" + this.getSite().getOutputEncoding() + "\"/><style>\ntable {border: medium solid #6495ed;border-collapse: collapse;width: 100%;} th{font-family: monospace;border: thin solid #6495ed;padding: 5px;background-color: #D0E3FA;}th{text-align: left;}td{font-family: sans-serif;border: thin solid #6495ed;padding: 5px;text-align: center;}.odd{background:#e8edff;}img{padding:5px; border:solid; border-color: #dddddd #aaaaaa #aaaaaa #dddddd; border-width: 1px 2px 2px 1px; background-color:white;}</style>\n</head>\n");
        out.write("<body>\n<table>");
        if (this.outputHeader) {
            out.write("<tr>");
            this.writeTableTitle(this.name, this.columns.length);
            out.write("</tr>");
            out.write("<tr>");
        }
        if (this.outputColumnHeaders) {
            for (DBDAttributeBinding column : this.columns) {
                String colName = column.getLabel();
                if (CommonUtils.isEmpty((String)colName)) {
                    colName = column.getName();
                }
                this.writeTextCell(colName, true);
            }
            out.write("</tr>");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exportRow(DBCSession session, DBCResultSet resultSet, Object[] row) throws DBException, IOException {
        PrintWriter out = this.getWriter();
        out.write("<tr" + (this.rowCount++ % 2 == 0 ? " class=\"odd\"" : "") + ">");
        for (int i = 0; i < row.length; ++i) {
            boolean isImage;
            DBDAttributeBinding column = this.columns[i];
            if (DBUtils.isNullValue((Object)row[i])) {
                this.writeTextCell(null, false);
                continue;
            }
            if (row[i] instanceof DBDContent) {
                DBDContent content = (DBDContent)row[i];
                try {
                    DBDContentStorage cs = content.getContents(session.getProgressMonitor());
                    out.write("<td>");
                    if (cs != null) {
                        if (ContentUtils.isTextContent((DBDContent)content)) {
                            this.writeCellValue(cs.getContentReader());
                        } else {
                            this.getSite().writeBinaryData(cs);
                        }
                    }
                    out.write("</td>");
                    continue;
                }
                finally {
                    DTUtils.closeContents(resultSet, content);
                }
            }
            String stringValue = super.getValueDisplayString(column, row[i]);
            boolean bl = isImage = row[i] instanceof File && stringValue != null && stringValue.endsWith(".jpg");
            if (isImage) {
                this.writeImageCell((File)row[i]);
                continue;
            }
            this.writeTextCell(stringValue, false);
        }
        out.write("</tr>\n");
    }

    @Override
    public void exportFooter(DBRProgressMonitor monitor) {
        this.getWriter().write("</table></body></html>");
    }

    private void writeTableTitle(String value, int columns) {
        PrintWriter out = this.getWriter();
        out.write(String.format("<th colspan=\"%d\"><pre><code>", columns));
        out.write(CommonUtils.escapeHtml((String)value));
        out.write("</code></pre></th>");
    }

    private void writeTextCell(String value, boolean header) {
        PrintWriter out = this.getWriter();
        out.write(header ? "<th>" : "<td>");
        out.write(CommonUtils.escapeHtml((String)value));
        out.write(header ? "</th>" : "</td>");
    }

    private void writeImageCell(File file) throws DBException {
        PrintWriter out = this.getWriter();
        out.write("<td>");
        if (file == null || !file.exists()) {
            out.write("&nbsp;");
        } else {
            BufferedImage image = null;
            try {
                image = ImageIO.read(file);
            }
            catch (IOException e) {
                throw new DBException("Can't read an exported image " + String.valueOf(image), (Throwable)e);
            }
            if (image != null) {
                Object imagePath = file.getAbsolutePath();
                imagePath = "files/" + ((String)imagePath).substring(((String)imagePath).lastIndexOf(File.separator));
                int width = image.getWidth();
                int height = image.getHeight();
                int rwidth = width;
                int rheight = height;
                if (width > 200 || height > 200) {
                    float scale = width > height ? 200.0f / (float)width : 200.0f / (float)height;
                    rwidth = (int)((float)rwidth * scale);
                    rheight = (int)((float)rheight * scale);
                }
                out.write("<a href=\"" + (String)imagePath + "\">");
                out.write("<img src=\"" + (String)imagePath + "\" width=\"" + rwidth + "\" height=\"" + rheight + "\" />");
                out.write("</a>");
            } else {
                out.write("&nbsp;");
            }
        }
        out.write("</td>");
    }

    private void writeCellValue(Reader reader) throws IOException {
        try (BufferedReader bufferedReader = new BufferedReader(reader);){
            PrintWriter out = this.getWriter();
            String line = bufferedReader.readLine();
            while (line != null) {
                out.write(CommonUtils.escapeHtml((String)line));
                line = bufferedReader.readLine();
                if (line == null) continue;
                out.write("<br>");
            }
        }
    }
}

