/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mssql.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Locale;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ext.mssql.SQLServerUtils;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerDataSource;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCDatabaseMetaData;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCDataSource;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCSQLDialect;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLDialectDDLExtension;
import org.jkiss.dbeaver.model.sql.SQLDialectSchemaController;
import org.jkiss.dbeaver.model.sql.parser.rules.SQLMultiWordRule;
import org.jkiss.dbeaver.model.sql.parser.rules.SQLVariableRule;
import org.jkiss.dbeaver.model.sql.parser.tokens.SQLTokenType;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedure;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedureParameter;
import org.jkiss.dbeaver.model.text.parser.TPRule;
import org.jkiss.dbeaver.model.text.parser.TPRuleProvider;
import org.jkiss.dbeaver.model.text.parser.TPToken;
import org.jkiss.dbeaver.model.text.parser.TPTokenDefault;
import org.jkiss.dbeaver.model.text.parser.TPTokenType;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public abstract class SQLServerDialectBase
extends JDBCSQLDialect
implements TPRuleProvider,
SQLDialectDDLExtension,
SQLDialectSchemaController {
    private static final String[][] TSQL_BEGIN_END_BLOCK = new String[][]{{"BEGIN", "END"}};
    public static final String AUTO_INCREMENT_KEYWORD = "IDENTITY";
    private static final String[] SQLSERVER_EXTRA_KEYWORDS = new String[]{"LOGIN", "TOP", "SYNONYM", "PERSISTED", "NOLOCK"};
    private static final String[][] SQLSERVER_QUOTE_STRINGS = new String[][]{{"[", "]"}, {"\"", "\""}};
    private static final String[][] SYBASE_LEGACY_QUOTE_STRINGS = new String[][]{{"\"", "\""}};
    private static final String[] EXEC_KEYWORDS = new String[]{"CALL", "EXEC", "EXECUTE"};
    private static final String[] PLAIN_TYPE_NAMES = new String[]{"geography", "geometry", "timestamp", "image"};
    private static final String[] SQLSERVER_FUNCTIONS_DATETIME = new String[]{"CURRENT_TIMEZONE", "DATEPART", "DATEADD", "DATEDIFF", "DATEDIFF_BIG", "DATEFROMPARTS", "DATENAME", "DATETIMEFROMPARTS", "EOMONTH", "GETDATE", "GETUTCDATE", "ISDATE", "SYSDATETIMEOFFSET", "SYSUTCDATETIME", "SMALLDATETIMEFROMPARTS", "SWITCHOFFSET", "TIMEFROMPARTS", "TODATETIMEOFFSET"};
    private JDBCDataSource dataSource;
    private boolean isSqlServer;

    protected SQLServerDialectBase(String name, String id) {
        super(name, id);
    }

    public void initDriverSettings(JDBCSession session, JDBCDataSource dataSource, JDBCDatabaseMetaData metaData) {
        super.initDriverSettings(session, dataSource, metaData);
        super.addSQLKeywords(Arrays.asList(SQLSERVER_EXTRA_KEYWORDS));
        this.dataSource = dataSource;
        this.isSqlServer = SQLServerUtils.isDriverSqlServer(dataSource.getContainer().getDriver());
        this.addFunctions(Arrays.asList(SQLSERVER_FUNCTIONS_DATETIME));
        this.addFunctions(Collections.singleton("SQL_VARIANT"));
    }

    @NotNull
    public String[] getScriptDelimiters() {
        return new String[]{";", "GO"};
    }

    public boolean validIdentifierPart(char c, boolean quoted) {
        return Character.isLetter(c) || Character.isDigit(c) || c == '_' || this.validCharacters.indexOf(c) != -1;
    }

    @NotNull
    public String[] getExecuteKeywords() {
        return EXEC_KEYWORDS;
    }

    @NotNull
    public String[] getParametersPrefixes() {
        return super.getParametersPrefixes();
    }

    public boolean isDelimiterAfterQuery() {
        return this.isSqlServer;
    }

    public boolean needsDelimiterFor(String firstKeyword, String lastKeyword) {
        return "MERGE".equalsIgnoreCase(firstKeyword) && lastKeyword != null;
    }

    public boolean supportsSubqueries() {
        return true;
    }

    public boolean supportsAliasInSelect() {
        return true;
    }

    public boolean supportsNestedComments() {
        return true;
    }

    public String[][] getIdentifierQuoteStrings() {
        if (this.dataSource != null && !this.isSqlServer && !this.dataSource.isServerVersionAtLeast(12, 6)) {
            return SYBASE_LEGACY_QUOTE_STRINGS;
        }
        return SQLSERVER_QUOTE_STRINGS;
    }

    public String[][] getBlockBoundStrings() {
        return TSQL_BEGIN_END_BLOCK;
    }

    @NotNull
    public SQLDialect.MultiValueInsertMode getDefaultMultiValueInsertMode() {
        if (this.isSqlServer) {
            if (this.dataSource.isServerVersionAtLeast(10, 0)) {
                return SQLDialect.MultiValueInsertMode.GROUP_ROWS;
            }
            return super.getDefaultMultiValueInsertMode();
        }
        return super.getDefaultMultiValueInsertMode();
    }

    public String getColumnTypeModifiers(@NotNull DBPDataSource dataSource, @NotNull DBSTypedObject column, @NotNull String typeName, @NotNull DBPDataKind dataKind) {
        String lowerTypeName = typeName.toLowerCase(Locale.ENGLISH);
        if (dataKind == DBPDataKind.DATETIME || lowerTypeName.equals("datetimeoffset")) {
            switch (lowerTypeName) {
                case "datetime2": 
                case "time": 
                case "datetimeoffset": {
                    Integer scale = column.getScale();
                    if (scale == null || scale < 0 || scale >= 7) break;
                    return "(" + scale + ")";
                }
            }
        } else {
            if (dataKind == DBPDataKind.STRING || dataKind == DBPDataKind.BINARY) {
                switch (lowerTypeName) {
                    case "binary": 
                    case "char": 
                    case "nchar": 
                    case "varchar": 
                    case "nvarchar": 
                    case "sql_variant": 
                    case "varbinary": {
                        long maxLength = column.getMaxLength();
                        int maxStringLength = CommonUtils.toInt((Object)dataSource.getDataSourceFeature("datasource.max-string-type-length"));
                        if (maxLength == 0L) {
                            return null;
                        }
                        if (maxLength == -1L || maxLength >= (long)maxStringLength) {
                            if (dataSource instanceof SQLServerDataSource) {
                                return "(MAX)";
                            }
                            return "(" + maxStringLength + ")";
                        }
                        return "(" + maxLength + ")";
                    }
                }
                return null;
            }
            if (ArrayUtils.contains((Object[])PLAIN_TYPE_NAMES, (Object)typeName)) {
                return null;
            }
            if (dataKind == DBPDataKind.NUMERIC && ("numeric".equals(lowerTypeName) || "decimal".equals(lowerTypeName))) {
                Integer scale;
                Integer precision = column.getPrecision();
                if (precision == null) {
                    precision = 18;
                }
                if (precision < 1 || precision > 38) {
                    precision = 38;
                }
                if ((scale = column.getScale()) == null) {
                    scale = 0;
                }
                if (scale > precision) {
                    scale = precision;
                }
                return "(" + precision + "," + scale + ")";
            }
        }
        return super.getColumnTypeModifiers(dataSource, column, typeName, dataKind);
    }

    public void generateStoredProcedureCall(StringBuilder sql, DBSProcedure proc, Collection<? extends DBSProcedureParameter> parameters, boolean castParams) {
        ArrayList inParameters = new ArrayList();
        int maxParamLength = this.getMaxParameterLength(parameters, inParameters);
        String schemaName = proc.getContainer().getParentObject().getName();
        sql.append("USE [").append(schemaName).append("]\n");
        sql.append("DECLARE @return_value int\n\n");
        sql.append("EXEC\t@return_value = [").append(proc.getContainer().getName()).append("].[").append(proc.getName()).append("]\n");
        for (int i = 0; i < inParameters.size(); ++i) {
            String name = ((DBSProcedureParameter)inParameters.get(i)).getName();
            sql.append("\t\t").append(name).append(" = :").append(CommonUtils.escapeIdentifier((String)name));
            if (i < inParameters.size() - 1) {
                sql.append(", ");
            } else {
                sql.append(" ");
            }
            int width = maxParamLength + 70 - name.length() / 2;
            String typeName = ((DBSProcedureParameter)inParameters.get(i)).getParameterType().getFullTypeName();
            sql.append(CommonUtils.fixedLengthString((String)("-- put the " + name + " parameter value instead of '?' (" + typeName + ")\n"), (int)width));
        }
        sql.append("\nSELECT\t'Return Value' = @return_value\n\n");
    }

    public boolean isQuotedString(String string) {
        if (string.length() >= 3 && string.charAt(0) == 'N') {
            return super.isQuotedString(string.substring(1));
        }
        return super.isQuotedString(string);
    }

    public String getQuotedString(String string) {
        return "N" + super.getQuotedString(string);
    }

    public String getUnquotedString(String string) {
        if (string.length() >= 3 && string.charAt(0) == 'N') {
            return super.getUnquotedString(string.substring(1));
        }
        return super.getUnquotedString(string);
    }

    @NotNull
    protected String quoteIdentifier(@NotNull String str, @NotNull String[][] quoteStrings) {
        return "[" + str.replace("]", "]]") + "]";
    }

    public String getUnquotedIdentifier(String identifier) {
        return super.getUnquotedIdentifier(identifier).replace("]]", "]");
    }

    public boolean isWordStart(int ch) {
        return super.isWordStart(ch) || ch == 35;
    }

    public boolean isWordPart(int ch) {
        return super.isWordPart(ch) || ch == 35;
    }

    public String[] getSingleLineComments() {
        if (!this.isSqlServer) {
            return new String[]{"--", "//"};
        }
        return super.getSingleLineComments();
    }

    @NotNull
    public TPRule[] extendRules(@Nullable DBPDataSourceContainer dataSource, @NotNull TPRuleProvider.RulePosition position) {
        if (position == TPRuleProvider.RulePosition.FINAL) {
            return new TPRule[]{new SQLVariableRule((SQLDialect)this)};
        }
        if (position == TPRuleProvider.RulePosition.KEYWORDS) {
            TPTokenDefault keywordToken = new TPTokenDefault((TPTokenType)SQLTokenType.T_KEYWORD);
            return new TPRule[]{new SQLMultiWordRule(new String[]{"BEGIN", "DISTRIBUTED", "TRANSACTION"}, (TPToken)keywordToken), new SQLMultiWordRule(new String[]{"BEGIN", "DISTRIBUTED", "TRAN"}, (TPToken)keywordToken), new SQLMultiWordRule(new String[]{"BEGIN", "TRANSACTION"}, (TPToken)keywordToken), new SQLMultiWordRule(new String[]{"BEGIN", "TRAN"}, (TPToken)keywordToken)};
        }
        return new TPRule[0];
    }

    public boolean supportsInsertAllDefaultValuesStatement() {
        return this.isSqlServer;
    }

    public boolean supportsAliasInConditions() {
        return false;
    }

    public String getOffsetLimitQueryPart(int offset, int limit) {
        return String.format("OFFSET %d ROWS FETCH NEXT %d ROWS ONLY", offset, limit);
    }

    @Nullable
    public String getAutoIncrementKeyword() {
        return AUTO_INCREMENT_KEYWORD;
    }

    public boolean supportsCreateIfExists() {
        return false;
    }

    @NotNull
    public String getTimestampDataType() {
        return "datetime";
    }

    @NotNull
    public String getBigIntegerType() {
        return "bigint";
    }

    @NotNull
    public String getClobDataType() {
        return "varchar(max)";
    }

    @NotNull
    public String getBlobDataType() {
        return "image";
    }

    @NotNull
    public String getUuidDataType() {
        return "uniqueidentifier";
    }

    @NotNull
    public String getBooleanDataType() {
        return "bit";
    }

    @NotNull
    public String getAlterColumnOperation() {
        return "alter";
    }

    public boolean supportsAlterColumnSet() {
        return false;
    }

    public boolean supportsAlterHasColumn() {
        return true;
    }

    public String getNVarCharDataType() {
        return "nvarchar";
    }

    public boolean supportsNoActionIndex() {
        return true;
    }

    public boolean needsDefaultDataTypes() {
        return false;
    }

    @NotNull
    public String getSchemaExistQuery(@NotNull String schemaName) {
        return "SELECT 1 FROM sys.schemas WHERE name = " + this.getQuotedString(schemaName);
    }

    @NotNull
    public String getCreateSchemaQuery(@NotNull String schemaName) {
        return "CREATE SCHEMA " + schemaName;
    }

    public EnumSet<SQLDialect.ProjectionAliasVisibilityScope> getProjectionAliasVisibilityScope() {
        return EnumSet.of(SQLDialect.ProjectionAliasVisibilityScope.ORDER_BY);
    }
}

