/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry.expressions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.jkiss.dbeaver.registry.expressions.ExpressionNamespaceDescriptor;

public class ExpressionRegistry {
    static final String TAG_FUNCTION = "function";
    static final String TAG_NAMESPACE = "namespace";
    private static ExpressionRegistry instance = null;
    private final List<ExpressionNamespaceDescriptor> expressionNamespaces = new ArrayList<ExpressionNamespaceDescriptor>();

    public static synchronized ExpressionRegistry getInstance() {
        if (instance == null) {
            instance = new ExpressionRegistry();
            instance.loadExtensions(Platform.getExtensionRegistry());
        }
        return instance;
    }

    private ExpressionRegistry() {
    }

    private void loadExtensions(IExtensionRegistry registry) {
        IConfigurationElement[] extConfigs;
        for (IConfigurationElement ext : extConfigs = registry.getConfigurationElementsFor("org.jkiss.dbeaver.expressions")) {
            if (!TAG_NAMESPACE.equals(ext.getName())) continue;
            this.expressionNamespaces.add(new ExpressionNamespaceDescriptor(ext));
        }
    }

    public void dispose() {
        this.expressionNamespaces.clear();
    }

    public List<ExpressionNamespaceDescriptor> getExpressionNamespaces() {
        return this.expressionNamespaces;
    }
}

