/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.app.DBPApplicationFeature;
import org.jkiss.utils.CommonUtils;

public class ProductFeatureRegistry {
    private static final Log log = Log.getLog(ProductFeatureRegistry.class);
    public static final String EXTENSION_ID = "org.jkiss.dbeaver.productFeature";
    private final Map<String, DBPApplicationFeature> allFeatures = new LinkedHashMap<String, DBPApplicationFeature>();
    private static ProductFeatureRegistry instance = null;

    public static synchronized ProductFeatureRegistry getInstance() {
        if (instance == null) {
            instance = new ProductFeatureRegistry(Platform.getExtensionRegistry());
        }
        return instance;
    }

    private ProductFeatureRegistry(IExtensionRegistry registry) {
        IConfigurationElement[] extElements;
        for (IConfigurationElement ext : extElements = registry.getConfigurationElementsFor("org.jkiss.dbeaver.objectManager")) {
            String parentId = ext.getAttribute("parent");
            DBPApplicationFeature parent = CommonUtils.isEmpty((String)parentId) ? null : this.allFeatures.get(parentId);
            DBPApplicationFeature feature = new DBPApplicationFeature(parent, ext.getAttribute("id"), ext.getAttribute("label"), ext.getAttribute("description"));
            this.allFeatures.put(feature.getId(), feature);
        }
    }

    public List<DBPApplicationFeature> getAllFeatures() {
        return new ArrayList<DBPApplicationFeature>(this.allFeatures.values());
    }
}

