/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.terminal;

import java.io.PrintWriter;
import java.util.Map;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolder2Adapter;
import org.eclipse.swt.custom.CTabFolder2Listener;
import org.eclipse.swt.custom.CTabFolderEvent;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.part.EditorPart;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.runtime.RunnableWithResult;
import org.jkiss.dbeaver.model.sql.SQLQueryResult;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetModel;
import org.jkiss.dbeaver.ui.editors.EditorPartContextualProperty;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditor;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorListener;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorListenerDefault;
import org.jkiss.dbeaver.ui.editors.sql.addins.SQLEditorAddIn;
import org.jkiss.dbeaver.ui.editors.sql.terminal.SQLTerminalFeatures;
import org.jkiss.dbeaver.ui.editors.sql.terminal.SQLTerminalView;
import org.jkiss.dbeaver.ui.editors.sql.terminal.SQLTerminalViewSwitchHandler;
import org.jkiss.dbeaver.ui.editors.sql.terminal.internal.SQLTerminalMessages;
import org.jkiss.utils.CommonUtils;

public class SQLTerminalEditorAddIn
implements SQLEditorAddIn {
    private static final Log log = Log.getLog(SQLTerminalViewSwitchHandler.class);
    private static final String BUNDLE_NAME = "org.jkiss.dbeaver.ui.editors.sql.terminal";
    private static final String TERMINAL_VIEW_ENABLED_PROPERTY = "org.jkiss.dbeaver.ui.editors.sql.show.consoleView.isEnabled";
    private static final QualifiedName FILE_TERMINAL_VIEW_ENABLED_PROP_NAME = new QualifiedName("org.jkiss.dbeaver.ui.editors.sql.terminal", "org.jkiss.dbeaver.ui.editors.sql.show.consoleView.isEnabled");
    private static final EditorPartContextualProperty terminalViewEnabledPartProperty = EditorPartContextualProperty.setup((String)"org.jkiss.dbeaver.ui.editors.sql.show.consoleView.isEnabled", (QualifiedName)FILE_TERMINAL_VIEW_ENABLED_PROP_NAME, (String)"SQLEditor.ConsoleView.showConsoleViewByDefault", (String)CommonUtils.toString((Object)false));
    private SQLEditor editor;
    private TerminalViewContext viewContext;
    private final SQLEditorListener editorListener = new SQLEditorListenerDefault(){

        public void onDataReceived(@NotNull DBPPreferenceStore contextPrefStore, @NotNull ResultSetModel resultSet, String name) {
            if (SQLTerminalEditorAddIn.this.isTerminalViewEnabled() && CommonUtils.isNotEmpty((String)name)) {
                SQLTerminalEditorAddIn.this.obtainViewContext().view.printQueryData(contextPrefStore, resultSet, name);
            }
        }

        public void onQueryResult(@NotNull DBPPreferenceStore contextPrefStore, @NotNull SQLQueryResult result) {
            if (SQLTerminalEditorAddIn.this.isTerminalViewEnabled()) {
                SQLTerminalEditorAddIn.this.obtainViewContext().view.printQueryResult(contextPrefStore, result);
            }
        }
    };

    public void init(@NotNull SQLEditor editor) {
        this.editor = editor;
        this.viewContext = null;
        this.editor.addListener(this.editorListener);
    }

    public void cleanup(@NotNull SQLEditor editor) {
        this.editor.removeListener(this.editorListener);
    }

    @Nullable
    public PrintWriter getServerOutputConsumer() {
        return (PrintWriter)UIUtils.syncExec((RunnableWithResult)new RunnableWithResult<PrintWriter>(){

            public PrintWriter runWithResult() {
                if (SQLTerminalEditorAddIn.this.editor.getActivePreferenceStore().getBoolean("SQLEditor.SQLTerminal.showServerOutput") && SQLTerminalEditorAddIn.this.isTerminalViewEnabled()) {
                    return SQLTerminalEditorAddIn.this.obtainViewContext().view.getOutputWriter();
                }
                return null;
            }
        });
    }

    @NotNull
    private TerminalViewContext obtainViewContext() {
        if (this.viewContext == null && this.isTerminalViewEnabled()) {
            this.viewContext = new TerminalViewContext();
        }
        return this.viewContext;
    }

    private void resetViewContext() {
        this.viewContext = null;
    }

    public void toggleTerminalView() {
        boolean wasEnabled = this.isTerminalViewEnabled();
        if (wasEnabled) {
            if (this.viewContext != null) {
                this.viewContext.dispose();
            }
            this.setConsoleViewEnabled(false);
        } else {
            this.setConsoleViewEnabled(true);
            if (this.editor.hasMaximizedControl()) {
                this.editor.toggleResultPanel(true, false);
            }
            this.obtainViewContext();
        }
        this.editor.getActivePreferenceStore().firePropertyChangeEvent("SQLEditor.ConsoleView.showConsoleViewByDefault", (Object)wasEnabled, (Object)(!wasEnabled ? 1 : 0));
    }

    public boolean isTerminalViewEnabled() {
        EditorPartContextualProperty.PartCustomPropertyValueInfo info = terminalViewEnabledPartProperty.getPropertyValue((EditorPart)this.editor);
        boolean enabled = CommonUtils.toBoolean((Object)info.value);
        if (info.isInitial) {
            this.editor.setResultSetAutoFocusEnabled(!enabled);
        }
        return enabled;
    }

    private void setConsoleViewEnabled(boolean enabled) {
        if (terminalViewEnabledPartProperty.setPropertyValue((EditorPart)this.editor, CommonUtils.toString((Object)enabled))) {
            this.editor.setResultSetAutoFocusEnabled(!enabled);
            SQLTerminalFeatures.SQL_TERMINAL_OPEN.use(Map.of("show", enabled));
        }
    }

    private class TerminalViewContext {
        public final SQLTerminalView view;
        public final CTabItem tabItem;

        public TerminalViewContext() {
            CTabFolder tabsContainer = SQLTerminalEditorAddIn.this.editor.getResultTabsContainer();
            this.view = new SQLTerminalView(SQLTerminalEditorAddIn.this.editor.getSite(), tabsContainer, 0);
            this.tabItem = new CTabItem(tabsContainer, 64);
            this.tabItem.setControl(this.view.getControl());
            this.tabItem.setText(SQLTerminalMessages.sql_terminal_item_text);
            this.tabItem.setToolTipText("");
            this.tabItem.setImage(DBeaverIcons.getImage((DBPImage)UIIcon.SQL_CONSOLE));
            this.tabItem.setData((Object)this.view);
            tabsContainer.addCTabFolder2Listener((CTabFolder2Listener)new CTabFolder2Adapter(){

                public void close(CTabFolderEvent event) {
                    CTabItem cTab;
                    Widget item = event.item;
                    if (item instanceof CTabItem && (cTab = (CTabItem)item).getData() instanceof SQLTerminalView) {
                        SQLTerminalEditorAddIn.this.setConsoleViewEnabled(false);
                    }
                }
            });
            this.tabItem.addDisposeListener(e -> {
                CTabItem cTab;
                Object item = e.getSource();
                if (item instanceof CTabItem && (cTab = (CTabItem)item).getData() instanceof SQLTerminalView) {
                    SQLTerminalEditorAddIn.this.setConsoleViewEnabled(false);
                }
                if (tabsContainer.getItemCount() == 0 && !this$0.editor.hasMaximizedControl()) {
                    this$0.editor.toggleResultPanel(false, true);
                }
                SQLTerminalEditorAddIn.this.resetViewContext();
            });
            SQLTerminalEditorAddIn.this.editor.getResultTabsContainer().setSelection(this.tabItem);
            UIUtils.disposeControlOnItemDispose((CTabItem)this.tabItem);
        }

        public void dispose() {
            this.tabItem.dispose();
            this.view.dispose();
        }
    }
}

