/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.ndarray.types;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;

public enum DataType {
    FLOAT32(Format.FLOATING, 4),
    FLOAT64(Format.FLOATING, 8),
    FLOAT16(Format.FLOATING, 2),
    UINT8(Format.UINT, 1),
    INT32(Format.INT, 4),
    INT8(Format.INT, 1),
    INT64(Format.INT, 8),
    BOOLEAN(Format.BOOLEAN, 1),
    COMPLEX64(Format.FLOATING, 4),
    UNKNOWN(Format.UNKNOWN, 0),
    STRING(Format.STRING, -1),
    BFLOAT16(Format.FLOATING, 2),
    UINT64(Format.UINT, 8),
    UINT32(Format.UINT, 4),
    UINT16(Format.UINT, 2),
    INT16(Format.INT, 2);

    private Format format;
    private int numOfBytes;

    private DataType(Format format, int numOfBytes) {
        this.format = format;
        this.numOfBytes = numOfBytes;
    }

    public int getNumOfBytes() {
        return this.numOfBytes;
    }

    public Format getFormat() {
        return this.format;
    }

    public boolean isFloating() {
        return this.format == Format.FLOATING;
    }

    public boolean isInteger() {
        return this.format == Format.UINT || this.format == Format.INT;
    }

    public boolean isBoolean() {
        return this.format == Format.BOOLEAN;
    }

    public static DataType fromBuffer(Buffer data) {
        if (data instanceof FloatBuffer) {
            return FLOAT32;
        }
        if (data instanceof ShortBuffer) {
            return FLOAT16;
        }
        if (data instanceof DoubleBuffer) {
            return FLOAT64;
        }
        if (data instanceof IntBuffer) {
            return INT32;
        }
        if (data instanceof LongBuffer) {
            return INT64;
        }
        if (data instanceof ByteBuffer) {
            return INT8;
        }
        throw new IllegalArgumentException("Unsupported buffer type: " + data.getClass().getSimpleName());
    }

    public static DataType fromNumpy(String dtype) {
        switch (dtype) {
            case "<f4": 
            case ">f4": 
            case "=f4": {
                return FLOAT32;
            }
            case "<f8": 
            case ">f8": 
            case "=f8": {
                return FLOAT64;
            }
            case "<f2": 
            case ">f2": 
            case "=f2": {
                return FLOAT16;
            }
            case "|u1": {
                return UINT8;
            }
            case "<u2": 
            case ">u2": 
            case "=u2": {
                return UINT16;
            }
            case "<u4": 
            case ">u4": 
            case "=u4": {
                return UINT32;
            }
            case "<u8": 
            case ">u8": 
            case "=u8": {
                return UINT64;
            }
            case "|i1": {
                return INT8;
            }
            case "<i2": 
            case ">i2": 
            case "=i2": {
                return INT16;
            }
            case "<i4": 
            case ">i4": 
            case "=i4": {
                return INT32;
            }
            case "<i8": 
            case ">i8": 
            case "=i8": {
                return INT64;
            }
            case "|b1": {
                return BOOLEAN;
            }
            case "|S1": {
                return STRING;
            }
        }
        throw new IllegalArgumentException("Unsupported dataType: " + dtype);
    }

    public static DataType fromSafetensors(String dtype) {
        switch (dtype) {
            case "F64": {
                return FLOAT64;
            }
            case "F32": {
                return FLOAT32;
            }
            case "F16": {
                return FLOAT16;
            }
            case "BF16": {
                return BFLOAT16;
            }
            case "I64": {
                return INT64;
            }
            case "I32": {
                return INT32;
            }
            case "I8": {
                return INT8;
            }
            case "U8": {
                return UINT8;
            }
            case "BOOL": {
                return BOOLEAN;
            }
        }
        throw new IllegalArgumentException("Unsupported safetensors dataType: " + dtype);
    }

    public Buffer asDataType(ByteBuffer data) {
        switch (this) {
            case FLOAT16: 
            case BFLOAT16: {
                return data.asShortBuffer();
            }
            case FLOAT32: {
                return data.asFloatBuffer();
            }
            case FLOAT64: {
                return data.asDoubleBuffer();
            }
            case INT32: 
            case UINT32: {
                return data.asIntBuffer();
            }
            case INT64: 
            case UINT64: {
                return data.asLongBuffer();
            }
        }
        return data;
    }

    public String asNumpy() {
        char order = ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN ? (char)'>' : '<';
        switch (this) {
            case FLOAT32: {
                return order + "f4";
            }
            case FLOAT64: {
                return order + "f8";
            }
            case FLOAT16: {
                return order + "f2";
            }
            case UINT8: {
                return "|u1";
            }
            case UINT16: {
                return order + "u2";
            }
            case UINT32: {
                return order + "u4";
            }
            case UINT64: {
                return order + "u8";
            }
            case INT8: {
                return "|i1";
            }
            case INT16: {
                return order + "i2";
            }
            case INT32: {
                return order + "i4";
            }
            case INT64: {
                return order + "i8";
            }
            case BOOLEAN: {
                return "|b1";
            }
            case STRING: {
                return "|S1";
            }
        }
        throw new IllegalArgumentException("Unsupported dataType: " + (Object)((Object)this));
    }

    public String asSafetensors() {
        switch (this) {
            case FLOAT64: {
                return "F64";
            }
            case FLOAT32: {
                return "F32";
            }
            case FLOAT16: {
                return "F16";
            }
            case BFLOAT16: {
                return "BF16";
            }
            case INT64: {
                return "I64";
            }
            case INT32: {
                return "I32";
            }
            case INT8: {
                return "I8";
            }
            case UINT8: {
                return "U8";
            }
            case BOOLEAN: {
                return "BOOL";
            }
        }
        throw new IllegalArgumentException("Unsupported dataType: " + (Object)((Object)this));
    }

    public String toString() {
        return this.name().toLowerCase();
    }

    public static enum Format {
        FLOATING,
        UINT,
        INT,
        BOOLEAN,
        STRING,
        UNKNOWN;

    }
}

