/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.helper;

import java.util.Collection;
import java.util.List;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.search.join.ScoreMode;
import org.opensearch.ExceptionsHelper;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.action.admin.indices.delete.DeleteIndexRequest;
import org.opensearch.action.bulk.BulkRequest;
import org.opensearch.action.bulk.BulkResponse;
import org.opensearch.action.delete.DeleteRequest;
import org.opensearch.action.delete.DeleteResponse;
import org.opensearch.action.get.GetRequest;
import org.opensearch.action.get.GetResponse;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.index.IndexResponse;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.support.clustermanager.AcknowledgedResponse;
import org.opensearch.action.update.UpdateRequest;
import org.opensearch.action.update.UpdateResponse;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.json.JsonXContent;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.Strings;
import org.opensearch.core.common.util.CollectionUtils;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.index.IndexNotFoundException;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.NestedQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.index.query.TermQueryBuilder;
import org.opensearch.index.reindex.BulkByScrollResponse;
import org.opensearch.index.reindex.DeleteByQueryAction;
import org.opensearch.index.reindex.DeleteByQueryRequest;
import org.opensearch.ml.common.memorycontainer.MLMemoryContainer;
import org.opensearch.ml.common.memorycontainer.MemoryConfiguration;
import org.opensearch.ml.common.memorycontainer.MemoryStrategy;
import org.opensearch.ml.common.memorycontainer.MemoryType;
import org.opensearch.ml.utils.RestActionUtils;
import org.opensearch.remote.metadata.client.GetDataObjectRequest;
import org.opensearch.remote.metadata.client.SdkClient;
import org.opensearch.remote.metadata.client.SearchDataObjectRequest;
import org.opensearch.remote.metadata.common.SdkClientUtils;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.search.fetch.subphase.FetchSourceContext;
import org.opensearch.transport.client.Client;

public class MemoryContainerHelper {
    @Generated
    private static final Logger log = LogManager.getLogger(MemoryContainerHelper.class);
    private final Client client;
    private final SdkClient sdkClient;
    private final NamedXContentRegistry xContentRegistry;

    @Inject
    public MemoryContainerHelper(Client client, SdkClient sdkClient, NamedXContentRegistry xContentRegistry) {
        this.client = client;
        this.sdkClient = sdkClient;
        this.xContentRegistry = xContentRegistry;
    }

    public void getMemoryContainer(String memoryContainerId, ActionListener<MLMemoryContainer> listener) {
        this.getMemoryContainer(memoryContainerId, null, listener);
    }

    public void getMemoryContainer(String memoryContainerId, String tenantId, ActionListener<MLMemoryContainer> listener) {
        log.debug("Fetching memory container with ID: {} for tenant: {}", (Object)memoryContainerId, (Object)tenantId);
        FetchSourceContext fetchSourceContext = new FetchSourceContext(true, Strings.EMPTY_ARRAY, Strings.EMPTY_ARRAY);
        GetDataObjectRequest.Builder requestBuilder = ((GetDataObjectRequest.Builder)((GetDataObjectRequest.Builder)GetDataObjectRequest.builder().index(".plugins-ml-am-memory-container")).id(memoryContainerId)).fetchSourceContext(fetchSourceContext);
        if (tenantId != null) {
            requestBuilder.tenantId(tenantId);
        }
        GetDataObjectRequest getDataObjectRequest = requestBuilder.build();
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            ActionListener wrappedListener = ActionListener.runBefore(listener, () -> ((ThreadContext.StoredContext)context).restore());
            this.sdkClient.getDataObjectAsync(getDataObjectRequest).whenComplete((r, throwable) -> {
                block13: {
                    if (throwable != null) {
                        Exception cause = SdkClientUtils.unwrapAndConvertToException((Throwable)throwable, (Class[])new Class[0]);
                        if (ExceptionsHelper.unwrap((Throwable)cause, (Class[])new Class[]{IndexNotFoundException.class}) != null) {
                            wrappedListener.onFailure((Exception)new OpenSearchStatusException("Memory container not found", RestStatus.NOT_FOUND, new Object[0]));
                        } else {
                            wrappedListener.onFailure(cause);
                        }
                    } else {
                        try {
                            if (r.getResponse() != null && r.getResponse().isExists()) {
                                try (XContentParser parser = JsonXContent.jsonXContent.createParser(this.xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, r.getResponse().getSourceAsString());){
                                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
                                    MLMemoryContainer container = MLMemoryContainer.parse((XContentParser)parser);
                                    wrappedListener.onResponse((Object)container);
                                    break block13;
                                }
                            }
                            wrappedListener.onFailure((Exception)new OpenSearchStatusException("Memory container not found", RestStatus.NOT_FOUND, new Object[0]));
                        }
                        catch (Exception e) {
                            wrappedListener.onFailure(e);
                        }
                    }
                }
            });
        }
    }

    public boolean checkMemoryContainerAccess(User user, MLMemoryContainer mlMemoryContainer) {
        if (user == null) {
            return true;
        }
        if (user.getRoles() != null && user.getRoles().contains("all_access")) {
            return true;
        }
        User owner = mlMemoryContainer.getOwner();
        if (owner != null && owner.getName() != null && owner.getName().equals(user.getName())) {
            return true;
        }
        List allowedBackendRoles = mlMemoryContainer.getBackendRoles();
        if (allowedBackendRoles != null && !allowedBackendRoles.isEmpty() && user.getBackendRoles() != null) {
            return allowedBackendRoles.stream().anyMatch(role -> user.getBackendRoles().contains(role));
        }
        if (owner != null && owner.getBackendRoles() != null && user.getBackendRoles() != null) {
            return owner.getBackendRoles().stream().anyMatch(role -> user.getBackendRoles().contains(role));
        }
        return false;
    }

    public boolean checkMemoryAccess(User user, String ownerId) {
        if (user == null) {
            return true;
        }
        if (user.getRoles() != null && user.getRoles().contains("all_access")) {
            return true;
        }
        String userName = user.getName();
        return userName.equals(ownerId);
    }

    public String getMemoryIndexName(MLMemoryContainer container, MemoryType memoryType) {
        MemoryConfiguration config = container.getConfiguration();
        if (config != null && memoryType != null) {
            return config.getIndexName(memoryType);
        }
        return null;
    }

    public void getData(MemoryConfiguration configuration, GetRequest getRequest, ActionListener<GetResponse> listener) {
        if (configuration.isUseSystemIndex()) {
            try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
                this.client.get(getRequest, ActionListener.runBefore(listener, () -> ((ThreadContext.StoredContext)context).restore()));
            }
        } else {
            this.client.get(getRequest, listener);
        }
    }

    public void searchData(MemoryConfiguration configuration, SearchDataObjectRequest searchRequest, ActionListener<SearchResponse> listener) {
        block9: {
            try {
                if (configuration.isUseSystemIndex()) {
                    try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
                        ActionListener wrappedListener = ActionListener.runBefore(listener, () -> ((ThreadContext.StoredContext)context).restore());
                        ActionListener doubleWrappedListener = ActionListener.wrap(arg_0 -> ((ActionListener)wrappedListener).onResponse(arg_0), e -> RestActionUtils.wrapListenerToHandleSearchIndexNotFound(e, (ActionListener<SearchResponse>)wrappedListener));
                        this.sdkClient.searchDataObjectAsync(searchRequest).whenComplete(SdkClientUtils.wrapSearchCompletion((ActionListener)doubleWrappedListener, (Class[])new Class[0]));
                        break block9;
                    }
                }
                ActionListener doubleWrappedListener = ActionListener.wrap(arg_0 -> listener.onResponse(arg_0), e -> RestActionUtils.wrapListenerToHandleSearchIndexNotFound(e, listener));
                this.sdkClient.searchDataObjectAsync(searchRequest).whenComplete(SdkClientUtils.wrapSearchCompletion((ActionListener)doubleWrappedListener, (Class[])new Class[0]));
            }
            catch (Exception e2) {
                log.error("Failed to search data", (Throwable)e2);
                listener.onFailure(e2);
            }
        }
    }

    public void indexData(MemoryConfiguration configuration, IndexRequest indexRequest, ActionListener<IndexResponse> listener) {
        if (configuration.isUseSystemIndex()) {
            try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
                this.client.index(indexRequest, ActionListener.runBefore(listener, () -> ((ThreadContext.StoredContext)context).restore()));
            }
        } else {
            this.client.index(indexRequest, listener);
        }
    }

    public void updateData(MemoryConfiguration configuration, UpdateRequest updateRequest, ActionListener<UpdateResponse> listener) {
        if (configuration.isUseSystemIndex()) {
            try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
                this.client.update(updateRequest, ActionListener.runBefore(listener, () -> ((ThreadContext.StoredContext)context).restore()));
            }
        } else {
            this.client.update(updateRequest, listener);
        }
    }

    public void deleteData(MemoryConfiguration configuration, DeleteRequest deleteRequest, ActionListener<DeleteResponse> listener) {
        if (configuration.isUseSystemIndex()) {
            try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
                this.client.delete(deleteRequest, ActionListener.runBefore(listener, () -> ((ThreadContext.StoredContext)context).restore()));
            }
        } else {
            this.client.delete(deleteRequest, listener);
        }
    }

    public void deleteIndex(MemoryConfiguration configuration, DeleteIndexRequest deleteIndexRequest, ActionListener<AcknowledgedResponse> listener) {
        if (configuration.isUseSystemIndex()) {
            try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
                this.client.admin().indices().delete(deleteIndexRequest, ActionListener.runBefore(listener, () -> ((ThreadContext.StoredContext)context).restore()));
            }
        } else {
            this.client.admin().indices().delete(deleteIndexRequest, listener);
        }
    }

    public void bulkIngestData(MemoryConfiguration configuration, BulkRequest bulkRequest, ActionListener<BulkResponse> listener) {
        if (configuration.isUseSystemIndex()) {
            try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
                this.client.bulk(bulkRequest, ActionListener.runBefore(listener, () -> ((ThreadContext.StoredContext)context).restore()));
            }
        } else {
            this.client.bulk(bulkRequest, listener);
        }
    }

    public void deleteDataByQuery(MemoryConfiguration configuration, DeleteByQueryRequest deleteByQueryRequest, ActionListener<BulkByScrollResponse> listener) {
        if (configuration.isUseSystemIndex()) {
            try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
                this.client.execute((ActionType)DeleteByQueryAction.INSTANCE, (ActionRequest)deleteByQueryRequest, ActionListener.runBefore(listener, () -> ((ThreadContext.StoredContext)context).restore()));
            }
            catch (Exception e) {
                log.error("Failed to execute delete by query on system index", (Throwable)e);
                listener.onFailure(e);
            }
        } else {
            this.client.execute((ActionType)DeleteByQueryAction.INSTANCE, (ActionRequest)deleteByQueryRequest, listener);
        }
    }

    public boolean isAdminUser(User user) {
        return user != null && !CollectionUtils.isEmpty((Collection)user.getRoles()) && user.getRoles().contains("all_access");
    }

    private SearchSourceBuilder applyFilterToSearchSource(SearchSourceBuilder searchSourceBuilder, QueryBuilder filterQuery) {
        QueryBuilder query = searchSourceBuilder.query();
        if (query == null) {
            searchSourceBuilder.query(filterQuery);
        } else if (query instanceof BoolQueryBuilder) {
            ((BoolQueryBuilder)query).filter(filterQuery);
        } else {
            BoolQueryBuilder rewriteQuery = new BoolQueryBuilder();
            rewriteQuery.must(query);
            rewriteQuery.filter(filterQuery);
            searchSourceBuilder.query((QueryBuilder)rewriteQuery);
        }
        return searchSourceBuilder;
    }

    public SearchSourceBuilder addUserBackendRolesFilter(User user, SearchSourceBuilder searchSourceBuilder) {
        BoolQueryBuilder boolQueryBuilder = new BoolQueryBuilder();
        boolQueryBuilder.should((QueryBuilder)QueryBuilders.termsQuery((String)"backend_roles.keyword", (Collection)user.getBackendRoles()));
        TermQueryBuilder ownerNameTermQuery = QueryBuilders.termQuery((String)"owner.name.keyword", (String)user.getName());
        NestedQueryBuilder nestedOwnerQuery = QueryBuilders.nestedQuery((String)"owner", (QueryBuilder)ownerNameTermQuery, (ScoreMode)ScoreMode.None);
        boolQueryBuilder.should((QueryBuilder)nestedOwnerQuery);
        return this.applyFilterToSearchSource(searchSourceBuilder, (QueryBuilder)boolQueryBuilder);
    }

    public SearchSourceBuilder addOwnerIdFilter(User user, SearchSourceBuilder searchSourceBuilder) {
        BoolQueryBuilder boolQueryBuilder = new BoolQueryBuilder();
        boolQueryBuilder.should((QueryBuilder)QueryBuilders.termsQuery((String)"owner_id", (String[])new String[]{user.getName()}));
        return this.applyFilterToSearchSource(searchSourceBuilder, (QueryBuilder)boolQueryBuilder);
    }

    public QueryBuilder addOwnerIdFilter(User user, QueryBuilder query) {
        if (user == null || this.isAdminUser(user)) {
            return query;
        }
        BoolQueryBuilder filteredQuery = QueryBuilders.boolQuery();
        filteredQuery.must(query);
        filteredQuery.filter((QueryBuilder)QueryBuilders.termQuery((String)"owner_id", (String)user.getName()));
        return filteredQuery;
    }

    public SearchSourceBuilder addContainerIdFilter(String containerId, SearchSourceBuilder searchSourceBuilder) {
        if (containerId == null || containerId.isBlank()) {
            return searchSourceBuilder;
        }
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        boolQueryBuilder.filter((QueryBuilder)QueryBuilders.termQuery((String)"memory_container_id", (String)containerId));
        return this.applyFilterToSearchSource(searchSourceBuilder, (QueryBuilder)boolQueryBuilder);
    }

    public QueryBuilder addContainerIdFilter(String containerId, QueryBuilder query) {
        if (containerId == null || containerId.isBlank()) {
            return query;
        }
        BoolQueryBuilder filteredQuery = QueryBuilders.boolQuery();
        filteredQuery.must(query);
        filteredQuery.filter((QueryBuilder)QueryBuilders.termQuery((String)"memory_container_id", (String)containerId));
        return filteredQuery;
    }

    public String getOwnerId(User user) {
        return user != null ? user.getName() : null;
    }

    public void countContainersWithPrefix(String indexPrefix, String tenantId, ActionListener<Long> listener) {
        if (indexPrefix == null || indexPrefix.isBlank()) {
            listener.onResponse((Object)0L);
            return;
        }
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.query((QueryBuilder)QueryBuilders.termQuery((String)"configuration.index_prefix", (String)indexPrefix));
        searchSourceBuilder.size(0);
        searchSourceBuilder.trackTotalHits(true);
        SearchDataObjectRequest.Builder requestBuilder = SearchDataObjectRequest.builder().indices(new String[]{".plugins-ml-am-memory-container"}).searchSourceBuilder(searchSourceBuilder);
        if (tenantId != null) {
            requestBuilder.tenantId(tenantId);
        }
        SearchDataObjectRequest searchRequest = requestBuilder.build();
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            ActionListener wrappedListener = ActionListener.runBefore((ActionListener)ActionListener.wrap(response -> {
                long totalHits = response.getHits().getTotalHits().value();
                listener.onResponse((Object)totalHits);
            }, e -> {
                log.error("Failed to count containers with prefix: " + indexPrefix, (Throwable)e);
                listener.onFailure(e);
            }), () -> ((ThreadContext.StoredContext)context).restore());
            this.sdkClient.searchDataObjectAsync(searchRequest).whenComplete(SdkClientUtils.wrapSearchCompletion((ActionListener)wrappedListener, (Class[])new Class[0]));
        }
        catch (Exception e2) {
            log.error("Failed to search for containers with prefix: " + indexPrefix, (Throwable)e2);
            listener.onFailure(e2);
        }
    }

    public String getLlmResultPath(MemoryStrategy strategy, MemoryConfiguration memoryConfig) {
        Object configPath;
        Object strategyPath;
        if (strategy != null && strategy.getStrategyConfig() != null && (strategyPath = strategy.getStrategyConfig().get("llm_result_path")) != null) {
            return strategyPath.toString();
        }
        if (memoryConfig != null && memoryConfig.getParameters() != null && (configPath = memoryConfig.getParameters().get("llm_result_path")) != null) {
            return configPath.toString();
        }
        return "$.output.message.content[0].text";
    }
}

