/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.action.contextmanagement;

import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.action.update.UpdateResponse;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.core.action.ActionListener;
import org.opensearch.ml.action.contextmanagement.ContextManagementTemplateService;
import org.opensearch.ml.common.transport.contextmanagement.MLUpdateContextManagementTemplateRequest;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;
import org.opensearch.transport.client.Client;

public class UpdateContextManagementTemplateTransportAction
extends HandledTransportAction<MLUpdateContextManagementTemplateRequest, UpdateResponse> {
    @Generated
    private static final Logger log = LogManager.getLogger(UpdateContextManagementTemplateTransportAction.class);
    private final Client client;
    private final ContextManagementTemplateService contextManagementTemplateService;

    @Inject
    public UpdateContextManagementTemplateTransportAction(TransportService transportService, ActionFilters actionFilters, Client client, ContextManagementTemplateService contextManagementTemplateService) {
        super("cluster:admin/opensearch/ml/context_management/update", transportService, actionFilters, MLUpdateContextManagementTemplateRequest::new);
        this.client = client;
        this.contextManagementTemplateService = contextManagementTemplateService;
    }

    protected void doExecute(Task task, MLUpdateContextManagementTemplateRequest request, ActionListener<UpdateResponse> listener) {
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            log.info("Updating context management template: {}", (Object)request.getTemplateName());
            this.contextManagementTemplateService.updateTemplate(request.getTemplateName(), request.getTemplate(), listener);
        }
        catch (Exception e) {
            log.error("Failed to update context management template: {}", (Object)request.getTemplateName(), (Object)e);
            listener.onFailure(e);
        }
    }
}

