/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.undertow.httpcore.WriteFunction;
import io.undertow.server.HandlerWrapper;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.ResponseCommitListener;
import io.undertow.server.handlers.builder.HandlerBuilder;
import io.undertow.util.ByteRange;
import io.undertow.util.DateUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ByteRangeHandler
implements HttpHandler {
    private final HttpHandler next;
    private final boolean sendAcceptRanges;
    private static final ResponseCommitListener ACCEPT_RANGE_LISTENER = new ResponseCommitListener(){

        @Override
        public void beforeCommit(HttpServerExchange exchange) {
            if (!exchange.containsResponseHeader("Accept-Ranges")) {
                if (exchange.containsResponseHeader("Content-Length")) {
                    exchange.setResponseHeader("Accept-Ranges", "bytes");
                } else {
                    exchange.setResponseHeader("Accept-Ranges", "none");
                }
            }
        }
    };

    public ByteRangeHandler(HttpHandler next, boolean sendAcceptRanges) {
        this.next = next;
        this.sendAcceptRanges = sendAcceptRanges;
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        ByteRange range;
        if (!"GET".equals(exchange.getRequestMethod()) && !"HEAD".equals(exchange.getRequestMethod())) {
            this.next.handleRequest(exchange);
            return;
        }
        if (this.sendAcceptRanges) {
            exchange.addResponseCommitListener(ACCEPT_RANGE_LISTENER);
        }
        if ((range = ByteRange.parse(exchange.getRequestHeader("Range"))) != null && range.getRanges() == 1) {
            exchange.addResponseCommitListener(new ResponseCommitListener(){

                @Override
                public void beforeCommit(HttpServerExchange exchange) {
                    if (exchange.getStatusCode() != 200) {
                        return;
                    }
                    String length = exchange.getResponseHeader("Content-Length");
                    if (length == null) {
                        return;
                    }
                    long responseLength = Long.parseLong(length);
                    String lastModified = exchange.getResponseHeader("Last-Modified");
                    ByteRange.RangeResponseResult rangeResponse = range.getResponseResult(responseLength, exchange.getRequestHeader("If-Range"), lastModified == null ? null : DateUtils.parseDate(lastModified), exchange.getResponseHeader("ETag"));
                    if (rangeResponse != null) {
                        long start = rangeResponse.getStart();
                        long end = rangeResponse.getEnd();
                        exchange.setStatusCode(rangeResponse.getStatusCode());
                        exchange.setResponseHeader("Content-Range", rangeResponse.getContentRange());
                        exchange.setResponseContentLength(rangeResponse.getContentLength());
                        if (rangeResponse.getStatusCode() == 416) {
                            exchange.addWriteFunction(new WriteFunction(){

                                public ByteBuf preWrite(ByteBuf data, boolean last) {
                                    data.release();
                                    return Unpooled.EMPTY_BUFFER;
                                }
                            });
                        }
                        exchange.addWriteFunction(new RangeWriteFunction(start, end, responseLength));
                    }
                }
            });
        }
        this.next.handleRequest(exchange);
    }

    public static class Builder
    implements HandlerBuilder {
        @Override
        public String name() {
            return "byte-range";
        }

        @Override
        public Map<String, Class<?>> parameters() {
            HashMap params = new HashMap();
            params.put("send-accept-ranges", Boolean.TYPE);
            return params;
        }

        @Override
        public Set<String> requiredParameters() {
            return Collections.emptySet();
        }

        @Override
        public String defaultParameter() {
            return "send-accept-ranges";
        }

        @Override
        public HandlerWrapper build(Map<String, Object> config) {
            Boolean send = (Boolean)config.get("send-accept-ranges");
            return new Wrapper(send != null && send != false);
        }
    }

    public static class Wrapper
    implements HandlerWrapper {
        private final boolean sendAcceptRanges;

        public Wrapper(boolean sendAcceptRanges) {
            this.sendAcceptRanges = sendAcceptRanges;
        }

        @Override
        public HttpHandler wrap(HttpHandler handler) {
            return new ByteRangeHandler(handler, this.sendAcceptRanges);
        }
    }

    private class RangeWriteFunction
    implements WriteFunction {
        private final long start;
        private final long end;
        private final long originalResponseLength;
        private long written;

        public RangeWriteFunction(long start, long end, long originalResponseLength) {
            this.start = start;
            this.end = end;
            this.originalResponseLength = originalResponseLength;
        }

        public ByteBuf preWrite(ByteBuf src, boolean last) {
            if (src == null) {
                return null;
            }
            if (this.written > this.end) {
                src.release();
                return Unpooled.EMPTY_BUFFER;
            }
            if (this.written < this.start) {
                long toEat = this.start - this.written;
                if ((long)src.readableBytes() < toEat) {
                    this.written += (long)src.readableBytes();
                    src.release();
                    return Unpooled.EMPTY_BUFFER;
                }
                src.readerIndex((int)((long)src.readerIndex() + toEat));
                this.written += toEat;
            }
            long remaining = this.end - this.written + 1L;
            if ((long)src.readableBytes() > remaining) {
                src.writerIndex((int)((long)src.readerIndex() + remaining));
                this.written += remaining;
            } else {
                this.written += (long)src.readableBytes();
            }
            return src;
        }
    }
}

