/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.common.iteration;

import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;

public interface EnumerationIterator<E>
extends Enumeration<E>,
Iterator<E> {
    @Override
    default public boolean hasMoreElements() {
        return this.hasNext();
    }

    @Override
    default public E nextElement() {
        return this.next();
    }

    public static <E> EnumerationIterator<E> over(final E item) {
        return new EnumerationIterator<E>(){
            boolean done;

            @Override
            public boolean hasNext() {
                return !this.done;
            }

            @Override
            public E next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.done = true;
                return item;
            }
        };
    }
}

