/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.quantum.mo;

import org.jmol.quantum.MOCalculation;
import org.jmol.quantum.mo.DataAdder;

public class DataAdder7F
implements DataAdder {
    static final double c0_xxz_yyz = 0.6708203932499369;
    static final double c1p_xzz = 1.0954451150103321;
    static final double c1p_xxx = 0.6123724356957945;
    static final double c1p_xyy = 0.27386127875258304;
    static final double c1n_yzz = 1.0954451150103321;
    static final double c1n_yyy = 0.6123724356957945;
    static final double c1n_xxy = 0.27386127875258304;
    static final double c2p_xxz_yyz = 0.8660254037844386;
    static final double c3p_xxx = 0.7905694150420949;
    static final double c3p_xyy = 1.0606601717798214;
    static final double c3n_yyy = 0.7905694150420949;
    static final double c3n_xxy = 1.0606601717798214;

    @Override
    public boolean addData(MOCalculation calc, boolean havePoints) {
        double norm1;
        double norm2;
        double norm3;
        double c0_zzz = 1.0;
        double c0_xxz_yyz = 0.6708203932499369;
        double c1p_xzz = 1.0954451150103321;
        double c1p_xxx = 0.6123724356957945;
        double c1p_xyy = 0.27386127875258304;
        double c2p_xxz_yyz = 0.8660254037844386;
        double c2n_xyz = 1.0;
        double c3p_xxx = 0.7905694150420949;
        double c3p_xyy = 1.0606601717798214;
        boolean normalizeAlpha = false;
        switch (calc.normType) {
            default: {
                norm3 = 1.0;
                norm2 = 1.0;
                norm1 = 1.0;
                break;
            }
            case 3: {
                norm3 = 1.0;
                norm2 = 1.0;
                norm1 = 1.0;
                c0_zzz = 2.0;
                c0_xxz_yyz = 3.0;
                c1p_xyy = c1p_xxx = Math.sqrt(1.5);
                c1p_xzz = 4.0 * c1p_xxx;
                c2p_xxz_yyz = Math.sqrt(15.0);
                c2n_xyz = 2.0 * c2p_xxz_yyz;
                c3p_xxx = Math.sqrt(2.5);
                c3p_xyy = 3.0 * c3p_xxx;
                break;
            }
            case 1: {
                norm1 = 5.701643762839922;
                norm2 = 3.2918455612989796;
                norm3 = 1.4721580892990938;
                normalizeAlpha = true;
                break;
            }
            case 2: {
                norm1 = Math.pow(66.05114251919257, 0.25);
                norm2 = norm1 / 1.7320507764816284;
                norm3 = 0.8660253882408142;
                normalizeAlpha = true;
            }
        }
        double c1n_yzz = c1p_xzz;
        double c1n_yyy = c1p_xxx;
        double c1n_xxy = c1p_xyy;
        double c3n_yyy = c3p_xxx;
        double c3n_xxy = c3p_xyy;
        double m0 = calc.coeffs[0];
        double m1p = calc.coeffs[1];
        double m1n = calc.coeffs[2];
        double m2p = calc.coeffs[3];
        double m2n = calc.coeffs[4];
        double m3p = calc.coeffs[5];
        double m3n = calc.coeffs[6];
        for (int ig = 0; ig < calc.nGaussians; ++ig) {
            double c1;
            double alpha = calc.gaussians[calc.gaussianPtr + ig][0];
            double a = c1 = (double)calc.gaussians[calc.gaussianPtr + ig][1];
            if (normalizeAlpha) {
                a *= Math.pow(alpha, 2.25);
            }
            double af0 = a * m0;
            double af1p = a * m1p;
            double af1n = a * m1n;
            double af2p = a * m2p;
            double af2n = a * m2n;
            double af3p = a * m3p;
            double af3n = a * m3n;
            calc.setE(calc.EX, alpha);
            int ix = calc.xMax;
            while (--ix >= calc.xMin) {
                double x = calc.X[ix];
                double xx = x * x;
                double eX = calc.EX[ix];
                double cxxx = norm3 * x * xx;
                if (havePoints) {
                    calc.setMinMax(ix);
                }
                int iy = calc.yMax;
                while (--iy >= calc.yMin) {
                    double y = calc.Y[iy];
                    double yy = y * y;
                    double eXY = eX * calc.EY[iy];
                    double cyyy = norm3 * y * yy;
                    double cxyy = norm2 * x * yy;
                    double cxxy = norm2 * xx * y;
                    float[] vd = calc.voxelDataTemp[ix][havePoints ? 0 : iy];
                    int iz = calc.zMax;
                    while (--iz >= calc.zMin) {
                        double z = calc.Z[iz];
                        double zz = z * z;
                        double czzz = norm3 * z * zz;
                        double cxxz = norm2 * xx * z;
                        double cxzz = norm2 * x * zz;
                        double cyyz = norm2 * yy * z;
                        double cyzz = norm2 * y * zz;
                        double cxyz = norm1 * x * y * z;
                        double f0 = af0 * (c0_zzz * czzz - c0_xxz_yyz * (cxxz + cyyz));
                        double f1p = af1p * (c1p_xzz * cxzz - c1p_xxx * cxxx - c1p_xyy * cxyy);
                        double f1n = af1n * (c1n_yzz * cyzz - c1n_yyy * cyyy - c1n_xxy * cxxy);
                        double f2p = af2p * (c2p_xxz_yyz * (cxxz - cyyz));
                        double f2n = af2n * c2n_xyz * cxyz;
                        double f3p = af3p * (c3p_xxx * cxxx - c3p_xyy * cxyy);
                        double f3n = -af3n * (c3n_yyy * cyyy - c3n_xxy * cxxy);
                        int n = havePoints ? 0 : iz;
                        vd[n] = (float)((double)vd[n] + (f0 + f1p + f1n + f2p + f2n + f3p + f3n) * eXY * calc.EZ[iz]);
                    }
                }
            }
        }
        return true;
    }
}

