/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer.database;

import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBPIdentifierCase;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.tools.transfer.internal.DTMessages;

public enum MappingNameCase {
    DEFAULT(0, DTMessages.pref_data_transfer_name_case_default, null),
    UPPER(1, DTMessages.pref_data_transfer_name_case_upper, DBPIdentifierCase.UPPER),
    LOWER(2, DTMessages.pref_data_transfer_name_case_lower, DBPIdentifierCase.LOWER);

    private final int selectionId;
    private final String name;
    private final DBPIdentifierCase identifierCase;

    private MappingNameCase(int selectionId, String name, DBPIdentifierCase identifierCase) {
        this.selectionId = selectionId;
        this.name = name;
        this.identifierCase = identifierCase;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public DBPIdentifierCase getIdentifierCase() {
        return this.identifierCase;
    }

    @NotNull
    public static MappingNameCase getCaseBySelectionId(int id) {
        for (MappingNameCase value : MappingNameCase.values()) {
            if (id != value.selectionId) continue;
            return value;
        }
        return DEFAULT;
    }

    @NotNull
    public static MappingNameCase getCaseFromPreferences(@NotNull DBPPreferenceStore dbpPreferenceStore, @NotNull DBPPreferenceStore store) {
        int selectionIndex = dbpPreferenceStore.contains("nameCaseMapping") ? dbpPreferenceStore.getInt("nameCaseMapping") : store.getInt("nameCaseMapping");
        return MappingNameCase.getCaseBySelectionId(selectionIndex);
    }
}

