/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.ai;

import java.time.LocalDateTime;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.ai.AIFunctionResult;
import org.jkiss.dbeaver.model.ai.AIMessageMeta;
import org.jkiss.dbeaver.model.ai.AIMessageType;
import org.jkiss.dbeaver.model.ai.engine.AIFunctionCall;
import org.jkiss.utils.CommonUtils;

public class AIMessage {
    @NotNull
    private final AIMessageType role;
    @NotNull
    private final String content;
    @Nullable
    private final String displayMessage;
    @Nullable
    private final String functionCallName;
    @NotNull
    private final LocalDateTime time;
    @Nullable
    private final AIFunctionCall functionCall;
    @Nullable
    private final AIFunctionResult functionResult;
    @Nullable
    private final List<AIMessageMeta> meta;

    public AIMessage(@NotNull AIMessageType role, @NotNull String content, @Nullable String displayMessage, @NotNull LocalDateTime time, @Nullable List<AIMessageMeta> meta, @Nullable String functionCallName) {
        this.role = role;
        this.content = content;
        this.displayMessage = displayMessage;
        this.time = time;
        this.meta = meta;
        this.functionCall = null;
        this.functionResult = null;
        this.functionCallName = functionCallName;
    }

    public AIMessage(@NotNull AIMessageType role, @NotNull String content, @Nullable String displayMessage, @NotNull LocalDateTime time, @Nullable List<AIMessageMeta> meta) {
        this.role = role;
        this.content = content;
        this.displayMessage = displayMessage;
        this.time = time;
        this.meta = meta;
        this.functionCall = null;
        this.functionResult = null;
        this.functionCallName = null;
    }

    private AIMessage(@NotNull AIFunctionCall functionCall, @NotNull AIFunctionResult result, @Nullable List<AIMessageMeta> meta) {
        this.meta = meta;
        this.role = AIMessageType.FUNCTION;
        this.content = CommonUtils.toString(result.getValue()) + " was completed";
        this.time = LocalDateTime.now();
        this.functionCall = functionCall;
        this.functionResult = result;
        this.displayMessage = CommonUtils.toString(result.getValue());
        this.functionCallName = null;
    }

    @NotNull
    public static AIMessage systemMessage(@NotNull String message) {
        return new AIMessage(AIMessageType.SYSTEM, message, null);
    }

    @NotNull
    public static AIMessage userMessage(@NotNull String message) {
        return new AIMessage(AIMessageType.USER, message, null);
    }

    @NotNull
    public static AIMessage assistantMessage(@NotNull String message, @Nullable List<AIMessageMeta> meta) {
        return new AIMessage(AIMessageType.ASSISTANT, message, meta);
    }

    @NotNull
    public static AIMessage functionCall(@NotNull AIFunctionCall functionCall, @NotNull AIFunctionResult result) {
        return new AIMessage(functionCall, result, null);
    }

    @NotNull
    public static AIMessage warningMessage(@NotNull String message) {
        return new AIMessage(AIMessageType.WARNING, message, null);
    }

    @NotNull
    public static AIMessage errorMessage(@NotNull Throwable throwable) {
        return new AIMessage(AIMessageType.ERROR, CommonUtils.toString((Object)CommonUtils.getAllExceptionMessages((Throwable)throwable), (String)"Unknown error"), null);
    }

    @NotNull
    public static AIMessage userAutoMessage(@NotNull String prompt, @NotNull String uiMessage) {
        return new AIMessage(AIMessageType.USER, prompt, uiMessage, LocalDateTime.now(), null);
    }

    public AIMessage(@NotNull AIMessageType role, @NotNull String content, @Nullable List<AIMessageMeta> meta) {
        this(role, content, content, LocalDateTime.now(), meta);
    }

    public static AIMessage functionMessage(@NotNull String id, @NotNull String payload, @NotNull AIMessageType type) {
        return new AIMessage(type, payload, null, LocalDateTime.now(), null, id);
    }

    public String toString() {
        return "Message (" + String.valueOf((Object)this.role) + "): " + this.content;
    }

    public boolean isAutoGenerated() {
        return this.displayMessage != null && !CommonUtils.equalObjects((Object)this.displayMessage, (Object)this.content);
    }

    public String getDisplayMessage() {
        return this.displayMessage != null ? this.displayMessage : this.content;
    }

    public String getRawDisplayMessage() {
        return this.displayMessage;
    }

    @NotNull
    public AIMessageType getRole() {
        return this.role;
    }

    @NotNull
    public String getContent() {
        return this.content;
    }

    @Nullable
    public String getFunctionCallName() {
        return this.functionCallName;
    }

    @NotNull
    public LocalDateTime getTime() {
        return this.time;
    }

    @Nullable
    public AIFunctionCall getFunctionCall() {
        return this.functionCall;
    }

    @Nullable
    public AIFunctionResult getFunctionResult() {
        return this.functionResult;
    }

    @Nullable
    public List<AIMessageMeta> getMeta() {
        return this.meta;
    }

    public AIMessage withContent(String newContent) {
        return new AIMessage(this.role, newContent, this.displayMessage, this.time, this.meta);
    }
}

