/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry.driver;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableWithProgress;
import org.jkiss.dbeaver.registry.driver.DriverDescriptor;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;
import org.objectweb.asm.ClassReader;

public class DriverClassFindJob
implements DBRRunnableWithProgress {
    private static final Log log = Log.getLog(DriverClassFindJob.class);
    public static final String OBJECT_CLASS_NAME = "java/lang/Object";
    public static final String CLASS_FILE_EXT = ".class";
    private List<String> driverClassNames = new ArrayList<String>();
    private final DriverDescriptor driver;
    private final String interfaceName;
    private final boolean isInterface;

    public DriverClassFindJob(DBPDriver driver, String interfaceName, boolean isInterface) {
        this.driver = (DriverDescriptor)driver;
        this.interfaceName = interfaceName.replace(".", "/");
        this.isInterface = isInterface;
    }

    public List<String> getDriverClassNames() {
        return this.driverClassNames;
    }

    public void run(DBRProgressMonitor monitor) {
        this.findDriverClasses(monitor);
    }

    private void findDriverClasses(DBRProgressMonitor monitor) {
        List<Path> libFiles = this.driver.getDefaultDriverLoader().getAllLibraryFiles(monitor);
        ArrayList<URL> libURLs = new ArrayList<URL>();
        for (Path libFile : libFiles) {
            if (libFile == null || !Files.exists(libFile, new LinkOption[0]) || Files.isDirectory(libFile, new LinkOption[0])) continue;
            try {
                libURLs.add(libFile.toUri().toURL());
            }
            catch (MalformedURLException e) {
                log.debug((Object)e);
            }
        }
        URLClassLoader findCL = new URLClassLoader(libURLs.toArray(new URL[0]));
        for (Path libFile : libFiles) {
            if (monitor.isCanceled()) break;
            if (Files.isDirectory(libFile, new LinkOption[0])) continue;
            this.findDriverClasses(monitor, findCL, libFile);
        }
    }

    private void findDriverClasses(DBRProgressMonitor monitor, ClassLoader findCL, Path libFile) {
        String jarName = libFile.getFileName().toString();
        if (!jarName.endsWith(".jar") && !jarName.endsWith(".zip")) {
            return;
        }
        try (JarFile currentFile = new JarFile(libFile.toFile(), false);){
            monitor.beginTask(jarName, currentFile.size());
            Enumeration<JarEntry> e = currentFile.entries();
            while (e.hasMoreElements() && !monitor.isCanceled()) {
                JarEntry current = e.nextElement();
                String fileName = current.getName();
                if (!fileName.endsWith(CLASS_FILE_EXT) || fileName.contains("$")) continue;
                String className = fileName.replaceAll("/", ".").replace(CLASS_FILE_EXT, "");
                monitor.subTask(className);
                try {
                    if (this.implementsInterface(currentFile, current, 0)) {
                        this.driverClassNames.add(className);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                monitor.worked(1);
            }
            monitor.done();
        }
        catch (IOException e) {
            log.debug((Object)e);
        }
    }

    private boolean implementsInterface(JarFile currentFile, JarEntry current, int depth) throws IOException {
        try (InputStream classStream = currentFile.getInputStream(current);){
            ClassReader cr = new ClassReader(classStream);
            int access = cr.getAccess();
            if (depth == 0 && ((access & 1) == 0 || (access & 0x400) != 0)) {
                boolean bl = false;
                return bl;
            }
            String superName = cr.getSuperName();
            if (this.isInterface) {
                JarEntry jarEntry;
                Object[] interfaces = cr.getInterfaces();
                if (ArrayUtils.contains((Object[])interfaces, (Object)this.interfaceName)) {
                    boolean bl = true;
                    return bl;
                }
                if (!CommonUtils.isEmpty((String)superName) && !superName.equals(OBJECT_CLASS_NAME) && (jarEntry = currentFile.getJarEntry(superName + CLASS_FILE_EXT)) != null) {
                    boolean bl = this.implementsInterface(currentFile, jarEntry, depth + 1);
                    return bl;
                }
                for (Object intName : interfaces) {
                    JarEntry jarEntry2 = currentFile.getJarEntry((String)intName + CLASS_FILE_EXT);
                    if (jarEntry2 == null || !this.implementsInterface(currentFile, jarEntry2, depth + 1)) continue;
                    boolean bl = true;
                    return bl;
                }
            } else if (superName != null) {
                if (this.interfaceName.equals(superName)) {
                    boolean interfaces = true;
                    return interfaces;
                }
                JarEntry jarEntry = currentFile.getJarEntry(superName + CLASS_FILE_EXT);
                if (jarEntry != null && this.implementsInterface(currentFile, jarEntry, depth + 1)) {
                    boolean bl = true;
                    return bl;
                }
            }
        }
        return false;
    }
}

