/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.widgets.Control;
import org.jkiss.utils.CommonUtils;

public class CompositeSelectionProvider
implements ISelectionProvider {
    private List<ISelectionChangedListener> listeners = new ArrayList<ISelectionChangedListener>();
    private ISelectionProvider provider;
    private ISelection selection = StructuredSelection.EMPTY;

    public void trackProvider(Control control, final ISelectionProvider selectionProvider) {
        control.addFocusListener((FocusListener)new FocusAdapter(this){
            final /* synthetic */ CompositeSelectionProvider this$0;
            {
                this.this$0 = this$0;
            }

            public void focusGained(FocusEvent e) {
                this.this$0.setProvider(selectionProvider);
            }
        });
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.add(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.remove(listener);
    }

    public ISelection getSelection() {
        ISelectionProvider cp = this.getProvider();
        if (cp != null) {
            return cp.getSelection();
        }
        return this.selection;
    }

    public void setSelection(ISelection selection) {
        ISelectionProvider cp = this.getProvider();
        if (cp != null) {
            cp.setSelection(selection);
        } else {
            this.selection = selection;
            if (!CommonUtils.isEmpty(this.listeners)) {
                SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, selection);
                for (ISelectionChangedListener listener : this.listeners) {
                    listener.selectionChanged(event);
                }
            }
        }
    }

    public ISelectionProvider getProvider() {
        return this.provider;
    }

    public void setProvider(ISelectionProvider newProvider) {
        if (this.provider != newProvider) {
            ISelection newSelection = null;
            if (!CommonUtils.isEmpty(this.listeners)) {
                if (this.provider != null) {
                    for (ISelectionChangedListener listener : this.listeners) {
                        this.provider.removeSelectionChangedListener(listener);
                    }
                }
                if (newProvider != null) {
                    for (ISelectionChangedListener listener : this.listeners) {
                        newProvider.addSelectionChangedListener(listener);
                    }
                    newSelection = newProvider.getSelection();
                } else {
                    newSelection = this.selection;
                }
            }
            this.provider = newProvider;
            if (newSelection != null) {
                this.setSelection(newSelection);
            }
        }
    }
}

