/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.altibase.model;

import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ext.altibase.model.AltibaseDataTypeDomain;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPIdentifierCase;
import org.jkiss.dbeaver.model.DBPKeywordType;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCDatabaseMetaData;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCDataSource;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCSQLDialect;
import org.jkiss.dbeaver.model.impl.sql.BasicSQLDialect;
import org.jkiss.dbeaver.model.sql.SQLConstants;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLDialectDDLExtension;
import org.jkiss.dbeaver.model.sql.SQLDialectSchemaController;
import org.jkiss.dbeaver.model.sql.SQLSyntaxManager;
import org.jkiss.dbeaver.model.sql.parser.SQLParserActionKind;
import org.jkiss.dbeaver.model.sql.parser.SQLRuleManager;
import org.jkiss.dbeaver.model.sql.parser.SQLTokenPredicateSet;
import org.jkiss.dbeaver.model.sql.parser.tokens.SQLTokenType;
import org.jkiss.dbeaver.model.sql.parser.tokens.predicates.TokenPredicateFactory;
import org.jkiss.dbeaver.model.sql.parser.tokens.predicates.TokenPredicateNode;
import org.jkiss.dbeaver.model.sql.parser.tokens.predicates.TokenPredicateSet;
import org.jkiss.dbeaver.model.sql.parser.tokens.predicates.TokenPredicatesCondition;
import org.jkiss.utils.ArrayUtils;

public class AltibaseSQLDialect
extends JDBCSQLDialect
implements SQLDialectDDLExtension,
SQLDialectSchemaController {
    private SQLTokenPredicateSet cachedDialectSkipTokenPredicates = null;
    private static final String[] ALTIBASE_NON_TRANSACTIONAL_KEYWORDS = (String[])ArrayUtils.concatArrays((Object[])BasicSQLDialect.NON_TRANSACTIONAL_KEYWORDS, (Object[])new String[]{"CREATE", "ALTER", "DROP", "ANALYZE", "VALIDATE"});
    private static final String[] ALTIBASE_BLOCK_HEADERS = new String[]{"DECLARE", "PACKAGE"};
    private static final String[][] ALTIBASE_BEGIN_END_BLOCK = new String[][]{{"BEGIN", "END"}, {"LOOP", "END LOOP"}, {"CASE", "END CASE"}};
    private static final String[] ALTIBASE_INNER_BLOCK_PREFIXES = new String[]{"AS", "IS"};
    public static final String[] OTHER_TYPES_FUNCTIONS = new String[]{"SYSDATE"};
    public static final String[] ALTIBASE_ONLY_KEYWORDS = new String[]{"ACCESS", "AGER", "APPLY", "ARCHIVE", "ARCHIVELOG", "AUDIT", "AUTHID", "AUTOEXTEND", "BACKUP", "BODY", "BULK", "CACHE", "CHECKPOINT", "COMMENT", "COMPILE", "COMPRESS", "COMPRESSED", "CONJOIN", "CONNECT_BY_ROOT", "CONSTANT", "CURRENT_USER", "DATABASE", "DECRYPT", "DELAUDIT", "DEQUEUE", "DIRECTORY", "DISABLE", "DISASTER", "DISJOIN", "DUMP_CALLSTACKS", "ELSEIF", "ELSIF", "ENABLE", "ENQUEUE", "EXIT", "EXTENT", "EXTENTSIZE", "FIFO", "FIXED", "FLASHBACK", "FLUSH", "FLUSHER", "IDENTIFIED", "INITRANS", "INSTEAD", "KEEP", "LESS", "LIBRARY", "LIFO", "LINK", "LINKER", "LOB", "LOCALUNIQUE", "LOCK", "LOGANCHOR", "LOGGING", "LOOP", "MATERIALIZED", "MAXROWS", "MAXTRANS", "MINUS", "MODE", "MODIFY", "MOVE", "MOVEMENT", "NOARCHIVELOG", "NOAUDIT", "NOCACHE", "NOCOPY", "NOCYCLE", "NOLOGGING", "NOPARALLEL", "OFF", "OFFLINE", "ONLINE", "PACKAGE", "PARALLEL", "PARAMETERS", "PARTITIONS", "PIVOT", "PURGE", "QUEUE", "RAISE", "REBUILD", "RECOVER", "REMOTE_TABLE", "REMOTE_TABLE_STORE", "REMOVE", "REORGANIZE", "REPLACE", "REPLICATION", "RETURNING", "ROWCOUNT", "ROWNUM", "ROWTYPE", "SEGMENT", "SHARD", "SHRINK_MEMPOOL", "SPECIFICATION", "SPLIT", "SQLCODE", "SQLERRM", "STEP", "STORAGE", "STORE", "SUPPLEMENTAL", "SYNONYM", "TABLESPACE", "THAN", "TOP", "TRUNCATE", "TYPESET", "UNCOMPRESSED", "UNLOCK", "UNPIVOT", "UNTIL", "VARIABLE", "VARIABLE_LARGE", "VC2COLL", "VOLATILE", "WAIT", "WHILE", "WRAPPED", "_PROWID"};
    public static final String[] ALTIBASE_ONLY_FUNCTIONS = new String[]{"ACOS", "ADD_MONTHS", "AESDECRYPT", "AESENCRYPT", "ASCII", "ASCIISTR", "ASIN", "ATAN", "ATAN2", "BASE64_DECODE", "BASE64_DECODE_STR", "BASE64_ENCODE", "BASE64_ENCODE_STR", "BINARY_LENGTH", "BIN_TO_NUM", "BITAND", "BITNOT", "BITOR", "BITXOR", "CASE2", "CEIL", "CHOSUNG", "CHR", "COALESCE", "CONCAT", "CONVERT", "CONV_TIMEZONE", "CORR", "COS", "COSH", "COVAR_POP", "COVAR_SAMP", "CUME_DIST", "CURRENT_DATE", "CURRENT_TIMESTAMP", "DATEADD", "DATEDIFF", "DATENAME", "DATE_TO_UNIX", "DB_TIMEZONE", "DECODE", "DENSE_RANK", "DESDECRYPT", "DESENCRYPT", "DIGEST", "DIGITS", "DUMP", "EMPTY_BLOB", "EMPTY_CLOB", "EXP", "EXTRACT", "FIRST", "FIRST_VALUE", "FIRST_VALUE_IGNORE_NULLS", "GREATEST", "GROUPING", "GROUPING_ID", "GROUP_CONCAT", "HEX_DECODE", "HEX_ENCODE", "HEX_TO_NUM", "HOST_NAME", "INITCAP", "INSTR", "ISNUMERIC", "LAG", "LAG_IGNORE_NULLS", "LAST", "LAST_DAY", "LAST_VALUE", "LAST_VALUE_IGNORE_NULLS", "LEAD", "LEAD_IGNORE_NULLS", "LEAST", "LISTAGG", "LN", "LNNVL", "LOG", "LPAD", "LTRIM", "MEDIAN", "MOD", "MONTHS_BETWEEN", "MSG_CREATE_QUEUE", "MSG_DROP_QUEUE", "MSG_RCV_QUEUE", "MSG_SND_QUEUE", "NCHR", "NEXT_DAY", "NTH_VALUE", "NTH_VALUE_IGNORE_NULLS", "NTILE", "NULLIF", "NUMAND", "NUMOR", "NUMSHIFT", "NUMXOR", "NVL", "NVL2", "OCT_TO_NUM", "PKCS7PAD16", "PKCS7UNPAD16", "QUOTE_PRINTABLE_DECODE", "QUOTE_PRINTABLE_ENCODE", "RAND", "RANDOM", "RANDOM_STRING", "RANK", "RATIO_TO_REPORT", "RAW_CONCAT", "RAW_SIZEOF", "RAW_TO_FLOAT", "RAW_TO_INTEGER", "RAW_TO_NUMERIC", "RAW_TO_VARCHAR", "REGEXP_COUNT", "REGEXP_INSTR", "REGEXP_REPLACE", "REGEXP_SUBSTR", "REPLACE2", "REPLICATE", "REVERSE_STR", "ROUND", "ROWNUM", "ROW_NUMBER", "RPAD", "RTRIM", "SENDMSG", "SESSION_ID", "SESSION_TIMEZONE", "SIGN", "SIN", "SINH", "SIZEOF", "STATS_ONE_WAY_ANOVA", "STDDEV", "STDDEV_POP", "STDDEV_SAMP", "STUFF", "SUBRAW", "SUBSTRB", "SYSTIMESTAMP", "SYS_CONNECT_BY_PATH", "SYS_CONTEXT", "SYS_GUID_STR", "TAN", "TANH", "TDESDECRYPT", "TDESENCRYPT", "TO_BIN", "TO_CHAR", "TO_DATE", "TO_HEX", "TO_INTERVAL", "TO_NCHAR", "TO_NUMBER", "TO_OCT", "TO_RAW", "TRANSLATE", "TRIPLE_DESDECRYPT", "TRIPLE_DESENCRYPT", "TRUNC", "UNISTR", "UNIX_DATE", "UNIX_TIMESTAMP", "UNIX_TO_DATE", "USER_ID", "USER_LOCK_RELEASE", "USER_LOCK_REQUEST", "USER_NAME", "VARIANCE", "VAR_POP", "VAR_SAMP"};
    private static final String[] ALTIBASE_FUNCTIONS = new String[]{"AVG", "CORR", "COUNT", "COVAR_POP", "COVAR_SAMP", "CUME_DIST", "FIRST", "GROUP_CONCAT", "LAST", "LISTAGG", "MAX", "MIN", "PERCENTILE_CONT", "PERCENTILE_DISC", "PERCENT_RANK", "RANK", "STATS_ONE_WAY_ANOVA", "STDDEV", "STDDEV_POP", "STDDEV_SAMP", "SUM", "VARIANCE", "VAR_POP", "VAR_SAMP", "MEDIAN", "LISTAGG", "RATIO_TO_REPORT", "GROUP_CONCAT", "RANK", "DENSE_RANK", "ROW_NUMBER", "LAG", "LAG_IGNORE_NULLS", "LEAD", "LEAD_IGNORE_NULLS", "NTILE", "FIRST", "LAST", "FIRST_VALUE", "FIRST_VALUE_IGNORE_NULLS", "LAST_VALUE", "LAST_VALUE_IGNORE_NULLS", "NTH_VALUE", "NTH_VALUE_IGNORE_NULLS", "ABS", "ACOS", "ASIN", "ATAN", "ATAN2", "CEIL", "COS", "COSH", "EXP", "FLOOR", "ISNUMERIC", "LN", "LOG", "MOD", "NUMAND", "NUMOR", "NUMSHIFT", "NUMXOR", "POWER", "RAND", "RANDOM", "ROUND", "SIGN", "SIN", "SINH", "SQRT", "TAN", "TANH", "TRUNC", "BITAND", "BITOR", "BITXOR", "BITNOT", "CHR", "CHOSUNG", "CONCAT", "DIGITS", "INITCAP", "LOWER", "LPAD", "LTRIM", "NCHR", "PKCS7PAD16", "PKCS7UNPAD16", "RANDOM_STRING", "REGEXP_COUNT", "REGEXP_REPLACE", "REPLICATE", "REPLACE2", "REVERSE_STR", "RPAD", "RTRIM", "STUFF", "SUBSTRB", "TRANSLATE", "TRIM", "UPPER", "ASCII", "CHAR_LENGTH", "DIGEST", "INSTR", "OCTET_LENGTH", "REGEXP_INSTR", "REGEXP_SUBSTR", "SIZEOF", "ADD_MONTHS", "DATEADD", "DATEDIFF", "DATENAME", "EXTRACT", "LAST_DAY", "MONTHS_BETWEEN", "NEXT_DAY", "SESSION_TIMEZONE", "SYSTIMESTAMP", "UNIX_DATE", "UNIX_TIMESTAMP", "CURRENT_DATE", "CURRENT_TIMESTAMP", "DB_TIMEZONE", "CONV_TIMEZONE", "ROUND", "TRUNC", "ASCIISTR", "BIN_TO_NUM", "CONVERT", "DATE_TO_UNIX", "HEX_ENCODE", "HEX_DECODE", "HEX_TO_NUM", "OCT_TO_NUM", "RAW_TO_FLOAT", "RAW_TO_INTEGER", "RAW_TO_NUMERIC", "RAW_TO_VARCHAR", "TO_BIN", "TO_CHAR", "TO_DATE", "TO_HEX", "TO_INTERVAL", "TO_NCHAR", "TO_NUMBER", "TO_OCT", "TO_RAW", "UNISTR", "UNIX_TO_DATE", "AESDECRYPT", "AESENCRYPT", "DESENCRYPT", "DESDECRYPT", "TDESDECRYPT", "TRIPLE_DESDECRYPT", "TDESENCRYPT", "TRIPLE_DESENCRYPT", "BASE64_DECODE", "BASE64_DECODE_STR", "BASE64_ENCODE", "BASE64_ENCODE_STR", "BINARY_LENGTH", "CASE2", "COALESCE", "DECODE", "DIGEST", "DUMP", "EMPTY_BLOB", "EMPTY_CLOB", "GREATEST", "GROUPING", "GROUPING_ID", "HOST_NAME", "LEAST", "LNNVL", "MSG_CREATE_QUEUE", "MSG_DROP_QUEUE", "MSG_SND_QUEUE", "MSG_RCV_QUEUE", "NULLIF", "NVL", "NVL2", "QUOTE_PRINTABLE_DECODE", "QUOTE_PRINTABLE_ENCODE", "RAW_CONCAT", "RAW_SIZEOF", "ROWNUM", "SENDMSG", "USER_ID", "USER_NAME", "SESSION_ID", "SUBRAW", "SYS_CONNECT_BY_PATH", "SYS_GUID_STR", "USER_LOCK_REQUEST", "USER_LOCK_RELEASE", "SYS_CONTEXT"};
    private static final String[] ALTIBASE_KEYWORDS = new String[]{"ACCESS", "ADD", "AFTER", "AGER", "ALL", "ALTER", "AND", "ANY", "APPLY", "ARCHIVE", "ARCHIVELOG", "AS", "ASC", "AT", "AUDIT", "AUTHID", "AUTOEXTEND", "BACKUP", "BEFORE", "BEGIN", "BETWEEN", "BODY", "BULK", "BY", "CASCADE", "CASE", "CAST", "CHECK", "CHECKPOINT", "CLOSE", "COALESCE", "COLUMN", "COMMENT", "COMMIT", "COMPILE", "COMPRESS", "COMPRESSED", "CONJOIN", "CONNECT", "CONNECT_BY_ROOT", "CONSTANT", "CONSTRAINT", "CONSTRAINTS", "CONTINUE", "CREATE", "CROSS", "CUBE", "CURRENT_USER", "CURSOR", "CYCLE", "DATABASE", "DECLARE", "DECRYPT", "DEFAULT", "DEFINER", "DELAUDIT", "DELETE", "DEQUEUE", "DESC", "DETERMINISTIC", "DIRECTORY", "DISABLE", "DISASTER", "DISCONNECT", "DISJOIN", "DISTINCT", "DROP", "DUMP_CALLSTACKS", "EACH", "ELSE", "ELSEIF", "ELSIF", "ENABLE", "END", "ENQUEUE", "ESCAPE", "EXCEPTION", "EXEC", "EXECUTE", "EXISTS", "EXIT", "EXTENT", "EXTENTSIZE", "FALSE", "FETCH", "FIFO", "FIXED", "FLASHBACK", "FLUSH", "FLUSHER", "FOLLOWING", "FOR", "FOREIGN", "FROM", "FULL", "FUNCTION", "GOTO", "GRANT", "GROUP", "HAVING", "IDENTIFIED", "IF", "IN", "INDEX", "INITRANS", "INNER", "INSERT", "INSTEAD", "INTERSECT", "INTO", "IS", "ISOLATION", "JOIN", "KEEP", "KEY", "LANGUAGE", "LATERAL", "LEFT", "LESS", "LEVEL", "LIBRARY", "LIFO", "LIKE", "LIMIT", "LINK", "LINKER", "LOB", "LOCAL", "LOCALUNIQUE", "LOCK", "LOGANCHOR", "LOGGING", "LOOP", "MATERIALIZED", "MAXROWS", "MAXTRANS", "MERGE", "MINUS", "MODE", "MODIFY", "MOVE", "MOVEMENT", "NEW", "NOARCHIVELOG", "NOAUDIT", "NOCOPY", "NOCYCLE", "NOLOGGING", "NOPARALLEL", "NOT", "NULL", "NULLS", "OF", "OFF", "OFFLINE", "OLD", "ON", "ONLINE", "OPEN", "OR", "ORDER", "OTHERS", "OUT", "OUTER", "OVER", "PACKAGE", "PARALLEL", "PARAMETERS", "PARTITION", "PARTITIONS", "PIVOT", "PRECEDING", "PRIMARY", "PRIOR", "PRIVILEGES", "PROCEDURE", "PURGE", "QUEUE", "RAISE", "READ", "REBUILD", "RECOVER", "REFERENCES", "REFERENCING", "REMOTE_TABLE", "REMOTE_TABLE_STORE", "REMOVE", "RENAME", "REORGANIZE", "REPLACE", "REPLICATION", "RETURN", "RETURNING", "REVOKE", "RIGHT", "ROLLBACK", "ROLLUP", "ROW", "ROWCOUNT", "ROWNUM", "ROWTYPE", "SAVEPOINT", "SEGMENT", "SELECT", "SEQUENCE", "SESSION", "SET", "SHARD", "SHRINK_MEMPOOL", "SOME", "SPECIFICATION", "SPLIT", "SQLCODE", "SQLERRM", "START", "STATEMENT", "STEP", "STORAGE", "STORE", "SUPPLEMENTAL", "SYNONYM", "TABLE", "TABLESPACE", "TEMPORARY", "THAN", "THEN", "TO", "TOP", "TRIGGER", "TRUE", "TRUNCATE", "TYPE", "TYPESET", "UNCOMPRESSED", "UNION", "UNIQUE", "UNLOCK", "UNPIVOT", "UNTIL", "UPDATE", "USING", "VALUES", "VARIABLE", "VARIABLE_LARGE", "VC2COLL", "VIEW", "VOLATILE", "WAIT", "WHEN", "WHENEVER", "WHERE", "WHILE", "WITH", "WITHIN", "WORK", "WRAPPED", "WRITE", "_PROWID", "CACHE", "NOCACHE"};

    public AltibaseSQLDialect() {
        super("Altibase", "altibase");
        this.setUnquotedIdentCase(DBPIdentifierCase.UPPER);
    }

    @NotNull
    public String[] getDDLKeywords() {
        return super.getDDLKeywords();
    }

    public String[] getBlockHeaderStrings() {
        return ALTIBASE_BLOCK_HEADERS;
    }

    @Nullable
    public String[] getInnerBlockPrefixes() {
        return ALTIBASE_INNER_BLOCK_PREFIXES;
    }

    public String[][] getBlockBoundStrings() {
        return ALTIBASE_BEGIN_END_BLOCK;
    }

    public void initDriverSettings(JDBCSession session, JDBCDataSource dataSource, JDBCDatabaseMetaData metaData) {
        super.initDriverSettings(session, dataSource, metaData);
        this.addFunctions(Arrays.asList(ALTIBASE_ONLY_FUNCTIONS));
        this.addSQLKeywords(Arrays.asList(ALTIBASE_ONLY_KEYWORDS));
        this.addKeywords(Arrays.asList(OTHER_TYPES_FUNCTIONS), DBPKeywordType.OTHER);
        this.turnFunctionIntoKeyword("TRUNCATE");
        this.cachedDialectSkipTokenPredicates = this.makeDialectSkipTokenPredicates(dataSource);
    }

    protected void loadDataTypesFromDatabase(JDBCDataSource dataSource) {
        super.loadDataTypesFromDatabase(dataSource);
        this.addDataTypes(Stream.of(AltibaseDataTypeDomain.values()).map(Enum::name).collect(Collectors.toList()));
    }

    @Nullable
    public String getDualTableName() {
        return "DUAL";
    }

    @NotNull
    public String[] getNonTransactionKeywords() {
        return ALTIBASE_NON_TRANSACTIONAL_KEYWORDS;
    }

    @NotNull
    public String[] getScriptDelimiters() {
        return new String[]{";", "/"};
    }

    public boolean supportsInsertAllDefaultValuesStatement() {
        return false;
    }

    public boolean supportsAliasInConditions() {
        return false;
    }

    public String getClobComparingPart(@NotNull String columnName) {
        return "DBMS_LOB.COMPARE(%s,?) = 0".formatted(columnName);
    }

    public boolean supportsAliasInSelect() {
        return true;
    }

    public boolean supportsTableDropCascade() {
        return true;
    }

    @NotNull
    public SQLTokenPredicateSet getSkipTokenPredicates() {
        return this.cachedDialectSkipTokenPredicates == null ? super.getSkipTokenPredicates() : this.cachedDialectSkipTokenPredicates;
    }

    @NotNull
    private SQLTokenPredicateSet makeDialectSkipTokenPredicates(JDBCDataSource dataSource) {
        SQLSyntaxManager syntaxManager = new SQLSyntaxManager();
        syntaxManager.init((SQLDialect)this, dataSource.getContainer().getPreferenceStore());
        SQLRuleManager ruleManager = new SQLRuleManager(syntaxManager);
        ruleManager.loadRules((DBPDataSource)dataSource, false);
        TokenPredicateFactory tt = TokenPredicateFactory.makeDialectSpecificFactory((SQLRuleManager)ruleManager);
        TokenPredicateSet conditions = TokenPredicateSet.of((TokenPredicatesCondition[])new TokenPredicatesCondition[]{new TokenPredicatesCondition(SQLParserActionKind.BEGIN_BLOCK, tt.sequence(new Object[]{"CREATE", tt.optional(new Object[]{"OR", "REPLACE"}), "PACKAGE", "BODY"}), tt.sequence(new TokenPredicateNode[0])), new TokenPredicatesCondition(SQLParserActionKind.SKIP_SUFFIX_TERM, tt.sequence(new Object[]{"CREATE", tt.optional(new Object[]{"OR", "REPLACE"}), tt.alternative(new Object[]{"FUNCTION", "PROCEDURE"})}), tt.sequence(new Object[]{tt.alternative(new Object[]{tt.sequence(new Object[]{"RETURN", SQLTokenType.T_TYPE}), "deterministor", "pipelined", "parallel_enable", "result_cache", ")", tt.sequence(new Object[]{"procedure", SQLTokenType.T_OTHER}), tt.sequence(new Object[]{SQLTokenType.T_OTHER, SQLTokenType.T_TYPE})}), ";"})), new TokenPredicatesCondition(SQLParserActionKind.BEGIN_BLOCK, tt.sequence(new TokenPredicateNode[0]), tt.sequence(new Object[]{tt.not("END"), "IF", tt.not("EXISTS")})), new TokenPredicatesCondition(SQLParserActionKind.BEGIN_BLOCK, tt.sequence(new Object[]{"CREATE", tt.optional(new Object[]{"OR", "REPLACE"}), "TYPESET"}), tt.sequence(new TokenPredicateNode[0])), new TokenPredicatesCondition(SQLParserActionKind.SKIP_SUFFIX_TERM, tt.token((Object)"END"), tt.sequence(new Object[]{";"}))});
        return conditions;
    }

    public boolean isDisableScriptEscapeProcessing() {
        return false;
    }

    public String getAutoIncrementKeyword() {
        return null;
    }

    public boolean supportsCreateIfExists() {
        return false;
    }

    public String getTimestampDataType() {
        return AltibaseDataTypeDomain.DATE.getTypeName();
    }

    public String getBigIntegerType() {
        return AltibaseDataTypeDomain.BIGINT.getTypeName();
    }

    public String getBlobDataType() {
        return AltibaseDataTypeDomain.BLOB.getTypeName();
    }

    public String getClobDataType() {
        return AltibaseDataTypeDomain.CLOB.getTypeName();
    }

    public String getUuidDataType() {
        return "";
    }

    public String getBooleanDataType() {
        return "";
    }

    @NotNull
    public String getAlterColumnOperation() {
        return "MODIFY";
    }

    public boolean supportsAlterColumnSet() {
        return false;
    }

    public boolean supportsAlterHasColumn() {
        return false;
    }

    @NotNull
    public String getSchemaExistQuery(@NotNull String schemaName) {
        return "SELECT 1 FROM SYSTEM_.SYS_USERS_ WHERE USER_NAME='" + schemaName + "'";
    }

    @NotNull
    public String getCreateSchemaQuery(@NotNull String schemaName) {
        return "CREATE USER \"" + schemaName + "\" IDENTIFIED BY \"" + schemaName + "\"";
    }

    public static void main(String[] args) {
        AltibaseSQLDialect.filter(ALTIBASE_KEYWORDS, SQLConstants.SQL2003_RESERVED_KEYWORDS);
        AltibaseSQLDialect.filter(ALTIBASE_FUNCTIONS, SQLConstants.SQL2003_FUNCTIONS);
    }

    private static void filter(String[] dbProvideNames, String[] sqlProvidedNames) {
    }

    public boolean supportsNoActionIndex() {
        return false;
    }

    private static /* synthetic */ boolean lambda$filter$2(Set defaultWordList, String e) {
        return !defaultWordList.contains(e);
    }

    private static /* synthetic */ String[] lambda$filter$1(int x$0) {
        return new String[x$0];
    }

    private static /* synthetic */ String[] lambda$filter$0(int x$0) {
        return new String[x$0];
    }
}

