/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql;

import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IBlockTextSelection;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewerExtension;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationRulerColumn;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.IAnnotationAccess;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ICharacterPairMatcher;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.ISharedTextColors;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.IVerticalRulerColumn;
import org.eclipse.jface.text.source.OverviewRuler;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.source.VerticalRuler;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.eclipse.jface.text.source.projection.ProjectionSupport;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.internal.dialogs.PropertyDialog;
import org.eclipse.ui.services.IServiceLocator;
import org.eclipse.ui.texteditor.DefaultRangeIndicator;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.IDocumentProviderExtension;
import org.eclipse.ui.texteditor.IStatusField;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.SourceViewerDecorationSupport;
import org.eclipse.ui.texteditor.TextOperationAction;
import org.eclipse.ui.texteditor.spelling.SpellingAnnotation;
import org.eclipse.ui.texteditor.templates.ITemplatesPage;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPContextProvider;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourceContainerProvider;
import org.jkiss.dbeaver.model.DBPErrorAssistant;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.impl.sql.BasicSQLDialect;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceListener;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLConstants;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLPartitionScanner;
import org.jkiss.dbeaver.model.sql.SQLQuery;
import org.jkiss.dbeaver.model.sql.SQLQueryParameter;
import org.jkiss.dbeaver.model.sql.SQLScriptElement;
import org.jkiss.dbeaver.model.sql.SQLSyntaxManager;
import org.jkiss.dbeaver.model.sql.completion.SQLCompletionContext;
import org.jkiss.dbeaver.model.sql.parser.SQLParserContext;
import org.jkiss.dbeaver.model.sql.parser.SQLParserPartitions;
import org.jkiss.dbeaver.model.sql.parser.SQLRuleManager;
import org.jkiss.dbeaver.model.sql.parser.SQLScriptParser;
import org.jkiss.dbeaver.model.sql.parser.SQLWordPartDetector;
import org.jkiss.dbeaver.model.sql.semantics.SQLDocumentSyntaxContext;
import org.jkiss.dbeaver.model.sql.semantics.completion.SQLQueryCompletionContext;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.ActionUtils;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.ICommentsSupport;
import org.jkiss.dbeaver.ui.IErrorVisualizer;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIStyles;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.AbstractStorageEditorInput;
import org.jkiss.dbeaver.ui.editors.EditorUtils;
import org.jkiss.dbeaver.ui.editors.StringEditorInput;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorContributor;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorControl;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorCustomActions;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorSourceViewer;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorSourceViewerConfiguration;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorUtils;
import org.jkiss.dbeaver.ui.editors.sql.SQLMarkerAnnotationAccess;
import org.jkiss.dbeaver.ui.editors.sql.SQLMatchingCharacterPainter;
import org.jkiss.dbeaver.ui.editors.sql.SQLObjectDocumentProvider;
import org.jkiss.dbeaver.ui.editors.sql.SQLOccurrencesHighlighter;
import org.jkiss.dbeaver.ui.editors.sql.SQLSourceViewerDecorationSupport;
import org.jkiss.dbeaver.ui.editors.sql.internal.SQLEditorMessages;
import org.jkiss.dbeaver.ui.editors.sql.semantics.SQLBackgroundParsingJob;
import org.jkiss.dbeaver.ui.editors.sql.semantics.SQLEditorOutlinePage;
import org.jkiss.dbeaver.ui.editors.sql.semantics.SQLEditorSemanticMarkersManager;
import org.jkiss.dbeaver.ui.editors.sql.semantics.SQLSemanticErrorAnnotation;
import org.jkiss.dbeaver.ui.editors.sql.syntax.SQLCharacterPairMatcher;
import org.jkiss.dbeaver.ui.editors.sql.syntax.SQLEditorCompletionContext;
import org.jkiss.dbeaver.ui.editors.sql.syntax.SQLProblemAnnotation;
import org.jkiss.dbeaver.ui.editors.sql.syntax.SQLRuleScanner;
import org.jkiss.dbeaver.ui.editors.sql.templates.SQLTemplatesPage;
import org.jkiss.dbeaver.ui.editors.sql.util.SQLSymbolInserter;
import org.jkiss.dbeaver.ui.editors.text.BaseTextEditor;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.Pair;

public abstract class SQLEditorBase
extends BaseTextEditor
implements DBPContextProvider,
IErrorVisualizer,
DBPPreferenceListener {
    protected static final Log log = Log.getLog(SQLEditorBase.class);
    public static final long MAX_FILE_LENGTH_FOR_RULES = 2048000L;
    private static final int SCROLL_ON_RESIZE_THRESHOLD_PX = 10;
    static final String STATS_CATEGORY_SELECTION_STATE = "SelectionState";
    @NotNull
    private final SQLSyntaxManager syntaxManager = new SQLSyntaxManager();
    @NotNull
    private final SQLRuleScanner ruleScanner = new SQLRuleScanner();
    @Nullable
    private SQLParserContext parserContext;
    private ProjectionSupport projectionSupport;
    private SQLBackgroundParsingJob backgroundParsingJob;
    private SQLEditorOutlinePage outlinePage;
    private SQLEditorSemanticMarkersManager semanticMarkersManager;
    private boolean hasVerticalRuler = true;
    private SQLTemplatesPage templatesPage;
    private IPropertyChangeListener themeListener = new IPropertyChangeListener(){
        long lastUpdateTime = 0L;

        public void propertyChange(PropertyChangeEvent event) {
            if (event.getProperty().equals("CHANGE_CURRENT_THEME") || event.getProperty().startsWith("org.jkiss.dbeaver.sql.editor")) {
                if (this.lastUpdateTime > 0L && System.currentTimeMillis() - this.lastUpdateTime < 500L) {
                    return;
                }
                this.lastUpdateTime = System.currentTimeMillis();
                UIUtils.asyncExec(() -> {
                    ISourceViewer sourceViewer = SQLEditorBase.this.getSourceViewer();
                    if (sourceViewer != null) {
                        SQLEditorBase.this.reloadSyntaxRules();
                        sourceViewer.configure(SQLEditorBase.this.getSourceViewerConfiguration());
                    }
                });
            }
        }
    };
    private SQLEditorControl editorControl;
    private ICharacterPairMatcher characterPairMatcher;
    private SQLCompletionContext completionContext;
    private SQLOccurrencesHighlighter occurrencesHighlighter;
    private SQLSymbolInserter sqlSymbolInserter;
    private int lastQueryErrorPosition = -1;

    public SQLEditorBase() {
        PlatformUI.getWorkbench().getThemeManager().addPropertyChangeListener(this.themeListener);
        this.setSourceViewerConfiguration((SourceViewerConfiguration)new SQLEditorSourceViewerConfiguration(this, this.getPreferenceStore()));
        this.setKeyBindingScopes(this.getKeyBindingContexts());
        this.completionContext = new SQLEditorCompletionContext(this);
        DBWorkbench.getPlatform().getPreferenceStore().addPropertyChangeListener((DBPPreferenceListener)this);
    }

    public void gotoMarker(IMarker marker) {
        try {
            Object object = marker.getAttribute("org.jkiss.dbeaver.ui.editors.sql.semantics.semanticProblemAnnotation");
            if (object instanceof SQLSemanticErrorAnnotation) {
                SQLSemanticErrorAnnotation annotation = (SQLSemanticErrorAnnotation)((Object)object);
                IAnnotationModel annotationModel = this.getAnnotationModel();
                TextViewer textViewer = this.getTextViewer();
                if (annotationModel != null && textViewer != null) {
                    Position position = annotationModel.getPosition((Annotation)annotation);
                    if (!position.isDeleted) {
                        textViewer.setSelectedRange(position.getOffset(), position.getLength());
                        textViewer.revealRange(position.getOffset(), position.getLength());
                    }
                    return;
                }
            }
        }
        catch (CoreException e) {
            log.error((Object)"Error retrieving marker attribute", (Throwable)e);
        }
        super.gotoMarker(marker);
    }

    public SQLDocumentSyntaxContext getSyntaxContext() {
        return this.backgroundParsingJob == null ? null : this.backgroundParsingJob.getCurrentContext();
    }

    @Nullable
    public SQLQueryCompletionContext obtainCompletionContext(DBRProgressMonitor monitor, @NotNull Position completionRequestPosition) {
        return this.backgroundParsingJob == null ? null : this.backgroundParsingJob.obtainCompletionContext(monitor, completionRequestPosition);
    }

    protected void setDocumentProvider(IEditorInput input) {
        if (input instanceof StringEditorInput && !(this.getDocumentProvider() instanceof NonFileDocumentProvider)) {
            NonFileDocumentProvider prov = new NonFileDocumentProvider(this, (StringEditorInput)input);
            this.setDocumentProvider((IDocumentProvider)prov);
        }
        super.setDocumentProvider(input);
    }

    protected boolean isReadOnly() {
        IDocumentProvider provider = this.getDocumentProvider();
        return provider instanceof IDocumentProviderExtension && ((IDocumentProviderExtension)provider).isReadOnly((Object)this.getEditorInput());
    }

    public static boolean isBigScript(@Nullable IEditorInput editorInput) {
        if (editorInput != null) {
            File file = EditorUtils.getLocalFileFromInput((Object)editorInput);
            return file != null && file.length() > SQLEditorBase.getBigScriptFileLengthBoundary();
        }
        return false;
    }

    static long getBigScriptFileLengthBoundary() {
        return DBWorkbench.getPlatform().getPreferenceStore().getLong("SQLEditor.script.bigFileLengthBoundary");
    }

    static boolean isReadEmbeddedBinding() {
        return DBWorkbench.getPlatform().getPreferenceStore().getBoolean("SQLEditor.script.bind.embedded.read");
    }

    static boolean isWriteEmbeddedBinding() {
        return DBWorkbench.getPlatform().getPreferenceStore().getBoolean("SQLEditor.script.bind.embedded.write");
    }

    public boolean isAdvancedHighlightingEnabled() {
        return this.getActivePreferenceStore().getBoolean("SQLEditor.Highlighting.advanced.enable");
    }

    private void handleInputChange(IEditorInput input) {
        this.occurrencesHighlighter.updateInput(input);
    }

    protected void updateSelectionDependentActions() {
        super.updateSelectionDependentActions();
        this.updateStatusField(STATS_CATEGORY_SELECTION_STATE);
    }

    protected String[] getKeyBindingContexts() {
        return new String[]{"org.eclipse.ui.textEditorScope", "org.jkiss.dbeaver.ui.editors.sql", "org.jkiss.dbeaver.ui.editors.sql.script"};
    }

    protected void initializeEditor() {
        super.initializeEditor();
        this.occurrencesHighlighter = new SQLOccurrencesHighlighter(this);
        this.setEditorContextMenuId("#SQLEditorContext");
        this.setRulerContextMenuId("#SQLRulerContext");
    }

    @Nullable
    public DBPDataSource getDataSource() {
        DBCExecutionContext context = this.getExecutionContext();
        return context == null ? null : context.getDataSource();
    }

    public DBPPreferenceStore getActivePreferenceStore() {
        DBPDataSourceContainer container;
        if (this instanceof DBPDataSourceContainerProvider && (container = ((DBPDataSourceContainerProvider)this).getDataSourceContainer()) != null) {
            return container.getPreferenceStore();
        }
        DBPDataSource dataSource = this.getDataSource();
        return dataSource == null ? DBWorkbench.getPlatform().getPreferenceStore() : dataSource.getContainer().getPreferenceStore();
    }

    protected void handlePreferenceStoreChanged(PropertyChangeEvent event) {
        if (!this.occurrencesHighlighter.handlePreferenceStoreChanged(event)) {
            super.handlePreferenceStoreChanged(event);
        }
    }

    @NotNull
    public SQLDialect getSQLDialect() {
        DBPDataSource dataSource = this.getDataSource();
        if (dataSource != null) {
            return dataSource.getSQLDialect();
        }
        return BasicSQLDialect.INSTANCE;
    }

    @NotNull
    public SQLSyntaxManager getSyntaxManager() {
        return this.syntaxManager;
    }

    @Nullable
    public SQLRuleManager getRuleManager() {
        if (this.parserContext == null) {
            return null;
        }
        return this.parserContext.getRuleManager();
    }

    @NotNull
    public SQLRuleScanner getRuleScanner() {
        return this.ruleScanner;
    }

    @Nullable
    public IAnnotationModel getAnnotationModel() {
        ISourceViewer viewer = this.getSourceViewer();
        return viewer != null ? viewer.getAnnotationModel() : null;
    }

    @Nullable
    public ProjectionAnnotationModel getProjectionAnnotationModel() {
        ProjectionViewer viewer = (ProjectionViewer)this.getSourceViewer();
        return viewer != null ? viewer.getProjectionAnnotationModel() : null;
    }

    public SQLEditorSourceViewerConfiguration getViewerConfiguration() {
        return (SQLEditorSourceViewerConfiguration)super.getSourceViewerConfiguration();
    }

    public void createPartControl(Composite parent) {
        this.setRangeIndicator((Annotation)new DefaultRangeIndicator());
        this.editorControl = new SQLEditorControl(parent, this);
        super.createPartControl((Composite)this.editorControl);
        if (this.occurrencesHighlighter.isEnabled()) {
            this.occurrencesHighlighter.installOccurrencesFinder();
        }
        ProjectionViewer projectionViewer = (ProjectionViewer)this.getSourceViewer();
        this.projectionSupport = new ProjectionSupport(projectionViewer, this.getAnnotationAccess(), this.getSharedColors());
        this.projectionSupport.addSummarizableAnnotationType("org.eclipse.ui.workbench.texteditor.error");
        this.projectionSupport.addSummarizableAnnotationType("org.eclipse.ui.workbench.texteditor.warning");
        this.projectionSupport.install();
        projectionViewer.doOperation(19);
        final ISourceViewer sourceViewer = this.getSourceViewer();
        this.sqlSymbolInserter = new SQLSymbolInserter(this);
        this.loadActivePreferenceSettings();
        if (sourceViewer instanceof ITextViewerExtension && this.sqlSymbolInserter != null) {
            ((ITextViewerExtension)sourceViewer).prependVerifyKeyListener((VerifyKeyListener)this.sqlSymbolInserter);
        }
        if (sourceViewer != null) {
            final StyledText widget = sourceViewer.getTextWidget();
            widget.addMouseListener((MouseListener)new MouseAdapter(this){

                public void mouseUp(MouseEvent e) {
                    int n;
                    if (e.button != 3) {
                        return;
                    }
                    StyledText widget = sourceViewer.getTextWidget();
                    ISelectionProvider selectionProvider = sourceViewer.getSelectionProvider();
                    ITextSelection selection = (ITextSelection)selectionProvider.getSelection();
                    int widgetOffset = widget.getOffsetAtPoint(new Point(e.x, e.y));
                    if (widgetOffset < 0) {
                        int lineIndex = widget.getLineIndex(e.y);
                        widgetOffset = lineIndex + 1 >= widget.getLineCount() ? widget.getCharCount() : widget.getOffsetAtLine(lineIndex + 1) - widget.getLineDelimiter().length();
                    }
                    if (widgetOffset < 0) {
                        return;
                    }
                    if (sourceViewer instanceof ITextViewerExtension5) {
                        ITextViewerExtension5 vext = (ITextViewerExtension5)sourceViewer;
                        n = vext.widgetOffset2ModelOffset(widgetOffset);
                    } else {
                        n = widgetOffset;
                    }
                    int modelOffset = n;
                    boolean withinExistingSelection = false;
                    if (selection instanceof IBlockTextSelection) {
                        for (IRegion region : ((IBlockTextSelection)selection).getRegions()) {
                            if (!this.within(region, modelOffset)) continue;
                            withinExistingSelection = true;
                            break;
                        }
                    } else {
                        withinExistingSelection = this.within((IRegion)new Region(selection.getOffset(), selection.getLength()), modelOffset);
                    }
                    if (!withinExistingSelection) {
                        selectionProvider.setSelection((ISelection)new TextSelection(modelOffset, 0));
                    }
                }

                private boolean within(@NotNull IRegion region, int index) {
                    return region.getLength() > 0 && index >= region.getOffset() && index < region.getOffset() + region.getLength();
                }
            });
            widget.addControlListener((ControlListener)new ControlAdapter(this){
                private int lastHeight;

                public void controlResized(ControlEvent e) {
                    int currentHeight = widget.getSize().y;
                    int lastHeight = this.lastHeight;
                    this.lastHeight = currentHeight;
                    if (Math.abs(currentHeight - lastHeight) < 10) {
                        return;
                    }
                    try {
                        IDocument document = sourceViewer.getDocument();
                        int visibleLine = sourceViewer.getBottomIndex();
                        int currentLine = document.getLineOfOffset(sourceViewer.getSelectedRange().x);
                        if (currentLine > visibleLine) {
                            int revealToLine = Math.min(document.getNumberOfLines() - 1, currentLine + 1);
                            int revealToOffset = document.getLineOffset(revealToLine);
                            sourceViewer.revealRange(revealToOffset, 0);
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
            });
        }
    }

    protected void loadActivePreferenceSettings() {
        if (this.sqlSymbolInserter == null) {
            return;
        }
        DBPPreferenceStore preferenceStore = this.getActivePreferenceStore();
        boolean closeSingleQuotes = preferenceStore.getBoolean("SQLEditor.closeSingleQuotes");
        boolean closeDoubleQuotes = preferenceStore.getBoolean("SQLEditor.closeDoubleQuotes");
        boolean closeBrackets = preferenceStore.getBoolean("SQLEditor.closeBrackets");
        this.sqlSymbolInserter.setCloseSingleQuotesEnabled(closeSingleQuotes);
        this.sqlSymbolInserter.setCloseDoubleQuotesEnabled(closeDoubleQuotes);
        this.sqlSymbolInserter.setCloseBracketsEnabled(closeBrackets);
    }

    public SQLEditorControl getEditorControlWrapper() {
        return this.editorControl;
    }

    public void updatePartControl(IEditorInput input) {
        super.updatePartControl(input);
    }

    protected IOverviewRuler createOverviewRuler(ISharedTextColors sharedColors) {
        if (this.isOverviewRulerVisible()) {
            return super.createOverviewRuler(sharedColors);
        }
        return new OverviewRuler(this.getAnnotationAccess(), 0, sharedColors);
    }

    protected boolean isOverviewRulerVisible() {
        return false;
    }

    protected IVerticalRulerColumn createAnnotationRulerColumn(CompositeRuler ruler) {
        if (this.isAnnotationRulerVisible()) {
            return super.createAnnotationRulerColumn(ruler);
        }
        return new AnnotationRulerColumn(0, this.getAnnotationAccess());
    }

    protected boolean isAnnotationRulerVisible() {
        return true;
    }

    protected IVerticalRuler createVerticalRuler() {
        return this.hasVerticalRuler ? super.createVerticalRuler() : new VerticalRuler(0);
    }

    protected void setHasVerticalRuler(boolean hasVerticalRuler) {
        this.hasVerticalRuler = hasVerticalRuler;
    }

    protected ISharedTextColors getSharedColors() {
        return UIUtils.getSharedTextColors();
    }

    protected void doSetInput(IEditorInput input) throws CoreException {
        if (this.getDocumentProvider() instanceof NonFileDocumentProvider) {
            this.setDocumentProvider(null);
        }
        this.handleInputChange(input);
        IFile file = (IFile)GeneralUtils.adapt((Object)input, IFile.class);
        if (file != null && SQLEditorUtils.isNewScriptFile((IResource)file)) {
            UIUtils.asyncExec(() -> this.selectAndReveal(Integer.MAX_VALUE, 0));
        }
        super.doSetInput(input);
    }

    public void doSave(IProgressMonitor progressMonitor) {
        try {
            super.doSave(progressMonitor);
        }
        catch (Exception e) {
            log.error((Object)"Error saving SQL editor");
        }
        this.handleInputChange(this.getEditorInput());
    }

    protected void doTextEditorSave(DBRProgressMonitor monitor) {
        super.doSave(monitor.getNestedMonitor());
    }

    protected ISourceViewer createSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        this.fAnnotationAccess = this.getAnnotationAccess();
        this.fOverviewRuler = this.createOverviewRuler(this.getSharedColors());
        SQLEditorSourceViewer sourceViewer = this.createSourceViewer(parent, ruler, styles, this.fOverviewRuler);
        this.getSourceViewerDecorationSupport((ISourceViewer)sourceViewer);
        SQLMatchingCharacterPainter matchPainter = new SQLMatchingCharacterPainter((ISourceViewer)sourceViewer, this.characterPairMatcher);
        matchPainter.setColor(this.getSharedColors().getColor(PreferenceConverter.getColor((IPreferenceStore)this.getPreferenceStore(), (String)"writeOccurrenceIndicationColor")));
        matchPainter.setHighlightCharacterAtCaretLocation(true);
        sourceViewer.addPainter(matchPainter);
        return sourceViewer;
    }

    protected SourceViewerDecorationSupport getSourceViewerDecorationSupport(ISourceViewer viewer) {
        if (this.fSourceViewerDecorationSupport == null) {
            this.fSourceViewerDecorationSupport = new SQLSourceViewerDecorationSupport(viewer, this.getOverviewRuler(), this.getAnnotationAccess(), this.getSharedColors());
            this.configureSourceViewerDecorationSupport(this.fSourceViewerDecorationSupport);
        }
        return this.fSourceViewerDecorationSupport;
    }

    protected void configureSourceViewerDecorationSupport(SourceViewerDecorationSupport support) {
        char[] matchChars = SQLConstants.BRACKETS;
        try {
            this.characterPairMatcher = new SQLCharacterPairMatcher(this, matchChars, "___sql_partitioning", true);
        }
        catch (Throwable e) {
            this.characterPairMatcher = new SQLCharacterPairMatcher(this, matchChars, "___sql_partitioning");
        }
        super.configureSourceViewerDecorationSupport(support);
        if (UIStyles.isDarkHighContrastTheme()) {
            support.setCursorLinePainterPreferenceKeys("currentLine", "org.jkiss.dbeaver.sql.resultset.color.lines.selected");
        }
    }

    public ICharacterPairMatcher getCharacterPairMatcher() {
        return this.characterPairMatcher;
    }

    @NotNull
    private SQLEditorSourceViewer createSourceViewer(Composite parent, IVerticalRuler ruler, int styles, IOverviewRuler overviewRuler) {
        return new SQLEditorSourceViewer(parent, ruler, overviewRuler, true, styles, this::getActivePreferenceStore, this);
    }

    protected IAnnotationAccess createAnnotationAccess() {
        return new SQLMarkerAnnotationAccess();
    }

    public <T> T getAdapter(Class<T> required) {
        Object adapter;
        if (this.projectionSupport != null && (adapter = this.projectionSupport.getAdapter(this.getSourceViewer(), required)) != null) {
            return (T)adapter;
        }
        if (ITemplatesPage.class.equals(required)) {
            return (T)((Object)this.getTemplatesPage());
        }
        if (IContentOutlinePage.class.equals(required)) {
            return (T)this.getOverviewOutlinePage();
        }
        return (T)super.getAdapter(required);
    }

    @NotNull
    public IContentOutlinePage getOverviewOutlinePage() {
        if (this.getSyntaxContext() == null) {
            this.reloadSyntaxRules();
        }
        if (this.outlinePage == null || this.outlinePage.getControl() == null || this.outlinePage.getControl().isDisposed()) {
            this.outlinePage = new SQLEditorOutlinePage(this);
        }
        return this.outlinePage;
    }

    public SQLTemplatesPage getTemplatesPage() {
        if (this.templatesPage == null) {
            this.templatesPage = new SQLTemplatesPage(this);
        }
        return this.templatesPage;
    }

    public void dispose() {
        SQLEditorSourceViewerConfiguration viewerConfiguration;
        DBWorkbench.getPlatform().getPreferenceStore().removePropertyChangeListener((DBPPreferenceListener)this);
        if (this.semanticMarkersManager != null) {
            this.semanticMarkersManager.dispose();
        }
        if (this.backgroundParsingJob != null) {
            this.backgroundParsingJob.dispose();
        }
        this.occurrencesHighlighter.dispose();
        this.clearProblems(null);
        if (this.themeListener != null) {
            PlatformUI.getWorkbench().getThemeManager().removePropertyChangeListener(this.themeListener);
            this.themeListener = null;
        }
        if ((viewerConfiguration = this.getViewerConfiguration()) != null) {
            viewerConfiguration.saveFoldingState();
        }
        super.dispose();
    }

    protected void createActions() {
        super.createActions();
        ResourceBundle bundle = ResourceBundle.getBundle("org.jkiss.dbeaver.ui.editors.sql.internal.SQLEditorMessages");
        TextOperationAction action = new TextOperationAction(bundle, SQLEditorContributor.getActionResourcePrefix("ContentAssistProposal"), (ITextEditor)this, 13);
        action.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.proposals");
        this.setAction("ContentAssistProposal", (IAction)action);
        action = new TextOperationAction(bundle, SQLEditorContributor.getActionResourcePrefix("ContentAssistTip"), (ITextEditor)this, 14);
        action.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.contextInformation");
        this.setAction("ContentAssistTip", (IAction)action);
        action = new TextOperationAction(bundle, SQLEditorContributor.getActionResourcePrefix("ContentAssistInfo"), (ITextEditor)this, 16);
        action.setActionDefinitionId("org.eclipse.ui.edit.text.showInformation");
        this.setAction("ContentAssistInfo", (IAction)action);
        action = new TextOperationAction(bundle, SQLEditorContributor.getActionResourcePrefix("ContentFormatProposal"), (ITextEditor)this, 15);
        action.setActionDefinitionId("org.jkiss.dbeaver.ui.editors.text.content.format");
        this.setAction("ContentFormatProposal", (IAction)action);
        this.setAction("Preferences.ContextAction", (IAction)new ShowPreferencesAction());
        SQLEditorCustomActions.registerCustomActions(this);
    }

    protected boolean isEditorInputIncludedInContextMenu() {
        return false;
    }

    public void editorContextMenuAboutToShow(IMenuManager menu) {
        menu.add((IContributionItem)new GroupMarker("sql.additions"));
        super.editorContextMenuAboutToShow(menu);
        this.addAction(menu, "sql.extras", "ContentAssistProposal");
        this.addAction(menu, "sql.extras", "ContentAssistTip");
        this.addAction(menu, "sql.extras", "ContentAssistInfo");
        menu.insertBefore("group.copy", (IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.getSite(), (String)"org.jkiss.dbeaver.ui.editors.sql.navigate.object"));
        TextViewer textViewer = this.getTextViewer();
        if (!this.isReadOnly() && textViewer != null && textViewer.isEditable()) {
            MenuManager formatMenu = new MenuManager(SQLEditorMessages.sql_editor_menu_format, "format");
            IAction formatAction = this.getAction("ContentFormatProposal");
            if (formatAction != null) {
                formatMenu.add(formatAction);
            }
            formatMenu.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.getSite(), (String)"org.jkiss.dbeaver.ui.editors.sql.morph.delimited.list"));
            formatMenu.add(this.getAction("UpperCase"));
            formatMenu.add(this.getAction("LowerCase"));
            formatMenu.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.getSite(), (String)"org.jkiss.dbeaver.ui.editors.sql.trim.spaces"));
            formatMenu.add((IContributionItem)new Separator());
            formatMenu.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.getSite(), (String)"org.jkiss.dbeaver.ui.editors.sql.word.wrap"));
            formatMenu.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.getSite(), (String)"org.jkiss.dbeaver.ui.editors.sql.comment.single"));
            formatMenu.add((IContributionItem)ActionUtils.makeCommandContribution((IServiceLocator)this.getSite(), (String)"org.jkiss.dbeaver.ui.editors.sql.comment.multi"));
            menu.insertAfter("sql.additions", (IContributionItem)formatMenu);
        }
    }

    public void reloadSyntaxRules() {
        if (SQLEditorUtils.isSQLSyntaxParserApplied(this.getEditorInput()) && this.isAdvancedHighlightingEnabled()) {
            if (this.backgroundParsingJob == null) {
                this.backgroundParsingJob = new SQLBackgroundParsingJob(this);
            }
            if (this.getActivePreferenceStore().getBoolean("SQLEditor.problemMarkers.enabled") && this.semanticMarkersManager == null) {
                this.semanticMarkersManager = new SQLEditorSemanticMarkersManager(this);
            }
        } else if (this.backgroundParsingJob != null) {
            this.backgroundParsingJob.dispose();
            this.backgroundParsingJob = null;
        }
        if (!(this.semanticMarkersManager == null || this.backgroundParsingJob != null && this.getActivePreferenceStore().getBoolean("SQLEditor.problemMarkers.enabled"))) {
            this.semanticMarkersManager.dispose();
            this.semanticMarkersManager = null;
        }
        SQLDialect dialect = this.getSQLDialect();
        IDocument document = this.getDocument();
        this.syntaxManager.init(dialect, this.getActivePreferenceStore());
        SQLRuleManager ruleManager = new SQLRuleManager(this.syntaxManager);
        ruleManager.loadRules(this.getDataSourceContainerForSyntaxRuleReloading(), !SQLEditorUtils.isSQLSyntaxParserApplied(this.getEditorInput()));
        this.ruleScanner.refreshRules(this.getDataSourceContainerForSyntaxRuleReloading(), ruleManager, this);
        this.parserContext = this.getDataSource() != null ? new SQLParserContext(this.getDataSource(), this.syntaxManager, ruleManager, (IDocument)(document != null ? document : new Document())) : new SQLParserContext(this.getDataSourceContainerForSyntaxRuleReloading(), this.syntaxManager, ruleManager, (IDocument)(document != null ? document : new Document()));
        if (document instanceof IDocumentExtension3) {
            FastPartitioner partitioner = new FastPartitioner((IPartitionTokenScanner)new SQLPartitionScanner(this.getDataSource(), dialect, ruleManager), SQLParserPartitions.SQL_CONTENT_TYPES);
            partitioner.connect(document);
            try {
                ((IDocumentExtension3)document).setDocumentPartitioner("___sql_partitioning", (IDocumentPartitioner)partitioner);
            }
            catch (Throwable e) {
                log.warn((Object)"Error setting SQL partitioner", e);
            }
            ProjectionViewer projectionViewer = (ProjectionViewer)this.getSourceViewer();
            if (projectionViewer != null && projectionViewer.getAnnotationModel() != null && document.getLength() > 0) {
                try {
                    projectionViewer.reinitializeProjection();
                }
                catch (Throwable ex) {
                    log.warn((Object)"Can't initialize SQL syntax projection", ex);
                }
            }
        }
        IVerticalRuler verticalRuler = this.getVerticalRuler();
        if (this.getSourceViewerConfiguration() instanceof SQLEditorSourceViewerConfiguration) {
            ((SQLEditorSourceViewerConfiguration)this.getSourceViewerConfiguration()).onDataSourceChange();
        }
        if (verticalRuler != null) {
            verticalRuler.update();
        }
        if (this.backgroundParsingJob != null) {
            this.backgroundParsingJob.setup();
        }
        if (this.semanticMarkersManager != null) {
            this.semanticMarkersManager.refresh();
        }
    }

    boolean hasActiveQuery() {
        IDocument document = this.getDocument();
        if (document == null) {
            return false;
        }
        ISelectionProvider selectionProvider = this.getSelectionProvider();
        if (selectionProvider == null) {
            return false;
        }
        ITextSelection selection = (ITextSelection)selectionProvider.getSelection();
        String selText = selection.getText();
        if (CommonUtils.isEmpty((String)selText) && selection.getOffset() >= 0 && selection.getOffset() < document.getLength()) {
            try {
                IRegion lineRegion = document.getLineInformationOfOffset(selection.getOffset());
                selText = document.get(lineRegion.getOffset(), lineRegion.getLength());
            }
            catch (BadLocationException e) {
                log.warn((Object)e);
                return false;
            }
        }
        return !CommonUtils.isEmptyTrimmed((String)selText);
    }

    @Nullable
    public SQLScriptElement extractActiveQuery() {
        if (this.parserContext == null) {
            return null;
        }
        ITextSelection selection = (ITextSelection)this.getSelectionProvider().getSelection();
        if (selection instanceof IBlockTextSelection) {
            return SQLScriptParser.extractActiveQuery((SQLParserContext)this.parserContext, (IRegion[])((IBlockTextSelection)selection).getRegions());
        }
        return SQLScriptParser.extractActiveQuery((SQLParserContext)this.parserContext, (int)selection.getOffset(), (int)selection.getLength());
    }

    public SQLScriptElement extractQueryAtPos(int currentPos) {
        return this.parserContext == null ? null : SQLScriptParser.extractQueryAtPos((SQLParserContext)this.parserContext, (int)currentPos, (boolean)false);
    }

    public SQLScriptElement extractNextQuery(boolean next) {
        if (this.parserContext == null) {
            return null;
        }
        ITextSelection selection = (ITextSelection)this.getSelectionProvider().getSelection();
        int offset = selection.getOffset();
        return SQLScriptParser.extractNextQuery((SQLParserContext)this.parserContext, (int)offset, (boolean)next);
    }

    public List<SQLScriptElement> extractScriptQueries(int startOffset, int length, boolean scriptMode, boolean keepDelimiters, boolean parseParameters) {
        if (this.parserContext == null) {
            return null;
        }
        return SQLScriptParser.extractScriptQueries((SQLParserContext)this.parserContext, (int)startOffset, (int)length, (boolean)scriptMode, (boolean)keepDelimiters, (boolean)parseParameters);
    }

    public SQLCompletionContext getCompletionContext() {
        return this.completionContext;
    }

    public void setCompletionContext(SQLCompletionContext completionContext) {
        this.completionContext = completionContext;
    }

    List<SQLQueryParameter> parseQueryParameters(SQLQuery query) {
        if (this.parserContext == null) {
            return null;
        }
        SQLParserContext context = this.getDataSource() != null ? new SQLParserContext(this.getDataSource(), this.parserContext.getSyntaxManager(), this.parserContext.getRuleManager(), (IDocument)new Document(query.getText())) : new SQLParserContext(this.getDataSourceContainerForSyntaxRuleReloading(), this.parserContext.getSyntaxManager(), this.parserContext.getRuleManager(), (IDocument)new Document(query.getText()));
        return SQLScriptParser.parseParametersAndVariables((SQLParserContext)context, (int)0, (int)query.getLength());
    }

    public boolean isDisposed() {
        return this.getSourceViewer() == null || this.getSourceViewer().getTextWidget() == null || this.getSourceViewer().getTextWidget().isDisposed();
    }

    @Nullable
    public ICommentsSupport getCommentsSupport() {
        final SQLDialect dialect = this.getSQLDialect();
        return new ICommentsSupport(){

            @Nullable
            public Pair<String, String> getMultiLineComments() {
                return dialect.getMultiLineComments();
            }

            public String[] getSingleLineComments() {
                return dialect.getSingleLineComments();
            }
        };
    }

    protected String[] collectContextMenuPreferencePages() {
        Object[] ids = super.collectContextMenuPreferencePages();
        return (String[])ArrayUtils.concatArrays((Object[])ids, (Object[])new String[]{"org.jkiss.dbeaver.preferences.main.sqleditor", "org.jkiss.dbeaver.preferences.main.sqlexecute", "org.jkiss.dbeaver.preferences.main.sql.codeeditor", "org.jkiss.dbeaver.preferences.main.sql.completion", "org.jkiss.dbeaver.preferences.main.sql.format", "org.jkiss.dbeaver.preferences.main.sql.resources", "org.jkiss.dbeaver.preferences.main.sql.templates"});
    }

    public boolean visualizeError(@NotNull DBRProgressMonitor monitor, @NotNull Throwable error) {
        IDocument document = this.getDocument();
        String text = document == null ? "" : document.get();
        SQLQuery query = new SQLQuery(this.getDataSource(), text, 0, text.length());
        return this.visualizeQueryErrors(monitor, query, error, null);
    }

    boolean visualizeQueryErrors(@NotNull DBRProgressMonitor monitor, @NotNull SQLQuery query, @NotNull Throwable error, @Nullable SQLQuery originalQuery) {
        try {
            DBPErrorAssistant.ErrorPosition[] positions;
            DBCExecutionContext context = this.getExecutionContext();
            if (context == null) {
                return false;
            }
            boolean scrolled = false;
            DBPErrorAssistant errorAssistant = (DBPErrorAssistant)DBUtils.getAdapter(DBPErrorAssistant.class, (Object)context.getDataSource());
            if (errorAssistant != null && (positions = errorAssistant.getErrorPosition(monitor, context, query.getText(), error)) != null && positions.length > 0) {
                int queryStartOffset = query.getOffset();
                int queryLength = query.getLength();
                for (int index = 0; index < positions.length; ++index) {
                    DBPErrorAssistant.ErrorPosition pos = positions[index];
                    int errorOffset = 0;
                    if (pos.line < 0) {
                        if (pos.position >= 0) {
                            int errorLine;
                            IDocument document;
                            int length;
                            errorOffset = queryStartOffset + pos.position;
                            SQLWordPartDetector detector = new SQLWordPartDetector(this.getDocument(), this.getSyntaxManager(), errorOffset);
                            int n = length = detector.getLength() > 0 ? detector.getLength() : queryLength - pos.position;
                            if (this.addProblem(GeneralUtils.getFirstMessage((Throwable)error), new Position(errorOffset, length))) {
                                scrolled = true;
                            } else if (index == 0) {
                                this.getSelectionProvider().setSelection((ISelection)new TextSelection(errorOffset, 0));
                                scrolled = true;
                            }
                            if (originalQuery != null && (document = this.getDocument()) != null && (errorLine = document.getLineOfOffset(errorOffset)) >= 0) {
                                pos.line = errorLine + 1;
                            }
                        }
                    } else {
                        IDocument document = this.getDocument();
                        if (document != null) {
                            int errorLength;
                            int startLine = document.getLineOfOffset(queryStartOffset);
                            errorOffset = document.getLineOffset(startLine + pos.line);
                            if (pos.position >= 0) {
                                errorOffset += pos.position;
                                errorLength = 1;
                            } else {
                                errorLength = document.getLineLength(startLine + pos.line);
                            }
                            if (errorOffset < queryStartOffset) {
                                errorOffset = queryStartOffset;
                            }
                            if (errorLength > queryLength) {
                                errorLength = queryLength;
                            }
                            if (errorOffset >= queryStartOffset + queryLength) {
                                errorOffset = queryStartOffset + queryLength - 1;
                            }
                            if (this.addProblem(GeneralUtils.getFirstMessage((Throwable)error), new Position(errorOffset, errorLength))) {
                                scrolled = true;
                            } else if (index == 0) {
                                this.getSelectionProvider().setSelection((ISelection)new TextSelection(errorOffset, errorLength));
                                scrolled = true;
                            }
                        }
                    }
                    if (originalQuery == null) continue;
                    originalQuery.addExtraErrorMessage("\n" + SQLEditorMessages.sql_editor_error_position + ":" + (String)(pos.line > 0 ? " line: " + pos.line : "") + (String)(pos.position > 0 ? " pos: " + pos.position : ""));
                    if (index != 0) continue;
                    this.lastQueryErrorPosition = errorOffset;
                }
            }
            return scrolled;
        }
        catch (Exception e) {
            log.warn((Object)"Error positioning on query error", (Throwable)e);
            return false;
        }
    }

    protected boolean addProblem(@Nullable String message, @NotNull Position position) {
        if (!this.getActivePreferenceStore().getBoolean("SQLEditor.problemMarkers.enabled")) {
            return false;
        }
        IResource resource = (IResource)GeneralUtils.adapt((Object)this.getEditorInput(), IResource.class);
        IAnnotationModel annotationModel = this.getAnnotationModel();
        if (resource == null || annotationModel == null) {
            return false;
        }
        try {
            IMarker marker = resource.createMarker("org.jkiss.dbeaver.ui.editors.sql.databaseScriptProblemMarker");
            marker.setAttribute("severity", 2);
            marker.setAttribute("message", (Object)message);
            marker.setAttribute("transient", true);
            annotationModel.addAnnotation((Annotation)new SQLProblemAnnotation(marker), position);
        }
        catch (CoreException e) {
            log.error((Object)"Error creating problem marker", (Throwable)e);
        }
        return true;
    }

    protected void clearProblems(@Nullable SQLQuery query) {
        if (query == null) {
            IResource resource = (IResource)GeneralUtils.adapt((Object)this.getEditorInput(), IResource.class);
            if (resource != null && resource.exists()) {
                try {
                    resource.deleteMarkers("org.jkiss.dbeaver.ui.editors.sql.databaseScriptProblemMarker", false, 1);
                }
                catch (CoreException e) {
                    log.error((Object)"Error deleting problem markers", (Throwable)e);
                }
            }
        } else {
            IAnnotationModel annotationModel = this.getAnnotationModel();
            if (annotationModel != null) {
                Iterator it = annotationModel.getAnnotationIterator();
                while (it.hasNext()) {
                    Position position;
                    Annotation annotation = (Annotation)it.next();
                    if (!(annotation instanceof SQLProblemAnnotation) || !(position = annotationModel.getPosition(annotation)).overlapsWith(query.getOffset(), query.getLength()) && (position.isDeleted() || query.getOffset() + query.getLength() != position.getOffset() + position.getLength())) continue;
                    try {
                        ((SQLProblemAnnotation)annotation).getMarker().delete();
                    }
                    catch (CoreException e) {
                        log.error((Object)"Error deleting problem marker", (Throwable)e);
                    }
                    annotationModel.removeAnnotation(annotation);
                }
            }
        }
    }

    public boolean isFoldingEnabled() {
        return SQLEditorUtils.isSQLSyntaxParserApplied(this.getEditorInput()) && DBWorkbench.getPlatform().getPreferenceStore().getBoolean("SQLEditor.Folding.enabled");
    }

    protected void updateStatusField(String category) {
        if (STATS_CATEGORY_SELECTION_STATE.equals(category)) {
            IStatusField field = this.getStatusField(category);
            if (field != null) {
                StringBuilder txt = new StringBuilder("Sel: ");
                ISelection selection = this.getSelectionProvider().getSelection();
                if (selection instanceof ITextSelection) {
                    ITextSelection textSelection = (ITextSelection)selection;
                    txt.append(textSelection.getLength()).append(" | ");
                    if (textSelection.getLength() <= 0) {
                        txt.append(0);
                    } else {
                        txt.append(textSelection.getEndLine() - textSelection.getStartLine() + 1);
                    }
                }
                field.setText(txt.toString());
            }
        } else {
            super.updateStatusField(category);
        }
    }

    public void preferenceChange(DBPPreferenceListener.PreferenceChangeEvent event) {
        switch (event.getProperty()) {
            case "SQLEditor.closeSingleQuotes": {
                this.sqlSymbolInserter.setCloseSingleQuotesEnabled(CommonUtils.toBoolean((Object)event.getNewValue()));
                return;
            }
            case "SQLEditor.closeDoubleQuotes": {
                this.sqlSymbolInserter.setCloseDoubleQuotesEnabled(CommonUtils.toBoolean((Object)event.getNewValue()));
                return;
            }
            case "SQLEditor.closeBrackets": {
                this.sqlSymbolInserter.setCloseBracketsEnabled(CommonUtils.toBoolean((Object)event.getNewValue()));
                return;
            }
            case "SQLEditor.Folding.enabled": {
                ProjectionAnnotationModel annotationModel = this.getProjectionAnnotationModel();
                if (annotationModel != null) {
                    annotationModel.removeAllAnnotations();
                    this.reloadSourceViewerConfiguration();
                }
                return;
            }
            case "SQLEditor.problemMarkers.enabled": {
                this.clearProblems(null);
                return;
            }
            case "SQLEditor.markOccurrences": 
            case "SQLEditor.markOccurrences.forSelection": {
                this.occurrencesHighlighter.updateInput(this.getEditorInput());
            }
            case "SQLEditor.format.boldKeywords": 
            case "SQLEditor.format.activeQuery": 
            case "SQLEditor.format.extractFromSource": 
            case "database.meta.disableAdditionalRead": 
            case "SQLEditor.Semantics.metadata.read.enable": 
            case "sql.format.keywordCase": 
            case "sql.format.lf.before.comma": 
            case "sql.format.break.before.close.bracket": 
            case "sql.format.insert.delimiters.in.empty_lines": 
            case "tabWidth": 
            case "spacesForTabs": {
                this.reloadSyntaxRules();
                return;
            }
            case "SQLEditor.Highlighting.advanced.enable": {
                this.reloadSourceViewerConfiguration();
                this.reloadSyntaxRules();
                if (this.outlinePage != null) {
                    this.outlinePage.refresh();
                }
                return;
            }
        }
    }

    public void refreshAdvancedServices() {
        if (this.outlinePage != null) {
            this.outlinePage.refresh();
        }
        if (this.semanticMarkersManager != null) {
            this.semanticMarkersManager.refresh();
        }
    }

    private void reloadSourceViewerConfiguration() {
        SourceViewerConfiguration configuration = this.getSourceViewerConfiguration();
        SQLEditorSourceViewer sourceViewer = (SQLEditorSourceViewer)this.getSourceViewer();
        sourceViewer.unconfigure();
        sourceViewer.configure(configuration);
    }

    void setLastQueryErrorPosition(int lastQueryErrorPosition) {
        this.lastQueryErrorPosition = lastQueryErrorPosition;
    }

    int getLastQueryErrorPosition() {
        return this.lastQueryErrorPosition;
    }

    protected boolean isNavigationTarget(Annotation annotation) {
        if (annotation instanceof SpellingAnnotation) {
            Iterator i = this.getAnnotationModel().getAnnotationIterator();
            while (i.hasNext()) {
                Annotation anno = (Annotation)i.next();
                if (!(anno instanceof SQLProblemAnnotation)) continue;
                return false;
            }
            return true;
        }
        return super.isNavigationTarget(annotation);
    }

    @Nullable
    protected DBPDataSourceContainer getDataSourceContainerForSyntaxRuleReloading() {
        DBPDataSource dataSource = this.getDataSource();
        return dataSource == null ? null : dataSource.getContainer();
    }

    static {
        IPreferenceStore editorStore = EditorsUI.getPreferenceStore();
        editorStore.setDefault("SQLEditor.matchingBrackets", true);
        editorStore.setDefault("SQLEditor.matchingBracketsHighlight", true);
        editorStore.setDefault("removeSpacesAsTabs", true);
    }

    private static class NonFileDocumentProvider
    extends SQLObjectDocumentProvider {
        private final StringEditorInput editorInput;

        public NonFileDocumentProvider(SQLEditorBase editor, StringEditorInput editorInput) {
            super(editor);
            this.editorInput = editorInput;
        }

        @Override
        protected String loadSourceText(DBRProgressMonitor monitor) throws DBException {
            return this.editorInput.getBuffer().toString();
        }

        @Override
        protected void saveSourceText(DBRProgressMonitor monitor, String text) throws DBException {
            this.editorInput.setText(text);
        }

        @Override
        public boolean isReadOnly(Object element) {
            if (element instanceof AbstractStorageEditorInput) {
                return ((AbstractStorageEditorInput)element).isReadOnly();
            }
            return this.editorInput.isReadOnly();
        }
    }

    protected class ShowPreferencesAction
    extends Action {
        ShowPreferencesAction() {
            super(SQLEditorMessages.editor_sql_preference, DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.CONFIGURATION));
        }

        public void run() {
            Shell shell = SQLEditorBase.this.getSourceViewer().getTextWidget().getShell();
            String[] preferencePages = SQLEditorBase.this.collectContextMenuPreferencePages();
            if (!(preferencePages.length <= 0 || shell != null && shell.isDisposed())) {
                PropertyDialog.createDialogOn((Shell)shell, null, (Object)new StructuredSelection((Object)SQLEditorBase.this.getEditorInput())).open();
            }
        }
    }
}

