/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tasks.nativetool;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.text.NumberFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import org.eclipse.osgi.util.NLS;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.access.DBAAuthCredentials;
import org.jkiss.dbeaver.model.access.DBAAuthModel;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.connection.DBPNativeClientLocation;
import org.jkiss.dbeaver.model.connection.DBPNativeClientLocationManager;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.impl.auth.AuthModelDatabaseNative;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNModel;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableContext;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.task.DBTTask;
import org.jkiss.dbeaver.model.task.DBTTaskExecutionListener;
import org.jkiss.dbeaver.model.task.DBTTaskHandler;
import org.jkiss.dbeaver.model.task.DBTTaskRunStatus;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.ProgressStreamReader;
import org.jkiss.dbeaver.runtime.ui.UIServiceSystemAgent;
import org.jkiss.dbeaver.tasks.nativetool.AbstractNativeToolSettings;
import org.jkiss.dbeaver.tasks.nativetool.NativeToolUtils;
import org.jkiss.dbeaver.tasks.nativetool.messages.NativeToolMessages;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.IOUtils;

public abstract class AbstractNativeToolHandler<SETTINGS extends AbstractNativeToolSettings<BASE_OBJECT>, BASE_OBJECT extends DBSObject, PROCESS_ARG>
implements DBTTaskHandler {
    private String taskErrorMessage;

    @NotNull
    public DBTTaskRunStatus executeTask(@NotNull DBRRunnableContext runnableContext, @NotNull DBTTask task, @NotNull Locale locale, @NotNull Log log, @NotNull PrintStream logStream, @NotNull DBTTaskExecutionListener listener) throws DBException {
        SETTINGS settings = this.createTaskSettings(runnableContext, task);
        ((AbstractNativeToolSettings)settings).setLogWriter(logStream);
        if (!this.validateTaskParameters(task, settings, log)) {
            listener.taskFinished(task, null, (Throwable)new InterruptedException("Task parameters validation failed"), settings);
            log.error((Object)"Task parameters validation failed");
            return new DBTTaskRunStatus();
        }
        try {
            runnableContext.run(true, true, monitor -> {
                monitor.beginTask(task.getType().getName(), 1);
                monitor.subTask(task.getType().getName());
                Log.setLogWriter((OutputStream)logStream);
                listener.taskStarted(task);
                Exception error = null;
                try {
                    boolean executionResult = this.doExecute(monitor, task, settings, log);
                    if (!executionResult) {
                        error = new DBCException("Task execution failed, reason: " + this.taskErrorMessage);
                    }
                }
                catch (Exception e) {
                    error = e;
                }
                finally {
                    listener.taskFinished(task, null, (Throwable)error, (Object)settings);
                    Log.setLogWriter(null);
                    monitor.worked(1);
                    monitor.done();
                }
            });
        }
        catch (InvocationTargetException e) {
            throw new DBException("Error executing native tool", e.getTargetException());
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return new DBTTaskRunStatus();
    }

    protected boolean isNativeClientHomeRequired() {
        return true;
    }

    protected boolean isMergeProcessStreams() {
        return false;
    }

    protected boolean needsModelRefresh() {
        return true;
    }

    private void validateClientHome(DBRProgressMonitor monitor, SETTINGS settings) throws DBCException {
        DBPDataSourceContainer dataSourceContainer = ((AbstractNativeToolSettings)settings).getDataSourceContainer();
        if (this.isNativeClientHomeRequired()) {
            String clientHomeId = dataSourceContainer.getConnectionConfiguration().getClientHomeId();
            DBPDriver driver = dataSourceContainer.getDriver();
            List clientLocations = driver.getNativeClientLocations();
            DBPNativeClientLocationManager locationManager = driver.getNativeClientManager();
            if (locationManager != null) {
                clientLocations.addAll(locationManager.findLocalClientLocations());
            }
            if (clientHomeId == null) {
                if (!clientLocations.isEmpty()) {
                    ((AbstractNativeToolSettings)settings).setClientHome((DBPNativeClientLocation)clientLocations.get(0));
                } else {
                    ((AbstractNativeToolSettings)settings).setClientHome(null);
                }
                if (((AbstractNativeToolSettings)settings).getClientHome() == null) {
                    throw new DBCException("Client binaries location is not specified");
                }
            } else {
                DBPNativeClientLocation clientHome = (DBPNativeClientLocation)DBUtils.findObject((Collection)clientLocations, (String)clientHomeId);
                if (clientHome == null) {
                    clientHome = ((AbstractNativeToolSettings)settings).findNativeClientHome(clientHomeId);
                }
                ((AbstractNativeToolSettings)settings).setClientHome(clientHome);
            }
            if (((AbstractNativeToolSettings)settings).getClientHome() == null) {
                throw new DBCException("Local client home '" + clientHomeId + "' not found");
            }
        }
        DBPNativeClientLocation clientHome = ((AbstractNativeToolSettings)settings).getClientHome();
        if (!this.isNativeClientHomeRequired() || clientHome == null) {
            return;
        }
        try {
            clientHome.validateFilesPresence(monitor);
        }
        catch (DBException e) {
            throw new DBCException("Error downloading client file(s)", (Throwable)e);
        }
        catch (InterruptedException e) {
            throw new DBCException("Client file download interrupted", (Throwable)e);
        }
    }

    public abstract Collection<PROCESS_ARG> getRunInfo(SETTINGS var1);

    public Collection<BASE_OBJECT> getUpdatedObjects(PROCESS_ARG settings) {
        return Collections.emptyList();
    }

    protected abstract SETTINGS createTaskSettings(DBRRunnableContext var1, DBTTask var2) throws DBException;

    protected boolean validateTaskParameters(DBTTask task, SETTINGS settings, Log log) {
        return true;
    }

    protected abstract List<String> getCommandLine(SETTINGS var1, PROCESS_ARG var2) throws IOException;

    public abstract void fillProcessParameters(SETTINGS var1, PROCESS_ARG var2, List<String> var3) throws IOException;

    protected void setupProcessParameters(DBRProgressMonitor monitor, SETTINGS settings, PROCESS_ARG arg, ProcessBuilder process) {
    }

    protected boolean isLogInputStream() {
        return true;
    }

    protected void startProcessHandler(DBRProgressMonitor monitor, DBTTask task, SETTINGS settings, PROCESS_ARG arg, ProcessBuilder processBuilder, Process process, Log log) throws IOException, DBException {
        LogReaderJob logReaderJob = new LogReaderJob(this, task, settings, processBuilder, process, this.isLogInputStream());
        logReaderJob.start();
    }

    public boolean executeProcess(DBRProgressMonitor monitor, DBTTask task, SETTINGS settings, PROCESS_ARG arg, Log log) throws IOException, InterruptedException {
        monitor.beginTask(task.getType().getName(), 1);
        try {
            monitor.subTask("Start native tool " + this.getClass().getSimpleName());
            List<String> commandLine = this.getCommandLine(settings, arg);
            File execPath = new File(commandLine.get(0));
            ProcessBuilder processBuilder = new ProcessBuilder(commandLine);
            processBuilder.directory(execPath.getParentFile());
            if (this.isMergeProcessStreams()) {
                processBuilder.redirectErrorStream(true);
            }
            this.setupProcessParameters(monitor, settings, arg, processBuilder);
            Process process = processBuilder.start();
            this.startProcessHandler(monitor, task, settings, arg, processBuilder, process, log);
            monitor.subTask("Executing");
            Thread.sleep(100L);
            while (true) {
                Thread.sleep(100L);
                if (monitor.isCanceled()) {
                    process.destroy();
                }
                try {
                    int exitCode = process.exitValue();
                    this.validateErrorCode(exitCode);
                }
                catch (IllegalThreadStateException e) {
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            log.error((Object)("IO error: " + e.getMessage()));
            throw e;
        }
        catch (DBException e) {
            log.error((Object)("Process error: " + e.getMessage()));
            throw new IOException(e);
        }
        finally {
            monitor.done();
        }
        return CommonUtils.isEmpty((String)this.taskErrorMessage);
    }

    public void validateErrorCode(int exitCode) throws IOException {
        if (exitCode != 0) {
            throw new IOException("Process failed (exit code = " + exitCode + "). See error log.");
        }
    }

    protected void notifyToolFinish(String toolName, long workTime) {
        UIServiceSystemAgent serviceSystemAgent = (UIServiceSystemAgent)DBWorkbench.getService(UIServiceSystemAgent.class);
        if (serviceSystemAgent != null && workTime > serviceSystemAgent.getLongOperationTimeout() * 1000L) {
            serviceSystemAgent.notifyAgent(toolName, 1);
        }
    }

    protected boolean doExecute(DBRProgressMonitor monitor, DBTTask task, SETTINGS settings, Log log) throws DBException, InterruptedException {
        this.validateClientHome(monitor, settings);
        long startTime = System.currentTimeMillis();
        boolean isSuccess = true;
        try {
            for (PROCESS_ARG arg : this.getRunInfo(settings)) {
                if (monitor.isCanceled()) break;
                if (this.executeProcess(monitor, task, settings, arg, log)) continue;
                isSuccess = false;
            }
            boolean refreshObjects = isSuccess && !monitor.isCanceled();
            DBNModel navigatorModel = task.getProject().getNavigatorModel();
            if (navigatorModel != null && refreshObjects && this.needsModelRefresh()) {
                for (DBSObject object : ((AbstractNativeToolSettings)settings).getDatabaseObjects()) {
                    DBNDatabaseNode node = navigatorModel.findNode(object);
                    if (node == null) continue;
                    node.refreshNode(monitor, (Object)this);
                }
            }
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new DBException("Error executing process", (Throwable)e);
        }
        if (monitor.isCanceled()) {
            throw new InterruptedException();
        }
        long workTime = System.currentTimeMillis() - startTime;
        this.notifyToolFinish(task.getType().getName() + " - " + task.getName() + " has finished", workTime);
        return isSuccess;
    }

    protected String getInputCharset() {
        return GeneralUtils.UTF8_ENCODING;
    }

    protected String getOutputCharset() {
        return GeneralUtils.UTF8_ENCODING;
    }

    protected String getDataSourcePassword(DBRProgressMonitor monitor, SETTINGS settings) {
        String userPassword = null;
        DBPDataSourceContainer dataSourceContainer = ((AbstractNativeToolSettings)settings).getDataSourceContainer();
        DBPConnectionConfiguration cfg = new DBPConnectionConfiguration(dataSourceContainer.getActualConnectionConfiguration());
        DBAAuthModel authModel = cfg.getAuthModel();
        if (authModel != AuthModelDatabaseNative.INSTANCE) {
            DBAAuthCredentials credentials = authModel.loadCredentials(dataSourceContainer, cfg);
            try {
                Properties connProperties = new Properties();
                authModel.initAuthentication(monitor, dataSourceContainer.getDataSource(), credentials, cfg, connProperties);
                Object authPassword = connProperties.get("password");
                if (authPassword != null) {
                    userPassword = CommonUtils.toString((Object)authPassword);
                }
            }
            catch (DBException dBException) {
                // empty catch block
            }
        }
        if (CommonUtils.isEmpty(userPassword)) {
            userPassword = dataSourceContainer.getActualConnectionConfiguration().getUserPassword();
        }
        return userPassword;
    }

    private class LogReaderJob
    extends Thread {
        private final DBTTask task;
        private final SETTINGS settings;
        private final PrintStream logWriter;
        private final ProcessBuilder processBuilder;
        private final Process input;
        private final boolean isLogInputStream;
        final /* synthetic */ AbstractNativeToolHandler this$0;

        /*
         * WARNING - Possible parameter corruption
         */
        protected LogReaderJob(DBTTask task, SETTINGS settings, ProcessBuilder processBuilder, Process stream, boolean isLogInputStream) {
            this.this$0 = (AbstractNativeToolHandler)n;
            super("Log reader for " + task.getName());
            this.task = task;
            this.settings = settings;
            this.logWriter = ((AbstractNativeToolSettings)settings).getLogWriter();
            this.processBuilder = processBuilder;
            this.input = stream;
            this.isLogInputStream = isLogInputStream;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            final String lf = GeneralUtils.getDefaultLineSeparator();
            List<String> command = this.processBuilder.command();
            StringBuilder cmdString = new StringBuilder();
            for (String cmd : command) {
                if (NativeToolUtils.isSecureString(this.settings, cmd)) {
                    cmd = "******";
                }
                if (cmdString.length() > 0) {
                    cmdString.append(' ');
                }
                cmdString.append(cmd);
            }
            cmdString.append(lf);
            try {
                this.logWriter.print(cmdString);
                this.logWriter.print(NLS.bind((String)NativeToolMessages.native_tool_handler_log_task, (Object)this.task.getName(), (Object)(String.valueOf(new Date()) + lf)));
                this.logWriter.flush();
                if (this.isLogInputStream) {
                    Thread readInputThread = new Thread(this, "Reading process input stream"){
                        final /* synthetic */ LogReaderJob this$1;
                        {
                            this.this$1 = this$1;
                            super(arg0);
                        }

                        @Override
                        public void run() {
                            try {
                                this.this$1.readStream(this.this$1.input.getInputStream());
                            }
                            catch (IOException e) {
                                this.this$1.logWriter.println(e.getMessage() + lf);
                            }
                        }
                    };
                    readInputThread.start();
                    String errorMessage = this.readStream(this.input.getErrorStream());
                    if (!CommonUtils.isEmpty((String)errorMessage)) {
                        this.this$0.taskErrorMessage = errorMessage;
                    }
                    try {
                        readInputThread.join();
                    }
                    catch (InterruptedException interruptedException) {}
                } else {
                    this.readStream(this.input.getErrorStream());
                }
            }
            catch (IOException e) {
                this.logWriter.println(e.getMessage() + lf);
            }
            finally {
                this.logWriter.print(NLS.bind((String)NativeToolMessages.native_tool_handler_log_finished_task, (Object)this.task.getName(), (Object)(String.valueOf(new Date()) + lf)));
                this.logWriter.flush();
            }
        }

        private String readStream(@NotNull InputStream inputStream) throws IOException {
            StringBuilder message = new StringBuilder();
            try (InputStreamReader reader = new InputStreamReader(inputStream, GeneralUtils.getDefaultConsoleEncoding());){
                int b;
                StringBuilder buf = new StringBuilder();
                while ((b = ((Reader)reader).read()) != -1) {
                    buf.append((char)b);
                    if (b != 10) continue;
                    message.append((CharSequence)buf);
                    this.logWriter.println(buf);
                    this.logWriter.flush();
                    buf.setLength(0);
                }
            }
            return message.toString();
        }
    }

    private class NullReaderJob
    extends Thread {
        private InputStream input;

        protected NullReaderJob(AbstractNativeToolHandler abstractNativeToolHandler, DBTTask task, InputStream stream) {
            super("Task " + task.getName() + " log reader");
            this.input = stream;
        }

        @Override
        public void run() {
            try {
                int count;
                byte[] buffer = new byte[1000];
                while ((count = this.input.read(buffer)) > 0) {
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static class BinaryFileTransformerJob
    extends Thread {
        private final DBRProgressMonitor monitor;
        private final DBTTask task;
        private final OutputStream output;
        private final Path inputFile;
        private final Log log;

        public BinaryFileTransformerJob(DBRProgressMonitor monitor, DBTTask task, Path inputFile, OutputStream stream, Log log) {
            super(task.getName());
            this.monitor = monitor;
            this.task = task;
            this.output = stream;
            this.inputFile = inputFile;
            this.log = log;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try (ProgressStreamReader scriptStream = new ProgressStreamReader(this.monitor, this.task.getName(), Files.newInputStream(this.inputFile, new OpenOption[0]), Files.size(this.inputFile));){
                int readSize;
                byte[] buffer = new byte[100000];
                while (!this.monitor.isCanceled() && (readSize = scriptStream.read(buffer)) >= 0) {
                    this.output.write(buffer, 0, readSize);
                    this.output.flush();
                }
                this.output.flush();
            }
            catch (IOException e) {
                this.log.error((Object)e);
            }
            finally {
                try {
                    this.output.close();
                }
                catch (IOException e) {
                    this.log.error((Object)e);
                }
            }
        }
    }

    public static class TextFileTransformerJob
    extends Thread {
        private final DBRProgressMonitor monitor;
        private final DBTTask task;
        private final OutputStream output;
        private final Path inputFile;
        private final String inputCharset;
        private final String outputCharset;
        private final Log log;

        public TextFileTransformerJob(DBRProgressMonitor monitor, DBTTask task, Path inputFile, OutputStream stream, String inputCharset, String outputCharset, Log log) {
            super(task.getName());
            this.monitor = monitor;
            this.task = task;
            this.output = stream;
            this.inputFile = inputFile;
            this.inputCharset = inputCharset;
            this.outputCharset = outputCharset;
            this.log = log;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                try (ProgressStreamReader scriptStream = new ProgressStreamReader(this.monitor, this.task.getName(), Files.newInputStream(this.inputFile, new OpenOption[0]), Files.size(this.inputFile));){
                    String line;
                    BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)scriptStream, this.inputCharset));
                    PrintWriter writer = new PrintWriter(new OutputStreamWriter(this.output, this.outputCharset));
                    while (!this.monitor.isCanceled() && (line = reader.readLine()) != null) {
                        writer.println(line);
                        writer.flush();
                    }
                    this.output.flush();
                }
                finally {
                    IOUtils.close((Closeable)this.output);
                }
            }
            catch (IOException e) {
                this.log.error((Object)e);
            }
            finally {
                this.monitor.done();
            }
        }
    }

    public static class DumpCopierJob
    extends DumpJob {
        public DumpCopierJob(DBRProgressMonitor monitor, String name, InputStream stream, Path outFile, Log log) {
            super(name, monitor, stream, outFile, log);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void runDump() throws IOException {
            this.monitor.beginTask(this.getName(), 100);
            long totalBytesDumped = 0L;
            long prevStatusUpdateTime = 0L;
            byte[] buffer = new byte[10000];
            try {
                NumberFormat numberFormat = NumberFormat.getInstance();
                try (OutputStream output = Files.newOutputStream(this.outFile, new OpenOption[0]);){
                    int count;
                    while ((count = this.input.read(buffer)) > 0) {
                        totalBytesDumped += (long)count;
                        long currentTime = System.currentTimeMillis();
                        if (currentTime - prevStatusUpdateTime > 300L) {
                            if (!DBWorkbench.getPlatform().getApplication().isHeadlessMode()) {
                                this.monitor.subTask(numberFormat.format(totalBytesDumped) + " bytes");
                            }
                            prevStatusUpdateTime = currentTime;
                        }
                        output.write(buffer, 0, count);
                    }
                    output.flush();
                }
            }
            finally {
                this.monitor.done();
            }
        }
    }

    public static abstract class DumpJob
    extends Thread {
        protected DBRProgressMonitor monitor;
        protected InputStream input;
        protected Path outFile;
        protected Log log;

        protected DumpJob(String name, DBRProgressMonitor monitor, InputStream stream, Path outFile, Log log) {
            super(name);
            this.monitor = monitor;
            this.input = stream;
            this.outFile = outFile;
            this.log = log;
        }

        @Override
        public final void run() {
            try {
                this.runDump();
            }
            catch (IOException e) {
                this.log.error((Object)e);
            }
        }

        protected abstract void runDump() throws IOException;
    }
}

