/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.validator.rules.utils;

import com.intellij.internal.statistic.eventLog.util.StringUtil;
import com.intellij.internal.statistic.eventLog.validator.rules.beans.EventGroupContextData;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.EnumValidationRule;
import com.intellij.internal.statistic.eventLog.validator.rules.utils.ValidationRuleProducer;
import org.jetbrains.annotations.NotNull;

final class EnumRuleProducer
implements ValidationRuleProducer<EnumValidationRule> {
    private static final String ENUM_PREFIX = "enum:";
    private static final String ENUM_SEPARATOR = "|";

    EnumRuleProducer() {
    }

    @Override
    public EnumValidationRule createValidationRule(@NotNull String value, @NotNull EventGroupContextData contextData) {
        return new EnumValidationRule(StringUtil.split(value, ENUM_SEPARATOR, true, false));
    }

    @Override
    @NotNull
    public String getPrefix() {
        return ENUM_PREFIX;
    }
}

