/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.Set;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.Function;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.streams.state.VersionedRecord;
import org.apache.kafka.streams.state.VersionedRecordIterator;
import org.apache.kafka.streams.state.internals.MeteredIterator;

class MeteredMultiVersionedKeyQueryIterator<V>
implements VersionedRecordIterator<V>,
MeteredIterator {
    private final VersionedRecordIterator<byte[]> iterator;
    private final Function<VersionedRecord<byte[]>, VersionedRecord<V>> deserializeValue;
    private final Sensor sensor;
    private final Time time;
    private final long startNs;
    private final long startTimestampMs;
    private final Set<MeteredIterator> openIterators;
    private final LongAdder numOpenIterators;

    public MeteredMultiVersionedKeyQueryIterator(VersionedRecordIterator<byte[]> iterator, Sensor sensor, Time time, Function<VersionedRecord<byte[]>, VersionedRecord<V>> deserializeValue, LongAdder numOpenIterators, Set<MeteredIterator> openIterators) {
        this.iterator = iterator;
        this.deserializeValue = deserializeValue;
        this.numOpenIterators = numOpenIterators;
        this.openIterators = openIterators;
        this.sensor = sensor;
        this.time = time;
        this.startNs = time.nanoseconds();
        this.startTimestampMs = time.milliseconds();
        numOpenIterators.increment();
        openIterators.add(this);
    }

    @Override
    public long startTimestamp() {
        return this.startTimestampMs;
    }

    @Override
    public void close() {
        try {
            this.iterator.close();
        }
        finally {
            this.sensor.record((double)(this.time.nanoseconds() - this.startNs));
            this.numOpenIterators.decrement();
            this.openIterators.remove(this);
        }
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public VersionedRecord<V> next() {
        return this.deserializeValue.apply((VersionedRecord)this.iterator.next());
    }
}

