/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group.streams;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.kafka.common.message.StreamsGroupHeartbeatRequestData;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.coordinator.common.runtime.CoordinatorRecord;
import org.apache.kafka.coordinator.group.generated.StreamsGroupCurrentMemberAssignmentKey;
import org.apache.kafka.coordinator.group.generated.StreamsGroupCurrentMemberAssignmentValue;
import org.apache.kafka.coordinator.group.generated.StreamsGroupMemberMetadataKey;
import org.apache.kafka.coordinator.group.generated.StreamsGroupMemberMetadataValue;
import org.apache.kafka.coordinator.group.generated.StreamsGroupMetadataKey;
import org.apache.kafka.coordinator.group.generated.StreamsGroupMetadataValue;
import org.apache.kafka.coordinator.group.generated.StreamsGroupTargetAssignmentMemberKey;
import org.apache.kafka.coordinator.group.generated.StreamsGroupTargetAssignmentMemberValue;
import org.apache.kafka.coordinator.group.generated.StreamsGroupTargetAssignmentMetadataKey;
import org.apache.kafka.coordinator.group.generated.StreamsGroupTargetAssignmentMetadataValue;
import org.apache.kafka.coordinator.group.generated.StreamsGroupTopologyKey;
import org.apache.kafka.coordinator.group.generated.StreamsGroupTopologyValue;
import org.apache.kafka.coordinator.group.streams.StreamsGroupMember;
import org.apache.kafka.coordinator.group.streams.TasksTuple;
import org.apache.kafka.server.common.ApiMessageAndVersion;

public class StreamsCoordinatorRecordHelpers {
    public static CoordinatorRecord newStreamsGroupMemberRecord(String groupId, StreamsGroupMember member) {
        Objects.requireNonNull(groupId, "groupId should not be null here");
        Objects.requireNonNull(member, "member should not be null here");
        return CoordinatorRecord.record((ApiMessage)new StreamsGroupMemberMetadataKey().setGroupId(groupId).setMemberId(member.memberId()), (ApiMessageAndVersion)new ApiMessageAndVersion((ApiMessage)new StreamsGroupMemberMetadataValue().setRackId(member.rackId().orElse(null)).setInstanceId(member.instanceId().orElse(null)).setClientId(member.clientId()).setClientHost(member.clientHost()).setRebalanceTimeoutMs(member.rebalanceTimeoutMs()).setTopologyEpoch(member.topologyEpoch()).setProcessId(member.processId()).setUserEndpoint(member.userEndpoint().orElse(null)).setClientTags(member.clientTags().entrySet().stream().map(e -> new StreamsGroupMemberMetadataValue.KeyValue().setKey((String)e.getKey()).setValue((String)e.getValue())).sorted(Comparator.comparing(StreamsGroupMemberMetadataValue.KeyValue::key)).toList()), 0));
    }

    public static CoordinatorRecord newStreamsGroupMemberTombstoneRecord(String groupId, String memberId) {
        Objects.requireNonNull(groupId, "groupId should not be null here");
        Objects.requireNonNull(memberId, "memberId should not be null here");
        return CoordinatorRecord.tombstone((ApiMessage)new StreamsGroupMemberMetadataKey().setGroupId(groupId).setMemberId(memberId));
    }

    public static CoordinatorRecord newStreamsGroupMetadataRecord(String groupId, int newGroupEpoch, long metadataHash, int validatedTopologyEpoch, Map<String, String> assignmentConfigs) {
        Objects.requireNonNull(groupId, "groupId should not be null here");
        Objects.requireNonNull(assignmentConfigs, "assignmentConfigs should not be null here");
        List<StreamsGroupMetadataValue.LastAssignmentConfig> assignmentConfigList = assignmentConfigs.entrySet().stream().map(entry -> new StreamsGroupMetadataValue.LastAssignmentConfig().setKey((String)entry.getKey()).setValue((String)entry.getValue())).toList();
        return CoordinatorRecord.record((ApiMessage)new StreamsGroupMetadataKey().setGroupId(groupId), (ApiMessageAndVersion)new ApiMessageAndVersion((ApiMessage)new StreamsGroupMetadataValue().setEpoch(newGroupEpoch).setMetadataHash(metadataHash).setValidatedTopologyEpoch(validatedTopologyEpoch).setLastAssignmentConfigs(assignmentConfigList), 0));
    }

    public static CoordinatorRecord newStreamsGroupEpochTombstoneRecord(String groupId) {
        Objects.requireNonNull(groupId, "groupId should not be null here");
        return CoordinatorRecord.tombstone((ApiMessage)new StreamsGroupMetadataKey().setGroupId(groupId));
    }

    public static CoordinatorRecord newStreamsGroupTargetAssignmentRecord(String groupId, String memberId, TasksTuple assignment) {
        Objects.requireNonNull(groupId, "groupId should not be null here");
        Objects.requireNonNull(memberId, "memberId should not be null here");
        Objects.requireNonNull(assignment, "assignment should not be null here");
        ArrayList<StreamsGroupTargetAssignmentMemberValue.TaskIds> activeTaskIds = new ArrayList<StreamsGroupTargetAssignmentMemberValue.TaskIds>(assignment.activeTasks().size());
        for (Map.Entry<String, Set<Integer>> entry : assignment.activeTasks().entrySet()) {
            activeTaskIds.add(new StreamsGroupTargetAssignmentMemberValue.TaskIds().setSubtopologyId(entry.getKey()).setPartitions(entry.getValue().stream().sorted().toList()));
        }
        activeTaskIds.sort(Comparator.comparing(StreamsGroupTargetAssignmentMemberValue.TaskIds::subtopologyId));
        ArrayList<StreamsGroupTargetAssignmentMemberValue.TaskIds> standbyTaskIds = new ArrayList<StreamsGroupTargetAssignmentMemberValue.TaskIds>(assignment.standbyTasks().size());
        for (Map.Entry<String, Set<Integer>> entry : assignment.standbyTasks().entrySet()) {
            standbyTaskIds.add(new StreamsGroupTargetAssignmentMemberValue.TaskIds().setSubtopologyId(entry.getKey()).setPartitions(entry.getValue().stream().sorted().toList()));
        }
        standbyTaskIds.sort(Comparator.comparing(StreamsGroupTargetAssignmentMemberValue.TaskIds::subtopologyId));
        ArrayList<StreamsGroupTargetAssignmentMemberValue.TaskIds> arrayList = new ArrayList<StreamsGroupTargetAssignmentMemberValue.TaskIds>(assignment.warmupTasks().size());
        for (Map.Entry<String, Set<Integer>> entry : assignment.warmupTasks().entrySet()) {
            arrayList.add(new StreamsGroupTargetAssignmentMemberValue.TaskIds().setSubtopologyId(entry.getKey()).setPartitions(entry.getValue().stream().sorted().toList()));
        }
        arrayList.sort(Comparator.comparing(StreamsGroupTargetAssignmentMemberValue.TaskIds::subtopologyId));
        return CoordinatorRecord.record((ApiMessage)new StreamsGroupTargetAssignmentMemberKey().setGroupId(groupId).setMemberId(memberId), (ApiMessageAndVersion)new ApiMessageAndVersion((ApiMessage)new StreamsGroupTargetAssignmentMemberValue().setActiveTasks(activeTaskIds).setStandbyTasks(standbyTaskIds).setWarmupTasks(arrayList), 0));
    }

    public static CoordinatorRecord newStreamsGroupTargetAssignmentTombstoneRecord(String groupId, String memberId) {
        Objects.requireNonNull(groupId, "groupId should not be null here");
        Objects.requireNonNull(memberId, "memberId should not be null here");
        return CoordinatorRecord.tombstone((ApiMessage)new StreamsGroupTargetAssignmentMemberKey().setGroupId(groupId).setMemberId(memberId));
    }

    public static CoordinatorRecord newStreamsGroupTargetAssignmentEpochRecord(String groupId, int assignmentEpoch) {
        Objects.requireNonNull(groupId, "groupId should not be null here");
        return CoordinatorRecord.record((ApiMessage)new StreamsGroupTargetAssignmentMetadataKey().setGroupId(groupId), (ApiMessageAndVersion)new ApiMessageAndVersion((ApiMessage)new StreamsGroupTargetAssignmentMetadataValue().setAssignmentEpoch(assignmentEpoch), 0));
    }

    public static CoordinatorRecord newStreamsGroupTargetAssignmentEpochTombstoneRecord(String groupId) {
        Objects.requireNonNull(groupId, "groupId should not be null here");
        return CoordinatorRecord.tombstone((ApiMessage)new StreamsGroupTargetAssignmentMetadataKey().setGroupId(groupId));
    }

    public static CoordinatorRecord newStreamsGroupCurrentAssignmentRecord(String groupId, StreamsGroupMember member) {
        Objects.requireNonNull(groupId, "groupId should not be null here");
        Objects.requireNonNull(member, "member should not be null here");
        return CoordinatorRecord.record((ApiMessage)new StreamsGroupCurrentMemberAssignmentKey().setGroupId(groupId).setMemberId(member.memberId()), (ApiMessageAndVersion)new ApiMessageAndVersion((ApiMessage)new StreamsGroupCurrentMemberAssignmentValue().setMemberEpoch(member.memberEpoch()).setPreviousMemberEpoch(member.previousMemberEpoch()).setState(member.state().value()).setActiveTasks(StreamsCoordinatorRecordHelpers.toTaskIdsWithEpochs(member.assignedTasks().activeTasksWithEpochs())).setStandbyTasks(StreamsCoordinatorRecordHelpers.toTaskIds(member.assignedTasks().standbyTasks())).setWarmupTasks(StreamsCoordinatorRecordHelpers.toTaskIds(member.assignedTasks().warmupTasks())).setActiveTasksPendingRevocation(StreamsCoordinatorRecordHelpers.toTaskIdsWithEpochs(member.tasksPendingRevocation().activeTasksWithEpochs())).setStandbyTasksPendingRevocation(StreamsCoordinatorRecordHelpers.toTaskIds(member.tasksPendingRevocation().standbyTasks())).setWarmupTasksPendingRevocation(StreamsCoordinatorRecordHelpers.toTaskIds(member.tasksPendingRevocation().warmupTasks())), 0));
    }

    public static CoordinatorRecord newStreamsGroupCurrentAssignmentTombstoneRecord(String groupId, String memberId) {
        Objects.requireNonNull(groupId, "groupId should not be null here");
        Objects.requireNonNull(memberId, "memberId should not be null here");
        return CoordinatorRecord.tombstone((ApiMessage)new StreamsGroupCurrentMemberAssignmentKey().setGroupId(groupId).setMemberId(memberId));
    }

    private static List<StreamsGroupCurrentMemberAssignmentValue.TaskIds> toTaskIds(Map<String, Set<Integer>> tasks) {
        ArrayList<StreamsGroupCurrentMemberAssignmentValue.TaskIds> taskIds = new ArrayList<StreamsGroupCurrentMemberAssignmentValue.TaskIds>(tasks.size());
        tasks.forEach((subtopologyId, partitions) -> taskIds.add(new StreamsGroupCurrentMemberAssignmentValue.TaskIds().setSubtopologyId((String)subtopologyId).setPartitions(partitions.stream().sorted().toList())));
        taskIds.sort(Comparator.comparing(StreamsGroupCurrentMemberAssignmentValue.TaskIds::subtopologyId));
        return taskIds;
    }

    private static List<StreamsGroupCurrentMemberAssignmentValue.TaskIds> toTaskIdsWithEpochs(Map<String, Map<Integer, Integer>> tasksWithEpochs) {
        ArrayList<StreamsGroupCurrentMemberAssignmentValue.TaskIds> taskIds = new ArrayList<StreamsGroupCurrentMemberAssignmentValue.TaskIds>(tasksWithEpochs.size());
        tasksWithEpochs.forEach((subtopologyId, partitionEpochMap) -> {
            List<Map.Entry> sortedEntries = partitionEpochMap.entrySet().stream().sorted(Comparator.comparingInt(Map.Entry::getKey)).toList();
            ArrayList<Integer> partitions = new ArrayList<Integer>(sortedEntries.size());
            ArrayList<Integer> epochs = new ArrayList<Integer>(sortedEntries.size());
            for (Map.Entry entry : sortedEntries) {
                partitions.add((Integer)entry.getKey());
                epochs.add((Integer)entry.getValue());
            }
            taskIds.add(new StreamsGroupCurrentMemberAssignmentValue.TaskIds().setSubtopologyId((String)subtopologyId).setPartitions(partitions).setAssignmentEpochs(epochs));
        });
        taskIds.sort(Comparator.comparing(StreamsGroupCurrentMemberAssignmentValue.TaskIds::subtopologyId));
        return taskIds;
    }

    public static CoordinatorRecord newStreamsGroupTopologyRecord(String groupId, StreamsGroupHeartbeatRequestData.Topology topology) {
        Objects.requireNonNull(groupId, "groupId should not be null here");
        Objects.requireNonNull(topology, "topology should not be null here");
        return StreamsCoordinatorRecordHelpers.newStreamsGroupTopologyRecord(groupId, StreamsCoordinatorRecordHelpers.convertToStreamsGroupTopologyRecord(topology));
    }

    public static CoordinatorRecord newStreamsGroupTopologyRecord(String groupId, StreamsGroupTopologyValue value) {
        Objects.requireNonNull(groupId, "groupId should not be null here");
        Objects.requireNonNull(value, "value should not be null here");
        return CoordinatorRecord.record((ApiMessage)new StreamsGroupTopologyKey().setGroupId(groupId), (ApiMessageAndVersion)new ApiMessageAndVersion((ApiMessage)value, 0));
    }

    public static StreamsGroupTopologyValue convertToStreamsGroupTopologyRecord(StreamsGroupHeartbeatRequestData.Topology topology) {
        Objects.requireNonNull(topology, "topology should not be null here");
        StreamsGroupTopologyValue value = new StreamsGroupTopologyValue();
        value.setEpoch(topology.epoch());
        topology.subtopologies().forEach(subtopology -> {
            List<StreamsGroupTopologyValue.TopicInfo> repartitionSourceTopics = subtopology.repartitionSourceTopics().stream().map(StreamsCoordinatorRecordHelpers::convertToTopicInfo).toList();
            List<StreamsGroupTopologyValue.TopicInfo> stateChangelogTopics = subtopology.stateChangelogTopics().stream().map(StreamsCoordinatorRecordHelpers::convertToTopicInfo).toList();
            List<StreamsGroupTopologyValue.CopartitionGroup> copartitionGroups = subtopology.copartitionGroups().stream().map(copartitionGroup -> new StreamsGroupTopologyValue.CopartitionGroup().setSourceTopics(copartitionGroup.sourceTopics()).setSourceTopicRegex(copartitionGroup.sourceTopicRegex()).setRepartitionSourceTopics(copartitionGroup.repartitionSourceTopics())).toList();
            value.subtopologies().add(new StreamsGroupTopologyValue.Subtopology().setSubtopologyId(subtopology.subtopologyId()).setSourceTopics(subtopology.sourceTopics()).setSourceTopicRegex(subtopology.sourceTopicRegex()).setRepartitionSinkTopics(subtopology.repartitionSinkTopics()).setRepartitionSourceTopics(repartitionSourceTopics).setStateChangelogTopics(stateChangelogTopics).setCopartitionGroups(copartitionGroups));
        });
        return value;
    }

    private static StreamsGroupTopologyValue.TopicInfo convertToTopicInfo(StreamsGroupHeartbeatRequestData.TopicInfo topicInfo) {
        List<StreamsGroupTopologyValue.TopicConfig> topicConfigs = topicInfo.topicConfigs() != null ? topicInfo.topicConfigs().stream().map(config -> new StreamsGroupTopologyValue.TopicConfig().setKey(config.key()).setValue(config.value())).toList() : null;
        return new StreamsGroupTopologyValue.TopicInfo().setName(topicInfo.name()).setTopicConfigs(topicConfigs).setPartitions(topicInfo.partitions()).setReplicationFactor(topicInfo.replicationFactor());
    }

    public static CoordinatorRecord newStreamsGroupTopologyRecordTombstone(String groupId) {
        Objects.requireNonNull(groupId, "groupId should not be null here");
        return CoordinatorRecord.tombstone((ApiMessage)new StreamsGroupTopologyKey().setGroupId(groupId));
    }
}

