/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group.generated;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class StreamsGroupMetadataValue
implements ApiMessage {
    int epoch;
    long metadataHash;
    int validatedTopologyEpoch;
    List<LastAssignmentConfig> lastAssignmentConfigs;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field[]{new Field("epoch", (Type)Type.INT32, "The group epoch."), new Field("metadata_hash", (Type)Type.INT64, "The hash of all topics in the group."), Field.TaggedFieldsSection.of((Object[])new Object[]{0, new Field("validated_topology_epoch", (Type)Type.INT32, "The topology epoch whose topics are validated to be present in a valid configuration in the metadata."), 1, new Field("last_assignment_configs", (Type)CompactArrayOf.nullable((Type)LastAssignmentConfig.SCHEMA_0), "The last used configuration parameters as key-value pairs.")})});
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 0;

    public StreamsGroupMetadataValue(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public StreamsGroupMetadataValue() {
        this.epoch = 0;
        this.metadataHash = 0L;
        this.validatedTopologyEpoch = -1;
        this.lastAssignmentConfigs = new ArrayList<LastAssignmentConfig>(0);
    }

    public short apiKey() {
        return 17;
    }

    public short lowestSupportedVersion() {
        return 0;
    }

    public short highestSupportedVersion() {
        return 0;
    }

    public final void read(Readable _readable, short _version) {
        this.epoch = _readable.readInt();
        this.metadataHash = _readable.readLong();
        this.validatedTopologyEpoch = -1;
        this.lastAssignmentConfigs = new ArrayList<LastAssignmentConfig>(0);
        this._unknownTaggedFields = null;
        int _numTaggedFields = _readable.readUnsignedVarint();
        block4: for (int _i = 0; _i < _numTaggedFields; ++_i) {
            int _tag = _readable.readUnsignedVarint();
            int _size = _readable.readUnsignedVarint();
            switch (_tag) {
                case 0: {
                    this.validatedTopologyEpoch = _readable.readInt();
                    continue block4;
                }
                case 1: {
                    int arrayLength = _readable.readUnsignedVarint() - 1;
                    if (arrayLength < 0) {
                        this.lastAssignmentConfigs = null;
                        continue block4;
                    }
                    if (arrayLength > _readable.remaining()) {
                        throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
                    }
                    ArrayList<LastAssignmentConfig> newCollection = new ArrayList<LastAssignmentConfig>(arrayLength);
                    for (int i = 0; i < arrayLength; ++i) {
                        newCollection.add(new LastAssignmentConfig(_readable, _version));
                    }
                    this.lastAssignmentConfigs = newCollection;
                    continue block4;
                }
                default: {
                    this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                }
            }
        }
    }

    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        _writable.writeInt(this.epoch);
        _writable.writeLong(this.metadataHash);
        if (this.validatedTopologyEpoch != -1) {
            ++_numTaggedFields;
        }
        if (this.lastAssignmentConfigs == null || !this.lastAssignmentConfigs.isEmpty()) {
            ++_numTaggedFields;
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
        if (this.validatedTopologyEpoch != -1) {
            _writable.writeUnsignedVarint(0);
            _writable.writeUnsignedVarint(4);
            _writable.writeInt(this.validatedTopologyEpoch);
        }
        if (this.lastAssignmentConfigs == null) {
            _writable.writeUnsignedVarint(1);
            _writable.writeUnsignedVarint(1);
            _writable.writeUnsignedVarint(0);
        } else if (!this.lastAssignmentConfigs.isEmpty()) {
            _writable.writeUnsignedVarint(1);
            _writable.writeUnsignedVarint(_cache.getArraySizeInBytes(this.lastAssignmentConfigs).intValue());
            _writable.writeUnsignedVarint(this.lastAssignmentConfigs.size() + 1);
            for (LastAssignmentConfig lastAssignmentConfigsElement : this.lastAssignmentConfigs) {
                lastAssignmentConfigsElement.write(_writable, _cache, _version);
            }
        }
        _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
    }

    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        _size.addBytes(4);
        _size.addBytes(8);
        if (this.validatedTopologyEpoch != -1) {
            ++_numTaggedFields;
            _size.addBytes(1);
            _size.addBytes(1);
            _size.addBytes(4);
        }
        if (this.lastAssignmentConfigs == null) {
            ++_numTaggedFields;
            _size.addBytes(1);
            _size.addBytes(1);
            _size.addBytes(1);
        } else if (!this.lastAssignmentConfigs.isEmpty()) {
            ++_numTaggedFields;
            _size.addBytes(1);
            int _sizeBeforeArray = _size.totalSize();
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)(this.lastAssignmentConfigs.size() + 1)));
            for (LastAssignmentConfig lastAssignmentConfigsElement : this.lastAssignmentConfigs) {
                lastAssignmentConfigsElement.addSize(_size, _cache, _version);
            }
            int _arraySize = _size.totalSize() - _sizeBeforeArray;
            _cache.setArraySizeInBytes(this.lastAssignmentConfigs, Integer.valueOf(_arraySize));
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_arraySize));
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.size()));
                _size.addBytes(_field.size());
            }
        }
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof StreamsGroupMetadataValue)) {
            return false;
        }
        StreamsGroupMetadataValue other = (StreamsGroupMetadataValue)obj;
        if (this.epoch != other.epoch) {
            return false;
        }
        if (this.metadataHash != other.metadataHash) {
            return false;
        }
        if (this.validatedTopologyEpoch != other.validatedTopologyEpoch) {
            return false;
        }
        if (this.lastAssignmentConfigs == null ? other.lastAssignmentConfigs != null : !this.lastAssignmentConfigs.equals(other.lastAssignmentConfigs)) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.epoch;
        hashCode = 31 * hashCode + ((int)(this.metadataHash >> 32) ^ (int)this.metadataHash);
        hashCode = 31 * hashCode + this.validatedTopologyEpoch;
        hashCode = 31 * hashCode + (this.lastAssignmentConfigs == null ? 0 : this.lastAssignmentConfigs.hashCode());
        return hashCode;
    }

    public StreamsGroupMetadataValue duplicate() {
        StreamsGroupMetadataValue _duplicate = new StreamsGroupMetadataValue();
        _duplicate.epoch = this.epoch;
        _duplicate.metadataHash = this.metadataHash;
        _duplicate.validatedTopologyEpoch = this.validatedTopologyEpoch;
        if (this.lastAssignmentConfigs == null) {
            _duplicate.lastAssignmentConfigs = null;
        } else {
            ArrayList<LastAssignmentConfig> newLastAssignmentConfigs = new ArrayList<LastAssignmentConfig>(this.lastAssignmentConfigs.size());
            for (LastAssignmentConfig _element : this.lastAssignmentConfigs) {
                newLastAssignmentConfigs.add(_element.duplicate());
            }
            _duplicate.lastAssignmentConfigs = newLastAssignmentConfigs;
        }
        return _duplicate;
    }

    public String toString() {
        return "StreamsGroupMetadataValue(epoch=" + this.epoch + ", metadataHash=" + this.metadataHash + ", validatedTopologyEpoch=" + this.validatedTopologyEpoch + ", lastAssignmentConfigs=" + (this.lastAssignmentConfigs == null ? "null" : MessageUtil.deepToString(this.lastAssignmentConfigs.iterator())) + ")";
    }

    public int epoch() {
        return this.epoch;
    }

    public long metadataHash() {
        return this.metadataHash;
    }

    public int validatedTopologyEpoch() {
        return this.validatedTopologyEpoch;
    }

    public List<LastAssignmentConfig> lastAssignmentConfigs() {
        return this.lastAssignmentConfigs;
    }

    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public StreamsGroupMetadataValue setEpoch(int v) {
        this.epoch = v;
        return this;
    }

    public StreamsGroupMetadataValue setMetadataHash(long v) {
        this.metadataHash = v;
        return this;
    }

    public StreamsGroupMetadataValue setValidatedTopologyEpoch(int v) {
        this.validatedTopologyEpoch = v;
        return this;
    }

    public StreamsGroupMetadataValue setLastAssignmentConfigs(List<LastAssignmentConfig> v) {
        this.lastAssignmentConfigs = v;
        return this;
    }

    public static class LastAssignmentConfig
    implements Message {
        String key;
        String value;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field[]{new Field("key", (Type)Type.COMPACT_STRING, "Key of the config."), new Field("value", (Type)Type.COMPACT_STRING, "Value of the config."), Field.TaggedFieldsSection.of((Object[])new Object[0])});
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;

        public LastAssignmentConfig(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public LastAssignmentConfig() {
            this.key = "";
            this.value = "";
        }

        public short lowestSupportedVersion() {
            return 0;
        }

        public short highestSupportedVersion() {
            return Short.MAX_VALUE;
        }

        public final void read(Readable _readable, short _version) {
            int length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field key was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field key had invalid length " + length);
            }
            this.key = _readable.readString(length);
            length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field value was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field value had invalid length " + length);
            }
            this.value = _readable.readString(length);
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            byte[] _stringBytes = _cache.getSerializedValue((Object)this.key);
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
            _writable.writeByteArray(_stringBytes);
            _stringBytes = _cache.getSerializedValue((Object)this.value);
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
            _writable.writeByteArray(_stringBytes);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            byte[] _stringBytes = this.key.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'key' field is too long to be serialized");
            }
            _cache.cacheSerializedValue((Object)this.key, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1)));
            _stringBytes = this.value.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'value' field is too long to be serialized");
            }
            _cache.cacheSerializedValue((Object)this.value, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1)));
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof LastAssignmentConfig)) {
                return false;
            }
            LastAssignmentConfig other = (LastAssignmentConfig)obj;
            if (this.key == null ? other.key != null : !this.key.equals(other.key)) {
                return false;
            }
            if (this.value == null ? other.value != null : !this.value.equals(other.value)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.key == null ? 0 : this.key.hashCode());
            hashCode = 31 * hashCode + (this.value == null ? 0 : this.value.hashCode());
            return hashCode;
        }

        public LastAssignmentConfig duplicate() {
            LastAssignmentConfig _duplicate = new LastAssignmentConfig();
            _duplicate.key = this.key;
            _duplicate.value = this.value;
            return _duplicate;
        }

        public String toString() {
            return "LastAssignmentConfig(key=" + (String)(this.key == null ? "null" : "'" + this.key.toString() + "'") + ", value=" + (String)(this.value == null ? "null" : "'" + this.value.toString() + "'") + ")";
        }

        public String key() {
            return this.key;
        }

        public String value() {
            return this.value;
        }

        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public LastAssignmentConfig setKey(String v) {
            this.key = v;
            return this;
        }

        public LastAssignmentConfig setValue(String v) {
            this.value = v;
            return this;
        }
    }
}

